' THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED 
' OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR 
' FITNESS FOR A PARTICULAR PURPOSE.
'
' Copyright (c) Microsoft Corporation. All rights reserved
'
' This script is not supported under any Microsoft standard support program or service. 
' The script is provided AS IS without warranty of any kind. Microsoft further disclaims all
' implied warranties including, without limitation, any implied warranties of merchantability
' or of fitness for a particular purpose. The entire risk arising out of the use or performance
' of the scripts and documentation remains with you. In no event shall Microsoft, its authors,
' or anyone else involved in the creation, production, or delivery of the script be liable for 
' any damages whatsoever (including, without limitation, damages for loss of business profits, 
' business interruption, loss of business information, or other pecuniary loss) arising out of 
' the use of or inability to use the script or documentation, even if Microsoft has been advised 
' of the possibility of such damages.

Option Explicit

' --------------------------------------------------------------------------------------------------------
Const cMaxSubClassExaminationDepth = 1
Const cSMS = False
Const cSMSTest = True
Const cSilent = False
Const cNoEcho = False
Const cForce = False
Const cRunOnce = False
Const cEventLog = False
Const cEventLogErrors = False
Const cLogWMIState = False
Const cErrorPopup = False
Const cCorrelateClassAndProvider = False
Const cRequestAllInstances = 1
Const cShowMOFerrors = False
Const cShowHighPrivProviders = False
Const cWriteInRepository = False
Const cWriteInExistingNS = False
Const cCheckConsistency = False
Const cWriteInRepositoryNS = "Root"
Const cBaseNS = "Root"
Const cWriteInRepositoryClass = "WMIDiagTestClass"
Const cStrict = False
Const cOldestWMIDIAGLogHistory = 0
Const cOldestEVENTLogHistory = 20
Const cNoWinZIP = False
Const cDebug = False
Const cStatistics = False
Const cShowLoadedProviders = False
Const cQueryWMIDiagData = False

Const cSMTPTo = "WMIDiag@microsoft.com"
Const cSMTPFrom = ""
Const cSMTPServer = ""
Const cSMTPPort = 25
Const cSMTPAuthenticate = 2   ' 0=Anonymous, 1=Basic, 2=NTLM
Const cSMTPUserName = ""
Const cSMTPPassword = ""
Const cSMTPSSL = False
Const cSMTPTEST = False
Const cSMTPWMIInvalidState = False

Const cMaxCSVFields = 93
Const cAsyncMaxInstances = 1000
Const cMaxNamespaces = 10
Const cMaxInstances = 250

Const cPresence = -2          
Const cCritical = -1          
Const cWarning = 0            
Const cIWarning = 1           

Const cSecurityException = 1
Const cSecuritySystem = 2
Const cSecurityApplication = 3
Const cSecurityDefaulted = 4

Const cRegistryInfo = 1 
Const cRegistryError = 2 
Const cRegistryWarning = 3 
Const cRegistryWarningWhenPresent = 4 

Const cStatic = &h01
Const cDynamic = &h02
Const cStaticAndDynamic = &h03

Const cWMIDiagVersion = "2.1"
Const cMonth = "July 2007"

Const cLoggingLevel0 = 0     ' Activity
Const cLoggingLevel1 = 1     ' Error
Const cLoggingLevel2 = 2     ' Warning
Const cLoggingLevel3 = 3     ' Activity verbose level 1
Const cLoggingLevel4 = 4     ' Activity verbose level 2
Const cLoggingDisabled = 64  ' No logging
Const cLoggingDebug = 128    ' Debug verbose logging for some critical code sections

Const wbemImpersonationLevelImpersonate = 3
Const wbemAuthenticationLevelDefault = 0

Const wbemQueryFlagDeep = 0
Const wbemQueryFlagShallow = 1
Const wbemFlagReturnImmediately = 16
Const wbemFlagSendStatus = 128

Const wbemFlagUseAmendedQualifiers = 131072

Const wbemCimtypeObject = 13
Const wbemCimtypeBoolean = 11

Const wbemChangeFlagCreateOrUpdate = 0
Const wbemFlagReturnWhenComplete = 0

Const wbemCimtypeString = 8
Const wbemCimtypeUint32 = 19

Const WBEM_E_FAILED = &h80041001
Const WBEM_E_NOT_FOUND = &h80041002
Const WBEM_E_NOT_SUPPORTED = &h8004100C 
Const WBEM_E_PROVIDER_NOT_CAPABLE = &h80041024
Const WBEM_E_CALL_CANCELLED = &h80041032 
Const WBEM_E_PROVIDER_LOAD_FAILURE = &h80041013
Const cSleepDelay = 500
Const cPopupTimeout = 40

Const cNetFWProfileDomain = 0
Const cNetFWProfileStandard = 1

Const cForReading = 1
Const cForWriting = 2
Const cForAppending = 8

Const cTristateUseDefault = -2
Const cTristateTrue = -1
Const cTristateFalse = 0

Const cOKClick = 1
Const cCancelClick = 2
Const cAbortClick = 3
Const cRetryClick = 4
Const cIgnoreClick = 5
Const cYesClick = 6
Const cNoClick = 7

Const cClientOnly = 1
Const cServerOnly = 2
Const cClientAndServer = 3

Const cWindowsUnknown = 0
Const cWindows2000RTM = 1
Const cWindows2000SP1 = 2
Const cWindows2000SP2 = 4
Const cWindows2000SP3 = 8
Const cWindows2000SP4 = 16
Const cWindowsXPRTM = 32
Const cWindowsXPSP1 = 64      
Const cWindowsXPSP164 = 128     
Const cWindowsXPSP2 = 256
Const cWindowsXPSP264 = 257
Const cWindowsXPSP3 = 258
Const cWindows2003RTM = 512     
Const cWindows2003RTM64 = 1024  
Const cWindows2003SP1 = 2048
Const cWindows2003SP164 = 4096  
Const cWindows2003SP2 = 8192
Const cWindows2003SP264 = 16384
Const cWindowsVistaRTM = 40000
Const cWindowsVistaRTM64 = 40001
Const cWindowsVistaSP1 = 40002
Const cWindowsVistaSP164 = 40003
Const cWindowsVistaSP2 = 40004
Const cWindowsVistaSP264 = 40005
Const cWindows2008SP1 = 41000
Const cWindows2008SP164 = 41001
Const cWindows2008SP2 = 41002
Const cWindows2008SP264 = 41004
Const cWindows7RTM = 50000
Const cWindows7RTM64 = 50001
Const cWindows7SP1 = 50002
Const cWindows7SP164 = 50003
Const cWindows2008R2RTM64 = 51000
Const cWindows2008R2SP164 = 51002


Const cWindowsAnyVersion = 1048575

Const cOSversion = 0
Const cPlatform = 1
Const cWMINamespace = 2
Const cWMIClassname = 3
Const cWMIProviderName = 4
Const cWMIProviderDisplayName = 5
Const cWMIProviderModel = 6
Const cWMIprovidertype = 7
Const cWMIProviderCLSID = 8
Const cWMIProviderHostingModel = 9
Const cWMIProviderBinary = 10
Const cWMIProviderMOF = 11
Const cWMIProviderAllData = 12

Const cMissingWMIInfo = "WMI information not available (This could be the case for an external application or a third party WMI provider)"

' -------------------------------------------------------------------------------------------------
Const cFileSD = 1
Const cShareSD = 2
Const cRegistrySD = 3
Const cWMINameSpaceSD = 4
Const cDComSDAccess = 5
Const cDComSDLaunch = 6

' -------------------------------------------------------------------------------------------------
' Security Descriptor Control Flags definition  (SECURITY_DESCRIPTOR_CONTROL)
Const SE_OWNER_DEFAULTED        		= &h0001
Const SE_GROUP_DEFAULTED        		= &h0002
Const SE_DACL_PRESENT           		= &h0004
Const SE_DACL_DEFAULTED         		= &h0008
Const SE_SACL_PRESENT           		= &h0010
Const SE_SACL_DEFAULTED         		= &h0020
Const SE_DACL_AUTO_INHERIT_REQ 			= &h0100
Const SE_SACL_AUTO_INHERIT_REQ  		= &h0200
Const SE_DACL_AUTO_INHERITED    		= &h0400
Const SE_SACL_AUTO_INHERITED    		= &h0800
Const SE_DACL_PROTECTED         		= &h1000
Const SE_SACL_PROTECTED         		= &h2000
Const SE_SELF_RELATIVE          		= 32768

' -------------------------------------------------------------------------------------------------
' ACEType definition (ADS_ACETYPE_ENUM)
Const ACCESS_ALLOWED_ACE_TYPE   		= &H0
Const ACCESS_DENIED_ACE_TYPE    		= &H1
Const SYSTEM_AUDIT_ACE_TYPE     		= &H2
Const SYSTEM_ALARM_ACE_TYPE     		= &H3

' -------------------------------------------------------------------------------------------------
' AceFlag definition (same values as ADS_ACEFLAG_ENUM)
Const OBJECT_INHERIT_ACE                	= &h01
Const CONTAINER_INHERIT_ACE             	= &h02
Const NO_PROPAGATE_INHERIT_ACE          	= &h04
Const INHERIT_ONLY_ACE                  	= &h08
Const INHERITED_ACE                     	= &h10
Const VALID_INHERIT_FLAG                 	= &h1F
Const SUCCESSFUL_ACCESS_ACE_FLAG        	= &h40
Const FAILED_ACCESS_ACE_FLAG            	= &h80

' -------------------------------------------------------------------------------------------------
' File System Rights definition
Const FILE_GENERIC_READ         		= &H120089
Const FILE_GENERIC_WRITE        		= &H100116
Const FILE_GENERIC_EXECUTE      		= &h1200A9

Const FILE_DELETE                    		= &H010000
Const FILE_READ_CONTROL              		= &H020000
Const FILE_WRITE_DAC                 		= &H040000
Const FILE_WRITE_OWNER               		= &H080000
Const FILE_SYNCHRONIZE               		= &H100000
Const FILE_READ_DATA            		= &H000001
Const FOLDER_LIST_DIRECTORY       		= &H000001
Const FILE_WRITE_DATA           		= &H000002
Const FOLDER_ADD_FILE             		= &H000002
Const FILE_APPEND_DATA          		= &H000004
Const FOLDER_ADD_SUBDIRECTORY     		= &H000004
Const FILE_READ_EA              		= &H000008
Const FILE_WRITE_EA             		= &H000010
Const FILE_EXECUTE              		= &H000020
Const FOLDER_TRAVERSE             		= &H000020
Const FILE_DELETE_CHILD         		= &H000040
Const FILE_READ_ATTRIBUTES      		= &H000080
Const FILE_WRITE_ATTRIBUTES     		= &H000100
Const FILE_ALL_ACCESS           		= &H1F01FF

' -------------------------------------------------------------------------------------------------
' Share Rights definition
Const FILE_SHARE_FULL_ACCESS                    = &h0C0040    
Const FILE_SHARE_CHANGE_ACCESS                  = &h010116    
Const FILE_SHARE_READ_ACCESS                    = &h1200A9    

' -------------------------------------------------------------------------------------------------
' Active Directory FlagType definition (ADS_FLAGTYPE_ENUM)
Const ADS_FLAG_OBJECT_TYPE_PRESENT              = &h1
Const ADS_FLAG_INHERITED_OBJECT_TYPE_PRESENT    = &h2

' -------------------------------------------------------------------------------------------------
' Security descriptor inheritance.
Const ADS_ACEFLAG_OBJECT_INHERIT_ACE            = &h01
Const ADS_ACEFLAG_CONTAINER_INHERIT_ACE         = &h02

' AceFlag definition (ADS_ACEFLAG_ENUM)
Const ADS_ACEFLAG_INHERIT_ACE                   = &h02
Const ADS_ACEFLAG_NO_PROPAGATE_INHERIT_ACE      = &h04
Const ADS_ACEFLAG_INHERIT_ONLY_ACE              = &h08
Const ADS_ACEFLAG_INHERITED_ACE                 = &h10
Const ADS_ACEFLAG_VALID_INHERIT_FLAGS           = &h1F
Const ADS_ACEFLAG_SUCCESSFUL_ACCESS             = &h40
Const ADS_ACEFLAG_FAILED_ACCESS                 = &h80

' -------------------------------------------------------------------------------------------------
' ADsSecurityUtility security descriptor components definitoon (ADS_SECURITY_INFO_ENUM)
Const ADS_SECURITY_INFO_OWNER                  = &h1
Const ADS_SECURITY_INFO_GROUP                  = &h2
Const ADS_SECURITY_INFO_DACL                   = &h4
Const ADS_SECURITY_INFO_SACL                   = &h8

' -------------------------------------------------------------------------------------------------
' ADsSecurityUtility security descriptor format definition (ADS_SD_FORMAT_ENUM)
Const ADS_SD_FORMAT_IID                         = &h1
Const ADS_SD_FORMAT_RAW                         = &h2
Const ADS_SD_FORMAT_HEXSTRING                   = &h3

' -------------------------------------------------------------------------------------------------
' ADsSecurityUtility path type definition (ADS_PATHTYPE_ENUM)
Const ADS_PATH_FILE                             = &h1
Const ADS_PATH_FILESHARE                        = &h2
Const ADS_PATH_REGISTRY                         = &h3

' Active Directory Service ACEType definition (ADS_ACETYPE_ENUM)
Const ADS_ACETYPE_ACCESS_ALLOWED                = &h0
Const ADS_ACETYPE_ACCESS_DENIED                 = &h1
Const ADS_ACETYPE_SYSTEM_AUDIT                  = &h2
Const ADS_ACETYPE_ACCESS_ALLOWED_OBJECT         = &h5
Const ADS_ACETYPE_ACCESS_DENIED_OBJECT          = &h6
Const ADS_ACETYPE_SYSTEM_AUDIT_OBJECT           = &h7

' -------------------------------------------------------------------------------------------------
' Registry rights definition
Const REG_QUERY_VALUE                           = &h00001
Const REG_SET_VALUE                             = &h00002
Const REG_CREATE_SUBKEYS                        = &h00004
Const REG_ENUMERATE_SUBKEYS                     = &h00008
Const REG_NOTIFY                                = &h00010
Const REG_CREATE_LINK                           = &h00020
Const REG_DELETE                                = &h10000
Const REG_READ_CONTROL                          = &h20000 
Const REG_WRITE_DAC                             = &h40000
Const REG_WRITE_OWNER                           = &h80000
Const REG_GENERIC_READ                          = &H20019  
Const REG_GENERIC_FULL_CONTROL                  = &HF003F

' -------------------------------------------------------------------------------------------------
' WMI Name Space Rights definition
Const WBEM_ENABLE                               = &h00001 
Const WBEM_METHOD_EXECUTE                       = &h00002 
Const WBEM_FULL_WRITE_REP                       = &h00004 
Const WBEM_PARTIAL_WRITE_REP                    = &h00008 
Const WBEM_WRITE_PROVIDER                       = &h00010 
Const WBEM_REMOTE_ACCESS                        = &h00020 
Const WBEM_READ_CONTROL                         = &h20000 
Const WBEM_WRITE_DAC                            = &h40000 

' -------------------------------------------------------------------------------------------------
' DCOM Rights definition
Const DCOM_RIGHT_EXECUTE                        = 1
Const DCOM_RIGHT_ACCESS_LOCAL                   = 2
Const DCOM_RIGHT_ACCESS_REMOTE                  = 4
Const DCOM_RIGHT_LAUNCH_LOCAL                   = 2
Const DCOM_RIGHT_LAUNCH_REMOTE                  = 4
Const DCOM_RIGHT_ACTIVATE_LOCAL                 = 8
Const DCOM_RIGHT_ACTIVATE_REMOTE                = 16

' --------------------------------------------------------------------------------------------------------
Const cWMIRuleGroup = "Windows Management Instrumentation (WMI)"
Const cFWRuleDCOMIn = "Windows Management Instrumentation (DCOM-In)"
Const cFWRuleWMIIn = "Windows Management Instrumentation (WMI-In)"
Const cFWRuleWMIOut = "Windows Management Instrumentation (WMI-Out)"
Const cFWRuleAsyncIn = "Windows Management Instrumentation (ASync-In)"

Const NET_FW_MODIFY_STATE_OK = 0
Const NET_FW_MODIFY_STATE_GP_OVERRIDE = 1
Const NET_FW_MODIFY_STATE_NO_EXCEPTIONS = 2
Const NET_FW_PROFILE2_DOMAIN = 1
Const NET_FW_PROFILE2_PRIVATE = 2
Const NET_FW_PROFILE2_PUBLIC = 4
Const NET_FW_IP_PROTOCOL_TCP = 6
Const NET_FW_IP_PROTOCOL_UDP = 17
Const NET_FW_IP_PROTOCOL_ICMPv4 = 1
Const NET_FW_IP_PROTOCOL_ICMPv6 = 58
Const NET_FW_RULE_DIR_IN = 1
Const NET_FW_RULE_DIR_OUT = 2
Const NET_FW_ACTION_BLOCK = 0
Const NET_FW_ACTION_ALLOW = 1

Const cWQLStartStop = "SELECT * FROM Win32_NTLogEvent Where SourceName='EventLog' And LogFile='System' And EventType=3 And (EventCode=6006 Or EventCode=6005)"
Const cSystemStart = 6005
Const cSystemStop = 6006


' --------------------------------------------------------------------------------------------------------
Dim objWMILocator
Dim objFS
Dim objWshShell
Dim objWshNetwork
Dim objShell 
Dim objStdOut
Dim objADSSecurity

Dim strFilePath
Dim strFileName, strLOGFileName, strSTATFileName, strWMIProvFileName, strDIAGFileName, strMIFFileName
Dim objLOGFileHandle, objSTATFileHandle, objDIAGFileHandle, objWMIProvFileHandle
Dim intDefaultLoggingLevel
Dim intWMICriticalityLevel
Dim intMaxSubClassExaminationDepth
Dim RunTimeEnvironmentInfo
Dim TrackingData
Dim strLastError
Dim strCSV

Dim strSMTPTo
Dim strSMTPFrom 
Dim strSMTPServer
Dim intSMTPPort
Dim intSMTPAuthenticate
Dim strSMTPUserName
Dim strSMTPPassword
Dim boolSMTPSSL
Dim boolSMTPTEST
Dim boolSMTPWMIInvalidState

Dim boolWScript 
Dim boolErrorPopup
Dim boolEventLog
Dim boolEventLogErrors
Dim boolLogWMIState
Dim boolSMS
Dim boolSilent
Dim boolNoEcho
Dim boolForce
Dim boolRunOnce
Dim boolCheckAccess
Dim boolCorrelateClassAndProvider
Dim intRequestAllInstances
Dim boolShowMOFErrors
Dim boolShowHighPrivProviders
Dim boolWriteInRepository
Dim boolWriteInExistingNS
Dim strWriteInRepository
Dim boolCheckConsistency
Dim boolWriteOperationCompleted
Dim intFreeSpace
Dim boolWMISystemError
Dim boolRC, intRC
Dim strBaseNamespace
Dim boolStrict 
Dim intOldestWMIDIAGLogHistory
Dim intOldestEVENTLogHistory
Dim boolWTTLogging
Dim boolNoWinZIP
Dim boolADsSecurity
Dim boolLoggingDebug
Dim boolStatistics
Dim boolShowLoadedProviders
Dim boolQueryWMIDiagData
Dim strWMIDataToQuery

Dim arrayWMIDCOMDataList, arraySpecificFileList, arrayWMITestList, arraySMSTestList, arraySMSAddedTestList, arraySCCMTestList
Dim arrayWMINameSpaceSecurity, arrayWMIDefaultNameSpaceSecurity, arrayWMIAppsNameSpaceSecurity, arrayWMINameSpaceSkippedSecurity 
Dim arrayDCOMDefaultAccessPermission, arrayDCOMMachineAccessRestriction
Dim arrayDCOMDefaultLaunchPermission, arrayDCOMMachineLaunchRestriction
Dim arrayWMIDCOMAccessPermission, arrayWMIDCOMLaunchPermission
Dim arrayWMIPSSDCOMAccessPermission, arrayWMIPSSDCOMLaunchPermission
Dim arrayWMIUnsecureApptDCOMAccessPermission, arrayWMIUnsecureApptDCOMLaunchPermission
Dim arrayWMIActiveScriptEventConsDCOMAccessPermission, arrayWMIActiveScriptEventConsDCOMLaunchPermission
Dim arrayWMIRepositoryFiles, arrayWMIRegistryServiceSetup, arrayWMIRegistryDCOMSetup, arrayWMIProgID
Dim arrayWMIRegistrySettings, arrayWMISystemConfigurationClasses, arrayWMIServiceKnownDependent, arrayWMIServiceActualDependent
Dim arrayExceptionForNoAutoRecoveryWBEMMOFFiles, arrayExceptionForMissingWMIProviderMOFFile, arrayExceptionForMissingDCOMRegistration
Dim arrayExceptionForMissingWMIProviderFile, arrayWMISystemClassList
Dim arrayKnownMOFFiles (), arrayKnownMOFFilesInAutoRecovery, arrayExceptionHighPrivWMIProvider, WBEMError
Dim arrayWMIProviderData, arrayWMIProviderDisplayName

Dim strStartTime
Dim strStartDate
Dim strStartDateTime 

Dim strExecutionDelta
Dim intExecutionDelta 
Dim strStart
Dim strEnd

Dim intCommandLineIndex
Dim longLogLineCounter
Dim longErrorCounter
Dim longWarningCounter
Dim longDynamicInstanceCounter
Dim longStaticInstanceCounter
Dim longInProcWMIProvider
Dim longOutOfProcWMIProvider
Dim longDecoupledWMIProvider
Dim longAsyncInstanceCounter
Dim longAsyncCancellationCounter

Dim longCIMClassCounter
Dim longCIMClassDescriptionCounter
Dim longCIMClassPropertyCounter
Dim longCIMClassReadPropertyCounter 
Dim longCIMClassWritePropertyCounter
Dim longCIMClassReadWritePropertyCounter
Dim longCIMClassPropertyDescriptionCounter
Dim longCIMClassPropertyNoDescriptionCounter
Dim longCIMClassReadPropertyDescriptionCounter
Dim longCIMClassWritePropertyDescriptionCounter
Dim longCIMClassReadWritePropertyDescriptionCounter

Dim longCIMClassMethodCounter
Dim longCIMClassMethodDescriptionCounter
Dim longCIMClassMethodInParameterCounter 
Dim longCIMClassMethodOutParameterCounter 
Dim longCIMClassMethodInParamDescriptionCounter 
Dim longCIMClassMethodOutParamDescriptionCounter 
Dim longCIMClassWithMethodCounter

Dim longWMIProviderCounter
Dim longWMIClassCounter
Dim longWMIClassDescriptionCounter
Dim longWMIClassPropertyCounter
Dim longWMIClassReadPropertyCounter 
Dim longWMIClassWritePropertyCounter 
Dim longWMIClassReadWritePropertyCounter
Dim longWMIClassPropertyDescriptionCounter
Dim longWMIClassPropertyNoDescriptionCounter
Dim longWMIClassReadPropertyDescriptionCounter
Dim longWMIClassWritePropertyDescriptionCounter
Dim longWMIClassReadWritePropertyDescriptionCounter

Dim longWMIClassMethodCounter
Dim longWMIClassMethodDescriptionCounter
Dim longWMIClassMethodInParameterCounter 
Dim longWMIClassMethodOutParameterCounter 
Dim longWMIClassMethodInParamDescriptionCounter 
Dim longWMIClassMethodOutParamDescriptionCounter 
Dim longWMIClassWithMethodCounter
 
Dim varParameter()
Dim varParameterValue()

Dim objWMIServicesToRoot, objWMIServicesForWrite ()
Dim boolSinkCompleted, boolSinkCancelled, boolSinkError, objWMISink

Class classRunTimeEnvironmentInfo
      Dim StartMenu
      Dim Desktop
      Dim Programs
      Dim SystemDrive
      Dim SystemRoot
      Dim Path
      Dim UserTemp
      Dim SystemTemp
      Dim System32
      Dim System
      Dim WBem
      Dim WBemLogs
      Dim CurrentDirectory
      Dim AllUsersStartMenu
      Dim AllUsersDesktop
      Dim AllUsersPrograms

      Dim DomainName
      Dim UserName
      Dim UserDNSDomain

      Dim LocalComputerName
      Dim LogonServerName

      Dim WSHScriptVersion
      Dim ScriptName
      Dim ScriptFullName
      Dim ScriptingName
      Dim EngineFullName
      Dim CommandLine
      Dim EnginePath
      Dim EngineVersion

      Dim ProductName
      Dim Locale
      Dim IsServerOS
      Dim Is64
      Dim IsWow64
      Dim ProcessorArchitecture
      Dim ProcessorIdentifier
      Dim NTVersion
      Dim NTBuild
      Dim NTServicePack
      Dim ProductFullName
      Dim ProductShortName
      Dim OSIdentifier
      Dim OSStringIdentifier
      Dim OSBrandVersion
      Dim SPUpgrade

      Dim SMSAgent
      Dim WinZIP
End Class

Class ClassWBEMError
      Dim WBEMCode
      Dim WBEMError
      Dim WBEMMessage
      Dim WBEMCounter
End Class

Class ClassTrackingData
      Dim Environment
      Dim WMIProviderSupportingEnumeration
      Dim PresenceOfFiles
      Dim AdditionalBinaryWBEMFolder
      Dim MissingWMISystemFiles
      Dim RepositoryFileSizes
      Dim MissingRepositoryFiles
      Dim AutoRecoveryMissingMOFFiles
      Dim WBemFolderMOFFilesNotListedInAutoRecovery
      Dim FirewallStatus
      Dim InvalidWMIServiceSetup
      Dim WMIServiceDependents
      Dim ServiceState
      Dim InvalidWMIServiceDCOMSetup
      Dim InvalidDCOMSetup
      Dim WMIDCOMRegistrations
      Dim HighPrivWMIProvider
      Dim RequiresEncryption
      Dim WMIProviderDCOMRegistrations
      Dim WMIProviderCIMRegistrations
      Dim WMIProviderEmptyCLSID
      Dim MissingWMIProviderFile
      Dim MissingWMIProviderMOFFile
      Dim GoodProviderCIMRegistration
      Dim WMIProviderRegistrationData
      Dim WMIProviderLocationData
      Dim ClassSupportedByProvider
      Dim LocatedWMIProviderMOFFile
      Dim DecoupledWMIProvider
      Dim WriteInRepository
      Dim WMIConnectionErrors
      Dim WMIMonikerConnectionErrors
      Dim WMIEnumerationErrors
      Dim WMIGetErrors
      Dim WMIPutErrors
      Dim WMIDeleteErrors
      Dim WMIMethodErrors
      Dim WMIExecQueryErrors
      Dim QualifierAccessError   
      Dim InvalidWMIRegistrySetup
      Dim WMIDiskData 
      Dim WMIEventLogEventData
      Dim WMIRepositoryConsistency
      Dim FailingMOFRepresentation
      Dim WMIGetValuePropertyErrors
      Dim WMIEnumerationSkipped 
      Dim WMIExecQuerySkipped 
      Dim WMIGetValuePropertySkipped 
      Dim ADAPStatus
      Dim WMIObjectProgID
      Dim PragmaAutorecoverMOFFile
      Dim NoPragmaAutorecoverMOFFile
      Dim SecurityDescriptor
      Dim UAC
      Dim InvalidShutdown
      Dim PermanentSubscriptions
      Dim TimerInstructions
End Class

Class EventLogEntry
      Dim RecordNumber
      Dim EventCode
      Dim TimeGenerated
End Class

On Error Resume Next

' --------------------------------------------------------------------------------------------------------
Set objWMILocator = CreateObject ("WBemscripting.SWBemlocator")
objWMILocator.Security_.AuthenticationLevel = wbemAuthenticationLevelDefault
objWMILocator.Security_.ImpersonationLevel = wbemImpersonationLevelImpersonate

Set objFS = CreateObject ("Scripting.FileSystemObject")
Set objWshShell = CreateObject ("WScript.Shell")
Set objWshNetwork = CreateObject ("WScript.Network")
set objShell = CreateObject("Shell.Application")
Set objStdOut = WScript.StdOut

' --------------------------------------------------------------------------------------------------------
Set RunTimeEnvironmentInfo = new classRunTimeEnvironmentInfo
Set TrackingData = new ClassTrackingData

GetRunTimeEnvInfo RunTimeEnvironmentInfo

If RunTimeEnvironmentInfo.OSIdentifier > cWindows2000SP4 Then
   Set objADSSecurity = CreateObject ("ADsSecurityUtility")
   If Err.Number Then
      boolADsSecurity = False
      Err.Clear
   Else
      boolADsSecurity = True
   End If
Else
   Set objADSSecurity = CreateObject ("ADsSecurityForWMIDiag")
   If Err.Number Then
      boolADsSecurity = False
      Err.Clear
   Else
      boolADsSecurity = True
   End If
End If

ReDim WBEMError (0)
Set WBEMError (0) = new ClassWBEMError
WBEMError (0).WBEMCounter = 0

longLogLineCounter = 0
longErrorCounter = 0
longWarningCounter = 0
intWMICriticalityLevel = 0
longDynamicInstanceCounter = 0
longStaticInstanceCounter = 0
longInProcWMIProvider = 0
longOutOfProcWMIProvider = 0
longDecoupledWMIProvider = 0
longAsyncInstanceCounter = 0
longAsyncCancellationCounter = 0

longCIMClassCounter = 0
longCIMClassDescriptionCounter = 0
longCIMClassPropertyCounter = 0
longCIMClassReadPropertyCounter = 0
longCIMClassWritePropertyCounter = 0
longCIMClassReadWritePropertyCounter = 0
longCIMClassPropertyDescriptionCounter = 0
longCIMClassPropertyNoDescriptionCounter = 0
longCIMClassReadPropertyDescriptionCounter = 0
longCIMClassWritePropertyDescriptionCounter = 0
longCIMClassReadWritePropertyDescriptionCounter = 0

longCIMClassMethodCounter = 0
longCIMClassMethodDescriptionCounter = 0
longCIMClassMethodInParameterCounter = 0
longCIMClassMethodOutParameterCounter = 0
longCIMClassMethodInParamDescriptionCounter = 0
longCIMClassMethodOutParamDescriptionCounter = 0
longCIMClassWithMethodCounter = 0

longWMIProviderCounter = 0

longWMIClassCounter = 0
longWMIClassDescriptionCounter = 0
longWMIClassPropertyCounter = 0
longWMIClassReadPropertyCounter = 0
longWMIClassWritePropertyCounter = 0
longWMIClassPropertyDescriptionCounter = 0
longWMIClassPropertyNoDescriptionCounter = 0
longWMIClassReadPropertyDescriptionCounter = 0
longWMIClassWritePropertyDescriptionCounter = 0
longWMIClassReadWritePropertyDescriptionCounter = 0

longWMIClassMethodCounter = 0
longWMIClassMethodDescriptionCounter = 0
longWMIClassMethodInParameterCounter = 0
longWMIClassMethodOutParameterCounter = 0
longWMIClassMethodInParamDescriptionCounter = 0
longWMIClassMethodOutParamDescriptionCounter = 0
longWMIClassWithMethodCounter = 0

boolForce = cForce
boolNoEcho = cNoEcho
boolRunOnce = cRunOnce
boolEventLog = cEventLog
boolEventLogErrors = cEventLogErrors
boolLogWMIState = cLogWMIState
boolSMS = cSMS
boolSilent = cSilent
boolErrorPopup = cErrorPopup
boolCorrelateClassAndProvider = cCorrelateClassAndProvider
intRequestAllInstances = cRequestAllInstances
boolShowMOFErrors = cShowMOFerrors
boolShowHighPrivProviders = cShowHighPrivProviders
boolWriteInRepository = cWriteInRepository
boolWriteInExistingNS = cWriteInExistingNS
boolCheckConsistency = cCheckConsistency
boolWriteOperationCompleted = False
strBaseNamespace = cBaseNS
boolStrict = cStrict
intOldestWMIDIAGLogHistory = cOldestWMIDIAGLogHistory 
intOldestEVENTLogHistory = cOldestEVENTLogHistory
strFilePath = RunTimeEnvironmentInfo.UserTemp  
intDefaultLoggingLevel = cLoggingLevel0
intMaxSubClassExaminationDepth = cMaxSubClassExaminationDepth 
objLOGFileHandle = Null
boolWTTLogging = False
boolNoWinZIP = cNoWinZIP
boolLoggingDebug = cDebug
boolStatistics = cStatistics
boolShowLoadedProviders = cShowLoadedProviders
boolQueryWMIDiagData = cQueryWMIDiagData

strSMTPTo = cSMTPTo
strSMTPFrom = cSMTPFrom
strSMTPServer = cSMTPServer 
intSMTPPort = cSMTPPort
intSMTPAuthenticate = cSMTPAuthenticate
strSMTPUserName = cSMTPUserName 
strSMTPPassword = cSMTPPassword
boolSMTPSSL = cSMTPSSL
boolSMTPTEST = cSMTPTEST
boolSMTPWMIInvalidState = cSMTPWMIInvalidState

If Ucase (RunTimeEnvironmentInfo.EnginePath & "\Wscript.Exe") = Ucase (RunTimeEnvironmentInfo.EngineFullName) Then
   boolNoEcho = True
   boolWScript = True
End If

' --------------------------------------------------------------------------------------------------------------------
strStartTime = Time
strStartDate = Date
strStartDateTime = strStartDate & " " & strStartTime
strFileName = Ucase ("WMIDiag-v" & cWMIDiagVersion & "_" & RunTimeEnvironmentInfo.ProductShortName & "_" & RunTimeEnvironmentInfo.LocalComputerName & "_" & _
                     Year (strStartDateTime) & "." & _
                     Right ("00" & Month (strStartDateTime), 2) & "." & _
                     Right ("00" & Day (strStartDateTime), 2) & "_" & _
                     Right ("00" & Hour (strStartDateTime), 2) & "." & _
                     Right ("00" & Minute (strStartDateTime), 2) & "." & _
                     Right ("00" & Second (strStartDateTime), 2))

strSTATFileName = strFileName & "-STATISTICS.CSV"
strLOGFileName = strFileName & ".LOG"
strWMIProvFileName = strFileName & "-PROVIDERS.CSV"
strDIAGFileName = strFileName & "-REPORT.TXT"
strMIFFileName = strFileName & ".MIF"

' -----------------------------------------------------------------------------------------------------------------------
If (ParseCommandLineArguments (objLOGFileHandle, varParameter, varParameterValue)) > 0 Then
   For intCommandLineIndex = 0 to Ubound(varParameter) - 1
       Select Case Ucase (varParameter (intCommandLineIndex))
              Case "SMTPTO"
                   strSMTPTo = varParameterValue (intCommandLineIndex)

              Case "SMTPFROM" 
                   strSMTPFrom = varParameterValue (intCommandLineIndex)

              Case "SMTPSERVER"
                   strSMTPServer = LCase (varParameterValue (intCommandLineIndex))
                   If Len (strSMTPFrom) = 0 Then
                      ErrorHandler objLOGFileHandle, "InvalidCommandLineParameter", "SMTPFROM email address is invalid. It must be specified BEFORE the SMTPSERVER parameter.", True, Err
                      ExitWMIDiag (3)
                   End If

              Case "SMTPPORT"
                   intSMTPPort = CLng (varParameterValue (intCommandLineIndex))
                   If intSMTPPort < 1 Or intSMTPPort > 65535 Then
                      ErrorHandler objLOGFileHandle, "InvalidCommandLineParameter", "SMTPPORT is invalid. It must be a value between 1 and 65535.", True, Err
                      ExitWMIDiag (3)
                   End If

              Case "SMTPAUTHENTICATE"
                   Select Case Ucase(varParameterValue (intCommandLineIndex))
                          Case "ANONYMOUS"
                               intSMTPAuthenticate = 0
                          Case "BASIC" 
                               intSMTPAuthenticate = 1
                          Case "NTLM"
                               intSMTPAuthenticate = 2
                          Case Else
                               ErrorHandler objLOGFileHandle, "InvalidCommandLineParameter", "Invalid SMTPAUTHENTICATE parameter detected: '" & varParameter (intCommandLineIndex) & "'.", True, Err
                               Help ()
                               ExitWMIDiag (3)
                   End Select

              Case "SMTPUSERNAME"
                   strSMTPUsername = varParameterValue (intCommandLineIndex)

              Case "SMTPPASSWORD"
                   strSMTPPassword = varParameterValue (intCommandLineIndex)

              Case "SMTPSSL" 
                   boolSMTPSSL = True

              Case "SMTPTEST"
                   boolSMTPTEST = True

              Case "SMTPWMIINVALIDSTATE"
                   boolSMTPWMIInvalidState = True

              Case "SMS"
                   boolSMS = True

              Case "SILENT"
                   boolSilent = True

              Case "NOECHO"
                   boolNoEcho = True

              Case "FORCE"
                   boolForce = True
    
              Case "RUNONCE"
                   boolRunOnce = True

              Case "LOGWMISTATE"
                   boolLogWMIState = True

              Case "DEPTH"
                   intMaxSubClassExaminationDepth = CLng(varParameterValue (intCommandLineIndex))
                   If intMaxSubClassExaminationDepth < 1 Or intMaxSubClassExaminationDepth > 9 Then
                      ErrorHandler objLOGFileHandle, "InvalidCommandLineParameter", "Depth examination " & intMaxSubClassExaminationDepth & " is invalid.", True, Err
                      ExitWMIDiag (3)
                   End If

              Case "LOGGINGLEVEL"
                   intDefaultLoggingLevel = CLng(varParameterValue (intCommandLineIndex))
                   If intDefaultLoggingLevel < 0 Or intDefaultLoggingLevel > cLoggingLevel4 Then
                      ErrorHandler objLOGFileHandle, "InvalidCommandLineParameter", "Logging level " & intDefaultLoggingLevel & " is invalid.", True, Err
                      ExitWMIDiag (3)
                   End If

              Case "OLDESTLOGHISTORY"
                   intOldestWMIDIAGLogHistory = CLng(varParameterValue (intCommandLineIndex))
                   If intOldestWMIDIAGLogHistory =< 0 Or intOldestWMIDIAGLogHistory > 365 Then
                      ErrorHandler objLOGFileHandle, "InvalidCommandLineParameter", "Oldest WMIDIAG Log History " & intOldestWMIDIAGLogHistory & " is invalid.", True, Err
                      ExitWMIDiag (3)
                   End If

              Case "OLDESTEVENTLOGHISTORY"
                   intOldestEVENTLogHistory = CLng(varParameterValue (intCommandLineIndex))
                   If intOldestEVENTLogHistory =< 0 Or intOldestEVENTLogHistory > 365 Then
                      ErrorHandler objLOGFileHandle, "InvalidCommandLineParameter", "Oldest EVENT Log History " & intOldestEVENTLogHistory & " is invalid.", True, Err
                      ExitWMIDiag (3)
                   End If

              Case "CORRELATECLASSANDPROVIDER"
                   boolCorrelateClassAndProvider = True

              Case "REQUESTALLINSTANCES"
                   Select Case Ucase(varParameterValue (intCommandLineIndex))
                          Case "STATIC"
                               intRequestAllInstances = cStatic
                          Case "DYNAMIC" 
                               intRequestAllInstances = cDynamic
                          Case "STATICANDDYNAMIC", ""
                               intRequestAllInstances = cStaticAndDynamic
                          Case Else
                               ErrorHandler objLOGFileHandle, "InvalidCommandLineParameter", "Invalid Request All Instances parameter detected: '" & varParameter (intCommandLineIndex) & "'.", True, Err
                               Help ()
                               ExitWMIDiag (3)
                   End Select

              Case "WRITEINREPOSITORY"
                   strWriteInRepository = Ucase (varParameterValue (intCommandLineIndex))
                   If Len (strWriteInRepository) = 0 Then 
                      boolWriteInExistingNS = False
                      strWriteInRepository = cWriteInRepositoryNS
                   Else
                      boolWriteInExistingNS = True
                      strWriteInRepository = ReplaceString (strWriteInRepository, "\", "/")
                   End If
                   boolWriteInRepository = True

              Case "STRICT"
                   boolStrict = True

              Case "CHECKCONSISTENCY"
                   boolCheckConsistency = True
                   
              Case "SHOWMOFERRORS"
                   boolShowMOFErrors = True

              Case "SHOWHIGHPRIVPROVIDERS"
                   boolShowHighPrivProviders = True

              Case "BASENAMESPACE"
                   strBaseNamespace = Ucase (varParameterValue (intCommandLineIndex))
                   If Len (strBaseNameSpace) = 0 Then strBaseNameSpace = "ROOT"
                   strBaseNamespace = ReplaceString (strBaseNamespace, "\", "/")

              Case "LOGFILEPATH"
                   strFilePath = varParameterValue (intCommandLineIndex)
                   If Len (strFilePath) = 0 Then 
                      strFilePath = RunTimeEnvironmentInfo.UserTemp
                   Else
                      If Len (RunTimeEnvironmentInfo.CurrentDirectory) > 0 Then
                         If Left (strFilePath, 1) = "." Then 
                            If Left (strFilePath, 2) = ".." Then
                               strFilePath = RunTimeEnvironmentInfo.CurrentDirectory & "\" & strFilePath
                            Else
                               strFilePath = RunTimeEnvironmentInfo.CurrentDirectory & Mid (strFilePath, 2)
                            End If
                         End If
                      End If
                   End If

                   If Mid (strFilePath, Len (strFilePath), 1) <> "\" Then
                      strFilePath = strFilePath & "\"
                   End If

              Case "LOGNTEVENTS"
                   boolEventLog = True

              Case "LOGNTEVENTERRORS"
                   boolEventLogErrors = True

              Case "ERRORPOPUP"
                   boolErrorPopup = True

              Case "WTTLOGGING"
                   boolWTTLogging = True

              Case "NOWINZIP"
                   boolNoWinZIP = True

              Case "DEBUG"
                   boolLoggingDebug = True

              Case "STATISTICS"
                   boolStatistics = True

              Case "SHOWLOADEDPROVIDERS"
                   boolShowLoadedProviders = True

              Case "QUERYWMIDIAGDATA"
                   boolQueryWMIDiagData = True
                   strWMIDataToQuery = varParameterValue (intCommandLineIndex)
    
              Case "?", "HELP", "/?"
                   Help ()
                   ExitWMIDiag (0)

              Case Else
                   ErrorHandler objLOGFileHandle, "InvalidCommandLineParameter", "Invalid command line parameter detected: '" & varParameter (intCommandLineIndex) & "'.", True, Err
                   Help ()
                   ExitWMIDiag (3)
       End Select
   Next
End If

If boolSMS = True Then
   boolNoEcho = True
   boolSilent = True
End If

If boolSilent = False And boolWScript = True Then
   intRC = objWSHShell.Popup ("Your default scripting engine is WSCRIPT.EXE." & vbCRLF & _ 
                              "Therefore WMIDiag will not produce any echo! " & vbCRLF & _
                              "The script will continue automatically in " & cPopupTimeout & " second(s) and run silently in the background." & vbCRLF & vbCRLF & _
                              "To see WMIDiag script activity on the screen, at the prompt, type: " & vbCRLF & vbCRLF & _
                              "                               Cscript.Exe //H:Cscript", _
                              cPopupTimeout, _
                              "(WMIDiag " & cWMIDiagVersion & ") Information", _
                              vbExclamation Or vbOk)
   If intRC = vbCancel Then
      ExitWMIDiag (4)
   End If
End If

If boolSMTPTEST Then
   If Len (strSMTPServer) > 0 Then
      SendMessage strSMTPTo, _
                  strSMTPFrom, _
                  "WMIDiag v" & cWMIDiagVersion & " TEST message. Started on " & FormatDateTime (Date, vbLongDate) & " at " & FormatDateTime (Time, vbShortTime) & ".", _
                  "WMIDiag v" & cWMIDiagVersion & " TEST message. Please discard!", _
                  "", _
                  Null
      ExitWMIDiag (0)
   End If
End If

If boolSilent = False And boolCheckConsistency = True And RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP2 Then
   intRC = objWSHShell.Popup ("Under Windows XP SP2, when the repository consistency is checked and when it" & vbCRLF & _
                              "is detected INCONSISTENT, a new repository is automatically re-created based on Auto-Recovery mechanism." & vbCRLF & _
                              "Note that some information CAN BE LOST during this process (i.e. static data, CIM registration)." & vbCRLF & _
                              "However, the original repository will be located at:" & vbCRLF & vbCRLF & _
                              RunTimeEnvironmentInfo.WBem & "Repository.001", _
                              cPopupTimeout * 2, _
                              "(WMIDiag " & cWMIDiagVersion & ") Information", _
                              vbExclamation Or vbOk)
   If intRC = vbCancel Then
      ExitWMIDiag (4)
   End If
End If

If boolSilent = False And boolCheckConsistency = True And RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP3 Then
   intRC = objWSHShell.Popup ("Under Windows XP SP3, when the repository consistency is checked and when it" & vbCRLF & _
                              "is detected INCONSISTENT, a new repository is automatically re-created based on Auto-Recovery mechanism." & vbCRLF & _
                              "Note that some information CAN BE LOST during this process (i.e. static data, CIM registration)." & vbCRLF & _
                              "However, the original repository will be located at:" & vbCRLF & vbCRLF & _
                              RunTimeEnvironmentInfo.WBem & "Repository.001", _
                              cPopupTimeout * 2, _
                              "(WMIDiag " & cWMIDiagVersion & ") Information", _
                              vbExclamation Or vbOk)
   If intRC = vbCancel Then
      ExitWMIDiag (4)
   End If
End If

If boolSilent = False And Len (strSMTPServer) Then
   intRC = objWSHShell.Popup ("By specifying an SMTP relay address '" & strSMTPServer & "', you consent to send WMIDiag information to '" & Lcase (strSMTPTo) & "' via email!" & vbCRLF & vbCRLF & _ 
                              "Press CANCEL if you disagree ... otherwise, the script will continue automatically in " & cPopupTimeout & " second(s)!", _
                              cPopupTimeout, _
                              "(WMIDiag " & cWMIDiagVersion & ") Information", _
                              vbExclamation Or vbOk)
   If intRC = vbCancel Then
      ExitWMIDiag (4)
   End If
End If

If boolSilent = False And intRequestAllInstances > 1 Then
   intRC = objWSHShell.Popup ("WMIDiag will request all STATIC and DYNAMIC instances that can be retrieved with WMI." & vbCRLF & vbCRLF & _ 
                              "This operation REQUIRES that all installed services and applications providing information" & vbCRLF & _
                              "through WMI are UP and running, otherwise, this could generate A LOT of unwanted errors!" & vbCRLF & vbCRLF & _
                              "This operation can be VERY CPU intensive!" & vbCRLF & vbCRLF & _
                              "The script will continue automatically in " & cPopupTimeout & " second(s) and run" & vbCRLF & _
                              "from 30 minutes to SEVERAL hours depending of the installation options." & vbCRLF & vbCRLF & _
                              "Press CANCEL if you do not want to perform this operation!", _
                              cPopupTimeout, _
                              "(WMIDiag " & cWMIDiagVersion & ") Information", _
                              vbExclamation Or vbOk)
   If intRC = vbCancel Then
      ExitWMIDiag (4)
   End If
End If

' -----------------------------------------------------------------------------------------------------------------------
Set objLOGFileHandle = CreateTextFile (strFilePath & strLOGFileName)
If IsNull (objLOGFileHandle) = True Then 
   Err.Clear
   ErrorHandler Null, "Main", "LOG file " & Chr(34) & strFilePath & strLOGFileName & Chr(34) & " CANNOT be created.", True, Err
   ExitWMIDiag (1)
End If
WriteToLogFile objLOGFileHandle, "LOG file " & Chr(34) & strFilePath & strLOGFileName & Chr(34) & " created.", cLoggingLevel0, False

If boolShowLoadedProviders Then
   intDefaultLoggingLevel = cLoggingLevel4

   InitializeWMISystemInformation objLOGFileHandle
   GetLoadedProviders objLOGFileHandle, ""

   WriteToLogFile objLOGFileHandle, "LOG file " & Chr(34) & strFilePath & strLOGFileName & Chr(34) & " closed.", cLoggingLevel0, False
   CloseTextFile (objLOGFileHandle)
   ExitWMIDiag (0)
End If

If boolQueryWMIDiagData Then
   intDefaultLoggingLevel = cLoggingLevel4

   InitializeWMISystemInformation objLOGFileHandle
   QueryWMIDiagData objLOGFileHandle, strWMIDataToQuery

   WriteToLogFile objLOGFileHandle, "LOG file " & Chr(34) & strFilePath & strLOGFileName & Chr(34) & " closed.", cLoggingLevel0, False
   CloseTextFile (objLOGFileHandle)
   ExitWMIDiag (0)
End If

Set objSTATFileHandle = CreateTextFile (strFilePath & strSTATFileName)
If IsNull (objSTATFileHandle) = True Then 
   Err.Clear
   ErrorHandler Nothing, "Main", "CSV file " & Chr(34) & strFilePath & strSTATFileName & Chr(34) & " CANNOT be created.", True, Err
   ExitWMIDiag (1)
End If
WriteToLogFile objLOGFileHandle, "CSV file " & Chr(34) & strFilePath & strSTATFileName & Chr(34) & " created.", cLoggingLevel0, False

Set objDiAGFileHandle = CreateTextFile (strFilePath & strDiAGFileName)
If IsNull (objDiAGFileHandle) = True Then 
   Err.Clear
   ErrorHandler Nothing, "Main", "TXT file " & Chr(34) & strFilePath & strDIAGFileName & Chr(34) & " CANNOT be created.", True, Err
   ExitWMIDiag (1)
End If
WriteToLogFile objLOGFileHandle, "TXT file " & Chr(34) & strFilePath & strDiAGFileName & Chr(34) & " created.", cLoggingLevel0, False

If boolWTTLogging = True then
   If IncludeAndExecuteVBS (objLOGFileHandle, RunTimeEnvironmentInfo.CurrentDirectory & "\" & "Support.vbs") = True Then
      boolWTTLogging = False
   Else
      CreateWTTLogDevice (strLOGFileName)
      StartWTTTest (strLOGFileName)
   End if
End if

If boolCorrelateClassAndProvider = True Then
   Set objWMIProvFileHandle = CreateTextFile (strFilePath & strWMIProvFileName)
   If IsNull (objWMIProvFileHandle) = True Then 
      Err.Clear
      ErrorHandler objLOGFileHandle, "Main", "CSV file " & Chr(34) & strFilePath & strWMIProvFileName & Chr(34) & " CANNOT be created.", True, Err
      ExitWMIDiag (1)
   End If
   WriteToLogFile objLOGFileHandle, "CSV file " & Chr(34) & strFilePath & strWMIProvFileName & Chr(34) & " created.", cLoggingLevel0, False
End If

DumpCSV cWMIDiagVersion, "cWMIDiagVersion", 1, True
DumpCSV Month (Date) & "/" & Day (Date) & "/" & Year (Date), "Date", 1, True
DumpCSV Time, "Time", 1, True

strStart = "WMIDiag v" & cWMIDiagVersion & " started on " & FormatDateTime (Date, vbLongDate) & " at " & FormatDateTime (Time, vbShortTime) & "."
WriteToLogFile objLOGFileHandle, strStart, cLoggingLevel0, False
MSDisclaimer (objLOGFileHandle)

If boolLogWMIState = True Then objWshShell.LogEvent 0, "WMIDIAG BEGIN: " & strStart

If Len (strSMTPServer) > 0 Then 
   WriteToLogFile objLOGFileHandle, "By specifying an SMTP relay address, the user '" & RunTimeEnvironmentInfo.DomainName & "\" & RunTimeEnvironmentInfo.UserName & "' consents to send information to '" & Lcase (strSMTPTo) & "' via email!", cLoggingLevel2, True

   WriteToLogFile objLOGFileHandle, "SMTPServer=" & strSMTPServer, cLoggingLevel4, False
   WriteToLogFile objLOGFileHandle, "SMTPPort=" & intSMTPPort, cLoggingLevel4, False
   WriteToLogFile objLOGFileHandle, "SMTPAuthenticate=" & intSMTPAuthenticate, cLoggingLevel4, False
   WriteToLogFile objLOGFileHandle, "SMTPUserName=" & strSMTPUserName, cLoggingLevel4, False
   WriteToLogFile objLOGFileHandle, "SMTPPassword=********", cLoggingLevel4, False
   WriteToLogFile objLOGFileHandle, "SMTPSSL=" & boolSMTPSSL, cLoggingLevel4, False
   WriteToLogFile objLOGFileHandle, "SMTPTO=" & strSMTPTO, cLoggingLevel4, False
   WriteToLogFile objLOGFileHandle, "SMTPFrom=" & strSMTPFrom, cLoggingLevel4, False
End If

WriteToLogFile objLOGFileHandle, "NOECHO=" & boolNoEcho, cLoggingLevel3, False
WriteToLogFile objLOGFileHandle, "SILENT=" & boolSilent, cLoggingLevel3, False
WriteToLogFile objLOGFileHandle, "SMS=" & boolSMS, cLoggingLevel3, False
WriteToLogFile objLOGFileHandle, "FORCE=" & boolForce, cLoggingLevel3, False
WriteToLogFile objLOGFileHandle, "NOWINZIP=" & boolNoWinZIP, cLoggingLevel3, False
WriteToLogFile objLOGFileHandle, "DEBUG=" & boolLoggingDebug, cLoggingLevel3, False
WriteToLogFile objLOGFileHandle, "STATISTICS=" & boolStatistics, cLoggingLevel3, False
WriteToLogFile objLOGFileHandle, "RUNONCE=" & boolRunOnce, cLoggingLevel3, False
Select Case intMaxSubClassExaminationDepth
       Case 1
            WriteToLogFile objLOGFileHandle, "DEPTH LEVEL=" & intMaxSubClassExaminationDepth, cLoggingLevel3, False
       Case 2
            WriteToLogFile objLOGFileHandle, "DEPTH LEVEL=" & intMaxSubClassExaminationDepth & " (WARNING: This will be quite long!)", cLoggingLevel3, False
       Case Else
            WriteToLogFile objLOGFileHandle, "DEPTH LEVEL=" & intMaxSubClassExaminationDepth & " (WARNING: This will be extremely long and CPU intensive!!!)", cLoggingLevel3, False
End Select
WriteToLogFile objLOGFileHandle, "LOGGINGLEVEL=" & intDefaultLoggingLevel, cLoggingLevel3, False
WriteToLogFile objLOGFileHandle, "EVENTLOG=" & boolEventLog, cLoggingLevel3, False
WriteToLogFile objLOGFileHandle, "EVENTLOGERRORS=" & boolEventLogErrors, cLoggingLevel3, False
WriteToLogFile objLOGFileHandle, "LOGWMISTATE=" & boolLogWMIState, cLoggingLevel3, False
WriteToLogFile objLOGFileHandle, "ERRORPOPUP=" & boolErrorPopup, cLoggingLevel3, False
WriteToLogFile objLOGFileHandle, "REQUESTALLINSTANCES=" & intRequestAllInstances, cLoggingLevel3, False
WriteToLogFile objLOGFileHandle, "WRITEINREPOSITORY=" & boolWriteInRepository, cLoggingLevel3, False
WriteToLogFile objLOGFileHandle, "CHECKCONSISTENCY=" & boolCheckConsistency, cLoggingLevel3, False
WriteToLogFile objLOGFileHandle, "SHOWMOFERRORS=" & boolShowMOFErrors, cLoggingLevel3, False
WriteToLogFile objLOGFileHandle, "SHOWHIGHPRIVPROVIDERS=" & boolShowHighPrivProviders, cLoggingLevel3, False
WriteToLogFile objLOGFileHandle, "CORRELATECLASSANDPROVIDER=" & boolCorrelateClassAndProvider, cLoggingLevel3, False
WriteToLogFile objLOGFileHandle, "STRICT=" & boolStrict, cLoggingLevel3, False
WriteToLogFile objLOGFileHandle, "OLDESTLOGHISTORY=" & intOldestWMIDIAGLogHistory, cLoggingLevel3, False
WriteToLogFile objLOGFileHandle, "OLDESTEVENTLOGHISTORY=" & intOldestEVENTLogHistory, cLoggingLevel3, False
WriteToLogFile objLOGFileHandle, "BASENAMESPACE=" & strBaseNamespace, cLoggingLevel3, False

' -----------------------------------------------------------------------------------------------------------------------
If CheckLastRun (objLOGFileHandle) = True Then
   intWMICriticalityLevel = 4
Else
   LogRunTimeEnvInfo objLOGFileHandle, RunTimeEnvironmentInfo

   InitializeWMISystemInformation objLOGFileHandle

   WriteToLogFile objLOGFileHandle, RunTimeEnvironmentInfo.ProductFullName & " (" & RunTimeEnvironmentInfo.ProductShortName & ").", cLoggingLevel0, False
   If Len (RunTimeEnvironmentInfo.SPUpgrade) > 0 Then 
      WriteToLogFile objLOGFileHandle, "INFO: " & RunTimeEnvironmentInfo.SPUpgrade, cLoggingLevel0, False
   End If

   DumpCSV RunTimeEnvironmentInfo.IsServerOS, "IsServerOS", 1, True
   DumpCSV RunTimeEnvironmentInfo.Is64, "Is64", 1, True
   DumpCSV RunTimeEnvironmentInfo.IsWOW64, "IsWOW64", 1, True
   DumpCSV RunTimeEnvironmentInfo.ProcessorArchitecture, "ProcessorArchitecture", 1, True
   DumpCSV RunTimeEnvironmentInfo.ProcessorIdentifier, "ProcessorIdentifier", 1, True
   DumpCSV RunTimeEnvironmentInfo.NTVersion, "NTVersion", 1, True
   DumpCSV RunTimeEnvironmentInfo.NTBuild, "NTBuild", 1, True
   DumpCSV RunTimeEnvironmentInfo.NTServicePack, "NTServicePack", 1, True
   DumpCSV RunTimeEnvironmentInfo.ProductFullName, "ProductFullName", 1, True
   DumpCSV RunTimeEnvironmentInfo.ProductShortName, "ProductShortName", 1, True
   DumpCSV RunTimeEnvironmentInfo.Locale, "Locale", 1, True
   DumpCSV RunTimeEnvironmentInfo.LocalComputerName, "LocalComputerName", 1, True
   DumpCSV RunTimeEnvironmentInfo.DomainName & "\" & RunTimeEnvironmentInfo.UserName, "DomainName", 1, True

   If RunTimeEnvironmentInfo.OSIdentifier = cWindowsUnknown Then
      ErrorHandler objLOGFileHandle, "Main", "Unsupported OS version or build #.", True, Err
      DumpCSV " ", " ", cMaxCSVFields - 29, True

      intWMICriticalityLevel = 4
   Else
      boolCheckAccess = CheckAccess (objLOGFileHandle) 
      If boolCheckAccess = True And boolForce = False Then
         ErrorHandler objLOGFileHandle, "Main", "User '" & RunTimeEnvironmentInfo.DomainName & "\" & RunTimeEnvironmentInfo.UserName & "' does not have enough privileges to run WMIDiag!", True, Err

         DumpCSV "True", "NoPrivilege", 1, True
         DumpCSV " ", " ", cMaxCSVFields - 30, True

         If boolSilent = False Then
            If RunTimeEnvironmentInfo.OSIdentifier >= cWindowsVistaRTM Then
               intRC = objWSHShell.Popup ("User '" & RunTimeEnvironmentInfo.DomainName & "\" & RunTimeEnvironmentInfo.UserName & "' does not have enough privileges to run WMIDiag." & vbCRLF & vbCRLF & _
                                          "Under Windows Vista, running as a User Account Control (UAC) user, is not sufficient." & vbCRLF & "You must be ELEVATED or a FULL Administrator of the computer!", _
                                          cPopupTimeout, _
                                          "(WMIDiag " & cWMIDiagVersion & ") Information", _
                                          vbExclamation Or vbOkOnly)
            Else
               intRC = objWSHShell.Popup ("User '" & RunTimeEnvironmentInfo.DomainName & "\" & RunTimeEnvironmentInfo.UserName & "' does not have enough privileges to run WMIDiag." & vbCRLF & vbCRLF & _
                                          "You must be a FULL Administrator of the computer!", _
                                          cPopupTimeout, _
                                          "(WMIDiag " & cWMIDiagVersion & ") Information", _
                                          vbExclamation Or vbOkOnly)
            End If
         End If  

         intWMICriticalityLevel = 4
      Else 
         DumpCSV "False", "NoPrivilege", 1, True

         If RunTimeEnvironmentInfo.IsWow64 = True Then
            ErrorHandler objLOGFileHandle, "Main", "WMIDiag must be run from native 64-bit environment. It is not supported in Wow64.", True, Err
            DumpCSV " ", " ", cMaxCSVFields - 30, True

            If boolSilent = False Then
               intRC = objWSHShell.Popup ("WMIDiag must be run from native 64-bit environment. It is not supported in Wow64.", _
                                          cPopupTimeout, _
                                          "(WMIDiag " & cWMIDiagVersion & ") Information", _
                                          vbExclamation Or vbOkOnly)
            End If   

            intWMICriticalityLevel = 4
         Else
            DumpCSV strBasenamespace, "BaseNamespace", 1, True

            boolRC = CheckEnvironment (objLOGFileHandle)
            
            ' ----------------------------------------------commenting checking files-------------------------------------------------

            ' boolRC = CheckFilesPresence (objLOGFileHandle)

            ' boolRC = CheckWMISystemFilesPresence (objLOGFileHandle)

            ' boolRC = CheckWMIRepositoryFiles (objLOGFileHandle, "BEFORE")

            ' boolRC = CheckAdditionalBinaryInWBEMFolder (objLOGFileHandle)
  
            boolRC = CheckMOFFilesPresence (objLOGFileHandle)

            boolRC = LocateNoPragmaAutorecoverMOFFile (objLOGFileHandle)

            boolRC = CheckDCOMConfiguration (objLOGFileHandle)
  
            boolRC = CheckWMIDCOMComponentRegistrations (objLOGFileHandle)

            If boolADsSecurity = True Then
               boolRC = CheckWMIDCOMComponentSecurity (objLOGFileHandle)
            End If 

            boolRC = CheckWMIProgID (objLOGFileHandle)
   
            If RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP2 Or _
               RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP164 Or _
               RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP3 Or _
               RunTimeEnvironmentInfo.OSIdentifier >= cWindows2003SP1 Then
               boolRC = CheckWindowsFWSettings (objLOGFileHandle)
            Else
               WriteToLogFile objLOGFileHandle, "FW/ICS service is NOT INSTALLED.", cLoggingLevel3, False
               TrackingData.FirewallStatus = AddTrackingData (TrackingData.FirewallStatus, "FWNOTINSTALLED")
            End If

            boolRC = CheckWMISettings (objLOGFileHandle) 
   
            boolRC = CheckWMIServiceSetup (objLOGFileHandle) 
      
            boolRC = CheckWMIServiceDependent (objLOGFileHandle)
   
            boolRC = StartService (objLOGFileHandle, "RPCSS")   
            boolRC = StartService (objLOGFileHandle, "WINMGMT")
   
            boolRC = CheckWMIRepositoryConsistency (objLOGFileHandle) 
   
            If boolWriteInRepository = True And boolWriteInExistingNS = False Then
               If intFreeSpace > 104857600 Then
                  WriteToLogFile objLOGFileHandle, "Enough disk space available to perform the 'WriteInRepository' operation (" & Round (intFreeSpace / (1024^2)) & " MB left)." , cLoggingLevel0, False
                  boolRC = WriteInRepository (objLOGFileHandle, strWriteInRepository, True)
               Else
                  boolWriteInRepository = False
                  ErrorHandler objLOGFileHandle, "Main", "Not enough disk space available to perform the 'WriteInRepository' operation (" & Round (intFreeSpace / (1024^2)) & " MB left).", True, Err
               End If
            End If

            boolRC = GetLoadedProviders (objLOGFileHandle, "BEFORE")

            boolRC = CheckWMIStaticData (objLOGFileHandle, strBaseNamespace, 1)

            If boolWriteInRepository = True And boolWriteOperationCompleted = True And boolWriteInExistingNS = False Then
               boolRC = WriteInRepository (objLOGFileHandle, strWriteInRepository, False)
            End If

            boolRC = GetADAPStatus (objLOGFileHandle)
   
            boolRC = CheckWMIFeatures (objLOGFileHandle, arrayWMITestList, "Verifying WMI features.")

            boolRC = CheckSMSWMISetup (objLOGFileHandle)

            boolRC = CheckWMIInventory (objLOGFileHandle)

            boolRC = GetLoadedProviders (objLOGFileHandle, "AFTER")

            boolRC = CheckWMIRepositoryFiles (objLOGFileHandle, "AFTER")

            WriteToLogFile objLOGFileHandle, "WMIDiag v" & cWMIDiagVersion & " completed.", cLoggingLevel0, False

            AnalyzeDiagnostic objLOGFileHandle, True
         End If
      End If
   End If
End If
   
TerminateWMIDiag objLOGFileHandle
   
Set objStdOut = Nothing
set objShell = Nothing
Set objWshNetwork = Nothing
Set objWshShell = Nothing
Set objFS = Nothing
Set objWMILocator = Nothing

ExitWMIDiag (intWMICriticalityLevel)

' --------------------------------------------------------------------------------------------------------
Function TerminateWMIDiag (ByVal objLOGFileHandle)

         Dim intExecutionTime, intCounter
         Dim objFolder, objFiles, objFile
         Dim strWMIStatusMessage, intWMIStatusPrompt, intWMIStatusID
         Dim boolEchoSavedState
         Dim strMessage, arrayFilenames
         Dim strLOGComputerName, strLOGFileNameForDeletion, intNumberOfDays

         On Error Resume Next

         Select Case intWMICriticalityLevel
                Case cLoggingLevel0
                     strWMIStatusMessage = "SUCCESS:@WMIDiag determined that WMI works CORRECTLY."
                     intWMIStatusPrompt = vbInformation
                     intWMIStatusID = intWMICriticalityLevel
                Case cLoggingLevel1
                     strWMIStatusMessage = "ERROR:@WMIDiag detected issues that could prevent WMI to work properly!.@@Check '" & strFilePath & strLOGFileName & "' for details."
                     intWMIStatusPrompt = vbCritical
                     intWMIStatusID = intWMICriticalityLevel
                Case cLoggingLevel2
                     strWMIStatusMessage = "WARNING:@WMIDiag determined that WMI works CORRECTLY.@@HOWEVER, some issues were detected.@@Check '" & strFilePath & strLOGFileName & "' for details."
                     intWMIStatusPrompt = vbExclamation
                     intWMIStatusID = intWMICriticalityLevel
                Case Else
                     strWMIStatusMessage = "ABORT:@WMIDiag execution aborted.@@Check '" & strFilePath & strLOGFileName & "' for details."
                     intWMIStatusPrompt = vbInformation
                     intWMIStatusID = 0
         End Select

         If boolLogWMIState = True Then objWshShell.LogEvent intWMIStatusID, ReplaceString (strWMIStatusMessage, "@", vbCRLF)

         WriteToLogFile objLOGFileHandle, ReplaceString (strWMIStatusMessage, "@", " "), cLoggingLevel0, False
         WriteToLogFile objLOGFileHandle, "", cLoggingLevel0, False

         DumpCSV Month (Date) & "/" & Day (Date) & "/" & Year (Date), "Date", 1, True
         DumpCSV Time, "Time", 1, True

         DumpCSV longInProcWMIProvider, "InProcWMIProvider", 1, True
         DumpCSV longOutOfProcWMIProvider, "OutOfProcWMIProvider", 1, True
         DumpCSV longDecoupledWMIProvider, "DecoupledWMIProvider", 1, True

         If intOldestWMIDIAGLogHistory > 0 And intWMICriticalityLevel < 3 Then 
            WriteToLogFile objLOGFileHandle, "Deleting WMIDiag files older than " & intOldestWMIDIAGLogHistory & " day(s).", cLoggingLevel0, False

            Set objFolder = objFS.GetFolder (strFilePath)
            If Err.Number Then
               ErrorHandler objLOGFileHandle, "TerminateWMIDiag", "", False, Err
            Else
               intCounter = 0
               Set objFiles = objFolder.Files
               For Each objFile In objFiles
                   strLOGFileNameForDeletion = Ucase (objFile.name)
                   If Left (strLOGFileNameForDeletion, 9) = "WMIDIAG-V" Then
                      WriteToLogFile objLOGFileHandle, "Verifying '" & strLOGFileNameForDeletion & "' for deletion ...", cLoggingDebug Or cLoggingLevel3, False

                      strLOGComputerName = UCase (Mid (strLOGFileNameForDeletion, 28 + Len (cWMIDiagVersion), Len (RunTimeEnvironmentInfo.LocalComputerName)))
                      WriteToLogFile objLOGFileHandle, "WMIDiag LOG computer name: '" & strLOGComputerName & "'.", cLoggingDebug Or cLoggingLevel4, False

                      If (strLOGComputerName = RunTimeEnvironmentInfo.LocalComputerName) Then
                         intNumberOfDays = DateDiff ("d", objFile.DateLastModified, Now())
                         WriteToLogFile objLOGFileHandle, "# of days since last modification: " & intNumberOfDays & " days.", cLoggingDebug Or cLoggingLevel4, False

                         If intNumberOfDays > intOldestWMIDIAGLogHistory Then
                            objFile.Delete 
                            If Err.Number Then
                               ErrorHandler objLOGFileHandle, "TerminateWMIDiag", "Unable to delete '" & strLOGFileNameForDeletion & "'.", False, Err
                            Else
                               intCounter = intCounter + 1
                               WriteToLogFile objLOGFileHandle, "'" & strLOGFileNameForDeletion & "' deleted.", cLoggingDebug Or cLoggingLevel4, False
                            End If
                         Else
                            WriteToLogFile objLOGFileHandle, "Skipping LOG file '" & strLOGFileNameForDeletion & "'.", cLoggingDebug Or cLoggingLevel4, False
                         End If 
                      Else
                         WriteToLogFile objLOGFileHandle, "Skipping computer '" & strLOGComputerName & "'.", cLoggingDebug Or cLoggingLevel4, False
                      End If 
                   End If
               Next
               Set objFiles = Nothing

               WriteToLogFile objLOGFileHandle, intCounter & " file(s) deleted.", cLoggingLevel0, False
               WriteToLogFile objLOGFileHandle, "", cLoggingLevel0, False
            End If 
         End If

         intExecutionTime = DateDiff ("s", strStartDateTime, Now())
         DumpCSV intExecutionTime, "ExecutionTime", 1, True

         If intExecutionTime > 300 Then 
            intExecutionTime = DateDiff ("n", strStartDateTime, Now()) & " minutes."
         Else
            intExecutionTime = intExecutionTime & " second(s)."
         End If

         If boolSMS = True Then
            CreateWMIDiagStatusMIF objLOGFileHandle, intWMICriticalityLevel, ReplaceString (strWMIStatusMessage, "@", " "), strStartDateTime, Now (), intExecutionTime
         End If 

         WriteToLogFile objLOGFileHandle, "WMIDiag executed in " & intExecutionTime, cLoggingLevel0, False

         DumpCSV longWarningCounter, "longWarningCounter", 1, True
         DumpCSV longErrorCounter, "longErrorCounter", 1, True
         DumpCSV intWMICriticalityLevel, "WMICriticalityLevel", 1, True
         DumpCSV strLOGFileName, "File://", 1, True
         DumpCSV strFilePath & strLOGFileName, "File://", 1, True

         WriteToFile objSTATFileHandle, strCSV
         WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, strCSV, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False

         strEnd = "WMIDiag v" & cWMIDiagVersion & " ended on " & FormatDateTime (Date, vbLongDate) & " at " & FormatDateTime (Time, vbShortTime) & " (W:" & longWarningCounter &" E:" & longErrorCounter & " S:" & intWMICriticalityLevel & ")."
         WriteToLogFile objLOGFileHandle, strEnd , cLoggingLevel0, False

         If boolLogWMIState = True Then objWshShell.LogEvent 0, "WMIDIAG END: " & strEnd 

         boolEchoSavedState = boolNoEcho 
         boolNoEcho = True
         WriteToLogFile objDIAGFileHandle, strStart, cLoggingLevel0, False
         MSDisclaimer (objDIAGFileHandle)
         ReDim WBEMError (0)
         Set WBEMError (0) = new ClassWBEMError
         WBEMError (0).WBEMCounter = 0
         AnalyzeDiagnostic objDIAGFileHandle, False
         WriteToLogFile objDIAGFileHandle, ReplaceString (strWMIStatusMessage, "@", " "), cLoggingLevel0, False
         WriteToLogFile objDIAGFileHandle, "", cLoggingLevel0, False
         WriteToLogFile objDIAGFileHandle, strEnd , cLoggingLevel0, False
         boolNoEcho = boolEchoSavedState

         If boolWTTLogging = True then
            TraceWTT2 strLOGFileName, Err, strWMIStatusMessage, intWMIStatusID
            EndWTTTest strLOGFileName, intWMIStatusID
            CloseWTTLogDevice()   
         End If

         If boolCorrelateClassAndProvider = True Then
            WriteToLogFile objLOGFileHandle, "CSV file " & Chr(34) & strFilePath & strWMIProvFileName & Chr(34) & " closed.", cLoggingLevel0, False
            CloseTextFile (objWMIProvFileHandle)
         End If

         WriteToLogFile objLOGFileHandle, "TXT file " & Chr(34) & strFilePath & strDIAGFileName & Chr(34) & " closed.", cLoggingLevel0, False
         CloseTextFile (objDIAGFileHandle)

         WriteToLogFile objLOGFileHandle, "CSV file " & Chr(34) & strFilePath & strSTATFileName & Chr(34) & " closed.", cLoggingLevel0, False
         CloseTextFile (objSTATFileHandle)

         WriteToLogFile objLOGFileHandle, "LOG file " & Chr(34) & strFilePath & strLOGFileName & Chr(34) & " closed.", cLoggingLevel0, False
         CloseTextFile (objLOGFileHandle)

         If boolCorrelateClassAndProvider = False Then
            strMessage = "Find the WMI REPORT, the activity LOG and 1 CSV for " & strFilename & " as attachments"
            arrayFilenames = Array (chr (34) & strFilePath & strDIAGFileName & chr (34), chr (34) & strFilePath & strLOGFileName & chr (34), chr (34) & strFilePath & strSTATFileName & chr (34))
         Else
            strMessage = "Find the WMI REPORT, the activity LOG and 2 CSV for " & strFilename & " as attachments"
            arrayFilenames = Array (chr (34) & strFilePath & strDIAGFileName & chr (34), chr (34) & strFilePath & strLOGFileName & chr (34), chr (34) & strFilePath & strSTATFileName & chr (34), chr (34) & strFilePath & strWMIProvFileName & chr (34))
         End If

         If Len (RunTimeEnvironmentInfo.WinZIP) > 0 And boolNoWinZIP = False Then
            WriteToLogFile Null, "Zipping WMIDiag information to '" & strFilePath & strFilename & ".ZIP'.", cLoggingLevel0, False

            objWSHShell.Run RunTimeEnvironmentInfo.WinZIP & " -min -a " & chr (34) & strFilePath & strFilename & ".ZIP" & chr (34) & " " & ConvertArrayInString (arrayFilenames, " "),, True

            If objFS.FileExists (strFilePath & strFilename & ".ZIP") = True Then
               arrayFilenames = Array (strFilePath & strFilename & ".ZIP")
            Else
               WriteToLogFile Null, "Failed to create ZIP file '" & strFilePath & strFilename & ".ZIP'.", cLoggingLevel2, False
            End If 
         End If

         If boolSMTPWMIInvalidState = True Then
            If intWMICriticalityLevel <> 0 Then
               If Len (strSMTPServer) > 0 Then
                  SendMessage strSMTPTo, _
                              strSMTPFrom, _
                              strFilename, _
                              strMessage, _
                              "", _
                              arrayFilenames
               End If
            End If
         Else
            If Len (strSMTPServer) > 0 Then
               SendMessage strSMTPTo, _
                           strSMTPFrom, _
                           strFilename, _
                           strMessage, _
                           "", _
                           arrayFilenames
            End If
         End If

         If boolCheckAccess = False And RunTimeEnvironmentInfo.IsWow64 = False And intWMICriticalityLevel > 0 And intWMICriticalityLevel < 3 Then 
            If boolSilent = False Then
               objWSHShell.Run "NOTEPAD.EXE " & chr(34) & strFilePath & strDIAGFileName & chr(34)
            End If 
         End If 

         If boolCheckAccess = False And RunTimeEnvironmentInfo.IsWow64 = False Then 
            If boolSilent = False Then 
               objWSHShell.Popup ReplaceString (strWMIStatusMessage, "@", vbCRLF), cPopupTimeout, "(WMIDiag " & cWMIDiagVersion & ") Information", intWMIStatusPrompt or vbOkOnly
            End If
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function ExitWMIDiag (ByVal intExitCode)

         On Error Resume Next

         If boolSMS = True Then
            WScript.Quit (0)
         Else
            WScript.Quit (intExitCode)
         End If 

End Function

' --------------------------------------------------------------------------------------------------------
Function MSDisclaimer (ByVal objFileHandle)

         On Error Resume Next

         WriteToLogFile objFileHandle, "", cLoggingLevel0, False
         WriteToLogFile objFileHandle, "Copyright (c) Microsoft Corporation. All rights reserved - " & cMonth & ".", cLoggingLevel0, False
         WriteToLogFile objFileHandle, "", cLoggingLevel0, False
         WriteToLogFile objFileHandle, "This script is not supported under any Microsoft standard support program or service.", cLoggingLevel0, False
         WriteToLogFile objFileHandle, "The script is provided AS IS without warranty of any kind. Microsoft further disclaims all", cLoggingLevel0, False
         WriteToLogFile objFileHandle, "implied warranties including, without limitation, any implied warranties of merchantability", cLoggingLevel0, False
         WriteToLogFile objFileHandle, "or of fitness for a particular purpose. The entire risk arising out of the use or performance", cLoggingLevel0, False
         WriteToLogFile objFileHandle, "of the scripts and documentation remains with you. In no event shall Microsoft, its authors,", cLoggingLevel0, False
         WriteToLogFile objFileHandle, "or anyone else involved in the creation, production, or delivery of the script be liable for", cLoggingLevel0, False
         WriteToLogFile objFileHandle, "any damages whatsoever (including, without limitation, damages for loss of business profits,", cLoggingLevel0, False
         WriteToLogFile objFileHandle, "business interruption, loss of business information, or other pecuniary loss) arising out of", cLoggingLevel0, False
         WriteToLogFile objFileHandle, "the use of or inability to use the script or documentation, even if Microsoft has been advised", cLoggingLevel0, False
         WriteToLogFile objFileHandle, "of the possibility of such damages.", cLoggingLevel0, False
         WriteToLogFile objFileHandle, "", cLoggingLevel0, False

End Function

' --------------------------------------------------------------------------------------------------------
Function CreateWMIDiagStatusMIF (ByVal objLOGFileHandle, ByVal intWMICriticalityLevel, ByVal strWMIStatusMessage, _
                                 ByVal strStartDateTime, ByVal strEndTime, ByVal intExecutionTime)

         Dim objMIFFileHandle  

         On Error Resume Next

         ' WriteToLogFile objLOGFileHandle, "SMS is enabled. Reporting results in an SMS MIF file.", cLoggingLevel0, False

         ' Set objMIFFileHandle = CreateTextFile (strFilePath & strMIFFileName)
         ' If IsNull (objLOGFileHandle) = True Then 
         '    Err.Clear
         '    ErrorHandler objLOGFileHandle, "CreateWMIDiagStatusMIF", "MIF file " & Chr(34) & strFilePath & strLOGFileName & Chr(34) & " CANNOT be created.", True, Err
         '    CreateWMIDiagStatusMIF = True
         ' End If
         ' WriteToLogFile objLOGFileHandle, "MIF file " & Chr(34) & strFilePath & strLOGFileName & Chr(34) & " created.", cLoggingLevel0, False
 
         ' WriteToLogFile objLOGFileHandle, "MIF file " & Chr(34) & strFilePath & strMIFFileName & Chr(34) & " closed.", cLoggingLevel0, False
         ' CloseTextFile (objMIFFileHandle)

         ' CreateWMIDiagStatusMIF = False
	
End Function

' --------------------------------------------------------------------------------------------------------
Function Help ()

         On Error Resume Next

         If boolNoEcho = True Then
            objWSHShell.Popup "WMIDiag  [NoEcho] [NoWinZIP] [Silent] [RunOnce] [Force] [SMS] [OldestLogHistory=1-365] [Depth=1|2|3|4|...]" & vbCRLF & _
                              "                [OldestEVENTLogHistory] [RequestAllInstances[=Static|Dynamic|StaticAndDynamic]]" & vbCRLF & _
                              "                [WriteInRepository[=Root\XYZ]] [CheckConsistency] [ShowLoadedProviders]" & vbCRLF & _
                              "                [BaseNameSpace=Root\XYZ] [LoggingLevel=n] [ShowMOFErrors] [CorrelateClassAndProvider]" & vbCRLF & _ 
                              "                [LogFilePath=<FolderPath>] [LogNTEvents] [LogNTEventErrors] [LogWMIState] [ErrorPopup]" & vbCRLF & _ 
                              "                [SmtpServer] [SmtpPort] [SmtpAuthenticate] [SmtpSSL]" & vbCRLF & _ 
                              "                [SmtpUsername] [SmtpPassword] [SmtpFrom] [SmtpTo] [SmtpWMIInvalidState] [SmtpTest]" & vbCRLF & vbCRLF & _ 
                              "Where:" & vbCRLF & vbCRLF & _
                              "NoEcho: Disables local console echo of WMIDiag activities (default=" & cNoEcho & ")" & vbCRLF & _
                              "NoWinZIP: Disables automatic compression of the WMI generated files in a ZIP file (default=" & cNoWinZIP & ")" & vbCRLF & _
                              "Silent: Prevents any Window prompts to appear except help (default=" & cSilent & ")" & vbCRLF & _
                              "SMS: Turns off the ERRORLEVEL return code and active NoEcho and Silent (default=" & cSMS & ")" & vbCRLF & _
                              "RunOnce: Prevents WMIDiag to run more than once a day (default=" & cRunOnce & ")" & vbCRLF & _
                              "OldestLogHistory: Deletes WMIDiag files older than the specified # of days (default=False)" & vbCRLF & _
                              "OldestEVENTLogHistory: Retrieves Event Log events older than the specified # of days (default=" & cOldestEVENTLogHistory & ")" & vbCRLF & _
                              "Force: Forces WMIDiag to run even if you are not a FULL aministrator (default=" & cForce & ")" & vbCRLF & _
                              "Depth: Defines the class hierarchy depth to examine (default=" & cMaxSubClassExaminationDepth & ")" & vbCRLF & _
                              "RequestAllInstances: Requests WMIDiag to retrieve all instances from STATIC and/or DYNAMIC classes (default=False)" & vbCRLF & _
                              "WriteInRepository: Requests WMIDiag to write non-destructive information temporarly in the WMI repository for testing purposes (default=" & cWriteInRepository & ")" & vbCRLF & _
                              "CheckConsistency: Executes Windows XP SP2 RUNDLL32 command to validate the WMI repository consistency (default=" & cCheckConsistency & ")" & vbCRLF & _
                              "BaseNamespace: Defines the WMI namespace to start the test from (default=" & cBaseNS & ")" & vbCRLF & _
                              "LoggingLevel: Defines the verbose of the logging level (default=" & cLoggingLevel0 & ")" & vbCRLF & _
                              "ShowMOFErrors: Displays detected MOF errors (default=" & cShowMOFErrors & ")" & vbCRLF & _
                              "ShowLoadedProviders: Displays information about the WMI providers currently loaded by the system (default=" & cShowLoadedProviders & ")" & vbCRLF & _
                              "CorrelateClassAndProvider: Creates a CSV listing the data correlation between classes, WMI providers and MOF files (default=" & boolCorrelateClassAndProvider & ")" & vbCRLF & vbCRLF & _
                              "LogFilePath: Defines the path where the WMIDiag files must be created (default=" & RunTimeEnvironmentInfo.UserTemp & ")" & vbCRLF & _
                              "LogNTEvents: Enables logging of WMIDiag messages in the application event log (default=" & cEventLog & ")" & vbCRLF & _
                              "LogNTEventErrors: Enables logging of WMIDiag error messages in the application event log (default=" & cEventLogErrors & ")" & vbCRLF & _
                              "LogWMIState: Creates an event log entry in the NT Event Log (Success, Warning or Error) to reflect the current WMI status (default=" & cLogWMIState & ")" & vbCRLF & _
                              "ErrorPopup: Enables the display of all error messages as popups (default=" & cErrorPopup & ")" & vbCRLF & vbCRLF & _
                              "SmtpServer: Defines the SMTP relay server address. By specifying this address YOU CONSENT to send information externally (no default)" & vbCRLF & _
                              "                     WARNING: By specifying this address you consent to information externally!" & vbCRLF & _
                              "SmtpPort: Defines the SMTP port number (default=" & cSMTPPort & ")" & vbCRLF & _
                              "SmtpAuthenticate: Defines the authentication mechanism. It could be [Anonymous] [Basic] [Ntlm] (default=" & cSMTPAuthenticate & ")" & vbCRLF & _ 
                              "SmtpSSL: Enables SSL to communicate with the SMTP relay (default=" & cSMTPSSL & ")" & vbCRLF & _
                              "SmtpUsername: Specifies the username to connect to the SMTP relay (default=" & cSMTPusername & ")" & vbCRLF & _ 
                              "SmtpPassword: Specifies the password to connect to the SMTP relay (default=" & cSMTPPassword & ")" & vbCRLF & _
                              "SmtpFrom: Specifies the SMTP source address (mandatory if SMTP server is mentioned)" & vbCRLF & _
                              "SmtpTo: Specifies the SMTP target address (default=" & cSMTPTo & ")" & vbCRLF & _
                              "SmtpWMIInvalidState: Sends an email only when the WMI state is reported as WARNING or ERROR (default=" & cSMTPWMIInvalidState & ")" & vbCRLF & _
                              "SmtpTest: Enables the test of the SMTP parameters. No WMIDiag tests are executed with this parameter (default=" & cSMTPTest & ")", _
                              0, _
                              "(WMIDiag " & cWMIDiagVersion & ") Information", _
                              vbInformation Or vbOkOnly
         Else
            WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "(WMIDiag " & cWMIDiagVersion & ") Help", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "WMIDiag [NoEcho] [NoWinZIP] [Silent] [RunOnce] [Force] [SMS] [OldestLogHistory=1-365] [Depth=1|2|3|4|...]", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "        [OldestEVENTLogHistory] [RequestAllInstances[=Static|Dynamic|StaticAndDynamic]]", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "        [WriteInRepository[=Root\XYZ]] [CheckConsistency] [ShowLoadedProviders]", cLoggingLevel3, True 
            WriteToLogFile objLOGFileHandle, "        [BaseNameSpace=Root\XYZ] [LoggingLevel=n] [ShowMOFErrors] [CorrelateClassAndProvider]", cLoggingLevel3, True 
            WriteToLogFile objLOGFileHandle, "        [LogFilePath=<FolderPath>] [LogNTEvents] [LogNTEventErrors] [LogWMIState] [ErrorPopup]", cLoggingLevel3, True 
            WriteToLogFile objLOGFileHandle, "        [SmtpServer=x.y.z] [SmtpPort=nn] [SmtpAuthenticate=<AuthLevel>] [SmtpSSL]", cLoggingLevel3, True 
            WriteToLogFile objLOGFileHandle, "        [SmtpUsername=<UserName>] [SmtpPassword=<Password>]", cLoggingLevel3, True 
            WriteToLogFile objLOGFileHandle, "        [SmtpFrom=<source@domain.com>] [SmtpTo=<target@domain.com>] [SmtpWMIInvalidState] [SmtpTest]", cLoggingLevel3, True  
            WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "Where:", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  NoEcho                     Disables local console echo of WMIDiag activities (default=" & cNoEcho & ")", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  NoWinZIP                   Disables automatic compression of the WMI generated files in a ZIP file (default=" & cNoWinZIP & ")", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  Silent                     Prevents any Window prompts to appear except help (default=" & cSilent & ")", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  RunOnce                    Prevents WMIDiag to run more than once a day (default=" & cRunOnce & ")", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  SMS                        Turns off the ERRORLEVEL return code and active NoEcho and Silent (default=" & cSMS & ")", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  OldestLogHistory           Deletes WMIDiag files older than the specified # of days (default=False)", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  OldestEventLogHistory      Retrieves Event Log events older than the specified # of days (default=" & cOldestEVENTLogHistory & ")", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  Force                      Forces WMIDiag to run even if you are not a FULL aministrator (default=" & cForce & ")", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  Depth                      Defines the class hierarchy depth to examine (default=" & cMaxSubClassExaminationDepth & ")", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  RequestAllInstances        Requests WMIDiag to retrieve all instances from STATIC and/or DYNAMIC classes (default=False)", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  WriteInRepository          Requests WMIDiag to write non-destructive information temporarly in the WMI repository for testing purposes (default=" & cWriteInRepository & ")", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  CheckConsistency           Executes Windows XP SP2 RUNDLL32 command to validate the WMI repository consistency (default=" & cCheckConsistency & ")", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  BaseNamespace              Defines the WMI namespace to start the test from (default=" & cBaseNS & ")", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  LoggingLevel               Defines the verbose of the logging level (default=" & cLoggingLevel0 & ")", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  CorrelateClassAndProvider  Creates a CSV listing the data correlation between classes, WMI providers and MOF files (default=" & boolCorrelateClassAndProvider & ")", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  ShowMOFErrors              Displays detected MOF errors (default=" & cShowMOFErrors & ")", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  ShowLoadedProviders        Displays information about the WMI providers currently loaded by the system (default=" & cShowLoadedProviders & ")", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  LogFilePath                Defines the path where the WMIDiag files must be created (default=" & RunTimeEnvironmentInfo.UserTemp & ")", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  LogNTEvents                Enables logging of WMIDiag messages in the application event log (default=" & cEventLog & ")", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  LogNTEventErrors           Enables logging of WMIDiag error messages in the application event log (default=" & cEventLogErrors & ")", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  LogWMIState                Creates an event log entry in the NT Event Log (Success, Warning or Error) to reflect the current WMI status (default=" & cLogWMIState & ")", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  ErrorPopup                 Enables the display of all error messages as popups (default=" & cErrorPopup & ")", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  SmtpServer                 Defines the SMTP relay server address (no default)", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "                             WARNING: By specifying this address YOU CONSENT to send information externally!", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  SmtpPort                   Defines the SMTP port number (default=" & cSMTPPort & ")", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  SmtpAuthenticate           Defines the authentication mechanism. It could be [Anonymous] [Basic] [Ntlm] (default=Ntlm)", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  SmtpSSL                    Enables SSL to communicate with the SMTP relay (default=" & cSMTPSSL & ")", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  SmtpUsername               Specifies the username to connect to the SMTP relay (no default)", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  SmtpPassword               Specifies the password to connect to the SMTP relay (no default)", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  SmtpFrom                   Specifies the SMTP source address (mandatory if SMTP server is mentioned)", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  SmtpTo                     Specifies the SMTP target address (default=" & cSMTPTo & ")", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  SmtpWMIInvalidState        Sends an email only when the WMI state is reported as WARNING or ERROR (default=" & cSMTPWMIInvalidState & ")", cLoggingLevel3, True
            WriteToLogFile objLOGFileHandle, "  SmtpTest                   Enables the test of the SMTP parameters. No WMIDiag tests are executed with this parameter (default=" & cSMTPTest & ")", cLoggingLevel3, True
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckAccess (ByVal objLOGFileHandle)

         Dim strTemp, arrayOutput, arrayMatchingOutput
         Dim arrayRegistryValue

         On Error Resume Next

         If RunTimeEnvironmentInfo.OSIdentifier >= cWindowsVistaRTM Then
            CheckAccess = False
         Else
            arrayRegistryValue = ReadRegistry (objLOGFileHandle, "HKLM\SYSTEM\CurrentControlSet\Services\winmgmt\Security", _
                                               "Security", _
                                               "REG_BINARY", _
                                               False)

            If Not IsArray (arrayRegistryValue) Then
               CheckAccess = True
            Else
               CheckAccess = False
            End If
         End If

         If RunTimeEnvironmentInfo.OSIdentifier >= cWindows2003RTM Then
            boolRC = ShellExecute (objLOGFileHandle, "WHOAMI.EXE /Priv", "", arrayOutput, arrayMatchingOutput)
            If boolRC = False And IsArray (arrayOutput) = True Then
               WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False
               WriteToLogFile objLOGFileHandle, UBound (arrayOutput) & " privilege(s):", cLoggingLevel3, False
               For Each strTemp In arrayOutput 
                   If Len (strTemp) > 0 Then
                      WriteToLogFile objLOGFileHandle, CleanString (strTemp, 32, 255), cLoggingLevel3, False
                   End If 
               Next 
            End If
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckLastRun (ByVal objLOGFileHandle)

         Dim strLastRun, strNow

         On Error Resume Next

         WriteToLogFile objLOGFileHandle, "Verifying last run of WMIDiag.", cLoggingLevel0, False

         strNow = Month (Date) & "/" & Day (Date) & "/" & Year (Date) & " " & Time

         CheckLastRun = False

         strLastRun = ReadRegistry (objLOGFileHandle, "HKLM\Software\Microsoft\WMIDiag", _
                                                      "LastRun", _
                                                      "REG_SZ", _
                                                      False)
         If Not IsArray (strLastRun) Then
            WriteRegistry objLOGFileHandle, "HKLM\Software\Microsoft\WMIDiag", _
                                            "LastRun", "REG_SZ", _
                                            strNow, _
                                            True
            DumpCSV strNow, "LastRun", 1, True
         Else
            WriteToLogFile objLOGFileHandle, "WMIDiag last run is " & strLastRun (0) & ".", cLoggingLevel0, False
            DumpCSV strLastRun (0), "LastRun", 1, True

            If DateDiff ("d", strLastRun (0), Now()) = 0 Then
               If boolRunOnce = True Then
                  WriteToLogFile objLOGFileHandle, "WMIDiag already started today.", cLoggingLevel1, True
                  CheckLastRun = True
               Else
                  WriteToLogFile objLOGFileHandle, "WMIDiag already started today.", cLoggingLevel2, False

                  WriteRegistry objLOGFileHandle, "HKLM\Software\Microsoft\WMIDiag", _
                                                  "LastRun", "REG_SZ", _
                                                  strNow, _
                                                  True
                  CheckLastRun = False
               End If
            Else
               WriteRegistry objLOGFileHandle, "HKLM\Software\Microsoft\WMIDiag", _
                                               "LastRun", "REG_SZ", _
                                               strNow, _
                                               True
            End If
	End If

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckWMIRepositoryFiles (ByVal objLOGFileHandle, ByVal strBeforeAfter)

         Dim intFileIndex, objFolder, objFile
         Dim strDrive, objDrive, strVolume
 
         On Error Resume Next
 
         WriteToLogFile objLOGFileHandle, "Verifying WMI Repository files presence.", cLoggingLevel0, False
 
         CheckWMIRepositoryFiles = False
 
         strDrive = objFS.GetDriveName (RunTimeEnvironmentInfo.WBem & arrayWMIRepositoryFiles (0))
         Set objDrive = objFS.GetDrive (strDrive)
         strVolume = objDrive.VolumeName
         intFreeSpace = objDrive.FreeSpace
 
         Set objFolder = objFS.GetFolder (RunTimeEnvironmentInfo.WBem & arrayWMIRepositoryFiles (0))
         If Err.Number Then
            CheckWMIRepositoryFiles = ErrorHandler (objLOGFileHandle, "CheckWMIRepositoryFiles", "Folder '" & RunTimeEnvironmentInfo.WBem & arrayWMIRepositoryFiles (0) & "' is missing or is access denied.", False, Err)
            TrackingData.RepositoryFileSizes = AddTrackingData (TrackingData.RepositoryFileSizes, "FOLDERSIZE" & strBeforeAfter & ";" & arrayWMIRepositoryFiles (0) & ";MISSING;DENIED;")
         Else
            WriteToLogFile objLOGFileHandle, "'" & RunTimeEnvironmentInfo.WBem & arrayWMIRepositoryFiles (0) & "' has a size of " & objFolder.Size & " bytes.", cLoggingLevel3, False
            TrackingData.RepositoryFileSizes = AddTrackingData (TrackingData.RepositoryFileSizes, "FOLDERSIZE" & strBeforeAfter & ";" & arrayWMIRepositoryFiles (0) & ";" & objFolder.Size & ";;")
         End If
 
         TrackingData.RepositoryFileSizes = AddTrackingData (TrackingData.RepositoryFileSizes, "FREESPACE" & strBeforeAfter & ";" & strDrive & ";" & strVolume & ";" & intFreeSpace & ";")
 
         For intFileIndex = 1 To UBound (arrayWMIRepositoryFiles)
             If Not CheckIfFileExists (objLOGFileHandle, RunTimeEnvironmentInfo.WBem & arrayWMIRepositoryFiles (0) & "\" & arrayWMIRepositoryFiles (intFileIndex)) Then
                WriteToLogFile objLOGFileHandle, "Unable to access or find file '" & UCase (arrayWMIRepositoryFiles (intFileIndex)) & "'.", cLoggingLevel1, False
                If Instr (TrackingData.MissingRepositoryFiles, arrayWMIRepositoryFiles (intFileIndex)) = 0 Then
                   TrackingData.MissingRepositoryFiles = AddTrackingData (TrackingData.MissingRepositoryFiles, arrayWMIRepositoryFiles (intFileIndex))
                End If
                CheckWMIRepositoryFiles = True
             Else
                Set objFile = objFS.GetFile (RunTimeEnvironmentInfo.WBem & arrayWMIRepositoryFiles (0) & "\" & arrayWMIRepositoryFiles (intFileIndex))
                WriteToLogFile objLOGFileHandle, "'" & objFile.Name & "' has a size of " & objFile.Size & " bytes (" & _
                                         "Created: " & objFile.DateCreated & _
                                         ", Last Accessed: " & objFile.DateLastAccessed & _
                                         ", Last Modified: " & objFile.DateLastModified & ").", _
                                         cLoggingLevel3, False
                TrackingData.RepositoryFileSizes = AddTrackingData (TrackingData.RepositoryFileSizes, UCase (objFile.Name) & ";" & objFile.Size & ";" & objFile.DateCreated & ";" & objFile.DateLastAccessed & ";" & objFile.DateLastModified)
                Set objFile = Nothing
	     End If
         Next

         Set objFolder = Nothing

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckMOFFilesPresence (ByVal objLOGFileHandle)

         Dim arrayRegistryValue, intIndex
         Dim objFolder, objFiles, objFile
         Dim boolMOFFoundInAutoRecovery 
 
         On Error Resume Next
 
         ReDim arrayKnownMOFFiles(0)
 
         WriteToLogFile objLOGFileHandle, "Verifying Auto-Recovery MOF files presence.", cLoggingLevel0, False
 
         arrayRegistryValue = ReadRegistry (objLOGFileHandle, "HKLM\SOFTWARE\Microsoft\WBEM\CIMOM", _
                                            "Autorecover MOFs", _
                                            "REG_MULTI_SZ", _
                                            True)
 
         If Not IsArray (arrayRegistryValue) Then
            CheckMOFFilesPresence = ErrorHandler (objLOGFileHandle, "CheckMOFFilesPresence", "'Autorecover MOFs' registry key is missing or is access denied.", False, Err)
            TrackingData.AutoRecoveryMissingMOFFiles = AddTrackingData (TrackingData.AutoRecoveryMissingMOFFiles, "NOAUTORECOVERYKEY")
         Else 
            WriteToLogFile objLOGFileHandle, "Verifying MOF files in WBEM folder.", cLoggingLevel0, False
 
            Set objFolder = objFS.GetFolder (RunTimeEnvironmentInfo.WBem)
            If Err.Number Then 
               CheckMOFFilesPresence = ErrorHandler (objLOGFileHandle, "CheckMOFFilesPresence", "'" & RunTimeEnvironmentInfo.WBem & "' not found.", False, Err)
               TrackingData.AutoRecoveryMissingMOFFiles = AddTrackingData (TrackingData.AutoRecoveryMissingMOFFiles, strLastError & ";NOWBEMFOLDER")
               Exit Function
            End If
 
            Set objFiles = objFolder.Files
            If Err.Number Then 
               CheckMOFFilesPresence = ErrorHandler (objLOGFileHandle, "CheckMOFFilesPresence", "No file found in '" & RunTimeEnvironmentInfo.WBem & "'.", False, Err)
               TrackingData.AutoRecoveryMissingMOFFiles = AddTrackingData (TrackingData.AutoRecoveryMissingMOFFiles, strLastError & ";NOFILESINWBEMFOLDER")
               Exit Function
            End If
 
            If objFiles.Count = 0 Then 
               WriteToLogFile objLOGFileHandle, "No file found in '" & RunTimeEnvironmentInfo.WBem & "'.", cLoggingLevel1, False
               TrackingData.AutoRecoveryMissingMOFFiles = AddTrackingData (TrackingData.AutoRecoveryMissingMOFFiles, strLastError & ";NOFILESINWBEMFOLDER")
               CheckMOFFilesPresence = True
               Exit Function
            End If
 
            For Each objFile in objFiles
                If UCase (Right (objFile.Name, 4)) = ".MOF" Or UCase (Right (objFile.Name, 4)) = ".MFL" Then 
                   boolMOFFoundInAutoRecovery = False
                   For intIndex = 0 To UBound (arrayRegistryValue)
                       arrayRegistryValue (intIndex) = ReplaceString (arrayRegistryValue (intIndex), Chr(34), "")
                       If Ucase (objWshShell.ExpandEnvironmentStrings (RunTimeEnvironmentInfo.WBem & objFile.Name)) = Ucase (objWshShell.ExpandEnvironmentStrings (arrayRegistryValue(intIndex))) Then
                          boolMOFFoundInAutoRecovery = True
                       End If
                   Next
                   If boolMOFFoundInAutoRecovery = False Then 
                      arrayKnownMOFFiles (UBound(arrayKnownMOFFiles)) = Ucase (objWshShell.ExpandEnvironmentStrings (RunTimeEnvironmentInfo.WBem & objFile.Name))
  
                      If (ExceptionForNoAutoRecoveryWBEMMOFFiles (arrayKnownMOFFiles (UBound (arrayKnownMOFFiles))) = True) Then
                         WriteToLogFile objLOGFileHandle, "'" & arrayKnownMOFFiles (UBound(arrayKnownMOFFiles)) & "' does exist and is NOT LISTED BY DEFAULT in the 'Autorecover MOFs' registry key.", cLoggingLevel3, False
                         TrackingData.WBemFolderMOFFilesNotListedInAutoRecovery = AddTrackingData (TrackingData.WBemFolderMOFFilesNotListedInAutoRecovery, arrayKnownMOFFiles (UBound(arrayKnownMOFFiles)) & " (*)")
                      Else
                         WriteToLogFile objLOGFileHandle, "'" & arrayKnownMOFFiles (UBound(arrayKnownMOFFiles)) & "' does exist but it is NOT LISTED in the 'Autorecover MOFs' registry key.", cLoggingLevel2, False
                         TrackingData.WBemFolderMOFFilesNotListedInAutoRecovery = AddTrackingData (TrackingData.WBemFolderMOFFilesNotListedInAutoRecovery, arrayKnownMOFFiles (UBound(arrayKnownMOFFiles)))
                      End If
 
                      ReDim Preserve arrayKnownMOFFiles (UBound(arrayKnownMOFFiles) + 1) 
                   End If
                End If
            Next

            arrayKnownMOFFilesInAutoRecovery = arrayRegistryValue
 
            For intIndex = 0 To UBound (arrayRegistryValue)
                If Not CheckIfFileExists (objLOGFileHandle, arrayRegistryValue (intIndex)) Then
                   WriteToLogFile objLOGFileHandle, "Unable to access or find file '" & UCase (arrayRegistryValue (intIndex)) & "' listed in 'Autorecover MOFs'.", cLoggingLevel1, False
                   TrackingData.AutoRecoveryMissingMOFFiles = AddTrackingData (TrackingData.AutoRecoveryMissingMOFFiles, UCase (arrayRegistryValue (intIndex)))
                   CheckMOFFilesPresence = True
                Else
                   arrayKnownMOFFiles (UBound(arrayKnownMOFFiles)) = UCase (objWshShell.ExpandEnvironmentStrings (arrayRegistryValue (intIndex)))
 
                   WriteToLogFile objLOGFileHandle, "Found '" & UCase (arrayKnownMOFFiles (UBound(arrayKnownMOFFiles))) & "'.", cLoggingLevel3, False
 
                   ReDim Preserve arrayKnownMOFFiles (UBound(arrayKnownMOFFiles) + 1) 
                End If
            Next
         End If
 
End Function

' --------------------------------------------------------------------------------------------------------
Function CheckWindowsFWSettings (ByVal objLOGFileHandle)

         Dim objFW, objFWCurrentProfile, intCurrentProfileType, objFWApp, objFWApps
         Dim objFWPolicy, objFWRule, objFWRules, strFWRuleNames, intIndex
         Dim strFWSvc, strFWName
         Dim boolUnSecapp
         Dim arrayRegistryValue
 
         On Error Resume Next
 
         WriteToLogFile objLOGFileHandle, "Verifying Windows Firewall setup.", cLoggingLevel0, False
 
         CheckWindowsFWSettings = False

         If RunTimeEnvironmentInfo.OSIdentifier > cWindows2003SP264 Then
            strFWSvc = "MpsSvc"
            strFWName = "Windows Firewall"
         Else
            strFWSvc = "SharedAccess"
            strFWName = "FW/ICS"
         End If

         arrayRegistryValue = ReadRegistry (objLOGFileHandle, "HKLM\SYSTEM\CurrentControlSet\Services\" & strFWSvc, _
                                            "DisplayName", _
                                            "REG_SZ", _
                                            False)
 
         If IsArray (arrayRegistryValue) = True Then
            If Len (arrayRegistryValue (0)) > 0 Then
               If objShell.IsServiceRunning(strFWSvc) = False  Then
                  WriteToLogFile objLOGFileHandle, strFWName & " service is NOT running.", cLoggingLevel3, False
                  TrackingData.FirewallStatus = AddTrackingData (TrackingData.FirewallStatus, "FWSVCSTOPPED")
               Else 
                  WriteToLogFile objLOGFileHandle, strFWName & " service is running.", cLoggingLevel3, False

                  If RunTimeEnvironmentInfo.OSIdentifier > cWindows2003SP264 Then
                     Set objFWPolicy = CreateObject ("HNetCfg.FwPolicy2")

                     intCurrentProfileType = objFWPolicy.CurrentProfileTypes

                     Select Case intCurrentProfileType
                            Case NET_FW_PROFILE2_DOMAIN 
                                 WriteToLogFile objLOGFileHandle, "Current firewall profile is DOMAIN.", cLoggingLevel3, False
                                 TrackingData.FirewallStatus = AddTrackingData (TrackingData.FirewallStatus, "FWPROFILE=DOMAIN")
                            Case NET_FW_PROFILE2_PRIVATE 

                                 WriteToLogFile objLOGFileHandle, "Current firewall profile is PRIVATE.", cLoggingLevel3, False
                                 TrackingData.FirewallStatus = AddTrackingData (TrackingData.FirewallStatus, "FWPROFILE=PRIVATE")
                            Case NET_FW_PROFILE2_PUBLIC 

                                 WriteToLogFile objLOGFileHandle, "Current firewall profile is PUBLIC.", cLoggingLevel3, False
                                 TrackingData.FirewallStatus = AddTrackingData (TrackingData.FirewallStatus, "FWPROFILE=PUBLIC")
                            Case Else
                                 WriteToLogFile objLOGFileHandle, "Current firewall profile is #" & objFWPolicy.CurrentProfileTypes, cLoggingLevel1, False
                                 TrackingData.FirewallStatus = AddTrackingData (TrackingData.FirewallStatus, "FWPROFILE=UNKNOWN (" & objFWPolicy.CurrentProfileTypes & ")")
                     End Select

                     If objFWPolicy.FirewallEnabled (objFWPolicy.CurrentProfileTypes) = False Then
                        WriteToLogFile objLOGFileHandle, strFWName & " status is DISABLED.", cLoggingLevel3, False
                        TrackingData.FirewallStatus = AddTrackingData (TrackingData.FirewallStatus, "FWDISABLED")
                     Else
                        If objFWPolicy.BlockAllInboundTraffic (objFWPolicy.CurrentProfileTypes) = False Then
                           If objFWPolicy.DefaultInboundAction (objFWPolicy.CurrentProfileTypes) = NET_FW_ACTION_BLOCK Then
                              WriteToLogFile objLOGFileHandle, "- Inbound connections that do not match a rule are BLOCKED.", cLoggingLevel3, False
                              TrackingData.FirewallStatus = AddTrackingData (TrackingData.FirewallStatus, "FWNOINBOUND")
                           Else 
                              WriteToLogFile objLOGFileHandle, "- Inbound connections that do not match a rule are ALLOWED.", cLoggingLevel3, False
                           End If
                        Else 
                           WriteToLogFile objLOGFileHandle, "- All inbound exception rules are BLOCKED.", cLoggingLevel3, False
                           TrackingData.FirewallStatus = AddTrackingData (TrackingData.FirewallStatus, "FWNOEXCEPTION")
                        End If

                        If objFWPolicy.DefaultOutboundAction (objFWPolicy.CurrentProfileTypes) = False Then
                           WriteToLogFile objLOGFileHandle, "- Outbound connections that do not match a rule are BLOCKED.", cLoggingLevel3, False
                           TrackingData.FirewallStatus = AddTrackingData (TrackingData.FirewallStatus, "FWNOOUTBOUND")
                        Else 
                           WriteToLogFile objLOGFileHandle, "- Outbound connections that do not match a rule are ALLOWED.", cLoggingLevel3, False
                        End If

                        WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False

                        WriteToLogFile objLOGFileHandle, "Group rule name:      " & cWMIRuleGroup, cLoggingLevel3, False
                        If objFWPolicy.IsRuleGroupCurrentlyEnabled(cWMIRuleGroup) Then
                           WriteToLogFile objLOGFileHandle, "  Enabled:            True", cLoggingLevel3, False
                           TrackingData.FirewallStatus = AddTrackingData (TrackingData.FirewallStatus, "FWGROUPRULEENABLED")
                        Else
                           WriteToLogFile objLOGFileHandle, "  Enabled:            False", cLoggingLevel3, False
                           TrackingData.FirewallStatus = AddTrackingData (TrackingData.FirewallStatus, "FWGROUPRULEDISABLED")
                        End If 
   
                        Set objFWRules = objFWPolicy.Rules

                        strFWRuleNames = Array (cFWRuleDCOMIn, "DCOM-IN", _
                                                cFWRuleWMIIn, "WMI-IN", _
                                                cFWRuleAsyncIn, "ASYNC-IN", _
                                                cFWRuleWMIOut, "WMI-OUT")

                        For Each objFWRule In objFWRules
                            For intIndex=0 To UBound (strFWRuleNames) Step 2
                                WriteToLogFile objLOGFileHandle, "Verifying if '" & UCase (objFWRule.Name) & "' (Rule profile='" & objFWRule.Profiles & "') matches '" & UCase (strFWRuleNames (intIndex)) & "' (Current profile='" & intCurrentProfileType & "').", cLoggingDebug Or cLoggingLevel3, False

                                If UCase (objFWRule.Name) = UCase (strFWRuleNames (intIndex)) And intCurrentProfileType = (objFWRule.Profiles And intCurrentProfileType) Then
                                   WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False
                                   DisplayFWRule objLOGFileHandle, objFWRule, strFWRuleNames (intIndex + 1)
                                End If
                            Next
                        Next

                        Select Case objFWPolicy.LocalPolicyModifyState
                               Case NET_FW_MODIFY_STATE_OK            
                                    WriteToLogFile objLOGFileHandle, "Changing or adding a firewall rule (or group) to the current profile will take effect.", cLoggingLevel3, False
                               Case NET_FW_MODIFY_STATE_GP_OVERRIDE   
                                    WriteToLogFile objLOGFileHandle, "Changing or adding a firewall rule (or group) to the current profile will not take effect because group policy overrides it.", cLoggingLevel2, False
                                    TrackingData.FirewallStatus = AddTrackingData (TrackingData.FirewallStatus, "FWGPOVERRIDES")
                               Case NET_FW_MODIFY_STATE_INBOUND_BLOCKED 
                                    WriteToLogFile objLOGFileHandle, "Changing or adding an inbound firewall rule (or group) to the current profile will not take effect because inbound exceptions are not allowed.", cLoggingLevel3, False
                               Case Else                              
                                    WriteToLogFile objLOGFileHandle, "Invalid MODIFY State returned by LocalPolicyModifyState.", cLoggingLevel1, False
                        End Select
                        WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False
                                               
                        Set objFWRules = Nothing
                     End If

                     Set objFWPolicy = Nothing
                  Else
                     Set objFW = CreateObject("HNetCfg.FwMgr")
                     Set objFWCurrentProfile = objFW.LocalPolicy.CurrentProfile
          
                     Select Case objFWCurrentProfile.Type
                            Case cNetFWProfileStandard 
                                 WriteToLogFile objLOGFileHandle, strFWName & " STANDARD profile is the current active one.", cLoggingLevel3, False
                                 TrackingData.FirewallStatus = AddTrackingData (TrackingData.FirewallStatus, "FWPROFILE=STANDARD")
                            Case cNetFWProfileDomain
                                 WriteToLogFile objLOGFileHandle, strFWName & " DOMAIN profile is the current active one.", cLoggingLevel3, False
                                 TrackingData.FirewallStatus = AddTrackingData (TrackingData.FirewallStatus, "FWPROFILE=DOMAIN")
                            Case Else
                                 WriteToLogFile objLOGFileHandle, strFWName & " Firewall profile is #" & objFWCurrentProfile.Type, cLoggingLevel3, False
                                 TrackingData.FirewallStatus = AddTrackingData (TrackingData.FirewallStatus, "FWPROFILE=UNKNOWN (" & objFWCurrentProfile.Type & ")")
                     End Select
                    
                     If objFWCurrentProfile.FirewallEnabled = False Then
                        WriteToLogFile objLOGFileHandle, strFWName & " status is DISABLED.", cLoggingLevel3, False
                        TrackingData.FirewallStatus = AddTrackingData (TrackingData.FirewallStatus, "FWDISABLED")
                     Else
                        WriteToLogFile objLOGFileHandle, strFWName & " status is ENABLED.", cLoggingLevel3, False
          
                        If objFWCurrentProfile.RemoteAdminSettings.Enabled = True Then
                           WriteToLogFile objLOGFileHandle, strFWName & " 'RemoteAdmin' is ENABLED.", cLoggingLevel3, False
                        Else
                           TrackingData.FirewallStatus = AddTrackingData (TrackingData.FirewallStatus, "NOREMOTEADMIN")
                           WriteToLogFile objLOGFileHandle, strFWName & " 'RemoteAdmin' is DISABLED, preventing remote WMI connections to this machine.", cLoggingLevel2, False
                        End If
          
                        boolUnSecapp = False
                        Set objFWApps = objFWCurrentProfile.AuthorizedApplications
                        If objFWApps.Count Then
                           For Each objFWApp In objFWApps
                               If UCase(objFWApp.ProcessImageFileName) = UCase(RunTimeEnvironmentInfo.WBem & "UNSECAPP.EXE") And objFWApp.Enabled = True Then
                                  boolUnSecapp = True
                               End If 
                          Next
                        End If
             
                        If boolUnSecapp = False Then
                           TrackingData.FirewallStatus = AddTrackingData (TrackingData.FirewallStatus, "NOUNSECAPP")
                           WriteToLogFile objLOGFileHandle, "'UNSECAPP.EXE' is not authorized, preventing WMI asynchronous callbacks to this computer for scripts and MMC applications.", cLoggingLevel2, False
                        Else
                           WriteToLogFile objLOGFileHandle, "'UNSECAPP.EXE' is in the ACTIVE application exception list.", cLoggingLevel3, False
                        End If
          
                        Set objFWApps = Nothing
                     End If

                     Set objFWCurrentProfile = Nothing 
                     Set objFW = Nothing
                  End If
               End If
            Else
               WriteToLogFile objLOGFileHandle, strFWName & " service is NOT INSTALLED.", cLoggingLevel3, False
               TrackingData.FirewallStatus = AddTrackingData (TrackingData.FirewallStatus, "FWNOTINSTALLED")
            End If
         Else
            WriteToLogFile objLOGFileHandle, strFWName & " service is NOT INSTALLED.", cLoggingLevel3, False
            TrackingData.FirewallStatus = AddTrackingData (TrackingData.FirewallStatus, "FWNOTINSTALLED")
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function DisplayFWRule (ByVal objLOGFileHandle, ByVal objFWRule, ByVal strFWRuleShortName) 

         Dim arrayInterfaces, intIndex, intFWCurrentProfile

         On Error Resume Next

         WriteToLogFile objLOGFileHandle, "Rule Name:            " & objFWRule.Name, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "  Description:        " & objFWRule.Description, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "  Enabled:            " & objFWRule.Enabled, cLoggingLevel3, False
         If objFWRule.Enabled = False Then
            TrackingData.FirewallStatus = AddTrackingData (TrackingData.FirewallStatus, strFWRuleShortName & "_DISABLED")
         Else
            TrackingData.FirewallStatus = AddTrackingData (TrackingData.FirewallStatus, strFWRuleShortName & "_ENABLED")
         End If
         WriteToLogFile objLOGFileHandle, "  Application Name:   " & UCase (objFWRule.ApplicationName), cLoggingLevel3, False

         Select Case objFWRule.Profiles
                Case NET_FW_PROFILE2_DOMAIN 
                     WriteToLogFile objLOGFileHandle, "  Rule profile:       DOMAIN", cLoggingLevel3, False
                Case NET_FW_PROFILE2_PRIVATE 

                     WriteToLogFile objLOGFileHandle, "  Rule profile:       PRIVATE", cLoggingLevel3, False
                Case NET_FW_PROFILE2_PUBLIC 

                     WriteToLogFile objLOGFileHandle, "  Rule profile:       PUBLIC", cLoggingLevel3, False
         End Select

         Select Case objFWRule.Protocol
                Case NET_FW_IP_PROTOCOL_TCP    
                     WriteToLogFile objLOGFileHandle, "  IP Protocol:        TCP", cLoggingLevel3, False
                Case NET_FW_IP_PROTOCOL_UDP     
                     WriteToLogFile objLOGFileHandle, "  IP Protocol:        UDP", cLoggingLevel3, False
                Case NET_FW_IP_PROTOCOL_ICMPv4 
                     WriteToLogFile objLOGFileHandle, "  IP Protocol:        UDP", cLoggingLevel3, False
                Case NET_FW_IP_PROTOCOL_ICMPv6 
                     WriteToLogFile objLOGFileHandle, "  IP Protocol:        UDP", cLoggingLevel3, False
                Case Else                      
                     WriteToLogFile objLOGFileHandle, "  IP Protocol:        " & objFWRule.Protocol, cLoggingLevel3, False
         End Select

         If objFWRule.Protocol = NET_FW_IP_PROTOCOL_TCP or objFWRule.Protocol = NET_FW_IP_PROTOCOL_UDP Then
            WriteToLogFile objLOGFileHandle, "  Local Ports:        " & objFWRule.LocalPorts, cLoggingLevel3, False
            WriteToLogFile objLOGFileHandle, "  Remote Ports:       " & objFWRule.RemotePorts, cLoggingLevel3, False
            WriteToLogFile objLOGFileHandle, "  LocalAddresses:     " & objFWRule.LocalAddresses, cLoggingLevel3, False
            WriteToLogFile objLOGFileHandle, "  RemoteAddresses:    " & objFWRule.RemoteAddresses, cLoggingLevel3, False
         End If 

         If objFWRule.Protocol = NET_FW_IP_PROTOCOL_ICMPv4 or objFWRule.Protocol = NET_FW_IP_PROTOCOL_ICMPv6 Then
            WriteToLogFile objLOGFileHandle, "  ICMP Type and Code:    " & objFWRule.IcmpTypesAndCodes, cLoggingLevel3, False
         End If 

         Select Case objFWRule.Direction
                Case NET_FW_RULE_DIR_IN  
                     WriteToLogFile objLOGFileHandle, "  Direction:          In", cLoggingLevel3, False
                Case NET_FW_RULE_DIR_OUT 
                     WriteToLogFile objLOGFileHandle, "  Direction:          Out", cLoggingLevel3, False
         End Select

         Select Case objFWRule.Action
                Case NET_FW_ACTION_ALLOW  
                     WriteToLogFile objLOGFileHandle, "  Action:             Allow", cLoggingLevel3, False
                Case NET_FW_ACTION_BLOCk  
                     WriteToLogFile objLOGFileHandle, "  Action:             Block", cLoggingLevel3, False
                     If objFWRule.Enabled = True Then
                        TrackingData.FirewallStatus = AddTrackingData (TrackingData.FirewallStatus, strFWRuleShortName & "_BLOCKED")
                     Else
                        TrackingData.FirewallStatus = AddTrackingData (TrackingData.FirewallStatus, strFWRuleShortName & "_ALLOWED")
                     End If
         End Select

         WriteToLogFile objLOGFileHandle, "  Edge:               " & objFWRule.EdgeTraversal, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "  Interface Types:    " & objFWRule.InterfaceTypes, cLoggingLevel3, False

         arrayInterfaces = objFWRule.Interfaces

         If IsEmpty(arrayInterfaces) = True Then
            WriteToLogFile objLOGFileHandle, "  There are no excluded interfaces", cLoggingLevel3, False
         Else
            WriteToLogFile objLOGFileHandle, "Excluded interfaces: "
            For intIndex = 0 To UBound (arrayInterfaces)
                WriteToLogFile objLOGFileHandle, "    " & arrayInterfaces (intIndex), cLoggingLevel3, False
            Next
         End If 

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckWMISettings (ByVal objLOGFileHandle)

         On Error Resume Next
 
         WriteToLogFile objLOGFileHandle, "Verifying WMI Core registry settings (WBEM).", cLoggingLevel0, False
 
         boolRC = CheckRegistrySetup (objLOGFileHandle, arrayWMIRegistrySettings, "WMIREGISTRYSETTINGS")

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckWMIServiceSetup (ByVal objLOGFileHandle)
  
         Dim boolRC, arrayRegistryValue, strTemp, boolSharedHost, boolAloneHost 
 
         On Error Resume Next
 
         WriteToLogFile objLOGFileHandle, "Verifying WMI Service registry settings (SVCHOST, WINMGMT).", cLoggingLevel0, False
 
         arrayRegistryValue = ReadRegistry (objLOGFileHandle, "HKLM\SYSTEM\CurrentControlSet\Services\Winmgmt", _
                                            "Start", _
                                            "REG_DWORD", _
                                            True)
 
         If IsArray (arrayRegistryValue) = True Then
            If arrayRegistryValue (0) = 4 Then
               CheckWMIServiceSetup = ErrorHandler (objLOGFileHandle, "CheckWMIServiceSetup", "'Windows Management Instrumentation' service is DISABLED.", False, Err)
               TrackingData.InvalidWMIServiceSetup = AddTrackingData (TrackingData.InvalidWMIServiceSetup, "WMISERVICEDISABLED")
            End If

            If RunTimeEnvironmentInfo.OSIdentifier >= cWindowsXPRTM Then
               boolSharedHost = False
               boolAloneHost = False
 
               arrayRegistryValue = ReadRegistry (objLOGFileHandle, "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SvcHost", _
                                                  "netsvcs", _
                                                  "REG_MULTI_SZ", _
                                                  False)
 
               If IsArray (arrayRegistryValue) = True Then
                  strTemp = ConvertArrayInString (arrayRegistryValue, ";")
                  If Instr (Ucase (strTemp), "WINMGMT") > 0 Then
                     boolSharedHost = True
                  Else 
                     boolSharedHost = False
                  End If
               End If
 
               arrayRegistryValue = ReadRegistry (objLOGFileHandle, "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\SvcHost", _
                                                  "winmgmt", _
                                                  "REG_MULTI_SZ", _
                                                  False)
 
               If IsArray (arrayRegistryValue) = True Then
                  strTemp = ConvertArrayInString (arrayRegistryValue, ";")
                  If Instr (UCase (strTemp), "WINMGMT") > 0 Then
                     boolAloneHost = True
                  Else
                     boolAloneHost = False
                  End If
               End If

               If boolSharedHost = True Then
                  WriteToLogFile objLOGFileHandle, "'Windows Management Instrumentation' (WINMGMT) is running as a SHARED HOST SERVICE.", cLoggingLevel3, False
               End If 
               If boolSharedHost = False And boolAloneHost = True Then
                  WriteToLogFile objLOGFileHandle, "'Windows Management Instrumentation' (WINMGMT) is running as a STANDALONE HOST SERVICE.", cLoggingLevel2, False
                  TrackingData.InvalidWMIServiceSetup = AddTrackingData (TrackingData.InvalidWMIServiceSetup, "WMISERVICESTANDALONEHOST")
               End If
               If (boolSharedHost = True And boolAloneHost = True) Or _
                  (boolSharedHost = False And boolAloneHost = False) Then
                  CheckWMIServiceSetup = ErrorHandler (objLOGFileHandle, "CheckWMIServiceSetup", "'Windows Management Instrumentation' service has an invalid SHARED/STANDALONE service host configuration.", False, Err)
                  TrackingData.InvalidWMIServiceSetup = AddTrackingData (TrackingData.InvalidWMIServiceSetup, "WMISERVICEHOST")
               End If
            End If
         End If
 
         boolRC = CheckRegistrySetup (objLOGFileHandle, arrayWMIRegistryServiceSetup, "WMISERVICESETUP")
 
         If boolRC Then
            CheckWMIServiceSetup = ErrorHandler (objLOGFileHandle, "CheckWMIServiceSetup", "'Windows Management Instrumentation' service registry setup is incorrect or access denied.", False, Err)
            TrackingData.InvalidWMIServiceSetup = AddTrackingData (TrackingData.InvalidWMIServiceSetup, "WMISERVICESETUP")
         Else 
            WriteToLogFile objLOGFileHandle, "'Windows Management Instrumentation' service registered correctly (WINMGMT).", cLoggingLevel3, False
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckWMIServiceDependent (ByVal objLOGFileHandle)

	 Dim intKeyIndex
         Dim strRegistryValue, arrayRegistryValue, strDisplayname, intStartMode, strStartMode, boolFound
 
         On Error Resume Next
 
         WriteToLogFile objLOGFileHandle, "Verifying WMI Service known dependents.", cLoggingLevel0, False
 
         CheckWMIServiceDependent = False
 
         For intKeyIndex = 0 To UBound (arrayWMIServiceKnownDependent) Step 2
             arrayRegistryValue = ReadRegistry (objLOGFileHandle, "HKLM\SYSTEM\CurrentControlSet\Services\" & arrayWMIServiceKnownDependent (intKeyIndex), _
                                                "DisplayName", _
                                                "REG_SZ", _
                                                False)
             If IsArray (arrayRegistryValue) = True Then
                strDisplayname = arrayWMIServiceKnownDependent (intKeyIndex + 1)
 
                arrayRegistryValue = ReadRegistry (objLOGFileHandle, "HKLM\SYSTEM\CurrentControlSet\Services\" & arrayWMIServiceKnownDependent (intKeyIndex), _
                                                   "DependOnService", _
                                                   "REG_MULTI_SZ", _
                                                   False)
                boolFound = False
                If IsArray (arrayRegistryValue) = True Then
                   For Each strRegistryValue in arrayRegistryValue
                       If UCase (strRegistryValue) = "WINMGMT" Then 
                          boolFound = True
                          Exit For
                       End If
                   Next
                End If
 
                intStartMode = CLng(ReadRegistry (objLOGFileHandle, "HKLM\SYSTEM\CurrentControlSet\Services\" & arrayWMIServiceKnownDependent (intKeyIndex), _
                                                  "Start", _
                                                  "REG_DWORD", True)(0))
                Select Case intStartMode
                       Case 0
                            strStartMode = "Boot"
                       Case 1
                            strStartMode = "System"
                       Case 2
                            strStartMode = "Automatic"
                       Case 3
                            strStartMode = "Manual"
                       Case 4 
                            strStartMode = "Disabled"
                       Case Else 
                            strStartMode = "Unknown"
                End Select
 
                If boolFound = False Then
                   WriteToLogFile objLOGFileHandle, "'" & strDisplayname & "' (" & Ucase (arrayWMIServiceKnownDependent (intKeyIndex)) & ", StartMode='" & strStartMode & "') is installed and should depends on WMI Service (No DependsOnService registry key).", cLoggingLevel2, False
                   TrackingData.WMIServiceDependents = AddTrackingData (TrackingData.WMIServiceDependents, strDisplayname & " (*);" & UCase (arrayWMIServiceKnownDependent (intKeyIndex)) & ";" & strStartMode)
                Else
                   WriteToLogFile objLOGFileHandle, "'" & strDisplayname & "' (" & Ucase (arrayWMIServiceKnownDependent (intKeyIndex)) & ", StartMode='" & strStartMode & "') is installed depends on WMI Service.", cLoggingLevel2, False
                   TrackingData.WMIServiceDependents = AddTrackingData (TrackingData.WMIServiceDependents, strDisplayname & ";" & UCase (arrayWMIServiceKnownDependent (intKeyIndex)) & ";" & strStartMode)
                End If
 
                CheckWMIServiceDependent = True
             End If
         Next

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckEnvironment (ByVal objLOGFileHandle)

         Dim arrayRegistryValue, strTemp, intPathPosition, intMaxPathLength

         On Error Resume Next

         CheckEnvironment = False

         WriteToLogFile objLOGFileHandle, "Verifying computer environment.", cLoggingLevel0, False

         If RunTimeEnvironmentInfo.OSIdentifier <= cWindowsXPRTM Then
            intMaxPathLength = 512
         End If
         If RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP1 Then
            intMaxPathLength = 1023
         End If
         If RunTimeEnvironmentInfo.OSIdentifier >= cWindowsXPSP164 Then
            intMaxPathLength = 2047 
         End If

	 WriteToLogFile objLOGFileHandle, "PATH = " & Left (RunTimeEnvironmentInfo.Path, Len (RunTimeEnvironmentInfo.Path) - 1) & ".", cLoggingLevel3, False

         strTemp = Left (RunTimeEnvironmentInfo.System32, Len (RunTimeEnvironmentInfo.System32) - 1)
         intPathPosition = Instr (UCase (objWshShell.ExpandEnvironmentStrings (RunTimeEnvironmentInfo.Path)), Ucase (strTemp) & ";")
         If intPathPosition = 0 Then
            WriteToLogFile objLOGFileHandle, "The SYSTEM32 folder is NOT in the PATH.", cLoggingLevel1, False
            TrackingData.Environment = AddTrackingData (TrackingData.Environment, "PATH;" & strTemp)
            CheckEnvironment = True
         Else
            If intPathPosition >= (intMaxPathLength - Len (RunTimeEnvironmentInfo.System32) + 1) Then
               WriteToLogFile objLOGFileHandle, "The SYSTEM32 folder IS in the PATH but on the edge or way after the maximum path length of " & intMaxPathLength & " characters (" & intPathPosition & ").", cLoggingLevel2, False
               TrackingData.Environment = AddTrackingData (TrackingData.Environment, "PATHEDGE;" & strTemp & ";" & intPathPosition & ";" & intMaxPathLength)
               CheckEnvironment = True
            Else
               WriteToLogFile objLOGFileHandle, "The SYSTEM32 folder IS in the PATH.", cLoggingLevel3, False
            End If
         End If

         strTemp = Left (RunTimeEnvironmentInfo.WBEM, Len (RunTimeEnvironmentInfo.WBEM) - 1)
         intPathPosition = Instr (UCase (objWshShell.ExpandEnvironmentStrings (RunTimeEnvironmentInfo.Path)), Ucase (strTemp))
         If intPathPosition = 0 Then
            WriteToLogFile objLOGFileHandle, "The WBEM folder is NOT in the PATH.", cLoggingLevel1, False
            TrackingData.Environment = AddTrackingData (TrackingData.Environment, "PATH;" & strTemp)
            CheckEnvironment = True
         Else
            If intPathPosition >= (intMaxPathLength - Len (RunTimeEnvironmentInfo.WBEM) + 1) Then
               WriteToLogFile objLOGFileHandle, "The WBEM folder IS in the PATH but on the edge or way after the maximum path length of " & intMaxPathLength & " characters (" & intPathPosition & ").", cLoggingLevel2, False
               TrackingData.Environment = AddTrackingData (TrackingData.Environment, "PATHEDGE;" & strTemp & ";" & intPathPosition & ";" & intMaxPathLength)
               CheckEnvironment = True
            Else
               WriteToLogFile objLOGFileHandle, "The WBEM folder IS in the PATH.", cLoggingLevel3, False
            End If
         End If

         If Len (RunTimeEnvironmentInfo.Path) >= intMaxPathLength Then
            WriteToLogFile objLOGFileHandle, "The PATH environment variable is equal or above the maximum length of " & intMaxPathLength & " characters (" & Len (RunTimeEnvironmentInfo.Path) & ").", cLoggingLevel2, False
            TrackingData.Environment = AddTrackingData (TrackingData.Environment, "PATHLEN;" & ReplaceString (RunTimeEnvironmentInfo.Path, ";", "#") & ";" & intMaxPathLength)
            CheckEnvironment = True
         Else
            WriteToLogFile objLOGFileHandle, "The PATH environment variable has a maximum length of " & intMaxPathLength & " characters. Current PATH length is " & Len (RunTimeEnvironmentInfo.Path) & " characters.", cLoggingLevel3, False
         End If

         arrayRegistryValue = ReadRegistry (objLOGFileHandle, "HKCU\Software\Microsoft\Windows Script Host\Settings", _
                                            "Timeout", _
                                            "REG_DWORD", _
                                            False)

         If IsArray (arrayRegistryValue) = True Then
            If arrayRegistryValue (0) > 0 Then
               WriteToLogFile objLOGFileHandle, "The user profile has a WSH script execution timeout of '" & arrayRegistryValue (0) & "'.", cLoggingLevel1, False
               TrackingData.Environment = AddTrackingData (TrackingData.Environment, "WSHTIMEOUT;USER;" & arrayRegistryValue (0))
               CheckEnvironment = True
            End If
         End If

         arrayRegistryValue = ReadRegistry (objLOGFileHandle, "HKLM\SOFTWARE\Microsoft\Windows Script Host\Settings", _
                                            "Timeout", _
                                            "REG_DWORD", _
                                            False)

         If IsArray (arrayRegistryValue) = True Then
            If arrayRegistryValue (0) > 0 Then
               WriteToLogFile objLOGFileHandle, "The computer profile has a WSH script execution timeout of '" & arrayRegistryValue (0) & "'.", cLoggingLevel1, False
               TrackingData.Environment = AddTrackingData (TrackingData.Environment, "WSHTIMEOUT;MACHINE;" & arrayRegistryValue (0))
               CheckEnvironment = True
            End If
         End If

         If RunTimeEnvironmentInfo.OSIdentifier > cWindows2003SP264 Then
            arrayRegistryValue = ReadRegistry (objLOGFileHandle, "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\System", _
                                               "EnableLUA", _
                                               "REG_DWORD", _
                                               False)
            If IsArray (arrayRegistryValue) = True Then
               If arrayRegistryValue (0) > 0 Then 
                  WriteToLogFile objLOGFileHandle, "User Account Control (UAC) is ENABLED.", cLoggingLevel2, False
                  TrackingData.UAC = AddTrackingData (TrackingData.UAC, "UAC;ENABLED")
               Else
                  WriteToLogFile objLOGFileHandle, "User Account Control (UAC) is DISABLED.", cLoggingLevel2, False
                  TrackingData.UAC = AddTrackingData (TrackingData.UAC, "UAC;DISABLED")
               End If
            Else
               WriteToLogFile objLOGFileHandle, "User Account Control (UAC) is DISABLED.", cLoggingLevel2, False
               TrackingData.UAC = AddTrackingData (TrackingData.UAC, "UAC;DISABLED")
            End If

            arrayRegistryValue = ReadRegistry (objLOGFileHandle, "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\System", _
                                               "LocalAccountTokenFilterPolicy", _
                                               "REG_DWORD", _
                                               False)
            If IsArray (arrayRegistryValue) = True Then
               If arrayRegistryValue (0) > 0 Then 
                  WriteToLogFile objLOGFileHandle, "Local account token filtering policy is DISABLED.", cLoggingLevel2, False
                  TrackingData.UAC = AddTrackingData (TrackingData.UAC, "LAF;DISABLED")
               Else
                  WriteToLogFile objLOGFileHandle, "Local account token filtering policy is ENABLED.", cLoggingLevel2, False
                  TrackingData.UAC = AddTrackingData (TrackingData.UAC, "LAF;ENABLED")
               End If
            Else
               WriteToLogFile objLOGFileHandle, "Local account token filtering policy is ENABLED.", cLoggingLevel2, False
               TrackingData.UAC = AddTrackingData (TrackingData.UAC, "LAF;ENABLED")
            End If
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckFilesPresence (ByVal objLOGFileHandle)

         Dim intFileIndex, strPathFilename

         On Error Resume Next
 
         WriteToLogFile objLOGFileHandle, "Verifying specific files presence.", cLoggingLevel0, False
 
         CheckFilesPresence = False
 
         For intFileIndex = 0 To UBound (arraySpecificFileList) Step 3
             strPathFilename = UCase (objWshShell.ExpandEnvironmentStrings (arraySpecificFileList (intFileIndex)))
 
             If CheckIfFileExists (objLOGFileHandle, strPathFilename) Then
                If arraySpecificFileList (intFileIndex + 1) = True Then
                   WriteToLogFile objLOGFileHandle, "File '" & strPathFilename & "' IS FOUND, which is AN ISSUE.", cLoggingLevel2, False
                   TrackingData.PresenceOfFiles = AddTrackingData (TrackingData.PresenceOfFiles, strPathFilename & ";True;" & arraySpecificFileList (intFileIndex + 2))
                Else
                   WriteToLogFile objLOGFileHandle, "File '" & strPathFilename & "' IS FOUND, which is FINE.", cLoggingLevel3, False
               End If
             Else
                If arraySpecificFileList (intFileIndex + 1) = True Then
                   WriteToLogFile objLOGFileHandle, "File '" & strPathFilename & "' is MISSING, which is FINE.", cLoggingLevel3, False
               Else
                   WriteToLogFile objLOGFileHandle, "File '" & strPathFilename & "' is MISSING, which is AN ISSUE.", cLoggingLevel2, False
                   TrackingData.PresenceOfFiles = AddTrackingData (TrackingData.PresenceOfFiles, strPathFilename & ";False;" & arraySpecificFileList (intFileIndex + 2))
                End If
             End If
         Next

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckAdditionalBinaryInWBEMFolder (ByVal objLOGFileHandle)

         Dim objFolder, objFiles, objFile
         Dim boolFoundAdditionalBinaryInWBEM, intFileIndex 

         On Error Resume Next
 
         WriteToLogFile objLOGFileHandle, "Verifying additional binaries in WBEM folder.", cLoggingLevel0, False
 
         Set objFolder = objFS.GetFolder (RunTimeEnvironmentInfo.WBem)
         If Err.Number Then 
            CheckAdditionalBinaryInWBEMFolder = ErrorHandler (objLOGFileHandle, "CheckAdditionalBinaryInWBEMFolder", "'" & RunTimeEnvironmentInfo.WBem & "' not found.", False, Err)
            TrackingData.AdditionalBinaryWBEMFolder = AddTrackingData (TrackingData.AdditionalBinaryWBEMFolder, strLastError & ";NOWBEMFOLDER;;;")
            Exit Function
         End If
 
         Set objFiles = objFolder.Files
         If Err.Number Then 
            CheckAdditionalBinaryInWBEMFolder = ErrorHandler (objLOGFileHandle, "CheckAdditionalBinaryInWBEMFolder", "No file found in '" & RunTimeEnvironmentInfo.WBem & "'.", False, Err)
            TrackingData.AdditionalBinaryWBEMFolder = AddTrackingData (TrackingData.AdditionalBinaryWBEMFolder, strLastError & ";NOFILESINWBEMFOLDER;;;")
            Exit Function
         End If

         If objFiles.Count = 0 Then 
           WriteToLogFile objLOGFileHandle, "No file found in '" & RunTimeEnvironmentInfo.WBem & "'.", cLoggingLevel1, False
            TrackingData.AdditionalBinaryWBEMFolder = AddTrackingData (TrackingData.AdditionalBinaryWBEMFolder, strLastError & ";NOFILESINWBEMFOLDER;;;")
            CheckAdditionalBinaryInWBEMFolder = True
            Exit Function
         End If
 
         For Each objFile in objFiles
             If UCase (Right (objFile.Name, 4)) = ".DLL" Or UCase (Right (objFile.Name, 4)) = ".EXE" Then 
                boolFoundAdditionalBinaryInWBEM = False
                For intFileIndex = 0 To UBound (arrayWMIDCOMDataList) Step 4
                    If Ucase (objFile.Name) = Ucase (arrayWMIDCOMDataList (intFileIndex + 1)) Then
                       boolFoundAdditionalBinaryInWBEM = True
                    End If
                Next
 
                If boolFoundAdditionalBinaryInWBEM = False Then
                   WriteToLogFile objLOGFileHandle, "'" & Ucase (objFile.Name) & "' is an unexpected binary file located in " & RunTimeEnvironmentInfo.WBem & ".", cLoggingLevel2, False
                   TrackingData.AdditionalBinaryWBEMFolder = AddTrackingData (TrackingData.AdditionalBinaryWBEMFolder , UCase (objFile.Name) & ";" & objFile.Size & ";" & objFile.DateCreated & ";" & objFile.DateLastAccessed & ";" & objFile.DateLastModified)
                End If
             End If
         Next

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckWMISystemFilesPresence (ByVal objLOGFileHandle)

         Dim intFileIndex

         On Error Resume Next

         WriteToLogFile objLOGFileHandle, "Verifying WMI System files presence at '" & RunTimeEnvironmentInfo.WBem & "'.", cLoggingLevel0, False
 
         CheckWMISystemFilesPresence = False
 
         For intFileIndex = 0 To UBound (arrayWMIDCOMDataList) Step 4
             If Not CheckIfFileExists (objLOGFileHandle, objWshShell.ExpandEnvironmentStrings (arrayWMIDCOMDataList (intFileIndex)) & arrayWMIDCOMDataList (intFileIndex + 1)) Then
                If arrayWMIDCOMDataList (intFileIndex + 2) = True Then
                   WriteToLogFile objLOGFileHandle, "WMI System file '" & UCase (objWshShell.ExpandEnvironmentStrings (arrayWMIDCOMDataList (intFileIndex)) & arrayWMIDCOMDataList (intFileIndex + 1)) & "' is MISSING or is access DENIED but it is an OPTIONAL component.", cLoggingLevel2, False
                Else
                   WriteToLogFile objLOGFileHandle, "WMI System file '" & UCase (objWshShell.ExpandEnvironmentStrings (arrayWMIDCOMDataList (intFileIndex)) & arrayWMIDCOMDataList (intFileIndex + 1)) & "' is MISSING or is access DENIED.", cLoggingLevel1, False
                   TrackingData.MissingWMISystemFiles = AddTrackingData (TrackingData.MissingWMISystemFiles, objWshShell.ExpandEnvironmentStrings (arrayWMIDCOMDataList (intFileIndex)) & arrayWMIDCOMDataList (intFileIndex + 1))
                   CheckWMISystemFilesPresence = True
                End If
             Else
                If arrayWMIDCOMDataList (intFileIndex + 2) = True Then
                   arrayWMIDCOMDataList (intFileIndex + 2) = False
                   WriteToLogFile objLOGFileHandle, "Found '" & UCase (objWshShell.ExpandEnvironmentStrings (arrayWMIDCOMDataList (intFileIndex)) & arrayWMIDCOMDataList (intFileIndex + 1))  & "', is present but it is an OPTIONAL component.", cLoggingLevel3, False
                Else
                   WriteToLogFile objLOGFileHandle, "Found '" & UCase (objWshShell.ExpandEnvironmentStrings (arrayWMIDCOMDataList (intFileIndex)) & arrayWMIDCOMDataList (intFileIndex + 1))  & ".", cLoggingLevel3, False
                 End If
	     End If
         Next

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckDCOMConfiguration (ByVal objLOGFileHandle)

         Dim arrayRegistryValue

         On Error Resume Next

         WriteToLogFile objLOGFileHandle, "Verifying DCOM configuration.", cLoggingLevel0, False

         ' HKLM\SOFTWARE\Microsoft\Ole\EnableDCOM = Y
         arrayRegistryValue = ReadRegistry (objLOGFileHandle, "HKLM\SOFTWARE\Microsoft\Ole", _
                                            "EnableDCOM", _
                                            "REG_SZ", _
                                            False)
         If Not IsArray (arrayRegistryValue) Then
            WriteToLogFile objLOGFileHandle, "DCOM is DISABLED.", cLoggingLevel1, False
            TrackingData.InvalidDCOMSetup = AddTrackingData (TrackingData.InvalidDCOMSetup, "DCOMDISABLED")
         Else
            If Ucase (arrayRegistryValue (0)) <> "Y" Then
               WriteToLogFile objLOGFileHandle, "DCOM is DISABLED.", cLoggingLevel1, False   
               TrackingData.InvalidDCOMSetup = AddTrackingData (TrackingData.InvalidDCOMSetup, "DCOMDISABLED")
            Else
               WriteToLogFile objLOGFileHandle, "DCOM is ENABLED.", cLoggingLevel3, False   
            End If
         End If

         ' HKLM\SOFTWARE\Microsoft\Ole\LegacyAuthenticationLevel = 2
         arrayRegistryValue = ReadRegistry (objLOGFileHandle, "HKLM\SOFTWARE\Microsoft\Ole", _
                                            "LegacyAuthenticationLevel", _
                                            "REG_DWORD", _
                                            False)
         If IsArray (arrayRegistryValue) = True Then
            If arrayRegistryValue (0) <> 2 Then
               WriteToLogFile objLOGFileHandle, "DCOM is NOT set at the CONNECT authentication level.", cLoggingLevel2, False
               TrackingData.InvalidDCOMSetup = AddTrackingData (TrackingData.InvalidDCOMSetup, "DCOMNOCONNECT")
            Else
               WriteToLogFile objLOGFileHandle, "DCOM IS set at the CONNECT authentication level.", cLoggingLevel3, False
            End If
         Else
            WriteToLogFile objLOGFileHandle, "DCOM IS set at the CONNECT authentication level.", cLoggingLevel3, False
         End If

         ' HKLM\SOFTWARE\Microsoft\Ole\LegacyImpersonationLevel = 2
         arrayRegistryValue = ReadRegistry (objLOGFileHandle, "HKLM\SOFTWARE\Microsoft\Ole", _
                                            "LegacyImpersonationLevel", _
                                            "REG_DWORD", _
                                            False)
         If IsArray (arrayRegistryValue) = True Then
            If arrayRegistryValue (0) <> 2 Then
               WriteToLogFile objLOGFileHandle, "DCOM is NOT set at the IDENTIFY impersonation level.", cLoggingLevel2, False
               TrackingData.InvalidDCOMSetup = AddTrackingData (TrackingData.InvalidDCOMSetup, "DCOMNOIDENTIFY")
            Else
               WriteToLogFile objLOGFileHandle, "DCOM IS set at the IDENTIFY impersonation level.", cLoggingLevel3, False
            End If
         Else
            WriteToLogFile objLOGFileHandle, "DCOM IS set at the IDENTIFY impersonation level.", cLoggingLevel3, False
         End If

         CheckDCOMConfiguration = False

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckWMIDCOMComponentRegistrations (ByVal objLOGFileHandle)

         Dim intFileIndex, intGUIDIndex, strGUIDHive, strGUID, arrayRegistryValue, boolRC
 
         On Error Resume Next
 
         WriteToLogFile objLOGFileHandle, "Verifying WMI DCOM component registrations.", cLoggingLevel0, False

         CheckWMIDCOMComponentRegistrations = False
 
         boolRC = CheckRegistrySetup (objLOGFileHandle, arrayWMIRegistryDCOMSetup, "WMIDCOMSETUP")
 
         If boolRC Then
            CheckWMIDCOMComponentRegistrations = ErrorHandler (objLOGFileHandle, "CheckWMIDCOMComponentRegistrations", "'Windows Management Instrumentation' DCOM application registration data is missing, incorrect or access denied.", False, Err)
            TrackingData.InvalidWMIServiceDCOMSetup = AddTrackingData (TrackingData.InvalidWMIServiceDCOMSetup, "WMIDCOMAPPLICATIONSETUPISSUE")
         Else 
            WriteToLogFile objLOGFileHandle, "'Windows Management Instrumentation' DCOM application registered correctly ({8BC3F05E-D86B-11D0-A075-00C04FB68820}).", cLoggingLevel3, False
         End If

         For intFileIndex = 0 To UBound (arrayWMIDCOMDataList) Step 4
             If arrayWMIDCOMDataList (intFileIndex + 2) = False Then
                If IsArray (arrayWMIDCOMDataList (intFileIndex + 3)) = True Then
                   For intGUIDIndex = 0 To UBound (arrayWMIDCOMDataList (intFileIndex + 3))
                       strGUIDHive = UCase (arrayWMIDCOMDataList (intFileIndex + 3)(intGUIDIndex))

                       If InStr (UCase (strGUIDHive), "\CLSID\") > 0 Then
                          If InStr (UCase (arrayWMIDCOMDataList (intFileIndex + 1)), ".EXE") > 0 Then
                             strGUIDHive = strGUIDHive & "\LocalServer32"
                          Else
                             strGUIDHive = strGUIDHive & "\InProcServer32"
                          End If
                       End If

                       arrayRegistryValue = ReadRegistry (objLOGFileHandle, "HKCR" & strGUIDHive, _
                                                          "", _
                                                          "REG_SZ", _
                                                          True)

                       If Not IsArray (arrayRegistryValue) Then
                          CheckWMIDCOMComponentRegistrations = ErrorHandler (objLOGFileHandle, "CheckWMIDCOMComponentRegistrations", "'" & UCase (objWshShell.ExpandEnvironmentStrings (arrayWMIDCOMDataList (intFileIndex)) & arrayWMIDCOMDataList (intFileIndex + 1)) & "' is not registered correctly, missing '" & strGUIDHive & "'.", False, Err)
                          TrackingData.WMIDCOMRegistrations = AddTrackingData (TrackingData.WMIDCOMRegistrations, UCase (objWshShell.ExpandEnvironmentStrings (arrayWMIDCOMDataList (intFileIndex)) & arrayWMIDCOMDataList (intFileIndex + 1)) & " (" & strGUIDHive & ")" )
                       Else 
                          WriteToLogFile objLOGFileHandle, "'" & UCase (objWshShell.ExpandEnvironmentStrings (arrayWMIDCOMDataList (intFileIndex)) & arrayWMIDCOMDataList (intFileIndex + 1)) & "' registered correctly (" & strGUIDHive & ").", cLoggingLevel3, False
                       End If
                   Next
                End If
             End If
         Next

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckWMIDCOMComponentSecurity (ByVal objLOGFileHandle)

         On Error Resume Next
 
         WriteToLogFile objLOGFileHandle, "Verifying WMI DCOM component security.", cLoggingLevel0, False

         CheckWMIDCOMComponentSecurity = False

         If RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP2 Or _
            RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP164 Or _
            RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP3 Or _
            RunTimeEnvironmentInfo.OSIdentifier >= cWindows2003SP1 Then
            boolRC = DecipherDCOMSD (objLOGFileHandle, "My Computer", "", "DefaultAccessPermission", "Access Permissions/Edit Default", arrayDCOMDefaultAccessPermission)
            boolRC = DecipherDCOMSD (objLOGFileHandle, "My Computer", "", "MachineAccessRestriction", "Access Permissions/Edit Limits", arrayDCOMMachineAccessRestriction)
            boolRC = DecipherDCOMSD (objLOGFileHandle, "My Computer", "", "DefaultLaunchPermission", "Launch & Activation Permissions/Edit Default", arrayDCOMDefaultLaunchPermission)
            boolRC = DecipherDCOMSD (objLOGFileHandle, "My Computer", "", "MachineLaunchRestriction", "Launch & Activation Permissions/Edit Limits", arrayDCOMMachineLaunchRestriction)
         Else
            boolRC = DecipherDCOMSD (objLOGFileHandle, "My Computer", "", "DefaultAccessPermission", "Access Permissions/Edit Default", arrayDCOMDefaultAccessPermission)
            boolRC = DecipherDCOMSD (objLOGFileHandle, "My Computer", "", "DefaultLaunchPermission", "Launch & Activation Permissions/Edit Default", arrayDCOMDefaultLaunchPermission)
         End If 


         boolRC = DecipherDCOMSD (objLOGFileHandle, "Windows Management Instrumentation", "{8BC3F05E-D86B-11D0-A075-00C04FB68820}", "AccessPermission", "Access Permissions", arrayWMIDCOMAccessPermission)
         boolRC = DecipherDCOMSD (objLOGFileHandle, "Windows Management Instrumentation", "{8BC3F05E-D86B-11D0-A075-00C04FB68820}", "LaunchPermission", "Launch & Activation Permissions", arrayWMIDCOMLaunchPermission)

         boolRC = DecipherDCOMSD (objLOGFileHandle, "Microsoft WMI Provider Subsystem Host", "{73E709EA-5D93-4B2E-BBB0-99B7938DA9E4}", "AccessPermission", "Access Permissions", arrayWMIPSSDCOMAccessPermission)
         boolRC = DecipherDCOMSD (objLOGFileHandle, "Microsoft WMI Provider Subsystem Host", "{73E709EA-5D93-4B2E-BBB0-99B7938DA9E4}", "LaunchPermission", "Launch & Activation Permissions", arrayWMIPSSDCOMLaunchPermission)

         boolRC = DecipherDCOMSD (objLOGFileHandle, "Microsoft WBEM UnSecured Apartment", "{49BD2028-1523-11D1-AD79-00C04FD8FDFF}", "AccessPermission", "Access Permissions", arrayWMIUnsecureApptDCOMAccessPermission)
         boolRC = DecipherDCOMSD (objLOGFileHandle, "Microsoft WBEM UnSecured Apartment", "{49BD2028-1523-11D1-AD79-00C04FD8FDFF}", "LaunchPermission", "Launch & Activation Permissions", arrayWMIUnsecureApptDCOMLaunchPermission)

         boolRC = DecipherDCOMSD (objLOGFileHandle, "Microsoft WBEM Active Scripting Event Consumer Provider", "{266C72E7-62E8-11D1-AD89-00C04FD8FDFF}", "AccessPermission", "Access Permissions", arrayWMIActiveScriptEventConsDCOMAccessPermission)
         boolRC = DecipherDCOMSD (objLOGFileHandle, "Microsoft WBEM Active Scripting Event Consumer Provider", "{266C72E7-62E8-11D1-AD89-00C04FD8FDFF}", "LaunchPermission", "Launch & Activation Permissions", arrayWMIActiveScriptEventConsDCOMLaunchPermission)

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckWMIProgID (objLOGFileHandle)

         Dim intIndex 
         Dim objWMIObject

         On Error Resume Next

         WriteToLogFile objLOGFileHandle, "Verifying WMI ProgID registrations.", cLoggingLevel0, False

         CheckWMIProgID = False

         For intIndex = 0 To UBound (arrayWMIProgID) Step 2
             Set objWMIobject = CreateObject (arrayWMIProgID (intIndex))
             If Err.Number Then
                WriteToLogFile objLOGFileHandle, "WMI object ProgID '" & arrayWMIProgID (intIndex) & "' CANNOT be instantiated'.", cLoggingLevel2, False
                TrackingData.WMIObjectProgID = AddTrackingData (TrackingData.WMIObjectProgID, arrayWMIProgID (intIndex) & ";" & RunTimeEnvironmentInfo.WBem & UCase (arrayWMIProgID (intIndex + 1)))
                CheckWMIProgID = True
             Else
                WriteToLogFile objLOGFileHandle, "WMI object ProgID '" & arrayWMIProgID (intIndex) & "' instantiated'.", cLoggingLevel3, False
             End If
             Set objWMIObject = Nothing
         Next

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckWMIRepositoryConsistency (ByVal objLOGFileHandle)

         Dim arrayOutput, arrayMatchingOutput
         Dim objFile
         Dim strCommand, strLOGFile, strMessageFilter, strInconsistencyMessage

         Dim boolRC

         On Error Resume Next

         Select Case RunTimeEnvironmentInfo.OSIdentifier
                Case cWindowsXPSP2, cWindowsXPSP3
                     If boolCheckConsistency = True Then
                        strCommand = "Rundll32.Exe WBemupgd,UpgradeRepository"
                        strLOGFile = "SETUP.LOG"
                        strMessageFilter = ""
                        strInconsistencyMessage = "Inconsistent repository detected"
                     Else
                        strCommand = ""
                     End If

                Case cWindowsXPSP164, cWindows2003SP1, cWindows2003SP164, cWindows2003SP2, cWindows2003SP264
                     strCommand = "Rundll32.Exe WBemupgd,CheckWMISetup"
                     strLOGFile = "REPLOG.LOG"
                     strMessageFilter = ""
                     strInconsistencyMessage = "Inconsistent repository detected"

                Case cWindowsVistaRTM, cWindowsVistaSP1, cWindowsLonghornRTM
                     strCommand = "Winmgmt.exe /VerifyRepository"
                     strLOGFile = ""
                     strMessageFilter = ""
                     strInconsistencyMessage = "WMI repository is INCONSISTENT"

                Case Else
                     strCommand = ""
         End Select

         If Len (strCommand) > 0 Then
            WriteToLogFile objLOGFileHandle, "Verifying WMI repository consistency.", cLoggingLevel0, False

            If Len (strLOGFile) > 0 Then
               If objFS.FileExists (RunTimeEnvironmentInfo.WBemLogs & strLOGFile) Then
                  Set objFile = objFS.GetFile (RunTimeEnvironmentInfo.WBemLogs & strLOGFile) 
                  objFile.Delete 
                  Set objFile = Nothing
               End If
            End If

            boolRC = ShellExecute (objLOGFileHandle, strCommand, strMessageFilter, arrayOutput, arrayMatchingOutput)
            If boolRc = False Then
               If RunTimeEnvironmentInfo.OSIdentifier >= cWindowsVistaRTM Then
                  If UBound (arrayOutput) > 0 Then
                     WriteToLogFile objLOGFileHandle, "WMI Repository IS consistent.", cLoggingLevel3, False
                     TrackingData.WMIRepositoryConsistency = AddTrackingData (TrackingData.WMIRepositoryConsistency, "True")
                  Else
                     CheckWMIRepositoryConsistency = ErrorHandler (objLOGFileHandle, "CheckWMIRepositoryConsistency", "WMI repository is INCONSISTENT.", False, Err)
                     TrackingData.WMIRepositoryConsistency = AddTrackingData (TrackingData.WMIRepositoryConsistency, "False")
                  End If
               Else
                  If objFS.FileExists (RunTimeEnvironmentInfo.WBemLogs & strLOGFile) Then
                     boolRC = ParseFile (objLOGFileHandle, RunTimeEnvironmentInfo.WBemLogs & strLOGFile, Array (strInconsistencyMessage), arrayMatchingOutput, False, True) 
                     If boolRc Then
                         CheckWMIRepositoryConsistency = ErrorHandler (objLOGFileHandle, "CheckWMIRepositoryConsistency", "WMI repository is INCONSISTENT.", False, Err)
                         TrackingData.WMIRepositoryConsistency = AddTrackingData (TrackingData.WMIRepositoryConsistency, "False")
                     Else
                         WriteToLogFile objLOGFileHandle, "WMI Repository IS consistent.", cLoggingLevel3, False
                         TrackingData.WMIRepositoryConsistency = AddTrackingData (TrackingData.WMIRepositoryConsistency, "True")
                     End If
                  Else
                     WriteToLogFile objLOGFileHandle, "'" & RunTimeEnvironmentInfo.WBemLogs & strLOGFile & "' file NOT found.", cLoggingLevel3, False
                     WriteToLogFile objLOGFileHandle, "WMI Repository IS consistent.", cLoggingLevel3, False
                     TrackingData.WMIRepositoryConsistency = AddTrackingData (TrackingData.WMIRepositoryConsistency, "True")
                  End If
               End If
            End If
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function WriteInRepository (ByVal objLOGFileHandle, ByVal strWMINamespace, ByVal boolWrite)

         Dim intIndexNamespace, strIndexNamespace 
         Dim objWMINSInstance, objWMIClass

         On Error Resume Next

         If boolWrite = True Then
            ReDim objWMIServicesForWrite (cMaxNamespaces)

            WriteToLogFile objLOGFileHandle, "Writing test data in WMI repository.", cLoggingLevel0, False

            Set objWMIServicesToRoot = objWMILocator.ConnectServer("LocalHost", strWMINameSpace, "", "")
            If Err.Number Then 
               WriteInRepository = ErrorHandler (objLOGFileHandle, "WriteInRepository", "", False, Err)
               TrackingData.WriteInRepository = AddTrackingData (TrackingData.WriteInRepository, "NAMESPACE CONNECTION;" & strWMINameSpace & ";" & strLastError & ";")
               Exit Function
            End If
   
            For intIndexNamespace = 1 To cMaxNamespaces
                strIndexNamespace = Right ("0000" & intIndexNamespace, 5)
                Set objWMIClass = objWMIServicesToRoot.Get ("__NAMESPACE")
                If Err.Number Then 
                   WriteInRepository = ErrorHandler (objLOGFileHandle, "WriteInRepository", "", False, Err)
                   TrackingData.WMIGetErrors = AddTrackingData (TrackingData.WMIGetErrors, strWMINameSpace & ";__NAMESPACE;" & strLastError)
                   Exit Function
                Else
                   Set objWMINSInstance = objWMIClass.SpawnInstance_
                   objWMINSInstance.Name = "WMIDiag" & strIndexNamespace
                   WriteToLogFile objLOGFileHandle, "Creating namespace '" & strWMINamespace & "\WMIDiag" & strIndexNamespace & "'.", cLoggingLevel3, False
                   objWMINSInstance.Put_ (wbemChangeFlagCreateOrUpdate Or wbemFlagReturnWhenComplete)
                   If Err.Number Then 
                      WriteInRepository = ErrorHandler (objLOGFileHandle, "WriteInRepository", "", False, Err)
                      TrackingData.WriteInRepository = AddTrackingData (TrackingData.WriteInRepository, "NAMESPACE CREATION;" & "WMIDiag" & strWMINamespace & "\WMIDiag" & strIndexNamespace & ";;" & strLastError)
                      TrackingData.WMIPutErrors = AddTrackingData (TrackingData.WMIPutErrors, strWMINamespace & "\WMIDiag" & strIndexNamespace & ";__NAMESPACE;WMIDiag" & strIndexNamespace & ";" & strLastError)
                      Exit Function
                   End If
                   Set objWMIClass = Nothing
                   Set objWMINSInstance = Nothing       
                End If
            Next
   
            For intIndexNamespace = 1 To cMaxNamespaces
                WriteToLogFile objLOGFileHandle, "Writing test data set #" & intIndexNamespace & ".", cLoggingLevel0, False
                strIndexNamespace = Right ("0000" & intIndexNamespace, 5)
                Set objWMIServicesForWrite (intIndexNamespace) = objWMILocator.ConnectServer("LocalHost", strWMINamespace & "\WMIDiag" & strIndexNamespace, "", "")
                If Err.Number Then 
                   WriteInRepository = ErrorHandler (objLOGFileHandle, "WriteInRepository", "", False, Err)
                   TrackingData.WriteInRepository = AddTrackingData (TrackingData.WriteInRepository, "NAMESPACE CONNECTION;" & strWMINamespace & "\WMIDiag" & strIndexNamespace & ";;" & strLastError)
                Else
                   If WriteClassesInRepository (objLOGFileHandle, objWMIServicesForWrite (intIndexNamespace), strWMINamespace & "\WMIDiag" & strIndexNamespace) = True Then
                      Exit For
                   End If

                   boolWriteOperationCompleted = True
                End If
            Next
         End If

         For intIndexNamespace = 1 To cMaxNamespaces
             strIndexNamespace = Right ("0000" & intIndexNamespace, 5)
             ReadClassesInRepository objLOGFileHandle, objWMIServicesForWrite (intIndexNamespace), strWMINamespace & "\WMIDiag" & strIndexNamespace
         Next     
  
         If boolWrite = False Then
            WriteToLogFile objLOGFileHandle, "Deleting test data from WMI repository.", cLoggingLevel0, False

            For intIndexNamespace = 1 To cMaxNamespaces
                WriteToLogFile objLOGFileHandle, "Deleting test data set #" & intIndexNamespace & ".", cLoggingLevel0, False
                strIndexNamespace = Right ("0000" & intIndexNamespace, 5)

                DeleteClassesInRepository objLOGFileHandle, objWMIServicesForWrite (intIndexNamespace), strWMINamespace & "\WMIDiag" & strIndexNamespace

            Next
   
            For intIndexNamespace = 1 To cMaxNamespaces
                strIndexNamespace = Right ("0000" & intIndexNamespace, 5)
                Set objWMIServicesForWrite (intIndexNamespace) = Nothing     
                Set objWMINSInstance = objWMIServicesToRoot.Get ("__NAMESPACE.Name='WMIDiag" & strIndexNamespace  & "'")
                If Err.Number Then 
                   WriteInRepository = ErrorHandler (objLOGFileHandle, "WriteInRepository", "", False, Err)
                   TrackingData.WMIGetErrors = AddTrackingData (TrackingData.WMIGetErrors, strWMINameSpace & ";__NAMESPACE.Name='WMIDiag" & strIndexNamespace & "';" & strLastError)
                Else
                   WriteToLogFile objLOGFileHandle, "Deleting namespace '" & strWMINamespace & "\WMIDiag" & strIndexNamespace & "'.", cLoggingLevel3, False
                   objWMINSInstance.Delete_
                   If Err.Number Then 
                      WriteInRepository = ErrorHandler (objLOGFileHandle, "WriteInRepository", "", False, Err)
                      TrackingData.WriteInRepository = AddTrackingData (TrackingData.WriteInRepository, "NAMESPACE DELETION;" & strWMINamespace & "\WMIDiag" & strIndexNamespace & ";;" & strLastError)
                      TrackingData.WMIDeleteErrors = AddTrackingData (TrackingData.WMIDeleteErrors, strWMINamespace & "\WMIDiag" & strIndexNamespace & ";__NAMESPACE;" & strLastError)
                   End If
                End If
                Set objWMINSInstance = Nothing  
            Next
   
            Set objWMIServicesToRoot = Nothing
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function WriteClassesInRepository (ByVal objLOGFileHandle, ByVal objWMIServices, ByVal strWMINamespace)

         Dim intIndexInstance, strIndexInstance 
         Dim objWMIClass, objWMIInstance

         On Error Resume Next

         If boolWriteInExistingNS = True Then
            WriteToLogFile objLOGFileHandle, "Creating " & cMaxInstances & " instances of class '" & cWriteInRepositoryClass & "' in namespace '" & strWMINamespace & "'.", cLoggingLevel0, False
         End If

         If Not IsNull (objWMIServices) Then
            Set objWMIClass = objWMIServices.Get ()
            objWMIClass.Path_.Class = cWriteInRepositoryClass
            objWMIClass.Properties_.Add "WMIDiagPropertyKey", wbemCimtypeString
            objWMIClass.Properties_("WMIDiagPropertyKey").Qualifiers_.Add "key", True
            objWMIClass.Properties_.Add "WMIDiagPropertyIndex", wbemCimtypeUint32
            WriteToLogFile objLOGFileHandle, "  Creating class '" & objWMIClass.Path_.Class & "' in namespace '" & strWMINamespace & "'.", cLoggingLevel3, False
            objWMIClass.Put_ (wbemChangeFlagCreateOrUpdate Or wbemFlagReturnWhenComplete)
            If Err.Number Then 
               If Err.Number = WBEM_E_PROVIDER_LOAD_FAILURE Or Err.Number = WBEM_E_FAILED Then
                  WriteClassesInRepository = ErrorHandler (objLOGFileHandle, "WriteClassesInRepository", "", False, Err)
                  TrackingData.WMIPutErrors = AddTrackingData (TrackingData.WMIPutErrors, strWMINamespace & ";();" & cWriteInRepositoryClass & ";" & strLastError)
                  WriteClassesInRepository = True
                  Exit Function
               Else
                  WriteClassesInRepository = ErrorHandler (objLOGFileHandle, "WriteClassesInRepository", "", False, Err)
                  TrackingData.WriteInRepository = AddTrackingData (TrackingData.WriteInRepository, "CLASS CREATION;" & strWMINameSpace & ";" & strLastError & ";")
                  TrackingData.WMIPutErrors = AddTrackingData (TrackingData.WMIPutErrors, strWMINamespace & ";();" & cWriteInRepositoryClass & ";" & strLastError)
                  WriteClassesInRepository = True
                  Exit Function
               End If
            End If
            Set objWMIClass = Nothing
        
            For intIndexInstance = 1 to cMaxInstances
                strIndexInstance = Right ("0000" & intIndexInstance, 5)
                Set objWMIClass = objWMIServices.Get (cWriteInRepositoryClass)
                If Err.Number Then 
                   WriteInRepository = ErrorHandler (objLOGFileHandle, "WriteInRepository", "", False, Err)
                   TrackingData.WMIGetErrors = AddTrackingData (TrackingData.WMIGetErrors, strWMINameSpace & ";" & cWriteInRepositoryClass & ";" & strLastError)
                Else
                   Set objWMIInstance = objWMIClass.SpawnInstance_
                   objWMIInstance.WMIDiagPropertyKey = "WMIDiagValue" & strIndexInstance
                   objWMIInstance.WMIDiagPropertyIndex = intIndexInstance
                   WriteToLogFile objLOGFileHandle, "    Creating static instance '" & cWriteInRepositoryClass & "." & objWMIInstance.WMIDiagPropertyKey & "' in namespace '" & strWMINamespace & "'.", cLoggingLevel3, False
                   objWMIInstance.Put_ (wbemChangeFlagCreateOrUpdate Or wbemFlagReturnWhenComplete)
                   If Err.Number Then 
                      WriteClassesInRepository = ErrorHandler (objLOGFileHandle, "WriteClassesInRepository", "", False, Err)
                      TrackingData.WriteInRepository = AddTrackingData (TrackingData.WriteInRepository, "STATIC INSTANCE CREATION;" & strWMINameSpace & ";" & strLastError & ";")
                      TrackingData.WMIPutErrors = AddTrackingData (TrackingData.WMIPutErrors, strWMINamespace & ";" & cWriteInRepositoryClass & ";" & cWriteInRepositoryClass & ".WMIDiagPropertyKey='WMIDiagValue" & strIndexInstance & "';" & strLastError)
                   End If
                End If
                Set objWMIInstance = Nothing
                Set objWMIClass = Nothing
            Next
         Else
            WriteClassesInRepository = ErrorHandler (objLOGFileHandle, "WriteClassesInRepository", "No WMI connection to namespace '" & strWMINamespace & "' available.", False, Err)
         End If 

End Function

' --------------------------------------------------------------------------------------------------------
Function ReadClassesInRepository (ByVal objLOGFileHandle, ByVal objWMIServices, ByVal strWMINamespace)

         Dim objWMIInstances
         Dim intCount

         On Error Resume Next

         If Not IsNull (objWMIServices) Then
            Set objWMIInstances = objWMIServices.InstancesOf (cWriteInRepositoryClass, wbemQueryFlagShallow)
            If Err.Number Then 
               ReadClassesInRepository = ErrorHandler (objLOGFileHandle, "ReadClassesInRepository", "", False, Err)
               TrackingData.WriteInRepository = AddTrackingData (TrackingData.WriteInRepository, "STATIC INSTANCE ENUMERATION;" & strWMINameSpace & ";" & strLastError & ";")
               Exit Function
            Else  
               IntCount = objWMIInstances.Count 
               If Err.Number Then 
                  ReadClassesInRepository = ErrorHandler (objLOGFileHandle, "ReadClassesInRepository", "", False, Err)
                  TrackingData.WriteInRepository = AddTrackingData (TrackingData.WriteInRepository, "STATIC INSTANCE ENUMERATION;" & strWMINameSpace & ";" & strLastError & ";")
                  Exit Function
               End If
        
               If intCount = cMaxInstances Then
                  WriteToLogFile objLOGFileHandle, "The " & cMaxInstances & " '" & cWriteInRepositoryClass & "' objects are available in '" & strWMINamespace & "', as expected.", cLoggingLevel0, False
               Else
                  WriteToLogFile objLOGFileHandle, intCount & " '" & cWriteInRepositoryClass & " objects counted instead of " & cMaxInstances & "!", cLoggingLevel1, False
                  TrackingData.WriteInRepository = AddTrackingData (TrackingData.WriteInRepository, "STATIC INSTANCE ENUMERATION;" & strWMINamespace & ";" & intCount & ";WRONGCOUNTEDOBJECTS")
               End If
               Set objWMIInstances = Nothing 
            End If
         Else
            ReadClassesInRepository = ErrorHandler (objLOGFileHandle, "ReadClassesInRepository", "No WMI connection to namespace '" & strWMINamespace & "' available.", False, Err)
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function DeleteClassesInRepository (ByVal objLOGFileHandle, ByVal objWMIServices, ByVal strWMINamespace)

         Dim intIndexInstance, strIndexInstance 
         Dim objWMINSInstance, objWMIClass, objWMIInstance

         On Error Resume Next

         If boolWriteInExistingNS = True Then
            WriteToLogFile objLOGFileHandle, "Deleting " & cMaxInstances & " instances of class '" & cWriteInRepositoryClass & "' in namespace '" & strWMINamespace & "'.", cLoggingLevel0, False
         End If

         If Not IsNull (objWMIServices) Then
            Set objWMIClass = objWMIServices.Get (cWriteInRepositoryClass)
            If Err.Number Then 
               DeleteClassesInRepository = ErrorHandler (objLOGFileHandle, "DeleteClassesInRepository", "", False, Err)
               TrackingData.WriteInRepository = AddTrackingData (TrackingData.WriteInRepository, "CLASS GET;" & strWMINameSpace & ";" & strLastError & ";")
               TrackingData.WMIGetErrors = AddTrackingData (TrackingData.WMIGetErrors, strWMINameSpace & ";" & cWriteInRepositoryClass & ";" & strLastError)
               Exit Function
            End If

            For intIndexInstance = 1 to cMaxInstances
                strIndexInstance = Right ("0000" & intIndexInstance, 5)
                Set objWMIInstance = objWMIServices.Get (cWriteInRepositoryClass & ".WMIDiagPropertyKey='WMIDiagValue" & strIndexInstance & "'")
                If Err.Number Then 
                   DeleteClassesInRepository = ErrorHandler (objLOGFileHandle, "DeleteClassesInRepository", "", False, Err)
                   TrackingData.WriteInRepository = AddTrackingData (TrackingData.WriteInRepository, "STATIC INSTANCE GET;" & strWMINameSpace & ";" & strLastError & ";")
                   TrackingData.WMIGetErrors = AddTrackingData (TrackingData.WMIGetErrors, strWMINameSpace & ";" & cWriteInRepositoryClass & ".WMIDiagPropertyKey='WMIDiagValue" & strIndexInstance & "'" & ";" & strLastError)
                Else
                   WriteToLogFile objLOGFileHandle, "    Deleting static instance '" & cWriteInRepositoryClass & "." & objWMIInstance.WMIDiagPropertyKey & "' in namespace '" & strWMINamespace & "'.", cLoggingLevel3, False
                   objWMIInstance.Delete_
                   If Err.Number Then 
                      DeleteClassesInRepository = ErrorHandler (objLOGFileHandle, "DeleteClassesInRepository", "", False, Err)
                      TrackingData.WriteInRepository = AddTrackingData (TrackingData.WriteInRepository, "STATIC INSTANCE DELETE;" & strWMINameSpace & ";" & strLastError & ";")
                      TrackingData.WMIDeleteErrors = AddTrackingData (TrackingData.WMIDeleteErrors, strWMINamespace & ";" & cWriteInRepositoryClass & ".WMIDiagPropertyKey='WMIDiagValue" & strIndexInstance & "'" & ";" & strLastError)
                   End If
                   Set objWMIInstance = Nothing     
                End If
            Next
   
            Set objWMIClass = objWMIServices.Get (cWriteInRepositoryClass)
            If Err.Number Then 
               DeleteClassesInRepository = ErrorHandler (objLOGFileHandle, "DeleteClassesInRepository", "", False, Err)
               TrackingData.WriteInRepository = AddTrackingData (TrackingData.WriteInRepository, "CLASS GET;" & strWMINameSpace & ";" & strLastError & ";")
               TrackingData.WMIGetErrors = AddTrackingData (TrackingData.WMIGetErrors, strWMINameSpace & ";" & cWriteInRepositoryClass & ";" & strLastError)
            Else
               WriteToLogFile objLOGFileHandle, "  Deleting class '" & objWMIClass.Path_.Class & "' in namespace '" & strWMINamespace & "'.", cLoggingLevel3, False
               objWMIClass.Delete_
               If Err.Number Then 
                  DeleteClassesInRepository = ErrorHandler (objLOGFileHandle, "DeleteClassesInRepository", "", False, Err)
                  TrackingData.WriteInRepository = AddTrackingData (TrackingData.WriteInRepository, "CLASS DELETION;" & strWMINameSpace & ";" & strLastError & ";")
                  TrackingData.WMIDeleteErrors = AddTrackingData (TrackingData.WMIDeleteErrors, strWMINamespace & ";" & cWriteInRepositoryClass & ";" & strLastError)
               End If
               Set objWMIClass = Nothing
            End If
         Else
            DeleteClassesInRepository = ErrorHandler (objLOGFileHandle, "DeleteClassesInRepository", "No WMI connection to namespace '" & strWMINamespace & "' available.", False, Err)
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckWMIStaticData (ByVal objLOGFileHandle, ByVal strWMINameSpace, ByVal L)

         Dim intIndex
         Dim objWMIServices
         Dim objWMIInstance, objWMIInstances
         Dim objWMINSInstance, objWMINSInstances
         Dim objWMISystemSecurity
         Dim objWMIClass, objWMIClasses 
         Dim strMOF 
         Dim intCount, intRC, arrayBinSD
         Dim strHexSD, strTemp
         Dim boolRequiresEncryption
         Dim boolWriteInLocalNSFailure 
 
         On Error Resume Next
 
         WriteToLogFile objLOGFileHandle, "Verifying WMI namespace '" & strWMINameSpace & "' (L=" & L & ").", cLoggingLevel0, False

         Set objWMIServices = GetObject ("winmgmts:/" & strWMINamespace)
         If Err.Number Then 
            CheckWMIStaticData = ErrorHandler (objLOGFileHandle, "CheckWMIStaticData", "", False, Err)
            TrackingData.WMIMonikerConnectionErrors = AddTrackingData (TrackingData.WMIMonikerConnectionErrors, strWMINameSpace & ";" & strLastError)
         End If
         Set objWMIServices = Nothing
 
         Set objWMIServices = objWMILocator.ConnectServer("LocalHost", strWMINameSpace, "", "")
         If Err.Number Then 
            CheckWMIStaticData = ErrorHandler (objLOGFileHandle, "CheckWMIStaticData", "", False, Err)
            TrackingData.WMIConnectionErrors = AddTrackingData (TrackingData.WMIConnectionErrors, strWMINameSpace & ";" & strLastError)
            Exit Function
         End If

         WriteToLogFile objLOGFileHandle, "Retrieving WMI system class(es) static information.", cLoggingLevel3, False
         intCount = 0
         For intIndex = 0 To UBound (arrayWMISystemClassList)   
             Set objWMIClass = objWMIServices.Get (arrayWMISystemClassList (intIndex))
             If Err.Number Then
                CheckWMIStaticData = ErrorHandler (objLOGFileHandle, "CheckWMIStaticData", "", False, Err)
                TrackingData.WMIGetErrors = AddTrackingData (TrackingData.WMIGetErrors, strWMINamespace & ";" & arrayWMISystemClassList (intIndex) & ";" & strLastError)
             Else
                strMOF = objWMIClass.GetObjectText_
                If Err.Number Then
                   CheckWMIStaticData = ErrorHandler (objLOGFileHandle, "CheckWMIStaticData", "", False, Err)
                   TrackingData.FailingMOFRepresentation = AddTrackingData (TrackingData.FailingMOFRepresentation, strWMINamespace & ";" & arrayWMISystemClassList (intIndex) & ";" & strLastError)
                Else
                   intCount = intCount + 1
                   WriteToLogFile objLOGFileHandle, "'" & arrayWMISystemClassList (intIndex) & "' WMI system class static information found.", cLoggingDebug Or cLoggingLevel3, False
                End If 
             End If
             Set objWMIClass = Nothing
         Next
         WriteToLogFile objLOGFileHandle, intCount & "/" & (UBound (arrayWMISystemClassList) + 1) & " system class(es) found.", cLoggingLevel3, False

         CheckPermanentSubscriptions objLOGFileHandle, strWMINameSpace, objWMIServices
 
         If boolWriteInRepository = True And boolWriteInExistingNS = True And _
            Left (strWMINamespace, Len (strWriteInRepository)) = strWriteInRepository Then
            If IsThereAClassProvider (objLOGFileHandle, objWMIServices, strWMINameSpace) = False Then
               boolWriteInLocalNSFailure = WriteClassesInRepository (objLOGFileHandle, objWMIServices, strWMINamespace) 
               If boolWriteInLocalNSFailure = False Then
                  boolWriteOperationCompleted = True
                  ReadClassesInRepository objLOGFileHandle, objWMIServices, strWMINamespace
               End If
            End If
            WriteToLogFile objLOGFileHandle, "Analyzing WMI namespace '" & strWMINameSpace & "'.", cLoggingLevel0, False
         End If

         If Ucase(strWMINameSpace) = "ROOT" Then
            CheckWMIStaticData = GetWMISystemSettings (objLOGFileHandle, objWMIServices)
         End If  
 
         Set objWMISystemSecurity = objWMIServices.Get ("__SystemSecurity=@")
         If Err.Number Then
            CheckWMIStaticData = ErrorHandler (objLOGFileHandle, "CheckWMIStaticData", "", False, Err)
            TrackingData.WMIGetErrors = AddTrackingData (TrackingData.WMIGetErrors, strWMINameSpace & ";__SystemSecurity;" & strLastError)
         Else
            boolRequiresEncryption = GetQualifier (objLOGFileHandle, objWMISystemSecurity, "RequiresEncryption", False, strWMINameSpace, "__SystemSecurity")
 
            If boolRequiresEncryption = True Then
               WriteToLogFile objLOGFileHandle, "Namespace '" & strWMINameSpace & "' requires PACKET PRIVACY authentication level for remote connections.", cLoggingLevel2, False
               TrackingData.RequiresEncryption = AddTrackingData (TrackingData.RequiresEncryption, strWMINameSpace)
            End If
 
            intRC = objWMISystemSecurity.GetSD (arrayBinSD)
            If Err.Number Then
               CheckWMIStaticData = ErrorHandler (objLOGFileHandle, "CheckWMIStaticData", "", False, Err)
               TrackingData.WMIGetErrors = AddTrackingData (TrackingData.WMIGetErrors, strWMINameSpace & ";__SystemSecurity;" & strLastError)
            End If

            If boolADsSecurity = True Then
               'DecipherWMISD objLOGFileHandle, strWMINameSpace, arrayBinSD
            End If

            Set objWMISystemSecurity = Nothing
         End If
 
         Set objWMIInstances = objWMIServices.InstancesOf ("__Win32Provider", wbemFlagReturnImmediately Or wbemFlagUseAmendedQualifiers)
         If Err.Number Then
            CheckWMIStaticData = ErrorHandler (objLOGFileHandle, "CheckWMIStaticData", "", False, Err)
            TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;__Win32Provider;" & cCritical & ";" & strLastError)
            Exit Function
         End If
 
         intCount = objWMIInstances.Count
         If Err.Number Then
            CheckWMIStaticData = ErrorHandler (objLOGFileHandle, "CheckWMIStaticData", "", False, Err)
            TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;__Win32Provider;" & cCritical & ";" & strLastError)
            Exit Function
         End If

         longWMIProviderCounter = longWMIProviderCounter + objWMIInstances.Count
 
         WriteToLogFile objLOGFileHandle, intCount & " WMI Provider CIM registration(s) found.", cLoggingLevel3, False
         If intCount Then
            CheckWMIStaticData = CheckWMIProviderRegistration (objLOGFileHandle, objWMIServices, strWMINameSpace, objWMIInstances)
         End If

         If Not (UCase(strWMINameSpace) = "ROOT/DIRECTORY/LDAP") Then
            ' Check subclass structure
            Set objWMIClasses = objWMIServices.SubClassesOf("", wbemQueryFlagDeep Or wbemFlagReturnImmediately Or wbemFlagUseAmendedQualifiers)
            If Err.Number Then
               CheckWMIStaticData = ErrorHandler (objLOGFileHandle, "CheckWMIStaticData", "", False, Err)
               TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";SubClassesOf;*;" & cCritical & ";" & strLastError)
               Exit Function 
            End If
 
            intCount = objWMIClasses.Count
            If Err.Number Then
               CheckWMIStaticData = ErrorHandler (objLOGFileHandle, "CheckWMIStaticData", "", False, Err)
               TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";SubClassesOf;*;" & cCritical & ";" & strLastError)
               Exit Function 
            End If
 
            WriteToLogFile objLOGFileHandle, intCount & " class(es) found. (Inheritance level analysis=" & intMaxSubClassExaminationDepth & ").", cLoggingLevel3, False
            If intCount Then
               CheckWMIStaticData = CheckWMIClasses (objLOGFileHandle, objWMIServices, objWMIClasses, strWMINameSpace, 1)
            Else
               CheckWMIStaticData = ErrorHandler (objLOGFileHandle, "CheckWMIStaticData", "No subclass found in namespace'" & strWMINameSpace & "' while some are expected.", False, Err)
               TrackingData.NoSubclasses = AddTrackingData (TrackingData.NoSubClasses, "SUBCLASSESOF;NOSUBCLASSES;" & strWMINameSpace)
               Exit Function 
            End If
 
            Set objWMINSInstances = objWMIServices.InstancesOf ("__NAMESPACE", wbemQueryFlagShallow)
            If Err.Number Then
               CheckWMIStaticData = ErrorHandler (objLOGFileHandle, "CheckWMIStaticData", "", False, Err)
               TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;__NAMESPACE;" & cCritical & ";" & strLastError)
               Exit Function 
            End If
 
            intCount = objWMINSInstances.Count
            If Err.Number Then
               CheckWMIStaticData = ErrorHandler (objLOGFileHandle, "CheckWMIStaticData", "", False, Err)
               TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;__NAMESPACE;" & cCritical & ";" & strLastError)
               Exit Function 
            End If
 
            If intCount Then 
               For Each objWMINSInstance in objWMINSInstances
                   If Not UCase (Left (objWMINSInstance.Name, 3)) = "MS_" Then
                      CheckWMIStaticData objLOGFileHandle, UCase (strWMINameSpace & "/" & objWMINSInstance.Name), L + 1
                   End If
               Next
            End If
         End If

         If boolWriteInRepository = True And boolWriteInExistingNS = True And _
            Left (strWMINamespace, Len (strWriteInRepository)) = strWriteInRepository Then
            If IsThereAClassProvider (objLOGFileHandle, objWMIServices, strWMINameSpace) = False Then
               If boolWriteInLocalNSFailure = False Then
                  ReadClassesInRepository objLOGFileHandle, objWMIServices, strWMINamespace
                  DeleteClassesInRepository objLOGFileHandle, objWMIServices, strWMINamespace
               End If
            End If
         End If
 
         Set objWMINSInstances = Nothing
         Set objWMIClasses = Nothing
         Set objWMIInstances = Nothing
 
         Set objWMIServices = Nothing

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckPermanentSubscriptions (ByVal objLOGFileHandle, ByVal strWMINameSpace, ByVal objWMIServices)

         Dim objWMIInstance, objWMIInstances
         Dim objWMIAssocInstance, objWMIAssocInstances
         Dim objWMIRefInstance, objWMIRefInstances
         Dim intCount, intAssocCount, intRefCount 
         Dim strCIMKey, varCIMKeyValue, strWMISubscriptionPath, strWQLQuery
         Dim strStartDate, strStartTime, strStartGMT

         On Error Resume Next

         WriteToLogFile objLOGFileHandle, "Verifying Permanent subscription(s) for '" & strWMINameSpace & "'.", cLoggingLevel3, False

         Set objWMIInstances = objWMIServices.ExecQuery ("Select * From __EventConsumer")
         If Err.Number Then
            CheckPermanentSubscriptions = ErrorHandler (objLOGFileHandle, "CheckPermanentSubscriptions", "", False, Err)
            TrackingData.WMIExecQueryErrors = AddTrackingData (TrackingData.WMIExecQueryErrors, strWMINamespace & ";Select * From __EventConsumer;" & cWarning & ";" & strLastError)
            Exit Function
         End If

         intCount = objWMIInstances.Count
         If Err.Number Then
            CheckPermanentSubscriptions = ErrorHandler (objLOGFileHandle, "CheckPermanentSubscriptions", "", False, Err)
            TrackingData.WMIExecQueryErrors = AddTrackingData (TrackingData.WMIExecQueryErrors, strWMINamespace & ";Select * From __EventConsumer;" & cWarning & ";" & strLastError)
            Exit Function
         End If

         WriteToLogFile objLOGFileHandle, intCount & " permanent subscription(s) in '" & strWMINameSpace & "' namespace.", cLoggingLevel3, False

         If intCount > 0 Then
            intCount = 0
            For Each objWMIInstance In objWMIInstances
                intCount = intCount + 1
                WriteToLogFile objLOGFileHandle, "", cLoggingLevel4, False

                strCIMKey = FindCIMKey (objWMIServices, objWMIInstance)
                If Len (strCIMKey) > 0 Then
                   varCIMKeyValue = objWMIInstance.Properties_.Item (strCIMKey)
                   strWMISubscriptionPath = objWMIInstance.Path_.Class & "." & strCIMKey & "=" & chr(34) & varCIMKeyValue & chr(34) 
                   WriteToLogFile objLOGFileHandle, "#" & intCount & " '" & strWMISubscriptionPath & "' permanent subscription.", cLoggingLevel4, False
                Else
                   strWMISubscriptionPath = objWMIInstance.Path_.Class
                   WriteToLogFile objLOGFileHandle, "#" & intCount & " '" & strWMISubscriptionPath & "' permanent subscription class.", cLoggingLevel4, False
                End If                
                DisplayFormattedWMIProperties objLOGFileHandle, objWMIInstance, intCount, 2, cLoggingLevel4

                Set objWMIAssocInstances = objWMIInstance.References_
                If Err.Number Then
                   CheckPermanentSubscriptions = ErrorHandler (objLOGFileHandle, "CheckPermanentSubscriptions", "", False, Err)
                   TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";References_;" & objWMIInstance.Path_.Class & ";" & cWarning & ";" & strLastError)
                Else
                   intAssocCount = objWMIAssocInstances.Count
                   If Err.Number Then
                      CheckPermanentSubscriptions = ErrorHandler (objLOGFileHandle, "CheckPermanentSubscriptions", "", False, Err)
                      TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";References_;" & objWMIInstance.Path_.Class & ";" & cWarning & ";" & strLastError)
                      intAssocCount = 0
                   End If

                   If intAssocCount > 0 Then
                      intAssocCount = 0
                      For Each objWMIAssocInstance In objWMIAssocInstances
                          intAssocCount = intAssocCount + 1
                          DisplayFormattedWMIProperties objLOGFileHandle, objWMIAssocInstance, intAssocCount, 4, cLoggingLevel4
                      Next
                   End If
                End If

                Set objWMIRefInstances = objWMIInstance.Associators_
                If Err.Number Then
                   CheckPermanentSubscriptions = ErrorHandler (objLOGFileHandle, "CheckPermanentSubscriptions", "", False, Err)
                   TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";Associators_;" & objWMIInstance.Path_.Class & ";" & cWarning & ";" & strLastError)
                Else
                   intRefCount = objWMIRefInstances.Count
                   If Err.Number Then
                      CheckPermanentSubscriptions = ErrorHandler (objLOGFileHandle, "CheckPermanentSubscriptions", "", False, Err)
                      TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";Associators_;" & objWMIInstance.Path_.Class & ";" & cWarning & ";" & strLastError)
                      intRefCount = 0
                   End If

                   If intRefCount > 0 Then
                      intRefCount = 0
                      For Each objWMIRefInstance In objWMIRefInstances
                          intRefCount = intRefCount + 1
                          DisplayFormattedWMIProperties objLOGFileHandle, objWMIRefInstance, intRefCount, 4, cLoggingLevel4

                          strWQLQuery = objWMIRefInstance.Query
                          If Len (strWQLQuery) > 0 Then 
                             TrackingData.PermanentSubscriptions = AddTrackingData (TrackingData.PermanentSubscriptions, strWMINameSpace & ";" & strWMISubscriptionPath & ";"& strWQLQuery)
                          End If
                      Next
                   End If
                End If
            Next

            WriteToLogFile objLOGFileHandle, "", cLoggingLevel4, False
         End If 

         Set objWMIInstances = objWMIServices.ExecQuery ("Select * From __TimerInstruction")
         If Err.Number Then
            CheckPermanentSubscriptions = ErrorHandler (objLOGFileHandle, "CheckPermanentSubscriptions", "", False, Err)
            TrackingData.WMIExecQueryErrors = AddTrackingData (TrackingData.WMIExecQueryErrors, strWMINamespace & ";Select * From __TimerInstruction;" & cWarning & ";" & strLastError)
            Exit Function
         End If

         intCount = objWMIInstances.Count
         If Err.Number Then
            CheckPermanentSubscriptions = ErrorHandler (objLOGFileHandle, "CheckPermanentSubscriptions", "", False, Err)
            TrackingData.WMIExecQueryErrors = AddTrackingData (TrackingData.WMIExecQueryErrors, strWMINamespace & ";Select * From __TimerInstruction;" & cWarning & ";" & strLastError)
            Exit Function
         End If

         WriteToLogFile objLOGFileHandle, intCount & " Timer instruction(s) in '" & strWMINameSpace & "' namespace.", cLoggingLevel3, False

         If intCount > 0 Then
            intCount = 0
            For Each objWMIInstance In objWMIInstances
                intCount = intCount + 1

                WriteToLogFile objLOGFileHandle, "", cLoggingLevel4, False

                WriteToLogFile objLOGFileHandle, "#" & intCount & " '" & objWMIInstance.TimerID & "' Timer instruction.", cLoggingLevel4, False
                DisplayFormattedWMIProperties objLOGFileHandle, objWMIInstance, intCount, 2, cLoggingLevel4

                If UCase (objWMIInstance.Path_.Class) = "__INTERVALTIMERINSTRUCTION" Then
                   TrackingData.TimerInstructions = AddTrackingData (TrackingData.TimerInstructions, "Interval;" & strWMINameSpace & ";" & objWMIInstance.TimerID & ";"& objWMIInstance.IntervalBetweenEvents)
                Else
                   TrackingData.TimerInstructions = AddTrackingData (TrackingData.TimerInstructions, "Absolute;" & strWMINameSpace & ";" & objWMIInstance.TimerID & ";"& ConvertDMTFDateTimeToLongDateTime (objLOGFileHandle, objWMIInstance.EventDateTime, strStartDate, strStartTime, strStartGMT, True))
                End If
            Next

            WriteToLogFile objLOGFileHandle, "", cLoggingLevel4, False
         End If 
    
         Set objWMIInstances = Nothing

End Function

' --------------------------------------------------------------------------------------------------------
Function FindCIMKey (ByVal objWMIServices, ByVal objWMIInstance)

         Dim objWMIClass
         Dim objWMIProperty, objWMIProperties
         Dim boolCIMKey

         On Error Resume Next

         Set objWMIClass = objWMIServices.Get (objWMIInstance.Path_.Class)
         Set objWMIProperties = objWMIClass.Properties_
         For Each objWMIProperty In objWMIProperties
             boolCIMKey = False
             boolCIMKey = objWMIClass.Properties_.Item (objWMIProperty.Name).Qualifiers_.Item("key").Value 
             If boolCIMKey = True Then
                FindCIMKey = objWMIProperty.Name
                Exit Function
             End If
         Next

         FindCIMKey = ""

End Function

' --------------------------------------------------------------------------------------------------------
Function DecipherDCOMSD (ByVal objLOGFileHandle, ByVal strDCOMApplication, ByVal strCLSID, ByVal strKeyValueName, ByVal strKeyDisplayName, ByVal arrayDefaultSD)

         Dim strKeyName
         Dim objSD   
         Dim strHexSD, arraySD
         Dim arrayRegistryValue 
         Dim strSecuredObjectName
         Dim intDComSD

         On Error Resume Next

         If Instr (UCase(strKeyValueName), "ACCESS") Then
            intDComSD = cDComSDAccess
         Else
            intDComSD = cDComSDLaunch
         End If

         strSecuredObjectName = "DCOM security for '" & strDCOMApplication & "' (" & strKeyDisplayName & ")"
         WriteToLogFile objLOGFileHandle, "Deciphering " & strSecuredObjectName, cLoggingLevel3, False

         If Len (strCLSID) = 0 Then
            strKeyName = "HKLM\SOFTWARE\Microsoft\Ole"
         Else
            strKeyName = "HKLM\SOFTWARE\Classes\AppID" & "\" & strCLSID
         End If

         arrayRegistryValue = ReadRegistry (objLOGFileHandle, strKeyName, _
                                            strKeyValueName, _
                                            "REG_BINARY", _
                                            False)

         If IsArray (arrayRegistryValue) = True Then
            strHexSD = ConvertArrayInString (arrayRegistryValue, ",") 
            strHexSD = ReplaceString (strHexSD , ",", "")
            strHexSD = ReplaceString (strHexSD , "&h", "")
            If ConvertBinSDtoObjSD (objLOGFileHandle, strHexSD, objSD) = False Then
               arraySD = ConvertObjSDToArraySD (objSD)
               DisplayDecipheredArraySD objLOGFileHandle, arraySD, intDComSD, False
               CompareDecipheredArraySD objLOGFileHandle, arraySD, arrayDefaultSD, intDComSD, strSecuredObjectName, cSecuritySystem
            End If
         Else
            DisplayDecipheredArraySD objLOGFileHandle, arrayDefaultSD, intDComSD, True
            CompareDecipheredArraySD objLOGFileHandle, arrayDefaultSD, arrayDefaultSD, intDComSD, strSecuredObjectName, cSecuritySystem
         End If

         WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False

End Function

' --------------------------------------------------------------------------------------------------------
Function DecipherWMISD (ByVal objLOGFileHandle, ByVal strWMINamespace, ByVal arrayBinSD)

         Dim objSD   
         Dim strHexSD
         Dim arraySD
         Dim strSecuredObjectName
         Dim arrayWMIActiveNameSpaceSecurity, intSecurityType

         On Error Resume Next

         strSecuredObjectName = "WMI namespace security for '" & strWMINameSpace & "'"
         WriteToLogFile objLOGFileHandle, "Deciphering " & strSecuredObjectName, cLoggingLevel3, False

         strHexSD = ConvertBinDataToHexString (arrayBinSD)
         If ConvertBinSDtoObjSD (objLOGFileHandle, strHexSD, objSD) = False Then
            arraySD = ConvertObjSDToArraySD (objSD)
            arraySD = CalculateEffectiveACEInArraySD (objLOGFileHandle, arraySD)
            DisplayDecipheredArraySD objLOGFileHandle, arraySD, cWMINameSpaceSD, False

            If Len (strSecuredObjectName) > 80 Then strSecuredObjectName = Mid (strSecuredObjectName, 1, 80) & ">...'"

            intSecurityType = LocateNameSpaceExpectedSecurity (objLOGFileHandle, strWMINamespace, arrayWMIActiveNameSpaceSecurity)
            CompareDecipheredArraySD objLOGFileHandle, arraySD, arrayWMIActiveNameSpaceSecurity, cWMINameSpaceSD, strSecuredObjectName, intSecurityType
         End If

         WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False

End Function

' --------------------------------------------------------------------------------------------------------
Function LocateNameSpaceExpectedSecurity (ByVal objLOGFileHandle, ByVal strWMINamespace, ByRef arrayWMIActiveNameSpaceSecurity)

         Dim intIndex, boolNameSpaceNotFound

         On Error Resume Next

         WriteToLogFile objLOGFileHandle, "Searching if namespace '" & strWMINamespace & "' security analysis must be SKIPPED ...", cLoggingLevel3, False
         For intIndex = 0 To UBound (arrayWMINameSpaceSkippedSecurity)
             If EvaluateRegExp (objLOGFileHandle, strWMINamespace, arrayWMINameSpaceSkippedSecurity (intIndex)) = True Then
                WriteToLogFile objLOGFileHandle, "Namespace '" & strWMINamespace & "' security analysis SKIPPED.", cLoggingLevel3, False
                arrayWMIActiveNameSpaceSecurity = Null
                LocateNameSpaceExpectedSecurity = cSecurityException
                Exit Function
             End If 
         Next

         WriteToLogFile objLOGFileHandle, "Searching if namespace '" & strWMINamespace & "' security settings use a SYSTEM specific security ...", cLoggingLevel3, False
         For intIndex = 0 To UBound (arrayWMINameSpaceSecurity) Step 2
             If EvaluateRegExp (objLOGFileHandle, strWMINamespace, arrayWMINameSpaceSecurity (intIndex)) = True Then
                WriteToLogFile objLOGFileHandle, "Namespace '" & strWMINamespace & "' uses a SYSTEM specific namespace security.", cLoggingLevel3, False
                arrayWMIActiveNameSpaceSecurity = arrayWMINameSpaceSecurity (intIndex + 1)
                LocateNameSpaceExpectedSecurity = cSecuritySystem
                Exit Function
             End If 
         Next

         WriteToLogFile objLOGFileHandle, "Searching if namespace '" & strWMINamespace & "' security settings use an APPLICATION specific security ...", cLoggingLevel3, False
         For intIndex = 0 To UBound (arrayWMIAppsNameSpaceSecurity) Step 2
             If EvaluateRegExp (objLOGFileHandle, strWMINamespace, arrayWMIAppsNameSpaceSecurity (intIndex)) = True Then
                WriteToLogFile objLOGFileHandle, "Namespace '" & strWMINamespace & "' uses an APPLICATION specific namespace security.", cLoggingLevel3, False
                arrayWMIActiveNameSpaceSecurity = arrayWMIAppsNameSpaceSecurity (intIndex + 1)
                LocateNameSpaceExpectedSecurity = cSecurityApplication
                Exit Function
             End If 
         Next

         WriteToLogFile objLOGFileHandle, "Namespace '" & strWMINamespace & "' uses a DEFAULT WMI namespace security.", cLoggingLevel3, False
         arrayWMIActiveNameSpaceSecurity = arrayWMIDefaultNameSpaceSecurity
         LocateNameSpaceExpectedSecurity = cSecurityDefaulted

End Function

' --------------------------------------------------------------------------------------------------------
Function ConvertBinSDtoObjSD (ByVal objLOGFileHandle, ByVal strHexSD, ByRef objSD)

         On Error Resume Next

         objADsSecurity.SecurityMask = ADS_SECURITY_INFO_OWNER Or _
                                       ADS_SECURITY_INFO_GROUP Or _
                                       ADS_SECURITY_INFO_DACL Or _
                                       ADS_SECURITY_INFO_SACL

         Set objSD = objADSSecurity.ConvertSecurityDescriptor (strHexSD, ADS_SD_FORMAT_HEXSTRING, ADS_SD_FORMAT_IID)
         If Err.Number Then
            ConvertBinSDtoObjSD = ErrorHandler (objLOGFileHandle, "ConvertBinSDtoObjSD", "", False, Err)
         Else
            ConvertBinSDtoObjSD = False
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function ConvertBinDataToHexString (arrayBinData)

         Dim strbyte, intIndex

         On Error Resume Next

         For intIndex = 0 to UBound (arrayBinData)
             strbyte = Right ("0" & Hex (arrayBinData (intIndex)), 2)
             ConvertBinDataToHexString = ConvertBinDataToHexString & strbyte
         Next

End Function

' ----------------------------------------------------------------------------------------
Function ConvertObjSDToArraySD (ByVal objSD)

         Dim objACL
         Dim objACE
         Dim intACETotal, intACECounter, intIndex
         Dim arraySD, arrayACL

         On Error Resume Next

         ReDim arraySD (5)
         ReDim arrayACL (0)
        
         arraySD (0) = objSD.Owner
         arraySD (1) = objSD.Group
         ' objSD.Revision
         arraySD (2) = objSD.Control

         Set objACL = objSD.DiscretionaryAcl
         intACETotal = objACL.AceCount
         If intACETotal And Err.Number = 0 Then     
            ReDim arrayACL ((intACETotal * 4) - 1)
            intIndex = 0
            For Each objACE In objACL
                arrayACL (intIndex) = objACE.Trustee
                arrayACL (intIndex + 1) = objACE.AceType
                arrayACL (intIndex + 2) = objACE.AceFlags
                arrayACL (intIndex + 3) = objACE.AccessMask
                intIndex = intIndex + 4
            Next
            arraySD (3) = arrayACL
         Else
            Err.Clear
            arraySD (3) = Null
         End If

         Set objACL = objSD.SystemACL
         intACETotal = objACL.AceCount
         If intACETotal And Err.Number = 0 Then    
            ReDim arrayACL ((intACETotal * 4) - 1)
            intIndex = 0
            For Each objACE In objACL
                arrayACL (intIndex) = objACE.Trustee
                arrayACL (intIndex + 1) = objACE.AceType
                arrayACL (intIndex + 2) = objACE.AceFlags
                arrayACL (intIndex + 3) = objACE.AccessMask
                intIndex = intIndex + 4
            Next
            arraySD (4) = arrayACL
         Else
            Err.Clear
            arraySD (4) = Null
         End If

         ConvertObjSDToArraySD = arraySD

End Function

' ----------------------------------------------------------------------------------------
Function CalculateEffectiveACEInArraySD (ByVal objLOGFileHandle, ByVal arraySD)

         Dim intIndex1, arrayACL
         Dim intIndex2, intIndex3, intNewIndex, arrayNewSD, arrayNewACL
         Dim boolDuplicateACEFound, boolCombinedACEFound
         Const cDestroyedTrustee = "@#$1234!5678$#@"

         On Error Resume Next

         ReDim arrayNewSD (5)
         ReDim arrayNewACL (0)
         
         arrayNewSD (0) = UCase (arraySD (0)) ' Owner
         arrayNewSD (1) = UCase (arraySD (1)) ' Group
         arrayNewSD (2) = UCase (arraySD (2)) ' Control

         intNewIndex = 0
         arrayACL = arraySD (3)

         If IsNull (arrayACL) = False Then
            For intIndex1=0 To UBound (arrayACL) - 1 Step 4
                arrayACL (intIndex1) = UCase (objWshShell.ExpandEnvironmentStrings (arrayACL (intIndex1)))
                If arrayACL (intIndex1) <> cDestroyedTrustee Then
                   boolDuplicateACEFound = False

                   For intIndex2 = intIndex1 + 4 To UBound (arrayACL) - 1 Step 4
                       arrayACL (intIndex2) = UCase (objWshShell.ExpandEnvironmentStrings (arrayACL (intIndex2)))

                       If arrayACL (intIndex2) <> cDestroyedTrustee Then
                          WriteToLogFile objLOGFileHandle, "Evaluating ACE '" & arrayACL (intIndex1) & "' (ACE #" & (intIndex1 / 4) + 1 & ") and '" & arrayACL (intIndex2) & "' (ACE #" & (intIndex2 / 4) + 1 & ")", cLoggingDebug Or cLoggingLevel4, False
                          WriteToLogFile objLOGFileHandle, "               '" & arrayACL (intIndex1) & "' (ACEType=&h" & Hex (arrayACL (intIndex1 + 1)) & ") and '" & arrayACL (intIndex2) & "' (ACEType=&h" & Hex (arrayACL (intIndex2 + 1)) & ")", cLoggingDebug Or cLoggingLevel4, False
   
                          If EvaluateRegExp (objLOGFileHandle, arrayACL (intIndex1), arrayACL (intIndex2)) = True And _
                             arrayACL (intIndex1 + 1) = arrayACL (intIndex2 + 1) Then
                             boolDuplicateACEFound = True
              
                             boolCombinedACEFound = False
                             If UBound (arrayNewACL) > 0 Then 
   
                                For intIndex3=0 To UBound (arrayNewACL) - 1 Step 4
                                    WriteToLogFile objLOGFileHandle, "Evaluating against existing combined ACE '" & arrayACL (intIndex1) & "' (ACE #" & (intIndex1 / 4) + 1 & ") and '" & arrayNewACL (intIndex3) & "' (ACE #" & (intIndex3 / 4) + 1 & ")", cLoggingDebug Or cLoggingLevel4, False
                                    WriteToLogFile objLOGFileHandle, "                                         '" & arrayACL (intIndex1) & "' (ACEType=&h" & Hex (arrayACL (intIndex1 + 1)) & ") and '" & arrayNewACL (intIndex3) & "' (ACEType=&h" & Hex (arrayNewACL (intIndex3 + 1)) & ")", cLoggingDebug Or cLoggingLevel4, False
         
                                    If EvaluateRegExp (objLOGFileHandle, arrayACL (intIndex1), arrayNewACL (intIndex3)) = True And _
                                       arrayACL (intIndex1 + 1) = arrayNewACL (intIndex3 + 1) Then
                                       boolCombinedACEFound = True
      
                                       WriteToLogFile objLOGFileHandle, "Combining into existing combined ACE '" & arrayACL (intIndex1) & "' (ACE #" & (intIndex1 / 4) + 1 & ") and '" & arrayNewACL (intIndex3) & "' (ACE #" & (intIndex3 / 4) + 1 & ")", cLoggingDebug Or cLoggingLevel4, False
                                       WriteToLogFile objLOGFileHandle, "                                     '" & arrayACL (intIndex1) & "' (AccessMask=&h" & Hex (arrayACL (intIndex1 + 3)) & ") and '" & arrayNewACL (intIndex3) & "' (AccessMask=&h" & Hex (arrayNewACL (intIndex3 + 3)) & ")", cLoggingDebug Or cLoggingLevel4, False
      
                                       arrayNewACL (intIndex3) = arrayACL (intIndex1)                                         ' Trustee
                                       arrayNewACL (intIndex3 + 1) = arrayACL (intIndex1 + 1)                                 ' ACEType
                                       arrayNewACL (intIndex3 + 2) = arrayACL (intIndex1 + 2) Or arrayNewACL (intIndex3 + 2)  ' ACEFlags
                                       arrayNewACL (intIndex3 + 3) = arrayACL (intIndex1 + 3) Or arrayNewACL (intIndex3 + 3)  ' AccessMask
      
                                       WriteToLogFile objLOGFileHandle, "Assigned to existing combined ACE '" & arrayNewACL (intIndex3) & "' (ACE #" & (intIndex3 / 4) + 1 & ")", cLoggingDebug Or cLoggingLevel4, False
                                       WriteToLogFile objLOGFileHandle, "                                  '" & arrayNewACL (intIndex3) & "' (AccessMask=&h" & Hex (arrayNewACL (intIndex3 + 3)) & ")", cLoggingDebug Or cLoggingLevel4, False
        
                                       Exit For
                                    End If
                                Next
                             End If 
   
                             If boolCombinedACEFound = False Then 
                                WriteToLogFile objLOGFileHandle, "Combining into new combined ACE '" & arrayACL (intIndex1) & "' (ACE #" & (intIndex1 / 4) + 1 & ") and '" & arrayACL (intIndex2) & "' (ACE #" & (intIndex2 / 4) + 1 & ")", cLoggingDebug Or cLoggingLevel4, False
                                WriteToLogFile objLOGFileHandle, "                                '" & arrayACL (intIndex1) & "' (AccessMask=&h" & Hex (arrayACL (intIndex1 + 3)) & ") and '" & arrayACL (intIndex2) & "' (AccessMask=&h" & Hex (arrayACL (intIndex2 + 3)) & ")", cLoggingDebug Or cLoggingLevel4, False
      
                                ReDim Preserve arrayNewACL (intNewIndex + 4)
                                arrayNewACL (intNewIndex) = arrayACL (intIndex1)                                      ' Trustee
                                arrayNewACL (intNewIndex + 1) = arrayACL (intIndex1 + 1)                              ' ACEType
                                arrayNewACL (intNewIndex + 2) = arrayACL (intIndex1 + 2) Or arrayACL (intIndex2 + 2)  ' ACEFlags
                                arrayNewACL (intNewIndex + 3) = arrayACL (intIndex1 + 3) Or arrayACL (intIndex2 + 3)  ' AccessMask
      
                                WriteToLogFile objLOGFileHandle, "Assigned to new combined ACE '" & arrayNewACL (intNewIndex) & "' (ACE #" & (intNewIndex / 4) + 1 & ")", cLoggingDebug Or cLoggingLevel4, False
                                WriteToLogFile objLOGFileHandle, "                             '" & arrayNewACL (intNewIndex) & "' (AccessMask=&h" & Hex (arrayNewACL (intNewIndex + 3)) & ")", cLoggingDebug Or cLoggingLevel4, False
      
                                intNewIndex = intNewIndex + 4
                             End If
      
                             arrayACL (intIndex2) = cDestroyedTrustee ' Destroy ACE to prevent duplication in combined trustee
                             arrayACL (intIndex2 + 1) = 0             ' ACEType
                             arrayACL (intIndex2 + 2) = 0             ' ACEFlags
                             arrayACL (intIndex2 + 3) = 0             ' AccessMask
                          Else
                             WriteToLogFile objLOGFileHandle, "Skipped.", cLoggingDebug Or cLoggingLevel4, False
                          End If
                       End If
                   Next
   
                   If boolDuplicateACEFound = False Then
                      ReDim Preserve arrayNewACL (intNewIndex + 4)
                      arrayNewACL (intNewIndex) = arrayACL (intIndex1)            ' Trustee
                      arrayNewACL (intNewIndex + 1) = arrayACL (intIndex1 + 1)    ' ACEType
                      arrayNewACL (intNewIndex + 2) = arrayACL (intIndex1 + 2)    ' ACEFlags
                      arrayNewACL (intNewIndex + 3) = arrayACL (intIndex1 + 3)    ' AccessMask
   
                      WriteToLogFile objLOGFileHandle, "Assigned into new ACE '" & arrayNewACL (intNewIndex) & "' (ACE #" & (intNewIndex / 4) + 1 & ")", cLoggingDebug Or cLoggingLevel4, False
                      WriteToLogFile objLOGFileHandle, "                      '" & arrayNewACL (intNewIndex) & "' (AccessMask=&h" & Hex (arrayNewACL (intNewIndex + 3)) & ")", cLoggingDebug Or cLoggingLevel4, False
   
                      intNewIndex = intNewIndex + 4
                   End If 
                End If 
            Next
         End If 

         arrayNewSD (3) = arrayNewACL   ' New DACL
         arrayNewSD (4) = arraySD (4)   ' SACL

         CalculateEffectiveACEInArraySD = arrayNewSD

End Function

' ----------------------------------------------------------------------------------------
Function CompareDecipheredArraySD (ByVal objLOGFileHandle, ByVal arraySD, ByVal arrayDefaultSD, ByVal intSDType, ByVal strSecuredObjectName, ByVal intSecurityType)

         Dim arrayACL, arrayDefaultACL
         Dim intIndex, intDefaultIndex
         Dim boolSDNoMatch, boolTrusteeNotFound, boolTrusteeACENoMatch, boolDefaultTrusteeNotFound, boolDefaultTrusteeACENoMatch
         Dim boolTrusteeInvalidACE, boolDefaultTrusteeInvalidACE
         Dim strNonMatchingACE
         Dim intLoggingLevel

         On Error Resume Next

         If intSecurityType = cSecurityException Then
            TrackingData.SecurityDescriptor = AddTrackingData (TrackingData.SecurityDescriptor, "@SKIPPED;" & strSecuredObjectName & ";" & intSecurityType)
            Exit Function
         End If

         If IsNull (arraySD) = True Then
            Exit Function
         End If

         TrackingData.SecurityDescriptor = AddTrackingData (TrackingData.SecurityDescriptor, "@OK;" & strSecuredObjectName & ";" & intSecurityType)

         ' Skip testing of SD owner, group and ACE protection behavior
         ' Open Security Descriptor data ----------------------------------------------------------------------
         ' If UCase (arraySD (0)) <> UCase (arrayDefaultSD (0)) Or _
         '    UCase (arraySD (1)) <> UCase (arrayDefaultSD (1)) Or _
         '    UCase (arraySD (2)) <> UCase (arrayDefaultSD (2)) Then
         '    boolSDNoMatch = True
         ' End If

         ' If boolSDNoMatch = True Then
         '    WriteToLogFile objLOGFileHandle, "Owner" & "=" & arraySD (0) & "=" & arrayDefaultSD (0), cLoggingLevel3, False
         '    WriteToLogFile objLOGFileHandle, "Group" & "=" & arraySD (1) & "=" & arrayDefaultSD (1), cLoggingLevel3, False
         '    WriteToLogFile objLOGFileHandle, "Control" & "=" & DecipherSDControlFlags (arraySD (2), False) & "=" & DecipherSDControlFlags (arrayDefaultSD (2), False), cLoggingLevel3, False
         ' End If

         arrayACL = arraySD (3)
         arrayDefaultACL = arrayDefaultSD (3)

         If IsNull (arrayACL) = False And IsNull (arrayDefaultACL) = False Then
            ' Check if actual trustees are matching the default ones and detect added ones.
            WriteToLogFile objLOGFileHandle, "Verifying actual trustees in ACEs against the default trustees in ACEs to locate actual trustee additions.", cLoggingLevel3, False

            For intIndex=0 To UBound (arrayACL) - 1 Step 4
                arrayACL (intIndex) = UCase (objWshShell.ExpandEnvironmentStrings (arrayACL (intIndex)))

                boolTrusteeNotFound = True
                boolTrusteeACENoMatch = False
                boolTrusteeInvalidACE = False
                strNonMatchingACE = ""

                For intDefaultIndex=0 To UBound (arrayDefaultACL) - 1 Step 4
                    arrayDefaultACL (intDefaultIndex) = UCase (objWshShell.ExpandEnvironmentStrings (arrayDefaultACL (intDefaultIndex)))

                    If EvaluateRegExp (objLOGFileHandle, arrayACL (intIndex), arrayDefaultACL (intDefaultIndex)) = True And _
                       arrayACL (intIndex + 1) = arrayDefaultACL (intDefaultIndex + 1) Then
                       boolTrusteeNotFound = False

                       ' ACEType
                       ' If arrayACL (intIndex + 1) <> arrayDefaultACL (intDefaultIndex + 1) Then
                       '    boolTrusteeACENoMatch = True
                       ' End If


                       ' Skip ACE inheritance settings. Just check effective rights
                       ' ACEFlags
                       ' If arrayACL (intIndex + 2) <> arrayDefaultACL (intDefaultIndex + 2) Then
                       '    boolTrusteeACENoMatch = True
                       ' End If

                       ' ACEMask   
                       Select Case intSDType 
                              Case cDComSDAccess
                                   If (arrayACL (intIndex + 3) And DCOM_RIGHT_EXECUTE) = DCOM_RIGHT_EXECUTE Then
                                      If arrayACL (intIndex + 3) = DCOM_RIGHT_EXECUTE Then
                                         If RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP2 Or _
				            RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP3 Or _
                                            RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP164 Or _
                                            RunTimeEnvironmentInfo.OSIdentifier >= cWindows2003SP1 Then
                                            arrayACL (intIndex + 3) = DCOM_RIGHT_EXECUTE Or DCOM_RIGHT_ACCESS_LOCAL Or DCOM_RIGHT_ACCESS_REMOTE
                                         End If
                                      End If

                                      If arrayACL (intIndex + 3) <> arrayDefaultACL (intDefaultIndex + 3) Then
                                         strNonMatchingACE = FindNonMatchingACE (intSDType, arrayACL (intIndex + 3), arrayDefaultACL (intDefaultIndex + 3))
                                         boolTrusteeACENoMatch = True
                                      End If

                                      Exit For
                                   Else
                                      boolTrusteeInvalidACE = True
                                   End If

                              Case cDComSDLaunch
                                   If (arrayACL (intIndex + 3) And DCOM_RIGHT_EXECUTE) = DCOM_RIGHT_EXECUTE Then
                                      If arrayACL (intIndex + 3) = DCOM_RIGHT_EXECUTE Then
                                         If RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP2 Or _
            				    RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP3 Or _
                                            RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP164 Or _
                                            RunTimeEnvironmentInfo.OSIdentifier >= cWindows2003SP1 Then
                                            arrayACL (intIndex + 3) = DCOM_RIGHT_EXECUTE Or DCOM_RIGHT_LAUNCH_LOCAL Or DCOM_RIGHT_LAUNCH_REMOTE Or DCOM_RIGHT_ACTIVATE_LOCAL Or DCOM_RIGHT_ACTIVATE_REMOTE
                                         End If
                                      End If
 
                                      If arrayACL (intIndex + 3) <> arrayDefaultACL (intDefaultIndex + 3) Then
                                         strNonMatchingACE = FindNonMatchingACE (intSDType, arrayACL (intIndex + 3), arrayDefaultACL (intDefaultIndex + 3))
                                         boolTrusteeACENoMatch = True
                                      End If

                                      Exit For
                                   Else
                                      boolTrusteeInvalidACE = True
                                   End If

                              Case Else
                                   If arrayACL (intIndex + 3) <> arrayDefaultACL (intDefaultIndex + 3) Then
                                      strNonMatchingACE = FindNonMatchingACE (intSDType, arrayACL (intIndex + 3), arrayDefaultACL (intDefaultIndex + 3))
                                      boolTrusteeACENoMatch = True
                                   End If

                                   Exit For
                       End Select
                    End If
                Next

                intLoggingLevel = cLoggingLevel0

                If boolTrusteeNotFound = True Then
                   WriteToLogFile objLOGFileHandle, "Not found!", cLoggingDebug Or cLoggingLevel4, False
                   WriteToLogFile objLOGFileHandle, "Actual trustee '" & arrayACL (intIndex) & "' has been ADDED for ACE #" & (intIndex / 4) + 1 & ".", cLoggingLevel2, False

                   If arrayACL (intIndex + 1) = ACCESS_DENIED_ACE_TYPE Then
                      If intLoggingLevel <> cLoggingLevel1 Then intLoggingLevel = cLoggingLevel2
                   End If

                   TrackingData.SecurityDescriptor = AddTrackingData (TrackingData.SecurityDescriptor, "ADDED;" & _
                                                                                                       intSDType & ";" & _
                                                                                                       "Actual trustee '" & arrayACL (intIndex) & "' has been ADDED!;" & _
                                                                                                       DecipherACEType (intSDType, arrayACL (intIndex + 1), False) & ";" & _
                                                                                                       DecipherACEFlags (intSDType, arrayACL (intIndex + 2), False) & ";" & _
                                                                                                       DecipherACEMask (intSDType, arrayACL (intIndex + 3), False) & ";" & _
                                                                                                       "" & ";" & _
                                                                                                       intLoggingLevel)
                Else
                   WriteToLogFile objLOGFileHandle, "Found!", cLoggingDebug Or cLoggingLevel4, False
                End If

                If boolTrusteeACENoMatch = True Then
                   WriteToLogFile objLOGFileHandle, "Actual trustee '" & arrayACL (intIndex) & "' DOES NOT match corresponding expected trustee rights for ACE #" & (intIndex / 4 ) + 1 & ".", cLoggingLevel2, False
                   WriteToLogFile objLOGFileHandle, "The " & strNonMatchingACE, cLoggingLevel3, False

                   If Instr (strNonMatchingACE, "removed") > 0 Then
                      intLoggingLevel = cLoggingLevel1
                   End If
                   If Instr (strNonMatchingACE, "added") > 0 Then
                      If arrayACL (intIndex + 1) = ACCESS_DENIED_ACE_TYPE Then
                         If intLoggingLevel <> cLoggingLevel1 Then intLoggingLevel = cLoggingLevel2
                      End If
                   End If

                   TrackingData.SecurityDescriptor = AddTrackingData (TrackingData.SecurityDescriptor, "NOACTUALMATCH;" & _
                                                                                                       intSDType & ";" & _
                                                                                                       "Actual trustee '" & arrayACL (intIndex) & "' DOES NOT match corresponding expected trustee rights (Actual->Default);" & _
                                                                                                       DecipherACEType (intSDType, arrayACL (intIndex + 1), False) & "/" & DecipherACEType (intSDType, arrayDefaultACL (intDefaultIndex + 1), False) & ";" & _
                                                                                                       DecipherACEFlags (intSDType, arrayACL (intIndex + 2), False) & "/" & DecipherACEFlags (intSDType, arrayDefaultACL (intDefaultIndex + 2), False) & ";" & _
                                                                                                       DecipherACEMask (intSDType, arrayACL (intIndex + 3), False) & "/" & DecipherACEMask (intSDType, arrayDefaultACL (intDefaultIndex + 3), False) & ";" & _
                                                                                                       strNonMatchingACE & ";" & _
                                                                                                       intLoggingLevel)
                End If                   

                If boolTrusteeInvalidACE = True Then
                   WriteToLogFile objLOGFileHandle, "Actual trustee '" & arrayACL (intIndex) & "' has an INVALID ACE #" & (intIndex / 4 ) + 1 & "(&h" & Hex (arrayACL (intIndex + 3)) & ")", cLoggingLevel2, False

                   TrackingData.SecurityDescriptor = AddTrackingData (TrackingData.SecurityDescriptor, "INVALIDACE;" & _
                                                                                                       intSDType & ";" & _
                                                                                                       "Actual trustee '" & arrayACL (intIndex) & "' has an INVALID ACE (Actual->Default);" & _
                                                                                                       DecipherACEType (intSDType, arrayACL (intIndex + 1), False) & ";" & _
                                                                                                       DecipherACEFlags (intSDType, arrayACL (intIndex + 2), False) & ";" & _
                                                                                                       DecipherACEMask (intSDType, arrayACL (intIndex + 3), False) & ";" & _
                                                                                                       "" & ";" & _
                                                                                                       cLoggingLevel2)
                End If                   

                If boolTrusteeACENoMatch = True Or boolTrusteeNotFound = True Or boolTrusteeInvalidACE = True Then
                   TrackingData.SecurityDescriptor = ReplaceString (TrackingData.SecurityDescriptor, "@OK;" & strSecuredObjectName, "@MODIFIED;" & strSecuredObjectName)
                End If
            Next

            ' Check if expected default trustees are present and detect removed ones.
            WriteToLogFile objLOGFileHandle, "Verifying default trustee in ACEs against the actual trustees in ACEs to locate default trustee removals.", cLoggingLevel3, False

            For intDefaultIndex=0 To UBound (arrayDefaultACL) - 1 Step 4
                arrayDefaultACL (intDefaultIndex) = UCase (objWshShell.ExpandEnvironmentStrings (arrayDefaultACL (intDefaultIndex)))

                boolDefaultTrusteeNotFound = True
                boolDefaultTrusteeACENoMatch = False
                boolDefaultTrusteeInvalidACE = False
                strNonMatchingACE = ""

                For intIndex=0 To UBound (arrayACL) - 1 Step 4
                    arrayACL (intIndex) = UCase (objWshShell.ExpandEnvironmentStrings (arrayACL (intIndex)))

                    If EvaluateRegExp (objLOGFileHandle, arrayACL (intIndex), arrayDefaultACL (intDefaultIndex)) = True And _
                       arrayACL (intIndex + 1) = arrayDefaultACL (intDefaultIndex + 1) Then
                       boolDefaultTrusteeNotFound = False

                       ' ACEType
                       ' If arrayDefaultACL (intDefaultIndex + 1) <> arrayACL (intIndex + 1) Then
                       '    boolDefaultTrusteeACENoMatch = True
                       ' End If

                       ' Skip ACE inheritance settings. Just check effective rights
                       ' ACEFlags
                       ' If arrayDefaultACL (intDefaultIndex + 2) <> arrayACL (intIndex + 2) Then
                       '    boolDefaultTrusteeACENoMatch = True
                       ' End If

                       ' ACEMask      
                       Select Case intSDType 
                              Case cDComSDAccess
                                   If (arrayACL (intIndex + 3) And DCOM_RIGHT_EXECUTE) = DCOM_RIGHT_EXECUTE Then
                                      If arrayACL (intIndex + 3) = DCOM_RIGHT_EXECUTE Then
                                         If RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP2 Or _
				            RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP3 Or _
                                            RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP164 Or _
                                            RunTimeEnvironmentInfo.OSIdentifier >= cWindows2003SP1 Then
                                            arrayDefaultACL (intDefaultIndex + 3) = DCOM_RIGHT_EXECUTE Or DCOM_RIGHT_ACCESS_LOCAL Or DCOM_RIGHT_ACCESS_REMOTE
                                         End If
                                      End If 
    
                                      If arrayDefaultACL (intDefaultIndex + 3) <> arrayACL (intIndex + 3) Then
                                         strNonMatchingACE = FindNonMatchingACE (intSDType, arrayDefaultACL (intDefaultIndex + 3), arrayACL (intIndex + 3))
                                         boolTrusteeACENoMatch = True
                                      End If

                                      Exit For
                                   Else
                                      boolDefaultTrusteeInvalidACE = True
                                   End If

                              Case cDComSDLaunch
                                   If (arrayACL (intIndex + 3) And DCOM_RIGHT_EXECUTE) = DCOM_RIGHT_EXECUTE Then
                                      If arrayACL (intIndex + 3) = DCOM_RIGHT_EXECUTE Then
                                         If RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP2 Or _
				            RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP3 Or _
                                            RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP164 Or _
                                            RunTimeEnvironmentInfo.OSIdentifier >= cWindows2003SP1 Then
                                            arrayDefaultACL (intDefaultIndex + 3) = DCOM_RIGHT_EXECUTE Or DCOM_RIGHT_LAUNCH_LOCAL Or DCOM_RIGHT_LAUNCH_REMOTE Or DCOM_RIGHT_ACTIVATE_LOCAL Or DCOM_RIGHT_ACTIVATE_REMOTE
                                         End If
                                      End If
                                      If arrayDefaultACL (intDefaultIndex + 3) <> arrayACL (intIndex + 3) Then
                                         strNonMatchingACE = FindNonMatchingACE (intSDType, arrayDefaultACL (intDefaultIndex + 3), arrayACL (intIndex + 3))
                                         boolTrusteeACENoMatch = True
                                      End If

                                      Exit For
                                   Else
                                      boolDefaultTrusteeInvalidACE = True
                                   End If
                              Case Else
                                   If arrayDefaultACL (intDefaultIndex + 3) <> arrayACL (intIndex + 3) Then
                                      strNonMatchingACE = FindNonMatchingACE (intSDType, arrayDefaultACL (intDefaultIndex + 3), arrayACL (intIndex + 3))
                                      boolTrusteeACENoMatch = True
                                   End If

                                   Exit For
                       End Select
                    End If
                Next

                If boolDefaultTrusteeNotFound = True Then
                   WriteToLogFile objLOGFileHandle, "Not found!", cLoggingDebug Or cLoggingLevel4, False
                   WriteToLogFile objLOGFileHandle, "Default trustee '" & arrayDefaultACL (intDefaultIndex) & "' has been REMOVED!", cLoggingLevel2, False

                   TrackingData.SecurityDescriptor = AddTrackingData (TrackingData.SecurityDescriptor, "REMOVED;" & _
                                                                                                       intSDType & ";" & _
                                                                                                       "Default trustee '" & arrayDefaultACL (intDefaultIndex) & "' has been REMOVED!;" & _
                                                                                                       DecipherACEType (intSDType, arrayDefaultACL (intDefaultIndex + 1), False) & ";" & _
                                                                                                       DecipherACEFlags (intSDType, arrayDefaultACL (intDefaultIndex + 2), False) & ";" & _
                                                                                                       DecipherACEMask (intSDType, arrayDefaultACL (intDefaultIndex + 3), False) & ";" & _
                                                                                                       "" & ";" & _
                                                                                                       cLoggingLevel1)
                Else
                   WriteToLogFile objLOGFileHandle, "Found!", cLoggingDebug Or cLoggingLevel4, False
                End If

                If boolDefaultTrusteeACENoMatch = True Then
                   WriteToLogFile objLOGFileHandle, "Default trustee '" & arrayDefaultACL (intDefaultIndex) & "' does not match corresponding actual trustee rights for ACE #" & (intDefaultIndex / 4) + 1 & ".", cLoggingLevel2, False
                   WriteToLogFile objLOGFileHandle, "The " & strNonMatchingACE, cLoggingLevel3, False

                   TrackingData.SecurityDescriptor = AddTrackingData (TrackingData.SecurityDescriptor, "NODEFAULTMATCH;" & _
                                                                                                       intSDType & ";" & _
                                                                                                       "Default trustee '" & arrayDefaultACL (intDefaultIndex) & "' DOES NOT match corresponding actual trustee rights (Default->Actual);" & _
                                                                                                       DecipherACEType (intSDType, arrayDefaultACL (intDefaultIndex + 1), False) & "/" & DecipherACEType (intSDType, arrayACL (intIndex + 1), False) & ";" & _
                                                                                                       DecipherACEFlags (intSDType, arrayDefaultACL (intDefaultIndex + 2), False) & "/" & DecipherACEFlags (intSDType, arrayACL (intIndex + 2), False) & ";" & _
                                                                                                       DecipherACEMask (intSDType, arrayDefaultACL (intDefaultIndex + 3), False) & "/" & DecipherACEMask (intSDType, arrayACL (intIndex + 3), False) & ";" & _
                                                                                                       strNonMatchingACE & ";" & _
                                                                                                       cLoggingLevel0)
                End If

                If boolDefaultTrusteeInvalidACE = True Then
                   WriteToLogFile objLOGFileHandle, "Default trustee '" & arrayDefaultACL (intDefaultIndex) & "' has an INVALID ACE #" & (intDefaultIndex / 4 ) + 1 & "(&h" & Hex (arrayDefaultACL (intDefaultIndex + 3)) & ")", cLoggingLevel2, False

                   TrackingData.SecurityDescriptor = AddTrackingData (TrackingData.SecurityDescriptor, "INVALIDACE;" & _
                                                                                                       intSDType & ";" & _
                                                                                                       "Default trustee '" & arrayDefaultACL (intDefaultIndex) & "' has an INVALID ACE (Default->Actual);" & _
                                                                                                       DecipherACEType (intSDType, arrayDefaultACL (intDefaultIndex + 1), False) & ";" & _
                                                                                                       DecipherACEFlags (intSDType, arrayDefaultACL (intDefaultIndex + 2), False) & ";" & _
                                                                                                       DecipherACEMask (intSDType, arrayDefaultACL (intDefaultIndex + 3), False) & ";" & _
                                                                                                       "" & ";" & _
                                                                                                       cLoggingLevel2)
                End If

                If boolDefaultTrusteeACENoMatch = True Or boolDefaultTrusteeNotFound = True Or boolDefaultTrusteeInvalidACE = True Then
                   TrackingData.SecurityDescriptor = ReplaceString (TrackingData.SecurityDescriptor, "@OK;" & strSecuredObjectName, "@MODIFIED;" & strSecuredObjectName)
                End If
            Next
         Else
            Err.Clear
         End If

End Function

' ----------------------------------------------------------------------------------------
Function FindNonMatchingACE (ByVal intSDType, ByVal intACE1, ByVal intACE2)

         Dim intXOR, intNOT, intAdded, intRemoved

         On Error Resume Next

         intXOR = (intACE1 Xor intACE2) 
         intAdded = (intACE1 And intXOR)

         If intAdded <> 0 Then
            FindNonMatchingACE = "ACE has the right(s) '" & DecipherACEMask (intSDType, intAdded, False) & "' added!"
         End If

         intNOT = (NOT intACE1)
         intRemoved = (intACE2 And intNOT)

         If intRemoved <> 0 Then
            FindNonMatchingACE = "ACE has the right(s) '" & DecipherACEMask (intSDType, intRemoved, False) & "' removed!"
         End If

End Function

' ----------------------------------------------------------------------------------------
Function EvaluateRegExp (ByVal objLOGFileHandle, ByVal strString, ByVal strMatchPattern) 

         Dim objRegExp, objMatch, objMatches

         On Error Resume Next

         If Instr (strMatchPattern, "\") > 0 Then strMatchPattern = ReplaceChar (strMatchPattern, "\", "\\")
         If Mid (strMatchPattern, Len (strMatchPattern), 1) <> "*" Then strMatchPattern = strMatchPattern & "$"

         WriteToLogFile objLOGFileHandle, "Searching '" & strString & "' matching RegExp '" & strMatchPattern & "'.", cLoggingDebug Or cLoggingLevel4, False

         Set objRegExp = New RegExp 
         objRegExp.Global = True 
         objRegExp.IgnoreCase = True 
         objRegExp.Pattern = strMatchPattern 

         Set objMatches = objRegExp.Execute (strString) 

         EvaluateRegExp = False
         For Each objMatch in objMatches
             WriteToLogFile objLOGFileHandle, "RegExp matching at position " & objMatch.FirstIndex & " with value '" & objMatch.value & "'.", cLoggingDebug Or cLoggingLevel4, False
             EvaluateRegExp = True
         Next

         Set objRegExp = Nothing

End Function

' ----------------------------------------------------------------------------------------
Function DisplayDecipheredArraySD (ByVal objLOGFileHandle, ByVal arraySD, ByVal intSDType, ByVal boolDefault)

         Dim arrayACL
         Dim intACECounter, intIndex
         Dim strIndent

         On Error Resume Next

         If boolDefault = True Then
            WriteToLogFile objLOGFileHandle, strIndent & "+- Security Descriptor (DEFAULT) " & String (81 - Len (strIndent), "-"), cLoggingLevel4, False
         Else
            WriteToLogFile objLOGFileHandle, strIndent & "+- Security Descriptor " & String (90 - Len (strIndent), "-"), cLoggingLevel4, False
         End If

         ' Open Security Descriptor data ----------------------------------------------------------------------
         DisplayFormattedProperty objLOGFileHandle, strIndent & "| Owner", arraySD (0), Null, cLoggingLevel4
         DisplayFormattedProperty objLOGFileHandle, strIndent & "| Group", arraySD (1), Null, cLoggingLevel4
         DisplayFormattedProperty objLOGFileHandle, strIndent & "| Revision", "1", Null, cLoggingLevel4
         DisplayFormattedProperty objLOGFileHandle, strIndent & "| Control", DecipherSDControlFlags (arraySD (2), True), Null, cLoggingLevel4

         intACECounter = 0
         arrayACL = arraySD (3)
         If IsNull (arrayACL) = False Then
            ' Open Discretionary ACL data ------------------------------------------------------------------------
            strIndent = strIndent & "|"
            WriteToLogFile objLOGFileHandle, strIndent & "+- DiscretionaryAcl " & String (93 - Len (strIndent), "-"), cLoggingLevel4, False
     
            strIndent = strIndent & "|"

            For intIndex=0 To UBound (arrayACL) - 1 Step 4
                ' Open ACE Data ----------------------------------------------------------------------------------
                intACECounter = intACECounter + 1 
                WriteToLogFile objLOGFileHandle, strIndent & "+- ACE #" & Right ("0" & intACECounter, 2) & " " & String (102 - Len (strIndent), "-"), cLoggingLevel4, False

                DisplayFormattedProperty objLOGFileHandle, strIndent & "| Trustee", _
                                         objWshShell.ExpandEnvironmentStrings (arrayACL (intIndex)), _
                                         Null, _
                                         cLoggingLevel4

                DisplayFormattedProperty objLOGFileHandle, strIndent & "| AceType", _
                                         DecipherACEType (intSDType, arrayACL (intIndex + 1), True), _
                                         Null, _
                                         cLoggingLevel4

                DisplayFormattedProperty objLOGFileHandle, strIndent & "| AceFlags", _
                                         DecipherACEFlags (intSDType, arrayACL (intIndex + 2), True), _
                                         Null, _
                                         cLoggingLevel4

                DisplayFormattedProperty objLOGFileHandle, strIndent & "| AccessMask", _
                                         DecipherACEMask (intSDType, arrayACL (intIndex + 3), True), _
                                         Null, _
                                         cLoggingLevel4

                If intSDType = cDComSDAccess Or intSDType = cDComSDLaunch Then
                   If (arrayACL (intIndex + 3) And DCOM_RIGHT_EXECUTE) <> DCOM_RIGHT_EXECUTE Then
                      WriteToLogFile objLOGFileHandle, "==> Invalid ACE for '" & Ucase (arrayACL (intIndex)) & "' (&h" & Hex (arrayACL (intIndex + 3)) & ")", cLoggingLevel4, False
                   End If
                End If
          
                ' Close ACE Data ----------------------------------------------------------------------------------
                WriteToLogFile objLOGFileHandle, strIndent & "+-" & String (109 - Len (strIndent) + 2, "-"), cLoggingLevel4, False
            Next
     
            strIndent = Mid (strIndent, 1, Len (strIndent) - 1)
     
            ' Close Discretionary ACL data ------------------------------------------------------------------------
            WriteToLogFile objLOGFileHandle, strIndent & "+-" & String (109 - Len (strIndent) + 2, "-"), cLoggingLevel4, False
            strIndent = Mid (strIndent, 1, Len (strIndent) - 1)
         Else
            Err.Clear
         End If
     
         intACECounter = 0
         arrayACL = arraySD (4)
         If IsNull (arrayACL) = False Then
            ' Open System ACL data -------------------------------------------------------------------------------
            strIndent = strIndent & "|"
            WriteToLogFile objLOGFileHandle, strIndent & "+- SystemAcl " & String (96 - Len (strIndent), "-"), cLoggingLevel4, False
     
            strIndent = strIndent & "|"
     
            For intIndex=0 To UBound (arrayACL) - 1 Step 4
                ' Open ACE Data ----------------------------------------------------------------------------------
                intACECounter = intACECounter + 1 
                WriteToLogFile objLOGFileHandle, strIndent & "+- ACE #" & Right ("0" & intACECounter, 2) & " " & String (102 - Len (strIndent), "-"), cLoggingLevel4, False
     
                DisplayFormattedProperty objLOGFileHandle, strIndent & "| Trustee", _
                                         objWshShell.ExpandEnvironmentStrings (arrayACL (intIndex)), _
                                         Null, _
                                         cLoggingLevel4

                DisplayFormattedProperty objLOGFileHandle, strIndent & "| AceType", _
                                         DecipherACEType (intSDType, arrayACL (intIndex + 1), True), _
                                         Null, _
                                         cLoggingLevel4

                DisplayFormattedProperty objLOGFileHandle, strIndent & "| AceFlags", _
                                         DecipherACEFlags (intSDType, arrayACL (intIndex + 2), True), _
                                         Null, _
                                         cLoggingLevel4

                DisplayFormattedProperty objLOGFileHandle, strIndent & "| AccessMask", _
                                         DecipherACEMask (intSDType, arrayACL (intIndex + 3), True), _
                                         Null, _
                                         cLoggingLevel4
     
                ' Close ACE Data ----------------------------------------------------------------------------------
                WriteToLogFile objLOGFileHandle, strIndent & "+-" & String (110 - Len (strIndent) + 2, "-"), cLoggingLevel4, False
            Next
     
            strIndent = Mid (strIndent, 1, Len (strIndent) - 1)
     
            ' Close System ACL data -------------------------------------------------------------------------------
            WriteToLogFile objLOGFileHandle, strIndent & "+-" & String (110 - Len (strIndent) + 2, "-"), cLoggingLevel4, False
            strIndent = Mid (strIndent, 1, Len (strIndent) - 1)
         Else
            Err.Clear
         End If

         ' Close Security Descriptor data ----------------------------------------------------------------------
         WriteToLogFile objLOGFileHandle, strIndent & "+-" & String (110 - Len (strIndent) + 2, "-"), cLoggingLevel4, False

End Function

' ----------------------------------------------------------------------------------------
Function DecipherSDControlFlags (ByVal intControlFlags, ByVal boolReturnArray)

         Dim strTemp

         On Error Resume Next

         strTemp = "&h" & Hex (intControlFlags)

         If (intControlFlags And SE_OWNER_DEFAULTED) Then
            strTemp = strTemp & "," & "SE_OWNER_DEFAULTED"
         End If
         If (intControlFlags And SE_GROUP_DEFAULTED) Then
            strTemp = strTemp & "," & "SE_GROUP_DEFAULTED" 
         End If
         If (intControlFlags And SE_DACL_PRESENT) Then
            strTemp = strTemp & "," & "SE_DACL_PRESENT" 
         End If
         If (intControlFlags And SE_DACL_DEFAULTED) Then
            strTemp = strTemp & "," & "SE_DACL_DEFAULTED" 
         End If
         If (intControlFlags And SE_SACL_PRESENT) Then
            strTemp = strTemp & "," & "SE_SACL_PRESENT" 
         End If
         If (intControlFlags And SE_SACL_DEFAULTED) Then
            strTemp = strTemp & "," & "SE_SACL_DEFAULTED" 
         End If
         If (intControlFlags And SE_DACL_AUTO_INHERIT_REQ) Then
            strTemp = strTemp & "," & "SE_DACL_AUTO_INHERIT_REQ" 
         End If
         If (intControlFlags And SE_SACL_AUTO_INHERIT_REQ) Then
            strTemp = strTemp & "," & "SE_SACL_AUTO_INHERIT_REQ" 
         End If
         If (intControlFlags And SE_DACL_AUTO_INHERITED) Then
            strTemp = strTemp & "," & "SE_DACL_AUTO_INHERITED"
         End If
         If (intControlFlags And SE_SACL_AUTO_INHERITED) Then
            strTemp = strTemp & "," & "SE_SACL_AUTO_INHERITED"
         End If
         If (intControlFlags And SE_DACL_PROTECTED) Then
            strTemp = strTemp & "," & "SE_DACL_PROTECTED" 
         End If
         If (intControlFlags And SE_SACL_PROTECTED) Then
            strTemp = strTemp & "," & "SE_SACL_PROTECTED"
         End If
         If (intControlFlags And SE_SELF_RELATIVE) Then
            strTemp = strTemp & "," & "SE_SELF_RELATIVE" 
         End If
     
         If boolReturnArray = True Then
            DecipherSDControlFlags = ConvertStringInArray (strTemp, ",")
         Else
            DecipherSDControlFlags = strTemp
         End If
     
End Function

' -----------------------------------------------------------------------------------------------------------------
Function DecipherACEMask (ByVal intSDType, ByVal intACEMask, ByVal boolReturnArray)

         Dim strTemp

         On Error Resume Next

         strTemp = "&h" & Hex (intACEMask)

         Select Case intSDType
                Case cFileSD
                     If (intACEMask = FILE_ALL_ACCESS) Then
                        strTemp = strTemp & "," & "(FILE_ALL_ACCESS)"
                     End If
                     If (intACEMask = FILE_GENERIC_EXECUTE) Then
                        strTemp = strTemp & "," & "(FILE_GENERIC_EXECUTE)"
                     End If
                     If (intACEMask = FILE_GENERIC_READ) Then
                        strTemp = strTemp & "," & "(FILE_GENERIC_READ)"
                     End If
                     If (intACEMask = FILE_GENERIC_WRITE) Then
                        strTemp = strTemp & "," & "(FILE_GENERIC_WRITE)"
                     End If
                     If (intACEMask And FILE_READ_DATA) Then
                        strTemp = strTemp & "," & "FILE_READ_DATA " & _
                                                  "(FOLDER_LIST_DIRECTORY for a Folder)"
                     End If
                     If (intACEMask And FILE_WRITE_DATA) Then
                        strTemp = strTemp & "," & "FILE_WRITE_DATA " & _
                                                  "(FOLDER_ADD_FILE for a Folder)"
                     End If
                     If (intACEMask And FILE_APPEND_DATA) Then
                        strTemp = strTemp & "," & "FILE_APPEND_DATA " & _
                                                  "(FOLDER_ADD_SUBDIRECTORY for a Folder)"
                     End If
                     If (intACEMask And FILE_READ_EA) Then
                        strTemp = strTemp & "," & "FILE_READ_EA"
                     End If
                     If (intACEMask And FILE_WRITE_EA) Then
                        strTemp = strTemp & "," & "FILE_WRITE_EA"
                     End If
                     If (intACEMask And FILE_EXECUTE) Then
                        strTemp = strTemp & "," & "FILE_EXECUTE " & _
                                                  "(FOLDER_TRAVERSE for a Folder)"
                     End If
                     If (intACEMask And FILE_DELETE_CHILD) Then
                        strTemp = strTemp & "," & "FILE_DELETE_CHILD"
                     End If
                     If (intACEMask And FILE_READ_ATTRIBUTES) Then
                        strTemp = strTemp & "," & "FILE_READ_ATTRIBUTES"
                     End If
                     If (intACEMask And FILE_WRITE_ATTRIBUTES) Then
                        strTemp = strTemp & "," & "FILE_WRITE_ATTRIBUTES"
                     End If
                     If (intACEMask And FILE_DELETE) Then
                        strTemp = strTemp & "," & "FILE_DELETE"
                     End If
                     If (intACEMask And FILE_READ_CONTROL) Then
                        strTemp = strTemp & "," & "FILE_READ_CONTROL"
                     End If
                     If (intACEMask And FILE_WRITE_DAC) Then
                        strTemp = strTemp & "," & "FILE_WRITE_DAC"
                     End If
                     If (intACEMask And FILE_WRITE_OWNER) Then
                        strTemp = strTemp & "," & "FILE_WRITE_OWNER"
                     End If
                     If (intACEMask And FILE_SYNCHRONIZE) Then
                        strTemp = strTemp & "," & "FILE_SYNCHRONIZE"
                     End If
     
                Case cShareSD
                     If (intACEMask And FILE_SHARE_FULL_ACCESS) Then
                        strTemp = strTemp & "," & "FILE_SHARE_FULL_ACCESS"
                     End If
                     If (intACEMask And FILE_SHARE_CHANGE_ACCESS) Then
                        strTemp = strTemp & "," & "FILE_SHARE_CHANGE_ACCESS"
                     End If
                     If (intACEMask And FILE_SHARE_READ_ACCESS) Then
                        strTemp = strTemp & "," & "FILE_SHARE_READ_ACCESS"
                     End If
          
                Case cRegistrySD
                     If (intACEMask = REG_GENERIC_FULL_CONTROL) Then
                        strTemp = strTemp & "," & "(REG_GENERIC_FULL_CONTROL)"
                     End If                                             
                     If (intACEMask = REG_GENERIC_READ) Then
                        strTemp = strTemp & "," & "(REG_GENERIC_READ)"
                     End If
     
                     If (intACEMask And REG_QUERY_VALUE) Then
                        strTemp = strTemp & "," & "REG_QUERY_VALUE"
                     End If
                     If (intACEMask And REG_SET_VALUE) Then
                        strTemp = strTemp & "," & "REG_SET_VALUE"
                     End If                   
                     If (intACEMask And REG_CREATE_SUBKEYS) Then
                        strTemp = strTemp & "," & "REG_CREATE_SUBKEYS"
                     End If                                  
                     If (intACEMask And REG_ENUMERATE_SUBKEYS) Then
                        strTemp = strTemp & "," & "REG_ENUMERATE_SUBKEYS"
                     End If                                               
                     If (intACEMask And REG_NOTIFY) Then
                        strTemp = strTemp & "," & "REG_NOTIFY"
                     End If                                             
                     If (intACEMask And REG_CREATE_LINK) Then
                        strTemp = strTemp & "," & "REG_CREATE_LINK"
                     End If                                  
                     If (intACEMask And REG_DELETE) Then
                        strTemp = strTemp & "," & "REG_DELETE"
                     End If                                                             
                     If (intACEMask And REG_READ_CONTROL) Then
                        strTemp = strTemp & "," & "REG_READ_CONTROL"
                     End If                                                                  
                     If (intACEMask And REG_WRITE_DAC) Then
                        strTemp = strTemp & "," & "REG_WRITE_DAC"
                     End If                                                                  
                     If (intACEMask And REG_WRITE_OWNER) Then
                        strTemp = strTemp & "," & "REG_WRITE_OWNER"
                     End If                                                                        

                Case cWMINameSpaceSD
                     If (intACEMask And WBEM_ENABLE) Then
                        strTemp = strTemp & "," & "WBEM_ENABLE"
                     End If
                     If (intACEMask And WBEM_METHOD_EXECUTE) Then
                        strTemp = strTemp & "," & "WBEM_METHOD_EXECUTE"
                     End If
                     If (intACEMask And WBEM_FULL_WRITE_REP) Then
                        strTemp = strTemp & "," & "WBEM_FULL_WRITE_REP"
                     End If
                     If (intACEMask And WBEM_PARTIAL_WRITE_REP) Then
                        strTemp = strTemp & "," & "WBEM_PARTIAL_WRITE_REP"
                     End If
                     If (intACEMask And WBEM_WRITE_PROVIDER) Then
                        strTemp = strTemp & "," & "WBEM_WRITE_PROVIDER"
                     End If
                     If (intACEMask And WBEM_REMOTE_ACCESS) Then
                        strTemp = strTemp & "," & "WBEM_REMOTE_ACCESS"
                     End If
                     If (intACEMask And WBEM_WRITE_DAC) Then
                        strTemp = strTemp & "," & "WBEM_WRITE_DAC"
                     End If
                     If (intACEMask And WBEM_READ_CONTROL) Then
                        strTemp = strTemp & "," & "WBEM_READ_CONTROL"
                     End If

                Case cDComSDAccess
                     If (intACEMask And DCOM_RIGHT_EXECUTE) Then
                        strTemp = strTemp & "," & "DCOM_RIGHT_EXECUTE"
                     End If
                     If (intACEMask And DCOM_RIGHT_ACCESS_LOCAL) Then
                        strTemp = strTemp & "," & "DCOM_RIGHT_ACCESS_LOCAL"
                     End If
                     If (intACEMask And DCOM_RIGHT_ACCESS_REMOTE) Then
                        strTemp = strTemp & "," & "DCOM_RIGHT_ACCESS_REMOTE"
                     End If

                Case cDComSDLaunch
                     If (intACEMask And DCOM_RIGHT_EXECUTE) Then
                        strTemp = strTemp & "," & "DCOM_RIGHT_EXECUTE"
                     End If
                     If (intACEMask And DCOM_RIGHT_LAUNCH_LOCAL) Then
                        strTemp = strTemp & "," & "DCOM_RIGHT_LAUNCH_LOCAL"
                     End If
                     If (intACEMask And DCOM_RIGHT_LAUNCH_REMOTE) Then
                        strTemp = strTemp & "," & "DCOM_RIGHT_LAUNCH_REMOTE"
                     End If
                     If (intACEMask And DCOM_RIGHT_ACTIVATE_LOCAL) Then
                        strTemp = strTemp & "," & "DCOM_RIGHT_ACTIVATE_LOCAL"
                     End If
                     If (intACEMask And DCOM_RIGHT_ACTIVATE_REMOTE) Then
                        strTemp = strTemp & "," & "DCOM_RIGHT_ACTIVATE_REMOTE"
                     End If
     
                Case Else
     
         End Select
     
         If boolReturnArray = True Then
            DecipherACEMask = ConvertStringInArray (strTemp, ",")
         Else
            DecipherACEMask = strTemp 
         End If

End Function

' -----------------------------------------------------------------------------------------------------------------
Function DecipherACEFlags (ByVal intSDType, ByVal intACEFlags, ByVal boolReturnArray)

         Dim strTemp

         On Error Resume Next

         strTemp = "&h" & Hex (intACEFlags)

         Select Case intSDType
                Case cFileSD, _
                     cShareSD, _
                     cRegistrySD, _
                     cWMINameSpaceSD, _
                     cDComSDAccess, cDComSDLaunch
                     If (intACEFlags And OBJECT_INHERIT_ACE) Then
                        strTemp = strTemp & "," & "OBJECT_INHERIT_ACE"
                     End If
                     If (intACEFlags And CONTAINER_INHERIT_ACE) Then
                        strTemp = strTemp & "," & "CONTAINER_INHERIT_ACE"
                     End If
                     If (intACEFlags And NO_PROPAGATE_INHERIT_ACE) Then
                        strTemp = strTemp & "," & "NO_PROPAGATE_INHERIT_ACE"
                     End If
                     If (intACEFlags And INHERIT_ONLY_ACE) Then
                        strTemp = strTemp & "," & "INHERIT_ONLY_ACE"
                     End If
                     If (intACEFlags And INHERITED_ACE) Then
                        strTemp = strTemp & "," & "INHERITED_ACE"
                     End If
                     If (intACEFlags = VALID_INHERIT_FLAG) Then
                        strTemp = strTemp & "," & "VALID_INHERIT_FLAG"
                     End If
                     If (intACEFlags And SUCCESSFUL_ACCESS_ACE_FLAG) Then
                        strTemp = strTemp & "," & "SUCCESSFUL_ACCESS_ACE_FLAG"
                     End If
                     If (intACEFlags And FAILED_ACCESS_ACE_FLAG) Then
                        strTemp = strTemp & "," & "FAILED_ACCESS_ACE_FLAG"
                     End If
     
                Case Else
     
         End Select
     
         If boolReturnArray = True Then
            DecipherACEFlags = ConvertStringInArray (strTemp, ",")
         Else
            DecipherACEFlags = strTemp 
         End If

End Function

' -----------------------------------------------------------------------------------------------------------------
Function DecipherACEType (ByVal intSDType, ByVal intACEType, ByVal boolReturnArray)

         Dim strTemp

         On Error Resume Next

         strTemp = "&h" & Hex (intACEType)

         Select Case intSDType
                Case cFileSD, _
                     cShareSD, _
                     cRegistrySD, _
                     cWMINameSpaceSD, _
                     cDComSDAccess, cDComSDLaunch
                     Select Case intACEType
                            Case ACCESS_ALLOWED_ACE_TYPE
                                 strTemp = strTemp & "," & "ACCESS_ALLOWED_ACE_TYPE"
                            Case ACCESS_DENIED_ACE_TYPE
                                 strTemp = strTemp & "," & "ACCESS_DENIED_ACE_TYPE"
                            Case SYSTEM_AUDIT_ACE_TYPE
                                 strTemp = strTemp & "," & "SYSTEM_AUDIT_ACE_TYPE"
                            Case SYSTEM_ALARM_ACE_TYPE
                                 strTemp = strTemp & "," & "SYSTEM_ALARM_ACE_TYPE"
                            Case Else
     
                     End Select
     
                Case Else
     
         End Select
     
         If boolReturnArray = True Then
            DecipherACEType = ConvertStringInArray (strTemp, ",")
         Else
            DecipherACEType = strTemp
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function IsThereAClassProvider (ByVal objLOGFileHandle, ByVal objWMIServices, ByVal strWMINamespace)

         Dim objWMIInstances
         Dim intCount

         On Error Resume Next

         IsThereAClassProvider = False

         If boolStrict = False Then
            Set objWMIInstances = objWMIServices.ExecQuery ("Select * From __ClassProviderRegistration")
            If Err.Number Then
               IsThereAClassProvider = ErrorHandler (objLOGFileHandle, "IsThereAClassProvider", "", False, Err)
               TrackingData.WMIExecQueryErrors = AddTrackingData (TrackingData.WMIExecQueryErrors, strWMINamespace & ";Select * From __ClassProviderRegistration;" & cCritical & ";" & strLastError)
               Exit Function
            End If

            intCount = objWMIInstances.Count
            If Err.Number Then
               IsThereAClassProvider = ErrorHandler (objLOGFileHandle, "IsThereAClassProvider", "", False, Err)
               TrackingData.WMIExecQueryErrors = AddTrackingData (TrackingData.WMIExecQueryErrors, strWMINamespace & ";Select * From __ClassProviderRegistration;" & cCritical & ";" & strLastError)                
               Exit Function 
            End If

            If intCount > 0 Then 
               IsThereAClassProvider = True
               WriteToLogFile objLOGFileHandle, "At least one class provider is present in namespace '" & strWMINamespace & "' (" & intCount & "). Skipping write operations in that namespace!", cLoggingLevel3, False
            End If
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function GetLoadedProviders (ByVal objLOGFileHandle, ByVal strBeforeAfter)

         Dim objWMIServices, objWMIInstance, objWMIInstances
         Dim objWMIProcess, strExecutableName
         Dim intCount

         On Error Resume Next

         GetLoadedProviders = False

         If Len (strBeforeAfter) Then
            WriteToLogFile objLOGFileHandle, "Verifying WMI providers loaded " & strBeforeAfter & " WMIDiag execution.", cLoggingLevel0, False
         End If

         If RunTimeEnvironmentInfo.OSIdentifier > cWindows2000SP4 Then
            Set objWMIServices = objWMILocator.ConnectServer ("LocalHost", "Root/CIMv2", "", "")
            If Err.Number Then 
               GetLoadedProviders = ErrorHandler (objLOGFileHandle, "CheckWMIStaticData", "", False, Err)
               TrackingData.WMIConnectionErrors = AddTrackingData (TrackingData.WMIConnectionErrors, strWMINameSpace & ";" & strLastError)
              Exit Function
            End If

            Set objWMIInstances = objWMIServices.ExecQuery ("Select * From MSFT_Providers")
            If Err.Number Then
               GetLoadedProviders = ErrorHandler (objLOGFileHandle, "GetLoadedProviders", "", False, Err)
               TrackingData.WMIExecQueryErrors = AddTrackingData (TrackingData.WMIExecQueryErrors, strWMINamespace & ";Select * From MSFT_Providers;" & cWarning & ";" & strLastError)
               Exit Function 
            End If

            intCount = objWMIInstances.Count
            If Err.Number Then
               GetLoadedProviders = ErrorHandler (objLOGFileHandle, "GetLoadedProviders", "", False, Err)
               TrackingData.WMIExecQueryErrors = AddTrackingData (TrackingData.WMIExecQueryErrors, strWMINamespace & ";Select * From MSFT_Providers;" & cWarning & ";" & strLastError)
               Exit Function 
            End If

            If intCount > 0 Then 
               GetLoadedProviders = True
               WriteToLogFile objLOGFileHandle, intCount & " WMI providers are currently loaded:", cLoggingLevel3, False

               For Each objWMIInstance In objWMIInstances
                   Set objWMIProcess = objWMIServices.Get ("Win32_Process.Handle=" & objWMIInstance.HostProcessIdentifier)
                   If Err.Number Then 
                      ErrorHandler objLOGFileHandle, "GetLoadedProviders", "", False, Err
                      TrackingData.WMIGetErrors = AddTrackingData (TrackingData.WMIGetErrors, "Root/CIMv2;Win32_Process.Handle=" & objWMIInstance.HostProcessIdentifier & ";" & strLastError)

                      WriteToLogFile objLOGFileHandle, "Provider: '" & UCase (objWMIInstance.Provider) & "' (PID: " & objWMIInstance.HostProcessIdentifier & ")", cLoggingLevel4, False
                   Else
                      If IsNull (objWMIProcess.ExecutablePath) = True Then
                         strExecutableName = objWMIProcess.Name
                      Else
                         strExecutableName = objWMIProcess.ExecutablePath
                      End If
                      WriteToLogFile objLOGFileHandle, "Provider: '" & UCase (objWMIInstance.Provider) & "' (PID: " & objWMIInstance.HostProcessIdentifier & ", " & Ucase (strExecutableName) & ")", cLoggingLevel4, False
                   End If
              
                   WriteToLogFile objLOGFileHandle, "  Provider Name:    '" & LocateWMIProviderData (objLOGFileHandle, objWMIInstance.Provider, cWMIProviderName, cWMIProviderDisplayName) & "'", cLoggingLevel4, False
                   WriteToLogFile objLOGFileHandle, "  Namespace:        '" & UCase (objWMIInstance.Namespace) & "' (i.e. '" & LocateWMIProviderData (objLOGFileHandle, objWMIInstance.Provider, cWMIProviderName, cWMIClassname) & "')", cLoggingLevel4, False
                   WriteToLogFile objLOGFileHandle, "  Hosting Model:    '" & LocateWMIProviderData (objLOGFileHandle, objWMIInstance.Provider, cWMIProviderName, cWMIProviderHostingModel) & "' (HostingSpecification=" & objWMIInstance.HostingSpecification & ")", cLoggingLevel4, False
                   WriteToLogFile objLOGFileHandle, "  Hosting Group:    '" & UCase (objWMIInstance.HostingGroup) & "'", cLoggingLevel4, False
                   WriteToLogFile objLOGFileHandle, "  User:             '" & UCase (objWMIInstance.User) & "'", cLoggingLevel4, False
                   WriteToLogFile objLOGFileHandle, "  Provider Binary:  '" & LocateWMIProviderData (objLOGFileHandle, objWMIInstance.Provider, cWMIProviderName, cWMIProviderBinary) & "'", cLoggingLevel4, False
                   WriteToLogFile objLOGFileHandle, "  MOF Registration: '" & LocateWMIProviderData (objLOGFileHandle, objWMIInstance.Provider, cWMIProviderName, cWMIProviderMOF) & "'", cLoggingLevel4, False
                   WriteToLogFile objLOGFileHandle, "", cLoggingLevel4, False

                   Set objWMIProcess =  Nothing
               Next
            End If
         End If 

End Function

' --------------------------------------------------------------------------------------------------------
Function QueryWMIDiagData (ByVal objLOGFileHandle, ByVal strWMIClass)

         Dim strWMIData, arrayWMIData

          On Error Resume Next

         strWMIData = LocateWMIProviderData (objLOGFileHandle, strWMIClass, cWMIClassName, cWMIProviderAllData)

         If strWMIData <> cMissingWMIInfo Then
            arrayWMIData = ConvertStringInArray (strWMIData, ",")

            WriteToLogFile objLOGFileHandle, "", cLoggingLevel4, False
            WriteToLogFile objLOGFileHandle, "Class Name:             '" & arrayWMIData (cWMIClassname) & "'", cLoggingLevel4, False
            WriteToLogFile objLOGFileHandle, "Provider Namespace:     '" & arrayWMIData (cWMINamespace) & "'", cLoggingLevel4, False
            WriteToLogFile objLOGFileHandle, "Provider Name:          '" & arrayWMIData (cWMIProviderName) & "'", cLoggingLevel4, False
            WriteToLogFile objLOGFileHandle, "Provider Displayname:   '" & arrayWMIData (cWMIProviderDisplayName) & "'", cLoggingLevel4, False
            WriteToLogFile objLOGFileHandle, "Provider Model:         '" & arrayWMIData (cWMIProviderModel) & "'", cLoggingLevel4, False
            WriteToLogFile objLOGFileHandle, "Provider Type:          '" & arrayWMIData (cWMIprovidertype) & "'", cLoggingLevel4, False
            WriteToLogFile objLOGFileHandle, "Provider CLSID:         '" & arrayWMIData (cWMIProviderCLSID) & "'", cLoggingLevel4, False
            WriteToLogFile objLOGFileHandle, "Provider Hosting Model: '" & arrayWMIData (cWMIProviderHostingModel) & "'", cLoggingLevel4, False
            WriteToLogFile objLOGFileHandle, "Provider Binary:        '" & arrayWMIData (cWMIProviderBinary) & "'", cLoggingLevel4, False
            WriteToLogFile objLOGFileHandle, "Provider MOF:           '" & arrayWMIData (cWMIProviderMOF) & "'", cLoggingLevel4, False
            WriteToLogFile objLOGFileHandle, "", cLoggingLevel4, False
         Else
            WriteToLogFile objLOGFileHandle, "", cLoggingLevel4, False
            WriteToLogFile objLOGFileHandle, strWMIData, cLoggingLevel4, False
            WriteToLogFile objLOGFileHandle, "", cLoggingLevel4, False
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function LocateWMIProviderData (ByVal objLOGFileHandle, ByVal strInput, ByVal intInputSearchIndex, ByVal intOuputSearchIndex)

         Dim intIndex, intOSIdentifier, intPlatform, intLength, strInputToSearch

          On Error Resume Next  

         If RunTimeEnvironmentInfo.IsServerOS = True Then
            intPlatform = cServerOnly
         Else
            intPlatform = cClientOnly
         End If

         intOSIdentifier = RunTimeEnvironmentInfo.OSIdentifier

         ' cWindows2000RTM => cWindows2000SP1 => cWindows2000SP2 => cWindows2000SP3 => cWindows2000SP4
         ' cWindowsXPRTM => cWindowsXPSP2
         ' cWindowsXPSP164 => cWindowsXPSP2
         ' cWindows2003RTM => cWindows2003RTM64 => cWindows2003SP164 => cWindows2003SP1
         ' cWindowsVistaSP1 => cWindowsVistaRTM

         If RunTimeEnvironmentInfo.OSIdentifier < cWindows2000SP4 Then
            intOSIdentifier = cWindows2000SP4 
         End If

         If RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPRTM Then
            intOSIdentifier = cWindowsXPSP2
         End If

         If RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP164 Or _
            RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP3 Or _
	    	RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP2 Then
            intOSIdentifier = cWindowsXPSP2
         End If

         If RunTimeEnvironmentInfo.OSIdentifier = cWindows2003RTM Or _
            RunTimeEnvironmentInfo.OSIdentifier = cWindows2003RTM64 Or _
            RunTimeEnvironmentInfo.OSIdentifier = cWindows2003SP164 Or _
	    RunTimeEnvironmentInfo.OSIdentifier = cWindows2003SP2 Or _
	    RunTimeEnvironmentInfo.OSIdentifier = cWindows2003SP264 Then
            intOSIdentifier = cWindows2003SP1 
         End If

         For intIndex = 0 To UBound (arrayWMIProviderData)

             If (arrayWMIProviderData (intIndex)(cOSVersion) And intOSIdentifier) = intOSIdentifier Then

                WriteToLogFile objLOGFileHandle, "'" & (arrayWMIProviderData (intIndex)(cPlatform) And intPlatform) & "'='" & intPlatform & "'", cLoggingDebug Or cLoggingLevel4, False
                If (arrayWMIProviderData (intIndex)(cPlatform) And intPlatform) = intPlatform Then
                   intLength = Len (arrayWMIProviderData (intIndex)(intInputSearchIndex))
                   If intLength > 0 Then
                      strInputToSearch = Mid (strInput, 1, intLength)
                   Else
                      strInputToSearch = strInput
                   End If
                   If UCase (arrayWMIProviderData (intIndex)(intInputSearchIndex)) = UCase (strInputToSearch) Then   
                      WriteToLogFile objLOGFileHandle, "FOUND!", cLoggingDebug Or cLoggingLevel4, False
                      If intOuputSearchIndex = cWMIProviderAllData Then
                         LocateWMIProviderData = ConvertArrayInString (arrayWMIProviderData (intIndex), ",")
                         Exit Function
                      Else
                         If intOuputSearchIndex = cWMIProviderDisplayName Then
                            LocateWMIProviderData = arrayWMIProviderData (intIndex)(cWMIProviderDisplayName) & " " & arrayWMIProviderData (intIndex)(cWMIProviderType) & " WMI Provider"
                            Exit Function
                         Else
                            LocateWMIProviderData = objWshShell.ExpandEnvironmentStrings (arrayWMIProviderData (intIndex)(intOuputSearchIndex))
                            Exit Function
                         End If
                      End If
                   End If
                End If
             End If
         Next

         LocateWMIProviderData = cMissingWMIInfo

End Function

' --------------------------------------------------------------------------------------------------------
Function GetWMISystemSettings (ByVal objLOGFileHandle, ByVal objWMIServices)

         Dim objWMIInstance, objWMIInstances   
         Dim strWMISystemClass
         Dim intCount
 
         On Error Resume Next
 
         WriteToLogFile objLOGFileHandle, "Verifying WMI system settings.", cLoggingLevel0, False
 
         For Each strWMISystemClass In arrayWMISystemConfigurationClasses
 
             Set objWMIInstances = objWMIServices.InstancesOf (strWMISystemClass, wbemFlagReturnImmediately Or wbemFlagUseAmendedQualifiers)
             If Err.Number Then
                GetWMISystemSettings = ErrorHandler (objLOGFileHandle, "GetWMISystemSettings", "", False, Err)
                TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, "ROOT" & ";InstancesOf;" & strWMISystemClass & ";" & cCritical & ";" & strLastError)
                Exit Function
             End If
 
             intCount = objWMIInstances.Count
             If Err.Number Then
                GetWMISystemSettings = ErrorHandler (objLOGFileHandle, "GetWMISystemSettings", "", False, Err)
                TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, "ROOT" & ";InstancesOf;" & strWMISystemClass & ";" & cCritical & ";" & strLastError)
                Exit Function
             End If
 
             If intCount Then
                intCount = 0
                For Each objWMIInstance in objWMIInstances
                    intCount = intCount + 1
                    DisplayFormattedWMIProperties objLOGFileHandle, objWMIInstance, intCount, 0, cLoggingLevel3
                Next
             Else
                GetWMISystemSettings = ErrorHandler (objLOGFileHandle, "GetWMISystemSettings", "'" & strWMISystemClass & "' not found.", False, Err)
                TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, "ROOT" & ";InstancesOf;" & strWMISystemClass & ";" & cCritical & ";NOINSTANCE")
             End If
         Next

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckWMIProviderRegistration (ByVal objLOGFileHandle, ByVal objWMIServices, ByVal strWMINameSpace, ByVal objWMIInstances)

         Dim arrayProviderPath, strWMIProviderCLSID, strWMIProviderRegistrationData, strWMIProviderType
         Dim objWMIInstance, objWMIReference 
         Dim strHostingModel, strWMIProviderRegistrationClass, boolUndefinedHostingModel, boolInstanceWMIProvider, strClassProviderType
         Dim intIndex
         Dim boolRC

         On Error Resume Next

         intIndex = 0

         For Each objWMIInstance in objWMIInstances
             intIndex = intIndex + 1

             WriteToLogFile objLOGFileHandle, "(#" & intIndex & ") Found WMI Provider '" & UCase (objWMIInstance.Name) & "' CIM registration.", cLoggingLevel3, False

             If RunTimeEnvironmentInfo.OSIdentifier >= cWindowsXPRTM Then
                strHostingModel = UCase (objWMIInstance.HostingModel)
                If Len (strHostingModel) > 0 Then
                   WriteToLogFile objLOGFileHandle, "WMI Provider hosting model is '" & strHostingModel & "'.", cLoggingLevel3, False
                   boolUndefinedHostingModel = False
                   strWMIProviderRegistrationData = strHostingModel
                Else
                   If RunTimeEnvironmentInfo.OSIdentifier >= cWindowsVistaRTM Then
                      WriteToLogFile objLOGFileHandle, "WMI Provider hosting model is undefined, which implies 'NetworkServiceHostOrSelfHost'.", cLoggingLevel2, False
                      strHostingModel = UCase ("NetworkServiceHostOrSelfHost")
                   Else
                      WriteToLogFile objLOGFileHandle, "WMI Provider hosting model is undefined, which implies 'LocalSystemHostOrSelfHost'.", cLoggingLevel2, False
                      strHostingModel = UCase ("LocalSystemHostOrSelfHost")
                   End If
                   boolUndefinedHostingModel = True
                   strWMIProviderRegistrationData = strHostingModel & " (*)"
                End If
             Else
                strWMIProviderRegistrationData = "No hosting model"
             End If

             strWMIProviderCLSID = UCase(objWMIInstance.CLSID)

             If Instr (strHostingModel, "LOCALSYSTEM") > 0 Or _
                Instr (strHostingModel, "WMICORE") > 0 Then
                If ExceptionForHighPrivWMIProvider (Ucase(objWMIInstance.Name & ";" & strWMIProviderCLSID)) = True Then
                   WriteToLogFile objLOGFileHandle, "WMI Provider is '" & Ucase (objWMIInstance.Name) & "' IS a trusted WMI providers.", cLoggingLevel3, False
                   strWMIProviderRegistrationData = strWMIProviderRegistrationData & ";Trusted"
                Else 
                   WriteToLogFile objLOGFileHandle, "WMI Provider is '" & Ucase (objWMIInstance.Name) & "' is NOT a trusted WMI providers.", cLoggingLevel2, False
                   TrackingData.HighPrivWMIProvider = AddTrackingData (TrackingData.HighPrivWMIProvider, UCase(strWMINameSpace & ";" & objWMIInstance.Name & ";" & strHostingModel & ";" & strWMIProviderCLSID) & ";" & boolUndefinedHostingModel)
                   strWMIProviderRegistrationData = strWMIProviderRegistrationData & ";Untrusted"
                End If
             Else 
                strWMIProviderRegistrationData = strWMIProviderRegistrationData & ";"
             End If

             strWMIProviderType = ""

             For Each objWMIReference in objWMIInstance.References_
                 strWMIProviderRegistrationClass = Ucase (objWMIReference.Path_.Class)
  
                 If strWMIProviderRegistrationClass = "__INSTANCEPROVIDERREGISTRATION" Then
                    boolInstanceWMIProvider = True
                    If objWMIReference.SupportsEnumeration = True Then
                       WriteToLogFile objLOGFileHandle, "WMI Provider '" & UCase (objWMIInstance.Name) & "' is an INSTANCE provider and supports instance enumeration.", cLoggingLevel3, False
                       TrackingData.WMIProviderSupportingEnumeration = AddTrackingData (TrackingData.WMIProviderSupportingEnumeration, UCase (strWMINamespace & ";" & objWMIInstance.Name))
                    Else
                       WriteToLogFile objLOGFileHandle, "WMI Provider '" & UCase (objWMIInstance.Name) & "' is an INSTANCE provider and DOES NOT support instance enumeration.", cLoggingLevel3, False
                    End If
                    strWMIProviderType = strWMIProviderType & "Instance "
                 Else
                    boolInstanceWMIProvider = False
                 End If

                 If strWMIProviderRegistrationClass = "__METHODPROVIDERREGISTRATION" Then
                    WriteToLogFile objLOGFileHandle, "WMI Provider '" & UCase (objWMIInstance.Name) & "' is a METHOD provider.", cLoggingLevel3, False
                    strWMIProviderType = strWMIProviderType & "Method "
                 End If

                 If strWMIProviderRegistrationClass = "__CLASSPROVIDERREGISTRATION" Then
                    Select Case (objWMIReference.InteractionType)
                           Case 0
                                strClassProviderType = "Pull"
                           Case 1 
                                strClassProviderType = "Push"
                           Case 2
                                strClassProviderType = "Push-Verify"
                           Case Else
                                strClassProviderType = "Pull"
                    End Select 
                    If objWMIReference.SupportsEnumeration = True Then
                       WriteToLogFile objLOGFileHandle, "WMI Provider '" & UCase (objWMIInstance.Name) & "' is a " & UCase (strClassProviderType) & " CLASS provider and support class enumeration.", cLoggingLevel3, False
                    Else
                       WriteToLogFile objLOGFileHandle, "WMI Provider '" & UCase (objWMIInstance.Name) & "' is a " & UCase (strClassProviderType) & " CLASS provider and DOES NOT support class enumeration.", cLoggingLevel3, False
                    End If
                    strWMIProviderType = strWMIProviderType & strClassProviderType & " Class "
                 End If

                 If strWMIProviderRegistrationClass = "__PROPERTYPROVIDERREGISTRATION" Then
                    WriteToLogFile objLOGFileHandle, "WMI Provider '" & UCase (objWMIInstance.Name) & "' is a PROPERTY provider.", cLoggingLevel3, False
                    strWMIProviderType = strWMIProviderType & "Property "
                 End If
  
                 If strWMIProviderRegistrationClass = "__EVENTPROVIDERREGISTRATION" Then
                    WriteToLogFile objLOGFileHandle, "WMI Provider '" & UCase (objWMIInstance.Name) & "' is an EVENT provider.", cLoggingLevel3, False
                    strWMIProviderType = strWMIProviderType & "Event "
  
                    RetrieveSupportedEventClasses objWMIReference.EventQueryList, strWMINamespace, UCase (objWMIInstance.Name)
                 End If

                 If strWMIProviderRegistrationClass = "__EVENTCONSUMERPROVIDERREGISTRATION" Then
                    WriteToLogFile objLOGFileHandle, "WMI Provider '" & UCase (objWMIInstance.Name) & "' is a PERMANENT EVENT CONSUMER provider.", cLoggingLevel3, False
                    strWMIProviderType = strWMIProviderType & "Event consumer "
  
                    RetrieveSupportedConsumerClasses objWMIReference.ConsumerClassNames, strWMINamespace, UCase (objWMIInstance.Name)
                 End If
             Next

             strWMIProviderRegistrationData = strWMIProviderRegistrationData & ";" & strWMIProviderType

             If Left (strHostingModel, 10) <> "DECOUPLED:" Then
                If Len (strWMIProviderCLSID) > 0 Then 
                   strWMIProviderRegistrationData = strWMIProviderRegistrationData & ";" & strWMIProviderCLSID

                   TrackingData.GoodProviderCIMRegistration = AddTrackingData (TrackingData.GoodProviderCIMRegistration, strWMINameSpace & ";" & objWMIInstance.Name)
 
                   WriteToLogFile objLOGFileHandle, "Verifying if WMI Provider '" & UCase (objWMIInstance.Name) & "' has an In-Proc registration.", cLoggingLevel3, False
                   arrayProviderPath = ReadRegistry (objLOGFileHandle, "HKCR\CLSID\" & strWMIProviderCLSID & "\InProcServer32", _
                                                     "", _
                                                     "REG_EXPAND_SZ", _
                                                     False)
                   If IsArray(arrayProviderPath) = True Then 
                      WriteToLogFile objLOGFileHandle, "Found WMI Provider In-Proc registration '" & UCase (objWMIInstance.Name) & "' (" & strWMIProviderCLSID & ").", cLoggingLevel3, False
                      longInProcWMIProvider = longInProcWMIProvider + 1
                      strWMIProviderRegistrationData = strWMIProviderRegistrationData & ";" & "In-proc"
                   Else
                      WriteToLogFile objLOGFileHandle, "Verifying if WMI Provider '" & UCase (objWMIInstance.Name) & "' has an Out-of-Proc registration.", cLoggingLevel3, False
                      arrayProviderPath = ReadRegistry (objLOGFileHandle, "HKCR\CLSID\" & strWMIProviderCLSID & "\LocalServer32", _
                                                        "", _
                                                        "REG_EXPAND_SZ", _
                                                        False)
                      If IsArray(arrayProviderPath) = True Then 
                         WriteToLogFile objLOGFileHandle, "Found WMI Provider Out-of-Proc registration '" & UCase (objWMIInstance.Name) & "' (" & strWMIProviderCLSID & ").", cLoggingLevel3, False
                         longOutOfProcWMIProvider = longOutOfProcWMIProvider + 1
                         strWMIProviderRegistrationData = strWMIProviderRegistrationData & ";" & "Out-of-proc"
                      Else
                         If RunTimeEnvironmentInfo.Is64 Then
                            WriteToLogFile objLOGFileHandle, "Verifying if WMI Provider '" & UCase (objWMIInstance.Name) & "' has an In-Proc registration (WOW64).", cLoggingLevel3, False
                            arrayProviderPath = ReadRegistry (objLOGFileHandle, "HKCR\Wow6432Node\CLSID\" & strWMIProviderCLSID & "\InProcServer32", _
                                                              "", _ 
                                                              "REG_EXPAND_SZ", _
                                                              False)
                            If IsArray(arrayProviderPath) = True Then 
                               WriteToLogFile objLOGFileHandle, "Found WMI Provider In-Proc registration (WOW64) '" & UCase (objWMIInstance.Name) & "' (" & strWMIProviderCLSID & ").", cLoggingLevel3, False
                               longInProcWMIProvider = longInProcWMIProvider + 1
                               strWMIProviderRegistrationData = strWMIProviderRegistrationData & ";" & "In-proc (Wow64)"
                            Else
                               WriteToLogFile objLOGFileHandle, "Verifying if WMI Provider '" & UCase (objWMIInstance.Name) & "' has an Out-of-Proc registration (WOW64).", cLoggingLevel3, False
                               arrayProviderPath = ReadRegistry (objLOGFileHandle, "HKCR\Wow6432Node\CLSID\" & strWMIProviderCLSID & "\LocalServer32", _
                                                                 "", _
                                                                 "REG_EXPAND_SZ", _
                                                                 False)
                               If IsArray(arrayProviderPath) = True Then 
                                  WriteToLogFile objLOGFileHandle, "Found WMI Provider Out-of-Proc registration (WOW64) '" & UCase (objWMIInstance.Name) & "' (" & strWMIProviderCLSID & ").", cLoggingLevel3, False
                                  longOutOfProcWMIProvider = longOutOfProcWMIProvider + 1
                                  strWMIProviderRegistrationData = strWMIProviderRegistrationData & ";" & "Out-of-proc (Wow64)"
                               End If 
                            End If
                         End If
                      End If 
                   End If

                   If IsArray(arrayProviderPath) = True Then 
                      If Not CheckIfFileExists (objLOGFileHandle, ReplaceString (arrayProviderPath(0), Chr(34), "")) Then
                         boolRC = ExceptionForMissingWMIProviderFile (UCase (strWMINameSpace & ";" & objWMIInstance.Name & ";" & strWMIProviderCLSID))
                         If boolRC = False Then
                            CheckWMIProviderRegistration = ErrorHandler (objLOGFileHandle, "CheckWMIProviderRegistration", "Unable to access or find WMI Provider EXE/DLL '" & UCase(arrayProviderPath(0)) & "' (" & UCase (objWMIInstance.Name) & ").", False, Err)
                            TrackingData.MissingWMIProviderFile = AddTrackingData (TrackingData.MissingWMIProviderFile, strWMINameSpace & ";" & objWMIInstance.Name & ";" & arrayProviderPath(0))
                         Else
                            WriteToLogFile objLOGFileHandle, "WMI Provider EXE/DLL '" & UCase (arrayProviderPath(0)) & "' (" & UCase (objWMIInstance.Name) & ") is missing, but this is expected.", cLoggingLevel1, False
                         End If
                         TrackingData.WMIProviderLocationData = AddTrackingData (TrackingData.WMIProviderLocationData, strWMINameSpace & ";" & objWMIInstance.Name & ";" & UCase(arrayProviderPath(0)))
                      Else
                         WriteToLogFile objLOGFileHandle, "WMI Provider DLL '" & UCase(arrayProviderPath(0)) & "' is available on the system (" & UCase (objWMIInstance.Name) & ").", cLoggingLevel3, False
                         TrackingData.WMIProviderLocationData = AddTrackingData (TrackingData.WMIProviderLocationData, strWMINameSpace & ";" & objWMIInstance.Name & ";" & UCase(arrayProviderPath(0)))
                      End If

                      TrackingData.WMIProviderRegistrationData = AddTrackingData (TrackingData.WMIProviderRegistrationData, strWMINameSpace & ";" & objWMIInstance.Name & ";" & strWMIProviderRegistrationData)
                   Else
                      boolRC = ExceptionForMissingDCOMProviderRegistration (UCase (strWMINameSpace & ";" & objWMIInstance.Name & ";" & strWMIProviderCLSID))
                      If boolRC = False Then
                         CheckWMIProviderRegistration = ErrorHandler (objLOGFileHandle, "CheckWMIProviderRegistration", "WMI Provider '" & UCase (objWMIInstance.Name) & "' DCOM registration data '" & strWMIProviderCLSID & "' is missing or is access denied.", False, Err)
                         If boolInstanceWMIProvider = True Then
                            TrackingData.WMIProviderDCOMRegistrations = AddTrackingData (TrackingData.WMIProviderDCOMRegistrations, "@W;" & strWMINameSpace & ";" & objWMIInstance.Name & ";" & strWMIProviderCLSID & ";")
                         Else
                            TrackingData.WMIProviderDCOMRegistrations = AddTrackingData (TrackingData.WMIProviderDCOMRegistrations, "@E;" & strWMINameSpace & ";" & objWMIInstance.Name & ";" & strWMIProviderCLSID & ";")
                         End If 
                         TrackingData.WMIProviderLocationData = AddTrackingData (TrackingData.WMIProviderLocationData, strWMINameSpace & ";" & objWMIInstance.Name & ";No DCOM registry registration")
                         TrackingData.WMIProviderRegistrationData = AddTrackingData (TrackingData.WMIProviderRegistrationData, strWMINameSpace & ";" & objWMIInstance.Name & ";" & strWMIProviderRegistrationData & ";No DCOM registry registration")
                         CheckWMIProviderRegistration = True
                      Else
                         WriteToLogFile objLOGFileHandle, "WMI Provider '" & UCase (objWMIInstance.Name) & "' DCOM registration data '" & strWMIProviderCLSID & "' is missing, but this is expected (i.e. implemented as a Windows Service).", cLoggingLevel2, False
                         TrackingData.WMIProviderLocationData = AddTrackingData (TrackingData.WMIProviderLocationData, strWMINameSpace & ";" & objWMIInstance.Name & ";No DCOM registry registration (Exception)")
                         TrackingData.WMIProviderRegistrationData = AddTrackingData (TrackingData.WMIProviderRegistrationData, strWMINameSpace & ";" & objWMIInstance.Name & ";" & strWMIProviderRegistrationData & ";No DCOM registry registration (Exception)")
                      End If
                   End If

                   LocateCorrespondingMOFFile objLOGFileHandle, strWMINamespace, strWMIProviderCLSID, UCase (objWMIInstance.Name), strHostingModel
                Else
                   CheckWMIProviderRegistration = ErrorHandler (objLOGFileHandle, "CheckWMIProviderRegistration", "WMI Provider '" & UCase (objWMIInstance.Name) & "' has a NULL CLSID.", False, Err)
                   TrackingData.WMIProviderEmptyCLSID = AddTrackingData (TrackingData.WMIProviderEmptyCLSID, strWMINameSpace & ";" & objWMIInstance.Name)
                   strWMIProviderRegistrationData = strWMIProviderRegistrationData & ";" & "No CLSID available" & ";" & "No located BIN file"
                   TrackingData.WMIProviderRegistrationData = AddTrackingData (TrackingData.WMIProviderRegistrationData, strWMINameSpace & ";" & objWMIInstance.Name & ";" & strWMIProviderRegistrationData)
                End If 
             Else
                WriteToLogFile objLOGFileHandle, "WMI Provider '" & UCase (objWMIInstance.Name) & "' is a DECOUPLED WMI provider.", cLoggingLevel3, False
                TrackingData.DecoupledWMIProvider = AddTrackingData (TrackingData.DecoupledWMIProvider, strWMINameSpace & ";" & objWMIInstance.Name & ";Decoupled;" )
                longDecoupledWMIProvider = longDecoupledWMIProvider + 1
  
                TrackingData.GoodProviderCIMRegistration = AddTrackingData (TrackingData.GoodProviderCIMRegistration, strWMINameSpace & ";" & objWMIInstance.Name)

                If Len (objWMIInstance.SecurityDescriptor) > 0 Then 
                   WriteToLogFile objLOGFileHandle, "WMI Decoupled provider SDDL security descriptor set to '" & UCase (objWMIInstance.SecurityDescriptor) & "'.", cLoggingLevel3, False
                End If 
  
                If Len (strWMIProviderCLSID) = 0 Then 
                   strWMIProviderCLSID = "No CLSID available"
                End If

                strWMIProviderRegistrationData = strWMIProviderRegistrationData & ";" & strWMIProviderCLSID & ";" & "Decoupled"
                TrackingData.WMIProviderRegistrationData = AddTrackingData (TrackingData.WMIProviderRegistrationData, strWMINameSpace & ";" & objWMIInstance.Name & ";" & strWMIProviderRegistrationData)

                LocateCorrespondingMOFFile objLOGFileHandle, strWMINamespace, strWMIProviderCLSID, UCase (objWMIInstance.Name), strHostingModel
             End If 
         Next
         Set objWMIInstances = Nothing

End Function

' --------------------------------------------------------------------------------------------------------
Function RetrieveSupportedEventClasses (ByVal arrayEventQueryList, ByVal strWMINamespace, ByVal strWMIProvider)

         Dim strEventQuery
 
         On Error Resume Next
 
         For Each strEventQuery in arrayEventQueryList
             TrackingData.ClassSupportedByProvider = AddTrackingData (TrackingData.ClassSupportedByProvider, strWMINameSpace & ";" & strWMIProvider & ";" & Mid (strEventQuery, InStrRev (strEventQuery, " ", -1, vbTextCompare) + 1))
         Next

End Function

' --------------------------------------------------------------------------------------------------------
Function RetrieveSupportedConsumerClasses (ByVal arrayConsumerClassList, ByVal strWMINamespace, ByVal strWMIProvider)

         Dim strConsumerClass
 
         On Error Resume Next
 
         For Each strConsumerClass in arrayConsumerClassList
             TrackingData.ClassSupportedByProvider = AddTrackingData (TrackingData.ClassSupportedByProvider, strWMINameSpace & ";" & strWMIProvider & ";" & strConsumerClass)
         Next

End Function

' --------------------------------------------------------------------------------------------------------
Function LocateCorrespondingMOFFile (ByVal objLOGFileHandle, ByVal strWMINamespace, ByVal strWMIProviderCLSID, ByVal strWMIProviderName, ByVal strHostingModel)

         Dim boolRC, strExistingMOFFile, arrayMatchingOutput, strMOFFileList
 
         On Error Resume Next

         boolRC = False
 
         If Len (strWMIProviderCLSID) > 0 Then
            For Each strExistingMOFFile In arrayKnownMOFFiles
                If Len (strExistingMOFFile) > 0 Then 
                   boolRC = ParseFile (objLOGFileHandle, strExistingMOFFile, Array (strWMIProviderCLSID), arrayMatchingOutput, False, False) 
                   If boolRC = True Then 
                      If Len (strMOFFileList) = 0 Then
                         strMOFFileList = strExistingMOFFile
                      Else
                         strMOFFileList = strMOFFileList & " / " & strExistingMOFFile
                      End If
                   End If
                End If
            Next
         End If
 
         If Len (strMOFFileList) = 0 Then
            boolRC = ExceptionForMissingWMIProviderMOFFile (UCase(strWMINamespace & ";" & strWMIProviderName), UCase(strWMIProviderName & ";" & strHostingModel))
            If boolRC = False Then
               WriteToLogFile objLOGFileHandle, "MOF file of WMI Provider '" & UCase (strWMIProviderName) & "' (" & strWMIProviderCLSID & " / " & strHostingModel & ") of namespace '" & strWMINamespace & "' CANNOT be located.", cLoggingLevel2, False
               TrackingData.MissingWMIProviderMOFFile = AddTrackingData (TrackingData.MissingWMIProviderMOFFile, "@E;" & strWMINameSpace & ";" & strWMIProviderName & ";" & strWMIProviderCLSID & ";" & strHostingModel)
               LocateCorrespondingMOFFile = True
            Else
               WriteToLogFile objLOGFileHandle, "Provider '" & UCase (strWMIProviderName) & "' (" & strWMIProviderCLSID & " / " & strHostingModel & ") of namespace '" & strWMINamespace & "' has NO known located MOF file, but this is expected.", cLoggingLevel2, False
               TrackingData.MissingWMIProviderMOFFile = AddTrackingData (TrackingData.MissingWMIProviderMOFFile, "@W;" & strWMINameSpace & ";" & strWMIProviderName & ";" & strWMIProviderCLSID & ";" & strHostingModel)
               TrackingData.LocatedWMIProviderMOFFile = AddTrackingData (TrackingData.LocatedWMIProviderMOFFile , strWMINameSpace & ";" & strWMIProviderName & ";" & "No located MOF file (exception)")
            End If
         Else 
            WriteToLogFile objLOGFileHandle, "MOF file(s) '" & strMOFFileList & "' contain(s) registration data for WMI Provider '" & UCase (strWMIProviderName) & "' (" & strWMIProviderCLSID & ") of namespace '" & strWMINamespace & "'.", cLoggingLevel3, False
            TrackingData.LocatedWMIProviderMOFFile = AddTrackingData (TrackingData.LocatedWMIProviderMOFFile , strWMINameSpace & ";" & strWMIProviderName & ";" & strMOFFileList)
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function LocateNoPragmaAutorecoverMOFFile (ByVal objLOGFileHandle)

         Dim boolFoundPragma, strExistingMOFFile, strMOFFile, arrayMatchingOutput, boolFoundInAutorecoveryList, boolFoundPragmaDelete 
 
         On Error Resume Next
 
         boolFoundPragma = False

         WriteToLogFile objLOGFileHandle, "Verifying '#PRAGMA AUTORECOVER' statement in MOF files.", cLoggingLevel0, False
 
         For Each strExistingMOFFile In arrayKnownMOFFiles
                If Len (strExistingMOFFile) > 0 Then 
                   strExistingMOFFile = Ucase (objWshShell.ExpandEnvironmentStrings (strExistingMOFFile))
                   boolFoundPragma = ParseFile (objLOGFileHandle, strExistingMOFFile, Array ("#PRAGMA AUTORECOVER"), arrayMatchingOutput, True, False) 
                   If boolFoundPragma = True Then 
                      TrackingData.PragmaAutorecoverMOFFile = AddTrackingData (TrackingData.PragmaAutorecoverMOFFile, strExistingMOFFile)
                   Else
                      boolFoundInAutorecoveryList = False
                      For Each strMOFFile In arrayKnownMOFFilesInAutoRecovery
                          If UCase (objWshShell.ExpandEnvironmentStrings (strMOFFile)) = strExistingMOFFile Then
                             boolFoundInAutorecoveryList = True
                             Exit For
                          End If 
                      Next

                      boolFoundPragmaDelete = ParseFile (objLOGFileHandle, strExistingMOFFile, Array ("DELETECLASS", "DELETEINSTANCE"), arrayMatchingOutput, False, False) 

                      If boolFoundInAutorecoveryList = True Then 
                         If boolFoundPragmaDelete = True Then
                            WriteToLogFile objLOGFileHandle, "MOF file '" & strExistingMOFFile & "' does NOT contain the '#PRAGMA AUTORECOVER' statement but it contains DELETE MOF statements while included in the AUTORECOVERY LIST!", cLoggingLevel2, False
                            WriteToLogFile objLOGFileHandle, "=> Only the MOF statements and logic will determine if the MOF is a true UNINSTALL MOF.", cLoggingLevel3, False
                            WriteToLogFile objLOGFileHandle, "   A true UNINSTALL MOF should NOT contain the '#PRAGMA AUTORECOVER' statement and should NOT be included in the AUTORECOVER LIST.", cLoggingLevel3, False
                            TrackingData.NoPragmaAutorecoverMOFFile = AddTrackingData (TrackingData.NoPragmaAutorecoverMOFFile, strExistingMOFFile & " (DELETE) (*)")
                         Else
                            WriteToLogFile objLOGFileHandle, "MOF file '" & strExistingMOFFile & "' does NOT contain the '#PRAGMA AUTORECOVER' statement but it is included in the AUTORECOVERY LIST, which is FINE!", cLoggingLevel3, False
                            TrackingData.NoPragmaAutorecoverMOFFile = AddTrackingData (TrackingData.NoPragmaAutorecoverMOFFile, strExistingMOFFile & " (*)")
                         End If
                      Else
                         If boolFoundPragmaDelete = True Then
                            WriteToLogFile objLOGFileHandle, "MOF file '" & strExistingMOFFile & "' does NOT contain the '#PRAGMA AUTORECOVER' statement but it contains DELETE MOF statements while NOT included in the AUTORECOVERY LIST, which could be FINE!", cLoggingLevel2, False
                            WriteToLogFile objLOGFileHandle, "=> Only the MOF statements and logic will determine if the MOF is a true UNINSTALL MOF.", cLoggingLevel3, False
                            WriteToLogFile objLOGFileHandle, "   A true UNINSTALL MOF should NOT contain the '#PRAGMA AUTORECOVER' statement and should NOT be included in the AUTORECOVER LIST.", cLoggingLevel3, False
                            TrackingData.NoPragmaAutorecoverMOFFile = AddTrackingData (TrackingData.NoPragmaAutorecoverMOFFile, strExistingMOFFile & " (DELETE)")
                         Else
                            WriteToLogFile objLOGFileHandle, "MOF file '" & strExistingMOFFile & "' does NOT contain the '#PRAGMA AUTORECOVER' statement.", cLoggingLevel2, False
                            TrackingData.NoPragmaAutorecoverMOFFile = AddTrackingData (TrackingData.NoPragmaAutorecoverMOFFile, strExistingMOFFile)
                         End If
                      End If
                   End If
                End If
            Next

End Function

' --------------------------------------------------------------------------------------------------------
Function ExceptionForNoAutoRecoveryWBEMMOFFiles (ByVal strMOFFile)

         Dim intIndex
 
         On Error Resume Next

         ExceptionForNoAutoRecoveryWBEMMOFFiles = False
 
         If boolStrict = False Then
            For intIndex = 0 to UBound (arrayExceptionForNoAutoRecoveryWBEMMOFFiles)
                If Instr (Ucase (strMOFFile), Ucase (arrayExceptionForNoAutoRecoveryWBEMMOFFiles (intIndex))) > 0 Then
                   ExceptionForNoAutoRecoveryWBEMMOFFiles = True
                   Exit Function
                End If
            Next
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function ExceptionForMissingWMIProviderMOFFile (ByVal strNamespaceAndProvider, ByVal strWMIProviderAndHostingModel)

         Dim intIndex
 
         On Error Resume Next
 
         ExceptionForMissingWMIProviderMOFFile = False
  
         If boolStrict = False Then
            For intIndex = 0 to UBound (arrayExceptionForMissingWMIProviderMOFFile) Step 2
                If Instr (Ucase (arrayExceptionForMissingWMIProviderMOFFile (intIndex)), Ucase (strNamespaceAndProvider)) > 0 Then
                   ExceptionForMissingWMIProviderMOFFile = True
                   Exit Function
                End If
                If Instr (Ucase (arrayExceptionForMissingWMIProviderMOFFile (intIndex + 1)), Ucase (strWMIProviderAndHostingModel)) > 0 Then
                   ExceptionForMissingWMIProviderMOFFile = True
                   Exit Function
                End If
            Next
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function ExceptionForMissingWMIProviderFile (ByVal strNameSpaceProviderAndCLSID)

         Dim intIndex
 
         On Error Resume Next
 
         ExceptionForMissingWMIProviderFile = False
 
         If boolStrict = False Then
            For intIndex = 0 to UBound (arrayExceptionForMissingWMIProviderFile) Step 2
                If Instr (Ucase (arrayExceptionForMissingWMIProviderFile (intIndex)), Ucase (strNameSpaceProviderAndCLSID)) > 0 Then
                  If arrayExceptionForMissingWMIProviderFile (intIndex + 1) = cClientAndServer Then
                      ExceptionForMissingWMIProviderFile = True
                      Exit Function
                   End If
                   If (RunTimeEnvironmentInfo.IsServerOS = True) And arrayExceptionForMissingWMIProviderFile (intIndex + 1) = cServerOnly Then
                      ExceptionForMissingWMIProviderFile = True
                      Exit Function
                   End If
                   If (RunTimeEnvironmentInfo.IsServerOS = False) And arrayExceptionForMissingWMIProviderFile (intIndex + 1) = cClientOnly Then
                      ExceptionForMissingWMIProviderFile = True
                      Exit Function
                   End If
                End If
            Next
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function ExceptionForMissingDCOMProviderRegistration (ByVal strNameSpaceProviderAndCLSID)

         Dim intIndex
 
         On Error Resume Next
 
         ExceptionForMissingDCOMProviderRegistration = False
 
         If boolStrict = False Then
            For intIndex = 0 to UBound (arrayExceptionForMissingDCOMRegistration) Step 2
                If Instr (Ucase (arrayExceptionForMissingDCOMRegistration (intIndex)), Ucase (strNameSpaceProviderAndCLSID)) > 0 Then
                   If arrayExceptionForMissingDCOMRegistration (intIndex + 1) = cClientAndServer Then
                      ExceptionForMissingDCOMProviderRegistration = True
                      Exit Function
                   End If
                   If (RunTimeEnvironmentInfo.IsServerOS = True) And arrayExceptionForMissingDCOMRegistration (intIndex + 1) = cServerOnly Then
                      ExceptionForMissingDCOMProviderRegistration = True
                      Exit Function
                   End If
                   If (RunTimeEnvironmentInfo.IsServerOS = False) And arrayExceptionForMissingDCOMRegistration (intIndex + 1) = cClientOnly Then
                      ExceptionForMissingDCOMProviderRegistration = True
                      Exit Function
                   End If
                End If
            Next
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function ExceptionForHighPrivWMIProvider (ByVal strWMIProviderNameAndCLSID)

         Dim intIndex
 
         On Error Resume Next

         ExceptionForHighPrivWMIProvider = False
 
         If boolStrict = False Then
            For intIndex = 0 to UBound (arrayExceptionHighPrivWMIProvider)
                If Instr (Ucase (arrayExceptionHighPrivWMIProvider (intIndex)), Ucase (strWMIProviderNameAndCLSID)) > 0 Then
                   ExceptionForHighPrivWMIProvider = True
                   Exit Function
                End If
            Next
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckWMIClasses (ByVal objLOGFileHandle, ByVal objWMIServices, ByVal objWMIClasses, ByVal strWMINamespace, ByVal I)

         Dim strWMIClass, objWMIClass, objWMISubClasses, objWMIInstances, objWMIProperty, objWMIMethod, objWMIParameter, objWMIParameters
         Dim strMOF, strWMIProvider, strWQL
         Dim intClassCounter, boolDynamic, strInstanceType, boolAssociation, boolRead, boolWrite, strDescription
         Dim strStartQuery, intQueryExecutionTime, intCount 
         Dim objWMISinkContext
 
         On Error Resume Next
 
         strExecutionDelta = Now()
 
         For Each objWMIClass In objWMIClasses
             strWMIClass = objWMIClass.Path_.RelPath
 
             WriteToLogFile objLOGFileHandle, "Retrieving static information (MOF) of '" & strWMIClass & "' (I=" & I & ").", cLoggingLevel3, False
             strMOF = objWMIClass.GetObjectText_
             If Err.Number Then
                CheckWMIClasses = ErrorHandler (objLOGFileHandle, "CheckWMIClasses", "", False, Err)
                TrackingData.FailingMOFRepresentation = AddTrackingData (TrackingData.FailingMOFRepresentation, strWMINameSpace & ";" & strWMIClass & ";" & strLastError)
             End If 
 
             strWMIProvider = GetQualifier (objLOGFileHandle, objWMIClass, "Provider", "@NULL@", strWMINameSpace, strWMIClass)
             boolAssociation = GetQualifier (objLOGFileHandle, objWMIClass, "Association", False, strWMINameSpace, strWMIClass)
             boolDynamic = GetQualifier (objLOGFileHandle, objWMIClass, "Dynamic", False, strWMINameSpace, strWMIClass)
             strDescription = GetQualifier (objLOGFileHandle, objWMIClass, "Description", "", strWMINameSpace, strWMIClass)

             WriteToLogFile objLOGFileHandle, "Qualifier information of '" & strWMIClass & "': Dynamic=" & boolDynamic & ", Provider='" & ReplaceString (strWMIProvider , "@NULL@", "<NOT DEFINED>") & "', Association=" & boolAssociation & ".", cLoggingLevel3, False

             If Left (strWMIClass, 2) <> "__" And boolStatistics = True Then
                If Left (strWMIClass, 4) = "CIM_" Then
                   longCIMClassCounter = longCIMClassCounter + 1
                   If Len (strDescription) > 0 Then longCIMClassDescriptionCounter = longCIMClassDescriptionCounter + 1

                   longCIMClassPropertyCounter = longCIMClassPropertyCounter + objWMIClass.Properties_.Count
                   For Each objWMIProperty In objWMIClass.Properties_
                       strDescription = GetQualifier (objLOGFileHandle, objWMIProperty, "Description", "", strWMINameSpace, strWMIClass & "/" & objWMIProperty.Name) 
                       boolRead = GetQualifier (objLOGFileHandle, objWMIProperty, "read", False, strWMINameSpace, strWMIClass & "/" & objWMIProperty.Name)
                       boolWrite = GetQualifier (objLOGFileHandle, objWMIProperty, "write", False, strWMINameSpace, strWMIClass & "/" & objWMIProperty.Name)

                       If boolRead = True And boolWrite = False Then
                          longCIMClassReadPropertyCounter = longCIMClassReadPropertyCounter + 1
                          If Len (strDescription) > 0 Then longCIMClassReadPropertyDescriptionCounter = longCIMClassReadPropertyDescriptionCounter + 1
                       End If
                       If boolRead = False And boolWrite = True Then
                          longCIMClassWritePropertyCounter = longCIMClassWritePropertyCounter + 1
                          If Len (strDescription) > 0 Then longCIMClassWritePropertyDescriptionCounter = longCIMClassWritePropertyDescriptionCounter + 1
                       End If
                       If boolRead = True And boolWrite = True Then
                          longCIMClassReadWritePropertyCounter = longCIMClassReadWritePropertyCounter + 1
                          If Len (strDescription) > 0 Then longCIMClassReadWritePropertyDescriptionCounter = longCIMClassReadWritePropertyDescriptionCounter + 1
                       End If
                       If boolRead = False And boolWrite = False Then 
                          If Len (strDescription) > 0 Then 
                             longCIMClassPropertyDescriptionCounter = longCIMClassPropertyDescriptionCounter + 1
                          Else
                             longCIMClassPropertyNoDescriptionCounter = longCIMClassPropertyNoDescriptionCounter + 1
                          End If
                       End If
                   Next

                   longCIMClassMethodCounter = longCIMClassMethodCounter + objWMIClass.Methods_.Count
                   If objWMIClass.Methods_.Count > 0 Then longCIMClassWithMethodCounter = longCIMClassWithMethodCounter + 1
                   For Each objWMIMethod In objWMIClass.Methods_
                       strDescription = GetQualifier (objLOGFileHandle, objWMIMethod, "Description", "", strWMINameSpace, strWMIClass & "/" & objWMIMethod.Name & "()") 
                       If Len (strDescription) > 0 Then longCIMClassMethodDescriptionCounter = longCIMClassMethodDescriptionCounter + 1
                       Set objWMIParameters = objWMIMethod.InParameters.Properties_
                       intCount = objWMIParameters.Count           
                       If intCount > 0 Then
                          longCIMClassMethodInParameterCounter = longCIMClassMethodInParameterCounter + intCount

                          For Each objWMIParameter In objWMIParameters
                              strDescription = GetQualifier (objLOGFileHandle, objWMIParameter, "Description", "", strWMINameSpace, strWMIClass & "/" & objWMIMethod.Name & "([In]" & objWMIParameter.Name & ")") 
                              If Len (strDescription) > 0 Then longCIMClassMethodInParamDescriptionCounter = longCIMClassMethodInParamDescriptionCounter + 1
                          Next
                       Else 
                          Err.Clear
                       End If
                       Set objWMIParameters = objWMIMethod.OutParameters.Properties_
                       intCount = objWMIParameters.Count           
                       If intCount > 0 Then
                          longCIMClassMethodOutParameterCounter = longCIMClassMethodOutParameterCounter + intCount
                          Err.Clear

                          For Each objWMIParameter In objWMIParameters
                              strDescription = GetQualifier (objLOGFileHandle, objWMIParameter, "Description", "", strWMINameSpace, strWMIClass & "/" & objWMIMethod.Name & "([Out]" & objWMIParameter.Name & ")") 
                              If Len (strDescription) > 0 Then longCIMClassMethodOutParamDescriptionCounter = longCIMClassMethodOutParamDescriptionCounter + 1
                          Next
                       Else
                          Err.Clear
                       End If
                   Next
                Else
                   longWMIClassCounter = longWMIClassCounter + 1
                   If Len (strDescription) > 0 Then longWMIClassDescriptionCounter = longWMIClassDescriptionCounter + 1

                   longWMIClassPropertyCounter = longWMIClassPropertyCounter + objWMIClass.Properties_.Count
                   For Each objWMIProperty In objWMIClass.Properties_
                       strDescription = GetQualifier (objLOGFileHandle, objWMIProperty, "Description", "", strWMINameSpace, strWMIClass & "/" & objWMIProperty.Name) 
                       boolRead = GetQualifier (objLOGFileHandle, objWMIProperty, "read", False, strWMINameSpace, strWMIClass & "/" & objWMIProperty.Name)
                       boolWrite = GetQualifier (objLOGFileHandle, objWMIProperty, "write", False, strWMINameSpace, strWMIClass & "/" & objWMIProperty.Name)

                       If boolRead = True And boolWrite = False Then
                          longWMIClassReadPropertyCounter = longWMIClassReadPropertyCounter + 1
                          If Len (strDescription) > 0 Then longWMIClassReadPropertyDescriptionCounter = longWMIClassReadPropertyDescriptionCounter + 1
                       End If
                       If boolRead = False And boolWrite = True Then
                          longWMIClassWritePropertyCounter = longWMIClassWritePropertyCounter + 1
                          If Len (strDescription) > 0 Then longWMIClassWritePropertyDescriptionCounter = longWMIClassWritePropertyDescriptionCounter + 1
                       End If
                       If boolRead = True And boolWrite = True Then
                          longWMIClassReadWritePropertyCounter = longWMIClassReadWritePropertyCounter + 1
                          If Len (strDescription) > 0 Then longWMIClassReadWritePropertyDescriptionCounter = longWMIClassReadWritePropertyDescriptionCounter + 1
                       End If
                       If boolRead = False And boolWrite = False Then 
                          If Len (strDescription) > 0 Then 
                             longWMIClassPropertyDescriptionCounter = longWMIClassPropertyDescriptionCounter + 1
                          Else
                             longWMIClassPropertyNoDescriptionCounter = longWMIClassPropertyNoDescriptionCounter + 1
                          End If
                       End If
                   Next

                   longWMIClassMethodCounter = longWMIClassMethodCounter + objWMIClass.Methods_.Count
                   If objWMIClass.Methods_.Count > 0 Then longWMIClassWithMethodCounter = longWMIClassWithMethodCounter + 1
                   For Each objWMIMethod In objWMIClass.Methods_
                       strDescription = GetQualifier (objLOGFileHandle, objWMIMethod, "Description", "", strWMINameSpace, strWMIClass & "/" & objWMIMethod.Name & "()") 
                       If Len (strDescription) > 0 Then longWMIClassMethodDescriptionCounter = longWMIClassMethodDescriptionCounter + 1
                       Set objWMIParameters = objWMIMethod.InParameters.Properties_
                       intCount = objWMIParameters.Count           
                       If intCount > 0 Then
                          longWMIClassMethodInParameterCounter = longWMIClassMethodInParameterCounter + intCount

                          For Each objWMIParameter In objWMIParameters
                              strDescription = GetQualifier (objLOGFileHandle, objWMIParameter, "Description", "", strWMINameSpace, strWMIClass & "/" & objWMIMethod.Name & "([In]" & objWMIParameter.Name & ")") 
                              If Len (strDescription) > 0 Then longWMIClassMethodInParamDescriptionCounter = longWMIClassMethodInParamDescriptionCounter + 1
                          Next
                       Else 
                          Err.Clear
                       End If
                       Set objWMIParameters = objWMIMethod.OutParameters.Properties_
                       intCount = objWMIParameters.Count  
                       If intCount > 0 Then
                          longWMIClassMethodOutParameterCounter = longWMIClassMethodOutParameterCounter + intCount
                          Err.Clear

                          For Each objWMIParameter In objWMIParameters
                              strDescription = GetQualifier (objLOGFileHandle, objWMIParameter, "Description", "", strWMINameSpace, strWMIClass & "/" & objWMIMethod.Name & "([Out]" & objWMIParameter.Name & ")") 
                              If Len (strDescription) > 0 Then longWMIClassMethodOutParamDescriptionCounter = longWMIClassMethodOutParamDescriptionCounter + 1
                          Next
                       Else
                          Err.Clear
                       End If
                   Next
                End If
             End If 
 
             If boolDynamic = False Then
                strInstanceType = " static "
                If strWMIProvider <> "@NULL@" Then
                   TrackingData.ClassSupportedByProvider = AddTrackingData (TrackingData.ClassSupportedByProvider, strWMINameSpace & ";" & strWMIProvider & ";" & strWMIClass)
                End If 

                If I < intMaxSubClassExaminationDepth Then
                   WriteToLogFile objLOGFileHandle, "Retrieving subclass(es) of '" & strWMIClass & "'.", cLoggingLevel4, False
 
                   Set objWMISubClasses = objWMIClass.SubClasses_ (wbemQueryFlagShallow)
                   If Err.Number Then
                      CheckWMIClasses = ErrorHandler (objLOGFileHandle, "CheckWMIClasses", "", False, Err)
                      TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";SubClassesOf;" & strWMIClass & ";" & cCritical & ";" & strLastError)
                   End If
  
                   intClassCounter = objWMISubClasses.Count
                   If Err.Number Then
                      CheckWMIClasses = ErrorHandler (objLOGFileHandle, "CheckWMIClasses", "", False, Err)
                      TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";SubClassesOf;" & strWMIClass & ";" & cCritical & ";" & strLastError)
                   End If
    
                   WriteToLogFile objLOGFileHandle, intClassCounter & " subclass(es) found (Inheritance level analysis=" & intMaxSubClassExaminationDepth & ").", cLoggingLevel4, False
                   If intClassCounter Then
                      CheckWMIClasses = CheckWMIClasses (objLOGFileHandle, objWMIServices, objWMISubClasses, strWMINamespace, I + 1)
                   End If
                   Set objWMISubClasses = Nothing
                End If
             Else 
                strInstanceType = " dynamic "
                If strWMIProvider <> "@NULL@" Then
                   WriteToLogFile objLOGFileHandle, "Dynamic '" & strWMIClass & "' class in '" & strWMINamespace & "' is supported by WMI provider '" & strWMIProvider & "'.", cLoggingLevel3, False
                   TrackingData.ClassSupportedByProvider = AddTrackingData (TrackingData.ClassSupportedByProvider, strWMINameSpace & ";" & strWMIProvider & ";" & strWMIClass)
 
                   If Len (TrackingData.WMIProviderDCOMRegistrations) > 0 Then
                      If Instr (UCase (TrackingData.WMIProviderDCOMRegistrations), UCase (strWMINameSpace & ";" & strWMIProvider)) > 0 Then 
                         CheckWMIClasses = ErrorHandler (objLOGFileHandle, "CheckWMIClasses", "WMI Class '" & strWMIClass & "' still references the WMI Provider '" & Ucase (strWMIProvider) & "' in namespace '" & UCase (strWMINamespace) & "', which has no DCOM registration data.", False, Err)
                         TrackingData.WMIProviderDCOMRegistrations = ReplaceString (TrackingData.WMIProviderDCOMRegistrations, _
                                                                                    "@W;" & strWMINameSpace & ";" & strWMIProvider & ";", _
                                                                                    "@E;" & strWMINameSpace & ";" & strWMIProvider & ";" & strWMIClass & ";")
                      End If 
                   End If 
                   If Instr (UCase (TrackingData.GoodProviderCIMRegistration), UCase (strWMINameSpace & ";" & strWMIProvider)) = 0 Then
                      CheckWMIClasses = ErrorHandler (objLOGFileHandle, "CheckWMIClasses", "WMI Class '" & strWMIClass & "' still references the WMI Provider '" & Ucase (strWMIProvider) & "' in namespace '" & UCase (strWMINamespace) & "', which has no WMI registration data.", False, Err)
                      TrackingData.WMIProviderCIMRegistrations = AddTrackingData (TrackingData.WMIProviderCIMRegistrations, strWMINameSpace & ";" & strWMIProvider & ";" & strWMIClass)
                   End If
                End If 
             End If
 
             If I = 1 and intRequestAllInstances > 0 Then
                If (_ 
                    Instr (UCase (TrackingData.WMIProviderSupportingEnumeration), UCase (strWMINameSpace & ";" & strWMIProvider)) > 0 And _
                    Instr (UCase (TrackingData.MissingWMIProviderFile), UCase (strWMINameSpace & ";" & strWMIProvider)) = 0 And _
                    Instr (UCase (TrackingData.WMIProviderDCOMRegistrations), UCase (strWMINameSpace & ";" & strWMIProvider)) = 0 And _
                    Instr (UCase (TrackingData.WMIProviderCIMRegistrations), UCase (strWMINameSpace & ";" & strWMIProvider)) = 0 And _
                    Instr (UCase (TrackingData.DecoupledWMIProvider), UCase (strWMINameSpace & ";" & strWMIProvider)) = 0 And _
                    boolDynamic = True And strWMIProvider <> "@NULL@" And _
                    ((intRequestAllInstances And cDynamic) = cDynamic) _
                   ) Or _
                   (boolAssociation = False And boolDynamic = False And strWMIProvider = "@NULL@" And ((intRequestAllInstances And cStatic) = cStatic) _
                   ) Then  
 
                   strStartQuery = Now()
                   WriteToLogFile objLOGFileHandle, "Requesting all" & strInstanceType & "instances of '" & strWMIClass & "' in '" & strWMINamespace & "' (" & Now () & ") ...", cLoggingLevel3, False
  
                   boolSinkCompleted = False
                   boolSinkCancelled = False
                   boolSinkError = False
  
                   Set objWMISinkContext = CreateObject ("WbemScripting.SWbemNamedValueSet")
                   If Err.Number Then
                      CheckWMIClasses = ErrorHandler (objLOGFileHandle, "CheckWMIClasses", "", False, Err)
                      Exit Function
                   End If

                   Set objWMISink = WScript.CreateObject ("WbemScripting.SWbemSink", "InstancesOfSink_")
                   If Err.Number Then
                      CheckWMIClasses = ErrorHandler (objLOGFileHandle, "CheckWMIClasses", "", False, Err)
                      Exit Function
                   End If

                   objWMISinkContext.Add "WMIClass", strWMINameSpace & ";InstancesOfAsync;" & strWMIClass
 
                   objWMIServices.InstancesOfAsync objWMISink, strWMIClass, wbemFlagSendStatus Or wbemQueryFlagShallow, , objWMISinkContext
                   If Err.Number Then
                      CheckWMIClasses = ErrorHandler (objLOGFileHandle, "CheckWMIClasses", "", False, Err)
                      TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOfAsync;" & strWMIClass & ";" & cCritical & ";" & strLastError)
                   Else
                      Do
                           WScript.Sleep (10)
                           If boolSinkCompleted Or boolSinkCancelled Then 
                              objWMISink.Cancel
                              Exit Do
                           End If
                      Loop While (longAsyncInstanceCounter < cAsyncMaxInstances)
  
                      intExecutionDelta = DateDiff ("s", strExecutionDelta, Now())
                      If intExecutionDelta > 10 And intDefaultLoggingLevel < cLoggingLevel3 Then
                         WriteToLogFile objLOGFileHandle, "Busy (" & Now () & ") ...", cLoggingLevel3, True
                         strExecutionDelta = Now ()
                      End If
  
                      If boolSinkError = False Then
                         intQueryExecutionTime = DateDiff ("s", strStartQuery, Now())   
 
                         If longAsyncInstanceCounter > 0 Then
                            If boolDynamic = True Then
                               longDynamicInstanceCounter = longDynamicInstanceCounter + longAsyncInstanceCounter
                            Else
                               longStaticInstanceCounter = longStaticInstanceCounter + longAsyncInstanceCounter
                            End if
    
                            If boolSinkCancelled Then
                               WriteToLogFile objLOGFileHandle, "More than " & cAsyncMaxInstances & strInstanceType & "instances counted (" & longAsyncInstanceCounter & ") for '" & strWMIClass & "' in '" & strWMINamespace & "' in " & intQueryExecutionTime & " second(s). Instance collection request cancelled.", cLoggingLevel2, False
                               longAsyncCancellationCounter = longAsyncCancellationCounter + 1
                            Else
                                WriteToLogFile objLOGFileHandle, longAsyncInstanceCounter & strInstanceType & "instance(s) found for '" & strWMIClass & "' in '" & strWMINamespace & "'in " & intQueryExecutionTime & " second(s).", cLoggingLevel3, False
                            End If
 
                            longAsyncInstanceCounter = 0
                         Else
                            WriteToLogFile objLOGFileHandle, "0" & strInstanceType & "instance(s) found for '" & strWMIClass & "' in '" & strWMINamespace & "'.", cLoggingLevel3, False
                         End If
                      End If
                   End If
 
                   Set objWMISink = Nothing
                  Set objWMISinkContext = Nothing
                Else
                   WriteToLogFile objLOGFileHandle, "Skipping request of" & strInstanceType & "instances of '" & strWMIClass & "' in '" & strWMINamespace & "' because:", cLoggingLevel3, False
 
                   If Not ((intRequestAllInstances And cDynamic) = cDynamic) And boolDynamic = True Then
                      WriteToLogFile objLOGFileHandle, "- Request all dynamic instances is set to FALSE.", cLoggingLevel3, False
                   End If
 
                   If Not ((intRequestAllInstances And cStatic) = cStatic) And boolDynamic = False Then
                      WriteToLogFile objLOGFileHandle, "- Request all static instances is set to FALSE.", cLoggingLevel3, False
                   End If
 
                   If strWMIProvider <> "@NULL@" Then
                      If Instr (UCase (TrackingData.WMIProviderSupportingEnumeration), UCase (strWMINameSpace & ";" & strWMIProvider)) = 0 Then
                         WriteToLogFile objLOGFileHandle, "- The WMI provider does not support enumeration.", cLoggingLevel3, False
                      End If
                   End If
 
                   If Instr (UCase (TrackingData.MissingWMIProviderFile), UCase (strWMINameSpace & ";" & strWMIProvider)) > 0 Then
                      WriteToLogFile objLOGFileHandle, "- The WMI provider EXE/DLL is missing.", cLoggingLevel3, False
                   End If
 
                   If Instr (UCase (TrackingData.WMIProviderDCOMRegistrations), UCase (strWMINameSpace & ";" & strWMIProvider)) > 0 Then
                      WriteToLogFile objLOGFileHandle, "- The WMI provider DCOM registration is missing.", cLoggingLevel3, False
                   End If
 
                   If Instr (UCase (TrackingData.DecoupledWMIProvider), UCase (strWMINameSpace & ";" & strWMIProvider)) > 0 Then
                      WriteToLogFile objLOGFileHandle, "- The WMI provider is a decoupled provider.", cLoggingLevel3, False
                   End If
 
                   If (boolDynamic = True And strWMIProvider = "@NULL@") Then
                      WriteToLogFile objLOGFileHandle, "- The WMI class is dynamic and does not have a provider specified.", cLoggingLevel3, False
                   End If
 
                   If (boolAssociation = True) Then
                      WriteToLogFile objLOGFileHandle, "- The WMI class is an association class.", cLoggingLevel3, False
                   End If
                End If
             End If
         Next

End Function

' --------------------------------------------------------------------------------------------------------
Function InstancesOfSink_OnCompleted (intRC, objWMILastError, objWMIContext)

         Dim strWBEMCode, strWBEMMessage
         Dim strLastHexError, strLastError, strErrorString, strDescription

         On Error Resume Next

         If intRC And intRC <> WBEM_E_CALL_CANCELLED Then
            If intRC <> WBEM_E_NOT_SUPPORTED And intRC <> WBEM_E_PROVIDER_NOT_CAPABLE Then
               strLastHexError = "0x" & Hex(intRC)
               If Left (strLastHexError, 7) = "0x80041" Then
                  GetWMIErrorMessage strLastHexError, strWBEMCode, strWBEMMessage
                  strLastError = strLastHexError & ";(" & strWBEMCode & ") " & strWBEMMessage
                  strErrorString = strLastHexError & " - (" & strWBEMCode & ") " & strWBEMMessage 
               Else
                  If Len (objWMILastError.Description) > 0 Then
                     strDescription = objWMILastError.Description
                  Else
                     strDescription = ""
                  End If
     
                  strLastError = strLastHexError & ";" & strDescription
                  If Len (strDescription) > 0 Then strDescription = " - " & strDescription
                  strErrorString = strLastHexError & strDescription
               End If

               ErrorHandler objLOGFileHandle, "InstancesOfSink_OnCompleted", strErrorString, False, Err
               TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, objWMIContext.Item ("WMIClass") & ";" & cCritical & ";" & strLastError)
            End If
            boolSinkError = True
         End If
  
         boolSinkCompleted = True

End Function

' --------------------------------------------------------------------------------------------------------
Function InstancesOfSink_OnObjectReady (objWMIInstance, objWMIContext)

         On Error Resume Next
 
         longAsyncInstanceCounter = longAsyncInstanceCounter + 1
 
         intExecutionDelta = DateDiff ("s", strExecutionDelta, Now())
 
         If intExecutionDelta > 10 Then
            WriteToLogFile objLOGFileHandle, "Busy (" & Now () & ") ...", cLoggingLevel3, True
            strExecutionDelta = Now ()
         End If
 
         If longAsyncInstanceCounter > cAsyncMaxInstances Then 
            boolSinkCancelled = True
            objWMISink.Cancel
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function GetADAPStatus (ByVal objLOGFileHandle)

         Dim objWMIServices
         Dim objWMIInstance, objWMIInstances
         Dim strADAPStateMessage
         Dim strStartDate, strStartTime, strStartGMT
         Dim strStopDate, strStopTime, strStopGMT
         Dim strADAPStartLongDateTime, strADAPStopLongDateTime

         On Error Resume Next

         If RunTimeEnvironmentInfo.OSIdentifier < cWindowsVistaRTM Then
            WriteToLogFile objLOGFileHandle, "Verifying WMI ADAP status.", cLoggingLevel0, False

            Set objWMIServices = objWMILocator.ConnectServer("LocalHost", "Root\Default", "", "")
            If Err.Number Then 
               GetADAPStatus = ErrorHandler (objLOGFileHandle, "GetADAPStatus", "", False, Err)
               TrackingData.WMIConnectionErrors = AddTrackingData (TrackingData.WMIConnectionErrors, strWMINameSpace & ";" & strLastError)
               Exit Function
            End If

            Set objWMIInstances = objWMIServices.InstancesOf ("__ADAPStatus", wbemQueryFlagShallow)
            If Err.Number Then
               GetADAPStatus = ErrorHandler (objLOGFileHandle, "GetADAPStatus", "", False, Err)
               TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;__NAMESPACE;" & cCritical & ";" & strLastError)
               Exit Function 
            End If

            Set objWMIInstance = objWMIServices.Get ("__ADAPStatus=@")
            If Err.Number Then 
               GetADAPStatus = ErrorHandler (objLOGFileHandle, "GetADAPStatus", "", False, Err)
               TrackingData.WMIGetErrors = AddTrackingData (TrackingData.WMIGetErrors, "Root/Default;__ADAPStatus=@" & "';" & strLastError)
               Exit Function
            End If

            Select Case (objWMIInstance.Status)
                   Case 0
                        strADAPStateMessage = "The WMI ADAP process has never run on this computer (0)."
                   Case 1
                        strADAPStateMessage = "The WMI ADAP process is currently running (1)."
                   Case 2
                        strADAPStateMessage = "The WMI ADAP process is processing a performance library (2)."
                   Case 3
                        strADAPStateMessage = "The WMI ADAP process is updating and committing changes to WMI (3)."
                   Case 4
                        strADAPStateMessage = "The WMI ADAP process has finished (4)."
                   Case Else
                        strADAPStateMessage = "Invalid WMI ADAP process status."
            End Select

            strADAPStartLongDateTime = ConvertDMTFDateTimeToLongDateTime (objLOGFileHandle, objWMIInstance.LastStartTime, strStartDate, strStartTime, strStartGMT, True)
            strADAPStopLongDateTime = ConvertDMTFDateTimeToLongDateTime (objLOGFileHandle, objWMIInstance.LastStopTime, strStopDate, strStopTime, strStopGMT, True)

            WriteToLogFile objLOGFileHandle, "ADAP last start time is: '" & strADAPStartLongDateTime & "'", cLoggingLevel3, False
            WriteToLogFile objLOGFileHandle, "ADAP last stop time is: '" & strADAPStopLongDateTime & "'", cLoggingLevel3, False
            WriteToLogFile objLOGFileHandle, "ADAP last message is: '" & strADAPStateMessage & "'", cLoggingLevel3, False
            TrackingData.ADAPStatus = AddTrackingData (TrackingData.ADAPStatus, strADAPStartLongDateTime & ";" & strADAPStopLongDateTime & ";" & strADAPStateMessage & ";" & objWMIInstance.Status)
         End If
 
End Function

' --------------------------------------------------------------------------------------------------------
Function CheckSMSWMISetup (ByVal objLOGFileHandle)

         On Error Resume Next

         If Len (RunTimeEnvironmentInfo.SMSAgent) > 0 And cSMSTest = True Then
	    if Left (RunTimeEnvironmentInfo.SMSAgent,3) = "4.0" Then
                CheckWMIFeatures objLOGFileHandle, arraySCCMTestList, "Verifying SCCM Agent v" & RunTimeEnvironmentInfo.SMSAgent & " WMI features."
	    Else
                CheckWMIFeatures objLOGFileHandle, arraySMSTestList, "Verifying SMS Agent v" & RunTimeEnvironmentInfo.SMSAgent & " WMI features."
	    End If

            CheckWMIFeatures objLOGFileHandle, arraySMSAddedTestList, ""
         End If 

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckWMIFeatures (ByVal objLOGFileHandle, ByVal arrayWMITestList, ByVal strOperationDescription)

	 Dim intIndex, intWMIItemIndex, intWMIPropertyIndex
	 Dim objWMIServices 
         Dim strWMIClass, objWMIClass
         Dim strWMIProvider, boolDynamic 
         Dim objWMIInstance, objWMIInstances
         Dim varValue
         Dim intCount, intLoggingLevel
         Dim strMOF 

         On Error Resume Next

         If Len (strOperationDescription) > 0 Then
            WriteToLogFile objLOGFileHandle, strOperationDescription, cLoggingLevel0, False
         End If

	 For intIndex = 0 To UBound (arrayWMITestList) Step 5
             WriteToLogFile objLOGFileHandle, "Opening WMI namespace '" & arrayWMITestList (intIndex) & "'.", cLoggingLevel3, False
             Set objWMIServices = objWMILocator.ConnectServer("LocalHost", arrayWMITestList (intIndex), "", "")
             If Err.Number Then
                If CBool (arrayWMITestList (intIndex + 1)) = True Then 
                   CheckWMIFeatures = ErrorHandler (objLOGFileHandle, "CheckWMIFeatures", "", False, Err)
                   TrackingData.WMIConnectionErrors = AddTrackingData (TrackingData.WMIConnectionErrors, arrayWMITestList (intIndex) & ";" & strLastError)
                Else
                   WriteToLogFile objLOGFileHandle, "WMI namespace '" & arrayWMITestList (intIndex) & "' not found, but it is not required to be present. Skipping.", cLoggingLevel2, False
                End If
             Else
                If IsArray (arrayWMITestList (intIndex + 2)) = True Then
                   WriteToLogFile objLOGFileHandle, "WMI GET operations for '" & arrayWMITestList (intIndex) & "'.", cLoggingLevel3, False 

                   For intWMIItemIndex = 0 To UBound (arrayWMITestList (intIndex + 2)) Step 2

                       If boolStrict = True Then arrayWMITestList (intIndex + 2)(intWMIItemIndex) = cCritical
                       If arrayWMITestList (intIndex + 2)(intWMIItemIndex) = cCritical Or arrayWMITestList (intIndex + 2)(intWMIItemIndex) = cPresence Then 
                          intLoggingLevel = cLoggingLevel1
                       Else
                          intLoggingLevel = cLoggingLevel2
                       End If 

                       WriteToLogFile objLOGFileHandle, "Retrieving '" & arrayWMITestList (intIndex + 2)(intWMIItemIndex + 1) & "' WMI Class static information.", cLoggingLevel3, False
   
                       Set objWMIClass = objWMIServices.Get (arrayWMITestList (intIndex + 2)(intWMIItemIndex + 1))
                       If Err.Number Then
                          CheckWMIFeatures = ErrorHandler (objLOGFileHandle, "CheckWMIFeatures", "", False, Err)
                          TrackingData.WMIGetErrors = AddTrackingData (TrackingData.WMIGetErrors, arrayWMITestList (intIndex) & ";" & arrayWMITestList (intIndex + 2)(intWMIItemIndex + 1) & ";" & strLastError)
                       Else
                          strMOF = objWMIClass.GetObjectText_
                          If Err.Number Then
                             CheckWMIFeatures = ErrorHandler (objLOGFileHandle, "CheckWMIFeatures", "", False, Err)
                             TrackingData.FailingMOFRepresentation = AddTrackingData (TrackingData.FailingMOFRepresentation, arrayWMITestList (intIndex) & ";" & (arrayWMITestList (intIndex + 2)(intWMIItemIndex + 1)) & ";" & strLastError)
                          End If 

                          If arrayWMITestList (intIndex + 2)(intWMIItemIndex) = cPresence Then
                             WriteToLogFile objLOGFileHandle, "No WMI ENUMERATION operations requested from '" & arrayWMITestList (intIndex) & "' for WMI class '" & arrayWMITestList (intIndex + 2)(intWMIItemIndex + 1) & "'.", cLoggingLevel3, False 
                          Else
                             WriteToLogFile objLOGFileHandle, "WMI ENUMERATION operations for '" & arrayWMITestList (intIndex) & "'.", cLoggingLevel3, False 
                             strWMIProvider = GetQualifier (objLOGFileHandle, objWMIClass, "Provider", "@NULL@", arrayWMITestList (intIndex), arrayWMITestList (intIndex + 2)(intWMIItemIndex + 1))
                             boolDynamic = GetQualifier (objLOGFileHandle, objWMIClass, "Dynamic", False, arrayWMITestList (intIndex), arrayWMITestList (intIndex + 2)(intWMIItemIndex + 1))

                             If (_
                                 Instr (UCase (TrackingData.MissingWMIProviderFile), UCase (arrayWMITestList (intIndex) & ";" & strWMIProvider)) = 0 And _
                                 Instr (UCase (TrackingData.WMIProviderDCOMRegistrations), UCase (arrayWMITestList (intIndex) & ";" & strWMIProvider)) = 0 And _
                                 Instr (UCase (TrackingData.WMIProviderCIMRegistrations), UCase (arrayWMITestList (intIndex) & ";" & strWMIProvider)) = 0 And _
                                 Instr (UCase (TrackingData.DecoupledWMIProvider), UCase (arrayWMITestList (intIndex) & ";" & strWMIProvider)) = 0 _
                                ) Then 
                                WriteToLogFile objLOGFileHandle, "Retrieving instance(s) of WMI class '" & (arrayWMITestList (intIndex + 2)(intWMIItemIndex + 1)) & "'.", cLoggingLevel3, False

                                Set objWMIInstances = objWMIServices.InstancesOf (arrayWMITestList (intIndex + 2)(intWMIItemIndex + 1), wbemQueryFlagShallow)
                                If Err.Number Then
                                   CheckWMIFeatures = ErrorHandler (objLOGFileHandle, "CheckWMIFeatures", "", False, Err)
                                   TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, arrayWMITestList (intIndex) & ";InstancesOf;" & arrayWMITestList (intIndex + 2)(intWMIItemIndex + 1) & ";" & cCritical & ";" & strLastError)
                                Else
                                   intCount = objWMIInstances.Count 
                                   If Err.Number Then
                                      CheckWMIFeatures = ErrorHandler (objLOGFileHandle, "CheckWMIFeatures", "", False, Err)
                                      TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, arrayWMITestList (intIndex) & ";InstancesOf;" & arrayWMITestList (intIndex + 2)(intWMIItemIndex + 1) & ";" & cCritical & ";" & strLastError)
                                   Else
                                      If intCount = 0 Then
                                         WriteToLogFile objLOGFileHandle, "No instance returned from WMI class '" & (arrayWMITestList (intIndex + 2)(intWMIItemIndex + 1)) & "', while at least 1 instance is expected.", intLoggingLevel, False
                                         TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, arrayWMITestList (intIndex) & ";InstancesOf;" & arrayWMITestList (intIndex + 2)(intWMIItemIndex + 1) & ";" & arrayWMITestList (intIndex + 2)(intWMIItemIndex) & ";NOINSTANCE")
                                         CheckWMIFeatures = True
                                      Else
                                         WriteToLogFile objLOGFileHandle, intCount & " instance(s) found.", cLoggingLevel3, False
                                      End If
                                   End If
                                End If

                                Set objWMIInstances = Nothing
                             Else
                                WriteToLogFile objLOGFileHandle, "Skipping WMI ENUMERATION operations from '" & arrayWMITestList (intIndex) & "' for WMI class '" & arrayWMITestList (intIndex + 2)(intWMIItemIndex + 1) & "' because registration issues have been previously reported for the '" & strWMIProvider & "' WMI provider.", cLoggingLevel2, False 
                                TrackingData.WMIEnumerationSkipped = AddTrackingData (TrackingData.WMIEnumerationSkipped, arrayWMITestList (intIndex) & ";" & strWMIProvider & ";InstancesOf;" & arrayWMITestList (intIndex + 2)(intWMIItemIndex + 1))
                             End If
                          End If

                       End If

                       Set objWMIClass = Nothing
                   Next
                Else
                   WriteToLogFile objLOGFileHandle, "No WMI ENUMERATIONS operations available for '" & arrayWMITestList (intIndex) & "'.", cLoggingLevel3, False 
                End If 

                If IsArray (arrayWMITestList (intIndex + 3)) = True Then
                   WriteToLogFile objLOGFileHandle, "WMI EXECQUERY operations for '" & arrayWMITestList (intIndex) & "'.", cLoggingLevel3, False 

                   For intWMIItemIndex = 0 To UBound (arrayWMITestList (intIndex + 3)) Step 2

                       If boolStrict = True Then arrayWMITestList (intIndex + 3)(intWMIItemIndex) = cCritical
                       If arrayWMITestList (intIndex + 3)(intWMIItemIndex) = cCritical Then 
                          intLoggingLevel = cLoggingLevel1
                       Else
                          intLoggingLevel = cLoggingLevel2
                       End If 

                       strWMIClass = ExtractWMIClassFromWQL (objLOGFileHandle, arrayWMITestList (intIndex + 3)(intWMIItemIndex + 1))
                       If Not IsNull (strWMIClass) Then
                          Set objWMIClass = objWMIServices.Get (strWMIClass)
                          If Err.Number Then
                             CheckWMIFeatures = ErrorHandler (objLOGFileHandle, "CheckWMIFeatures", "", False, Err)
                             TrackingData.WMIGetErrors = AddTrackingData (TrackingData.WMIGetErrors, arrayWMITestList (intIndex) & ";" & strWMIClass & ";" & strLastError)
                          Else
                             strWMIProvider = GetQualifier (objLOGFileHandle, objWMIClass, "Provider", "@NULL@", arrayWMITestList (intIndex), strWMIClass)
                             boolDynamic = GetQualifier (objLOGFileHandle, objWMIClass, "Dynamic", False, arrayWMITestList (intIndex), strWMIClass)

                             If (_
                                 Instr (UCase (TrackingData.MissingWMIProviderFile), UCase (arrayWMITestList (intIndex) & ";" & strWMIProvider)) = 0 And _
                                 Instr (UCase (TrackingData.WMIProviderDCOMRegistrations), UCase (arrayWMITestList (intIndex) & ";" & strWMIProvider)) = 0 And _
                                 Instr (UCase (TrackingData.WMIProviderCIMRegistrations), UCase (arrayWMITestList (intIndex) & ";" & strWMIProvider)) = 0 And _
                                 Instr (UCase (TrackingData.DecoupledWMIProvider), UCase (arrayWMITestList (intIndex) & ";" & strWMIProvider)) = 0 _
                                ) Then 
                                WriteToLogFile objLOGFileHandle, "Executing WQL query '" & (arrayWMITestList (intIndex + 3)(intWMIItemIndex + 1)) & "'.", cLoggingLevel3, False
   
                                Set objWMIInstances = objWMIServices.ExecQuery (arrayWMITestList (intIndex + 3)(intWMIItemIndex + 1))
                                If Err.Number Then
                                   CheckWMIFeatures = ErrorHandler (objLOGFileHandle, "CheckWMIFeatures", "", False, Err)
                                   TrackingData.WMIExecQueryErrors = AddTrackingData (TrackingData.WMIExecQueryErrors, arrayWMITestList (intIndex) & ";" & arrayWMITestList (intIndex + 3)(intWMIItemIndex + 1) & ";" & cCritical & ";" & strLastError)
                                Else
                                   intCount = objWMIInstances.Count 
                                   If Err.Number Then
                                      CheckWMIFeatures = ErrorHandler (objLOGFileHandle, "CheckWMIFeatures", "", False, Err)
                                      TrackingData.WMIExecQueryErrors = AddTrackingData (TrackingData.WMIExecQueryErrors, arrayWMITestList (intIndex) & ";" & arrayWMITestList (intIndex + 3)(intWMIItemIndex + 1) & ";" & cCritical & ";" & strLastError)
                                   Else
                                      If intCount = 0 Then
                                         If arrayWMITestList (intIndex + 3)(intWMIItemIndex) = cIWarning Then
                                            WriteToLogFile objLOGFileHandle, "0 instance(s) found, BUT this is expected.", cLoggingLevel3, False
                                         Else
                                            WriteToLogFile objLOGFileHandle, "No instance returned from the WQL query '" & arrayWMITestList (intIndex + 3)(intWMIItemIndex + 1) & "', while at least 1 instance is expected.", intLoggingLevel, False
                                            TrackingData.WMIExecQueryErrors = AddTrackingData (TrackingData.WMIExecQueryErrors, arrayWMITestList (intIndex) & ";" & arrayWMITestList (intIndex + 3)(intWMIItemIndex + 1) & ";" & arrayWMITestList (intIndex + 3)(intWMIItemIndex) & ";NOINSTANCE")
                                            CheckWMIFeatures = True
                                         End If
                                      Else
                                         If arrayWMITestList (intIndex + 3)(intWMIItemIndex) = cIWarning Then
                                            WriteToLogFile objLOGFileHandle, intCount & " instance(s) returned from the WQL query '" & arrayWMITestList (intIndex + 3)(intWMIItemIndex + 1) & "', while NO instance is expected.", intLoggingLevel, False
                                            TrackingData.WMIExecQueryErrors = AddTrackingData (TrackingData.WMIExecQueryErrors, arrayWMITestList (intIndex) & ";" & arrayWMITestList (intIndex + 3)(intWMIItemIndex + 1) & ";" & arrayWMITestList (intIndex + 3)(intWMIItemIndex) & ";INSTANCE")
                                            CheckWMIFeatures = True
                                         Else
                                            WriteToLogFile objLOGFileHandle, intCount & " instance(s) found, BUT this is expected.", cLoggingLevel3, False
                                         End If
                                      End If
                                      Set objWMIInstances = Nothing
                                   End If
                                End If
                             Else
                                WriteToLogFile objLOGFileHandle, "Skipping WMI EXECQUERY operations from '" & arrayWMITestList (intIndex) & "' for WMI class '" & strWMIClass & "' because registration issues have been previously reported for the '" & strWMIProvider & "' WMI provider.", cLoggingLevel2, False 
                                TrackingData.WMIExecQuerySkipped = AddTrackingData (TrackingData.WMIExecQuerySkipped, arrayWMITestList (intIndex) & ";" & strWMIProvider & ";" & arrayWMITestList (intIndex + 3)(intWMIItemIndex + 1) & ";" & strWMIClass)
                             End If
                          End If   

                          Set objWMIClass = Nothing
                       End If
                   Next
                Else
                   WriteToLogFile objLOGFileHandle, "No WMI EXECQUERY operations available for '" & arrayWMITestList (intIndex) & "'.", cLoggingLevel3, False 
                End If 

                If IsArray (arrayWMITestList (intIndex + 4)) = True Then
                   WriteToLogFile objLOGFileHandle, "WMI GET VALUE operations for '" & arrayWMITestList (intIndex) & "'.", cLoggingLevel3, False 

                   For intWMIItemIndex = 0 To UBound (arrayWMITestList (intIndex + 4)) Step 4

                       If boolStrict = True Then arrayWMITestList (intIndex + 4)(intWMIItemIndex) = cCritical
                       If arrayWMITestList (intIndex + 4)(intWMIItemIndex) = cCritical Then 
                          intLoggingLevel = cLoggingLevel1
                       Else
                          intLoggingLevel = cLoggingLevel2
                       End If 

                       Set objWMIClass = objWMIServices.Get (arrayWMITestList (intIndex + 4)(intWMIItemIndex + 1))
                       If Err.Number Then
                          CheckWMIFeatures = ErrorHandler (objLOGFileHandle, "CheckWMIFeatures", "", False, Err)
                          TrackingData.WMIGetErrors = AddTrackingData (TrackingData.WMIGetErrors, arrayWMITestList (intIndex) & ";" & arrayWMITestList (intIndex + 4)(intWMIItemIndex + 1) & "=" & arrayWMITestList (intIndex + 4)(intWMIItemIndex + 2) & ";" & strLastError)
                       Else
                          strWMIProvider = GetQualifier (objLOGFileHandle, objWMIClass, "Provider", "@NULL@", arrayWMITestList (intIndex), arrayWMITestList (intIndex + 4)(intWMIItemIndex + 1))
                          boolDynamic = GetQualifier (objLOGFileHandle, objWMIClass, "Dynamic", False, arrayWMITestList (intIndex), arrayWMITestList (intIndex + 4)(intWMIItemIndex + 1))

                          If (_
                              Instr (UCase (TrackingData.MissingWMIProviderFile), UCase (arrayWMITestList (intIndex) & ";" & strWMIProvider)) = 0 And _
                              Instr (UCase (TrackingData.WMIProviderDCOMRegistrations), UCase (arrayWMITestList (intIndex) & ";" & strWMIProvider)) = 0 And _
                              Instr (UCase (TrackingData.WMIProviderCIMRegistrations), UCase (arrayWMITestList (intIndex) & ";" & strWMIProvider)) = 0 And _
                              Instr (UCase (TrackingData.DecoupledWMIProvider), UCase (arrayWMITestList (intIndex) & ";" & strWMIProvider)) = 0 _
                             ) Then 
                             WriteToLogFile objLOGFileHandle, "Retrieving instance '" & (arrayWMITestList (intIndex + 4)(intWMIItemIndex + 1)) & "=" & arrayWMITestList (intIndex + 4)(intWMIItemIndex + 2) & "'.", cLoggingLevel3, False
                             Set objWMIInstance = objWMIServices.Get (arrayWMITestList (intIndex + 4)(intWMIItemIndex + 1) & "=" & arrayWMITestList (intIndex + 4)(intWMIItemIndex + 2))
                             If Err.Number Then
                                CheckWMIFeatures = ErrorHandler (objLOGFileHandle, "CheckWMIFeatures", "", False, Err)
                                TrackingData.WMIGetErrors = AddTrackingData (TrackingData.WMIGetErrors, arrayWMITestList (intIndex) & ";" & arrayWMITestList (intIndex + 4)(intWMIItemIndex + 1) & "=" & arrayWMITestList (intIndex + 4)(intWMIItemIndex + 2) & ";" & strLastError)
                             Else
                                For intWMIPropertyIndex = 0 To UBound (arrayWMITestList (intIndex + 4)(intWMIItemIndex + 3)) Step 2
                                    WriteToLogFile objLOGFileHandle, "Retrieving value '" & arrayWMITestList (intIndex + 4)(intWMIItemIndex + 3)(intWMIPropertyIndex) & "' property value.", cLoggingLevel3, False
                                    varValue = objWMIInstance.Properties_.Item (arrayWMITestList (intIndex + 4)(intWMIItemIndex + 3)(intWMIPropertyIndex))
                                    If arrayWMITestList (intIndex + 4)(intWMIItemIndex + 3)(intWMIPropertyIndex + 1) = varValue Then
                                       WriteToLogFile objLOGFileHandle, "'" & arrayWMITestList (intIndex + 4)(intWMIItemIndex + 3)(intWMIPropertyIndex) & "' property value is CORRECT. ('" & arrayWMITestList (intIndex + 4)(intWMIItemIndex + 3)(intWMIPropertyIndex + 1) & "')", cLoggingLevel3, False
                                    Else
                                       WriteToLogFile objLOGFileHandle, "'" & arrayWMITestList (intIndex + 4)(intWMIItemIndex + 3)(intWMIPropertyIndex) & "' property value of instance " & arrayWMITestList (intIndex + 4)(intWMIItemIndex + 1) & "=" & arrayWMITestList (intIndex + 4)(intWMIItemIndex + 2) & " is INCORRECT.", intLoggingLevel, False
                                       WriteToLogFile objLOGFileHandle, "The current value is '" & varValue & "', while the default value is '" & arrayWMITestList (intIndex + 4)(intWMIItemIndex + 3)(intWMIPropertyIndex + 1) & "'", intLoggingLevel, False 
                                       TrackingData.WMIGetValuePropertyErrors = AddTrackingData (TrackingData.WMIGetValuePropertyErrors, arrayWMITestList (intIndex) & ";" & arrayWMITestList (intIndex + 4)(intWMIItemIndex + 1) & "=" & arrayWMITestList (intIndex + 4)(intWMIItemIndex + 2) & ";" & arrayWMITestList (intIndex + 4)(intWMIItemIndex + 3)(intWMIPropertyIndex) & ";" & varValue & ";" & arrayWMITestList (intIndex + 4)(intWMIItemIndex + 3)(intWMIPropertyIndex + 1) & ";" & arrayWMITestList (intIndex + 4)(intWMIItemIndex))
                                    End If 
                                Next
                             End If
                          Else
                             WriteToLogFile objLOGFileHandle, "Skipping WMI GET VALUE operations from '" & arrayWMITestList (intIndex) & "' for WMI class '" & arrayWMITestList (intIndex + 4)(intWMIItemIndex + 1) & "' because registration issues have been previously reported for the '" & strWMIProvider & "' WMI provider.", cLoggingLevel2, False 
                             TrackingData.WMIGetValuePropertySkipped = AddTrackingData (TrackingData.WMIGetValuePropertySkipped, arrayWMITestList (intIndex) & ";" & strWMIProvider & ";" & arrayWMITestList (intIndex + 4)(intWMIItemIndex + 1) & "=" & arrayWMITestList (intIndex + 4)(intWMIItemIndex + 2))
                          End If
                       End If

                       Set objWMIClass = Nothing
                   Next
                Else
                   WriteToLogFile objLOGFileHandle, "No WMI GET VALUE operations available for '" & arrayWMITestList (intIndex) & "'.", cLoggingLevel3, False 
                End If

                Set objWMIServices = Nothing       
             End If
         Next

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckWMIInventory (ByVal objLOGFileHandle)

         Dim objWMIServices
         Dim strWMIClass, objWMIClass, strWMIProvider 
 
         On Error Resume Next
 
         WriteToLogFile objLOGFileHandle, "Collecting system information.", cLoggingLevel0, False
 
         Set objWMIServices = objWMILocator.ConnectServer("LocalHost", "Root\CIMv2", "", "")
         If Err.Number Then 
            CheckWMIInventory = ErrorHandler (objLOGFileHandle, "CheckWMIInventory", "", False, Err)
            TrackingData.WMIConnectionErrors = AddTrackingData (TrackingData.WMIConnectionErrors, strWMINameSpace & ";" & strLastError)
            Exit Function
         End If
 
         If (_
             Instr (UCase (TrackingData.MissingWMIProviderFile), "ROOT/CIMV2;CIMWIN32") = 0 And _
             Instr (UCase (TrackingData.WMIProviderDCOMRegistrations), "ROOT/CIMV2;CIMWIN32") = 0 And _
             Instr (UCase (TrackingData.WMIProviderCIMRegistrations), "ROOT/CIMV2;CIMWIN32") = 0 And _
             Instr (UCase (TrackingData.DecoupledWMIProvider), "ROOT/CIMV2;CIMWIN32") = 0 _
            ) Then
            CheckWMIInventory = CheckDiskInventory (objLOGFileHandle, objWMIServices)          
            If RunTimeEnvironmentInfo.OSIdentifier >= cWindowsXPRTM Then
               CheckWMIInventory = CheckNetworkInventory (objLOGFileHandle, objWMIServices)
            End If
            CheckWMIInventory = CheckIRQInventory (objLOGFileHandle, objWMIServices)
            CheckWMIInventory = CheckDMAInventory (objLOGFileHandle, objWMIServices)
            CheckWMIInventory = CheckMemoryInventory (objLOGFileHandle, objWMIServices)
            CheckWMIInventory = CheckProcessorInventory (objLOGFileHandle, objWMIServices)
            CheckWMIInventory = CheckOSInventory (objLOGFileHandle, objWMIServices)
            CheckWMIInventory = CheckServicesInventory (objLOGFileHandle, objWMIServices)
            CheckWMIInventory = CheckWbemFilesInventory (objLOGFileHandle, objWMIServices)
         Else
            WriteToLogFile objLOGFileHandle, "Skipping WMI inventory from 'Root/CIMv2' because registration issues have been previously reported for the 'CIMWin32' WMI provider.", cLoggingLevel2, False 
            TrackingData.WMIDiskData = AddTrackingData (TrackingData.WMIDiskData, "CIMWIN32_SKIPPED;;;;")
         End If

         If (_
             Instr (UCase (TrackingData.MissingWMIProviderFile), "ROOT/CIMV2;MS_NT_EVENTLOG_PROVIDER") = 0 And _
             Instr (UCase (TrackingData.WMIProviderDCOMRegistrations), "ROOT/CIMV2;MS_NT_EVENTLOG_PROVIDER") = 0 And _
             Instr (UCase (TrackingData.WMIProviderCIMRegistrations), "ROOT/CIMV2;MS_NT_EVENTLOG_PROVIDER") = 0 And _
             Instr (UCase (TrackingData.DecoupledWMIProvider), "ROOT/CIMV2;MS_NT_EVENTLOG_PROVIDER") = 0 _
            ) Then
            CheckWMIInventory = CheckEventLogEVentsInventory (objLOGFileHandle, objWMIServices)
            CheckWMIInventory = CheckSuspiciousReboot (objLOGFileHandle, objWMIServices)
         Else
            WriteToLogFile objLOGFileHandle, "Skipping WMI inventory from 'Root/CIMv2' because registration issues have been previously reported for the 'MS_NT_EVENTLOG_PROVIDER' WMI provider.", cLoggingLevel2, False 
            TrackingData.WMIEventLogEventData = AddTrackingData (TrackingData.WMIEventLogEventData, "NTEVENTLOG_SKIPPED")
         End If
 
         Set objWMIServices = Nothing

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckDiskInventory (ByVal objLOGFileHandle, ByVal objWMIServices)

        Dim objWMIInstance, objWMIInstances
        Dim objWMIAssoc1Instance, objWMIAssoc1Instances
        Dim objWMIAssoc2Instance, objWMIAssoc2Instances
        Dim intCount1, intCount2, intCount3

        On Error Resume Next

        ' --------------------------------------------------------------------------------------------------------
        WriteToLogFile objLOGFileHandle, "- Disk information ", cLoggingLevel0, False

        Set objWMIInstances = objWMIServices.InstancesOf ("Win32_DiskDrive")
        If Err.Number Then
           CheckDiskInventory = ErrorHandler (objLOGFileHandle, "CheckDiskInventory", "", False, Err)
           TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;Win32_Processor;" & cCritical & ";" & strLastError)
           Exit Function
        End If

        intCount1 = objWMIInstances.Count
        If Err.Number Then
           CheckDiskInventory = ErrorHandler (objLOGFileHandle, "CheckDiskInventory", "", False, Err)
           TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;Win32_Processor;" & cCritical & ";" & strLastError)
           Exit Function
        End If

        If intCount1 Then
           intCount1 = 0
           For Each objWMIInstance In objWMIInstances
               intCount1 = intCount1 + 1
               DisplayFormattedWMIProperties objLOGFileHandle, objWMIInstance, intCount1, 0, cLoggingLevel3
      
               Set objWMIAssoc1Instances = objWMIServices.ExecQuery ("Associators of {Win32_DiskDrive='" & _
                                                                    objWMIInstance.DeviceID & _
                                                                    "'} Where AssocClass=Win32_DiskDriveToDiskPartition")
               If Err.Number Then
                  CheckDiskInventory = ErrorHandler (objLOGFileHandle, "CheckDiskInventory", "", False, Err)
                  TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;Win32_DiskDriveToDiskPartition;" & cCritical & ";" & strLastError)
               End If
       
               intCount2 = objWMIAssoc1Instances.Count
               If Err.Number Then
                  CheckDiskInventory = ErrorHandler (objLOGFileHandle, "CheckDiskInventory", "", False, Err)
                  TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;Win32_DiskDriveToDiskPartition;" & cCritical & ";" & strLastError)
               End If
        
               If intCount2 Then
                  intCount2 = 0
                  For Each objWMIAssoc1Instance In objWMIAssoc1Instances
                      intCount2 = intCount2 + 1
                      DisplayFormattedWMIProperties objLOGFileHandle, objWMIAssoc1Instance, intCount2, 2, cLoggingLevel3

                      Set objWMIAssoc2Instances = objWMIServices.ExecQuery ("Associators of {Win32_DiskPartition='" & _
                                                                            objWMIAssoc1Instance.DeviceID & _
                                                                            "'} Where AssocClass=Win32_LogicalDiskToPartition")
                      If Err.Number Then
                         CheckDiskInventory = ErrorHandler (objLOGFileHandle, "CheckDiskInventory", "", False, Err)
                         TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;Win32_LogicalDiskToPartition;" & cCritical & ";" & strLastError)
                      End If
             
                      intCount3 = objWMIAssoc2Instances.Count
                      If Err.Number Then
                         CheckDiskInventory = ErrorHandler (objLOGFileHandle, "CheckDiskInventory", "", False, Err)
                         TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;Win32_LogicalDiskToPartition;" & cCritical & ";" & strLastError)
                      End If
         
                      If intCount3 Then
                         intCount3 = 0
                         For Each objWMIAssoc2Instance In objWMIAssoc2Instances
                             intCount3 = intCount3 + 1
                             DisplayFormattedWMIProperties objLOGFileHandle, objWMIAssoc2Instance, intCount3, 4, cLoggingLevel3

                             If UCase (objWMIAssoc2Instance.Name) = ReplaceString (RunTimeEnvironmentInfo.SystemDrive , "\", "") Then
                                TrackingData.WMIDiskData = AddTrackingData (TrackingData.WMIDiskData, ";" & objWMIInstance.InterfaceType & ";" & objWMIInstance.Model & ";" & objWMIAssoc1Instance.Name & ";" & objWMIAssoc2Instance.Name)
                             End If
                         Next
                      Else
                         WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False
                         WriteToLogFile objLOGFileHandle, "No Win32_LogicalDisk information available.", cLoggingLevel1, False
                      End If  
                  Next
               Else
                  WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False
                  WriteToLogFile objLOGFileHandle, "No Win32_DiskPartition information available.", cLoggingLevel1, False
               End If 

               WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False
           Next
        Else
           WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False
           WriteToLogFile objLOGFileHandle, "No Win32_DiskDrive information available.", cLoggingLevel1, False
           WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False
        End If 

        Set objWMIAssoc2Instances = Nothing
        Set objWMIAssoc1Instances = Nothing
        Set objWMIInstances = Nothing

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckProcessorInventory (ByVal objLOGFileHandle, ByVal objWMIServices)

        Dim objWMIInstance, objWMIInstances
        Dim intCount

        On Error Resume Next

        ' --------------------------------------------------------------------------------------------------------
        WriteToLogFile objLOGFileHandle, "- Processor information ", cLoggingLevel0, False

        Set objWMIInstances = objWMIServices.InstancesOf ("Win32_Processor")
        If Err.Number Then
           CheckProcessorInventory = ErrorHandler (objLOGFileHandle, "CheckProcessorInventory", "", False, Err)
           TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;Win32_Processor;" & cCritical & ";" & strLastError)
           Exit Function
        End If

        intCount = objWMIInstances.Count
        If Err.Number Then
           CheckProcessorInventory = ErrorHandler (objLOGFileHandle, "CheckProcessorInventory", "", False, Err)
           TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;Win32_Processor;" & cCritical & ";" & strLastError)
           Exit Function
        End If

        If intCount Then
           intCount = 0
           For Each objWMIInstance In objWMIInstances
               intCount = intCount + 1
               DisplayFormattedWMIProperties objLOGFileHandle, objWMIInstance, intCount, 0, cLoggingLevel3
           Next
        Else
           WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False
           WriteToLogFile objLOGFileHandle, "No Win32_Processor information available.", cLoggingLevel1, False
        End If 

        WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False

        Set objWMIInstances = Nothing

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckMemoryInventory (ByVal objLOGFileHandle, ByVal objWMIServices)

        Dim objWMIInstance, objWMIInstances
        Dim intCount

        On Error Resume Next

        ' --------------------------------------------------------------------------------------------------------
        WriteToLogFile objLOGFileHandle, "- Memory information ", cLoggingLevel0, False

        Set objWMIInstances = objWMIServices.InstancesOf ("Win32_PhysicalMemory")
        If Err.Number Then
           CheckMemoryInventory = ErrorHandler (objLOGFileHandle, "CheckMemoryInventory", "", False, Err)
           TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;Win32_PhysicalMemory;" & cCritical & ";" & strLastError)
           Exit Function
        End If

        intCount = objWMIInstances.Count
        If Err.Number Then
           CheckMemoryInventory = ErrorHandler (objLOGFileHandle, "CheckMemoryInventory", "", False, Err)
           TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;Win32_PhysicalMemory;" & cCritical & ";" & strLastError)
           Exit Function
        End If

        If intCount Then
           For Each objWMIInstance In objWMIInstances
               If (objWMIInstance.Capacity - 1024^2) < 0 Then
                  WriteToLogFile objLOGFileHandle, _
                                 "'" & objWMIInstance.BankLabel & "' is " & _
                                 objWMIInstance.Capacity / (1024) & " KB chip size (" & _
                                 objWMIInstance.DeviceLocator & ").", cLoggingLevel3, False
               Else 
                  WriteToLogFile objLOGFileHandle, _
                                 "'" & objWMIInstance.BankLabel & "' is " & _
                                 objWMIInstance.Capacity / (1024^2) & " MB chip size (" & _
                                 objWMIInstance.DeviceLocator & ").", cLoggingLevel3, False
               End If 
           Next
        Else
           WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False
           WriteToLogFile objLOGFileHandle, "No Win32_PhysicalMemory information available.", cLoggingLevel1, False
        End If 

        WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False

        Set objWMIInstances = Nothing

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckDMAInventory (ByVal objLOGFileHandle, ByVal objWMIServices)

        Dim objWMIInstance, objWMIInstances
        Dim objWMIAssoc1Instance, objWMIAssoc1Instances
        Dim objWMIAssoc2Instance, objWMIAssoc2Instances
        Dim intCount

        On Error Resume Next
    
        ' --------------------------------------------------------------------------------------------------------
        WriteToLogFile objLOGFileHandle, "- DMA resource usage ", cLoggingLevel0, False

        Set objWMIInstances = objWMIServices.InstancesOf ("Win32_DMAChannel")
        If Err.Number Then
           CheckDMAInventory = ErrorHandler (objLOGFileHandle, "CheckDMAInventory", "", False, Err)
           TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;Win32_DMAChannel;" & cCritical & ";" & strLastError)
           Exit Function
        End If

        intCount = objWMIInstances.Count
        If Err.Number Then
           CheckDMAInventory = ErrorHandler (objLOGFileHandle, "CheckDMAInventory", "", False, Err)
           TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;Win32_DMAChannel;" & cCritical & ";" & strLastError)
           Exit Function
        End If

        If intCount Then
           For Each objWMIInstance In objWMIInstances
               Set objWMIAssoc1Instances = objWMIServices.ExecQuery _
                                          ("Associators of {Win32_DMAChannel='" & _
                                          objWMIInstance.DMAChannel & _
                                          "'} Where AssocClass=Win32_PNPAllocatedResource")
    
               If objWMIAssoc1Instances.Count Then
                  WriteToLogFile objLOGFileHandle, objWMIInstance.Caption, cLoggingLevel3, False
                  For Each objWMIAssoc1Instance In objWMIAssoc1Instances
                      If Len (objWMIAssoc1Instance.Service) > 0 Then
                         WriteToLogFile objLOGFileHandle, "  " & Trim (objWMIAssoc1Instance.Name) & ".", cLoggingLevel3, False
                         WriteToLogFile objLOGFileHandle, "     Service name is '" & UCase (objWMIAssoc1Instance.Service) & _
                                                          "' and status is " & objWMIAssoc1Instance.Status & ".", cLoggingLevel3, False
    
                         Set objWMIAssoc2Instances = objWMIServices.ExecQuery _
                                          ("Associators of {Win32_PnPEntity='" & _
                                          objWMIAssoc1Instance.DeviceID & _
                                          "'} Where ResultClass=Win32_PortResource " & _
                                          "AssocClass=Win32_PNPAllocatedResource")
    
                         For Each objWMIAssoc2Instance In objWMIAssoc2Instances
                             WriteToLogFile objLOGFileHandle, "     Address range is " & objWMIAssoc2Instance.Name, cLoggingLevel3, False
                         Next
    
                      Else
                         WriteToLogFile objLOGFileHandle, "  " & objWMIAssoc1Instance.Name & ".", cLoggingLevel3, False
                      End If 
                  Next
               End If 
           Next
        Else
           WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False
           WriteToLogFile objLOGFileHandle, "No Win32_DMAChannel information available.", cLoggingLevel1, False
        End If 

        WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False

        Set objWMIAssoc2Instances = Nothing
        Set objWMIAssoc1Instances = Nothing
        Set objWMIInstances = Nothing

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckIRQInventory (ByVal objLOGFileHandle, ByVal objWMIServices)

        Dim objWMIInstance, objWMIInstances
        Dim objWMIAssoc1Instance, objWMIAssoc1Instances
        Dim objWMIAssoc2Instance, objWMIAssoc2Instances
        Dim intCount

        On Error Resume Next

        ' --------------------------------------------------------------------------------------------------------
        WriteToLogFile objLOGFileHandle, "- IRQ resource usage ", cLoggingLevel0, False

        Set objWMIInstances = objWMIServices.InstancesOf ("Win32_IRQResource")
        If Err.Number Then
           CheckIRQInventory  = ErrorHandler (objLOGFileHandle, "CheckIRQInventory", "", False, Err)
           TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;Win32_IRQResource;" & cCritical & ";" & strLastError)
           Exit Function
        End If

        intCount = objWMIInstances.Count
        If Err.Number Then
           CheckIRQInventory  = ErrorHandler (objLOGFileHandle, "CheckIRQInventory", "", False, Err)
           TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;Win32_IRQResource;" & cCritical & ";" & strLastError)
           Exit Function
        End If

        If intCount Then
           For Each objWMIInstance In objWMIInstances
               Set objWMIAssoc1Instances = objWMIServices.ExecQuery _
                                          ("Associators of {Win32_IRQResource='" & _
                                          objWMIInstance.IRQNumber & _
                                          "'} Where AssocClass=Win32_PNPAllocatedResource")
               If objWMIAssoc1Instances.Count Then
                  WriteToLogFile objLOGFileHandle, objWMIInstance.Caption, cLoggingLevel3, False
                  For Each objWMIAssoc1Instance In objWMIAssoc1Instances
                      If Len (objWMIAssoc1Instance.Service) > 0 Then
                         WriteToLogFile objLOGFileHandle, "  " & Trim (objWMIAssoc1Instance.Name) & ".", cLoggingLevel3, False
                         WriteToLogFile objLOGFileHandle, "     Service name is '" & UCase (objWMIAssoc1Instance.Service) & _
                                      "' and status is " & objWMIAssoc1Instance.Status & ".", cLoggingLevel3, False
    
                         Set objWMIAssoc2Instances = objWMIServices.ExecQuery _
                                          ("Associators of {Win32_PnPEntity='" & _
                                          objWMIAssoc1Instance.DeviceID & _
                                          "'} Where ResultClass=Win32_PortResource " & _
                                          "AssocClass=Win32_PNPAllocatedResource")
    
                         For Each objWMIAssoc2Instance In objWMIAssoc2Instances
                             WriteToLogFile objLOGFileHandle, "     Address range is " & objWMIAssoc2Instance.Name, cLoggingLevel3, False
                         Next
    
                      Else
                         WriteToLogFile objLOGFileHandle, "  " & objWMIAssoc1Instance.Name & ".", cLoggingLevel3, False
                      End If 
                  Next
               End If 
           Next
        Else
           WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False
           WriteToLogFile objLOGFileHandle, "No Win32_IRQResource information available.", cLoggingLevel1, False
        End If 

        WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False

        Set objWMIAssoc2Instances = Nothing
        Set objWMIAssoc1Instances = Nothing
        Set objWMIInstances = Nothing

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckNetworkInventory (ByVal objLOGFileHandle, ByVal objWMIServices)

        Dim objWMIInstance, objWMIInstances
        Dim intCount

        On Error Resume Next

        ' --------------------------------------------------------------------------------------------------------
        WriteToLogFile objLOGFileHandle, "- Network information", cLoggingLevel0, False
        Set objWMIInstances = objWMIServices.InstancesOf ("Win32_NetworkAdapter")
        If Err.Number Then
           CheckNetworkInventory = ErrorHandler (objLOGFileHandle, "CheckNetworkInventory", "", False, Err)
           TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;Win32_NetworkAdapter;" & cCritical & ";" & strLastError)
           Exit Function
        End If

        intCount = objWMIInstances.Count
        If Err.Number Then
           CheckNetworkInventory = ErrorHandler (objLOGFileHandle, "CheckNetworkInventory", "", False, Err)
           TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;Win32_NetworkAdapter;" & cCritical & ";" & strLastError)
           Exit Function
        End If

        If intCount Then
           intCount = 0
           For Each objWMIInstance in objWMIInstances
               intCount = intCount + 1
               WriteToLogFile objLOGFileHandle, "- " & objWMIInstance.Path_.Class & " #" & Left (intCount & " ---", 4) & _
                                                String (100 - Len (objWMIInstance.Path_.Class), "-"), cLoggingLevel3, False

               DisplayFormattedWMIProperty objLOGFileHandle, _
                                           objWMIInstance, _
                                           "Adapter name", _
                                           "Name", _
                                           Null, _
                                           cLoggingLevel3
               DisplayFormattedWMIProperty objLOGFileHandle, _
                                           objWMIInstance, _
                                           "Device availability", _
                                           "Availability", _
                                           Null, _
                                           cLoggingLevel3
               If objWMIInstance.NetConnectionStatus = 0 Then
                  DisplayFormattedWMIProperty objLOGFileHandle, _
                                              objWMIInstance, _
                                              "Adapter state", _
                                              "DISABLED", _
                                              Null, _
                                              cLoggingLevel3
               Else
                  DisplayFormattedWMIProperty objLOGFileHandle, _
                                              objWMIInstance, _
                                              "Adapter type", _
                                              "AdapterType", _
                                              Null, _
                                              cLoggingLevel3
                  DisplayFormattedWMIProperty objLOGFileHandle, _
                                              objWMIInstance, _
                                              "Adapter state", _
                                              "NetConnectionStatus", _
                                              Null, _
                                              cLoggingLevel3
                  DisplayFormattedWMIProperty objLOGFileHandle, _
                                              objWMIInstance, _
                                              "MAC address is ", _
                                              "MACAddress", _
                                              Null, _
                                              cLoggingLevel3
               End If

               DisplayFormattedWMIProperty objLOGFileHandle, _
                                           objWMIInstance, _
                                           "Adapter service name", _
                                           "ServiceName", _
                                           Null, _
                                           cLoggingLevel3
               DisplayFormattedWMIProperty objLOGFileHandle, _
                                           objWMIInstance, _
                                           "Last reset", _
                                           "TimeOfLastReset", _
                                           Null, _
                                           cLoggingLevel3

               Set objWMIInstance = objWMIServices.Get ("Win32_NetworkAdapterConfiguration=" & objWMIInstance.Index)
               If Err.Number Then
                  CheckNetworkInventory  = ErrorHandler (objLOGFileHandle, "CheckNetworkInventory", "", False, Err)
                  TrackingData.WMIGetErrors = AddTrackingData (TrackingData.WMIGetErrors, strWMINameSpace & ";Win32_NetworkAdapterConfiguration;" & strLastError)
               End If
       
               If objWMIInstance.IPEnabled Then
                  ' DHCP -----------------------------------------------------------------------
                   DisplayFormattedWMIProperty objLOGFileHandle, _
                                               objWMIInstance, _
                                               "DHCP enabled", _
                                               "DHCPEnabled", _
                                               Null, _
                                            cLoggingLevel3
                   If objWMIInstance.DHCPEnabled Then
                      DisplayFormattedWMIProperty objLOGFileHandle, _
                                                  objWMIInstance, _
                                                  "DHCP expires", _
                                                  "DHCPLeaseExpires", _
                                                  Null, _
                                                  cLoggingLevel3
                      DisplayFormattedWMIProperty objLOGFileHandle, _
                                                  objWMIInstance, _
                                                  "DHCP obtained", _
                                                  "DHCPLeaseObtained", _
                                                  Null, _
                                                  cLoggingLevel3
                      DisplayFormattedWMIProperty objLOGFileHandle, _
                                                  objWMIInstance, _
                                                  "DHCP server", _
                                                  "DHCPServer", _
                                                  Null, _
                                                  cLoggingLevel3
                   End If

                   ' IP Addresses ---------------------------------------------------------------
                   DisplayFormattedWMIProperty objLOGFileHandle, _
                                               objWMIInstance, _
                                               "IP address(es)", _
                                               "IPAddress", _
                                               "IPSubnet", _
                                               cLoggingLevel3
                   DisplayFormattedWMIProperty objLOGFileHandle, _
                                               objWMIInstance, _
                                               "IP connection metric", _
                                               "IPConnectionMetric", _
                                               Null, _
                                               cLoggingLevel3
                   DisplayFormattedWMIProperty objLOGFileHandle, _
                                               objWMIInstance, _
                                               "Default Gateway(s) and metric", _
                                               "DefaultIPGateway", _
                                               "GatewayCostMetric", _
                                               cLoggingLevel3
                   DisplayFormattedWMIProperty objLOGFileHandle, _
                                               objWMIInstance, _
                                               "Dead gateway detection enabled", _
                                               "DeadGWDetectEnabled", _
                                               Null, _
                                               cLoggingLevel3

                   ' DNS -----------------------------------------------------------------------
                   DisplayFormattedWMIProperty objLOGFileHandle, _
                                               objWMIInstance, _
                                               "DNS registration enabled", _
                                               "DomainDNSRegistrationEnabled", _
                                               Null, _
                                               cLoggingLevel3
                   DisplayFormattedWMIProperty objLOGFileHandle, _
                                               objWMIInstance, _
                                               "DNS FULL registration enabled", _
                                               "FullDNSRegistrationEnabled", _
                                               Null, _
                                               cLoggingLevel3
                   DisplayFormattedWMIProperty objLOGFileHandle, _
                                               objWMIInstance, _
                                               "DNS search order", _
                                               "DNSServerSearchOrder", _
                                               Null, _
                                               cLoggingLevel3
                   DisplayFormattedWMIProperty objLOGFileHandle, _
                                               objWMIInstance, _
                                               "DNS domain", _
                                               "DNSDomain", _
                                               Null, _
                                               cLoggingLevel3
                   DisplayFormattedWMIProperty objLOGFileHandle, _
                                               objWMIInstance, _
                                               "DNS domain suffix search order", _
                                               "DNSDomainSuffixSearchOrder", _
                                               Null, _
                                               cLoggingLevel3
                   DisplayFormattedWMIProperty objLOGFileHandle, _
                                               objWMIInstance, _
                                               "DNS enabled for WINS resolution", _
                                               "DNSEnabledForWINSResolution", _
                                               Null, _
                                               cLoggingLevel3
   
                   ' WINS -----------------------------------------------------------------------
                   DisplayFormattedWMIProperty objLOGFileHandle, _
                                               objWMIInstance, _
                                               "Primary WINS Server", _
                                               "WINSPrimaryServer", _
                                               Null, _
                                               cLoggingLevel3
                   DisplayFormattedWMIProperty objLOGFileHandle, _
                                               objWMIInstance, _
                                               "Secondary WINS Server", _
                                               "WINSSecondaryServer", _
                                               Null, _
                                               cLoggingLevel3
                   DisplayFormattedWMIProperty objLOGFileHandle, _
                                               objWMIInstance, _
                                               "WINS scope ID", _
                                               "WINSScopeID", _
                                               Null, _
                                               cLoggingLevel3
                   DisplayFormattedWMIProperty objLOGFileHandle, _
                                               objWMIInstance, _
                                               "Enable LMHOSTS lookup", _
                                               "WINSEnableLMHostsLookup", _
                                               Null, _
                                               cLoggingLevel3

                   Select Case objWMIInstance.TcpipNetbiosOptions
                          Case 0
                               DisplayFormattedWMIProperty objLOGFileHandle, _
                                                           objWMIInstance, _
                                                           "NETBIOS over TCP/IP", _
                                                           "by DHCP", _
                                                           Null, _
                                                           cLoggingLevel3
                          Case 1
                               DisplayFormattedWMIProperty objLOGFileHandle, _
                                                           objWMIInstance, _
                                                           "NETBIOS over TCP/IP", _
                                                           "ENABLED", _
                                                           Null, _
                                                           cLoggingLevel3
                          Case 2
                               DisplayFormattedWMIProperty objLOGFileHandle, _
                                                           objWMIInstance, _
                                                           "NETBIOS over TCP/IP", _
                                                           "DISABLED", _
                                                           Null, _
                                                           cLoggingLevel3
                   End Select

                   ' IP Security ----------------------------------------------------------------
                   If objWMIInstance.IPFilterSecurityEnabled Then
                      DisplayFormattedWMIProperty objLOGFileHandle, _
                                                  objWMIInstance, _
                                                  "IP filtering security enabled", _
                                                  "ENABLED", _
                                                  Null, _
                                                  cLoggingLevel3
                      DisplayFormattedWMIProperty objLOGFileHandle, _
                                                  objWMIInstance, _
                                                  "IP port security enabled", _
                                                  "IPPortSecurityEnabled" , _
                                                  Null, _
                                                  cLoggingLevel3
                      DisplayFormattedWMIProperty objLOGFileHandle, _
                                                  objWMIInstance, _
                                                  "IP permitted protocols", _
                                                  "IPSecPermitIPProtocols", _
                                                  Null, _
                                                  cLoggingLevel3
                      DisplayFormattedWMIProperty objLOGFileHandle, _
                                                  objWMIInstance, _
                                                  "TCP ports allowed", _
                                                  "IPSecPermitTCPPorts", _
                                                  Null, _
                                                  cLoggingLevel3
                      DisplayFormattedWMIProperty objLOGFileHandle, _
                                                  objWMIInstance, _
                                                  "UDP ports allowed", _
                                                  "IPSecPermitUDPPorts", _
                                                  Null, _
                                                  cLoggingLevel3
                   End If
               Else
                   DisplayFormattedWMIProperty objLOGFileHandle, _
                                               objWMIInstance, _
                                               "IP status", _
                                               "DISABLED", _
                                               Null, _
                                               cLoggingLevel3
               End If
               Set objWMIInstance = Nothing
           Next
        Else
           WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False
           WriteToLogFile objLOGFileHandle, "No Win32_NetworkAdapter information available.", cLoggingLevel1, False
        End If 

        WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False

        Set objWMIInstances = Nothing

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckOSInventory (ByVal objLOGFileHandle, ByVal objWMIServices)

        Dim objWMIInstance, objWMIInstances
        Dim objWMIProperty, objWMIProperties
        Dim intCount

        On Error Resume Next

        ' --------------------------------------------------------------------------------------------------------
        WriteToLogFile objLOGFileHandle, "- Operating System information ", cLoggingLevel0, False

        Set objWMIInstances = objWMIServices.InstancesOf ("Win32_ComputerSystem")
        If Err.Number Then
           CheckOSInventory = ErrorHandler (objLOGFileHandle, "CheckOSInventory", "", False, Err)
           TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;Win32_ComputerSystem;" & cCritical & ";" & strLastError)
        End If

        intCount = objWMIInstances.Count
        If Err.Number Then
           CheckOSInventory = ErrorHandler (objLOGFileHandle, "CheckOSInventory", "", False, Err)
           TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;Win32_ComputerSystem;" & cCritical & ";" & strLastError)
        End If

        If intCount Then
           For Each objWMIInstance in objWMIInstances
               Set objWMIProperties = objWMIInstance.Properties_
               For Each objWMIProperty In objWMIProperties
                   Select Case objWMIProperty.Name
                          Case "OEMLogoBitmap"

                          Case Else
                               DisplayFormattedWMIProperty objLOGFileHandle, _
                                                           objWMIInstance, _
                                                           objWMIProperty.Name, _
                                                           objWMIProperty.Name, _
                                                           Null, _
                                                           cLoggingLevel3
                   End Select
               Next
               Set objWMIProperties = Nothing
           Next
        Else
           WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False
           WriteToLogFile objLOGFileHandle, "No Win32_ComputerSystem information available.", cLoggingLevel1, False
        End If 

        WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False

        Set objWMIInstances = objWMIServices.InstancesOf ("Win32_OperatingSystem")
        If Err.Number Then
           CheckOSInventory = ErrorHandler (objLOGFileHandle, "CheckOSInventory", "", False, Err)
           TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;Win32_OperatingSystem;" & cCritical & ";" & strLastError)
        End If

        intCount = objWMIInstances.Count
        If Err.Number Then
           CheckOSInventory = ErrorHandler (objLOGFileHandle, "CheckOSInventory", "", False, Err)
           TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;Win32_OperatingSystem;" & cCritical & ";" & strLastError)
        End If

        If intCount Then
           intCount = 0
           For Each objWMIInstance in objWMIInstances
               intCount = intCount + 1
               DisplayFormattedWMIProperties objLOGFileHandle, objWMIInstance, intCount, 0, cLoggingLevel3
           Next
        Else
           WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False
           WriteToLogFile objLOGFileHandle, "No Win32_OperatingSystem information available.", cLoggingLevel1, False
        End If 

        WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False

        Set objWMIInstances = objWMIServices.InstancesOf ("Win32_OSRecoveryConfiguration")
        If Err.Number Then
           CheckOSInventory = ErrorHandler (objLOGFileHandle, "CheckOSInventory", "", False, Err)
           TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;Win32_OSRecoveryConfiguration;" & cCritical & ";" & strLastError)
        End If

        intCount = objWMIInstances.Count
        If Err.Number Then
           CheckOSInventory = ErrorHandler (objLOGFileHandle, "CheckOSInventory", "", False, Err)
           TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;Win32_OSRecoveryConfiguration;" & cCritical & ";" & strLastError)
        End If

        If intCount Then
           intCount = 0
           For Each objWMIInstance in objWMIInstances
               intCount = intCount + 1
               DisplayFormattedWMIProperties objLOGFileHandle, objWMIInstance, intCount, 0, cLoggingLevel3
           Next
        Else
           WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False
           WriteToLogFile objLOGFileHandle, "No Win32_OSRecoveryConfiguration information available.", cLoggingLevel1, False
        End If 

        WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False
    
        Set objWMIInstances = objWMIServices.InstancesOf ("Win32_QuickFixEngineering")
        If Err.Number Then
           CheckOSInventory = ErrorHandler (objLOGFileHandle, "CheckOSInventory", "", False, Err)
           TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;Win32_QuickFixEngineering;" & cCritical & ";" & strLastError)
        End If

        intCount = objWMIInstances.Count
        If Err.Number Then
           CheckOSInventory = ErrorHandler (objLOGFileHandle, "CheckOSInventory", "", False, Err)
           TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;Win32_QuickFixEngineering;" & cCritical & ";" & strLastError)
        End If

        If intCount Then
           intCount = 0
           For Each objWMIInstance in objWMIInstances
               intCount = intCount + 1
               DisplayFormattedWMIProperties objLOGFileHandle, objWMIInstance, intCount, 0, cLoggingLevel3
           Next
        Else
           WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False
           WriteToLogFile objLOGFileHandle, "No Win32_QuickFixEngineering information available.", cLoggingLevel1, False
        End If 

        WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False
 
        Set objWMIInstances = Nothing

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckServicesInventory (ByVal objLOGFileHandle, ByVal objWMIServices)

        Dim objWMIInstance, objWMIInstances
        Dim objWMIProperty, objWMIProperties
        Dim intCount

        On Error Resume Next

        ' --------------------------------------------------------------------------------------------------------
        WriteToLogFile objLOGFileHandle, "- Services information ", cLoggingLevel0, False

        Set objWMIInstances = objWMIServices.InstancesOf ("Win32_Service")
        If Err.Number Then
           CheckServicesInventory = ErrorHandler (objLOGFileHandle, "CheckServicesInventory", "", False, Err)
           TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;Win32_Service;" & cCritical & ";" & strLastError)
        End If

        intCount = objWMIInstances.Count
        If Err.Number Then
           CheckServicesInventory = ErrorHandler (objLOGFileHandle, "CheckServicesInventory", "", False, Err)
           TrackingData.WMIEnumerationErrors = AddTrackingData (TrackingData.WMIEnumerationErrors, strWMINameSpace & ";InstancesOf;Win32_Service;" & cCritical & ";" & strLastError)
        End If

        If intCount Then
           For Each objWMIInstance in objWMIInstances
               If Len (objWMIInstance.Description) <= 80 Then
                  WriteToLogFile objLOGFileHandle, Left (objWMIInstance.Name & Space (30), 30) & _
                                                   " " & Right (Space (7) & objWMIInstance.State, 7) & _
                                                   " " & Right (Space (8) & objWMIInstance.StartMode, 8) & _
                                                   " " & objWMIInstance.Description, _
                                                   cLoggingLevel3, False
               Else
                  WriteToLogFile objLOGFileHandle, Left (objWMIInstance.Name & Space (30), 30) & _
                                                   " " & Right (Space (7) & objWMIInstance.State, 7) & _
                                                   " " & Right (Space (8) & objWMIInstance.StartMode, 8) & _
                                                   " " & Left (objWMIInstance.Description, 80) & ">...", _
                                                   cLoggingLevel3, False
               End If
           Next
        Else
           WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False
           WriteToLogFile objLOGFileHandle, "No Win32_Service information available.", cLoggingLevel1, False
        End If

        WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False

        Set objWMIInstances = Nothing

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckWBEMFilesInventory (ByVal objLOGFileHandle, ByVal objWMIServices)

         Dim objWMIInstance, objWMIInstances
         Dim objWMIProperty, objWMIProperties
         Dim intCount, strWQLQuery

         On Error Resume Next

         ' --------------------------------------------------------------------------------------------------------
         WriteToLogFile objLOGFileHandle, "- WMI Binary files information", cLoggingLevel0, False
 
         strWQLQuery = "Select * From CIM_DataFile Where Drive='" & ReplaceChar (RunTimeEnvironmentInfo.SystemDrive, "\", "") & "' And Path='" & ReplaceChar (Mid (RunTimeEnvironmentInfo.WBem, 3), "\", "\\") & "' And (Extension='DLL' Or Extension='EXE')"
 
         WriteToLogFile objLOGFileHandle, "  WQL Query: '" & strWQLQuery & "'", cLoggingDebug Or cLoggingLevel4, False
         WriteToLogFile objLOGFileHandle, "", cLoggingDebug Or cLoggingLevel4, False
 
         Set objWMIInstances = objWMIServices.ExecQuery (strWQLQuery)
         If Err.Number Then
            CheckWBEMFilesInventory = ErrorHandler (objLOGFileHandle, "CheckWBEMFilesInventory", "", False, Err)
            TrackingData.WMIExecQueryErrors = AddTrackingData (TrackingData.WMIExecQueryErrors, strWMINamespace & ";" & strWQLQuery & ";" & cCritical & ";" & strLastError)
         End If

         intCount = objWMIInstances.Count
         If Err.Number Then
            CheckWBEMFilesInventory = ErrorHandler (objLOGFileHandle, "CheckWBEMFilesInventory", "", False, Err)
            TrackingData.WMIExecQueryErrors = AddTrackingData (TrackingData.WMIExecQueryErrors, strWMINamespace & ";" & strWQLQuery & ";" & cCritical & ";" & strLastError)
         End If

         If intCount Then
            For Each objWMIInstance in objWMIInstances
                WriteToLogFile objLOGFileHandle, Left (UCase (objWMIInstance.FileName & "." & objWMIInstance.Extension) & Space (28), 28) & _
                                                 " " & Right (Space (10) & objWMIInstance.FileSize, 10) & _
                                                 " - " & Left (objWMIInstance.Manufacturer & Space (25), 25) & _
                                                 " - " & objWMIInstance.Version, _
                                                 cLoggingLevel3, False
            Next
         Else
            WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False
            WriteToLogFile objLOGFileHandle, "No CIM_DataFile information available.", cLoggingLevel1, False
         End If

         WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False
 
         Set objWMIInstances = Nothing

End Function

' ---------------------------------------------------------------------------------------------------------
Function CheckEventLogEVentsInventory (ByVal objLOGFileHandle, ByVal objWMIServices)

         Dim strDate, strDMTFDateTime, strDMTFStartDateTime, longLogLineCounter, longEventLogEventCounter
         Dim arrayEventLogQueries, intIndex

         On Error Resume Next

         ' --------------------------------------------------------------------------------------------------------
         WriteToLogFile objLOGFileHandle, "- NT Event Log information ", cLoggingLevel0, False

         strDate = strStartDate - intOldestEVENTLogHistory
         strDMTFDateTime = ConvertDateTimeToDMTFDateTime (objLOGFileHandle, strDate, strStartTime)
         strDMTFStartDateTime = ConvertDateTimeToDMTFDateTime (objLOGFileHandle, strStartDate, strStartTime)

         WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False

         longLogLineCounter = WriteToLogFile (objLOGFileHandle, "Querying event log to locate events older than " & intOldestEVENTLogHistory & " day(s) since " & FormatDateTime (strDate, vbLongDate) & " at " & FormatDateTime (strStartTime, vbShortTime) & ".", cLoggingLevel3, False)
         WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False

         arrayEventLogQueries = array ("SYSTEM", "DCOM", _
                                              "SELECT * FROM Win32_NTLogEvent Where SourceName=" & Chr(34) & "DCOM" & Chr(34) & " And LogFile=" & Chr(34) & "System" & Chr(34) & " And (EventType=1 Or EventType=2) And TimeGenerated>=" & Chr(34) & strDMTFDateTime & Chr(34) & " And TimeGenerated<" & Chr(34) & strDMTFStartDateTime & Chr(34), _
                                       "SYSTEM", "WINMGMT", _
                                              "SELECT * FROM Win32_NTLogEvent Where SourceName=" & Chr(34) & "WINMGMT" & Chr(34) & " And LogFile=" & Chr(34) & "Application" & Chr(34) & " And (EventType=1 Or EventType=2) And TimeGenerated>=" & Chr(34) & strDMTFDateTime & Chr(34) & " And TimeGenerated<" & Chr(34) & strDMTFStartDateTime & Chr(34), _
                                       "SYSTEM", "WMIADAPTER", _
                                              "SELECT * FROM Win32_NTLogEvent Where SourceName=" & Chr(34) & "WMIADAPTER" & Chr(34) & " And LogFile=" & Chr(34) & "Application" & Chr(34) & " And (EventType=1 Or EventType=2) And TimeGenerated>=" & Chr(34) & strDMTFDateTime & Chr(34) & " And TimeGenerated<" & Chr(34) & strDMTFStartDateTime & Chr(34) _
                                      )
                  
         For intIndex = 0 To UBound (arrayEventLogQueries) Step 3
             boolRC = WQLQuery (objLOGFileHandle, objWMIServices, arrayEventLogQueries (intIndex + 1), arrayEventLogQueries (intIndex + 2), longEventLogEventCounter)
             If boolRC = True Then
                TrackingData.WMIEventLogEventData = AddTrackingData (TrackingData.WMIEventLogEventData, "SYSTEMERROR;" & arrayEventLogQueries (intIndex + 1) & ";" & longLogLineCounter & ";" & longEventLogEventCounter)
             Else
                TrackingData.WMIEventLogEventData = AddTrackingData (TrackingData.WMIEventLogEventData, arrayEventLogQueries (intIndex) & ";" & arrayEventLogQueries (intIndex + 1) & ";" & longLogLineCounter & ";" & longEventLogEventCounter)
             End If
         Next

         longLogLineCounter = WriteToLogFile (objLOGFileHandle, "Querying event log to locate events created during the execution of WMIDiag since " & FormatDateTime (strStartDate, vbLongDate) & " at " & FormatDateTime (strStartTime, vbShortTime) & ".", cLoggingLevel3, False)
         WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False

         arrayEventLogQueries = array ("WMIDIAG", "DCOM", _
                                              "SELECT * FROM Win32_NTLogEvent Where SourceName=" & Chr(34) & "DCOM" & Chr(34) & " And LogFile=" & Chr(34) & "System" & Chr(34) & " And (EventType=1 Or EventType=2) And TimeGenerated>=" & Chr(34) & strDMTFStartDateTime & Chr(34), _
                                       "WMIDIAG", "WINMGMT", _
                                              "SELECT * FROM Win32_NTLogEvent Where SourceName=" & Chr(34) & "WINMGMT" & Chr(34) & " And LogFile=" & Chr(34) & "Application" & Chr(34) & " And (EventType=1 Or EventType=2) And TimeGenerated>=" & Chr(34) & strDMTFStartDateTime & Chr(34), _
                                       "WMIDIAG", "WMIADAPTER", _
                                              "SELECT * FROM Win32_NTLogEvent Where SourceName=" & Chr(34) & "WMIADAPTER" & Chr(34) & " And LogFile=" & Chr(34) & "Application" & Chr(34) & " And (EventType=1 Or EventType=2) And TimeGenerated>=" & Chr(34) & strDMTFStartDateTime & Chr(34) _
                                      )
         
         For intIndex = 0 To UBound (arrayEventLogQueries) Step 3
             boolRC = WQLQuery (objLOGFileHandle, objWMIServices, arrayEventLogQueries (intIndex + 1), arrayEventLogQueries (intIndex + 2), longEventLogEventCounter)
             If boolRC = True Then
                TrackingData.WMIEventLogEventData = AddTrackingData (TrackingData.WMIEventLogEventData, "WMIDIAGERROR;" & arrayEventLogQueries (intIndex + 1) & ";" & longLogLineCounter & ";" & longEventLogEventCounter)
             Else
                TrackingData.WMIEventLogEventData = AddTrackingData (TrackingData.WMIEventLogEventData, arrayEventLogQueries (intIndex) & ";" & arrayEventLogQueries (intIndex + 1) & ";" & longLogLineCounter & ";" & longEventLogEventCounter)
             End If
         Next

End Function 

' ---------------------------------------------------------------------------------------------------------
Function WQLQuery (ByVal objLOGFileHandle, ByVal objWMIServices, ByVal strEventSource, ByVal strWQLQuery, ByRef longEventLogEventCounter)

         Dim objWMIInstance, objWMIInstances, intCount
         Dim strEventDate, strEventTime, strEventGMT

         On Error Resume Next

         Set objWMIInstances = objWMIServices.ExecQuery (strWQLQuery)
         If Err.Number Then
            WriteToLogFile objLOGFileHandle, "  WQL Query: '" & strWQLQuery & "'", cLoggingLevel4, False
            WriteToLogFile objLOGFileHandle, "", cLoggingLevel4, False

            WQLQuery = ErrorHandler (objLOGFileHandle, "WQLQuery ", "", False, Err)
            TrackingData.WMIExecQueryErrors = AddTrackingData (TrackingData.WMIExecQueryErrors, strWMINamespace & ";" & strWQLQuery & ";" & cCritical & ";" & strLastError)
            Exit Function 
         End If

         intCount = objWMIInstances.Count
         If Err.Number Then
            WriteToLogFile objLOGFileHandle, "  WQL Query: '" & strWQLQuery & "'", cLoggingLevel4, False
            WriteToLogFile objLOGFileHandle, "", cLoggingLevel4, False

            WQLQuery = ErrorHandler (objLOGFileHandle, "WQLQuery", "", False, Err)
            TrackingData.WMIExecQueryErrors = AddTrackingData (TrackingData.WMIExecQueryErrors, strWMINamespace & ";" & strWQLQuery & ";" & cCritical & ";" & strLastError)
            Exit Function 
         End If

         If intCount > 0 Then   
            WriteToLogFile objLOGFileHandle, "  " & Right ("000" & objWMIInstances.Count, 3) & " " & strEventSource & " event(s):", cLoggingLevel3, False
         Else
            WriteToLogFile objLOGFileHandle, "  ZERO " & strEventSource & " event.", cLoggingLevel3, False
         End If

         WriteToLogFile objLOGFileHandle, "  WQL Query: '" & strWQLQuery & "'", cLoggingDebug Or cLoggingLevel4, False
         WriteToLogFile objLOGFileHandle, "", cLoggingLevel4, False

         If intCount > 0 Then   
            For Each objWMIInstance In objWMIInstances 
                WriteToLogFile objLOGFileHandle, "    #" & Right ("000000" & objWMIInstance.RecordNumber, 6) & ": " & UCase (objWMIInstance.SourceName) & " (" & Right ("00000" & objWMIInstance.EventCode, 5) & ") - " & _
                               UCase (Mid (objWMIInstance.Type, 1, 1)) & LCase (Mid (objWMIInstance.Type, 2)) & " - " & _
                               ConvertDMTFDateTimeToLongDateTime (objLOGFileHandle, objWMIInstance.TimeGenerated, strEventDate, strEventTime, strEventGMT, False), _
                               cLoggingLevel3, False  
                arrayWriteToLogFile objLOGFileHandle, Space (13), SplitStringInArrayBySpace (CleanString (objWMIInstance.Message, 32, 255), 70), cLoggingLevel3, False
            Next 
            WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False
         End If

         longEventLogEventCounter = intCount

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckSuspiciousReboot (ByVal objLOGFileHandle, ByVal objWMIServices)

         Dim objWMIInstance, objWMIInstances, intCount, strWQLQuery
         Dim strDate, strDMTFDateTime, strEventDate, strEventTime, strEventGMT
         Dim arrayEventEntries, intIndex1, intIndex2, boolEventFound, intEventIDToCatch, intInvalidShutdownCounter

         On Error Resume Next

         ' --------------------------------------------------------------------------------------------------------

         WriteToLogFile objLOGFileHandle, "Querying event log to locate startup/shutdown event(s).", cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "", cLoggingLevel3, False

         strWQLQuery = cWQLStartStop

         WriteToLogFile objLOGFileHandle, "  WQL Query: '" & strWQLQuery & "'", cLoggingDebug Or cLoggingLevel4, False
         WriteToLogFile objLOGFileHandle, "", cLoggingDebug Or cLoggingLevel4, False

         Set objWMIInstances = objWMIServices.ExecQuery (strWQLQuery)
         If Err.Number Then
            WriteToLogFile objLOGFileHandle, "  WQL Query: '" & strWQLQuery & "'", cLoggingLevel4, False
            WriteToLogFile objLOGFileHandle, "", cLoggingLevel4, False

            WQLQuery = ErrorHandler (objLOGFileHandle, "WQLQuery ", "", False, Err)
            TrackingData.WMIExecQueryErrors = AddTrackingData (TrackingData.WMIExecQueryErrors, strWMINamespace & ";" & strWQLQuery & ";" & cCritical & ";" & strLastError)
            Exit Function 
         End If

         intCount = objWMIInstances.Count
         If Err.Number Then
            WriteToLogFile objLOGFileHandle, "  WQL Query: '" & strWQLQuery & "'", cLoggingLevel4, False
            WriteToLogFile objLOGFileHandle, "", cLoggingLevel4, False

            WQLQuery = ErrorHandler (objLOGFileHandle, "WQLQuery", "", False, Err)
            TrackingData.WMIExecQueryErrors = AddTrackingData (TrackingData.WMIExecQueryErrors, strWMINamespace & ";" & strWQLQuery & ";" & cCritical & ";" & strLastError)
            Exit Function 
         End If

         If intCount > 0 Then   
            WriteToLogFile objLOGFileHandle, "  " & objWMIInstances.Count & " Startup/Shutdown event(s) found!", cLoggingLevel3, False
         Else
            WriteToLogFile objLOGFileHandle, "  ZERO Startup/Shutdown event(s) found!", cLoggingLevel3, False
         End If

         If intCount > 0 Then
            WriteToLogFile objLOGFileHandle, "", cLoggingDebug Or cLoggingLevel4, False

            intIndex1 = 0
            ReDim arrayEventEntries (intCount)

            For Each objWMIInstance In objWMIInstances
                Set arrayEventEntries(intIndex1) = new EventLogEntry 
                arrayEventEntries(intIndex1).RecordNumber = objWMIInstance.RecordNumber
                arrayEventEntries(intIndex1).EventCode = CInt (objWMIInstance.EventCode)
                arrayEventEntries(intIndex1).TimeGenerated = objWMIInstance.TimeGenerated 

                WriteToLogFile objLOGFileHandle, " " & FindEventName (arrayEventEntries(intIndex1).EventCode) & "on " & ConvertDMTFDateTimeToLongDateTime (objLOGFileHandle, arrayEventEntries(intIndex1).TimeGenerated, strEventDate, strEventTime, strEventGMT, False) & ".", cLoggingDebug Or cLoggingLevel4, False
                intIndex1 = intIndex1 + 1
            Next 
            WriteToLogFile objLOGFileHandle, "", cLoggingDebug Or cLoggingLevel4, False

            boolEventFound = False 
            intInvalidShutdownCounter = 0
            intEventIDToCatch = cSystemStart

            intIndex1 = UBound (arrayEventEntries) - 1
            intEventIDToCatch = GetNextEventToCatch (objLOGFileHandle, arrayEventEntries(intIndex1).EventCode)

            Do
                 If intIndex1 > 0 Then
                    intIndex2 = intIndex1 - 1
                    If arrayEventEntries(intIndex2).EventCode = intEventIDToCatch Then 
                       WriteToLogFile objLOGFileHandle, "Found" & FindEventName (arrayEventEntries(intIndex2).EventCode) & "event (" & ConvertDMTFDateTimeToLongDateTime (objLOGFileHandle, arrayEventEntries(intIndex2).TimeGenerated, strEventDate, strEventTime, strEventGMT, False) & ").", cLoggingDebug Or cLoggingLevel4, False
                       boolEventFound = True
                    Else
                       WriteToLogFile objLOGFileHandle, "Found" & FindEventName (arrayEventEntries(intIndex2).EventCode) & "event instead!", cLoggingDebug Or cLoggingLevel4, False
                       WriteToLogFile objLOGFileHandle, "Incorrect system" & FindEventName (intEventIDToCatch) & "on " & ConvertDMTFDateTimeToLongDateTime (objLOGFileHandle, arrayEventEntries(intIndex2).TimeGenerated, strEventDate, strEventTime, strEventGMT, False) & ".", cLoggingLevel2, False
                       TrackingData.InvalidShutdown = AddTrackingData (TrackingData.InvalidShutdown, FindEventName (intEventIDToCatch) & "on " & ConvertDMTFDateTimeToLongDateTime (objLOGFileHandle, arrayEventEntries(intIndex2).TimeGenerated, strEventDate, strEventTime, strEventGMT, False))
                       intInvalidShutdownCounter = intInvalidShutdownCounter + 1
                       boolEventFound = False
                    End If
            
                    intIndex1 = intIndex1 - 1 
                    intEventIDToCatch = GetNextEventToCatch (objLOGFileHandle, arrayEventEntries(intIndex1).EventCode) 
                 End If 
            Loop While intIndex1 >= 1
         End If

         If intEventIDToCatch = cSystemStart Then
            WriteToLogFile objLOGFileHandle, "Startup event missing!", cLoggingLevel1, False
         End If

         WriteToLogFile objLOGFileHandle, "", cLoggingLevel4, False

         If intInvalidShutdownCounter > 0 Then
            WriteToLogFile objLOGFileHandle, intInvalidShutdownCounter & " incorrect system shutdown(s) found!", cLoggingLevel2, False
            TrackingData.Environment = AddTrackingData (TrackingData.Environment, "SHUTDOWN;" & intInvalidShutdownCounter)
         Else
            WriteToLogFile objLOGFileHandle, "No incorrect system shutdown found.", cLoggingLevel3, False
         End If 

End Function

' --------------------------------------------------------------------------------------------------------
Function GetNextEventToCatch (ByVal objLOGFileHandle, ByVal intEventCode)

         On Error Resume Next

         If CInt (intEventCode) = cSystemStart Then 
            GetNextEventToCatch = cSystemStop
            WriteToLogFile objLOGFileHandle, "Searching for shutdown event ...", cLoggingDebug Or cLoggingLevel4, False
         End If 
         If CInt (intEventCode) = cSystemStop Then 
            GetNextEventToCatch = cSystemStart
            WriteToLogFile objLOGFileHandle, "Searching for startup event ...", cLoggingDebug Or cLoggingLevel4, False
         End If 

End Function 

' --------------------------------------------------------------------------------------------------------
Function FindEventName (ByVal intEventCode)

         On Error Resume Next

         If CInt (intEventCode) = cSystemStart Then 
            FindEventName = " Startup " 
         End If 

         If CInt (intEventCode) = cSystemStop Then 
            FindEventName = " Shutdown " 
         End If 

End Function 

' --------------------------------------------------------------------------------------------------------
Function GetQualifier (ByVal objLOGFileHandle, ByVal objWMIObject, ByVal strQualifierName, ByVal varQualifierDefaultValue, ByVal strWMINameSpace, ByVal strWMIObject)

         Dim varQualifierValue

         On Error Resume Next

         varQualifierValue = varQualifierDefaultValue
         varQualifierValue = objWMIObject.Qualifiers_.Item (strQualifierName)

         If Err.Number Then
            If Err.Number = WBEM_E_NOT_FOUND Then
               Err.Clear
            Else
               ErrorHandler objLOGFileHandle, "GetQualifier", "", False, Err
               TrackingData.QualifierAccessError = AddTrackingData (TrackingData.QualifierAccessError, strWMINameSpace & ";" & strWMIObject & ";" & strLastError)
            End If

            varQualifierValue = varQualifierDefaultValue
         End If
         GetQualifier = varQualifierValue

End Function

' --------------------------------------------------------------------------------------------------------
Function AddTrackingData (ByVal TrackingData, ByVal strText)

         On Error Resume Next

         strText = ReplaceString (strText, ",", " ")
         strText = CleanString (strText, 32, 255)

         If Len (TrackingData) = 0 Then
            TrackingData = strText
         Else
           TrackingData = TrackingData & "," & strText
         End If

         AddTrackingData = TrackingData 

End Function

' --------------------------------------------------------------------------------------------------------
Function AnalyzeDiagnostic (ByVal objFileHandle, ByVal boolDump)

         Dim boolRC

         On Error Resume Next

         boolWMISystemError = False 

         intDefaultLoggingLevel = cLoggingLevel2 ' Ensure warnings and errors are echoed.

         WriteToLogFile objFileHandle, "", cLoggingLevel0, False
         WriteToLogFile objFileHandle, String (130, "-"), cLoggingLevel0, False
         WriteToLogFile objFileHandle, "----------------------------------------------------- WMI REPORT: BEGIN ----------------------------------------------------------", cLoggingLevel0, False
         WriteToLogFile objFileHandle, String (130, "-"), cLoggingLevel0, False
         WriteToLogFile objFileHandle, "", cLoggingLevel0, False

         WriteToLogFile objFileHandle, String (130, "-"), cLoggingLevel0, False
         WriteToLogFile objFileHandle, RunTimeEnvironmentInfo.ProductFullName & " (" & RunTimeEnvironmentInfo.NTBuild & ") - User '" & RunTimeEnvironmentInfo.DomainName & "\" & RunTimeEnvironmentInfo.UserName & "' on computer '" & RunTimeEnvironmentInfo.LocalComputerName & "'.", cLoggingLevel0, False

         If intWMICriticalityLevel < 4 Then
            AnalyzeEnvironment objFileHandle, boolDump
            AnalyzeWMIFiles objFileHandle, boolDump
            AnalyzeFirewallStatus objFileHandle, boolDump
            AnalyzeInvalidDCOMSetup objFileHandle, boolDump
            AnalyzeInvalidWMIServiceSetup objFileHandle, boolDump
            AnalyzeInvalidWMIDCOMAndWMISetup objFileHandle, boolDump
            AnalyzeSecurity objFileHandle, boolDump
            AnalyzeWMIOperationErrors objFileHandle, boolDump
            AnalyzeRegistrySetup objFileHandle, boolDump
            AnalyzeMissingMOFFiles objFileHandle, boolDump
            AnalyzeMissingWMIProviderMOFFile objFileHandle, boolDump
            AnalyzeMissingPragmaAutorecoverMOFFile objFileHandle, boolDump

            AnalyzeClassAndProviderCorrelation objFileHandle, boolDump
         End If 

         WriteToLogFile objFileHandle, String (130, "-"), cLoggingLevel0, False

         WriteToLogFile objFileHandle, "", cLoggingLevel0, False
         WriteToLogFile objFileHandle, String (130, "-"), cLoggingLevel0, False
         WriteToLogFile objFileHandle, "------------------------------------------------------ WMI REPORT: END -----------------------------------------------------------", cLoggingLevel0, False
         WriteToLogFile objFileHandle, String (130, "-"), cLoggingLevel0, False
         WriteToLogFile objFileHandle, "", cLoggingLevel0, False

End Function

' --------------------------------------------------------------------------------------------------------
Function AnalyzeEnvironment (ByVal objFileHandle, ByVal boolDump)

         Dim strTemp1, strTemp2, arrayTemp1, arrayTemp2

         On Error Resume Next

         WriteToLogFile objFileHandle, String (130, "-"), cLoggingLevel0, False

         If Len (TrackingData.Environment) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.Environment, ",")
            If Instr (TrackingData.Environment, "PATH;") > 0 Then
               StatusWriteToLogFile objFileHandle, "Environment", UBound (arrayTemp1) + 1 & " ITEM(S)!", cLoggingLevel1, False
            Else
               If Instr (TrackingData.Environment, "PATHEDGE;") > 0 Or Instr (TrackingData.Environment, "PATHLEN;") > 0 Then
                  StatusWriteToLogFile objFileHandle, "Environment", UBound (arrayTemp1) + 1 & " ITEM(S)!", cLoggingLevel2, Fals
               Else
                  StatusWriteToLogFile objFileHandle, "INFO: Environment", UBound (arrayTemp1) + 1 & " ITEM(S)!", cLoggingLevel0, False
               End If
            End If

            DumpCSV UBound (arrayTemp1) + 1, "Environment", 1, boolDump

            If Instr (TrackingData.Environment, "PATH;") > 0 Then
               WriteToLogFile objFileHandle, "=> The following path(s) is/are missing from the PATH environment variable:", cLoggingLevel1, False
               For Each strTemp1 In arrayTemp1
                   arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                   If arrayTemp2 (0) = "PATH" Then
                      WriteToLogFile objFileHandle, "          - " & arrayTemp2 (1), cLoggingLevel0, False
                   End If
               Next
               WriteToLogFile objFileHandle, "          Failing to have the listed path(s) in the PATH environment variable", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "          could prevent the system to work properly.", cLoggingLevel0, False

               intWMICriticalityLevel = cLoggingLevel1
            End If 

            If Instr (TrackingData.Environment, "PATHEDGE;") > 0 Then
               WriteToLogFile objFileHandle, "=> The following path(s) is/are on the edge or further than the maximum PATH length:", cLoggingLevel2, False
               For Each strTemp1 In arrayTemp1
                   arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                   If arrayTemp2 (0) = "PATHEDGE" Then
                      WriteToLogFile objFileHandle, "          - " & arrayTemp2 (1) & " is at position " & arrayTemp2 (2) & ", while the maximum PATH length is " & arrayTemp2 (3) & ".", cLoggingLevel0, False
                   End If
               Next
               WriteToLogFile objFileHandle, "          Failing to have the listed path(s) at the beginning of the PATH environment variable", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "          could prevent the system to work properly.", cLoggingLevel0, False

               If intWMICriticalityLevel <> cLoggingLevel1 Then intWMICriticalityLevel = cLoggingLevel2
            End If 

            If Instr (TrackingData.Environment, "PATHLEN;") > 0 Then
               WriteToLogFile objFileHandle, "=> The PATH is longer than the supported PATH length:", cLoggingLevel2, False
               For Each strTemp1 In arrayTemp1
                   arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                   If arrayTemp2 (0) = "PATHLEN" Then
                      WriteToLogFile objFileHandle, "          The maximum PATH length must be made of " & arrayTemp2 (2) & " positions.", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "          However, the current PATH length is be made of " & Len (arrayTemp2 (1)) & " positions.", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "          - " & ReplaceString (arrayTemp2 (1), "#", ";"), cLoggingLevel0, False
                   End If
               Next
               WriteToLogFile objFileHandle, "          When the PATH environment variable is too long the bottom part of the path is ignored, which", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "          could prevent the system to work properly.", cLoggingLevel0, False

               If intWMICriticalityLevel <> cLoggingLevel1 Then intWMICriticalityLevel = cLoggingLevel2
            End If 

            If Instr (TrackingData.Environment, "WSHTIMEOUT;") > 0 Then
               WriteToLogFile objFileHandle, "INFO: => WSH is configured with a maximum time a script is permitted to run:", cLoggingLevel0, False
               For Each strTemp1 In arrayTemp1
                   arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                   If arrayTemp2 (0) = "WSHTIMEOUT" Then
                      WriteToLogFile objFileHandle, "         - WSH " & arrayTemp2 (1) & " settings has a timeout set to " & CInt (arrayTemp2 (2)) & " seconds. With REGEDIT,", cLoggingLevel0, False
                      If arrayTemp2 (1) = "USER" Then
                         WriteToLogFile objFileHandle, "           set the 'Timeout' registry key at 'HKCU\Software\Microsoft\Windows Script Host\Settings' to 0.", cLoggingLevel0, False
                      End If 
                      If arrayTemp2 (1) = "MACHINE" Then
                         WriteToLogFile objFileHandle, "           set the 'Timeout' registry key at 'HKLM\SOFTWARE\Microsoft\Windows Script Host\Settings' to 0.", cLoggingLevel0, False
                      End If 
                   End If
               Next
               WriteToLogFile objFileHandle, "      => You can also overwrite these settings with the command:", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "         i.e. 'Cscript.Exe //T:5000 //S'", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "         i.e. 'Cscript.Exe //T:0 //S'", cLoggingLevel0, False
            End If

            If Instr (TrackingData.Environment, "SHUTDOWN;") > 0 Then
               For Each strTemp1 In arrayTemp1
                   arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                   If arrayTemp2 (0) = "SHUTDOWN" Then
                      WriteToLogFile objFileHandle, "INFO: => " & CInt (arrayTemp2 (1)) & " possible incorrect shutdown(s) detected on:", cLoggingLevel0, False
                      arrayTemp2 = ConvertStringInArray (TrackingData.InvalidShutdown, ",")
                      For Each strTemp2 In arrayTemp2
                          WriteToLogFile objFileHandle, "         - " & strTemp2 & ".", cLoggingLevel0, False
                      Next
                   End If
               Next
            End If

            WriteToLogFile objFileHandle, "", cLoggingLevel0, False     
         Else
            StatusWriteToLogFile objFileHandle, "Environment", "OK", cLoggingLevel0, False
            DumpCSV 0, "Environment", 1, boolDump
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function AnalyzeWMIFiles (ByVal objFileHandle, ByVal boolDump)

         Dim strTemp1, arrayTemp1, arrayTemp2

         On Error Resume Next

         If Len (TrackingData.WMIDiskData) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.WMIDiskData, ";")
            If arrayTemp1 (0) = "CIMWIN32_SKIPPED" Then
               StatusWriteToLogFile objFileHandle, "System drive", "SKIPPED.", cLoggingLevel0, False
               StatusWriteToLogFile objFileHandle, "Drive type", "SKIPPED.", cLoggingLevel0, False
               DumpCSV "SKIPPED", "SystemDriveType", 1, boolDump
               If intWMICriticalityLevel <> cLoggingLevel1 Then intWMICriticalityLevel = cLoggingLevel2
            Else
               StatusWriteToLogFile objFileHandle, "System drive", arrayTemp1 (4) & " (" & arrayTemp1 (3) & ")", cLoggingLevel0, False
               StatusWriteToLogFile objFileHandle, "Drive type", arrayTemp1 (1) & " (" & arrayTemp1 (2) & ")", cLoggingLevel0, False
               DumpCSV arrayTemp1 (1), "SystemDriveType", 1, boolDump
            End If 
         Else
            DumpCSV " ", "SystemDriveType", 1, boolDump
         End If

         If Len (TrackingData.PresenceOfFiles) > 0 Then
            arrayTemp1 = ConvertStringInArray (TrackingData.PresenceOfFiles, ",")
            StatusWriteToLogFile objFileHandle, "The following issues have been found with the following files", UBound (arrayTemp1) + 1 & " FILE(S)!", cLoggingLevel2, False
            DumpCSV UBound (arrayTemp1) + 1, "PresenceOfFiles", 1, boolDump
            For Each strTemp1 In arrayTemp1
                arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                If CBool (arrayTemp2 (1)) = True Then
                   WriteToLogFile objFileHandle, "=> At this location, '" & arrayTemp2 (0) & "' is a ROGUE file. It is NOT a WMI file. It MUST be deleted.", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "   This is an issue because " & arrayTemp2 (2), cLoggingLevel0, False
                End If
            Next

            For Each strTemp1 In arrayTemp1
                arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                If CBool (arrayTemp2 (1)) = False Then
                   WriteToLogFile objFileHandle, "=> '" & arrayTemp2 (0) & "' is a MISSING file. Retrieve a copy from a working system.", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "   This is an issue because " & arrayTemp2 (2), cLoggingLevel0, False
                End If
            Next

            WriteToLogFile objFileHandle, "", cLoggingLevel0, False

            If intWMICriticalityLevel <> cLoggingLevel1 Then intWMICriticalityLevel = cLoggingLevel2
         Else
            DumpCSV 0, "PresenceOfFiles", 1, boolDump
         End If

         If Len (TrackingData.AdditionalBinaryWBEMFolder) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.AdditionalBinaryWBEMFolder, ",")
            StatusWriteToLogFile objFileHandle, "INFO: The following UNEXPECTED binary files are/is found in the WBEM folder", UBound (arrayTemp1) + 1 & " FILE(S)!", cLoggingLevel0, False
            DumpCSV UBound (arrayTemp1) + 1, "AdditionalBinaryWBEMFolder", 1, boolDump
            For Each strTemp1 In arrayTemp1
                arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                WriteToLogFile objFileHandle, "  - " & Left (arrayTemp2 (0) & "," & Space (40), 30) & " " & Left (arrayTemp2 (1) & " bytes, " & Space (20), 20) & arrayTemp2 (4), cLoggingLevel0, False
            Next

            WriteToLogFile objFileHandle, "=> This list is provided for information. Unexpected binary file(s) in '" & RunTimeEnvironmentInfo.WBem & "'", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   do not necessarily represent an error. For instance, the file(s) listed can be added by", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   any applications implementing WMI providers.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "=> NO ACTION is required.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "", cLoggingLevel0, False
         Else
            DumpCSV 0, "AdditionalBinaryWBEMFolder", 1, boolDump
         End If

         If Len (TrackingData.MissingWMISystemFiles) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.MissingWMISystemFiles, ",")
            StatusWriteToLogFile objFileHandle, "The following WMI system file(s) is/are missing", UBound (arrayTemp1) + 1 & " ERROR(S)!", cLoggingLevel1, False
            DumpCSV UBound (arrayTemp1) + 1, "MissingWMISystemFiles", 1, boolDump
            DisplayDiagnostic objFileHandle, arrayTemp1

            WriteToLogFile objFileHandle, "=> Recopy from a working system the missing WMI system files to '" & RunTimeEnvironmentInfo.WBem & "'", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "", cLoggingLevel0, False

            intWMICriticalityLevel = cLoggingLevel1
         Else
            DumpCSV 0, "MissingWMISystemFiles", 1, boolDump
            StatusWriteToLogFile objFileHandle, "There are no missing WMI system files", "OK", cLoggingLevel0, False
         End If

         If Len (TrackingData.MissingRepositoryFiles) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.MissingRepositoryFiles, ",")

            If Instr (TrackingData.RepositoryFileSizes, ";MISSING;DENIED;") > 0 Then
               StatusWriteToLogFile objFileHandle, "The WMI repository folder is missing or you do not have access to it at", RunTimeEnvironmentInfo.WBem & arrayWMIRepositoryFiles (0), cLoggingLevel1, False
               DumpCSV " ", "MissingRepositoryFiles", 1, boolDump
            Else
               DumpCSV UBound (arrayTemp1) + 1, "MissingRepositoryFiles", 1, boolDump
            End If

            StatusWriteToLogFile objFileHandle, "The following WMI repository file(s) is/are missing", UBound (arrayTemp1) + 1 & " ERROR(S)!", cLoggingLevel1, False

            DisplayDiagnostic objFileHandle, arrayTemp1

            WriteToLogFile objFileHandle, "=> To fix this issue:", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   - ENSURE you have all access rights to the WMI repository folder.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   - ENSURE you run WMIDiag as an Administrator.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "=> If the issue is not due to a lack of privileges, and folder/files are really missing, while", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   the WMI service successfully started, then WMI will rebuild the repository based on the", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   auto-recovery mechanism. In such a case, WMI repository files shoud be available after the execution", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   of WMIDiag. Check WMIDiag LOG.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "=> If the issue is NOT due to a lack of privileges, and folder/files are really missing, while", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   the WMI service does not start, then additional errors should be displayed (i.e. registry, DCOM, service hosts).", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   You must fix those issues first!", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "=> After fixing issues, if the files are still missing and if you do not want WMI to rebuild", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   the WMI repository, then you must restore the WMI repository from a previous backup.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   Note: The System State backup or the System Restore snapshot contain a backup of", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "         of the WMI repository.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "=> If no backup is available, you must rebuild the repository.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   Note: The WMI repository reconstruction requires to locate all MOF files needed to rebuild the repository,", cLoggingLevel0, False 
            WriteToLogFile objFileHandle, "         otherwise some applications may fail after the reconstruction.", cLoggingLevel0, False 
            WriteToLogFile objFileHandle, "         This can be achieved with the following command:", cLoggingLevel0, False 
            WriteToLogFile objFileHandle, "         i.e. 'WMIDiag ShowMOFErrors'", cLoggingLevel0, False 
            WriteToLogFile objFileHandle, "   Note: Any missing MOF files, or existing MOF files not listed in the Auto-recovery", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "         registry key will be excluded from the WMI repository reconstruction.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "         This may imply the lost of WMI registration information.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   Note: The repository reconstruction must be a LAST RESORT solution and ONLY after executing", cLoggingLevel0, False 
            WriteToLogFile objFileHandle, "         ALL fixes previously mentioned.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "Static information stored by external applications in the repository will be LOST! (i.e. SMS Inventory)", cLoggingLevel2, False
            WriteToLogFile objFileHandle, "=> To rebuild the WMI repository, you must:", cLoggingLevel0, False
            If RunTimeEnvironmentInfo.OSIdentifier >= cWindowsVistaRTM Then
               WriteToLogFile objFileHandle, "   - Reset the WMI repository", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "     (The WMI repository rebuilt is based on auto-recovery)", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "     i.e. 'WINMGMT /ResetRepository'", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   OR", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   - Salvage the WMI repository if you want to attempt the retrieval of good data from the", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "     inconsistent repository", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "     (The repository rebuilt is based on auto-recovery + salvage)", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "     i.e. 'WINMGMT /SalvageRepository'", cLoggingLevel0, False
            Else
               WriteToLogFile objFileHandle, "   - Stop the WMI Service.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "     i.e. 'NET.EXE STOP WINMGMT'", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   - Move the existing WMI repository files to another location.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "     i.e. MOVE " & RunTimeEnvironmentInfo.WBem & arrayWMIRepositoryFiles (0) & "\*.* %TEMP%", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   - Start the WMI Service.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "     i.e. 'NET.EXE START WINMGMT'", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   WMI will rebuild the WMI repository based the auto-recovery mechanism.", cLoggingLevel0, False
            End If 
            WriteToLogFile objFileHandle, "", cLoggingLevel0, False

            intWMICriticalityLevel = cLoggingLevel1
         Else
            DumpCSV 0, "MissingRepositoryFiles", 1, boolDump
            StatusWriteToLogFile objFileHandle, "There are no missing WMI repository files", "OK", cLoggingLevel0, False
         End If

         If Len (TrackingData.WMIRepositoryConsistency) > 0 Then 
            If CBool (TrackingData.WMIRepositoryConsistency) = True Then
               StatusWriteToLogFile objFileHandle, "WMI repository state", "CONSISTENT", cLoggingLevel0, False
               DumpCSV "CONSISTENT", "WMIRepositoryConsistency", 1, boolDump
            End If 
            
            If CBool (TrackingData.WMIRepositoryConsistency) = False Then
               StatusWriteToLogFile objFileHandle, "WMI repository state", "ERROR (INCONSISTENT)!", cLoggingLevel1, False
               DumpCSV "INCONSISTENT", "WMIRepositoryConsistency", 1, boolDump

               If RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP2 Or _
		  RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP3 Then
                  WriteToLogFile objFileHandle, "   Note: Under Windows XP SP2 and SP3, when the repository is checked and detected INCONSISTENT,", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "         a new repository is automatically re-created based on Auto-Recovery mechanism.", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "         Note that some information can be lost during this process (i.e. static data, CIM registration).", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "         However, the original repository is located at '" & RunTimeEnvironmentInfo.WBem & "Repository.001'.", cLoggingLevel0, False
               End If 

               WriteToLogFile objFileHandle, "=> To fix this issue and if you do not want WMI to rebuild", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   the WMI repository, then you must restore the WMI repository from a previous backup.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   Note: The System State backup or the System Restore snapshot contain a backup of", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "         of the WMI repository.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "=> If no backup is available, you must rebuild the repository.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   Note: The WMI repository reconstruction requires to locate all MOF files needed to rebuild the repository,", cLoggingLevel0, False 
               WriteToLogFile objFileHandle, "         otherwise some applications may fail after the reconstruction.", cLoggingLevel0, False 
               WriteToLogFile objFileHandle, "         This can be achieved with the following command:", cLoggingLevel0, False 
               WriteToLogFile objFileHandle, "         i.e. 'WMIDiag ShowMOFErrors'", cLoggingLevel0, False 
               WriteToLogFile objFileHandle, "   Note: Any missing MOF files, or existing MOF files not listed in the Auto-recovery", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "         registry key will be excluded from the WMI repository reconstruction.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "         This may imply the lost of WMI registration information.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   Note: The repository reconstruction must be a LAST RESORT solution and ONLY after executing", cLoggingLevel0, False 
               WriteToLogFile objFileHandle, "         ALL fixes previously mentioned.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "Static information stored by external applications in the repository will be LOST! (i.e. SMS Inventory)", cLoggingLevel2, False
               WriteToLogFile objFileHandle, "=> To rebuild the WMI repository, you must:", cLoggingLevel0, False
               If RunTimeEnvironmentInfo.OSIdentifier >= cWindowsVistaRTM Then
                  WriteToLogFile objFileHandle, "   - Reset the WMI repository", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "     (The WMI repository rebuilt is based on auto-recovery)", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "     i.e. 'WINMGMT /ResetRepository'", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   OR", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   - Salvage the WMI repository if you want to attempt the retrieval of good data from the", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "     inconsistent repository", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "     (The repository rebuilt is based on auto-recovery + salvage)", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "     i.e. 'WINMGMT /SalvageRepository'", cLoggingLevel0, False
               Else
                  WriteToLogFile objFileHandle, "   - Stop the WMI Service.", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "     i.e. 'NET.EXE STOP WINMGMT'", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   - Move the existing WMI repository files to another location.", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "     i.e. MOVE " & RunTimeEnvironmentInfo.WBem & arrayWMIRepositoryFiles (0) & "\*.* %TEMP%", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   - Start the WMI Service.", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "     i.e. 'NET.EXE START WINMGMT'", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   WMI will rebuild the WMI repository based the auto-recovery mechanism.", cLoggingLevel0, False
               End If 
               WriteToLogFile objFileHandle, "", cLoggingLevel0, False

               boolWMISystemError = True
               intWMICriticalityLevel = cLoggingLevel1
            End If 
         Else
            If RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP2 Or _ 
               RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP3 Then
               StatusWriteToLogFile objFileHandle, "WMI repository state", "NOT TESTED", cLoggingLevel0, False
            Else
               StatusWriteToLogFile objFileHandle, "WMI repository state", "N/A", cLoggingLevel0, False
            End If
            DumpCSV " ", "WMIRepositoryConsistency", 1, boolDump
         End If

         If Len (TrackingData.RepositoryFileSizes) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.RepositoryFileSizes, ",")
            For Each strTemp1 In arrayTemp1
                arrayTemp2 = ConvertStringInArray (strTemp1, ";")

                If Instr (arrayTemp2 (0), "FOLDERSIZEBEFORE") > 0 Then 
                   WriteToLogFile objFileHandle, "BEFORE running WMIDiag:", cLoggingLevel0, False
                End If 
                If Instr (arrayTemp2 (0), "FOLDERSIZEAFTER") > 0 Then 
                   WriteToLogFile objFileHandle, "AFTER running WMIDiag:", cLoggingLevel0, False
                End If 

                Select Case arrayTemp2 (0) 
                       Case "FOLDERSIZEBEFORE", "FOLDERSIZEAFTER"
                            StatusWriteToLogFile objFileHandle, "The WMI repository has a size of", Round (arrayTemp2 (2) / (1024^2)) & " MB", cLoggingLevel0, False
                            DumpCSV Round (arrayTemp2 (2) / (1024^2)), "RepositoryFolderSize", 1, boolDump
                       Case "FREESPACEBEFORE", "FREESPACEAFTER"
                            StatusWriteToLogFile objFileHandle, "- Disk free space on '" & arrayTemp2 (1) & "'", Round (arrayTemp2 (3) / (1024^2)) & " MB", cLoggingLevel0, False
                            DumpCSV Round (arrayTemp2 (3) / (1024^2)), "DiskFreeSpace", 1, boolDump
                       Case Else
                            WriteToLogFile objFileHandle, "  - " & Left (arrayTemp2 (0) & "," & Space (40), 30) & " " & Left (arrayTemp2 (1) & " bytes, " & Space (20), 20) & arrayTemp2 (4), cLoggingLevel0, False
                            If Instr (TrackingData.RepositoryFileSizes, ";MISSING;DENIED;") > 0 Then
                               DumpCSV 0, "RepositoryFileSizes", 1, boolDump
                            End If
                End Select
            Next
         Else
            StatusWriteToLogFile objFileHandle, "- The WMI repository has a size of", "NOT AVAILABLE", cLoggingLevel0, False
            DumpCSV " ", "RepositoryFileSizes", 1, boolDump
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function AnalyzeFirewallStatus (ByVal objFileHandle, ByVal boolDump)

         Dim strTemp, arrayTemp, strFWProfile
         Dim strWMIInbound, strWMIAsyncInbound

         On Error Resume Next

         WriteToLogFile objFileHandle, String (130, "-"), cLoggingLevel0, False

         If Instr (TrackingData.FirewallStatus, "FWNOTINSTALLED") > 0 Then 
            StatusWriteToLogFile objFileHandle, "Windows Firewall", "NOT INSTALLED", cLoggingLevel0, False
            DumpCSV " ", "FirewallStatus", 1, boolDump
            DumpCSV " ", "RemoteAdmin", 1, boolDump
            DumpCSV " ", "UnSecApp", 1, boolDump
         Else
            If Instr (TrackingData.FirewallStatus, "FWSVCSTOPPED") > 0 Then 
               StatusWriteToLogFile objFileHandle, "Windows Firewall Service", "STOPPED", cLoggingLevel2, False
               DumpCSV "False", "FirewallStatus", 1, boolDump
               DumpCSV " ", "RemoteAdmin", 1, boolDump
               DumpCSV " ", "UnSecApp", 1, boolDump
            Else
               If Instr (TrackingData.FirewallStatus, "FWDISABLED") > 0 Then 
                  StatusWriteToLogFile objFileHandle, "Windows Firewall", "DISABLED", cLoggingLevel2, False
                  DumpCSV "False", "FirewallStatus", 1, boolDump
                  DumpCSV " ", "RemoteAdmin", 1, boolDump
                  DumpCSV " ", "UnSecApp", 1, boolDump
               Else
                  StatusWriteToLogFile objFileHandle, "INFO: Windows Firewall status", "ENABLED", cLoggingLevel0, False
                  DumpCSV "True", "FirewallStatus", 1, boolDump
   
                  If Len (TrackingData.FirewallStatus) > 0 Then 
                     If RunTimeEnvironmentInfo.OSIdentifier > cWindows2003SP264 Then

                        strWMIInbound = "True"
                        strWMIAsyncInbound = "True"

                        arrayTemp = ConvertStringInArray (TrackingData.FirewallStatus, ",")
                        For Each strTemp In arrayTemp         
                            If Mid (strTemp, 1, 10) = "FWPROFILE=" Then
                               strFWProfile = Mid (strTemp, 11)
                               StatusWriteToLogFile objFileHandle, "Windows Firewall Profile", strFWProfile, cLoggingLevel0, False
                            End If
                            If strTemp = "FWNOEXCEPTION" Then
                               StatusWriteToLogFile objFileHandle, "Firewall inbound exception rules BLOCKED", "ENABLED", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "=> This will prevent any WMI remote connectivity to this computer despite the activation of any firewall inbound rules.", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   Changing or adding an inbound firewall rule (or group) to the current profile will not take effect", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   because inbound exceptions are not allowed.", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, " - You can adjust the configuration by executing the following command:", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, " i.e. 'NETSH.EXE ADVFIREWALL SET ALLPROFILES FIREWALLPOLICY BLOCKINBOUND,ALLOWOUTBOUND'", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "", cLoggingLevel0, False

                               strWMIInbound = "False"
                            End If 
                            If strTemp = "FWNOINBOUND" Then
                               StatusWriteToLogFile objFileHandle, "Inbound connections that do not match a rule BLOCKED", "ENABLED", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "=> This will prevent any WMI remote connectivity to this computer except", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   if the following three inbound rules are ENABLED and non-BLOCKING:", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   - '" & cFWRuleDCOMIn & "'", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   - '" & cFWRuleWMIIn & "'", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   - '" & cFWRuleAsyncIn & "'", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   Verify the reported status for each of these three inbound rules below.", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "", cLoggingLevel0, False
                            End If 
                            If strTemp = "FWNOOUTBOUND" Then
                               StatusWriteToLogFile objFileHandle, "Outbound connections that do not match a rule BLOCKED", "ENABLED", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "=> This will prevent any WMI asynchronous connectivity from this computer except", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   if the following outbound rule is ENABLED and non-BLOCKING:", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   - '" & cFWRuleWMIOut & "'", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   Verify the reported status for this outbound rule below.", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "", cLoggingLevel0, False
                            End If 
                            If strTemp = "FWGROUPRULEDISABLED" Then
                               StatusWriteToLogFile objFileHandle, "Windows Firewall '" & cWMIRuleGroup & "' group rule", "DISABLED", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "=> This will prevent any WMI remote connectivity to/from this machine.", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   - You can adjust the configuration by executing the following command:", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   i.e. 'NETSH.EXE ADVFIREWALL FIREWALL SET RULE GROUP=" & Chr(34) & cWMIRuleGroup & Chr(34) & " NEW ENABLE=YES'", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "Note: With this command all inbound and outbound WMI rules are activated at once!", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "      You can also enable each individual rule instead of activating the group rule.", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "", cLoggingLevel0, False
                            End If 
                            If strTemp = "FWGROUPRULEENABLED" Then
                               StatusWriteToLogFile objFileHandle, "Windows Firewall '" & cWMIRuleGroup & "' GROUP rule", "ENABLED", cLoggingLevel0, False
                            End If 
                            If strTemp = "DCOM-IN_DISABLED" Then
                               StatusWriteToLogFile objFileHandle, "Windows Firewall '" & cFWRuleDCOMIn & "' rule", "DISABLED", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "=> This will prevent any DCOM WMI inbound connectivity to this machine.", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "Note: The rule '" & cFWRuleDCOMIn & "' rule must be ENABLED to allow incoming DCOM WMI connectivity.", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   - You can adjust the configuration of this rule by executing the following command:", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   i.e. 'NETSH.EXE ADVFIREWALL FIREWALL SET RULE NAME=" & Chr(34) & cFWRuleDCOMIn & Chr(34) & " NEW ENABLE=YES'", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "", cLoggingLevel0, False

                               strWMIInbound = "False"
                            End If 
                            If strTemp = "DCOM-IN_ENABLED" Then
                               StatusWriteToLogFile objFileHandle, "Windows Firewall '" & cFWRuleDCOMIn & "' rule", "ENABLED", cLoggingLevel0, False
                            End If 
                            If strTemp = "DCOM-IN_BLOCKED" Then
                               StatusWriteToLogFile objFileHandle, "Windows Firewall '" & cFWRuleDCOMIn & "' rule", "BLOCKED", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "=> This will prevent any DCOM WMI inbound connectivity to this computer even if the rule is ENABLED.", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   - You can adjust the configuration of this rule by executing the following command:", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   i.e. 'NETSH.EXE ADVFIREWALL FIREWALL SET RULE NAME=" & Chr(34) & cFWRuleDCOMIn & Chr(34) & " NEW ACTION=ALLOW'", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "", cLoggingLevel0, False

                               strWMIInbound = "False"
                            End If 
                            If strTemp = "WMI-IN_DISABLED" Then
                               StatusWriteToLogFile objFileHandle, "Windows Firewall '" & cFWRuleWMIIn & "' rule", "DISABLED", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "=> This will prevent any WMI inbound connectivity to this machine.", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "Note: The rule '" & cFWRuleWMIIn & "' rule must be ENABLED to allow incoming WMI connectivity.", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   - You can adjust the configuration of this rule by executing the following command:", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   i.e. 'NETSH.EXE ADVFIREWALL FIREWALL SET RULE NAME=" & Chr(34) & cFWRuleWMIIn & Chr(34) & " NEW ENABLE=YES'", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "", cLoggingLevel0, False

                               strWMIInbound = "False"
                            End If 
                            If strTemp = "WMI-IN_ENABLED" Then
                               StatusWriteToLogFile objFileHandle, "Windows Firewall '" & cFWRuleWMIIn & "' rule", "ENABLED", cLoggingLevel0, False
                            End If 
                            If strTemp = "WMI-IN_BLOCKED" Then
                               StatusWriteToLogFile objFileHandle, "Windows Firewall '" & cFWRuleWMIIn & "' rule", "BLOCKED", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "=> This will prevent any WMI inbound connectivity to this computer even if the rule is ENABLED.", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   - You can adjust the configuration of this rule by executing the following command:", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   i.e. 'NETSH.EXE ADVFIREWALL FIREWALL SET RULE NAME=" & Chr(34) & cFWRuleWMIIn & Chr(34) & " NEW ACTION=ALLOW'", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "", cLoggingLevel0, False

                               strWMIInbound = "False"
                            End If 
                            If strTemp = "ASYNC-IN_DISABLED" Then
                               StatusWriteToLogFile objFileHandle, "Windows Firewall '" & cFWRuleAsyncIn & "' rule", "DISABLED", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "=> This will prevent any WMI asynchronous inbound connectivity to this machine.", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   - You can adjust the configuration of this rule by executing the following command:", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   i.e. 'NETSH.EXE ADVFIREWALL FIREWALL SET RULE NAME=" & Chr(34) & cFWRuleAsyncIn & Chr(34) & " NEW ENABLE=YES'", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "", cLoggingLevel0, False

                               strWMIAsyncInbound = "False"
                            End If 
                            If strTemp = "ASYNC-IN_ENABLED" Then
                               StatusWriteToLogFile objFileHandle, "Windows Firewall '" & cFWRuleAsyncIn & "' rule", "ENABLED", cLoggingLevel0, False
                            End If 
                            If strTemp = "ASYNC-IN_BLOCKED" Then
                               StatusWriteToLogFile objFileHandle, "Windows Firewall '" & cFWRuleAsyncIn & "' rule", "BLOCKED", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "=> This will prevent any WMI asynchronous inbound connectivity to this computer even if the rule is ENABLED.", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   - You can adjust the configuration of this rule by executing the following command:", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   i.e. 'NETSH.EXE ADVFIREWALL FIREWALL SET RULE NAME=" & Chr(34) & cFWRuleAsyncIn & Chr(34) & " NEW ACTION=ALLOW'", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "", cLoggingLevel0, False

                               strWMIAsyncInbound = "False"
                            End If 
                            If strTemp = "WMI-OUT_DISABLED" Then
                               StatusWriteToLogFile objFileHandle, "Windows Firewall '" & cFWRuleWMIOut & "' rule", "DISABLED", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "=> This will prevent any WMI asynchronous outbound connectivity from this machine.", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   - You can adjust the configuration of this rule by executing the following command:", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   i.e. 'NETSH.EXE ADVFIREWALL FIREWALL SET RULE NAME=" & Chr(34) & cFWRuleWMIOut & Chr(34) & " NEW ENABLE=YES'", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "", cLoggingLevel0, False
                            End If 
                            If strTemp = "WMI-OUT_ENABLED" Then
                               StatusWriteToLogFile objFileHandle, "Windows Firewall '" & cFWRuleWMIOut & "' rule", "ENABLED", cLoggingLevel0, False
                            End If 
                            If strTemp = "WMI-OUT_BLOCKED" Then
                               StatusWriteToLogFile objFileHandle, "Windows Firewall '" & cFWRuleWMIOut  & "' rule", "BLOCKED", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "=> This will prevent any WMI asynchronous outbound connectivity from this computer even if the rule is ENABLED.", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   - You can adjust the configuration of this rule by executing the following command:", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   i.e. 'NETSH.EXE ADVFIREWALL FIREWALL SET RULE NAME=" & Chr(34) & cFWRuleWMIOut & Chr(34) & " NEW ACTION=ALLOW'", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "", cLoggingLevel0, False
                            End If 
                            If strTemp = "FWGPOVERRIDES" Then    
                               WriteToLogFile objLOGFileHandle, "INFO: Changing or adding a firewall rule (or group) to the current profile will not take effect because group policy overrides it.", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "", cLoggingLevel0, False
                            End If 
                        Next
                        DumpCSV strWMIInbound, "RemoteAdmin", 1, boolDump
                        DumpCSV strWMIAsyncInbound, "UnSecApp", 1, boolDump
                     Else
                        arrayTemp = ConvertStringInArray (TrackingData.FirewallStatus, ",")
                        For Each strTemp In arrayTemp   
                            If Mid (strTemp, 1, 10) = "FWPROFILE=" Then
                               strFWProfile = Mid (strTemp, 11)
                               StatusWriteToLogFile objFileHandle, "Windows Firewall Profile", strFWProfile, cLoggingLevel0, False
                            End If
                            If strTemp = "NOREMOTEADMIN" And UBound (arrayTemp) = 1 Then
                               DumpCSV "False", "RemoteAdmin", 1, boolDump
                               DumpCSV "True", "UnSecApp", 1, boolDump
                            End If 
                            If strTemp = "NOUNSECAPP" And UBound (arrayTemp) = 1 Then
                               DumpCSV "True", "RemoteAdmin", 1, boolDump
                               DumpCSV "False", "UnSecApp", 1, boolDump
                            End If 
                            If (strTemp = "NOREMOTEADMIN" Or strTemp = "NOUNSECAPP") And UBound (arrayTemp) = 2 Then
                               DumpCSV "False", "RemoteAdmin/UnSecApp", 1, boolDump
                            End If

                            If strTemp = "NOREMOTEADMIN" Then
                               StatusWriteToLogFile objFileHandle, "Windows Firewall 'RemoteAdmin' status", "DISABLED", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "=> This will prevent any WMI remote connectivity to this machine.", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   - You can adjust the configuration by executing the following command:", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   i.e. 'NETSH.EXE FIREWALL SET SERVICE REMOTEADMIN ENABLE SUBNET'", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "", cLoggingLevel0, False   
                            End If 
                            If strTemp = "NOUNSECAPP" Then
                               StatusWriteToLogFile objFileHandle, "Windows Firewall application exception for 'UNSECAPP.EXE'", "MISSING", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "=> This will prevent any script and MMC application asynchronous callbacks to this machine.", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   - You can adjust the configuration by executing the following command:", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   i.e. 'NETSH.EXE FIREWALL SET ALLOWEDPROGRAM " & RunTimeEnvironmentInfo.WBem & "UNSECAPP.EXE WMICALLBACKS ENABLE'", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "", cLoggingLevel0, False   
                            End If 
                        Next
                     End If 
                  Else
                     DumpCSV "True", "RemoteAdmin", 1, boolDump
                     DumpCSV "True", "UnSecApp", 1, boolDump
                  End If
               End If
            End If
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function AnalyzeInvalidDCOMSetup (ByVal objFileHandle, ByVal boolDump)

         Dim strTemp1, arrayTemp1, arrayTemp2, intIndex

         On Error Resume Next

         WriteToLogFile objFileHandle, String (130, "-"), cLoggingLevel0, False

         If Len (TrackingData.InvalidDCOMSetup) > 0 Then 
            If Instr (TrackingData.InvalidDCOMSetup, "DCOMDISABLED") > 0 Then 
               StatusWriteToLogFile objFileHandle, "DCOM Status", "ERROR!", cLoggingLevel1, False
            Else
               StatusWriteToLogFile objFileHandle, "DCOM Status", "WARNING!", cLoggingLevel2, False
            End If 

            arrayTemp1 = ConvertStringInArray (TrackingData.InvalidDCOMSetup, ",")
            For Each strTemp1 In arrayTemp1
                Select Case strTemp1
                       Case "DCOMDISABLED"
                            WriteToLogFile objFileHandle, "=> The DCOM configuration on this computer is DISABLED.", cLoggingLevel1, False 
                            WriteToLogFile objFileHandle, "   This prevents WMI to work correctly.", cLoggingLevel0, False 
                            WriteToLogFile objFileHandle, "   You can fix the DCOM configuration by:", cLoggingLevel0, False 
                            WriteToLogFile objFileHandle, "   - Executing the 'DCOMCNFG.EXE' command.", cLoggingLevel0, False 
                            WriteToLogFile objFileHandle, "   - Expanding 'Component Services' and 'Computers' nodes.", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "   - Editing properties of 'My Computer' node.", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "   - Editing the 'Default properties' tab.", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "   - Activate the 'Enable Distributed COM on this computer' checkbox.", cLoggingLevel0, False


                            If RunTimeEnvironmentInfo.OSIdentifier > cWindows2000SP4 Then
                               WriteToLogFile objFileHandle, "   From the command line, the DCOM configuration can be corrected with the following command:", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   i.e. 'REG.EXE Add HKLM\SOFTWARE\Microsoft\Ole /v EnableDCOM /t REG_SZ /d Y /f'", cLoggingLevel0, False
                            End If
                            intWMICriticalityLevel = cLoggingLevel1

                       Case "DCOMNOCONNECT"
                            WriteToLogFile objFileHandle, "=> The DCOM Default Authentication is NOT set to 'Connect'.", cLoggingLevel2, False
                            WriteToLogFile objFileHandle, "   This could prevent WMI to work correctly.", cLoggingLevel0, False 
                            WriteToLogFile objFileHandle, "   You can fix the DCOM configuration by:", cLoggingLevel0, False 
                            WriteToLogFile objFileHandle, "   - Executing the 'DCOMCNFG.EXE' command.", cLoggingLevel0, False 
                            WriteToLogFile objFileHandle, "   - Expanding 'Component Services' and 'Computers' nodes.", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "   - Editing properties of 'My Computer' node.", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "   - Editing the 'Default properties' tab.", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "   - Set the 'Default Authentication level' listbox to 'Connect'.", cLoggingLevel0, False
                            If RunTimeEnvironmentInfo.OSIdentifier > cWindows2000SP4 Then
                               WriteToLogFile objFileHandle, "   From the command line, the DCOM configuration can be corrected with the following command:", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   i.e. 'REG.EXE Add HKLM\SOFTWARE\Microsoft\Ole /v LegacyAuthenticationLevel /t REG_DWORD /d 2 /f'", cLoggingLevel0, False
                            End If

                            If intWMICriticalityLevel <> cLoggingLevel1 Then intWMICriticalityLevel = cLoggingLevel2

                       Case "DCOMNOIDENTIFY"
                            WriteToLogFile objFileHandle, "=> The DCOM Default Impersonation is NOT set to 'Identify'.", cLoggingLevel2, False
                            WriteToLogFile objFileHandle, "   This could prevent WMI to work correctly.", cLoggingLevel0, False 
                            WriteToLogFile objFileHandle, "   You can fix the DCOM configuration by:", cLoggingLevel0, False 
                            WriteToLogFile objFileHandle, "   - Executing the 'DCOMCNFG.EXE' command.", cLoggingLevel0, False 
                            WriteToLogFile objFileHandle, "   - Expanding 'Component Services' and 'Computers' nodes.", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "   - Editing properties of 'My Computer' node.", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "   - Editing the 'Default properties' tab.", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "   - Set the 'Default Impersonation level' listbox to 'Identify'.", cLoggingLevel0, False
                            If RunTimeEnvironmentInfo.OSIdentifier > cWindows2000SP4 Then
                               WriteToLogFile objFileHandle, "   From the command line, the DCOM configuration can be corrected with the following command:", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   i.e. 'REG.EXE Add HKLM\SOFTWARE\Microsoft\Ole /v LegacyImpersonationLevel /t REG_DWORD /d 2 /f'", cLoggingLevel0, False
                            End If

                            If intWMICriticalityLevel <> cLoggingLevel1 Then intWMICriticalityLevel = cLoggingLevel2
                End Select
            Next

            WriteToLogFile objFileHandle, "", cLoggingLevel0, False

            DumpCSV 1, "InvalidDCOMSetup", 1, boolDump
         Else
            StatusWriteToLogFile objFileHandle, "DCOM Status", "OK", cLoggingLevel0, False
            DumpCSV 0, "InvalidDCOMSetup", 1, boolDump
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function AnalyzeInvalidWMIServiceSetup (ByVal objFileHandle, ByVal boolDump)

         Dim strTemp1, arrayTemp1, arrayTemp2, intIndex

         On Error Resume Next

         If Len (TrackingData.InvalidWMIServiceSetup) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.InvalidWMIServiceSetup, ",")
            For Each strTemp1 In arrayTemp1
                Select Case strTemp1
                       Case "WMISERVICESTANDALONEHOST"
                            StatusWriteToLogFile objFileHandle, "INFO: WMI registry setup", "STANDALONE", cLoggingLevel2, False
                            WriteToLogFile objFileHandle, "=> The WMI service is configured to run as a STANDALONE service host.", cLoggingLevel0, False 
                            WriteToLogFile objFileHandle, "   - You should run the WMI service in a SHARED service host (recommended and default setup)", cLoggingLevel0, False 
                            WriteToLogFile objFileHandle, "     by executing the following command:", cLoggingLevel0, False 
                            If RunTimeEnvironmentInfo.OSIdentifier >= cWindowsVistaRTM Then 
                               WriteToLogFile objFileHandle, "   i.e. 'WINMGMT.EXE /SharedHost'", cLoggingLevel0, False
                            Else
                               WriteToLogFile objFileHandle, "   i.e. 'RUNDLL32.EXE " & RunTimeEnvironmentInfo.WBem & "WMISVC.DLL,MoveToShared'", cLoggingLevel0, False
                            End If
                            WriteToLogFile objFileHandle, "=> Reboot the system.", cLoggingLevel0, False

                       Case "WMISERVICEHOST"
                            StatusWriteToLogFile objFileHandle, "WMI registry setup", "INVALID HOSTING SETUP!", cLoggingLevel2, False
                            WriteToLogFile objFileHandle, "=> The WMI service must be configured to run as a STANDALONE service host or", cLoggingLevel0, False 
                            WriteToLogFile objFileHandle, "   as a SHARED service host but the (SvcHost) configuration contains invalid information.", cLoggingLevel0, False 
                            If RunTimeEnvironmentInfo.OSIdentifier >= cWindowsVistaRTM Then 
                               WriteToLogFile objFileHandle, "=> You can fix this issue by running ONE of the following commands:", cLoggingLevel0, False 
                               WriteToLogFile objFileHandle, "   - Shared service host (recommended):", cLoggingLevel0, False 
                               WriteToLogFile objFileHandle, "     i.e. 'WINMGMT.EXE /SharedHost'", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   - Standalone service host:", cLoggingLevel0, False 
                               WriteToLogFile objFileHandle, "     i.e. 'WINMGMT.EXE /StandaloneHost'", cLoggingLevel0, False
                            Else
                               WriteToLogFile objFileHandle, "=> You can fix this issue by running ONE of the following commands (case sensitive):", cLoggingLevel0, False 
                               WriteToLogFile objFileHandle, "   - Shared service host (recommended):", cLoggingLevel0, False 
                               WriteToLogFile objFileHandle, "     i.e. 'RUNDLL32.EXE " & RunTimeEnvironmentInfo.WBem & "WMISVC.DLL,MoveToShared'", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   - Standalone service host:", cLoggingLevel0, False 
                               WriteToLogFile objFileHandle, "     i.e. 'RUNDLL32.EXE " & RunTimeEnvironmentInfo.WBem & "WMISVC.DLL,MoveToAlone'", cLoggingLevel0, False
                            End If
                            WriteToLogFile objFileHandle, "=> Reboot the system.", cLoggingLevel0, False

                            If intWMICriticalityLevel <> cLoggingLevel1 Then intWMICriticalityLevel = cLoggingLevel2

                       Case "WMISERVICEDISABLED"
                            StatusWriteToLogFile objFileHandle, "WMI registry setup", "DISABLED!", cLoggingLevel1, False
                            WriteToLogFile objFileHandle, "=> The WMI service automatic startup is DISABLED!", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "   - It is a best practice for manageability purposes to start", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "     the WMI service at computer startup (automactic startup).", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "=> The service startup state can be changed with the SERVICES MMC snap-in.", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "   or with the the command:", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "   i.e. 'SC.EXE CONFIG WINMGMT START= AUTO'", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "   Note: The SC.EXE command is available in the Windows Resource Kit.", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "=> You can also check the registry key setup further in this report.", cLoggingLevel0, False

                            intWMICriticalityLevel = cLoggingLevel1

                       Case "WMISERVICESETUP"
                            If Instr (TrackingData.InvalidWMIServiceSetup, "DISABLED") = 0 Then
                               StatusWriteToLogFile objFileHandle, "WMI registry setup", "SERVICE SETUP ISSUES!", cLoggingLevel2, False
                               WriteToLogFile objFileHandle, "=> If the WMI service is RUNNING and if registry settings are not correct,", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   you should check which registry key is subject to modifications (below in this report).", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   You can eventually repair the registry:", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   - manually with REGEDIT.EXE.", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   - by importing the missing registry keys from a working system (same Windows version, same SP level).", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   - You can also repair the WMI Service registry setup by re-creating the WMI service", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "     setup with the following command:", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "     i.e. 'SC.EXE CREATE WINMGMT BINPATH= " & RunTimeEnvironmentInfo.WBem & "WINMGMT.EXE START= AUTO'", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   Note: The SC.EXE command is available in the Windows Resource Kit.", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "     If the command fails because the WMI service name already exists,", cLoggingLevel0, False 
                               WriteToLogFile objFileHandle, "     you can delete the existing definition with the following command:", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "     i.e. 'SC.EXE DELETE WINMGMT'", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "     If the SC.EXE command does not work, you can delete with REGEDIT.EXE the registry hive at:", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "     'HKLM\SYSTEM\CurrentControlSet\Services\Winmgmt'", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "     and re-execute the 'SC.EXE CREATE' command above.", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   Note: It could be required to reboot the system to refresh the Service Control Manager configuration.", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "     - Once the WMI service is re-created:", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "     - Make sure there is no other registry keys missing or wrongly configured.", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "       You can manually add the missing keys with REGEDIT.", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "     - After re-creating the registry, and fixing ALL missing entries, you must configure", cLoggingLevel0, False 
                               WriteToLogFile objFileHandle, "       the WMI service to run as a STANDALONE service host or as a SHARED service host (SvcHost)", cLoggingLevel0, False 
                               If RunTimeEnvironmentInfo.OSIdentifier >= cWindowsVistaRTM Then 
                                  WriteToLogFile objFileHandle, "       You can achieve this by running the following commands:", cLoggingLevel0, False 
                                  WriteToLogFile objFileHandle, "       - to configure the service to run as a SHARED service host (recommended):", cLoggingLevel0, False 
                                  WriteToLogFile objFileHandle, "         i.e. 'WINMGMT.EXE /SharedHost'", cLoggingLevel0, False
                                  WriteToLogFile objFileHandle, "       - if you have issue to get the WMI service running as a SHARED service host, it", cLoggingLevel0, False 
                                  WriteToLogFile objFileHandle, "         can be configured to run as a STANDALONEservice host:", cLoggingLevel0, False 
                                  WriteToLogFile objFileHandle, "         i.e. 'WINMGMT.EXE /StandaloneHost'", cLoggingLevel0, False
                               Else
                                  WriteToLogFile objFileHandle, "       You can achieve this by running ONE of the following commands (case sensitive):", cLoggingLevel0, False 
                                  WriteToLogFile objFileHandle, "       - to configure the service to run as a SHARED service host (recommended):", cLoggingLevel0, False 
                                  WriteToLogFile objFileHandle, "         i.e. 'RUNDLL32.EXE " & RunTimeEnvironmentInfo.WBem & "WMISVC.DLL,MoveToShared'", cLoggingLevel0, False
                                  WriteToLogFile objFileHandle, "       - if you have issue to get the WMI service running as a SHARED service host, it", cLoggingLevel0, False 
                                  WriteToLogFile objFileHandle, "         can be configured to run as a STANDALONE service host:", cLoggingLevel0, False 
                                  WriteToLogFile objFileHandle, "         i.e. 'RUNDLL32.EXE " & RunTimeEnvironmentInfo.WBem & "WMISVC.DLL,MoveToAlone'", cLoggingLevel0, False
                               End If
                               WriteToLogFile objFileHandle, "=> Reboot the system.", cLoggingLevel0, False

                               If intWMICriticalityLevel <> cLoggingLevel1 Then intWMICriticalityLevel = cLoggingLevel2
                            End If 
                End Select
            Next

            WriteToLogFile objFileHandle, "", cLoggingLevel0, False

            DumpCSV 1, "InvalidWMIServiceSetup", 1, boolDump
         Else
            StatusWriteToLogFile objFileHandle, "WMI registry setup", "OK", cLoggingLevel0, False
            DumpCSV 0, "InvalidWMIServiceSetup", 1, boolDump
         End If

         If Len (TrackingData.WMIServiceDependents) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.WMIServiceDependents, ",")
            StatusWriteToLogFile objFileHandle, "INFO: WMI service has dependents", UBound (arrayTemp1) + 1 & " SERVICE(S)!", cLoggingLevel0, False
            DumpCSV UBound (arrayTemp1) + 1, "WMIServiceDependents", 1, boolDump
            For Each strTemp1 In arrayTemp1
                arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                WriteToLogFile objFileHandle, "- " & arrayTemp2(0) & " (" & arrayTemp2(1) & ", StartMode='" & arrayTemp2(2) & "')", cLoggingLevel0, False                    
            Next

            WriteToLogFile objFileHandle, "=> If the WMI service is stopped, the listed service(s) will have to be stopped as well.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   Note: If the service is marked with (*), it means that the service/application uses WMI but", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "         there is no hard dependency on WMI. However, if the WMI service is stopped,", cLoggingLevel0, False 
            WriteToLogFile objFileHandle, "         this can prevent the service/application to work as expected.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "", cLoggingLevel0, False
         Else
            StatusWriteToLogFile objFileHandle, "WMI Service has no dependents", "OK", cLoggingLevel0, False
            DumpCSV 0, "WMIServiceDependents", 1, boolDump
         End If

         If Len (TrackingData.ServiceState) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.ServiceState, ",")
            For Each strTemp1 In arrayTemp1
                arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                If arrayTemp2(2) = "0x0" Then
                   StatusWriteToLogFile objFileHandle, arrayTemp2(0) & " service", "OK (" & arrayTemp2(1) & ")", cLoggingLevel0, False
                Else
                   If Instr (TrackingData.InvalidWMIServiceSetup, "DISABLED") = 0 Then
                      StatusWriteToLogFile objFileHandle, arrayTemp2(0) & " service", arrayTemp2(1), cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "=> The " & arrayTemp2(0) & " service can't be started. This could be due to the following reasons:", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "   - The service is DISABLED. You can re-enable the service with the command:", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "     i.e. 'SC.EXE CONFIG " & arrayTemp2(0) & " START= AUTO'", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "   Note: The SC.EXE command is available in the Windows Resource Kit.", cLoggingLevel0, False
                      If arrayTemp2(0) = "WINMGMT" Then
                         WriteToLogFile objFileHandle, "   - The " & arrayTemp2(0) & " service depends on RPCSS service which is DISABLED or unable to start.", cLoggingLevel0, False
                      End If
                      WriteToLogFile objFileHandle, "   - If the service is ENABLED but can't start, then the service registry may contains bad data.", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "   Note: Registry setup errors should be reported. Follow the steps related to registry issues.", cLoggingLevel0, False
                      If arrayTemp2(0) = "WINMGMT" Then
                         WriteToLogFile objFileHandle, "=> After verifying the registry, if the WMI service does not start yet, you can try to", cLoggingLevel0, False 
                         WriteToLogFile objFileHandle, "   to run the service as a STANDALONE service host or as a SHARED service host (SvcHost)", cLoggingLevel0, False 
                         If RunTimeEnvironmentInfo.OSIdentifier >= cWindowsVistaRTM Then 
                            WriteToLogFile objFileHandle, "   You can achieve this by running ONE of the following commands:", cLoggingLevel0, False 
                            WriteToLogFile objFileHandle, "   - to configure the service to run as a SHARED service host (recommended):", cLoggingLevel0, False 
                            WriteToLogFile objFileHandle, "     i.e. 'WINMGMT.EXE /SharedHost'", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "   - if you have issue to get it running as a SHARED service host, the WMI service", cLoggingLevel0, False 
                            WriteToLogFile objFileHandle, "     can be configured to run as a STANDALONE service host:", cLoggingLevel0, False 
                            WriteToLogFile objFileHandle, "     i.e. 'WINMGMT.EXE /StandaloneHost'", cLoggingLevel0, False
                         Else
                            WriteToLogFile objFileHandle, "   You can achieve this by running ONE of the following commands (case sensitive):", cLoggingLevel0, False 
                            WriteToLogFile objFileHandle, "   - to configure the service to run as a SHARED service host (recommended):", cLoggingLevel0, False 
                            WriteToLogFile objFileHandle, "     i.e. 'RUNDLL32.EXE " & RunTimeEnvironmentInfo.WBem & "WMISVC.DLL,MoveToShared'", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "   - if you have issue to get it running as a SHARED service host, the WMI service", cLoggingLevel0, False 
                            WriteToLogFile objFileHandle, "     can be configured to run as a STANDALONE service host:", cLoggingLevel0, False 
                            WriteToLogFile objFileHandle, "     i.e. 'RUNDLL32.EXE " & RunTimeEnvironmentInfo.WBem & "WMISVC.DLL,MoveToAlone'", cLoggingLevel0, False
                         End If
                         WriteToLogFile objFileHandle, "=> If the registry is correct and the WMI service does not start yet, the WMI repository could be inconsistent.", cLoggingLevel0, False
                         If RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP2 Or _
			    RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP3 Then
                            WriteToLogFile objFileHandle, "   - Under Windows XP SP2 and SP3, you can validate the repository consistency by:", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "     executing the following command:", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "     i.e. 'WMIDiag CheckConsistency'", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "   Note: Under Windows XP SP2 and SP3, when the repository is checked and detected INCONSISTENT,", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "         a new repository is automatically re-created based on Auto-Recovery mechanism.", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "         Note that some information can be lost during this process (i.e. static data, CIM registration).", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "         However, the original repository is located at '" & RunTimeEnvironmentInfo.WBem & "Repository.001'.", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "         The computer must be rebooted for the system to work with the re-created repository.", cLoggingLevel0, False
                         Else
                            If RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP164 Or _
                               RunTimeEnvironmentInfo.OSIdentifier = cWindows2003SP1 Or _
			       RunTimeEnvironmentInfo.OSIdentifier = cWindows2003SP2 Or _
			       RunTimeEnvironmentInfo.OSIdentifier = cWindows2003SP264 Or _
                               RunTimeEnvironmentInfo.OSIdentifier = cWindows2003SP164 Then
                               WriteToLogFile objFileHandle, "   - Validating the repository consistency. Under Windows XP 64-bit SP1, Windows 2003 SP1 and Windows Vista, the", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "     repository consistency is ALWAYS verified.", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "     Under Windows XP SP2, the repository consistency must be explicitly requested:", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "     i.e. 'WMIDiag CheckConsistency''", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "     Check the state of the repository above in the WMIDiag report.", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   - If the repository is inconsistent, it must be reconstructed.", cLoggingLevel0, False
                            Else
                               WriteToLogFile objFileHandle, "   - Validating the repository consistency. In such a case, you must rerun WMIDiag with 'WriteInRepository' parameter", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "     to validate the WMI repository operations.", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   Note: ENSURE you are an administrator with FULL access to WMI EVERY namespaces of the computer before", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "         executing the WriteInRepository command. To write temporary data from the Root namespace, use:", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "         i.e. 'WMIDiag WriteInRepository=Root'", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "   - If the WriteInRepository command fails, while being an Administrator with ALL accesses to ALL namespaces", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "     the WMI repository must be reconstructed/recovered.", cLoggingLevel0, False
                            End If
                         End If
                         WriteToLogFile objFileHandle, "   - The repository can be recovered from a previous backup.", cLoggingLevel0, False
                         WriteToLogFile objFileHandle, "   Note: The System State backup or the System Restore snapshot contain a backup of", cLoggingLevel0, False
                         WriteToLogFile objFileHandle, "         of the WMI repository.", cLoggingLevel0, False
                         WriteToLogFile objFileHandle, "=> If no backup is available, you must rebuild the repository.", cLoggingLevel0, False
                         WriteToLogFile objFileHandle, "   - Re-run WMIDiag with the ShowMOFErrors, this will show any MOF file issues.", cLoggingLevel0, False
                         WriteToLogFile objFileHandle, "     i.e. 'WMIDiag ShowMOFErrors'", cLoggingLevel0, False
                         WriteToLogFile objFileHandle, "   Note: The WMI repository reconstruction requires to locate all MOF files needed to rebuild the repository,", cLoggingLevel0, False 
                         WriteToLogFile objFileHandle, "         otherwise some applications may fail after the reconstruction.", cLoggingLevel0, False 
                         WriteToLogFile objFileHandle, "         This can be achieved with the following command:", cLoggingLevel0, False 
                         WriteToLogFile objFileHandle, "         i.e. 'WMIDiag ShowMOFErrors'", cLoggingLevel0, False 
                         WriteToLogFile objFileHandle, "   Note: Any missing MOF files, or existing MOF files not listed in the Auto-recovery", cLoggingLevel0, False
                         WriteToLogFile objFileHandle, "         registry key will be excluded from the WMI repository reconstruction.", cLoggingLevel0, False
                         WriteToLogFile objFileHandle, "         This may imply the lost of WMI registration information.", cLoggingLevel0, False
                         WriteToLogFile objFileHandle, "   Note: The repository reconstruction must be a LAST RESORT solution and ONLY after executing", cLoggingLevel0, False 
                         WriteToLogFile objFileHandle, "         ALL fixes previously mentioned.", cLoggingLevel0, False
                         WriteToLogFile objFileHandle, "Static information stored by external applications in the repository will be LOST! (i.e. SMS Inventory)", cLoggingLevel2, False
                         WriteToLogFile objFileHandle, "   - To rebuild the WMI repository, you must:", cLoggingLevel0, False
                         If RunTimeEnvironmentInfo.OSIdentifier >= cWindowsVistaRTM Then
                            WriteToLogFile objFileHandle, "   - Reset the WMI repository", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "     (The WMI repository rebuilt is based on auto-recovery)", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "     i.e. 'WINMGMT /ResetRepository'", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "   OR", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "   - Salvage the WMI repository if you want to attempt the retrieval of good data from the", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "     inconsistent repository", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "     (The repository rebuilt is based on auto-recovery + salvage)", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "     i.e. 'WINMGMT /SalvageRepository'", cLoggingLevel0, False
                         Else
                            WriteToLogFile objFileHandle, "   - Stop the WMI Service.", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "     i.e. 'NET.EXE STOP WINMGMT'", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "   - Move the existing WMI repository files to another location.", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "     i.e. MOVE " & RunTimeEnvironmentInfo.WBem & arrayWMIRepositoryFiles (0) & "\*.* %TEMP%", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "   - Start the WMI Service.", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "     i.e. 'NET.EXE START WINMGMT'", cLoggingLevel0, False
                            WriteToLogFile objFileHandle, "   WMI will rebuild the WMI repository based the auto-recovery mechanism.", cLoggingLevel0, False
                         End If 
                         WriteToLogFile objFileHandle, "", cLoggingLevel0, False
   
                         intWMICriticalityLevel = cLoggingLevel1
                      End If
                   End If
                End If
            Next
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function AnalyzeInvalidWMIDCOMAndWMISetup (ByVal objFileHandle, ByVal boolDump)

         Dim strTemp1, arrayTemp1, arrayTemp2, intCounter 

         On Error Resume Next

         WriteToLogFile objFileHandle, String (130, "-"), cLoggingLevel0, False

         If Len (TrackingData.InvalidWMIServiceDCOMSetup) > 0 Then 
            StatusWriteToLogFile objFileHandle, "WMI service DCOM setup", "ERROR!", cLoggingLevel1, False
            WriteToLogFile objFileHandle, "=> You can correct the WMI service DCOM configuration by executing the two following commands:", cLoggingLevel0, False
            If RunTimeEnvironmentInfo.OSIdentifier >= cWindowsVistaRTM then
               WriteToLogFile objFileHandle, "   i.e. 'REGSVR32.EXE WMISVC.DLL'", cLoggingLevel0, False
            Else
               WriteToLogFile objFileHandle, "   i.e. 'WINMGMT.EXE /REGSERVER'", cLoggingLevel0, False
            End If
            WriteToLogFile objFileHandle, "   i.e. 'UNSECAPP.EXE /REGSERVER'", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   i.e. 'FOR %i IN (""" & RunTimeEnvironmentInfo.WBem & "WBEM*.DLL"") DO REGSVR32.EXE /S %i'", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   Once completed, stop and restart the WMI Service with the following commands:", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   i.e. 'NET STOP WINMGMT'", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   i.e. 'NET START WINMGMT'", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "=> Check any additional registry setup errors at the bottom of this report.", cLoggingLevel0, False

            WriteToLogFile objFileHandle, "", cLoggingLevel0, False
            DumpCSV 1, "InvalidWMIServiceDCOMSetup", 1, boolDump

            intWMICriticalityLevel = cLoggingLevel1
         Else
            StatusWriteToLogFile objFileHandle, "WMI service DCOM setup", "OK", cLoggingLevel0, False
            DumpCSV 0, "InvalidWMIServiceDCOMSetup", 1, boolDump
         End If

         If Len (TrackingData.WMIDCOMRegistrations) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.WMIDCOMRegistrations, ",")
            StatusWriteToLogFile objFileHandle, "WMI DCOM components registration is missing for the following EXE/DLLs", UBound (arrayTemp1) + 1 & " WARNING(S)!", cLoggingLevel2, False
            DumpCSV UBound (arrayTemp1) + 1, "WMIDCOMRegistrations", 1, boolDump
            DisplayDiagnostic objFileHandle, arrayTemp1

            WriteToLogFile objFileHandle, "=> WMI System components are not properly registered as COM objects, which could make WMI to", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   fail depending on the operation requested.", cLoggingLevel0, False
            If Instr (UCase (TrackingData.WMIDCOMRegistrations), ".DLL") > 0 Then
               WriteToLogFile objFileHandle, "=> For a .DLL, you can correct the DCOM configuration by executing the 'REGSVR32.EXE <Filename.DLL>' command.", cLoggingLevel0, False
            End If
            If Instr (UCase (TrackingData.WMIDCOMRegistrations), ".EXE") > 0 Then
               WriteToLogFile objFileHandle, "=> For a .EXE, you can correct the DCOM configuration by executing the 'Filename.EXE /RegServer' command.", cLoggingLevel0, False
            End If
            WriteToLogFile objFileHandle, "", cLoggingLevel0, False

            If intWMICriticalityLevel <> cLoggingLevel1 Then intWMICriticalityLevel = cLoggingLevel2
         Else 
            StatusWriteToLogFile objFileHandle, "WMI components DCOM registrations", "OK", cLoggingLevel0, False
            DumpCSV 0, "WMIDCOMRegistrations", 1, boolDump
         End If

         If Len (TrackingData.WMIObjectProgID) > 0 Then
            arrayTemp1 = ConvertStringInArray (TrackingData.WMIObjectProgID, ",")
            DumpCSV UBound (arrayTemp1) + 1, "WMIObjectProgID", 1, boolDump
            StatusWriteToLogFile objFileHandle, "WMI ProgID registrations missing", UBound (arrayTemp1) + 1 & " ProgID(S)!", cLoggingLevel2, False
            For Each strTemp1 In arrayTemp1
                arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                WriteToLogFile objFileHandle, "- " & arrayTemp2 (0) & " -> " & arrayTemp2 (1), cLoggingLevel0, False
            Next

            WriteToLogFile objFileHandle, "=> Missing WMI ProgID(s) could prevent WMI applications to run properly!", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   To correct this problem, you must re-register the DLL(s) corresponding to the missing ProgID(s)", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   with the following command:", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   i.e. 'REGSVR32.EXE " & arrayTemp2 (1) & "'", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "", cLoggingLevel0, False

            If intWMICriticalityLevel <> cLoggingLevel1 Then intWMICriticalityLevel = cLoggingLevel2
         Else
            StatusWriteToLogFile objFileHandle, "WMI ProgID registrations", "OK", cLoggingLevel0, False
            DumpCSV 0, "WMIObjectProgID", 1, boolDump
         End If

         If Len (TrackingData.HighPrivWMIProvider) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.HighPrivWMIProvider, ",")
            DumpCSV UBound (arrayTemp1) + 1, "HighPrivWMIProvider", 1, boolDump
            If boolShowHighPrivProviders Then
               StatusWriteToLogFile objFileHandle, "INFO: WMI Providers running with high privileges", UBound (arrayTemp1) + 1 & " PROVIDERS(S)!", cLoggingLevel0, False
               For Each strTemp1 In arrayTemp1
                   arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                   If CBool (arrayTemp2 (4)) = True Then
                      WriteToLogFile objFileHandle, "! " & arrayTemp2 (0) & ", " & arrayTemp2 (1) & ", " & arrayTemp2 (2) & " (" & arrayTemp2 (3) & ").", cLoggingLevel0, False
                      If RunTimeEnvironmentInfo.OSIdentifier >= cWindowsVistaRTM Then
                         WriteToLogFile objFileHandle, "  => The provider lacks a hosting model definition. It is defaulted to 'NetworkServiceHostOrSelfHost'.", cLoggingLevel0, False
                      Else
                         WriteToLogFile objFileHandle, "  => The provider lacks a hosting model definition. It is defaulted to 'LocalSystemHostOrSelfHost'.", cLoggingLevel0, False
                      End If
                   Else
                      WriteToLogFile objFileHandle, "- " & arrayTemp2 (0) & ", " & arrayTemp2 (1) & ", " & arrayTemp2 (2) & " (" & arrayTemp2 (3) & ").", cLoggingLevel0, False
                   End If
               Next

               WriteToLogFile objFileHandle, "=> WMI providers are running in high privileges security context.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   - A provider should run under the lowest security context (i.e. NetworkServiceHost)", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "     and impersonates requests.", cLoggingLevel0, False
               If RunTimeEnvironmentInfo.OSIdentifier >= cWindowsVistaRTM Then
                  WriteToLogFile objFileHandle, "=> The provider hosting model is missing (defaulted to 'NetworkServiceHostOrSelfHost') and tagged with '!',", cLoggingLevel0, False
               Else
                  WriteToLogFile objFileHandle, "=> The provider hosting model is missing (defaulted to 'LocalSystemHostOrSelfHost') and tagged with '!',", cLoggingLevel0, False
               End If
               WriteToLogFile objFileHandle, "   it must be added to the MOF file.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "=> The provider developer can adjust the hosting model by specifying the", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   NetworkServiceHost security context in the WMI provider registration data (MOF file)", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   and impersonates WMI client requests in the provider code.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   This issue generates Event ID:", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   - 63: A provider, (" & arrayTemp2 (1)  & "), has been registered in the WMI namespace (" & arrayTemp2 (0) & ")", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "         to use the LocalSystem account.  This account is privileged and the provider may cause ", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "         a security violation if it does not correctly impersonate user requests.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   - 5063: A provider (" & arrayTemp2 (1) & ") has been registered in the WMI namespace (" & arrayTemp2 (0) & ")", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "           but did not specify the HostingModel property. This provider will be run using the", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "           LocalSystem account. This account is privileged and the provider may cause a security ", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "           violation if it does not correctly impersonate user requests.  Ensure that provider has been ", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "           reviewed for security behavior and update the HostingModel property of the provider ", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "           registration to an account with the least privileges possible for the required functionality.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "=> A provider MUST have a hosting model defined and should NOT run as LocalSystem unless it is", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   an absolute requirement (subject to an exception).", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "=> Proceeding accordingly, Event ID 63 and 5063 will disappear from the NT Event Log.", cLoggingLevel0, False

               WriteToLogFile objFileHandle, "", cLoggingLevel0, False
            End If

         Else
            If boolShowHighPrivProviders Then
               StatusWriteToLogFile objFileHandle, "WMI Providers running with high privileges", "OK", cLoggingLevel0, False
            End If
            DumpCSV 0, "HighPrivWMIProvider", 1, boolDump
         End If

         If Len (TrackingData.WMIProviderDCOMRegistrations) > 0 Then 
            If Instr (Ucase (TrackingData.WMIProviderDCOMRegistrations), "@E;") > 0 Then 
               intCounter = 0
               arrayTemp1 = ConvertStringInArray (TrackingData.WMIProviderDCOMRegistrations, ",")
               For Each strTemp1 In arrayTemp1
                   arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                   If arrayTemp2 (0) = "@E" Then
                      intCounter = intCounter + 1
                   End If
               Next
               DumpCSV intCounter, "WMIProviderDCOMRegistrations", 1, boolDump

               StatusWriteToLogFile objFileHandle, "WMI provider DCOM registrations missing for the following provider(s)", intCounter & " WARNING(S)!", cLoggingLevel2, False
               For Each strTemp1 In arrayTemp1
                   arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                   If arrayTemp2 (0) = "@E" Then
                      If Len (arrayTemp2 (4)) = 0 Then
                         WriteToLogFile objFileHandle, "- " & arrayTemp2 (1) & ", " & arrayTemp2 (2) & " (" & arrayTemp2 (3) & ")", cLoggingLevel0, False
                         WriteToLogFile objFileHandle, "  Provider DLL: '" & LocateWMIProviderData (objLOGFileHandle, arrayTemp2 (3), cWMIProviderCLSID, cWMIProviderBinary) & "'", cLoggingLevel0, False
                      Else
                         WriteToLogFile objFileHandle, "- " & arrayTemp2 (1) & ", " & arrayTemp2 (2) & " (" & arrayTemp2 (4) & ") (i.e. WMI Class '" & arrayTemp2 (3) & "')", cLoggingLevel0, False
                         WriteToLogFile objFileHandle, "  Provider DLL: '" & LocateWMIProviderData (objLOGFileHandle, arrayTemp2 (4), cWMIProviderCLSID, cWMIProviderBinary) & "'", cLoggingLevel0, False
                      End If
                   End If
               Next

               WriteToLogFile objFileHandle, "=> This is an issue because there are still some WMI classes referencing this list of providers", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   while the DCOM registration is wrong or missing. This can be due to:", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   - a de-installation of the software.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   - a deletion of some registry key data.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   - a registry corruption.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "=> You can correct the DCOM configuration by:", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   - Executing the 'REGSVR32.EXE <Provider.DLL>' command.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   Note: You can build a list of classes in relation with their WMI provider and MOF file with WMIDiag.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "         (This list can be built on a similar and working WMI Windows installation)", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "         The following command line must be used:", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "         i.e. 'WMIDiag CorrelateClassAndProvider'", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "Re-registering with REGSVR32.EXE all DLL from '" & RunTimeEnvironmentInfo.WBem & "'", cLoggingLevel2, False
               WriteToLogFile objFileHandle, "         may not solve the problem as the DLL supporting the WMI class(es)", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "         can be located in a different folder.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "         You must refer to the class name to determine the software delivering the related DLL.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "=> If the software has been de-installed intentionally, then this information must be", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   removed from the WMI repository. You can use the 'WMIC.EXE' command to remove", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   the provider registration data.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   i.e. 'WMIC.EXE /NAMESPACE:\\" & ReplaceString (arrayTemp2 (1), "/", "\") & " path __Win32Provider Where Name='" & arrayTemp2 (2) & "' DELETE'", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "=> If the namespace was ENTIRELY dedicated to the intentionally de-installed software,", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   the namespace and ALL its content can be ENTIRELY deleted.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   i.e. 'WMIC.EXE /NAMESPACE:\\" & SplitStringReverse (ReplaceString (arrayTemp2 (1), "/", "\"), -1, "\") & " path __NAMESPACE Where Name='" & SplitStringReverse (ReplaceString (arrayTemp2 (1), "/", "\"), 1, "\") & "' DELETE'", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   - Re-installing the software.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "", cLoggingLevel0, False

               If intWMICriticalityLevel <> cLoggingLevel1 Then intWMICriticalityLevel = cLoggingLevel2
            Else
               StatusWriteToLogFile objFileHandle, "WMI provider DCOM registrations", "OK", cLoggingLevel0, False
               DumpCSV 0, "WMIProviderDCOMRegistrations", 1, boolDump
            End If
         Else
            StatusWriteToLogFile objFileHandle, "WMI provider DCOM registrations", "OK", cLoggingLevel0, False
            DumpCSV 0, "WMIProviderDCOMRegistrations", 1, boolDump
         End If

         If Len (TrackingData.WMIProviderCIMRegistrations) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.WMIProviderCIMRegistrations, ",")
            StatusWriteToLogFile objFileHandle, "WMI provider CIM registrations missing for the following provider(s)", UBound (arrayTemp1) + 1 & " WARNING(S)!", cLoggingLevel2, False
            DumpCSV UBound (arrayTemp1) + 1, "WMIProviderCIMRegistrations", 1, boolDump
            For Each strTemp1 In arrayTemp1
                arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                WriteToLogFile objFileHandle, "- " & arrayTemp2 (0) & ", " & arrayTemp2 (1) & " (i.e. WMI Class '" & arrayTemp2 (2) & "')", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "  MOF Registration: '" & LocateWMIProviderData (objLOGFileHandle, arrayTemp2 (1), cWMIProviderName, cWMIProviderMOF) & "'", cLoggingLevel0, False
            Next

            WriteToLogFile objFileHandle, "=> This is an issue because there are still some WMI classes referencing this list of providers", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   while the CIM registration is wrong or missing. This can be due to:", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   - a de-installation of the software.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   - a deletion of some CIM registration information.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "=> You can correct the CIM configuration by:", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   - Manually recompiling the MOF file(s) with the 'MOFCOMP <FileName.MOF>' command.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   Note: You can build a list of classes in relation with their WMI provider and MOF file with WMIDiag.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "         (This list can be built on a similar and working WMI Windows installation)", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "         The following command line must be used:", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "         i.e. 'WMIDiag CorrelateClassAndProvider'", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   - Re-installing the software.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "=> If the software has been de-installed intentionally, then this information must be", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   removed from the WMI repository. You can use the 'WMIC.EXE' command to remove the provider", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   registration data and its set of associated classes.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   i.e. 'WMIC.EXE /NAMESPACE:\\" & ReplaceString (arrayTemp2 (0), "/", "\") & " path __Win32Provider Where Name='" & arrayTemp2 (1) & "' DELETE'", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   i.e. 'WMIC.EXE /NAMESPACE:\\" & ReplaceString (arrayTemp2 (0), "/", "\") & " Class " & arrayTemp2 (2) & " DELETE'", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "=> If the namespace was ENTIRELY dedicated to the intentionally de-installed software,", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   the namespace and ALL its content can be ENTIRELY deleted.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   i.e. 'WMIC.EXE /NAMESPACE:\\" & SplitStringReverse (ReplaceString (arrayTemp2 (0), "/", "\"), -1, "\") & " path __NAMESPACE Where Name='" & SplitStringReverse (ReplaceString (arrayTemp2 (0), "/", "\"), 1, "\") & "' DELETE'", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "", cLoggingLevel0, False

            If intWMICriticalityLevel <> cLoggingLevel1 Then intWMICriticalityLevel = cLoggingLevel2
         Else
            StatusWriteToLogFile objFileHandle, "WMI provider CIM registrations", "OK", cLoggingLevel0, False
            DumpCSV 0, "WMIProviderCIMRegistrations", 1, boolDump
         End If

         If Len (TrackingData.WMIProviderEmptyCLSID) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.WMIProviderEmptyCLSID, ",")
            StatusWriteToLogFile objFileHandle, "WMI provider CIM registration is missing the CLSID for the following provider(s)", UBound (arrayTemp1) + 1 & " WARNING(S)!", cLoggingLevel2, False
            DumpCSV UBound (arrayTemp1) + 1, "WMIProviderEmptyCLSID", 1, boolDump
            For Each strTemp1 In arrayTemp1
                arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                WriteToLogFile objFileHandle, "- " & arrayTemp2 (0) & ", " & arrayTemp2 (1), cLoggingLevel0, False
                WriteToLogFile objFileHandle, "  MOF Registration: '" & LocateWMIProviderData (objLOGFileHandle, arrayTemp2 (1), cWMIProviderName, cWMIProviderMOF) & "'", cLoggingLevel0, False
            Next

            WriteToLogFile objFileHandle, "=> This will make any operations related to the WMI class supported by the provider(s) to fail.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   - Unless the provider is hosted by an application external to WMI, every WMI hosted providers", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "     must have a CLSID defined in the WMI registration data (MOF file).", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "=> You can manually recompile the MOF file(s) with the 'MOFCOMP.EXE <FileName.MOF>' command.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "", cLoggingLevel0, False

            If intWMICriticalityLevel <> cLoggingLevel1 Then intWMICriticalityLevel = cLoggingLevel2
         Else
            StatusWriteToLogFile objFileHandle, "WMI provider CLSIDs", "OK", cLoggingLevel0, False
            DumpCSV 0, "WMIProviderEmptyCLSID", 1, boolDump
         End If

         If Len (TrackingData.MissingWMIProviderFile) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.MissingWMIProviderFile, ",")
            StatusWriteToLogFile objFileHandle, "Some WMI providers EXE/DLL file(s) are missing", UBound (arrayTemp1) + 1 & " WARNING(S)!", cLoggingLevel2, False
            DumpCSV UBound (arrayTemp1) + 1, "MissingWMIProviderFile", 1, boolDump
            For Each strTemp1 In arrayTemp1
                arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                WriteToLogFile objFileHandle, "- " & arrayTemp2 (0) & ", " & arrayTemp2 (1) & ", " & arrayTemp2 (2), cLoggingLevel0, False
            Next

            WriteToLogFile objFileHandle, "=> This will make any operations related to the WMI class supported by the provider(s) to fail.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   This can be due to:", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   - the de-installation of the software.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   - the deletion of some files.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "=> If the software has been de-installed intentionally, then this information must be", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   removed from the WMI repository. You can use the 'WMIC.EXE' command to remove", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   the provider registration data.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   i.e. 'WMIC.EXE /NAMESPACE:\\" & ReplaceString (arrayTemp2 (0), "/", "\") & " path __Win32Provider Where Name='" & arrayTemp2 (1) & "' DELETE'", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "=> If not, you must restore a copy of the missing provider EXE/DLL file(s) as indicated by the path.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   You can retrieve the missing file from:", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   - A backup.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   - The Windows CD.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   - Another Windows installation using the same version and service pack level of the examined system.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   - The original CD or software package installing this WMI provider.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "", cLoggingLevel0, False

            If intWMICriticalityLevel <> cLoggingLevel1 Then intWMICriticalityLevel = cLoggingLevel2
         Else
            StatusWriteToLogFile objFileHandle, "WMI providers EXE/DLL availability", "OK", cLoggingLevel0, False
            DumpCSV 0, "MissingWMIProviderFile", 1, boolDump
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function AnalyzeSecurity (ByVal objFileHandle, ByVal boolDump)

         Dim strTemp, arrayTemp1, arrayTemp2, arrayTemp3, arrayTemp4, arrayTemp5, intIndex1
         Dim strStatusMessage, strStatusValue
         Dim intDCOMSecurityWarnings, intDCOMSecurityErrors
         Dim intWMISecurityWarnings, intWMISecurityErrors
         Dim intSecurityType, strSecurityType

         On Error Resume Next

         WriteToLogFile objFileHandle, String (130, "-"), cLoggingLevel0, False

         If Len (TrackingData.UAC) > 0 Then 
            If Instr (TrackingData.UAC, "UAC;") > 0 Or Instr (TrackingData.UAC, "LAF;") > 0 Then
               arrayTemp1 = ConvertStringInArray (TrackingData.UAC, ",")
               For Each strTemp In arrayTemp1
                   arrayTemp2 = ConvertStringInArray (strTemp, ";")
                   If arrayTemp2 (0) = "UAC" Then
                      StatusWriteToLogFile objFileHandle, "INFO: User Account Control (UAC)", arrayTemp2 (1), cLoggingLevel0, False
                      If arrayTemp2 (1) = "ENABLED" Then
                         WriteToLogFile objFileHandle, "=> WMI tasks requiring Administrative privileges on this computer MUST run in an elevated context.", cLoggingLevel0, False
                         WriteToLogFile objFileHandle, "   i.e. You can start your scripts or WMIC commands from an elevated command", cLoggingLevel0, False
                         WriteToLogFile objFileHandle, "        prompt by right clicking on the 'Command Prompt' icon in the Start Menu and", cLoggingLevel0, False
                         WriteToLogFile objFileHandle, "        selecting 'Run as Administrator'.", cLoggingLevel0, False
                         WriteToLogFile objFileHandle, "   i.e. You can also execute the WMI scripts or WMIC commands as a task", cLoggingLevel0, False
                         WriteToLogFile objFileHandle, "        in the Task Scheduler within the right security context.", cLoggingLevel0, False
                         WriteToLogFile objFileHandle, "", cLoggingLevel0, False
                      End If 
                      DumpCSV arrayTemp2 (1), "UserAccountControl", 1, boolDump
                   End If 
                   If arrayTemp2 (0) = "LAF" Then
                      StatusWriteToLogFile objFileHandle, "INFO: Local Account Filtering", arrayTemp2 (1), cLoggingLevel0, False
                      If arrayTemp2 (1) = "ENABLED" Then
                         WriteToLogFile objFileHandle, "=> WMI tasks remotely accessing WMI information on this computer and requiring Administrative", cLoggingLevel0, False
                         WriteToLogFile objFileHandle, "   privileges MUST use a DOMAIN account part of the Local Administrators group of this computer", cLoggingLevel0, False
                         WriteToLogFile objFileHandle, "   to ensure that administrative privileges are granted. If a Local User account is used for remote", cLoggingLevel0, False
                         WriteToLogFile objFileHandle, "   accesses, it will be reduced to a plain user (filtered token), even if it is part of the Local Administrators group.", cLoggingLevel0, False
                         WriteToLogFile objFileHandle, "", cLoggingLevel0, False
                      End If 
                      DumpCSV arrayTemp2 (1), "LocalAccountFiltering", 1, boolDump
                   End If 
               Next
            Else
               DumpCSV " ", "UserAccountControl", 1, boolDump
               DumpCSV " ", "LocalAccountFiltering", 1, boolDump
            End If
         Else
            DumpCSV " ", "UserAccountControl", 1, boolDump
            DumpCSV " ", "LocalAccountFiltering", 1, boolDump
         End If

         intDCOMSecurityWarnings = 0
         intDCOMSecurityErrors = 0
         intWMISecurityWarnings = 0
         intWMISecurityErrors = 0

         If boolADSSecurity = True Then
            If Len (TrackingData.SecurityDescriptor) > 0 Then 
               arrayTemp1 = ConvertStringInArray (TrackingData.SecurityDescriptor, ",")

               For intIndex1 = 0 To UBound (arrayTemp1)
                   If Left (arrayTemp1 (intIndex1), 1) = "@" Then
                      arrayTemp2 = ConvertStringInArray (arrayTemp1 (intIndex1), ";")

                      intSecurityType = Cint (arrayTemp2 (2))
                      If boolLoggingDebug = True Then
                         Select Case intSecurityType
                                Case cSecurityException
                                     strSecurityType = " (X)"
                                Case cSecuritySystem
                                     strSecurityType = " (S)"
                                Case cSecurityApplication
                                     strSecurityType = " (A)"
                                Case cSecurityDefaulted
                                     strSecurityType = " (D)"
                         End Select
                      End If

                      If arrayTemp2 (0) = "@MODIFIED" Then
                         strStatusMessage = arrayTemp2 (1) & strSecurityType
                         strStatusValue = Mid (arrayTemp2 (0), 2)
                         intIndex1 = intIndex1 + 1
                      Else
                         StatusWriteToLogFile objFileHandle, arrayTemp2 (1) & strSecurityType, Mid (arrayTemp2 (0), 2), cLoggingDebug Or cLoggingLevel0, False
                      End If 
                   End If 

                   If Left (arrayTemp1 (intIndex1), 1) <> "@" Then
                      arrayTemp2 = ConvertStringInArray (arrayTemp1 (intIndex1), ";")

                      Select Case CInt(arrayTemp2 (7)) 
                             Case cLoggingLevel0
                                  StatusWriteToLogFile objFileHandle, strStatusMessage, strStatusValue, cLoggingDebug Or cLoggingLevel0, False
                                  WriteToLogFile objFileHandle, "INFO: " & arrayTemp2 (2), cLoggingDebug Or cLoggingLevel0, False
                             Case cLoggingLevel1
                                  StatusWriteToLogFile objFileHandle, strStatusMessage, strStatusValue, cLoggingLevel0, False
                                  WriteToLogFile objFileHandle, arrayTemp2 (2), cLoggingLevel1, False
                                  If intSecurityType = cSecuritySystem Or _
                                     intSecurityType = cSecurityApplication Then
                                     intWMICriticalityLevel = cLoggingLevel1
                                  End If
   
                                  Select Case CInt (arrayTemp2 (1))
                                         Case cDComSDAccess, cDComSDLaunch
                                              intDCOMSecurityErrors = intDCOMSecurityErrors + 1
                                         Case cWMINameSpaceSD
                                              intWMISecurityErrors = intWMISecurityErrors + 1
                                  End Select
                             Case cLoggingLevel2
                                  StatusWriteToLogFile objFileHandle, strStatusMessage, strStatusValue, cLoggingLevel0, False
                                  WriteToLogFile objFileHandle, arrayTemp2 (2), cLoggingLevel2, False
                                  If intSecurityType = cSecuritySystem Or _
                                     intSecurityType = cSecurityApplication Then
                                     If intWMICriticalityLevel <> cLoggingLevel1 Then intWMICriticalityLevel = cLoggingLevel2
                                  End If
      
                                  Select Case Cint (arrayTemp2 (1))
                                         Case cDComSDAccess, cDComSDLaunch
                                              intDCOMSecurityWarnings = intDCOMSecurityWarnings + 1
                                         Case cWMINameSpaceSD
                                              intWMISecurityWarnings = intWMISecurityWarnings + 1
                                  End Select
                      End Select 
   
                      Select Case Ucase (arrayTemp2 (0))
                             Case "NOACTUALMATCH", "NODEFAULTMATCH"
                                  arrayTemp3 = ConvertStringInArray (arrayTemp2 (3), "/")
                                  arrayTemp4 = ConvertStringInArray (arrayTemp2 (4), "/")
                                  arrayTemp5 = ConvertStringInArray (arrayTemp2 (5), "/")
   
                                  If CInt (arrayTemp2 (7)) > cLoggingLevel0 Or boolLoggingDebug = True Then
                                     If Ucase (arrayTemp2 (0)) = "NOACTUALMATCH" Then 
                                        WriteToLogFile objFileHandle, Space (5) & "  - ACTUAL ACE:", cLoggingLevel0, False
                                        DisplaySecurityData objFileHandle, "    ACEType:  ", arrayTemp3 (0), cLoggingLevel0
                                        DisplaySecurityData objFileHandle, "    ACEFlags: ", arrayTemp4 (0), cLoggingLevel0
                                        DisplaySecurityData objFileHandle, "    ACEMask:  ", arrayTemp5 (0), cLoggingLevel0
      
                                        WriteToLogFile objFileHandle, Space (5) & "  - EXPECTED ACE:", cLoggingLevel0, False            
                                        DisplaySecurityData objFileHandle, "    ACEType:  ", arrayTemp3 (1), cLoggingLevel0
                                        DisplaySecurityData objFileHandle, "    ACEFlags: ", arrayTemp4 (1), cLoggingLevel0
                                        DisplaySecurityData objFileHandle, "    ACEMask:  ", arrayTemp5 (1), cLoggingLevel0
                                     End If

                                     If Ucase (arrayTemp2 (0)) = "NODEFAULTMATCH" Then 
                                        WriteToLogFile objFileHandle, Space (5) & "  - EXPECTED ACE:", cLoggingLevel0, False            
                                        DisplaySecurityData objFileHandle, "    ACEType:  ", arrayTemp3 (0), cLoggingLevel0
                                        DisplaySecurityData objFileHandle, "    ACEFlags: ", arrayTemp4 (0), cLoggingLevel0
                                        DisplaySecurityData objFileHandle, "    ACEMask:  ", arrayTemp5 (0), cLoggingLevel0
   
                                        WriteToLogFile objFileHandle, Space (5) & "  - ACTUAL ACE:", cLoggingLevel0, False
                                        DisplaySecurityData objFileHandle, "    ACEType:  ", arrayTemp3 (1), cLoggingLevel0
                                        DisplaySecurityData objFileHandle, "    ACEFlags: ", arrayTemp4 (1), cLoggingLevel0
                                        DisplaySecurityData objFileHandle, "    ACEMask:  ", arrayTemp5 (1), cLoggingLevel0
                                     End If

                                     WriteToLogFile objFileHandle, "", cLoggingLevel0, False
                                  End If

                                  If CInt (arrayTemp2 (7)) = cLoggingLevel0 And boolLoggingDebug = True Then
                                     WriteToLogFile objFileHandle, "=> The actual " & arrayTemp2 (6), cLoggingLevel0, False
                                     WriteToLogFile objFileHandle, "", cLoggingLevel0, False
                                  End If 

                                  If CInt (arrayTemp2 (7)) = cLoggingLevel1 Then
                                     WriteToLogFile objFileHandle, "=> The actual " & arrayTemp2 (6), cLoggingLevel0, False
                                     WriteToLogFile objFileHandle, "   This will cause some operations to fail!", cLoggingLevel0, False
                                     WriteToLogFile objFileHandle, "   It is possible to fix this issue by editing the security descriptor and adding the removed right.", cLoggingLevel0, False
                                     If CInt (arrayTemp2 (1)) <> cWMINameSpaceSD Then
                                        WriteToLogFile objFileHandle, "   For DCOM objects, this can be done with 'DCOMCNFG.EXE'.", cLoggingLevel0, False
                                     Else
                                        WriteToLogFile objFileHandle, "   For WMI namespaces, this can be done with 'WMIMGMT.MSC'.", cLoggingLevel0, False
                                     End If
                                     If intSecurityType = cSecurityDefaulted Then
                                        WriteToLogFile objFileHandle, "Note: WMIDiag has no specific knowledge of this WMI namespace.", cLoggingLevel0, False
                                        WriteToLogFile objFileHandle, "      The security diagnostic is based on the WMI namespace expected defaults.", cLoggingLevel0, False
                                        WriteToLogFile objFileHandle, "      A specific WMI application can always require a security setup different", cLoggingLevel0, False 
                                        WriteToLogFile objFileHandle, "      than the WMI security defaults.", cLoggingLevel0, False
                                     End If 
                                     WriteToLogFile objFileHandle, "", cLoggingLevel0, False
                                  End If 

                                  If CInt (arrayTemp2 (7)) = cLoggingLevel2 Then
                                     WriteToLogFile objFileHandle, "=> The actual " & arrayTemp2 (6), cLoggingLevel0, False
                                     WriteToLogFile objFileHandle, "   This may cause some operations to fail!", cLoggingLevel0, False
                                     WriteToLogFile objFileHandle, "   It is possible to fix this potential issue by editing the security descriptor and granting the modified right.", cLoggingLevel0, False
                                     If CInt (arrayTemp2 (1)) <> cWMINameSpaceSD Then
                                        WriteToLogFile objFileHandle, "   For DCOM objects, this can be done with 'DCOMCNFG.EXE'.", cLoggingLevel0, False
                                     Else
                                        WriteToLogFile objFileHandle, "   For WMI namespaces, this can be done with 'WMIMGMT.MSC'.", cLoggingLevel0, False
                                     End If
                                     If intSecurityType = cSecurityDefaulted Then
                                        WriteToLogFile objFileHandle, "Note: WMIDiag has no specific knowledge of this WMI namespace.", cLoggingLevel0, False
                                        WriteToLogFile objFileHandle, "      The security diagnostic is based on the WMI namespace expected defaults.", cLoggingLevel0, False
                                        WriteToLogFile objFileHandle, "      A specific WMI application can always require a security setup different", cLoggingLevel0, False 
                                        WriteToLogFile objFileHandle, "      than the WMI security defaults.", cLoggingLevel0, False
                                     End If 
                                     WriteToLogFile objFileHandle, "", cLoggingLevel0, False
                                  End If

                             Case "INVALIDACE"
                                  WriteToLogFile objFileHandle, Space (5) & "  - ACE:", cLoggingLevel0, False            
                                  DisplaySecurityData objFileHandle, "    ACEType:  ", arrayTemp2 (3), cLoggingLevel0
                                  DisplaySecurityData objFileHandle, "    ACEFlags: ", arrayTemp2 (4), cLoggingLevel0
                                  DisplaySecurityData objFileHandle, "    ACEMask:  ", arrayTemp2 (5), cLoggingLevel0
                                  WriteToLogFile objFileHandle, "", cLoggingLevel0, False
                                  WriteToLogFile objFileHandle, "=> This ACE is invalid. This may cause the Windows security validation to fail (AccessCheck)!", cLoggingLevel0, False
                                  WriteToLogFile objFileHandle, "   It is possible to fix this issue by removing the invalid ACE and recreating it.", cLoggingLevel0, False
                                  If CInt (arrayTemp2 (1)) <> cWMINameSpaceSD Then
                                     WriteToLogFile objFileHandle, "   For DCOM objects, this can be done with 'DCOMCNFG.EXE'.", cLoggingLevel0, False
                                  Else
                                     WriteToLogFile objFileHandle, "   For WMI namespaces, this can be done with 'WMIMGMT.MSC'.", cLoggingLevel0, False
                                  End If
                                  WriteToLogFile objFileHandle, "", cLoggingLevel0, False
   
                             Case "ADDED"
                                  If CInt (arrayTemp2 (7)) = cLoggingLevel2 Or boolLoggingDebug = True Then
                                     WriteToLogFile objFileHandle, Space (5) & "  - ADDED ACE:", cLoggingLevel0, False            
                                     DisplaySecurityData objFileHandle, "    ACEType:  ", arrayTemp2 (3), cLoggingLevel0
                                     DisplaySecurityData objFileHandle, "    ACEFlags: ", arrayTemp2 (4), cLoggingLevel0
                                     DisplaySecurityData objFileHandle, "    ACEMask:  ", arrayTemp2 (5), cLoggingLevel0
                                     WriteToLogFile objFileHandle, "", cLoggingLevel0, False

                                     If CInt (arrayTemp2 (7)) = cLoggingLevel2 Then
                                        WriteToLogFile objFileHandle, "=> The ADDED ACE is an access DENIED ACE for the trustee, which may cause operations to fail!", cLoggingLevel0, False
                                        WriteToLogFile objFileHandle, "   It is possible to fix this potential issue by editing the security descriptor and granting the modified right.", cLoggingLevel0, False
                                        If CInt (arrayTemp2 (1)) <> cWMINameSpaceSD Then
                                           WriteToLogFile objFileHandle, "   For DCOM objects, this can be done with 'DCOMCNFG.EXE'.", cLoggingLevel0, False
                                        Else
                                           WriteToLogFile objFileHandle, "   For WMI namespaces, this can be done with 'WMIMGMT.MSC'.", cLoggingLevel0, False
                                        End If
                                        If intSecurityType = cSecurityDefaulted Then
                                           WriteToLogFile objFileHandle, "Note: WMIDiag has no specific knowledge of this WMI namespace.", cLoggingLevel0, False
                                           WriteToLogFile objFileHandle, "      The security diagnostic is based on the WMI namespace expected defaults.", cLoggingLevel0, False
                                           WriteToLogFile objFileHandle, "      A specific WMI application can always require a security setup different", cLoggingLevel0, False 
                                           WriteToLogFile objFileHandle, "      than the WMI security defaults.", cLoggingLevel0, False
                                        End If 
                                        WriteToLogFile objFileHandle, "", cLoggingLevel0, False
                                     End If
                                  End If
   
                             Case "REMOVED"
                                  WriteToLogFile objFileHandle, Space (5) & "  - REMOVED ACE:", cLoggingLevel0, False            
                                  DisplaySecurityData objFileHandle, "    ACEType:  ", arrayTemp2 (3), cLoggingLevel0
                                  DisplaySecurityData objFileHandle, "    ACEFlags: ", arrayTemp2 (4), cLoggingLevel0
                                  DisplaySecurityData objFileHandle, "    ACEMask:  ", arrayTemp2 (5), cLoggingLevel0
                                  WriteToLogFile objFileHandle, "", cLoggingLevel0, False
                                  WriteToLogFile objFileHandle, "=> The REMOVED ACE was part of the DEFAULT setup for the trustee.", cLoggingLevel0, False
                                  WriteToLogFile objFileHandle, "   Removing default security will cause some operations to fail!", cLoggingLevel0, False
                                  WriteToLogFile objFileHandle, "   It is possible to fix this issue by editing the security descriptor and adding the ACE.", cLoggingLevel0, False
                                  If CInt (arrayTemp2 (1)) <> cWMINameSpaceSD Then
                                     WriteToLogFile objFileHandle, "   For DCOM objects, this can be done with 'DCOMCNFG.EXE'.", cLoggingLevel0, False
                                  Else
                                     WriteToLogFile objFileHandle, "   For WMI namespaces, this can be done with 'WMIMGMT.MSC'.", cLoggingLevel0, False
                                  End If
                                  If intSecurityType = cSecurityDefaulted Then
                                     WriteToLogFile objFileHandle, "Note: WMIDiag has no specific knowledge of this WMI namespace.", cLoggingLevel0, False
                                     WriteToLogFile objFileHandle, "      The security diagnostic is based on the WMI namespace expected defaults.", cLoggingLevel0, False
                                     WriteToLogFile objFileHandle, "      A specific WMI application can always require a security setup different", cLoggingLevel0, False 
                                     WriteToLogFile objFileHandle, "      than the WMI security defaults.", cLoggingLevel0, False
                                  End If 
                                  WriteToLogFile objFileHandle, "", cLoggingLevel0, False 
                      End Select
                   End If 
               Next
            End If

            DumpCSV intDCOMSecurityErrors, "DCOMSecurityErrors", 1, boolDump
            DumpCSV intDCOMSecurityWarnings, "DCOMSecurityWarnings", 1, boolDump
            DumpCSV intWMISecurityErrors, "WMISecurityErrors", 1, boolDump
            DumpCSV intWMISecurityWarnings, "WMISecurityWarnings", 1, boolDump

            If (intDCOMSecurityWarnings + intDCOMSecurityErrors + intWMISecurityWarnings + intWMISecurityErrors) > 0 Or _
               boolLoggingDebug = True Then 
               WriteToLogFile objFileHandle, "", cLoggingLevel0, False 
               StatusWriteToLogFile objFileHandle, "DCOM security warning(s) detected", intDCOMSecurityWarnings, cLoggingLevel0, False
               StatusWriteToLogFile objFileHandle, "DCOM security error(s) detected", intDCOMSecurityErrors, cLoggingLevel0, False
 
               StatusWriteToLogFile objFileHandle, "WMI security warning(s) detected", intWMISecurityWarnings, cLoggingLevel0, False
               StatusWriteToLogFile objFileHandle, "WMI security error(s) detected", intWMISecurityErrors, cLoggingLevel0, False
               WriteToLogFile objFileHandle, "", cLoggingLevel0, False
            End If 

            If intDCOMSecurityErrors > intDCOMSecurityWarnings Then
               StatusWriteToLogFile objFileHandle, "Overall DCOM security status", "ERROR!", cLoggingLevel1, False
            Else
               If intDCOMSecurityWarnings > 0 Then 
                  StatusWriteToLogFile objFileHandle, "Overall DCOM security status", "WARNING!", cLoggingLevel2, False
               Else
                  StatusWriteToLogFile objFileHandle, "Overall DCOM security status", "OK", cLoggingLevel0, False
               End If
            End If 

            If intWMISecurityErrors > intWMISecurityWarnings Then
               StatusWriteToLogFile objFileHandle, "Overall WMI security status", "ERROR!", cLoggingLevel1, False
            Else
               If intWMISecurityWarnings > 0 Then 
                  StatusWriteToLogFile objFileHandle, "Overall WMI security status", "WARNING!", cLoggingLevel2, False
               Else
                  StatusWriteToLogFile objFileHandle, "Overall WMI security status", "OK", cLoggingLevel0, False
               End If
            End If 
         Else
            DumpCSV " ", "DCOMSecurityErrors", 1, boolDump
            DumpCSV " ", "DCOMSecurityWarnings", 1, boolDump
            DumpCSV " ", "WMISecurityErrors", 1, boolDump
            DumpCSV " ", "WMISecurityWarnings", 1, boolDump

            StatusWriteToLogFile objFileHandle, "Overall security status", "NOT TESTED", cLoggingLevel0, False
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function DisplaySecurityData (ByVal objFileHandle, ByVal strLabel, ByVal arrayData, ByVal intLoggingLevel)

         Dim arrayTemp, intIndex

         On Error Resume Next         

         arrayTemp = ConvertStringInArray (arrayData, " ")
         WriteToLogFile objFileHandle, Space (5) & strLabel & arrayTemp (0), intLoggingLevel, False
         For intIndex = 1 To UBound (arrayTemp)
             WriteToLogFile objFileHandle, "                   " & arrayTemp (intIndex), intLoggingLevel, False
         Next

End Function

' --------------------------------------------------------------------------------------------------------
Function AnalyzeWMIOperationErrors (ByVal objFileHandle, ByVal boolDump)

         Dim strTemp1, arrayTemp1, arrayTemp2, intIndex, intCount
         Dim strPerformanceClass
         Dim boolEventLogEvents

         On Error Resume Next         

         WriteToLogFile objFileHandle, "- Started at '" & strBaseNamespace & "' " & String (130 - Len (strBaseNamespace) - 16, "-"), cLoggingLevel0, False

         AnalyzeWMIOperationErrors = False

         If Len (TrackingData.PermanentSubscriptions) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.PermanentSubscriptions, ",")
            StatusWriteToLogFile objFileHandle, "INFO: WMI permanent SUBSCRIPTION(S)", UBound (arrayTemp1) + 1, cLoggingLevel0, False
            DumpCSV UBound (arrayTemp1) + 1, "WMIPermanentSubscriptions", 1, boolDump
            For Each strTemp1 In arrayTemp1
                arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                WriteToLogFile objFileHandle, "- " & arrayTemp2 (0) & ", " & arrayTemp2 (1) & ".", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "  '" & arrayTemp2 (2) & "'", cLoggingLevel0, False
            Next
            WriteToLogFile objFileHandle, "", cLoggingLevel0, False
         Else 
            DumpCSV 0, "WMIPermanentSubscriptions", 1, boolDump
            StatusWriteToLogFile objFileHandle, "WMI permanent SUBSCRIPTION(S)", "NONE", cLoggingLevel0, False
         End If

         If Len (TrackingData.TimerInstructions) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.TimerInstructions, ",")
            StatusWriteToLogFile objFileHandle, "INFO: WMI TIMER instruction(s)", UBound (arrayTemp1) + 1, cLoggingLevel0, False
            DumpCSV UBound (arrayTemp1) + 1, "WMITimerInstructions", 1, boolDump
            For Each strTemp1 In arrayTemp1
                arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                WriteToLogFile objFileHandle, "- " & arrayTemp2 (0) & ": " & arrayTemp2 (1) & ", '" & arrayTemp2 (2) & "', " & arrayTemp2 (3) & "'.", cLoggingLevel0, False
            Next
            WriteToLogFile objFileHandle, "", cLoggingLevel0, False
         Else 
            DumpCSV 0, "WMITimerInstructions", 1, boolDump
            StatusWriteToLogFile objFileHandle, "WMI TIMER instruction(s)", "NONE", cLoggingLevel0, False
         End If

         If Len (TrackingData.ADAPStatus) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.ADAPStatus, ";")
            If arrayTemp1 (3) < 1 Then 
               StatusWriteToLogFile objFileHandle, "WMI ADAP status", arrayTemp1 (3), cLoggingLevel2, False
               WriteToLogFile objFileHandle, "=> " & arrayTemp1 (2), cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   You can start the WMI AutoDiscovery/AutoPurge (ADAP) process to resynchronize", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   the performance counters with the WMI performance classes with the following commands:", cLoggingLevel0, False

               WriteToLogFile objFileHandle, "   i.e. 'WINMGMT.EXE /CLEARADAP'", cLoggingLevel0, False
               If RunTimeEnvironmentInfo.OSIdentifier =< cWindows2000SP4 then
                  WriteToLogFile objFileHandle, "   i.e. 'WINMGMT.EXE /RESYNCPERF <PID_of_WINMGMT.EXE>'", cLoggingLevel0, False
               End If
               If RunTimeEnvironmentInfo.OSIdentifier > cWindows2000SP4 then
                  WriteToLogFile objFileHandle, "   i.e. 'WINMGMT.EXE /RESYNCPERF'", cLoggingLevel0, False
               End If
               WriteToLogFile objFileHandle, "   The ADAP process logs informative events in the Windows NT event log.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   More information can be found on MSDN at:", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   http://msdn.microsoft.com/library/default.asp?url=/library/en-us/wmisdk/wmi/wmi_adap_event_log_events.asp", cLoggingLevel0, False

               If intWMICriticalityLevel <> cLoggingLevel1 Then intWMICriticalityLevel = cLoggingLevel2
            Else
               If arrayTemp1 (3) < 4 Then 
                  StatusWriteToLogFile objFileHandle, "INFO: WMI ADAP status", arrayTemp1 (3), cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "=> " & arrayTemp1 (2), cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   Some WMI performance classes could be missing at the time WMIDiag was executed.", cLoggingLevel0, False
               Else
                  StatusWriteToLogFile objFileHandle, "WMI ADAP status", "OK", cLoggingLevel0, False
               End If
            End If

            DumpCSV arrayTemp1 (3), "ADAPStatus", 1, boolDump
         Else 
            If RunTimeEnvironmentInfo.OSIdentifier >= cWindowsVistaRTM Then
               DumpCSV " ", "ADAPStatus", 1, boolDump
            Else
               StatusWriteToLogFile objFileHandle, "WMI ADAP status", "NOT AVAILABLE", cLoggingLevel1, False
               If Instr (TrackingData.InvalidWMIServiceSetup, "DISABLED") = 0 Then
                  WriteToLogFile objFileHandle, "   You can start the WMI AutoDiscovery/AutoPurge (ADAP) process to resynchronize", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   the performance counters with the WMI performance classes with the following commands:", cLoggingLevel0, False
   
                  WriteToLogFile objFileHandle, "   i.e. 'WINMGMT.EXE /CLEARADAP'", cLoggingLevel0, False
                  If RunTimeEnvironmentInfo.OSIdentifier =< cWindows2000SP4 then
                     WriteToLogFile objFileHandle, "   i.e. 'WINMGMT.EXE /RESYNCPERF <PID_of_WINMGMT.EXE>'", cLoggingLevel0, False
                  End If
                  If RunTimeEnvironmentInfo.OSIdentifier > cWindows2000SP4 then
                     WriteToLogFile objFileHandle, "   i.e. 'WINMGMT.EXE /RESYNCPERF'", cLoggingLevel0, False
                  End If
                  WriteToLogFile objFileHandle, "   The ADAP process logs informative events in the Windows NT event log.", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   More information can be found on MSDN at:", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   http://msdn.microsoft.com/library/default.asp?url=/library/en-us/wmisdk/wmi/wmi_adap_event_log_events.asp", cLoggingLevel0, False
               End If

               DumpCSV "N/A", "ADAPStatus", 1, boolDump

               intWMICriticalityLevel = cLoggingLevel1
            End If
         End If

         If Len (TrackingData.RequiresEncryption) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.RequiresEncryption, ",")
            StatusWriteToLogFile objFileHandle, "INFO: WMI namespace(s) requiring PACKET PRIVACY", UBound (arrayTemp1) + 1 & " NAMESPACE(S)!", cLoggingLevel0, False
            DumpCSV UBound (arrayTemp1) + 1, "RequiresEncryption", 1, boolDump
            For Each strTemp1 In arrayTemp1
                arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                WriteToLogFile objFileHandle, "- " & arrayTemp2 (0) & ".", cLoggingLevel0, False
            Next

            WriteToLogFile objFileHandle, "=> When remotely connecting, the namespace(s) listed require(s) the WMI client to", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   use an encrypted connection by specifying the PACKET PRIVACY authentication level.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   (RPC_C_AUTHN_LEVEL_PKT_PRIVACY or PktPrivacy flags)", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   i.e. 'WMIC.EXE /NODE:" & Chr(34) & RunTimeEnvironmentInfo.LocalComputerName & Chr(34) & " /AUTHLEVEL:Pktprivacy /NAMESPACE:\\" & ReplaceString (arrayTemp2 (0), "/", "\") & " Class __SystemSecurity'", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "", cLoggingLevel0, False
         Else 
            DumpCSV 0, "RequiresEncryption", 1, boolDump
         End If

         If Len (TrackingData.WMIMonikerConnectionErrors) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.WMIMonikerConnectionErrors, ",")
            StatusWriteToLogFile objFileHandle, "WMI MONIKER CONNECTION errors occured for the following namespaces", UBound (arrayTemp1) + 1 & " ERROR(S)!", cLoggingLevel1, False
            DumpCSV UBound (arrayTemp1) + 1, "WMIMonikerConnectionErrors", 1, boolDump
            For Each strTemp1 In arrayTemp1
                arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                WriteToLogFile objFileHandle, "- " & arrayTemp2 (0) & ", " & arrayTemp2 (1) & " - " & arrayTemp2 (2) & ".", cLoggingLevel0, False
                CountWMIErrorMessage arrayTemp2 (1)
            Next
            WriteToLogFile objFileHandle, "", cLoggingLevel0, False

            intWMICriticalityLevel = cLoggingLevel1
         Else 
            DumpCSV 0, "WMIMonikerConnectionErrors", 1, boolDump
            StatusWriteToLogFile objFileHandle, "WMI MONIKER CONNECTIONS", "OK", cLoggingLevel0, False
         End If

         If Len (TrackingData.WMIConnectionErrors) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.WMIConnectionErrors, ",")
            StatusWriteToLogFile objFileHandle, "WMI CONNECTION errors occured for the following namespaces", UBound (arrayTemp1) + 1 & " ERROR(S)!", cLoggingLevel1, False
            DumpCSV UBound (arrayTemp1) + 1, "WMIConnectionErrors", 1, boolDump
            For Each strTemp1 In arrayTemp1
                arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                WriteToLogFile objFileHandle, "- " & arrayTemp2 (0) & ", " & arrayTemp2 (1) & " - " & arrayTemp2 (2) & ".", cLoggingLevel0, False
                CountWMIErrorMessage arrayTemp2 (1)
            Next
            WriteToLogFile objFileHandle, "", cLoggingLevel0, False

            intWMICriticalityLevel = cLoggingLevel1
         Else 
            DumpCSV 0, "WMIConnectionErrors", 1, boolDump
            StatusWriteToLogFile objFileHandle, "WMI CONNECTIONS", "OK", cLoggingLevel0, False
         End If

         If Len (TrackingData.WMIGetErrors) > 0 Then
            arrayTemp1 = ConvertStringInArray (TrackingData.WMIGetErrors, ",")
            StatusWriteToLogFile objFileHandle, "WMI GET operation errors reported", UBound (arrayTemp1) + 1 & " ERROR(S)!", cLoggingLevel1, False
            DumpCSV UBound (arrayTemp1) + 1, "WMIGetErrors", 1, boolDump
            For Each strTemp1 In arrayTemp1
                arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                WriteToLogFile objFileHandle, "- " & arrayTemp2 (0) & ", " & arrayTemp2 (1) & ", " & arrayTemp2 (2) & " - " & arrayTemp2 (3) & ".", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "  MOF Registration: '" & LocateWMIProviderData (objLOGFileHandle, arrayTemp2 (1), cWMIClassName, cWMIProviderMOF) & "'", cLoggingLevel0, False

                CountWMIErrorMessage arrayTemp2 (2)

                If Instr (Ucase (arrayTemp2 (1)), "WIN32_PERF") > 0 Then
                   strPerformanceClass = arrayTemp2 (1)
                End If
            Next

            If Len (strPerformanceClass) > 0 Then
               If RunTimeEnvironmentInfo.OSIdentifier < cWindowsVistaRTM Then 
                  WriteToLogFile objFileHandle, "=> When a WMI performance class is missing (i.e. '" & strPerformanceClass & "'), it is generally due to", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   a synchronization issue between the performance counters and WMI.", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   The AutoDiscovery/AutoPurge (ADAP) process logs informative events in the Windows NT event log.", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   More information can be found on MSDN at:", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   http://msdn.microsoft.com/library/default.asp?url=/library/en-us/wmisdk/wmi/wmi_adap_event_log_events.asp", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "", cLoggingLevel0, False

                  If Len (TrackingData.ADAPStatus) > 0 Then
                     arrayTemp1 = ConvertStringInArray (TrackingData.ADAPStatus, ";")
                     WriteToLogFile objFileHandle, "   - The last time the ADAP process was STARTED was the '" & arrayTemp1 (0) & "'.", cLoggingLevel0, False
                     WriteToLogFile objFileHandle, "   - The last time the ADAP process was STOPPED was the '" & arrayTemp1 (1) & "'.", cLoggingLevel0, False
                     WriteToLogFile objFileHandle, "   - The latest ADAP process status is '" & arrayTemp1 (2) & "'.", cLoggingLevel0, False
                     WriteToLogFile objFileHandle, "", cLoggingLevel0, False
                  Else
                     WriteToLogFile objFileHandle, "   - WMIDiag was unable to find the latest WMI ADAP status.", cLoggingLevel0, False
                  End If
                  WriteToLogFile objFileHandle, "   You can attempt to resynchronize the WMI performance classes with the existing Windows", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   performance counters with the following commands:", cLoggingLevel0, False
   
                  WriteToLogFile objFileHandle, "   i.e. 'WINMGMT.EXE /CLEARADAP'", cLoggingLevel0, False
                  If RunTimeEnvironmentInfo.OSIdentifier =< cWindows2000SP4 then
                     WriteToLogFile objFileHandle, "   i.e. 'WINMGMT.EXE /RESYNCPERF <PID_of_WINMGMT.EXE>'", cLoggingLevel0, False
                  End If
                  If RunTimeEnvironmentInfo.OSIdentifier > cWindows2000SP4 And RunTimeEnvironmentInfo.OSIdentifier < cWindowsVistaRTM then
                     WriteToLogFile objFileHandle, "   i.e. 'WINMGMT.EXE /RESYNCPERF'", cLoggingLevel0, False
                  End If
               Else
                  WriteToLogFile objFileHandle, "=> When a WMI performance class is missing (i.e. '" & strPerformanceClass & "'), it is generally due to", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   a lack of buffer refresh of the WMI class provider exposing the WMI performance counters.", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   You can refresh the WMI class provider buffer with the following command:", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   i.e. 'WINMGMT.EXE /SYNCPERF'", cLoggingLevel0, False
               End If
            End If
            WriteToLogFile objFileHandle, "", cLoggingLevel0, False

            intWMICriticalityLevel = cLoggingLevel1
         Else 
            StatusWriteToLogFile objFileHandle, "WMI GET operations", "OK", cLoggingLevel0, False
            DumpCSV 0, "WMIGetErrors", 1, boolDump
         End If

         If Len (TrackingData.FailingMOFRepresentation) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.FailingMOFRepresentation, ",")
            StatusWriteToLogFile objFileHandle, "WMI MOF representation errors reported", UBound (arrayTemp1) + 1 & " ERROR(S)!", cLoggingLevel1, False
            DumpCSV UBound (arrayTemp1) + 1, "WMIMOFRepresentationErrors", 1, boolDump
            For Each strTemp1 In arrayTemp1
                arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                WriteToLogFile objFileHandle, "- " & arrayTemp2 (0) & ", " & arrayTemp2 (1) & ".", cLoggingLevel0, False
            Next
            WriteToLogFile objFileHandle, "", cLoggingLevel0, False

            intWMICriticalityLevel = cLoggingLevel1
         Else 
            StatusWriteToLogFile objFileHandle, "WMI MOF representations", "OK", cLoggingLevel0, False
            DumpCSV 0, "WMIMOFRepresentationErrors", 1, boolDump
         End If

         If Len (TrackingData.QualifierAccessError) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.QualifierAccessError, ",")
            StatusWriteToLogFile objFileHandle, "WMI QUALIFIERS access operation errors reported", UBound (arrayTemp1) + 1 & " ERROR(S)!", cLoggingLevel1, False
            DumpCSV UBound (arrayTemp1) + 1, "QualifierAccessError", 1, boolDump
            For Each strTemp1 In arrayTemp1
                arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                WriteToLogFile objFileHandle, "- " & arrayTemp2 (0) & ", " & arrayTemp2 (1) & ", " & arrayTemp2 (2) & " - " & arrayTemp2 (3) & ".", cLoggingLevel0, False
                CountWMIErrorMessage arrayTemp2 (2)
            Next
            WriteToLogFile objFileHandle, "", cLoggingLevel0, False

            intWMICriticalityLevel = cLoggingLevel1
         Else
            StatusWriteToLogFile objFileHandle, "WMI QUALIFIER access operations", "OK", cLoggingLevel0, False
            DumpCSV 0, "QualifierAccessError", 1, boolDump
         End If

         If Len (TrackingData.WMIEnumerationErrors) > 0 Then
            arrayTemp1 = ConvertStringInArray (TrackingData.WMIEnumerationErrors, ",")
            If Instr (UCase (TrackingData.WMIEnumerationErrors), UCase (";" & cCritical)) > 0 Then
               StatusWriteToLogFile objFileHandle, "WMI ENUMERATION operation errors reported", UBound (arrayTemp1) + 1 & " ERROR(S)!", cLoggingLevel1, False
               intWMICriticalityLevel = cLoggingLevel1
            Else 
               StatusWriteToLogFile objFileHandle, "WMI ENUMERATION operation errors reported", UBound (arrayTemp1) + 1 & " WARNING(S)!", cLoggingLevel2, False
               If intWMICriticalityLevel <> cLoggingLevel1 Then intWMICriticalityLevel = cLoggingLevel2
            End If 
            DumpCSV UBound (arrayTemp1) + 1, "WMIEnumerationErrors", 1, boolDump
            For Each strTemp1 In arrayTemp1
                arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                Select Case arrayTemp2 (4) 
                       Case "NOINSTANCE"
                             WriteToLogFile objFileHandle, "- " & arrayTemp2 (0) & ", " & arrayTemp2 (1) & ", '" & arrayTemp2 (2) & "' did not return any instance while AT LEAST 1 instance is expected.", cLoggingLevel0, False
                             WriteToLogFile objFileHandle, "  MOF Registration: '" & LocateWMIProviderData (objLOGFileHandle, arrayTemp2 (2), cWMIClassName, cWMIProviderMOF) & "'", cLoggingLevel0, False
                       Case Else
                             WriteToLogFile objFileHandle, "- " & arrayTemp2 (0) & ", " & arrayTemp2 (1) & ", '" & arrayTemp2 (2) & "', " & arrayTemp2 (4) & " - " & arrayTemp2 (5) & ".", cLoggingLevel0, False
                             WriteToLogFile objFileHandle, "  MOF Registration: '" & LocateWMIProviderData (objLOGFileHandle, arrayTemp2 (2), cWMIClassName, cWMIProviderMOF) & "'", cLoggingLevel0, False
                             CountWMIErrorMessage arrayTemp2 (4)
                End Select
            Next
            WriteToLogFile objFileHandle, "", cLoggingLevel0, False
         Else 
            DumpCSV 0, "WMIEnumerationErrors", 1, boolDump
         End If

         If Len (TrackingData.WMIEnumerationSkipped) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.WMIEnumerationSkipped , ",")
            StatusWriteToLogFile objFileHandle, "WMI ENUMERATION operations SKIPPED", UBound (arrayTemp1) + 1 & " WARNING(S)!", cLoggingLevel2, False
            DumpCSV UBound (arrayTemp1) + 1, "WMIEnumerationSkipped", 1, boolDump
            For Each strTemp1 In arrayTemp1
                arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                WriteToLogFile objFileHandle, "- " & arrayTemp2 (0) & ", " & arrayTemp2 (1) & ", " & arrayTemp2 (2) & ", " & arrayTemp2 (3) & ".", cLoggingLevel0, False
            Next

            WriteToLogFile objFileHandle, "=> ENUMERATION operations are skipped because the WMI provider (i.e. '" & arrayTemp2 (1) & "') supporting", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   the WMI class (i.e. '" & arrayTemp2 (3) & "') has registration issues.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   (as listed previously in this report)", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "", cLoggingLevel0, False

            If intWMICriticalityLevel <> cLoggingLevel1 Then intWMICriticalityLevel = cLoggingLevel2
         Else 
            DumpCSV 0, "WMIEnumerationSkipped", 1, boolDump
         End If

         If Len (TrackingData.WMIEnumerationErrors) = 0 And _
            Len (TrackingData.WMIEnumerationSkipped ) = 0 Then 
            StatusWriteToLogFile objFileHandle, "WMI ENUMERATION operations", "OK", cLoggingLevel0, False
         End If 

         If Len (TrackingData.WMIExecQueryErrors) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.WMIExecQueryErrors, ",")
            If Instr (UCase (TrackingData.WMIExecQueryErrors), UCase (";" & cCritical)) > 0 Then
               StatusWriteToLogFile objFileHandle, "WMI EXECQUERY operation errors reported", UBound (arrayTemp1) + 1 & " ERROR(S)!", cLoggingLevel1, False
               intWMICriticalityLevel = cLoggingLevel1
            Else
               StatusWriteToLogFile objFileHandle, "WMI EXECQUERY operation errors reported", UBound (arrayTemp1) + 1 & " WARNING(S)!", cLoggingLevel2, False
               If intWMICriticalityLevel <> cLoggingLevel1 Then intWMICriticalityLevel = cLoggingLevel2
            End If 
            DumpCSV UBound (arrayTemp1) + 1, "WMIExecQueryErrors", 1, boolDump
            For Each strTemp1 In arrayTemp1
                arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                If CInt (arrayTemp2 (2)) = cIWarning Then
                   WriteToLogFile objFileHandle, "- " & arrayTemp2 (0) & ", '" & arrayTemp2 (1) & "' returned instances while NO instance is expected.", cLoggingLevel0, False                   
                Else
                   If arrayTemp2 (3) = "NOINSTANCE" Then
                      WriteToLogFile objFileHandle, "- " & arrayTemp2 (0) & ", '" & arrayTemp2 (1) & "' did not return any instance while AT LEAST 1 instance is expected.", cLoggingLevel0, False
                   Else
                      WriteToLogFile objFileHandle, "- " & arrayTemp2 (0) & ", " & arrayTemp2 (1) & ", " & arrayTemp2 (3) & " - " & arrayTemp2 (4) & ".", cLoggingLevel0, False
                      CountWMIErrorMessage arrayTemp2 (3)
                   End If
                End If
            Next
            WriteToLogFile objFileHandle, "", cLoggingLevel0, False
         Else
            DumpCSV 0, "WMIExecQueryErrors", 1, boolDump
         End If

         If Len (TrackingData.WMIExecQuerySkipped) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.WMIExecQuerySkipped, ",")
            StatusWriteToLogFile objFileHandle, "WMI EXECQUERY operations SKIPPED", UBound (arrayTemp1) + 1 & " WARNING(S)!", cLoggingLevel2, False
            DumpCSV UBound (arrayTemp1) + 1, "WMIExecQuerySkipped", 1, boolDump
            For Each strTemp1 In arrayTemp1
                arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                WriteToLogFile objFileHandle, "- " & arrayTemp2 (0) & ", " & arrayTemp2 (1) & ", " & arrayTemp2 (2) & ".", cLoggingLevel0, False
            Next

            WriteToLogFile objFileHandle, "=> EXECQUERY operations are skipped because the WMI provider (i.e. '" & arrayTemp2 (1) & "') supporting", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   the WMI class contained in the WQL query (i.e. '" & arrayTemp2 (3) & "') has registration issues.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   (as listed previously in this report)", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "", cLoggingLevel0, False

            If intWMICriticalityLevel <> cLoggingLevel1 Then intWMICriticalityLevel = cLoggingLevel2
         Else
            DumpCSV 0, "WMIExecQuerySkipped", 1, boolDump
         End If

         If Len (TrackingData.WMIExecQueryErrors) = 0 And _
            Len (TrackingData.WMIExecQuerySkipped) = 0 Then 
            StatusWriteToLogFile objFileHandle, "WMI EXECQUERY operations", "OK", cLoggingLevel0, False
         End If 

         If Len (TrackingData.WMIGetValuePropertyErrors) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.WMIGetValuePropertyErrors, ",")
            If Instr (UCase (TrackingData.WMIGetValuePropertyErrors), UCase (";" & cCritical)) > 0 Then
               StatusWriteToLogFile objFileHandle, "WMI GET VALUE operation errors reported", UBound (arrayTemp1) + 1 & " ERROR(S)!", cLoggingLevel1, False
               intWMICriticalityLevel = cLoggingLevel1
            Else
               StatusWriteToLogFile objFileHandle, "WMI GET VALUE operation errors reported", UBound (arrayTemp1) + 1 & " WARNING(S)!", cLoggingLevel2, False
               If intWMICriticalityLevel <> cLoggingLevel1 Then intWMICriticalityLevel = cLoggingLevel2
            End If

            DumpCSV UBound (arrayTemp1) + 1, "WMIGetValuePropertyErrors", 1, boolDump
            For Each strTemp1 In arrayTemp1
                arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                WriteToLogFile objFileHandle, "- " & arrayTemp2 (0) & ", Instance: " & arrayTemp2 (1) & ", Property: " & arrayTemp2 (2) & "='" & arrayTemp2 (3) & "' (Expected default='" & arrayTemp2 (4) & "').", cLoggingLevel0, False
            Next
            WriteToLogFile objFileHandle, "", cLoggingLevel0, False
         Else
            DumpCSV 0, "WMIGetValuePropertyErrors", 1, boolDump
         End If

         If Len (TrackingData.WMIGetValuePropertySkipped) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.WMIGetValuePropertySkipped, ",")
            StatusWriteToLogFile objFileHandle, "WMI GET VALUE operations SKIPPED", UBound (arrayTemp1) + 1 & " WARNING(S)!", cLoggingLevel2, False
            DumpCSV UBound (arrayTemp1) + 1, "WMIGetValuePropertySkipped", 1, boolDump
            For Each strTemp1 In arrayTemp1
                arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                WriteToLogFile objFileHandle, "- " & arrayTemp2 (0) & ", " & arrayTemp2 (1) & ", " & arrayTemp2 (2) & ".", cLoggingLevel0, False
            Next

            WriteToLogFile objFileHandle, "=> GET VALUE operations are skipped because the WMI provider (i.e. '" & arrayTemp2 (1) & "') supporting", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   the WMI class instance (i.e. '" & arrayTemp2 (2) & "') has registration issues.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "   (as listed previously in this report)", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "", cLoggingLevel0, False

            If intWMICriticalityLevel <> cLoggingLevel1 Then intWMICriticalityLevel = cLoggingLevel2
         Else 
            DumpCSV 0, "WMIGetValuePropertySkipped", 1, boolDump
         End If

         If Len (TrackingData.WMIGetValuePropertyErrors) = 0 And _
            Len (TrackingData.WMIGetValuePropertySkipped) = 0 Then
            StatusWriteToLogFile objFileHandle, "WMI GET VALUE operations", "OK", cLoggingLevel0, False
         End If

         If boolWriteInRepository Then
            If Len (TrackingData.WriteInRepository) > 0 Then 
               arrayTemp1 = ConvertStringInArray (TrackingData.WriteInRepository, ",")
               StatusWriteToLogFile objFileHandle, "WMI WRITE operation errors reported", UBound (arrayTemp1) + 1 & " ERROR(S)!", cLoggingLevel1, False
               DumpCSV UBound (arrayTemp1) + 1, "WriteInRepository", 1, boolDump
               For Each strTemp1 In arrayTemp1
                   arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                   If arrayTemp2 (3) = "WRONGCOUNTEDOBJECTS" Then
                      WriteToLogFile objFileHandle, "- " & arrayTemp2 (0) & ": " & arrayTemp2 (1) & ", " & arrayTemp2 (2) & " '" & cWriteInRepositoryClass & "' objects counted instead of " & cMaxInstances & "!", cLoggingLevel0, False
                   Else
                      WriteToLogFile objFileHandle, "- " & arrayTemp2 (0) & ": " & arrayTemp2 (1) & ", " & arrayTemp2 (2) & " - " & arrayTemp2 (3) & ".", cLoggingLevel0, False
                      CountWMIErrorMessage arrayTemp2 (2)
                   End If 
               Next
               WriteToLogFile objFileHandle, "", cLoggingLevel0, False
   
               intWMICriticalityLevel = cLoggingLevel1
            Else 
               If boolWriteOperationCompleted = True Then
                  StatusWriteToLogFile objFileHandle, "WMI WRITE operations", "OK", cLoggingLevel0, False
               Else
                  StatusWriteToLogFile objFileHandle, "WMI WRITE operations", "SKIPPED", cLoggingLevel2, False
                  If intWMICriticalityLevel <> cLoggingLevel1 Then intWMICriticalityLevel = cLoggingLevel2
               End If
               DumpCSV 0, "WriteInRepository", 1, boolDump
            End If
         Else
            StatusWriteToLogFile objFileHandle, "WMI WRITE operations", "NOT TESTED", cLoggingLevel0, False
            DumpCSV " ", "WriteInRepository", 1, boolDump
         End If

         If Len (TrackingData.WMIPutErrors) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.WMIPutErrors, ",")
            StatusWriteToLogFile objFileHandle, "WMI PUT operation errors reported", UBound (arrayTemp1) + 1 & " ERROR(S)!", cLoggingLevel1, False
            DumpCSV UBound (arrayTemp1) + 1, "WMIPutErrors", 1, boolDump
            For Each strTemp1 In arrayTemp1
                arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                WriteToLogFile objFileHandle, "- " & arrayTemp2 (0) & ", " & arrayTemp2 (1) & ", " & arrayTemp2 (2) & ", " & arrayTemp2 (3) & " - " & arrayTemp2 (4) & ".", cLoggingLevel0, False
                CountWMIErrorMessage arrayTemp2 (3)
            Next

            ' WBEM_E_PROVIDER_LOAD_FAILURE
            If arrayTemp2 (3) = "0x80041013" And arrayTemp2 (1) = "()" Then
               WriteToLogFile objFileHandle, "=> PUT operation failures returning 0x80041013 (WBEM_E_PROVIDER_LOAD_FAILURE) occur generally when", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   WMI client attempt the creation of a WMI class in a namespace where a WMI class provider is registered and", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   fails to load.", cLoggingLevel0, False
            End If 
            WriteToLogFile objFileHandle, "", cLoggingLevel0, False

            intWMICriticalityLevel = cLoggingLevel1
         Else 
            If boolWriteInRepository = True Then 
               StatusWriteToLogFile objFileHandle, "WMI PUT operations", "OK", cLoggingLevel0, False
               DumpCSV 0, "WMIPutErrors", 1, boolDump
            Else
               StatusWriteToLogFile objFileHandle, "WMI PUT operations", "NOT TESTED", cLoggingLevel0, False
               DumpCSV " ", "WMIPutErrors", 1, boolDump
            End If
         End If

         If Len (TrackingData.WMIDeleteErrors) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.WMIDeleteErrors, ",")
            StatusWriteToLogFile objFileHandle, "WMI DELETE operation errors reported", UBound (arrayTemp1) + 1 & " ERROR(S)!", cLoggingLevel1, False
            DumpCSV UBound (arrayTemp1) + 1, "WMIDeleteErrors", 1, boolDump
            For Each strTemp1 In arrayTemp1
                arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                WriteToLogFile objFileHandle, "- " & arrayTemp2 (0) & ", " & arrayTemp2 (1) & ", " & arrayTemp2 (2) & " - " & arrayTemp2 (3) & ".", cLoggingLevel0, False
                CountWMIErrorMessage arrayTemp2 (3)
            Next
            WriteToLogFile objFileHandle, "", cLoggingLevel0, False

            intWMICriticalityLevel = cLoggingLevel1
         Else 
            If boolWriteInRepository = True Then 
               StatusWriteToLogFile objFileHandle, "WMI DELETE operations", "OK", cLoggingLevel0, False
               DumpCSV 0, "WMIDeleteErrors", 1, boolDump
            Else
               StatusWriteToLogFile objFileHandle, "WMI DELETE operations", "NOT TESTED", cLoggingLevel0, False
               DumpCSV " ", "WMIDeleteErrors", 1, boolDump
            End If
         End If

         If intRequestAllInstances > 0 Then
            StatusWriteToLogFile objFileHandle, "WMI static instances retrieved", longStaticInstanceCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "WMI dynamic instances retrieved", longDynamicInstanceCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "WMI instance request cancellations (to limit performance impact)", longAsyncCancellationCounter, cLoggingLevel0, False
            DumpCSV longDynamicInstanceCounter, "DynamicInstances", 1, boolDump
            DumpCSV longStaticInstanceCounter, "StaticInstances", 1, boolDump 
            DumpCSV longAsyncCancellationCounter, "CancelRequests", 1, boolDump
         Else
            DumpCSV " ", "DynamicInstances", 1, boolDump
            DumpCSV " ", "StaticInstances", 1, boolDump
            DumpCSV " ", "CancelRequests", 1, boolDump
         End If

         WriteToLogFile objFileHandle, String (130, "-"), cLoggingLevel0, False

         If Len (TrackingData.WMIEventLogEventData) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.WMIEventLogEventData, ",")

            If arrayTemp1 (0) = "NTEVENTLOG_SKIPPED" Then
               StatusWriteToLogFile objFileHandle, "Event Log Events", "SKIPPED", cLoggingLevel0, False
               If intWMICriticalityLevel <> cLoggingLevel1 Then intWMICriticalityLevel = cLoggingLevel2

               DumpCSV " ", "COM_NTEventLog", 1, boolDump
               DumpCSV " ", "WMI_NTEventLog", 1, boolDump
               DumpCSV " ", "ADAP_NTEventLog", 1, boolDump

               DumpCSV " ", "COM_NTEventLog", 1, boolDump
               DumpCSV " ", "WMI_NTEventLog", 1, boolDump
               DumpCSV " ", "ADAP_NTEventLog", 1, boolDump
            Else
               WriteToLogFile objFileHandle, "# of Event Log events BEFORE WMIDiag execution since the last " & intOldestEVENTLogHistory & " day(s):", cLoggingLevel0, False
               boolEventLogEvents = False
               For Each strTemp1 In arrayTemp1
                   If InStr (strTemp1, "SYSTEM;") > 0 Then
                      arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                      StatusWriteToLogFile objFileHandle, "  " & arrayTemp2 (1), arrayTemp2 (3), cLoggingLevel0, False
                      If arrayTemp2 (3) > 0 Then boolEventLogEvents = True
                      DumpCSV arrayTemp2 (3), arrayTemp2 (1) & "_NTEventLog", 1, boolDump
                   End If 
                   If InStr (strTemp1, "SYSTEMERROR;") > 0 Then
                      arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                      StatusWriteToLogFile objFileHandle, "  " & arrayTemp2 (1), "ERROR!", cLoggingLevel0, False
                      intWMICriticalityLevel = cLoggingLevel1
                      DumpCSV "", arrayTemp2 (1) & "_NTEventLog", 1, boolDump
                   End If 
               Next
               If boolEventLogEvents = True Then 
                  WriteToLogFile objFileHandle, "=> Verify the WMIDiag LOG at line #" & arrayTemp2 (2) & " for more details.", cLoggingLevel0, False
               End If

               WriteToLogFile objFileHandle, "", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "# of additional Event Log events AFTER WMIDiag execution:", cLoggingLevel0, False
               boolEventLogEvents = False
               For Each strTemp1 In arrayTemp1
                   If InStr (strTemp1, "WMIDIAG;") > 0 Then
                      arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                      StatusWriteToLogFile objFileHandle, "  " & arrayTemp2 (1), arrayTemp2 (3), cLoggingLevel0, False
                      If arrayTemp2 (3) > 0 Then boolEventLogEvents = True
                      DumpCSV arrayTemp2 (3), arrayTemp2 (1) & "_NTEventLog", 1, boolDump
                   End If 
                   If InStr (strTemp1, "WMIDIAGERROR;") > 0 Then
                      arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                      StatusWriteToLogFile objFileHandle, "  " & arrayTemp2 (1), "ERROR!", cLoggingLevel0, False
                      DumpCSV "", arrayTemp2 (1) & "_NTEventLog", 1, boolDump
                   End If 
               Next
               If boolEventLogEvents = True Then 
                  WriteToLogFile objFileHandle, "=> Verify the WMIDiag LOG at line #" & arrayTemp2 (2) & " for more details.", cLoggingLevel2, False
                  If intWMICriticalityLevel <> cLoggingLevel1 Then intWMICriticalityLevel = cLoggingLevel2
               End If
            End If
         Else
            DumpCSV " ", "COM_NTEventLog", 1, boolDump
            DumpCSV " ", "WMI_NTEventLog", 1, boolDump
            DumpCSV " ", "ADAP_NTEventLog", 1, boolDump

            DumpCSV " ", "COM_NTEventLog", 1, boolDump
            DumpCSV " ", "WMI_NTEventLog", 1, boolDump
            DumpCSV " ", "ADAP_NTEventLog", 1, boolDump
         End If

         For intIndex = 0 To Ubound (WBEMError) - 1
             WriteToLogFile objFileHandle, "", cLoggingLevel0, False

             WriteToLogFile objFileHandle, WBEMError (intIndex).WBEMCounter & " error(s) " & _
                                           WBEMError (intIndex).WBEMError & " - (" & _
                                           WBEMError (intIndex).WBEMCode & ") " & _
                                           WBEMError (intIndex).WBEMMessage, cLoggingLevel0, False

             ' Typical insuficient privileges errors
             ' WBEM_E_ACCESS_DENIED
             If WBEMError (intIndex).WBEMError = "0x80041003" Then
                WriteToLogFile objFileHandle, "=> This error is typically due to insufficient or restricted permissions in the examined system.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "=> ENSURE you are a Full Administrator of the examined system, if the WMI provider or the ", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   WMI system security do not enforce any restrictions.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "", cLoggingLevel0, False
             End If

             ' Typical WMI system errors
             ' WBEM_E_FAILED 
             If WBEMError (intIndex).WBEMError = "0x80041001" Then
                WriteToLogFile objFileHandle, "=> This error is typically a WMI system error. WMI system errors can find their origins in:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - Failing WMI system components (see any missing WMI system files or DCOM registration", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "     issues previously mentioned).", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - Failing WMI providers (see any WMI provider DCOM registration", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "     issues previously mentioned).", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - Failing operation in WMI providers because the underlying component queried by the WMI", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "     provider is not available (i.e. not installed, not running or not available).", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - Corrupted WMI repository.", cLoggingLevel0, False
                If RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP2 Or _ 
		   RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP3 Then
                   WriteToLogFile objFileHandle, "     - Under Windows XP SP2 and SP3, you can validate the repository consistency", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "       by executing the following command:", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "       i.e. 'WMIDiag CheckConsistency'", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "     Note: Under Windows XP SP2 and SP3, when the repository is checked and detected INCONSISTENT,", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "           a new repository is automatically re-created based on Auto-Recovery mechanism.", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "           Note that some information can be lost during this process (i.e. static data, CIM registration).", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "           However, the original repository is located at '" & RunTimeEnvironmentInfo.WBem & "Repository.001'.", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "           The computer must be rebooted for the system to work with the re-created repository.", cLoggingLevel0, False
                Else
                   If RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP164 Or _
                      RunTimeEnvironmentInfo.OSIdentifier = cWindows2003SP1 Or _
                      RunTimeEnvironmentInfo.OSIdentifier = cWindows2003SP2 Or _
                      RunTimeEnvironmentInfo.OSIdentifier = cWindows2003SP264 Or _
                      RunTimeEnvironmentInfo.OSIdentifier = cWindows2003SP164 Then
                      WriteToLogFile objFileHandle, "     - Validating the repository consistency. Under Windows XP 64-bit SP1, Windows 2003 SP1 and Windows Vista, the", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "       repository consistency is ALWAYS verified.", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "       Under Windows XP SP2, the repository consistency must be explicitly requested:", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "       i.e. 'WMIDiag CheckConsistency''", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "       Check the state of the repository above in the WMIDiag report.", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "     Note: If the repository is inconsistent, it must be reconstructed.", cLoggingLevel0, False
                   Else
                      WriteToLogFile objFileHandle, "     - Validating the repository consistency. In such a case, you must rerun WMIDiag with 'WriteInRepository' parameter", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "       to validate the WMI repository operations.", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "     Note: ENSURE you are an administrator with FULL access to WMI EVERY namespaces of the computer before", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "           executing the WriteInRepository command. To write temporary data from the Root namespace, use:", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "           i.e. 'WMIDiag WriteInRepository=Root'", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "     - If the WriteInRepository command fails, while being an Administrator with ALL accesses to ALL namespaces", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "       the WMI repository must be reconstructed.", cLoggingLevel0, False
                   End If
                End If
                WriteToLogFile objFileHandle, "   Note: The WMI repository reconstruction requires to locate all MOF files needed to rebuild the repository,", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "         otherwise some applications may fail after the reconstruction.", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "         This can be achieved with the following command:", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "         i.e. 'WMIDiag ShowMOFErrors'", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "   Note: The repository reconstruction must be a LAST RESORT solution and ONLY after executing", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "         ALL fixes previously mentioned.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "Static information stored by external applications in the repository will be LOST! (i.e. SMS Inventory)", cLoggingLevel2, False
                WriteToLogFile objFileHandle, "", cLoggingLevel0, False
                boolWMISystemError = True
             End If

             ' Typical instance request errors
             ' WBEM_E_INVALID_METHOD
             If WBEMError (intIndex).WBEMError = "0x8004102E" Then
                WriteToLogFile objFileHandle, "=> This error is generally due to an invalid request to a WMI provider because", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   the provider expects some specific parameters to be specified before issuing", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   the request. This error is not actionable and can be perfectly normal depending on the", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   operation requested and the WMI provider returning the error", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   (i.e. SMS on a site server may return this error).", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "", cLoggingLevel0, False
             End If

             ' Typical instance request errors
             ' WBEM_E_CALL_CANCELLED
             If WBEMError (intIndex).WBEMError = "0x80041032" Then
                WriteToLogFile objFileHandle, "=> This error occurs when an asynchronous call is cancelled.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   WMIDiag cancels asynchornous with the RequestAllInstances parameter when", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   " & cAsyncMaxInstances & " instances or more are returned. NO ACTION is required.", cLoggingLevel0, False
             End If

             ' Typical missing class errors
             ' WBEM_E_INVALID_CLASS
             If WBEMError (intIndex).WBEMError = "0x80041010" Then 
                WriteToLogFile objFileHandle, "=> This error is typically due to missing or invalid WMI classes in the repository.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - Verify any GET, ENUMERATION, EXECQUERY and GET VALUE operation failures.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "=> You can correct the missing class definitions by:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - Manually recompiling the MOF file(s) with the 'MOFCOMP <FileName.MOF>' command.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   Note: You can build a list of classes in relation with their WMI provider and MOF file with WMIDiag.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "         (This list can be built on a similar and working WMI Windows installation)", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "         The following command line must be used:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "         i.e. 'WMIDiag CorrelateClassAndProvider'", cLoggingLevel0, False

                WriteToLogFile objFileHandle, "", cLoggingLevel0, False
             End If

             ' Typical missing classes or objects
             ' WBEM_E_NOT_FOUND 
             If WBEMError (intIndex).WBEMError = "0x80041002" Then 
                WriteToLogFile objFileHandle, "=> This error is typically a WMI error. This WMI error is due to:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - a missing WMI class definition or object.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "     (See any GET, ENUMERATION, EXECQUERY and GET VALUE operation failures).", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "     You can correct the missing class definitions by:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "     - Manually recompiling the MOF file(s) with the 'MOFCOMP <FileName.MOF>' command.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "     Note: You can build a list of classes in relation with their WMI provider and MOF file with WMIDiag.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "           (This list can be built on a similar and working WMI Windows installation)", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "           The following command line must be used:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "           i.e. 'WMIDiag CorrelateClassAndProvider'", cLoggingLevel0, False
                If Len (strPerformanceClass) > 0 Then 
                   WriteToLogFile objFileHandle, "     Note: When a WMI performance class is missing, you can manually resynchronize performance counters", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "           with WMI by starting the ADAP process.", cLoggingLevel0, False
                End If
                WriteToLogFile objFileHandle, "   - a WMI repository corruption.", cLoggingLevel0, False
                If RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP2 Or _
		   RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP3 Then
                   WriteToLogFile objFileHandle, "     Under Windows XP SP2 and SP3, you can validate the repository consistency", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "     by executing the following command:", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "     i.e. 'WMIDiag CheckConsistency'", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "   Note: Under Windows XP SP2 and SP3, when the repository is checked and detected INCONSISTENT,", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "         a new repository is automatically re-created based on Auto-Recovery mechanism.", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "         Note that some information can be lost during this process (i.e. static data, CIM registration).", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "         However, the original repository is located at '" & RunTimeEnvironmentInfo.WBem & "Repository.001'.", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "         The computer must be rebooted for the system to work with the re-created repository.", cLoggingLevel0, False
                Else
                   If RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP164 Or _
                      RunTimeEnvironmentInfo.OSIdentifier = cWindows2003SP1 Or _
                      RunTimeEnvironmentInfo.OSIdentifier = cWindows2003SP2 Or _
                      RunTimeEnvironmentInfo.OSIdentifier = cWindows2003SP264 Or _
                      RunTimeEnvironmentInfo.OSIdentifier = cWindows2003SP164 Then
                      WriteToLogFile objFileHandle, "     Under Windows XP 64-bit SP1, Windows 2003 SP1 and Windows Vista, the", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "     repository consistency is ALWAYS verified.", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "     Under Windows XP SP2, the repository consistency must be explicitly requested:", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "     i.e. 'WMIDiag CheckConsistency''", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "     Check the state of the repository above in the WMIDiag report.", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "     If the repository is inconsistent, it must be reconstructed.", cLoggingLevel0, False
                   Else
                      WriteToLogFile objFileHandle, "     In such a case, you must rerun WMIDiag with 'WriteInRepository' parameter", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "     to validate the WMI repository operations.", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "   Note: ENSURE you are an administrator with FULL access to WMI EVERY namespaces of the computer before", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "         executing the WriteInRepository command. To write temporary data from the Root namespace, use:", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "         i.e. 'WMIDiag WriteInRepository=Root'", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "   - If the WriteInRepository command fails, while being an Administrator with ALL accesses to ALL namespaces", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "     the WMI repository must be reconstructed.", cLoggingLevel0, False
                   End If
                End If
                WriteToLogFile objFileHandle, "   Note: The WMI repository reconstruction requires to locate all MOF files needed to rebuild the repository,", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "         otherwise some applications may fail after the reconstruction.", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "         This can be achieved with the following command:", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "         i.e. 'WMIDiag ShowMOFErrors'", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "   Note: The repository reconstruction must be a LAST RESORT solution and ONLY after executing", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "         ALL fixes previously mentioned.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "Static information stored by external applications in the repository will be LOST! (i.e. SMS Inventory)", cLoggingLevel2, False
                WriteToLogFile objFileHandle, "", cLoggingLevel0, False
             End If

             ' Typical WMI system errors
             ' WBEM_E_INITIALIZATION_FAILURE    
             ' WBEM_E_CRITICAL_ERROR 
             ' WBEM_E_OUT_OF_MEMORY 
             If WBEMError (intIndex).WBEMError = "0x80041014" Or _
                WBEMError (intIndex).WBEMError = "0x8004100A" Or _
                WBEMError (intIndex).WBEMError = "0x80041006" Then 
                WriteToLogFile objFileHandle, "=> This error is typically a WMI system error. WMI system errors can find their origin in:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - Failing WMI system components (see any missing WMI system files or DCOM registration", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "     issues previously mentioned).", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - Failing WMI providers (see any DCOM registration issues previously mentioned).", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - a WMI repository corruption.", cLoggingLevel0, False
                If RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP2  Or _
		   RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP3 Then
                   WriteToLogFile objFileHandle, "     Under Windows XP SP2 and SP3, you can validate the repository consistency", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "     by executing the following command:", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "     i.e. 'WMIDiag CheckConsistency'", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "   Note: Under Windows XP SP2 and SP3, when the repository is checked and detected INCONSISTENT,", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "         a new repository is automatically re-created based on Auto-Recovery mechanism.", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "         Note that some information can be lost during this process (i.e. static data, CIM registration).", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "         However, the original repository is located at '" & RunTimeEnvironmentInfo.WBem & "Repository.001'.", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "         The computer must be rebooted for the system to work with the re-created repository.", cLoggingLevel0, False
                Else
                   If RunTimeEnvironmentInfo.OSIdentifier = cWindowsXPSP164 Or _
                      RunTimeEnvironmentInfo.OSIdentifier = cWindows2003SP1 Or _
                      RunTimeEnvironmentInfo.OSIdentifier = cWindows2003SP2 Or _
                      RunTimeEnvironmentInfo.OSIdentifier = cWindows2003SP264 Or _
                      RunTimeEnvironmentInfo.OSIdentifier = cWindows2003SP164 Then
                      WriteToLogFile objFileHandle, "     Under Windows XP 64-bit SP1, Windows 2003 SP1 and Windows Vista, the", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "     repository consistency is ALWAYS verified.", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "     Under Windows XP SP2, the repository consistency must be explicitly requested:", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "     i.e. 'WMIDiag CheckConsistency''", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "     Check the state of the repository above in the WMIDiag report.", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "     If the repository is inconsistent, it must be reconstructed.", cLoggingLevel0, False
                   Else
                      WriteToLogFile objFileHandle, "     In such a case, you must rerun WMIDiag with 'WriteInRepository' parameter", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "     to validate the WMI repository operations.", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "   Note: ENSURE you are an administrator with FULL access to WMI EVERY namespaces of the computer before", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "         executing the WriteInRepository command. To write temporary data from the Root namespace, use:", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "         i.e. 'WMIDiag WriteInRepository=Root'", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "   - If the WriteInRepository command fails, while being an Administrator with ALL accesses to ALL namespaces", cLoggingLevel0, False
                      WriteToLogFile objFileHandle, "     the WMI repository must be reconstructed.", cLoggingLevel0, False
                   End If
                End If
                WriteToLogFile objFileHandle, "   Note: The WMI repository reconstruction requires to locate all MOF files needed to rebuild the repository,", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "         otherwise some applications may fail after the reconstruction.", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "         This can be achieved with the following command:", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "         i.e. 'WMIDiag ShowMOFErrors'", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "   Note: The repository reconstruction must be a LAST RESORT solution and ONLY after executing", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "         ALL fixes previously mentioned.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "Static information stored by external applications in the repository will be LOST! (i.e. SMS Inventory)", cLoggingLevel2, False
                WriteToLogFile objFileHandle, "", cLoggingLevel0, False
                boolWMISystemError = True
             End If

             ' Typical DLL depency provider failures (or ACL on DLL dependencies)
             ' WBEM_E_PROVIDER_FAILURE
             If WBEMError (intIndex).WBEMError = "0x80041004" Then 
                WriteToLogFile objFileHandle, "=> When a WMI provider fails to execute requests after initialization, this can be due to some", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   DLL dependencies or ACL on those DLLs.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - Dependencies can be found with the DEPENDS.EXE tool coming with the", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "     Windows XP and Windows 2003 Support Tools. The command line is as follows:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "     i.e. DEPENDS.EXE <PATH><Provider.DLL>", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   Note: You can build a list of classes in relation with their WMI provider and MOF file with WMIDiag.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "         (This list can be built on a similar and working WMI Windows installation)", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "         The following command line must be used:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "         i.e. 'WMIDiag CorrelateClassAndProvider'", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "=> It is also possible to trace the provider requests by", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   submitting, via WBEMTEST and asynchronously, the following WMI event query:", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "   'Select * From MSFT_WmiSelfEvent'", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   Then you can trace the following WMI events:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - Msft_WmiProvider_ComServerLoadOperationEvent", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - Msft_WmiProvider_InitializationOperationEvent", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - Msft_WmiProvider_LoadOperationEvent", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   and depending on the WMI operation executed, you can trace the following WMI events:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   i.e. for an enumeration:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - Msft_WmiProvider_CreateInstanceEnumAsyncEvent_Pre and Msft_WmiProvider_CreateInstanceEnumAsyncEvent_Post", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   i.e. for a put operation:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - Msft_WmiProvider_PutInstanceAsyncEvent_Pre and Msft_WmiProvider_PutInstanceAsyncEvent_Post", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "", cLoggingLevel0, False
             End If

             ' Typical provider registration errors
             ' WBEM_E_PROVIDER_LOAD_FAILURE
             ' WBEM_E_INVALID_PROVIDER_REGISTRATION
             ' WBEM_E_PROVIDER_NOT_FOUND
             ' WBEM_E_PROVIDER_NOT_REGISTERED
             If WBEMError (intIndex).WBEMError = "0x80041013" Or _
                WBEMError (intIndex).WBEMError = "0x80041012" Or _
                WBEMError (intIndex).WBEMError = "0x80041011" Or _
                WBEMError (intIndex).WBEMError = "0x80041085" Then 
                WriteToLogFile objFileHandle, "=> This error is typically due to the following major reasons:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - The application queried by the WMI provider is not installed, not available or not running", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "     at the time of the request was made. This error can also be generated because ", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "     the application supporting the providers has been uninstalled.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - Some WMI providers (i.e. RSOP Planning Mode, Exchange 2003) are implemented as a WMI service.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "     Make sure the required services are successfully started.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - The WMI provider binary files are not accessible (i.e. access denied ACL).", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - A WMI provider registration problem at the CIM level (MOFCOMP.EXE) or at the COM level (REGSVR32.EXE).", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "     You must re-register the WMI provider by recompiling its associated MOF file with MOFCOMP.EXE", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   Note: - If the WMI provider DLL CIM and COM registrations are correct, this error can", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "           be returned because the provider has a dependency on another DLL that cannot be", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "           loaded (missing or bad DLL)", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "         - Dependencies can be found with the DEPENDS.EXE tool coming with the", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "           Windows XP and Windows 2003 Support Tools. The command line is as follows:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "           i.e. DEPENDS.EXE <PATH><Provider.DLL>", cLoggingLevel0, False
                If WBEMError (intIndex).WBEMError = "0x80041013" Then 
                   WriteToLogFile objFileHandle, "=> When a WMI provider fails to load, it is possible to trace the provider load process by", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "   submitting, via WBEMTEST and asynchronously, the following WMI event query:", cLoggingLevel0, False 
                   WriteToLogFile objFileHandle, "   'Select * From MSFT_WmiSelfEvent'", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "   Then you can trace the following WMI events:", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "   - Msft_WmiProvider_ComServerLoadOperationEvent", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "   - Msft_WmiProvider_InitializationOperationEvent", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "   - Msft_WmiProvider_LoadOperationEvent", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "   and depending on the WMI operation executed, you can trace the following WMI events:", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "   i.e. for an enumeration:", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "   - Msft_WmiProvider_CreateInstanceEnumAsyncEvent_Pre and Msft_WmiProvider_CreateInstanceEnumAsyncEvent_Post", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "   i.e. for a put operation:", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "   - Msft_WmiProvider_PutInstanceAsyncEvent_Pre and Msft_WmiProvider_PutInstanceAsyncEvent_Post", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "", cLoggingLevel0, False
                End If
                WriteToLogFile objFileHandle, "=> If the software has been de-installed intentionally, then this information must be", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   removed from the WMI repository. You can use the 'WMIC.EXE' command to remove the provider", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   registration data and its set of associated classes.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "=> To correct this situation, you can:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - Install or start the application supporting these providers.", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "   - Register the providers in CIM (MOFCOMP) or DCOM (REGSVR32).", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "   Note: In this case the provider should also be listed in the 'missing WMI", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "         provider DCOM registrations' or in the 'missing WMI provider files' section.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "Re-registering with REGSVR32.EXE all DLL from '" & RunTimeEnvironmentInfo.WBem & "'", cLoggingLevel2, False
                WriteToLogFile objFileHandle, "         may not solve the problem as the DLL supporting the WMI class(es)", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "         can be located in a different folder.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "         You must refer to the class name to determine the software delivering the related DLL.", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "", cLoggingLevel0, False
             End If

             ' Typical WMI errors when exceeding limits
             ' WBEM_E_QUOTA_VIOLATION
             If WBEMError (intIndex).WBEMError = "0x8004106C" Then
                WriteToLogFile objFileHandle, "=> This error is typically due to the following major reasons:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - The requested WMI operation is extremely costly in terms of resources and", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "     the WMI provider handling this operation has exceeded the authorized limits.", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "=> You can either:", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "   - Review the scope of the requested WMI operation.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - Eventually review the WMI default quota limits defined at root:__ProviderHostQuotaConfiguration=@", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   Note: Not recommended.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "", cLoggingLevel0, False
             End If

             ' Typical WMI errors when exceeding limits or shuting down the machine
             ' WBEM_E_SHUTTING_DOWN
             If WBEMError (intIndex).WBEMError = "0x80041033" Then
                WriteToLogFile objFileHandle, "=> This error is typically due to the following major reasons:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - While the WMI operation is running, the computer has been requested to shutdown.", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "   - The requested WMI operation is extremely costly in terms of resources and WMI core requests.", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "     the WMI provider handling this operation to shutdown.", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "=> In case of resource limits, you can either:", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "   - Review the scope of the requested WMI operation.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - Eventually review the WMI default quota limits defined at root:__ProviderHostQuotaConfiguration=@", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   Note: Not recommended.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "", cLoggingLevel0, False
             End If

             ' WBEM_E_INVALID_OBJECT
             If WBEMError (intIndex).WBEMError = "0x8004100F" Then
                WriteToLogFile objFileHandle, "=> This error is typically due to malformed data returned to WMI core:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - by the WMI provider involved in the requested operation.", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "   or/and", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "   - from the WMI repository if the data requested is contained in the repository itself.", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "=> You must identify the provider or the WMI classes at the origin of the invalid information.", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "=> You can test the WMI repository integrity with the 'WMIDiag WriteInRepository' command.", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "", cLoggingLevel0, False
             End If

             ' WBEM_E_PROVIDER_DISABLED
             If WBEMError (intIndex).WBEMError = "0x8004108A" Then
                WriteToLogFile objFileHandle, "=> This error is due to a WMI provider explicitly UNLOADED.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   The provider must be explicitly RELOADED before it can be used again.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   It can be reloaded with the following command:", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "   i.e. 'WMIC.EXE Path MSFT_Providers Call Load """", ""<WMINamespace>"", ""<ProviderName>"", """", """"'.", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "   Note: You can build a list of classes in relation with their WMI provider and MOF file with WMIDiag.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "         (This list can be built on a similar and working WMI Windows installation)", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "         The following command line must be used:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "         i.e. 'WMIDiag CorrelateClassAndProvider'", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "", cLoggingLevel0, False
             End If

             ' WMI External errors ...
             ' WBEM_UNKNOWN
             If WBEMError (intIndex).WBEMError = "0x80004002" Then
                WriteToLogFile objFileHandle, "=> This error is not a WMI error. It is a DCOM error due to the following reasons:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - An application has changed the COM/DCOM settings of OLE32.DLL and/or OLEAUT32.DLL.", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "   - The registry settings of COM/DCOM has been damage or wrongly modified.", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "=> To correct this situation, you must re-register the original COM/DCOM DLLs with REGSVR32.EXE", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   i.e. 'REGSVR32.EXE OLE32.DLL'", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   i.e. 'REGSVR32.EXE OLEAUT32.DLL'", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "", cLoggingLevel0, False
             End If

             If WBEMError (intIndex).WBEMError = "0x800706BE" Or _
                WBEMError (intIndex).WBEMError = "0x800706BA" Then
                WriteToLogFile objFileHandle, "=> This error is not a WMI error. It is typically an RPC error due to the following reasons:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - The application queried by the WMI provider is not installed, not available or not running", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "     at the time of the request was made. This error can also be generated because ", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "     the application supporting the providers has been uninstalled.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - The WMI operation was extremely intensive making the RPC communication to fail.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "=> To correct this situation, you can:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - Install or start the application supporting these providers.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "", cLoggingLevel0, False
             End If

             If WBEMError (intIndex).WBEMError = "0x800706D9" Then
                WriteToLogFile objFileHandle, "=> This error is not a WMI error. It is typically due to the following reason:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - The application queried by the WMI provider is not installed, not available or not running", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "     at the time of the request was made. This error can also be generated because ", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "     the application supporting the providers has been uninstalled.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "=> To correct this situation, you can:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - Install or start the application supporting these providers.", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "=> If the software has been de-installed intentionally, then this information must be", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   removed from the WMI repository. You can use the 'WMIC.EXE' command to remove the provider", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   registration data and its set of associated classes.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "", cLoggingLevel0, False
             End If

             If WBEMError (intIndex).WBEMError = "0x8007043B" Then
                WriteToLogFile objFileHandle, "=> This error is not a WMI error. It is typically due to one of the following WMI service", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   configuration issue:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - The WMI service was configured to run as a standalone service host and has being updated to", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "     to run as a shared service host but the configuration is incomplete or not refreshed.", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "   - The Windows Service Host (SvcHost) contains invalid information.", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "=> You can fix this issue by running the following command (case sensitive):", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "   'RUNDLL32.EXE " & RunTimeEnvironmentInfo.WBem & "WMISVC.DLL,MoveToShared'", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "=> Reboot the system.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "", cLoggingLevel0, False
             End If

             If WBEMError (intIndex).WBEMError = "0x80070005" Then
                WriteToLogFile objFileHandle, "=> This error is not a WMI error. It is typically due to:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - The DCOM security modifications.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "     => Ensure that DCOM security configuration settings are not modified.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - The user running WMIDiag has not enough privileges or rights to issue requests", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "     against software components exposing information through WMI.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "     => Ensure that no third party applications installing additional WMI providers have", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "        specific security requirements (i.e. group membership, privileges, etc ...)", cLoggingLevel0, False
                If RunTimeEnvironmentInfo.OSIdentifier >= cWindowsXPSP164 Then
                   WriteToLogFile objFileHandle, "   - The 'Impersonate Client after authentication' Local Policy is disabled or the ", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "     'SERVICE' account has been removed from that Local Policy.", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "     => You must add the 'SERVICE' account to the 'Impersonate Client after authentication'", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "        Local Policy in the 'Local Policies/User Right Assignments' MMC snap-in (GPEDIT.MSC).", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "        By default, this Local Policy includes the 'SERVICE' account.", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "", cLoggingLevel0, False
                End If
             End If

             If Left (WBEMError (intIndex).WBEMError, 6) = "0x8007" Then          
                WriteToLogFile objFileHandle, "=> Errors starting with 0x8007 are Win32 errors, NOT WMI errors. More information can be found", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   with the 'NET.EXE HELPMSG <dddd>' command, where <dddd> is the last four hex digits (0x" & Right (WBEMError (intIndex).WBEMError, 4) & ") ", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "   converted in decimal (" & Clng ("&h" & Right(WBEMError (intIndex).WBEMError, 4)) & ").", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - NET HELPMSG " & Clng ("&h" & Right(WBEMError (intIndex).WBEMError, 4)), cLoggingLevel0, False
                WriteToLogFile objFileHandle, "", cLoggingLevel0, False
             End If

             If WBEMError (intIndex).WBEMError = "0x80040154" Then
                WriteToLogFile objFileHandle, "=> This error is not a WMI error. This error is a DCOM component registration error.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   The registry information for DCOM to initialize a DCOM object is missing or wrongly configured.", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "   - An application has changed the COM/DCOM settings of OLE32.DLL and/or OLEAUT32.DLL.", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "   - The registry settings of COM/DCOM has been damage or wrongly modified.", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "   - The registry security settings of COM/DCOM has been damage or wrongly modified.", cLoggingLevel0, False 

                If RunTimeEnvironmentInfo.OSIdentifier < cWindowsVistaRTM Then
                   WriteToLogFile objFileHandle, "=> To correct this situation, you must re-register the original COM/DCOM DLLs with REGSVR32.EXE", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "   i.e. 'REGSVR32.EXE OLE32.DLL'", cLoggingLevel0, False
                   WriteToLogFile objFileHandle, "   i.e. 'REGSVR32.EXE OLEAUT32.DLL'", cLoggingLevel0, False
                End If

                WriteToLogFile objFileHandle, "=> Verify WMIDiag report if ERRORS or WARNINGS are reported about the DCOM security for", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   the following DCOM objects:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - 'My Computer'", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - 'Windows Management Instrumentation'", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - 'Microsoft WMI Provider Subsystem Host'", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - 'Microsoft WBEM UnSecured Apartment'", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "=> You must also verify with 'REGEDIT.EXE', if the 'Users' builtin group is granted read access for", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   the following registry hives:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - HKCR\APPID", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - HKCR\CLSID", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - HKCR\APPID\{1BE1F766-5536-11D1-B726-00C04FB926AF} (WinMgmt EventSystem APPID keys)", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - HKCR\CLSID\{1BE1F766-5536-11D1-B726-00C04FB926AF} (WinMgmt EventSystem CLSID keys)", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - HKCR\APPID\{8BC3F05E-D86B-11D0-A075-00C04FB68820} (WinMgmt APPID keys)", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - HKCR\CLSID\{8BC3F05E-D86B-11D0-A075-00C04FB68820} (WinMgmt CLSID keys)", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "", cLoggingLevel0, False
             End If

             If WBEMError (intIndex).WBEMError = "0x800A0046" Then
                WriteToLogFile objFileHandle, "=> This error is not a WMI error. This error is a typical DCOM configuration error.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   The DCOM Default Properties (Default Authentication Level and Default Impersonation Level)", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   are probably wrongly configured.", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "=> You can verify and correct the DCOM configuration with the DCOMCNFG MMC snap-in.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - Edit 'My Computer' properties.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - Go to the 'Default properties' tab.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   - Make sure:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "     - The Default Authentication Level is set to 'Connect'.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "     - The Default Impersonation Level is set to 'Impersonate'.", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "", cLoggingLevel0, False
             End If

             If Left (WBEMError (intIndex).WBEMError, 7) = "0x80005" Then  
                WriteToLogFile objFileHandle, "=> Error starting with 0x80005 are ADSI errors. These errors can be returned by an Active", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "   Directory WMI provider failing to access data sotred on an Active Directory Domain Controller.", cLoggingLevel0, False 
                WriteToLogFile objFileHandle, "   More information can be found on MSDN at:", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "   http://msdn.microsoft.com/library/en-us/adsi/adsi/generic_adsi_error_codes.asp", cLoggingLevel0, False
                WriteToLogFile objFileHandle, "", cLoggingLevel0, False
             End If

         Next

End Function

' --------------------------------------------------------------------------------------------------------
Function AnalyzeMissingMOFFiles (ByVal objFileHandle, ByVal boolDump)

         Dim arrayTemp1

         On Error Resume Next

         WriteToLogFile objFileHandle, String (130, "-"), cLoggingLevel0, False

         If Len (TrackingData.AutoRecoveryMissingMOFFiles) > 0 Then 
            If Instr (TrackingData.AutoRecoveryMissingMOFFiles, "NOAUTORECOVERYKEY") > 0 Then
               DumpCSV " ", "AutoRecoveryMissingMOFFiles", 1, boolDump
               If boolWMISystemError = True Or boolShowMOFErrors = True Then 
                  WriteToLogFile objFileHandle, "=> The Auto-Recovery key is missing! If the WMI repository is rebuilt,", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   none of the WMI definitions will be recreated. In such a case, two options are possible:", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   - You must restore a backup copy of the repository.", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   Note: The System State backup or the System Restore snapshot contain a backup of", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "         of the WMI repository.", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   - On Windows Vista, a fresh copy of the WMI repository can be manually reloaded from the CD.", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "", cLoggingLevel0, False
               End If
            Else
               arrayTemp1 = ConvertStringInArray (TrackingData.AutoRecoveryMissingMOFFiles, ",")
               DumpCSV UBound (arrayTemp1) + 1, "AutoRecoveryMissingMOFFiles", 1, boolDump
               If boolWMISystemError = True Or boolShowMOFErrors = True Then 
                  StatusWriteToLogFile objFileHandle, "MOF file(s) referenced in the Auto-Recovery list can't be found on the disk", UBound (arrayTemp1) + 1 & " ERROR(S)!", cLoggingLevel1, False
                  DisplayDiagnostic objFileHandle, arrayTemp1
                  WriteToLogFile objFileHandle, "=> After fixing all other issues previously mentioned, if the WMI repository is rebuilt,", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   the listed MOF file(s) will not be recompiled, and therefore the definition they contain", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   will not be available in the WMI repository.", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "=> You must retrieve a copy of the missing MOF file(s) unless these were uninstalled with", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   an application or were intentionally deleted.", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "", cLoggingLevel0, False
               End If
            End If
         Else
            If boolShowMOFErrors = True Then
               StatusWriteToLogFile objFileHandle, "No MOF file referenced in the Auto-Recovery list is missing", "OK", cLoggingLevel0, False
            End If
            DumpCSV 0, "AutoRecoveryMissingMOFFiles", 1, boolDump
         End If

         If Len (TrackingData.WBemFolderMOFFilesNotListedInAutoRecovery) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.WBemFolderMOFFilesNotListedInAutoRecovery, ",")
            DumpCSV UBound (arrayTemp1) + 1, "WBemFolderMOFFilesNotListedInAutoRecovery", 1, boolDump
            If boolWMISystemError = True Or boolShowMOFErrors = True Then 
               StatusWriteToLogFile objFileHandle, "MOF file(s) present in the WBEM folder not referenced in the Auto-Recovery list", UBound (arrayTemp1) + 1 & " ERROR(S)!", cLoggingLevel1, False
               DisplayDiagnostic objFileHandle, arrayTemp1
               WriteToLogFile objFileHandle, "=> After fixing all other issues previously mentioned, if the WMI repository is rebuilt,", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   the listed MOF file(s) will not be recompiled, and therefore the definition they contain", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   will not be available in the WMI repository.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "=> You must manually recompile the MOF file(s) with the 'MOFCOMP.EXE <FileName.MOF>' command.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "=> If you want the MOF file(s) to be part of the Auto-Recovery list, make sure the", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   statement '#PRAGMA AUTORECOVER' is included.", cLoggingLevel0, False
               If boolStrict = False Then
                  WriteToLogFile objFileHandle, "   Note: MOF file(s) marked with (*) are NEVER included AT SETUP in the auto-recovery process.", cLoggingLevel0, False
               End If 
                  WriteToLogFile objFileHandle, "         MOF file(s) containing UNINSTALL statements (i.e. '#PRAGMA DELETECLASS') should NEVER be included in the auto-recovery process.", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "         Refer to the list of MOF files below NOT containing the '#PRAGMA AUTORECOVER' statement' for more information.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "", cLoggingLevel0, False
            End If
         Else
            If boolShowMOFErrors = True Then
               StatusWriteToLogFile objFileHandle, "There is no MOF file from the WBEM folder missing in the Auto-Recovery list", "OK", cLoggingLevel0, False
            End If
            DumpCSV 0, "WBemFolderMOFFilesNotListedInAutoRecovery", 1, boolDump
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function AnalyzeMissingWMIProviderMOFFile (ByVal objFileHandle, ByVal boolDump)

         Dim strTemp1, arrayTemp1, arrayTemp2, intCounter

         On Error Resume Next

         WriteToLogFile objFileHandle, String (130, "-"), cLoggingLevel0, False

         If Len (TrackingData.MissingWMIProviderMOFFile) > 0 Then
            If Instr (Ucase (TrackingData.MissingWMIProviderMOFFile), "@E;") > 0 Then 

               intCounter = 0
               arrayTemp1 = ConvertStringInArray (TrackingData.MissingWMIProviderMOFFile, ",")
               For Each strTemp1 In arrayTemp1
                   arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                   If arrayTemp2 (0) = "@E" Then
                      intCounter = intCounter + 1
                   End If
               Next
               DumpCSV intCounter, "MissingWMIProviderMOFFile", 1, boolDump

               If boolWMISystemError = True Or boolShowMOFErrors = True Then 
                  WriteToLogFile objFileHandle, "Unable to locate MOF file(s) in the WBEM folder or in Auto-Recovery list for the", cLoggingLevel1, False
                  StatusWriteToLogFile objFileHandle, "following CIM registered WMI provider(s)", intCounter & " ERROR(S)!", cLoggingLevel1, False
                  For Each strTemp1 In arrayTemp1
                      arrayTemp2 = ConvertStringInArray (strTemp1, ";")
                      If arrayTemp2 (0) = "@E" Then
                         WriteToLogFile objFileHandle, "- " & arrayTemp2 (1) & ", " & arrayTemp2 (2) & " (" & arrayTemp2 (3) & ")", cLoggingLevel0, False
                      End If
                  Next

                  WriteToLogFile objFileHandle, "=> If the WMI repository is rebuilt, the listed provider(s) may not be available anymore", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   because the registration data is not located in the list of known MOF files. You can either:", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   - Locate the MOF file(s) and manually recompile the corresponding MOF file(s) with", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "     the 'MOFCOMP.EXE <FileName.MOF>' command.", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   - Retrieve a copy of the missing MOF file(s) and make sure there are part of the Auto-Recovery.", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "     registry key.", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   Note: If you want the MOF file to be part of the Auto-Recovery, make sure the", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "         statement '#PRAGMA AUTORECOVER' is included.", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   - If the corresponding MOF file can't be located, the MOF file can be recreated with", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "     WBEMTEST and/or CIM Studio available at", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "     http://www.microsoft.com/downloads/details.aspx?FamilyID=6430f853-1120-48db-8cc5-f2abdc3ed314&DisplayLang=en", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "   - It is also possible that the application implemented its own recovery mechanism.", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "     In that case, no action is required. ", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "     You must verify with the application vendor if the application has this capability (i.e. Microsoft SMS)", cLoggingLevel0, False
                  WriteToLogFile objFileHandle, "", cLoggingLevel0, False
               End If
            Else
               If boolShowMOFErrors = True Then
                  StatusWriteToLogFile objFileHandle, "WMI provider MOF files are available", "OK", cLoggingLevel0, False
               End If
               DumpCSV 0, "MissingWMIProviderMOFFile", 1, boolDump
            End If
         Else
            If boolShowMOFErrors = True Then
               StatusWriteToLogFile objFileHandle, "WMI provider MOF files are available", "OK", cLoggingLevel0, False
            End If
            DumpCSV 0, "MissingWMIProviderMOFFile", 1, boolDump
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function AnalyzeMissingPragmaAutorecoverMOFFile (ByVal objFileHandle, ByVal boolDump)

         Dim strTemp1, arrayTemp1

         On Error Resume Next

         WriteToLogFile objFileHandle, String (130, "-"), cLoggingLevel0, False

         If Len (TrackingData.NoPragmaAutorecoverMOFFile) > 0 Then
            arrayTemp1 = ConvertStringInArray (TrackingData.NoPragmaAutorecoverMOFFile, ",")
            DumpCSV UBound (arrayTemp1) + 1, "NoPragmaAutorecoverMOFFile", 1, boolDump

            If boolWMISystemError = True Or boolShowMOFErrors = True Then 
               StatusWriteToLogFile objFileHandle, "MOF file(s) not containing the '#PRAGMA AUTORECOVER' statement", UBound (arrayTemp1) + 1 & " FILE(S)!", cLoggingLevel1, False
               For Each strTemp1 In arrayTemp1
                   WriteToLogFile objFileHandle, "- " & strTemp1, cLoggingLevel0, False
               Next
 
               WriteToLogFile objFileHandle, "=> MOF file(s) marked with (*) are INCLUDED in the AUTO-RECOVERY LIST even if they do NOT contain the '#PRAGMA AUTORECOVER' statement.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   If the WMI repository is rebuilt, the listed MOF files not included in the AUTO-RECOVERY LIST and", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   missing the '#PRAGMA AUTORECOVERY' statement when they are compiled the first time will NOT", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   be recompiled during the repository reconstruction.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   Note: If you want the MOF file to be part of the AUTO-RECOVERY LIST, make sure the statement '#PRAGMA AUTORECOVER'", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "         is included and recompile the MOF/MFL with the following command:", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "         i.e. 'MOFCOMP.EXE <FileName.MOF>'", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "", cLoggingLevel0, False

               WriteToLogFile objFileHandle, "=> MOF file(s) marked with (DELETE) contains class and instance DELETE statements.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   Usually, MOF with DELETE statements are used to UNinstall components and they should NOT be listed in the AUTORECOVERY LIST", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   and therefore they should NOT specify the '#PRAGMA AUTORECOVER' statement.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "   Note: It happens that some MOF files do contain DELETE statements for installation purposes to delete", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "         existing information before it is recreated.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "", cLoggingLevel0, False

               WriteToLogFile objFileHandle, "   Note: It is also possible that the application implemented its own recovery mechanism.", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "         In that case, no action is required. You must verify with the application vendor", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "         if the application has this capability (i.e. Microsoft SMS)", cLoggingLevel0, False
               WriteToLogFile objFileHandle, "", cLoggingLevel0, False
            End If
         Else
            If boolShowMOFErrors = True Then 
               StatusWriteToLogFile objFileHandle, "MOF files contain the '#PRAGMA AUTORECOVER' statement", "OK", cLoggingLevel0, False 
            End If
            DumpCSV 0, "NoPragmaAutorecoverMOFFile", 1, boolDump
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function AnalyzeClassAndProviderCorrelation (ByVal objFileHandle, ByVal boolDump)

         Dim intIndex, strTemp1, strTemp2, arrayTemp1, arrayTemp2, arrayTemp3, arrayTemp4, arrayTemp5
         Dim strWMIProviderFile, strMOFProviderFile, strWMIClass, strProviderDisplayName, strWMIProviderData, intPosition, intCounter
         Dim arrayMatchingOutput
         Dim strBegin, strMid, strEnd

         On Error Resume Next

         If boolStatistics = True Then
            WriteToLogFile objFileHandle, "- Statistics " & String (107, "-"), cLoggingLevel0, False

            StatusWriteToLogFile objFileHandle, "CIM Class(es)", longCIMClassCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "    CIM Class(es) with Description", longCIMClassDescriptionCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "CIM Properties", longCIMClassPropertyCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "    CIM Properties with NO Description (No READ/WRITE)", longCIMClassPropertyNoDescriptionCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "    CIM Properties with Description (No READ/WRITE)", longCIMClassPropertyDescriptionCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "    CIM Properties marked as READ", longCIMClassReadPropertyCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "    CIM Properties marked as READ with Description", longCIMClassReadPropertyDescriptionCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "    CIM Properties marked as WRITE", longCIMClassWritePropertyCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "    CIM Properties marked as WRITE with Description", longCIMClassWritePropertyDescriptionCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "    CIM Properties marked as READ/WRITE", longCIMClassReadWritePropertyCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "    CIM Properties marked as READ/WRITE with Description", longCIMClassReadWritePropertyDescriptionCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "CIM Method(s)", longCIMClassMethodCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "    CIM Method(s) with Description", longCIMClassMethodDescriptionCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "    CIM Method(s) INPUT parameters", longCIMClassMethodInParameterCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "    CIM Method(s) INPUT parameters with Description", longCIMClassMethodInParamDescriptionCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "    CIM Method(s) OUTPUT parameters", longCIMClassMethodOutParameterCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "    CIM Method(s) OUTPUT parameters with Description", longCIMClassMethodOutParamDescriptionCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "CIM Class(es) with Method(s)", longCIMClassWithMethodCounter, cLoggingLevel0, False

            WriteToLogFile objFileHandle, "", cLoggingLevel0, False
 
            StatusWriteToLogFile objFileHandle, "WMI Provider Registration(s)", longWMIProviderCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "WMI Class(es) (static and dynamic)", longWMIClassCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "    WMI Class(es) with Description", longWMIClassDescriptionCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "WMI Properties", longWMIClassPropertyCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "    WMI Properties with NO Description (No READ/WRITE)", longWMIClassPropertyNoDescriptionCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "    WMI Properties with Description (No READ/WRITE)", longWMIClassPropertyDescriptionCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "    WMI Properties marked as READ", longWMIClassReadPropertyCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "    WMI Properties marked as READ with Description", longWMIClassReadPropertyDescriptionCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "    WMI Properties marked as WRITE", longWMIClassWritePropertyCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "    WMI Properties marked as WRITE with Description", longWMIClassWritePropertyDescriptionCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "    WMI Properties marked as READ/WRITE", longWMIClassReadWritePropertyCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "    WMI Properties marked as READ/WRITE with Description", longWMIClassReadWritePropertyDescriptionCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "WMI Method(s) (static and dynamic)", longWMIClassMethodCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "    WMI Method(s) with Description", longWMIClassMethodDescriptionCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "    WMI Method(s) INPUT parameters", longWMIClassMethodInParameterCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "    WMI Method(s) INPUT parameters with Description", longWMIClassMethodInParamDescriptionCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "    WMI Method(s) OUTPUT parameters", longWMIClassMethodOutParameterCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "    WMI Method(s) OUTPUT parameters with Description", longWMIClassMethodOutParamDescriptionCounter, cLoggingLevel0, False
            StatusWriteToLogFile objFileHandle, "WMI Class(es) with Method(s) (static and dynamic)", longWMIClassWithMethodCounter, cLoggingLevel0, False

            WriteToLogFile objFileHandle, "", cLoggingLevel0, False
         End If 

         If boolCorrelateClassAndProvider = True And boolDump = True Then
            WriteToLogFile objFileHandle, "Creating content for '" & strWMIProvFileName & "'.", cLoggingLevel0, False
            If boolLoggingDebug = True Then
               WriteToFile objWMIProvFileHandle, "       OSVersion, Platform, WMI Namespace, WMI Class name, WMI provider name, WMI provider dislayname, WMI provider model, WMI provider type, WMI provider CLSID, WMI provider hosting model, WMI provider binary, WMI provider registration MOF file(s)"
            Else
               WriteToFile objWMIProvFileHandle, "WMI Namespace, WMI Class name, WMI provider name, WMI provider model, WMI provider type, WMI provider CLSID, WMI provider hosting model, WMI provider binary, WMI provider registration MOF file(s)"
            End If

            If Len (TrackingData.WMIProviderRegistrationData) > 0 Then 
               If Len (TrackingData.WMIProviderLocationData) > 0 Then
                  intCounter = 0
                  arrayTemp1 = ConvertStringInArray (TrackingData.WMIProviderRegistrationData, ",")
                  arrayTemp3 = ConvertStringInArray (TrackingData.WMIProviderLocationData, ",")
                  arrayTemp4 = ConvertStringInArray (TrackingData.LocatedWMIProviderMOFFile, ",")

                  StatusWriteToLogFile objFileHandle, "WMI provider registration data", UBound (arrayTemp1) + 1, cLoggingLevel0, False
                  If Len (TrackingData.ClassSupportedByProvider) > 0 Then
                     arrayTemp5 = ConvertStringInArray (TrackingData.ClassSupportedByProvider, ",")
                     StatusWriteToLogFile objFileHandle, "WMI class registration data", UBound (arrayTemp5) + 1, cLoggingLevel0, False
                  Else
                     StatusWriteToLogFile objFileHandle, "WMI class registration data", 0, cLoggingLevel0, False
                     arrayTemp5 = Null
                  End If

                  For Each strTemp1 In arrayTemp1
                      arrayTemp2 = ConvertStringInArray (strTemp1, ";")

                      For Each strTemp2 In arrayTemp3
                          intPosition = Instr (UCase (strTemp2), UCase (arrayTemp2 (0) & ";" & arrayTemp2 (1) & ";"))
                          If intPosition > 0 Then
                             strWMIProviderFile = Mid (strTemp2, Len (arrayTemp2 (0) & ";" & arrayTemp2 (1) & ";" ) + 1)
                             Exit For
                           Else
                             strWMIProviderFile = "No located BIN file"
                           End If
                      Next

                      For Each strTemp2 In arrayTemp4
                          intPosition = Instr (UCase (strTemp2), UCase (arrayTemp2 (0) & ";" & arrayTemp2 (1) & ";"))
                          If intPosition > 0 Then 
                             strMOFProviderFile = Mid (strTemp2, Len (arrayTemp2 (0) & ";" & arrayTemp2 (1) & ";" ) + 1)
                             Exit For
                          Else
                             strMOFProviderFile = "No located MOF file"
                          End If
                      Next

                      intCounter = intCounter + 1

                      If boolLoggingDebug = True Then
                         strBegin = "Array (" & RunTimeEnvironmentInfo.OSStringIdentifier & ", "
                         If RunTimeEnvironmentInfo.IsServerOS = True Then
                            strBegin = strBegin & "cServerOnly, "
                         Else
                            strBegin = strBegin & "cClientOnly, "
                         End If
                         strMid = Chr(34)
                         strEnd = "), _"
                      Else
                         strBegin = ""
                         strMid = ""
                         strEnd = ""
                      End If

                      If boolLoggingDebug = True Then
                         strProviderDisplayName = cMissingWMIInfo
                         For intIndex = 0 To UBound (arrayWMIProviderDisplayName) Step 2
                             If UCase (arrayWMIProviderDisplayName (intIndex)) = UCase (arrayTemp2 (1)) Then
                                strProviderDisplayName = arrayWMIProviderDisplayName (intIndex + 1)
                                Exit For
                             End If
                         Next
                         strWMIProviderData = strMid & arrayTemp2 (1) & strMid & ", " & strMid & strProviderDisplayName & strMid & ", " & strMid & arrayTemp2 (6) & strMid & ", " & strMid & arrayTemp2 (4) & strMid & ", " & strMid & arrayTemp2 (5) & strMid & ", " & strMid & arrayTemp2 (2) & strMid & ", " & strMid & strWMIProviderFile & strMid & ", " & strMid & strMOFProviderFile & strMid & strEnd
                      Else 
                         strWMIProviderData = strMid & arrayTemp2 (1) & strMid & ", " & strMid & arrayTemp2 (6) & strMid & ", " & strMid & arrayTemp2 (4) & strMid & ", " & strMid & arrayTemp2 (5) & strMid & ", " & strMid & arrayTemp2 (2) & strMid & ", " & strMid & arrayTemp2 (3) & strMid & ", " & strMid & strWMIProviderFile & strMid & ", " & strMid & strMOFProviderFile & strMid & strEnd
                      End If 

                      strWMIClass = "*"
                      If IsNull (arrayTemp5) = False Then 
                         For Each strTemp2 In arrayTemp5
                             intPosition = Instr (UCase (strTemp2), UCase (arrayTemp2 (0) & ";" & arrayTemp2 (1) & ";"))
                             If intPosition > 0 Then 
                                strWMIClass = Mid (strTemp2, Len (arrayTemp2 (0) & ";" & arrayTemp2 (1) & ";" ) + 1)
                                WriteToFile objWMIProvFileHandle, strBegin & strMid & arrayTemp2 (0) & strMid & ", " & strMid & strWMIClass & strMid & ", " & strWMIProviderData
                             End If
                         Next
                         If strWMIClass = "*" Then
                            WriteToFile objWMIProvFileHandle, strBegin & strMid & arrayTemp2 (0) & strMid & ", " & strMid & strWMIClass & strMid & ", " & strWMIProviderData
                         End If
                      Else
                         WriteToFile objWMIProvFileHandle, strBegin & strMid & arrayTemp2 (0) & strMid & ", " & strMid & strWMIClass & strMid & ", " & strWMIProviderData
                      End If                      
                  Next
               Else
                  StatusWriteToLogFile objFileHandle, "No WMI provider registered", "NONE", cLoggingLevel2, False
               End If
            Else
               StatusWriteToLogFile objFileHandle, "No WMI provider registered", "NONE", cLoggingLevel2, False
            End If

            WriteToLogFile objFileHandle, "Completed.", cLoggingLevel0, False
            WriteToLogFile objFileHandle, "", cLoggingLevel0, False
         End If 

End Function

' --------------------------------------------------------------------------------------------------------
Function AnalyzeRegistrySetup (ByVal objFileHandle, ByVal boolDump)

         Dim strTemp1, arrayTemp1, arrayTemp2, intCounter, intLoggingLevel

         On Error Resume Next

         WriteToLogFile objFileHandle, String (130, "-"), cLoggingLevel0, False

         If Len (TrackingData.InvalidWMIRegistrySetup) > 0 Then 
            arrayTemp1 = ConvertStringInArray (TrackingData.InvalidWMIRegistrySetup, ",")

            StatusWriteToLogFile objFileHandle, "Unexpected, wrong or missing registry key values", UBound (arrayTemp1) + 1 & " KEY(S)!", cLoggingLevel0, False

            For Each strTemp1 In arrayTemp1
                arrayTemp2 = ConvertStringInArray (strTemp1, ";")

                Select Case Cint (arrayTemp2 (6))
                       Case cRegistryError
                            intLoggingLevel = cLoggingLevel1
                            intWMICriticalityLevel = cLoggingLevel1
                       Case cRegistryWarning, cRegistryWarningWhenPresent
                            intLoggingLevel = cLoggingLevel2
                            If intWMICriticalityLevel <> cLoggingLevel1 Then intWMICriticalityLevel = cLoggingLevel2
                       Case cRegistryInfo
                            intLoggingLevel = cLoggingLevel0
                End Select

                Select Case Ucase (arrayTemp2 (0))
                       Case "MISSINGREGISTRYKEY"
                            If intLoggingLevel = cLoggingLevel0 Then
                               WriteToLogFile objFileHandle, "INFO: Missing registry key value:" , intLoggingLevel, False
                            Else
                               WriteToLogFile objFileHandle, "Missing registry key value:" , intLoggingLevel, False
                            End If
                            If IsNull (arrayTemp2 (5)) = True Or Len (arrayTemp2 (5)) = 0 Then
                               WriteToLogFile objFileHandle, "  - " & arrayTemp2 (1) & "\" & arrayTemp2 (3) & " (" & arrayTemp2 (2) & ")", cLoggingLevel0, False   
                            Else 
                               WriteToLogFile objFileHandle, "  - " & arrayTemp2 (1) & "\" & arrayTemp2 (3) & " (" & arrayTemp2 (2) & ") -> " & arrayTemp2 (5), cLoggingLevel0, False  
                               If RunTimeEnvironmentInfo.OSIdentifier > cWindows2000SP4 Then
                                  WriteToLogFile objFileHandle, "    From the command line, the registry configuration can be corrected with the following command:", cLoggingLevel0, False
                                  WriteToLogFile objFileHandle, "    i.e. 'REG.EXE Add " & Chr (34) & arrayTemp2 (1) & Chr (34) & " /v " & Chr (34) & arrayTemp2 (3) & Chr (34) & " /t " & Chr (34) & arrayTemp2 (2) & Chr (34) & " /d " & Chr (34) & Cint (arrayTemp2 (5)) & Chr (34) & " /f'", cLoggingLevel0, False
                               End If
                            End If 
                       Case "EXTRAREGISTRYKEY"
                            If intLoggingLevel = cLoggingLevel0 Then
                               WriteToLogFile objFileHandle, "INFO: Unexpected existing registry key (the key should not exist):" , intLoggingLevel, False
                            Else
                               WriteToLogFile objFileHandle, "Unexpected existing registry key (the key should not exist):" , intLoggingLevel, False
                            End If
                            If IsNull (arrayTemp2 (5)) = True Or Len (arrayTemp2 (5)) = 0 Then
                               WriteToLogFile objFileHandle, "  - " & arrayTemp2 (1) & "\" & arrayTemp2 (3) & " (" & arrayTemp2 (2) & ")", cLoggingLevel0, False
                            Else 
                               WriteToLogFile objFileHandle, "  - " & arrayTemp2 (1) & "\" & arrayTemp2 (3) & " (" & arrayTemp2 (2) & ") -> " & arrayTemp2 (5), cLoggingLevel0, False  
                            End If
                            If RunTimeEnvironmentInfo.OSIdentifier > cWindows2000SP4 Then
                               WriteToLogFile objFileHandle, "    From the command line, the registry configuration can be corrected with the following command:", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "    i.e. 'REG.EXE Delete " & Chr (34) & arrayTemp2 (1) & Chr (34) & " /v " & Chr (34) & arrayTemp2 (3) & Chr (34) & " /f'", cLoggingLevel0, False
                            End If
                       Case Else
                            If intLoggingLevel = cLoggingLevel0 Then
                               WriteToLogFile objFileHandle, "INFO: Unexpected registry key value:", intLoggingLevel, False
                            Else
                               WriteToLogFile objFileHandle, "Unexpected registry key value:", intLoggingLevel, False
                            End If
                            WriteToLogFile objFileHandle, "  - Current:  " & arrayTemp2 (1) & "\" & arrayTemp2 (3) & " (" & arrayTemp2 (2) & ") -> " & arrayTemp2 (4), cLoggingLevel0, False  
                            WriteToLogFile objFileHandle, "  - Expected: " & arrayTemp2 (1) & "\" & arrayTemp2 (3) & " (" & arrayTemp2 (2) & ") -> " & arrayTemp2 (5), cLoggingLevel0, False  
                            If RunTimeEnvironmentInfo.OSIdentifier > cWindows2000SP4 Then
                               WriteToLogFile objFileHandle, "    From the command line, the registry configuration can be corrected with the following command:", cLoggingLevel0, False
                               WriteToLogFile objFileHandle, "    i.e. 'REG.EXE Add " & Chr (34) & arrayTemp2 (1) & Chr (34) & " /v " & Chr (34) & arrayTemp2 (3) & Chr (34) & " /t " & Chr (34) & arrayTemp2 (2) & Chr (34) & " /d " & Chr (34) & Cint (arrayTemp2 (5)) & Chr (34) & " /f'", cLoggingLevel0, False
                            End If
                End Select
            Next
            WriteToLogFile objFileHandle, "", cLoggingLevel0, False
         Else
            StatusWriteToLogFile objFileHandle, "WMI Registry key setup", "OK", cLoggingLevel0, False
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function DisplayDiagnostic (ByVal objFileHandle, ByVal arrayStrTemp)

         Dim strTemp
 
          On Error Resume Next
 
         For Each strTemp In arrayStrTemp
             WriteToLogFile objFileHandle, "- " & strTemp, cLoggingLevel0, False
         Next

End Function

' --------------------------------------------------------------------------------------------------------
Function ParseCommandLineArguments (ByVal objLOGFileHandle, ByRef varParameter, ByRef varParameterValue)

         Dim WshArguments
         Dim intIndex, intEqualPosition 
 
         On Error Resume Next
 
         WriteToLogFile objLOGFileHandle, "Parsing command line argument(s).", cLoggingLevel3, False
 
         Set WshArguments = Wscript.Arguments
 
         If WshArguments.Count = 0 Then
            WriteToLogFile objLOGFileHandle, "No command line arguments given", cLoggingLevel4, False
         Else
            ReDim varParameter (WshArguments.Count)
            ReDim varParameterValue (WshArguments.Count)
 
            For intIndex = 0 To WshArguments.Count - 1
                WriteToLogFile objLOGFileHandle, "Argument " & intIndex & "='" & WshArguments (intIndex) & "'", cLoggingLevel4, False
 
                varParameter (intIndex) = WshArguments (intIndex)
                RunTimeEnvironmentInfo.CommandLine = RunTimeEnvironmentInfo.CommandLine & varParameter (intIndex) & " "
 
                intEqualPosition = InStr (varParameter (intIndex), "=")
                If intEqualPosition Then
                   varParameterValue (intIndex) = Mid (varParameter (intIndex), intEqualPosition + 1)
                   varParameter (intIndex) = Mid (varParameter (intIndex), 1, intEqualPosition - 1)
                End If
            Next
         End If
 
         ParseCommandLineArguments = WshArguments.Count
 
         Set WshArguments = Nothing
 
         RunTimeEnvironmentInfo.CommandLine = Ucase (RunTimeEnvironmentInfo.ScriptFullName & " " & RunTimeEnvironmentInfo.CommandLine)

End Function

' --------------------------------------------------------------------------------------------------------
Function GetRunTimeEnvInfo (ByRef RunTimeEnvironmentInfo)

         Dim arrayTempValue, strTemp
 
         On Error Resume Next
 
         GetRunTimeEnvInfo = False

         WriteToLogFile Null, "Retrieving Run-time environment information.", cLoggingLevel0, False
 
         RunTimeEnvironmentInfo.StartMenu = UCase (objWshShell.SpecialFolders("StartMenu") & "\")
         RunTimeEnvironmentInfo.Desktop = UCase (objWshShell.SpecialFolders("Desktop") & "\")
         RunTimeEnvironmentInfo.Programs = UCase (objWshShell.SpecialFolders("Programs") & "\")
         RunTimeEnvironmentInfo.SystemDrive = UCase (ReadEnvironmentVariable (Null, "Process", "SystemDrive") & "\")
         RunTimeEnvironmentInfo.SystemRoot = UCase (ReadEnvironmentVariable (Null, "Process", "SystemRoot") & "\")
         RunTimeEnvironmentInfo.Path = UCase (ReadEnvironmentVariable (Null, "Process", "Path") & "\")
         RunTimeEnvironmentInfo.UserTemp = UCase (ReadEnvironmentVariable (Null, "User", "Temp") & "\")
         RunTimeEnvironmentInfo.SystemTemp = UCase (ReadEnvironmentVariable (Null, "System", "Temp") & "\")
         RunTimeEnvironmentInfo.System32 = UCase (RunTimeEnvironmentInfo.SystemRoot & "system32\")
         RunTimeEnvironmentInfo.System = UCase (RunTimeEnvironmentInfo.SystemRoot & "system\")
         RunTimeEnvironmentInfo.WBem = UCase (RunTimeEnvironmentInfo.System32 & "Wbem\")
         RunTimeEnvironmentInfo.WBemLogs = UCase (RunTimeEnvironmentInfo.WBem & "Logs\")
         RunTimeEnvironmentInfo.AllUsersStartMenu = UCase (objWshShell.SpecialFolders("AllUsersStartMenu") & "\")
         RunTimeEnvironmentInfo.AllUsersDesktop = UCase (objWshShell.SpecialFolders("AllUsersDesktop") & "\")
         RunTimeEnvironmentInfo.AllUsersPrograms = UCase (objWshShell.SpecialFolders("AllUsersPrograms") & "\")

         ' Information about Network -----------------------------------------------------------------------
         RunTimeEnvironmentInfo.DomainName = UCase (objWshNetwork.UserDomain)
         RunTimeEnvironmentInfo.UserName = UCase (objWshNetwork.UserName)
         RunTimeEnvironmentInfo.UserDNSDomain = UCase (ReadEnvironmentVariable (Null, "Process", "UserDNSDomain"))
         RunTimeEnvironmentInfo.LocalComputerName = UCase (objWshNetwork.ComputerName)
         RunTimeEnvironmentInfo.LogonServerName = UCase (Mid (ReadEnvironmentVariable (Null, "Process", "LogonServer"), 3))

         ' Information about script environment ------------------------------------------------------------
         RunTimeEnvironmentInfo.ScriptName = UCase (Wscript.ScriptName)
         RunTimeEnvironmentInfo.ScriptFullName = UCase (Wscript.ScriptFullName)
         RunTimeEnvironmentInfo.ScriptingName = UCase (Wscript.Name)
         RunTimeEnvironmentInfo.EngineFullName = UCase (Wscript.FullName)
         RunTimeEnvironmentInfo.EnginePath = UCase (Wscript.Path)
         RunTimeEnvironmentInfo.EngineVersion = UCase (Wscript.Version)

         If RunTimeEnvironmentInfo.EngineVersion >= 5.6 Then 
            
RunTimeEnvironmentInfo.CurrentDirectory = UCase (objWSHShell.CurrentDirectory)
         End If
 
         ' Information about the Windows version -----------------------------------------------------------
 
         arrayTempValue = ReadRegistry (Null, _
                                        "HKLM\SYSTEM\CurrentControlSet\Control\Nls\Locale", _
                                        "", _
                                        "REG_SZ", _
                                        True)
           
         If IsArray (arrayTempValue) = True Then
            RunTimeEnvironmentInfo.Locale = UCase (arrayTempValue (0))
         Else
            arrayTempValue = ReadRegistry (Null, _
                                           "HKLM\SYSTEM\CurrentControlSet\Control\Nls\Locale", _
                                           "(Default)", _
                                           "REG_SZ", _
                                           True)
  
            If IsArray (arrayTempValue) = True Then
               RunTimeEnvironmentInfo.Locale = UCase (arrayTempValue (0))
            Else
               RunTimeEnvironmentInfo.Locale = "?"
               GetRunTimeEnvInfo = True
            End If
         End If
 
         arrayTempValue = ReadRegistry (Null, _
                                        "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion", _
                                        "CurrentVersion", _
                                        "REG_SZ", _
                                        True)
 
         If IsArray (arrayTempValue) = True Then
            RunTimeEnvironmentInfo.NTVersion = UCase (arrayTempValue (0))
         Else
            GetRunTimeEnvInfo = True
         End If

         arrayTempValue = ReadRegistry (Null, _
                                        "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion", _
                                        "CurrentBuildNumber", _
                                        "REG_SZ", _
                                        True)
            
         If IsArray (arrayTempValue) = True Then
            RunTimeEnvironmentInfo.NTBuild = UCase (arrayTempValue (0))
         Else
            GetRunTimeEnvInfo = True
         End If
 
         arrayTempValue = ReadRegistry (Null, _
                                        "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion", _
                                        "CSDVersion", _
                                        "REG_SZ", _
                                        True)

         If IsArray (arrayTempValue) = True Then
            RunTimeEnvironmentInfo.NTServicePack = arrayTempValue (0)
         Else
            RunTimeEnvironmentInfo.NTServicePack = ""
            GetRunTimeEnvInfo = True
         End If

         If RunTimeEnvironmentInfo.NTBuild = "2195" Then
            arrayTempValue = ReadRegistry (Null, _
                                           "HKLM\SYSTEM\CurrentControlSet\Services\kdc", _
                                           "DisplayName", _
                                           "REG_SZ", _
                                           True)

            If IsArray (arrayTempValue) = True Then
               RunTimeEnvironmentInfo.ProductName = "Microsoft Windows 2000 Server"
            Else
               RunTimeEnvironmentInfo.ProductName = "Microsoft Windows 2000 Client"
            End If
         Else
            arrayTempValue = ReadRegistry (Null, _
                                           "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion", _
                                           "ProductName", _
                                           "REG_SZ", _
                                           True)
            If IsArray (arrayTempValue) = True Then
               RunTimeEnvironmentInfo.ProductName = arrayTempValue (0)
            Else
               RunTimeEnvironmentInfo.ProductName = ""
               GetRunTimeEnvInfo = True
            End If
         End If

         If Instr (Ucase (RunTimeEnvironmentInfo.ProductName), "SERVER") > 0 Then
            RunTimeEnvironmentInfo.IsServerOS = True
         Else
            RunTimeEnvironmentInfo.IsServerOS = False
         End If
 
         If Instr (ReadEnvironmentVariable (Null, "Process", "PROCESSOR_ARCHITEW6432"), "64") > 0 Then
            RunTimeEnvironmentInfo.IsWow64 = True
         Else
            RunTimeEnvironmentInfo.IsWow64 = False                      
         End If

         If Instr (ReadEnvironmentVariable (Null, "System", "PROCESSOR_ARCHITECTURE"), "64") > 0 Then
            RunTimeEnvironmentInfo.Is64 = True
            RunTimeEnvironmentInfo.ProcessorArchitecture = "64-bit"
         Else
            RunTimeEnvironmentInfo.Is64 = False
            RunTimeEnvironmentInfo.ProcessorArchitecture = "32-bit"
         End If
 
         RunTimeEnvironmentInfo.ProcessorIdentifier = ReadEnvironmentVariable (Null, "System", "PROCESSOR_IDENTIFIER")

         If RunTimeEnvironmentInfo.Is64 = True Then
            arrayTempValue = ReadRegistry (Null, _
                                           "HKLM\SOFTWARE\Wow6432Node\Microsoft\SMS\Mobile Client", _
                                           "ProductVersion", _
                                           "REG_SZ", _
                                           False)

            If Not IsArray (arrayTempValue) Then
               arrayTempValue = ReadRegistry (Null, _
                                              "HKLM\Software\Microsoft\SMS\Mobile Client", _
                                              "ProductVersion", _
                                              "REG_SZ", _
                                              False)
            End If
         Else
            arrayTempValue = ReadRegistry (Null, _
                                           "HKLM\Software\Microsoft\SMS\Mobile Client", _
                                           "ProductVersion", _
                                           "REG_SZ", _
                                           False)
         End If

         If IsArray (arrayTempValue) = True Then
           RunTimeEnvironmentInfo.SMSAgent = Left (arrayTempValue (0), 9)
         Else
            RunTimeEnvironmentInfo.SMSAgent = ""
            GetRunTimeEnvInfo = True
         End If

         If RunTimeEnvironmentInfo.Is64 = True Then
            arrayTempValue = ReadRegistry (Null, _
                                           "HKLM\SOFTWARE\Wow6432Node\Microsoft\Windows\CurrentVersion\App Paths\winzip.exe", _
                                           "", _
                                           "REG_SZ", _
                                           False)

            If Not IsArray (arrayTempValue) Then
               arrayTempValue = ReadRegistry (Null, _
                                              "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\winzip.exe", _
                                              "", _
                                              "REG_SZ", _
                                              False)
            End If
         Else
            arrayTempValue = ReadRegistry (Null, _
                                           "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\winzip.exe", _
                                           "", _
                                           "REG_SZ", _
                                           False)
         End If

         If IsArray (arrayTempValue) = True Then
            RunTimeEnvironmentInfo.WinZIP = arrayTempValue (0)
         End If 

         RunTimeEnvironmentInfo.OSIdentifier = GetOSVersion ()

         RunTimeEnvironmentInfo.SPUpgrade = GetOSUpgrade ()

End Function

' --------------------------------------------------------------------------------------------------------
Function LogRunTimeEnvInfo (ByVal objLOGFileHandle, ByVal RunTimeEnvironmentInfo)

         On Error Resume Next

         WriteToLogFile objLOGFileHandle, "Logging Run-time environment information.", cLoggingLevel0, False

         WriteToLogFile objLOGFileHandle, "StartMenu=" & RunTimeEnvironmentInfo.StartMenu, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "Desktop=" & RunTimeEnvironmentInfo.Desktop, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "Programs=" & RunTimeEnvironmentInfo.Programs, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "SystemDrive=" & RunTimeEnvironmentInfo.SystemDrive, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "SystemRoot=" & RunTimeEnvironmentInfo.SystemRoot, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "Path=" & RunTimeEnvironmentInfo.Path, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "UserTemp=" & RunTimeEnvironmentInfo.UserTemp, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "SystemTemp=" & RunTimeEnvironmentInfo.SystemTemp, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "System32=" & RunTimeEnvironmentInfo.System32, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "System=" & RunTimeEnvironmentInfo.System, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "Wbem=" & RunTimeEnvironmentInfo.WBem, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "WbemLogs=" & RunTimeEnvironmentInfo.WBemLogs, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "CurrentDirectory=" & RunTimeEnvironmentInfo.CurrentDirectory, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "AllUsersStartMenu=" & RunTimeEnvironmentInfo.AllUsersStartMenu, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "AllUsersDesktop=" & RunTimeEnvironmentInfo.AllUsersDesktop, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "AllUsersPrograms=" & RunTimeEnvironmentInfo.AllUsersPrograms, cLoggingLevel3, False

         WriteToLogFile objLOGFileHandle, "ScriptName=" & RunTimeEnvironmentInfo.ScriptName, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "ScriptFullName=" & RunTimeEnvironmentInfo.ScriptFullName, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "ScriptingName=" & RunTimeEnvironmentInfo.ScriptingName, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "EngineFullName=" & RunTimeEnvironmentInfo.EngineFullName, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "CommandLine=" & RunTimeEnvironmentInfo.CommandLine, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "EnginePath=" & RunTimeEnvironmentInfo.EnginePath, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "EngineVersion=" & RunTimeEnvironmentInfo.EngineVersion, cLoggingLevel3, False

         WriteToLogFile objLOGFileHandle, "DomainName=" & RunTimeEnvironmentInfo.DomainName, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "UserName=" & RunTimeEnvironmentInfo.UserName, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "UserDNSDomain=" & RunTimeEnvironmentInfo.UserDNSDomain, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "LogonServerName=" & RunTimeEnvironmentInfo.LogonServerName, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "LocalComputerName=" & RunTimeEnvironmentInfo.LocalComputerName, cLoggingLevel3, False

         WriteToLogFile objLOGFileHandle, "ProductName=" & RunTimeEnvironmentInfo.ProductName, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "Locale=" & RunTimeEnvironmentInfo.Locale, cLoggingLevel3, False

         WriteToLogFile objLOGFileHandle, "IsServerOS=" & RunTimeEnvironmentInfo.IsServerOS, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "Is64=" & RunTimeEnvironmentInfo.Is64, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "IsWow64=" & RunTimeEnvironmentInfo.IsWow64, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "ProcessorArchitecture=" & RunTimeEnvironmentInfo.ProcessorArchitecture, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "ProcessorIdentifier=" & RunTimeEnvironmentInfo.ProcessorIdentifier, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "NTVersion=" & RunTimeEnvironmentInfo.NTVersion, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "NTBuild=" & RunTimeEnvironmentInfo.NTBuild, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "NTServicePack=" & RunTimeEnvironmentInfo.NTServicePack, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "FullName=" & RunTimeEnvironmentInfo.ProductFullName, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "ShortName=" & RunTimeEnvironmentInfo.ProductShortName, cLoggingLevel3, False

         WriteToLogFile objLOGFileHandle, "SMSAgent=" & RunTimeEnvironmentInfo.SMSAgent, cLoggingLevel3, False
         WriteToLogFile objLOGFileHandle, "WinZIP=" & RunTimeEnvironmentInfo.WinZIP, cLoggingLevel3, False

End Function

' --------------------------------------------------------------------------------------------------------
Function GetOSVersion ()

         Dim strNTServicePack 

         On Error Resume Next

         strNTServicePack = LEFT (RunTimeEnvironmentInfo.NTServicePack, 14)

         Select Case UCase (RunTimeEnvironmentInfo.NTVersion)
                Case "5.0" ' Windows 2000 
                     RunTimeEnvironmentInfo.OSBrandVersion = "2000"
        
                     If RunTimeEnvironmentInfo.IsServerOS Then
                        RunTimeEnvironmentInfo.ProductFullName = "Windows 2000 Server"
                        RunTimeEnvironmentInfo.ProductShortName = "2000_.SRV"
                     Else
                        RunTimeEnvironmentInfo.ProductFullName = "Windows 2000 Client"                       
                        RunTimeEnvironmentInfo.ProductShortName = "2000_.CLI"
                     End If
 
                     Select Case Ucase (strNTServicePack)
                            Case "SERVICE PACK 1"
                                 GetOSVersion = cWindows2000SP1
                                 RunTimeEnvironmentInfo.ProductFullName = RunTimeEnvironmentInfo.ProductFullName & " - Service pack 1 - " & RunTimeEnvironmentInfo.ProcessorArchitecture
                                 RunTimeEnvironmentInfo.ProductShortName = RunTimeEnvironmentInfo.ProductShortName & ".SP1"
 
                            Case "SERVICE PACK 2"
                                 GetOSVersion = cWindows2000SP2
                                 RunTimeEnvironmentInfo.ProductFullName = RunTimeEnvironmentInfo.ProductFullName & " - Service pack 2 - " & RunTimeEnvironmentInfo.ProcessorArchitecture
                                 RunTimeEnvironmentInfo.ProductShortName = RunTimeEnvironmentInfo.ProductShortName & ".SP2"
 
                            Case "SERVICE PACK 3"
                                 GetOSVersion = cWindows2000SP3
                                 RunTimeEnvironmentInfo.ProductFullName = RunTimeEnvironmentInfo.ProductFullName & " - Service pack 3 - " & RunTimeEnvironmentInfo.ProcessorArchitecture
                                 RunTimeEnvironmentInfo.ProductShortName = RunTimeEnvironmentInfo.ProductShortName & ".SP3"

                            Case "SERVICE PACK 4"
                                 GetOSVersion = cWindows2000SP4
                                 RunTimeEnvironmentInfo.ProductFullName = RunTimeEnvironmentInfo.ProductFullName & " - Service pack 4 - " & RunTimeEnvironmentInfo.ProcessorArchitecture
                                 RunTimeEnvironmentInfo.ProductShortName = RunTimeEnvironmentInfo.ProductShortName & ".SP4"
 
                            Case Else
                                 GetOSVersion = cWindows2000RTM
                                 RunTimeEnvironmentInfo.ProductFullName = RunTimeEnvironmentInfo.ProductFullName & " - No service pack - " & RunTimeEnvironmentInfo.ProcessorArchitecture
                                 RunTimeEnvironmentInfo.ProductShortName = RunTimeEnvironmentInfo.ProductShortName & ".RTM"
                     End Select 
  
                     RunTimeEnvironmentInfo.ProductShortName = RunTimeEnvironmentInfo.ProductShortName & ".32"
                Case "5.1" ' Windows XP 
                     RunTimeEnvironmentInfo.OSBrandVersion = "XP"
 
                     Select Case Ucase (strNTServicePack)
                            Case "SERVICE PACK 1"
                                 GetOSVersion = cWindowsXPSP1
                                 RunTimeEnvironmentInfo.ProductShortName = "XP___.CLI.SP1"
                                 RunTimeEnvironmentInfo.ProductFullName = "Windows XP - Service pack 1 - " & RunTimeEnvironmentInfo.ProcessorArchitecture
                            Case "SERVICE PACK 2"
                                 GetOSVersion = cWindowsXPSP2
                                 RunTimeEnvironmentInfo.ProductFullName = "Windows XP - Service pack 2 - " & RunTimeEnvironmentInfo.ProcessorArchitecture
                                 RunTimeEnvironmentInfo.ProductShortName = "XP___.CLI.SP2"
			    			Case "SERVICE PACK 3"
                                 GetOSVersion = cWindowsXPSP3
                                 RunTimeEnvironmentInfo.ProductFullName = "Windows XP - Service pack 3 - " & RunTimeEnvironmentInfo.ProcessorArchitecture
                                 RunTimeEnvironmentInfo.ProductShortName = "XP___.CLI.SP3"
                            Case Else
                                 GetOSVersion = cWindowsXPRTM
                                 RunTimeEnvironmentInfo.ProductFullName = "Windows XP - No service pack - " & RunTimeEnvironmentInfo.ProcessorArchitecture
                                 RunTimeEnvironmentInfo.ProductShortName = "XP___.CLI.RTM"
                     End Select
                     RunTimeEnvironmentInfo.ProductShortName = RunTimeEnvironmentInfo.ProductShortName & ".32"
                Case "5.2"
                     If RunTimeEnvironmentInfo.IsServerOS = False Then
                        ' Windows XP 64 bits
                        RunTimeEnvironmentInfo.OSBrandVersion = "XP"
 
                        Select Case Ucase (strNTServicePack)
                               Case "SERVICE PACK 1"
                                    GetOSVersion = cWindowsXPSP164
                                    RunTimeEnvironmentInfo.ProductFullName = "Windows XP - Service Pack 1 - " & RunTimeEnvironmentInfo.ProcessorArchitecture
                                    RunTimeEnvironmentInfo.ProductShortName = "XP___.CLI.SP1.64"
                               Case "SERVICE PACK 2"
                                    GetOSVersion = cWindowsXPSP264
                                    RunTimeEnvironmentInfo.ProductFullName = "Windows XP - Service Pack 2 - " & RunTimeEnvironmentInfo.ProcessorArchitecture
                                    RunTimeEnvironmentInfo.ProductShortName = "XP___.CLI.SP2.64"
                               Case Else
                                    GetOSVersion = cWindowsUnknown
                                    RunTimeEnvironmentInfo.ProductFullName = "Unsupported Windows version - " & RunTimeEnvironmentInfo.ProcessorArchitecture
                                    RunTimeEnvironmentInfo.ProductShortName = "_____.___.___.__"
                        End Select
                     Else
                        ' Windows 2003
                       RunTimeEnvironmentInfo.OSBrandVersion = "2003"
 
                        If RunTimeEnvironmentInfo.Is64 = False Then
                           Select Case Ucase (strNTServicePack)
                                  Case "SERVICE PACK 1"
                                       GetOSVersion = cWindows2003SP1
                                       RunTimeEnvironmentInfo.ProductFullName = "Windows Server 2003 - Service pack 1 - " & RunTimeEnvironmentInfo.ProcessorArchitecture
                                       RunTimeEnvironmentInfo.ProductShortName = "2003_.SRV.SP1.32"
				  				  Case "SERVICE PACK 2"
                                       GetOSVersion = cWindows2003SP2
                                       RunTimeEnvironmentInfo.ProductFullName = "Windows Server 2003 - Service pack 2 - " & RunTimeEnvironmentInfo.ProcessorArchitecture
                                       RunTimeEnvironmentInfo.ProductShortName = "2003_.SRV.SP2.32"		
                                  Case Else
                                       GetOSVersion = cWindows2003RTM
                                       RunTimeEnvironmentInfo.ProductFullName = "Windows Server 2003 - No service pack - " & RunTimeEnvironmentInfo.ProcessorArchitecture
                                       RunTimeEnvironmentInfo.ProductShortName = "2003_.SRV.RTM.32"
                           End Select
                        Else
                           Select Case Ucase (strNTServicePack)
                                  Case "SERVICE PACK 1"
                                       GetOSVersion = cWindows2003SP164
                                       RunTimeEnvironmentInfo.ProductFullName = "Windows Server 2003 - Service pack 1 - " & RunTimeEnvironmentInfo.ProcessorArchitecture
                                       RunTimeEnvironmentInfo.ProductShortName = "2003_.SRV.SP1.64"
                                  Case "SERVICE PACK 2"
                                       GetOSVersion = cWindows2003SP264
                                       RunTimeEnvironmentInfo.ProductFullName = "Windows Server 2003 - Service pack 2 - " & RunTimeEnvironmentInfo.ProcessorArchitecture
                                       RunTimeEnvironmentInfo.ProductShortName = "2003_.SRV.SP2.64"
                                  Case Else
                                       GetOSVersion = cWindows2003RTM64
                                       RunTimeEnvironmentInfo.ProductFullName = "Windows Server 2003 - No service pack - " & RunTimeEnvironmentInfo.ProcessorArchitecture
                                       RunTimeEnvironmentInfo.ProductShortName = "2003_.SRV.RTM.64"
                           End Select
                        End If
                     End If
                Case "6.0" ' Windows Vista and Server 2008 (non-R2)
                     If RunTimeEnvironmentInfo.IsServerOS Then

                        RunTimeEnvironmentInfo.OSBrandVersion = "Windows Server 2008"
                        RunTimeEnvironmentInfo.ProductShortName = RunTimeEnvironmentInfo.NTBuild & "_.SRV.RTM"
                        If RunTimeEnvironmentInfo.Is64 = False Then
	                       Select Case Ucase (strNTServicePack)
	                              Case "SERVICE PACK 1"
	                                   GetOSVersion = cWindows2008SP1
	                                   RunTimeEnvironmentInfo.ProductFullName = "Windows Server 2008 - Service pack 1 - " & RunTimeEnvironmentInfo.ProcessorArchitecture
	                                   RunTimeEnvironmentInfo.ProductShortName = "2008_.SRV.SP1.32"
	                              Case "SERVICE PACK 2"
	                                   GetOSVersion = cWindows2008SP2
	                                   RunTimeEnvironmentInfo.ProductFullName = "Windows Server 2008 - Service pack 2 - " & RunTimeEnvironmentInfo.ProcessorArchitecture
	                                   RunTimeEnvironmentInfo.ProductShortName = "2008_.SRV.SP2.32"
	                              Case Else
	                                    GetOSVersion = cWindowsUnknown
	                                    RunTimeEnvironmentInfo.ProductFullName = "Unsupported Windows version - " & RunTimeEnvironmentInfo.ProcessorArchitecture
	                                    RunTimeEnvironmentInfo.ProductShortName = "_____.___.___.__"
	                       End Select
	                    Else
	                       Select Case Ucase (strNTServicePack)
	                              Case "SERVICE PACK 1"
	                                   GetOSVersion = cWindows2008SP164
	                                   RunTimeEnvironmentInfo.ProductFullName = "Windows Server 2008 - Service pack 1 - " & RunTimeEnvironmentInfo.ProcessorArchitecture
	                                   RunTimeEnvironmentInfo.ProductShortName = "2008_.SRV.SP1.64"
	                              Case "SERVICE PACK 2"
	                                   GetOSVersion = cWindows2008SP264
	                                   RunTimeEnvironmentInfo.ProductFullName = "Windows Server 2008 - Service pack 2 - " & RunTimeEnvironmentInfo.ProcessorArchitecture
	                                   RunTimeEnvironmentInfo.ProductShortName = "2008_.SRV.SP2.64"
	                              Case Else
	                                    GetOSVersion = cWindowsUnknown
	                                    RunTimeEnvironmentInfo.ProductFullName = "Unsupported Windows version - " & RunTimeEnvironmentInfo.ProcessorArchitecture
	                                    RunTimeEnvironmentInfo.ProductShortName = "_____.___.___.__"
	                       End Select
	                    End if	                    	
                     Else
                        RunTimeEnvironmentInfo.OSBrandVersion = "Vista"
                        RunTimeEnvironmentInfo.ProductFullName = "Windows Vista" 
                        RunTimeEnvironmentInfo.ProductShortName = "VISTA.CLI"

                        If RunTimeEnvironmentInfo.Is64 = False Then
	                       Select Case Ucase (strNTServicePack)
	                              Case "SERVICE PACK 1"
	                                   GetOSVersion = cWindows2008SP1
	                                   RunTimeEnvironmentInfo.ProductFullName = "Windows Vista - Service pack 1 - " & RunTimeEnvironmentInfo.ProcessorArchitecture
	                                   RunTimeEnvironmentInfo.ProductShortName = "VISTA.CLI.SP1.32"
	                              Case "SERVICE PACK 2"
	                                   GetOSVersion = cWindows2008SP2
	                                   RunTimeEnvironmentInfo.ProductFullName = "Windows Vista - Service pack 2 - " & RunTimeEnvironmentInfo.ProcessorArchitecture
	                                   RunTimeEnvironmentInfo.ProductShortName = "VISTA.CLI.SP2.32"
	                              Case Else
	                                    GetOSVersion = cWindowsUnknown
	                                    RunTimeEnvironmentInfo.ProductFullName = "Windows Vista - No Service Pack - " & RunTimeEnvironmentInfo.ProcessorArchitecture
	                                    RunTimeEnvironmentInfo.ProductShortName = "VISTA.CLI.RTM.32"
	                       End Select
	                    Else
	                       Select Case Ucase (strNTServicePack)
	                              Case "SERVICE PACK 1"
	                                   GetOSVersion = cWindows2008SP1
	                                   RunTimeEnvironmentInfo.ProductFullName = "Windows Vista - Service pack 1 - " & RunTimeEnvironmentInfo.ProcessorArchitecture
	                                   RunTimeEnvironmentInfo.ProductShortName = "VISTA.CLI.SP1.64"
	                              Case "SERVICE PACK 2"
	                                   GetOSVersion = cWindows2008SP2
	                                   RunTimeEnvironmentInfo.ProductFullName = "Windows Vista - Service pack 2 - " & RunTimeEnvironmentInfo.ProcessorArchitecture
	                                   RunTimeEnvironmentInfo.ProductShortName = "VISTA.CLI.SP2.64"
	                              Case Else
	                                    GetOSVersion = cWindowsUnknown
	                                    RunTimeEnvironmentInfo.ProductFullName = "Windows Vista - No Service Pack - " & RunTimeEnvironmentInfo.ProcessorArchitecture
	                                    RunTimeEnvironmentInfo.ProductShortName = "VISTA.CLI.RTM.64"
	                       End Select
	                    End if	
                     End If
				Case "6.1" ' Windows 7 or Windows Server 2008 R2 
                     If RunTimeEnvironmentInfo.IsServerOS Then

                        RunTimeEnvironmentInfo.OSBrandVersion = "Windows Server 2008 R2"
                        RunTimeEnvironmentInfo.ProductShortName = RunTimeEnvironmentInfo.NTBuild & "_.SRV.RTM"
                        
                        If RunTimeEnvironmentInfo.Is64 = False Then
                            'There is no 2008 R2 32-bit
                            GetOSVersion = cWindowsUnknown
                            RunTimeEnvironmentInfo.ProductFullName = "Unsupported Windows version - " & RunTimeEnvironmentInfo.ProcessorArchitecture
                            RunTimeEnvironmentInfo.ProductShortName = "_____.___.___.__"
	                    Else
	                       Select Case Ucase (strNTServicePack)
	                              Case "SERVICE PACK 1"
	                                   GetOSVersion = cWindows2008R2SP164
	                                   RunTimeEnvironmentInfo.ProductFullName = "Windows Server 2008 R2 - Service pack 1 - " & RunTimeEnvironmentInfo.ProcessorArchitecture
	                                   RunTimeEnvironmentInfo.ProductShortName = "2K8R2.SRV.SP1.64"
	                              Case Else
	                                   GetOSVersion = cWindows2008R2SP164
	                                   RunTimeEnvironmentInfo.ProductFullName = "Windows Server 2008 R2 - No Service Pack - " & RunTimeEnvironmentInfo.ProcessorArchitecture
	                                   RunTimeEnvironmentInfo.ProductShortName = "2K8R2.SRV.RTM.64"
	                       End Select
	                    End if	                    	
                     Else
                        RunTimeEnvironmentInfo.OSBrandVersion = "Windows 7"
                        RunTimeEnvironmentInfo.ProductFullName = "Windows 7" 
                        RunTimeEnvironmentInfo.ProductShortName = "WIN7_.CLI"

                        If RunTimeEnvironmentInfo.Is64 = False Then
	                       Select Case Ucase (strNTServicePack)
	                              Case "SERVICE PACK 1"
	                                   GetOSVersion = cWindows7SP1
	                                   RunTimeEnvironmentInfo.ProductFullName = "Windows 7 - Service Pack 1 - " & RunTimeEnvironmentInfo.ProcessorArchitecture
	                                   RunTimeEnvironmentInfo.ProductShortName = "WIN7_.CLI.SP1.32"
	                              Case Else
	                                    GetOSVersion = cWindows7SP164
	                                    RunTimeEnvironmentInfo.ProductFullName = "Windows 7 - No Service Pack - " & RunTimeEnvironmentInfo.ProcessorArchitecture
	                                    RunTimeEnvironmentInfo.ProductShortName = "WIN7_.CLI.RTM.32"
	                       End Select
	                    Else
	                       Select Case Ucase (strNTServicePack)
	                              Case "SERVICE PACK 1"
	                                   GetOSVersion = cWindows7RTM
	                                   RunTimeEnvironmentInfo.ProductFullName = "Windows 7 - Service Pack 1 - " & RunTimeEnvironmentInfo.ProcessorArchitecture
	                                   RunTimeEnvironmentInfo.ProductShortName = "WIN7_.CLI.SP1.64"
	                              Case Else
	                                    GetOSVersion = cWindows7RTM
	                                    RunTimeEnvironmentInfo.ProductFullName = "Windows 7 - No Service Pack - " & RunTimeEnvironmentInfo.ProcessorArchitecture
	                                    RunTimeEnvironmentInfo.ProductShortName = "WIN7_.CLI.RTM.64"
	                       End Select
	                    End if	
                     End If                     
                Case Else
                     GetOSVersion = cWindowsUnknown
                     RunTimeEnvironmentInfo.ProductFullName = "Unsupported Windows version - " & RunTimeEnvironmentInfo.ProcessorArchitecture
                     RunTimeEnvironmentInfo.ProductShortName = "_____.___.___.__"
         End Select
 
         If RunTimeEnvironmentInfo.IsWow64 Then
            RunTimeEnvironmentInfo.ProductFullName = RunTimeEnvironmentInfo.ProductFullName & " (WOW64)"
            GetOSVersion = cWindowsWow64
         End If
 
         If RunTimeEnvironmentInfo.Is64 = True Then
            RunTimeEnvironmentInfo.OSStringIdentifier = "cWindows" & RunTimeEnvironmentInfo.OSBrandVersion & _
                                                        Mid (RunTimeEnvironmentInfo.ProductShortName, 10, 3) & _
                                                        "64"
         Else
            RunTimeEnvironmentInfo.OSStringIdentifier = "cWindows" & RunTimeEnvironmentInfo.OSBrandVersion & _
                                                        Mid (RunTimeEnvironmentInfo.ProductShortName, 10, 3)
         End If
 
         RunTimeEnvironmentInfo.OSStringIdentifier = ReplaceString (RunTimeEnvironmentInfo.OSStringIdentifier, "_", "")

End Function

' --------------------------------------------------------------------------------------------------------
Function GetOSUpgrade ()

         Dim arrayTempValue, strTemp, strRegistryHive

         On Error Resume Next

         Select Case RunTimeEnvironmentInfo.OSIdentifier
                Case cWindows2000SP1
                     strRegistryHive = "HKLM\SOFTWARE\Microsoft\Updates\Windows 2000\SP1\Q259524"
                Case cWindows2000SP2
                     strRegistryHive = "HKLM\SOFTWARE\Microsoft\Updates\Windows 2000\SP2\Q282522"
                Case cWindows2000SP3
                     strRegistryHive = "HKLM\SOFTWARE\Microsoft\Updates\Windows 2000\SP3\Q282522"
                Case cWindows2000SP4
                     strRegistryHive = "HKLM\SOFTWARE\Microsoft\Updates\Windows 2000\SP4\Q327194"
                Case cWindowsXPSP1
                     strRegistryHive = "HKLM\SOFTWARE\Microsoft\Updates\Windows XP\SP1\Q324720"
                Case cWindowsXPSP2
                     strRegistryHive = "HKLM\SOFTWARE\Microsoft\Updates\Windows XP\SP2\KB811113"
				Case cWindowsXPSP3
                     strRegistryHive = "HKLM\SOFTWARE\Microsoft\Updates\Windows XP\SP3\KB936929"
                Case cWindows2003SP1
                     strRegistryHive = "HKLM\SOFTWARE\Microsoft\Updates\Windows Server 2003\SP1\KB889101"
				Case cWindows2003SP2
                     strRegistryHive = "HKLM\SOFTWARE\Microsoft\Updates\Windows Server 2003\SP2\KB914961"
                Case cWindowsVistaRTM, cWindowsVistaSP1, cWindows2008SP1, cWindows2008SP164, cWindows2008SP2, cWindows2008SP264, cWindows7RTM, cWindows7RTM64, cWindows7SP1, cWindows7SP164, cWindows2008R2RTM64, cWindows2008R2SP164
                     strRegistryHive = "HKLM\System\Setup"
                Case Else
                     strRegistryHive = ""
         End Select
         If RunTimeEnvironmentInfo.OSIdentifier < cWindowsVistaRTM Then
            If Len (strRegistryHive) > 0 Then
               arrayTempValue = ReadRegistry (Null, _
                                              strRegistryHive, _
                                              "Description", _
                                              "REG_SZ", _
                                              False)

               If IsArray (arrayTempValue) = True Then
                  strTemp = "Windows system upgraded to " & arrayTempValue (0)
                          
                  arrayTempValue = ReadRegistry (Null, _
                                                 strRegistryHive, _
                                                 "InstalledDate", _
                                                 "REG_SZ", _
                                                 False)
                  If IsArray (arrayTempValue) = True Then
                     strTemp = StrTemp & " on " & FormatDateTime (arrayTempValue (0), vbLongDate) & "."
                  End If
               Else
                   StrTemp = ""
               End If
            End If 
         Else 
            arrayTempValue = ReadRegistry (Null, _
                                           strRegistryHive, _
                                           "Upgrade", _
                                           "REG_DWORD", _
                                           False)

            If IsArray (arrayTempValue) = True Then
               If Cint (arrayTempValue (0)) = 0 Then
                  strTemp = "Windows system upgraded to Windows Vista (" & RunTimeEnvironmentInfo.NTBuild & ")"
               Else
                  strTemp = "Windows Vista or newer - Clean installation detected (" & RunTimeEnvironmentInfo.NTBuild & ")"
               End If
            Else
               strTemp = "Windows Vista or newer - Clean installation detected (" & RunTimeEnvironmentInfo.NTBuild & ")"
            End If
         End If

         GetOSUpgrade = strTemp

End Function

' --------------------------------------------------------------------------------------------------------
Function ReadEnvironmentVariable (ByVal objLOGFileHandle, ByVal strEnvironmentType, ByVal strVarName)

         Dim objEnvironment
 
         On Error Resume Next
 
         WriteToLogFile objLOGFileHandle, "Reading environment variable (" & strEnvironmentType & ") '" & strVarName & "'.", cLoggingLevel3, False
 
         ' Create a new variable via environment object.
         Set objEnvironment = objWshShell.Environment (strEnvironmentType)
         If Err.Number Then
            ErrorHandler objLOGFileHandle, "ReadEnvironmentVariable", "", False, Err
            Exit Function
         End If
 
         ReadEnvironmentVariable = objWshShell.ExpandEnvironmentStrings (objEnvironment(strVarName))
         If Err.Number Then
            ErrorHandler objLOGFileHandle, "ReadEnvironmentVariable", "", False, Err
            Exit Function
         End If

         WriteToLogFile objLOGFileHandle, "(" & strEnvironmentType & ") '" & _
                                  strVarName & "' -> '" & ReadEnvironmentVariable & "'", cLoggingLevel4, False

         Set objEnvironment = Nothing

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckRegistrySetup (ByVal objLOGFileHandle, ByVal arrayRegistryData, ByVal strRegQualifier)
 
         Dim intHiveIndex, intKeyIndex, intLoggingLevel
         Dim strRegistryValue, arrayRegistryValue
         Dim strRegistryExpectedValue, arrayRegistryExpectedValue
         Dim boolFoundRegKey, boolReadRegistryError

         On Error Resume Next
 
         CheckRegistrySetup = False
 
         For intHiveIndex = 0 To UBound (arrayRegistryData) Step 2
             If IsArray (arrayRegistryData (intHiveIndex + 1)) = True Then
                For intKeyIndex = 0 To UBound (arrayRegistryData (intHiveIndex + 1)) Step 4

                    If boolStrict = True Then arrayRegistryData (intHiveIndex + 1)(intKeyIndex) = cRegistryError

                    Select Case Cint (arrayRegistryData (intHiveIndex + 1)(intKeyIndex))
                           Case CRegistryError
                                intLoggingLevel = cLoggingLevel1
                                boolReadRegistryError = True
                           Case CRegistryWarning
                                intLoggingLevel = cLoggingLevel2
                                boolReadRegistryError = True
                           Case cRegistryWarningWhenPresent
                                intLoggingLevel = cLoggingLevel2
                                boolReadRegistryError = False
                           Case Else
                                intLoggingLevel = cLoggingLevel3
                                boolReadRegistryError = True
                    End Select 

                    Select Case arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 2)
                           Case "REG_DWORD", "REG_BINARY", "REG_MULTI_SZ"
                                 arrayRegistryValue = ReadRegistry (objLOGFileHandle, arrayRegistryData (intHiveIndex), _
                                                                    arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 1), _
                                                                    arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 2), _
                                                                    boolReadRegistryError)
                           Case "REG_SZ", "REG_EXPAND_SZ"
                                 arrayRegistryValue = ReadRegistry (objLOGFileHandle, arrayRegistryData (intHiveIndex), _
                                                                    arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 1), _
                                                                    "REG_SZ", _
                                                                    boolReadRegistryError)
                    End Select
 
                    If IsArray (arrayRegistryValue) = True Then
                       If Len (arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 1)) = 0 Then arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 1) = "(Default)"

                       If Len (arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 3)) > 0 And _
                          arrayRegistryData (intHiveIndex + 1)(intKeyIndex) <> cRegistryWarningWhenPresent Then 

                          Select Case arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 2)
                                 Case "REG_MULTI_SZ"
                                      arrayRegistryExpectedValue = ConvertStringInArray (arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 3), ",")
                                      strRegistryValue = ConvertArrayInString (arrayRegistryValue, ",")

                                      boolFoundRegKey = False
                                      For Each strRegistryExpectedValue In arrayRegistryExpectedValue
                                          If InStr (UCase (strRegistryValue), Ucase (strRegistryExpectedValue)) > 0 Then
                                             boolFoundRegKey = True
                                          Else
                                             boolFoundRegKey = False
                                             Exit For
                                          End If
                                      Next

                                      If boolFoundRegKey Then
                                         WriteToLogFile objLOGFileHandle, "WMI registry key (" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 2) & ") '" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 1) & "' is correct.", cLoggingLevel3, False
                                      Else
                                         WriteToLogFile objLOGFileHandle, "WMI registry key (" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 2) & ") '" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 1) & "' is incorrect.", intLoggingLevel, False
                                         TrackingData.InvalidWMIRegistrySetup = AddTrackingData (TrackingData.InvalidWMIRegistrySetup, strRegQualifier & ";" & arrayRegistryData (intHiveIndex) & ";" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 2) & ";" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 1) & ";" & ReplaceString (Ucase (strRegistryValue) & ";" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 3), ",", " ") & ";" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex))
                                         WriteToLogFile objLOGFileHandle, "Expected in the registry: '" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 3) & "'", intLoggingLevel, False
                                         If intLoggingLevel = cLoggingLevel1 Then CheckRegistrySetup = True
                                      End If
                                 Case "REG_BINARY"
                                      strRegistryValue = ConvertArrayInString (arrayRegistryValue , ",")
                                      If Ucase (strRegistryValue) = UCase (arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 3)) Then
                                         WriteToLogFile objLOGFileHandle, "WMI registry key (" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 2) & ") '" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 1) & "' is correct.", cLoggingLevel3, False
                                      Else
                                         WriteToLogFile objLOGFileHandle, "WMI registry key (" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 2) & ") '" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 1) & "' is incorrect.", intLoggingLevel, False
                                         TrackingData.InvalidWMIRegistrySetup = AddTrackingData (TrackingData.InvalidWMIRegistrySetup, strRegQualifier & ";" & arrayRegistryData (intHiveIndex) & ";" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 2) & ";" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 1) & ";" & ReplaceString (Ucase (strRegistryValue) & ";" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 3), ",", " ") & ";" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex))
                                         WriteToLogFile objLOGFileHandle, "Expected in the registry: '" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 3) & "'", intLoggingLevel, False
                                         If intLoggingLevel = cLoggingLevel1 Then CheckRegistrySetup = True
                                      End If
                                 Case "REG_DWORD"
                                      If CLng(arrayRegistryValue(0)) = CLng(arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 3)) Then
                                         WriteToLogFile objLOGFileHandle, "WMI registry key (" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 2) & ") '" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 1) & "' is correct.", cLoggingLevel3, False
                                      Else
                                         WriteToLogFile objLOGFileHandle, "WMI registry key (" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 2) & ") '" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 1) & "' is incorrect.", intLoggingLevel, False
                                         TrackingData.InvalidWMIRegistrySetup = AddTrackingData (TrackingData.InvalidWMIRegistrySetup, strRegQualifier & ";" & arrayRegistryData (intHiveIndex) & ";" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 2) & ";" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 1) & ";" & arrayRegistryValue(0) & ";" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 3) & ";" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex))
                                         WriteToLogFile objLOGFileHandle, "Expected in the registry: '" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 3) & "'", intLoggingLevel, False
                                         If intLoggingLevel = cLoggingLevel1 Then CheckRegistrySetup = True
                                      End If 
                                 Case "REG_EXPAND_SZ"
                                      If UCase (objWshShell.ExpandEnvironmentStrings (arrayRegistryValue(0))) = UCase (objWshShell.ExpandEnvironmentStrings (arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 3))) Then
                                         WriteToLogFile objLOGFileHandle, "WMI registry key (" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 2) & ") '" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 1) & "' is correct.", cLoggingLevel3, False
                                      Else
                                         WriteToLogFile objLOGFileHandle, "WMI registry key (" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 2) & ") '" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 1) & "' is incorrect.", intLoggingLevel, False
                                         TrackingData.InvalidWMIRegistrySetup = AddTrackingData (TrackingData.InvalidWMIRegistrySetup, strRegQualifier & ";" & arrayRegistryData (intHiveIndex) & ";" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 2) & ";" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 1) & ";" & arrayRegistryValue(0) & ";" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 3) & ";" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex))
                                         WriteToLogFile objLOGFileHandle, "Expected in the registry: '" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 3) & "'", intLoggingLevel, False
                                         If intLoggingLevel = cLoggingLevel1 Then CheckRegistrySetup = True
                                      End If
                                 Case "REG_SZ"
                                      If UCase (arrayRegistryValue(0)) = UCase (arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 3)) Then
                                         WriteToLogFile objLOGFileHandle, "WMI registry key (" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 2) & ") '" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 1) & "' is correct.", cLoggingLevel3, False
                                      Else
                                         WriteToLogFile objLOGFileHandle, "WMI registry key (" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 2) & ") '" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 1) & "' is incorrect.", intLoggingLevel, False
                                         TrackingData.InvalidWMIRegistrySetup = AddTrackingData (TrackingData.InvalidWMIRegistrySetup, strRegQualifier & ";" & arrayRegistryData (intHiveIndex) & ";" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 2) & ";" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 1) & ";" & arrayRegistryValue(0) & ";" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 3) & ";" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex))
                                         WriteToLogFile objLOGFileHandle, "Expected in the registry: '" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 3) & "'", intLoggingLevel, False
                                         If intLoggingLevel = cLoggingLevel1 Then CheckRegistrySetup = True
                                      End If
                          End Select
                       Else
                          If arrayRegistryData (intHiveIndex + 1)(intKeyIndex) = cRegistryWarningWhenPresent Then
                             WriteToLogFile objLOGFileHandle, "WMI registry hive (" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 2) & ") '" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 1) & "' is present, while it should NOT be!", cLoggingLevel2, False
                             TrackingData.InvalidWMIRegistrySetup = AddTrackingData (TrackingData.InvalidWMIRegistrySetup, "EXTRAREGISTRYKEY;" & arrayRegistryData (intHiveIndex) & ";" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 2) & ";" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 1) & ";;" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 3) & ";" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex))
                             CheckRegistrySetup = True
                          Else
                             WriteToLogFile objLOGFileHandle, "WMI registry hive (" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 2) & ") '" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 1) & "' is present.", cLoggingLevel3, False
                          End If
                       End If
                    Else
                       If arrayRegistryData (intHiveIndex + 1)(intKeyIndex) = cRegistryWarningWhenPresent Then
                          WriteToLogFile objLOGFileHandle, "WMI registry key (" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 2) & ") '" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 1) & "' is missing, which is FINE.", cLoggingLevel3, False
                       Else
                          WriteToLogFile objLOGFileHandle, "WMI registry key (" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 2) & ") '" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 1) & "' is missing or is access denied.", cLoggingLevel1, False
                          TrackingData.InvalidWMIRegistrySetup = AddTrackingData (TrackingData.InvalidWMIRegistrySetup, "MISSINGREGISTRYKEY;" & arrayRegistryData (intHiveIndex) & ";" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 2) & ";" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 1) & ";;" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex + 3) & ";" & arrayRegistryData (intHiveIndex + 1)(intKeyIndex))
                          CheckRegistrySetup = True
                       End If
                    End If
                Next
             End If
 	Next

End Function

' --------------------------------------------------------------------------------------------------------
Function ParseFile (ByVal objLOGFileHandle, ByVal strFileName, ByVal arrayFilter, ByRef arrayMatchingOutput, ByVal boolNoSpace, ByVal boolLoggingDebug)

         Dim objParseFileHandle, strText, intLineCounter
         Dim intMatchingOutputIndex, intIndex
 
         On Error Resume Next

         WriteToLogFile objLOGFileHandle, "Parsing file '" & strFileName & "' for '" & ConvertArrayInString (arrayFilter, ", ") & "'.", cLoggingDebug Or cLoggingLevel4, False
 
         ReDim arrayOutput (0), arrayMatchingOutput (0)
         intMatchingOutputIndex = 0
         ParseFile = False

         If boolNoSpace = True Then
            For intIndex = 0 to UBound (arrayFilter)
                arrayFilter (intIndex) = ReplaceString (arrayFilter (intIndex), " ", "")
            Next
         End If

         intLineCounter = 0

         Set objParseFileHandle = OpenTextFile (strFileName) 
         If IsNull (objParseFileHandle) = False Then
            Do while (objParseFileHandle.AtEndOfStream = False)
                     ReadFromFile objParseFileHandle, strText

                     intLineCounter = intLineCounter + 1

                     If boolLoggingDebug = True Then
                        WriteToLogFile objLOGFileHandle, "-> '" & strText & "'", cLoggingDebug Or cLoggingLevel4, False
                     End If

                     If boolNoSpace = True Then
                        strText = ReplaceString (strText, " ", "")
                     End If
 
                     For intIndex = 0 to UBound (arrayFilter)
                         If Instr (Ucase (strText), Ucase (arrayFilter (intIndex))) > 0 Then
                            arrayMatchingOutput (intMatchingOutputIndex) = strText 
                            intMatchingOutputIndex = intMatchingOutputIndex + 1
                            ReDim Preserve arrayMatchingOutput (intMatchingOutputIndex)

                            WriteToLogFile objLOGFileHandle, "   Found at line " & intLineCounter & " an occurrence of '" & arrayFilter (intIndex) & ".", cLoggingDebug Or cLoggingLevel4, False
          
                            ParseFile = True
                         End If
                     Next
            Loop
         End If

         WriteToLogFile objLOGFileHandle, "Found " & intMatchingOutputIndex & " occurrence(s) in '" & strFileName & "'.", cLoggingDebug Or cLoggingLevel4, False
 
         CloseTextFile objParseFileHandle

End Function

' --------------------------------------------------------------------------------------------------------
Function ShellExecute (ByVal objLOGFileHandle, ByVal strCommandLine, ByVal strFilter, ByRef arrayOutput, ByRef arrayMatchingOutput)
      
         Dim objWshExec, strOutput, intTickCounter, intOutputIndex, intMatchingOutputIndex

         On Error Resume Next

         ReDim arrayOutput (0), arrayMatchingOutput (0)
         intMatchingOutputIndex = 0
         intOutputIndex = 0
         ShellExecute = False

         If RunTimeEnvironmentInfo.EngineVersion >= 5.6 Then
            WriteToLogFile objLOGFileHandle, "Shell executing '" & strCommandLine & "'.", cLoggingDebug Or cLoggingLevel4, False

            Set objWshExec = objWshShell.Exec (strCommandLine)

            If objWshExec.Status = 0 Then
               WriteToLogFile objLOGFileHandle, "Shell Execute command started (" & objWshExec.ProcessID & ").", cLoggingDebug Or cLoggingLevel4, False
            End If

            Do
               strOutput = objWshExec.StdOut.ReadLine()
   
               arrayOutput (intOutputIndex) = strOutput
               WriteToLogFile objLOGFileHandle, "-> '" & arrayOutput (intOutputIndex) & "'.", cLoggingDebug Or cLoggingLevel4, False

               intOutputIndex = intOutputIndex + 1
               ReDim Preserve arrayOutput (intOutputIndex)
   
               If Len (strFilter) > 0 Then
                  If Instr (UCase (strOutput), Ucase (strFilter)) > 0 Then
   
                     arrayMatchingOutput (intMatchingOutputIndex) = strOutput
                     intMatchingOutputIndex = intMatchingOutputIndex + 1
                     ReDim Preserve arrayMatchingOutput (intMatchingOutputIndex)
   
                     WriteToLogFile objLOGFileHandle, "   Found at line " & intOutputIndex & " an occurrence of '" & strFilter & ".", cLoggingDebug Or cLoggingLevel4, False
                  End If
               End If
            Loop While Not (objWshExec.StdOut.AtEndOfStream)

            Do 
               If intTickCounter > 20 Then
                  objWshExec.Terminate
                  ShellExecute = ErrorHandler (objLOGFileHandle, "ShellExecute", "Shell Execute command killed due to timeout.", True, Err)
                  Exit Do 
               End If

               WScript.Sleep (cSleepDelay)
               intTickCounter = intTickCounter + 1
   
               If objWshExec.Status = 0 Then
                  WriteToLogFile objLOGFileHandle, "Waiting for Shell Execute command to complete ..." & intTickCounter * cSleepDelay & " ms.", cLoggingDebug Or cLoggingLevel4, False
               Else
                  WriteToLogFile objLOGFileHandle, "Shell Execute command completed.", cLoggingDebug Or cLoggingLevel4, False
                  WriteToLogFile objLOGFileHandle, "Found " & intMatchingOutputIndex & " occurrence(s) of '" & strFilter & "'.", cLoggingDebug Or cLoggingLevel4, False
               End If

            Loop Until Not (objWshExec.Status = 0) 
         Else
            WriteToLogFile objLOGFileHandle, "Shell execution not supported for WSH " & RunTimeEnvironmentInfo.EngineVersion & ".", cLoggingDebug Or cLoggingLevel4, False
            ShellExecute = True
         End If 

End Function

' -----------------------------------------------------------------------------------------------------------------------
Function DisplayFormattedWMIProperties (ByVal objLOGFileHandle, ByVal objWMIInstance, ByVal intIndex, ByVal intIndent, ByVal intLoggingLevel)

         Dim objWMIProperty, objWMIProperties
         Dim varElement, intCount
 
         On Error Resume Next

         WriteToLogFile objLOGFileHandle, Space (intIndent) & "- " & objWMIInstance.Path_.Class & " #" & Left (intIndex & " ---", 4) & _
                        String (100 - Len (objWMIInstance.Path_.Class), "-"), intLoggingLevel, False
     
         Set objWMIProperties = objWMIInstance.Properties_
         For Each objWMIProperty In objWMIProperties
             If Not IsNull (objWMIProperty.Value) Then
                If objWMIProperty.CIMType = wbemCimtypeObject Then
                   If objWMIProperty.IsArray Then
                      intCount = 0
                      For Each varElement In objWMIProperty.Value
                          intCount = intCount + 1
                          DisplayFormattedWMIProperties objLOGFileHandle, varElement, intCount, intIndent + 2, intLoggingLevel + 2
                      Next
                   Else
                      DisplayFormattedWMIProperties objLOGFileHandle, objWMIProperty.Value, 1, intIndent + 2, intLoggingLevel + 2
                   End If
                Else
                   Select Case Ucase (objWMIProperty.Name) 
                          Case "SECURITY_DESCRIPTOR", "CREATORSID"
                               DisplayFormattedWMIProperty objLOGFileHandle, _
                                                           objWMIInstance, _
                                                           Space (intIndent) & objWMIProperty.Name, _
                                                           ConvertArrayInString (objWMIProperty.Value, ","), _
                                                           Null, _
                                                           intLoggingLevel
                          Case Else
                               DisplayFormattedWMIProperty objLOGFileHandle, _
                                                           objWMIInstance, _
                                                           Space (intIndent) & objWMIProperty.Name, _
                                                           objWMIProperty.Name, _
                                                           Null, _
                                                           intLoggingLevel
                   End Select
                End If
             End If
         Next
         Set objWMIProperties = Nothing
    
End Function

' -----------------------------------------------------------------------------------------------------------------------
Function DisplayFormattedWMIProperty (ByVal objLOGFileHandle, ByVal objWMIInstance, ByVal strText, ByVal strProperty1, ByVal strProperty2, ByVal intLoggingLevel)

         Dim intIndex
         Dim varValue1, varValue2
         Dim boolCIMKey, strCIMKey
         Dim intSpace
 
         On Error Resume Next
 
         If Not IsNull (strProperty1) Then 
            varValue1 = objWMIInstance.Properties_.Item (strProperty1)
            If Err.Number Then
               varValue1 = strProperty1
               Err.Clear
            Else
               Select Case objWMIInstance.Properties_.Item (strProperty1).CIMType
                      Case wbemCimtypeBoolean
                           varValue1 = Ucase (varValue1)
                      Case wbemCimtypeObject
                           varValue1 = "<OBJECT>"
               End Select
 
               boolCIMKey = objWMIInstance.Properties_.Item (strProperty1).Qualifiers_.Item("key").Value 
 
               If Err.Number Then 
                  Err.Clear
                  boolCIMKey = False
               End If
               If boolCIMKey Then
                  If Mid (strText, 1, 1) = Chr (32) Then
                     intSpace = Len (strText) - Len(LTrim(strText))
                     strText = Space(intSpace) & "*" & Ltrim(strText)
                  Else
                     strText = "*" & strText
                  End If
               End If
            End If
         Else 
            varValue1 = strProperty1
         End If
     
         If Not IsNull (strProperty2) Then 
            varValue2 = objWMIInstance.Properties_.Item (strProperty2)
            If Err.Number Then
               varValue2 = strProperty2
               Err.Clear
            Else
               Select Case objWMIInstance.Properties_.Item (strProperty2).CIMType
                      Case wbemCimtypeBoolean
                           varValue2 = Ucase (varValue2)
                      Case wbemCimtypeObject
                           varValue2 = "<OBJECT>"
               End Select  
            End If
         Else 
            varValue2 = strProperty2
         End If
     
         If Not IsNull (varValue1) Then
            If Not IsNull (varValue2) Then
               If IsArray (varValue1) = True Then
                  For intIndex=0 To UBound(varValue1)
                      If intIndex = 0 Then
                         WriteToLogFile objLOGFileHandle, StrText & ": " & string (40 - Len(strText), ".") & _
                                        " " & Trim (varValue1 (intIndex)) & _
                                        " " & Trim (varValue2 (intIndex)), _
                                        intLoggingLevel, False
                      Else
                         WriteToLogFile objLOGFileHandle, Space (42) & _
                                        " " & Trim (varValue1 (intIndex)) & _
                                        " " & Trim (varValue2 (intIndex)), _
                                        intLoggingLevel, False
                      End If
                  Next
              Else
                  WriteToLogFile objLOGFileHandle, StrText & ": " & string (40 - Len(strText), ".") & _
                                 " " & Trim (varValue1) & _
                                 " " & Trim (varValue2), _ 
                                 intLoggingLevel, False
              End If
            Else
               If IsArray (varValue1) = True Then
                  For intIndex=0 To UBound(varValue1)
                      If intIndex = 0 Then
                         WriteToLogFile objLOGFileHandle, StrText & ": " & string (40 - Len(strText), ".") & _
                                        " " & CleanString (varValue1 (intIndex), 32, 255), _
                                        intLoggingLevel, False
                      Else
                         WriteToLogFile objLOGFileHandle, Space (42) & _
                                        " " & CleanString (varValue1 (intIndex), 32, 255), _
                                        intLoggingLevel, False
                      End If
                  Next
               Else
                  WriteToLogFile objLOGFileHandle, StrText & ": " & string (40 - Len(strText), ".") & _
                                 " " & CleanString (varValue1, 32, 255), _
                                 intLoggingLevel, False
               End If
            End If
         End If
     
         Err.Clear
    
End Function

' -----------------------------------------------------------------------------------------------------------------------
Function DisplayFormattedProperty (ByVal objLOGFileHandle, ByVal strText, ByVal varValue1, ByVal varValue2, ByVal intLoggingLevel)

         Dim intIndex

         On Error Resume Next

         If Not IsNull (varValue1) Then
            If Not IsNull (varValue2) Then
               If IsArray (varValue1) = True Then
                  For intIndex = 0 To UBound(varValue1)
                      If intIndex = 0 Then
                         WriteToLogFile objLOGFileHandle, strText & ": " & string (40 - Len(strText), ".") & _
                                                          " " & varValue1 (intIndex) & _
                                                          " " & varValue2 (intIndex), _
                                        intLoggingLevel, False
                      Else
                         WriteToLogFile objLOGFileHandle, Space (42) & _
                                                          " " & varValue1 (intIndex) & _
                                                          " " & varValue2 (intIndex), _
                                        intLoggingLevel, False
                      End if
                  Next
              Else
                  If Len (varValue1) > 0 Then
                     WriteToLogFile objLOGFileHandle, strText & ": " & string (40 - Len(strText), ".") & _
                                                      " " & varValue1 & _
                                                      " " & varValue2, _
                                    intLoggingLevel, False
                  End If
               End IF
            Else
               If IsArray (varValue1) = True Then
                  For intIndex = 0 To UBound(varValue1)
                      If intIndex = 0 Then
                         WriteToLogFile objLOGFileHandle, strText & ": " & string (40 - Len(strText), ".") & _
                                                          " " & varValue1 (intIndex), _
                                        intLoggingLevel, False
                      Else
                         WriteToLogFile objLOGFileHandle, Space (42) & _
                                                          " " & varValue1 (intIndex), _
                                        intLoggingLevel, False
                      End If
                  Next
               Else
                  If Len (varValue1) > 0 Then
                     WriteToLogFile objLOGFileHandle, strText & ": " & string (40 - Len(strText), ".") & _
                                                      " " & varValue1, _
                                    intLoggingLevel, False
                  End If
               End If
            End If
         End If

End Function

' -----------------------------------------------------------------------------------------------------------------------
Function ExtractWMIClassFromWQL (ByVal objLOGFileHandle, ByVal strWQL)

         Dim intStringPosition, strTemp

         On Error Resume Next

         intStringPosition = Instr (UCase (strWQL), "FROM ") 
         If intStringPosition > 0 Then
            strTemp = Trim (Mid (strWQL, intStringPosition + 5))
            intStringPosition = Instr (Ucase (strTemp), " WHERE") 
            If intStringPosition > 0 Then
               ExtractWMIClassFromWQL = Trim (Mid (strTemp, 1, intStringPosition))
            Else
               ExtractWMIClassFromWQL = strTemp
            End If 
         Else
            WriteToLogFile objLOGFileHandle, "'" & strWQL &  "' is an invalid query.", cLoggingLevel2, False
            ExtractWMIClassFromWQL = Null
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function ConvertDMTFDateTimeToLongDateTime (ByVal objLOGFileHandle, ByVal strDMTFDateTime, ByRef strDate, ByRef strTime, ByRef strGMT, ByVal boolLongTime)

         Dim strMonth

         On Error Resume Next

         WriteToLogFile objLOGFileHandle, "Converting '" & strDMTFDateTime & "'.", cLoggingDebug Or cLoggingLevel4, False

         Select Case Cint (Mid (strDMTFDateTime, 5, 2))
                Case 1
                     strMonth = "January"
                Case 2
                     strMonth = "February"
                Case 3
                     strMonth = "March"
                Case 4
                     strMonth = "April"
                Case 5
                     strMonth = "May"
                Case 6
                     strMonth = "June"
                Case 7
                     strMonth = "July"
                Case 8
                     strMonth = "August"
                Case 9
                     strMonth = "September"
                Case 10
                     strMonth = "October"
                Case 11
                     strMonth = "November"
                Case 12
                     strMonth = "December"
         End Select

         strDate = Mid (strDMTFDateTime, 5, 2) & "/" & _
                   Mid (strDMTFDateTime, 7, 2) & "/" & _
                   Mid (strDMTFDateTime, 1, 4)

         If boolLongTime = True Then
            strTime = Mid (strDMTFDateTime, 9, 2) & ":" & _
                      Mid (strDMTFDateTime, 11, 2) & ":" & _
                      Mid (strDMTFDateTime, 13, 2) & ":" & _
                      Mid (strDMTFDateTime, 16, 6)
         Else
            strTime = Mid (strDMTFDateTime, 9, 2) & ":" & _
                      Mid (strDMTFDateTime, 11, 2) & ":" & _
                      Mid (strDMTFDateTime, 13, 2)
         End If

         If Cint (Mid (strDMTFDateTime, 23, 4) / 60) <= 0 Then
            strGMT = "GMT-" & Mid (strDMTFDateTime, 23, 3) / 60
         Else
            strGMT = "GMT+" & Mid (strDMTFDateTime, 23, 3) / 60
         End If

         ConvertDMTFDateTimeToLongDateTime = Mid (strDMTFDateTime, 7, 2) & " " & _
                               strMonth & " " & _
                               Mid (strDMTFDateTime, 1, 4) & _
                               " " & strTime & " (" & strGMT & ")"

End Function

' ---------------------------------------------------------------------------------------------------------
Function ConvertDateTimeToDMTFDateTime (ByVal objLOGFileHandle, ByVal strDate, ByVal strTime)

         Dim intBias, strSign, arrayRegistryValue

         On Error Resume Next

         arrayRegistryValue = ReadRegistry (objLOGFileHandle, "HKLM\SYSTEM\CurrentControlSet\Control\TimeZoneInformation", _
                                            "ActiveTimeBias", _
                                            "REG_DWORD", _
                                            False)

         If IsArray (arrayRegistryValue) = True Then
            intBias = Cint (arrayRegistryValue (0))
         Else
            intBias = 0
         End If

         If intBias >= 0 Then 
            strSign = "-" 
         Else 
            strSign = "+" 
         End If

         ConvertDateTimeToDMTFDateTime = Right ("00" & Year(strDate), 4) & Right ("0" & Month(strDate), 2) & Right ("0" & Day(strDate), 2) & _
                      Right ("0" & Hour(strTime), 2) & Right ("0" & Minute(strTime), 2) & Right ("0" & Second(strTime), 2) & _
                      ".000000" & strSign & Right ("000" & intBias, 3)

End Function 

' -----------------------------------------------------------------------------------------------------------------------
Function ConvertStringInArray (ByVal strTemp, ByVal strSeparator)

         Dim intArrayIndex
         Dim intSeparatorPosition
         Dim strTempItem()

         On Error Resume Next

         intArrayIndex = 0
         ReDim strTempItem(intArrayIndex) 
 
         strTemp = Trim (strTemp)
         Do
            intSeparatorPosition = InStr(strTemp, strSeparator)
            If intSeparatorPosition Then
               ReDim Preserve strTempItem(intArrayIndex)
               strTempItem(intArrayIndex) = Trim(Mid(strTemp, 1, intSeparatorPosition - 1))
               strTemp = Trim(Mid(strTemp, intSeparatorPosition + 1))
               intArrayIndex = intArrayIndex + 1
            Else
               ReDim Preserve strTempItem(intArrayIndex)
               strTempItem(intArrayIndex) = Trim(strTemp)
               Exit Do
            End If
         Loop 
 
         ConvertStringInArray = strTempItem

End Function

' --------------------------------------------------------------------------------------------------------
Function ConvertArrayInString (ByVal arrayData, ByVal strSeparator)
 
         Dim varElement
         Dim strTemp
 
         On Error Resume Next
 
         If IsArray (arrayData) = True Then
            For Each varElement In arrayData
               If Len(strTemp) = 0 Then
                   strTemp = varElement
                Else
                   strTemp = strTemp & strSeparator & varElement
                End If
            Next
            ConvertArrayInString = strTemp
         Else
            ConvertArrayInString = arrayData
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function ReplaceString (ByVal strSourceString, ByVal strStringToSearch, ByVal strStringToReplace)

         Dim intIndex
 
         On Error Resume Next
 
         If IsArray (strSourceString) = True Then
            For intIndex = 0 To UBound (strSourceString)
                ReplaceString = ReplaceString2 (strSourceString (intIndex), strStringToSearch, strStringToReplace)            
            Next
         Else
            ReplaceString = ReplaceString2 (strSourceString, strStringToSearch, strStringToReplace)            
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function ReplaceString2 (ByVal strSourceString, ByVal strStringToSearch, ByVal strStringToReplace)

         Dim intStringPosition
 
         On Error Resume Next
 
         Do
               intStringPosition = Instr (Ucase(strSourceString), Ucase(strStringToSearch))
               If intStringPosition > 0 Then
                  If intStringPosition = 1 Then
                     strSourceString = strStringToReplace & _
                                       Mid (strSourceString, _
                                            Len (strStringToSearch) + 1)
                  Else
                     strSourceString = Mid (strSourceString, _
                                            1, _
                                            intStringPosition - 1) & _
                                            strStringToReplace & _
                                            Mid (strSourceString, intStringPosition + Len (strStringToSearch))
                  End If
               End If
         Loop Until intStringPosition = 0
 
         ReplaceString2 = strSourceString
 
End Function

' --------------------------------------------------------------------------------------------------------
Function ReplaceChar (ByVal strString, ByVal strReplacedChar, ByVal strReplacingString)

         Dim intIndex
         Dim strTemp
         Dim strNewString

         On Error Resume Next
     
         For intIndex = 1 to Len(strString)
             strTemp = Mid(strString, intIndex, 1)
             If (strTemp = strReplacedChar) Then
                strNewString = strNewString & strReplacingString
             Else
                strNewString = strNewString & strTemp
             End If
         Next
     
         ReplaceChar = strNewString

End Function

' --------------------------------------------------------------------------------------------------------
Function SplitStringReverse (ByVal strSourceString, ByVal intSide, ByVal chrSeparator)

         Dim intPosition, strLeftString, strRightString
 
         On Error Resume Next
 
         intPosition = InStrRev (strSourceString, chrSeparator)
         If intPosition > 0 Then
            strLeftString = Left (strSourceString, intPosition - 1)
            strRightString = Mid (strSourceString, intPosition + 1)
         Else
            strLeftString = strSourceString
            strRightString = strSourceString
         End If
  
         Select Case intSide
                Case 1
                     SplitStringReverse = strRightString 
                Case -1
                     SplitStringReverse = strLeftString 
         End Select

End Function

' --------------------------------------------------------------------------------------------------------
Function CleanString (ByVal strSourceString, ByVal intAsciiLower, ByVal intAsciiUpper)

         Dim intStringPosition, strTargetString
 
         On Error Resume Next

         For intStringPosition = 1 To Len (strSourceString)
             If Asc (Mid (strSourceString, intStringPosition, 1)) < intAsciiLower Or _ 
                Asc (Mid (strSourceString, intStringPosition, 1)) > intAsciiUpper Then
                strTargetString = strTargetString & " "
             Else
                strTargetString = strTargetString & Mid (strSourceString, intStringPosition, 1)
             End If
         Next
 
         CleanString = Trim (ReplaceString (strTargetString, "  ", " "))

End Function

' --------------------------------------------------------------------------------------------------------
Function SplitStringInArrayBySpace (ByVal strSourceString, ByVal intSplitter)

         Dim intIndex, intStringPosition1, intStringPosition2, intStringLastPosition, arrayString 
 
         On Error Resume Next

         intIndex = 0
         ReDim arrayString (0)
         intStringLastPosition = 1

         strSourceString = Trim (strSourceString)

         For intStringPosition1 = intSplitter To Len (strSourceString) Step intSplitter

             intStringPosition2 = intStringPosition1

             Do 
                  If (Mid (strSourceString, intStringPosition2, 1) = " ") Then
                     arrayString (intIndex) = Trim (Mid (strSourceString, intStringLastPosition, intSplitter + intStringPosition2 - intStringPosition1))
                     intStringLastPosition = intStringPosition2

                     intIndex = intIndex + 1
                     ReDim Preserve arrayString (intIndex)

                     Exit Do
                  End If
 
                  intStringPosition2 = intStringPosition2 + 1
        
             Loop While intStringPosition2 < Len (strSourceString)
    
             intStringPosition1 = intStringPosition2

         Next 

         arrayString (intIndex) = Trim (Mid (strSourceString, intStringLastPosition))

         SplitStringInArrayBySpace = arrayString

End Function

' --------------------------------------------------------------------------------------------------------
Function CheckServiceStartedState (ByVal objLOGFileHandle, ByVal strService)

         Dim arrayOutput (), arrayMatchingOutput ()
 
         On Error Resume Next

         WriteToLogFile objLOGFileHandle, "Verifying '" & UCase(strService) & "' service started state.", cLoggingLevel3, False
 
         CheckServiceStartedState = objShell.IsServiceRunning (strService)
 
         If CheckServiceStartedState Then 
            WriteToLogFile objLOGFileHandle, "'" & UCase(strService) & "' service IS started.", cLoggingLevel3, False
         Else
            WriteToLogFile objLOGFileHandle, "'" & UCase(strService) & "' service is NOT started.", cLoggingLevel3, False
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function StartService (ByVal objLOGFileHandle, ByVal strService)

         Dim arrayOutput (), arrayMatchingOutput ()
         Dim intTickCounter
 
         On Error Resume Next
 
         StartService = True
 
         WriteToLogFile objLOGFileHandle, "Verifying '" & strService & "' service status.", cLoggingLevel0, False
 
         If CheckServiceStartedState (objLOGFileHandle, strService) = True Then 
            TrackingData.ServiceState = AddTrackingData (TrackingData.ServiceState, strService & ";Already started;0x0")
            Exit Function
         End If
 
         objShell.ServiceStart strService, False
 
         intTickCounter = 0
         Do 
              If intTickCounter > 20 Then
                  StartService = ErrorHandler (objLOGFileHandle, "StartService", "Start service '" & UCase(strService) & "' command timeout.", False, Err)
                  TrackingData.ServiceState = AddTrackingData (TrackingData.ServiceState, strService & ";Failed to start;TIMEOUT")
                  Exit Function
              End If
 
              WScript.Sleep (cSleepDelay)
              intTickCounter = intTickCounter + 1
         Loop While (CheckServiceStartedState (objLOGFileHandle, strService) = False)

         WriteToLogFile objLOGFileHandle, "'" & UCase(strService) & "' service is successfully started.", cLoggingLevel3, True
         TrackingData.ServiceState = AddTrackingData (TrackingData.ServiceState, strService & ";Successfully started;0x0")
 
         StartService = False

End Function

' --------------------------------------------------------------------------------------------------------
Function WriteRegistry (ByVal objLOGFileHandle, ByVal strKeyName, ByVal strKeyValueName, ByVal strRegType, ByVal varRegKeyValue, ByVal boolWriteRegistryError)

         Dim strRegKey
 
         On Error Resume Next
 
         strRegKey = strKeyName & "\" & strKeyValueName
         Select Case strRegType
                Case "REG_BINARY"
                     WriteToLogFile objLOGFileHandle, "Writing registry (" & UCase(strRegType) & ") '" & _
                                 strRegKey & "' -> '&h" & Hex(varRegKeyValue) & "'", cLoggingDebug Or cLoggingLevel4, False
                Case "REG_DWORD"
                     WriteToLogFile objLOGFileHandle, "Writing registry (" & UCase(strRegType) & ") '" & _
                                 strRegKey & "' -> '&h" & Hex(varRegKeyValue) & "'", cLoggingDebug Or cLoggingLevel4, False
                Case "REG_MULTI_SZ"
                     ' RegWrite from WSH does not support REG_MULTI_SZ
                     Exit Function	
 
                Case Else
                     WriteToLogFile objLOGFileHandle, "Writing registry (" & UCase(strRegType) & ") '" & _
                                    strRegKey & "' -> '" & varRegKeyValue & "'", cLoggingDebug Or cLoggingLevel4, False
         End Select

         objWshShell.RegWrite strRegKey, varRegKeyValue, strRegType
         If Err.Number Then
            If boolWriteRegistryError Then
               WriteRegistry = ErrorHandler (objLOGFileHandle, "WriteRegistry", "", False, Err)
            Else
               Err.Clear
            End If
            Exit Function
         End If
 
End Function

' --------------------------------------------------------------------------------------------------------
Function ReadRegistry (ByVal objLOGFileHandle, ByVal strKeyName, ByVal strKeyValueName, ByVal strRegType, ByVal boolReadRegistryError)

         Dim strRegKey
         Dim varRegKeyValue()

         Dim intIndex
         Dim strTempValue
 
         On Error Resume Next
 
         strRegKey = strKeyName & "\" & strKeyValueName
         WriteToLogFile objLOGFileHandle, "Reading registry (" & strRegType & ") '" & strRegKey & "'.", cLoggingLevel4, False
 
         strTempValue = objWshShell.RegRead (strRegKey)
         If Err.Number Then
            If boolReadRegistryError Then 
               ErrorHandler objLOGFileHandle, "ReadRegistry", "", False, Err
            Else
               Err.Clear
            End If
            Exit Function
         End If
         Select Case strRegType
                Case "REG_BINARY"
                     ReDim varRegKeyValue(Ubound(strTempValue))
                     For intIndex = 0 to Ubound(strTempValue)
                         varRegKeyValue (intIndex) = "&h" & Right("0" & Hex(strTempValue(intIndex)),2)
                     Next
                     WriteToLogFile objLOGFileHandle, "(" & UCase(strRegType) & ") '" & strRegKey & "' -> '" & ConvertArrayInString (varRegKeyValue, ",") & "'", cLoggingDebug Or cLoggingLevel4, False
                Case "REG_DWORD"
                     ReDim varRegKeyValue(0)
                     varRegKeyValue(0) = "&h" & Hex (strTempValue)
                     WriteToLogFile objLOGFileHandle, "(" & UCase(strRegType) & ") '" & strRegKey & "' -> '" & varRegKeyValue (0) & "'", cLoggingDebug Or cLoggingLevel4, False
                Case "REG_MULTI_SZ"
                     ReDim varRegKeyValue(Ubound(strTempValue))
		     For intIndex = 0 to Ubound(strTempValue)
                        varRegKeyValue (intIndex) = Trim (strTempValue(intIndex))
                          WriteToLogFile objLOGFileHandle, "(" & UCase(strRegType) & ") '" & strRegKey & "' -> '" & varRegKeyValue (intIndex) & "'", cLoggingDebug Or cLoggingLevel4, False
                     Next
                Case "REG_EXPAND_SZ"
                     ReDim varRegKeyValue(0)
                     varRegKeyValue(0) = Trim (objWshShell.ExpandEnvironmentStrings (strTempValue))
                     WriteToLogFile objLOGFileHandle, "(" & UCase(strRegType) & ") '" & strRegKey & "' -> '" & varRegKeyValue (0) & "'", cLoggingDebug Or cLoggingLevel4, False
                Case Else
                     ReDim varRegKeyValue(0)
                     varRegKeyValue(0) = Trim (strTempValue)
                     WriteToLogFile objLOGFileHandle, "(" & UCase(strRegType) & ") '" & strRegKey & "' -> '" & varRegKeyValue (0) & "'", cLoggingDebug Or cLoggingLevel4, False 
         End Select

         ReadRegistry = varRegKeyValue

End Function

' --------------------------------------------------------------------------------------------------------
Function IncludeAndExecuteVBS (ByVal objLOGFileHandle, ByVal strScriptPathFilename)

         Dim objFile

         On Error Resume Next

         IncludeAndExecuteVBS = True

         If CheckIfFileExists (objLOGFileHandle, strScriptPathFilename) = True Then
            Set objFile = objFS.OpenTextFile (strScriptPathFilename, cForReading, False, cTristateUseDefault)
            If Err.Number Then
               ErrorHandler objLOGFileHandle, "IncludeAndExecuteVBS", "", False, Err
            Else
               ExecuteGlobal objFile.ReadAll()
               objFile.Close
               IncludeAndExecuteVBS = False
            End If

            Set objFile = Nothing
         End If
 
End Function

' -----------------------------------------------------------------------------------------------------------------------
Function CheckIfFileExists (ByVal objLOGFileHandle, ByVal strFileName)

         Dim objOpenFileHandle
 
         On Error Resume Next
 
         Set objOpenFileHandle = objFS.OpenTextFile (objWshShell.ExpandEnvironmentStrings (strFileName), cForReading, False, cTristateUseDefault)
         If Err.Number Then
            Err.Clear
 
            objOpenFileHandle.Close
            Set objOpenFileHandle = Nothing
            CheckIfFileExists = False
            Exit Function
         End If

         objOpenFileHandle.Close
         Set objOpenFileHandle = Nothing
 
         CheckIfFileExists = True

End Function

' -----------------------------------------------------------------------------------------------------------------------
Function OpenTextFile (ByVal strFileName)

         Dim objOpenFileHandle
 
         On Error Resume Next

         Set objOpenFileHandle = objFS.OpenTextFile (objWshShell.ExpandEnvironmentStrings (strFileName), cForReading, False, cTristateUseDefault)
         If Err.Number Then
            ErrorHandler "", "OpenTextFile", "", False, Err
            objOpenFileHandle = Null
            Exit Function
         End If
 
         Set OpenTextFile = objOpenFileHandle

End Function

' -----------------------------------------------------------------------------------------------------------------------
Function CreateTextFile (ByVal strFileName)

         Dim objCreateFileHandle
 
         On Error Resume Next
 
         Set objCreateFileHandle = objFS.CreateTextFile (objWshShell.ExpandEnvironmentStrings (strFileName), True)
         If Err.Number Then
            ErrorHandler "", "CreateTextFile", "", True, Err
            objCreateFileHandle = Null
            Exit Function
         End If
 
         Set CreateTextFile = objCreateFileHandle

End Function

' -----------------------------------------------------------------------------------------------------------------------
Function WriteToFile (ByVal objWriteFileHandle, ByVal strText)

         On Error Resume Next
 
         If Not IsNull(objWriteFileHandle) Then
            objWriteFileHandle.WriteLine strText
            If Err.Number Then
               WriteToFile = ErrorHandler (objWriteFileHandle, "WriteToFile", "", False, Err)
            End If
         End If

End Function

' -----------------------------------------------------------------------------------------------------------------------
Function ReadFromFile (ByVal objReadFileHandle, ByRef strText)

         On Error Resume Next

         If Not IsNull(objReadFileHandle) Then
            strText = objReadFileHandle.ReadLine
            If Err.Number Then
               ReadFromFile  = ErrorHandler (objReadFileHandle, "ReadFromFile", "", False, Err)
            End If
         End If

End Function

' -----------------------------------------------------------------------------------------------------------------------
Function CloseTextFile (ByVal objCloseFileHandle)

         On Error Resume Next
 
         objCloseFileHandle.Close
 
         Set objCloseFileHandle = Nothing

End Function

' --------------------------------------------------------------------------------------------------------
Function DumpCSV (ByVal strText, ByVal strTemp, ByVal intCopies, ByVal boolDump)

         Dim intCounter
 
         On Error Resume Next

         If boolDump = True Then
            ' strText = strTemp

            strText = ReplaceString (strText, ",", "")
  
            For intCounter = 1 to intCopies
                If Len (strCSV) = 0 Then
                   strCSV = strText
                Else
                   strCSV = strCSV & "," & strText
                End If
            Next 
         End If 

End Function

' --------------------------------------------------------------------------------------------------------
Function SendMessage (ByVal strTO, ByVal strFROM, ByVal strSubject, ByVal strBodyText, ByVal strHTMLBodyText, ByVal arrayAttachment)

         Dim objMessage 
         Dim objConfiguration
         Dim strAttachment
 
         On Error Resume Next
 
         strTO = Trim (strTO)
         strFrom = Trim (strFrom)
         strSubject = Trim (strSubject)
         strBodyText = Trim (strBodyText)
         strHTMLBodyText = Trim (strHTMLBodyText)

         If Not (CBool(Len (strTO)) And _
                 CBool(Len(strFrom)) And _
                 CBool(Len(strSubject)) And _
                (CBool(Len(strBodyText)) Or CBool(Len(strHTMLBodyText))) _
                ) Then 
            SendMessage = True
            Exit Function
         End If

         Set objMessage = CreateObject("CDO.Message")
         Set objConfiguration = CreateObject ("CDO.Configuration")

         objConfiguration.Fields ("http://schemas.microsoft.com/cdo/configuration/smtpserver") = strSMTPServer 
         objConfiguration.Fields ("http://schemas.microsoft.com/cdo/configuration/smtpserverport") = intSMTPPort  
         objConfiguration.Fields ("http://schemas.microsoft.com/cdo/configuration/smtpauthenticate") = intSMTPAuthenticate 
         objConfiguration.Fields ("http://schemas.microsoft.com/cdo/configuration/sendusername") = strSMTPUserName 
         objConfiguration.Fields ("http://schemas.microsoft.com/cdo/configuration/sendpassword") = strSMTPPassword 
         objConfiguration.Fields ("http://schemas.microsoft.com/cdo/configuration/smtpusessl") = boolSMTPSSL 
         objConfiguration.Fields ("http://schemas.microsoft.com/cdo/configuration/sendusing") = 2
         objConfiguration.Fields ("http://schemas.microsoft.com/cdo/configuration/smtpconnectiontimeout") = 60
         objConfiguration.Fields.Update

         objMessage.Configuration = objConfiguration
         objMessage.To = strTO
         objMessage.From = strFrom
         objMessage.CC = strFrom
         objMessage.Subject = strSubject
         objMessage.TEXTBody = strBodyText
         objMessage.HTMLBody = strHTMLBodyText

         If IsNull (arrayAttachment) = False Then 
            For Each strAttachment In arrayAttachment
                strAttachment = ReplaceString (strAttachment, Chr (34), "")
                objMessage.AddAttachment strAttachment
            Next
         End If

         WriteToLogFile Null, "Sending WMIDiag information to '" & strTO & "'.", cLoggingLevel0, False

         objMessage.Send

         If Err.Number Then
            SendMessage = ErrorHandler (Null, "SendMessage", "", True, Err)
         Else
            WriteToLogFile Null, "WMIDiag information successfully sent.", cLoggingLevel0, False
         End If

         Set objConfiguration = Nothing
         Set objMessage = Nothing

End Function

' --------------------------------------------------------------------------------------------------------
Function ErrorHandler (ByVal objLOGFileHandle, ByVal strFunctionName, ByVal strErrorMessage, ByVal boolCriticalError, ByVal Err)

         Dim strErrorString, intPopupTimeout
         Dim strWBEMCode, strWBEMMessage
         Dim strLastHexError, strDescription

         If Err.Number Then
            strLastHexError = "0x" & Hex(Err.Number)
            If Left (strLastHexError, 7) = "0x80041" Then
               GetWMIErrorMessage strLastHexError, strWBEMCode, strWBEMMessage
               strLastError = strLastHexError & ";(" & strWBEMCode & ") " & strWBEMMessage
               strErrorString = "("& strFunctionName &") : " & strLastHexError & " - (" & strWBEMCode & ") " & strWBEMMessage  & "."
            Else
               If Len (Err.Description) = 0 Then
                  If Len (objWMILastError.Description) > 0 Then
                     strDescription = objWMILastError.Description
                  Else
                     strDescription = ""
                  End If
               Else  
                  strDescription = Err.Description
               End If
 
               strDescription = CleanString (strDescription, 32, 255)
 
               strLastError = strLastHexError & ";" & strDescription
               If Len (strDescription) > 0 Then strDescription = " - " & strDescription
               strErrorString = "("& strFunctionName &") : " & strLastHexError & strDescription
            End If
 
            Err.Clear
 
            If Len (strErrorMessage) Then strErrorString = strErrorString & ". " & strErrorMessage
         Else
            strLastError = "0x0;"
            strErrorString = "("& strFunctionName &") : " & _
                             strErrorMessage
            strErrorString = CleanString (strErrorString, 32, 255)
         End If

         WriteToLogFile objLOGFileHandle, strErrorString, cLoggingLevel1, boolCriticalError
 
         If boolEventLogErrors = True Or boolEventLog = True Then objWshShell.LogEvent 1, strErrorString
 
         If boolErrorPopup = True Or (boolNoEcho = True And boolCriticalError = True And boolSilent = False) Then
            objWshShell.Popup strErrorString, _
                           0, _
                           "(WMIDiag " & cWMIDiagVersion & ") ERROR!", _
                           vbCritical Or vbOkOnly
         End If
 
         ErrorHandler = True

End Function

' -----------------------------------------------------------------------------------------------------------------------
Function StatusWriteToLogFile (ByVal objWriteFileHandle, ByVal strTextMessage, ByVal strStatus, ByVal intLoggingLevel, ByVal boolCriticalError)

         Dim intTextMessageLength

         On Error Resume Next

         Select Case intLoggingLevel
                Case cLoggingLevel1
                     intTextMessageLength = Len (strTextMessage) + Len ("ERROR: ")
                Case cLoggingLevel2
                     intTextMessageLength = Len (strTextMessage) + Len ("WARNING: ")
                Case Else
                     intTextMessageLength = Len (strTextMessage)
         End Select 

         If intTextMessageLength > 100 Then strTextMessage = Left (strTextMessage, 100) & ">..."

         strTextMessage = strTextMessage & ": " 

         If Right (strStatus, 1) = "!" Then 
            strTextMessage = strTextMessage & String (115 - intTextMessageLength, ".") & " " & strStatus
         Else
            strTextMessage = strTextMessage & String (115 - intTextMessageLength, ".") & " " & strStatus & "."
         End If

         WriteToLogFile objWriteFileHandle, strTextMessage, intLoggingLevel, boolCriticalError

End Function

' -----------------------------------------------------------------------------------------------------------------------
Function arrayWriteToLogFile (ByVal objWriteFileHandle, ByVal strTab, ByVal arrayTextMessage, ByVal intLoggingLevel, ByVal boolCriticalError)

         Dim strTextMessage

         On Error Resume Next

         For Each strTextMessage In arrayTextMessage
             arrayWriteToLogFile = WriteToLogFile (objWriteFileHandle, strTab & strTextMessage, intLoggingLevel, boolCriticalError)
         Next

End Function

' -----------------------------------------------------------------------------------------------------------------------
Function WriteToLogFile (ByVal objWriteFileHandle, ByVal strTextMessage, ByVal intLoggingLevel, ByVal boolCriticalError)
 
         On Error Resume Next

         If boolLoggingDebug = True Then 
            If (intLoggingLevel And cLoggingDebug) = cLoggingDebug Then
               intLoggingLevel = (Not cLoggingDebug) And intLoggingLevel
            End If
         Else
            If (intLoggingLevel And cLoggingDebug) = cLoggingDebug Then
               intLoggingLevel = cLoggingDisabled
            End If
         End If

         If intLoggingLevel <> cLoggingDisabled Then
            Select Case (intLoggingLevel)
                   Case 0
                        strTextMessage = "** " & strTextMessage
                   Case 1
                        strTextMessage = "!! " & "ERROR: " & strTextMessage
                        longErrorCounter = longErrorCounter + 1
                   Case 2
                        strTextMessage = "!! " & "WARNING: " & strTextMessage
                        longWarningCounter = longWarningCounter + 1
                   Case Else
                        strTextMessage = Space ((intLoggingLevel - 1 )* 2 - 1) & strTextMessage
            End Select
   
            If Not IsNull(objWriteFileHandle) Then
               longLogLineCounter = longLogLineCounter + 1
    
               objWriteFileHandle.WriteLine Right ("....." & longLogLineCounter, 5) & " " & _
                                            Right ("00" & Hour (Time), 2) & ":" & _
                                            Right ("00" & Minute (Time), 2) & ":" & _
                                            Right ("00" & Second (Time), 2) & _
                                            " (" & intLoggingLevel & ") " & strTextMessage

               If (boolWTTLogging = True) And (intLoggingLevel = 1 Or intLoggingLevel = 2) Then
                  TraceWTTMessage (Right ("....." & longLogLineCounter, 5) & " " & _
                                         Right ("00" & Hour (Time), 2) & ":" & _
                                         Right ("00" & Minute (Time), 2) & ":" & _
                                         Right ("00" & Second (Time), 2) & _
                                         " (" & intLoggingLevel & ") " & strTextMessage)                                       
               End If              

               If Err.Number Then Err.Clear

               WriteToLogFile = longLogLineCounter
            End If
    
            If intLoggingLevel =< intDefaultLoggingLevel Or boolCriticalError Then
               If boolNoEcho = False Or boolCriticalError = True Then  
                  objStdOut.WriteLine "(" & intLoggingLevel & ") " & strTextMessage
               End If
    
               If boolEventLog Then 
                  If intLoggingLevel > 2 Then 
                     objWshShell.LogEvent 4, "(" & intLoggingLevel & ") " & Trim (strTextMessage)
                  Else
                     objWshShell.LogEvent intLoggingLevel, Trim (strTextMessage)
                  End If
               End If
            End If
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function CountWMIErrorMessage (ByVal strWMIError)

         Dim intIndex, boolFound
         Dim strWBEMCode, strWBEMMessage

         On Error Resume Next

         boolFound = False

         For intIndex = 0 To UBound (WBEMError)
             If WBEMError (intIndex).WBEMError = strWMIError Then
                boolFound = True
                Exit For
             End If
         Next 

         If boolFound = True Then
            WBEMError (intIndex).WBEMCounter = WBEMError (intIndex).WBEMCounter + 1
         Else
            intIndex = UBound (WBEMError) 
            WBEMError (intIndex).WBEMCounter = 1
            WBEMError (intIndex).WBEMError = strWMIError

            GetWMIErrorMessage strWMIError, strWBEMCode, strWBEMMessage

            WBEMError (intIndex).WBEMCode = strWBEMCode
            WBEMError (intIndex).WBEMMessage = strWBEMMessage

            ReDim Preserve WBEMError (intIndex + 1)
            Set WBEMError (intIndex + 1) = new ClassWBEMError
         End If

End Function

' --------------------------------------------------------------------------------------------------------
Function GetWMIErrorMessage (ByVal strWMIError, ByRef WBEMCode, ByRef WBEMMessage)

         On Error Resume Next

         Select Case strWMIError
                Case "0x80041001"
                     WBEMCode = "WBEM_E_FAILED"
                     WBEMMessage = "Call failed"
                Case "0x80041002"
                     WBEMCode = "WBEM_E_NOT_FOUND"
                     WBEMMessage = "Object cannot be found"
                Case "0x80041003"
                     WBEMCode = "WBEM_E_ACCESS_DENIED"
                     WBEMMessage = "Current user does not have permission to perform the action"
                Case "0x80041004"
                     WBEMCode = "WBEM_E_PROVIDER_FAILURE"
                     WBEMMessage = "Provider has failed at some time other than during initialization"
                Case "0x80041005"
                     WBEMCode = "WBEM_E_TYPE_MISMATCH"
                     WBEMMessage = "Type mismatch occurred"
                Case "0x80041006"
                     WBEMCode = "WBEM_E_OUT_OF_MEMORY"
                     WBEMMessage = "Not enough memory for the operation"
                Case "0x80041007"
                     WBEMCode = "WBEM_E_INVALID_CONTEXT"
                     WBEMMessage = "The IWbemContext object is not valid"
                Case "0x80041008"
                     WBEMCode = "WBEM_E_INVALID_PARAMETER"
                     WBEMMessage = "One of the parameters to the call is not correct"
                Case "0x80041009"
                     WBEMCode = "WBEM_E_NOT_AVAILABLE"
                     WBEMMessage = "Resource typically a remote server is not currently available" 
                Case "0x8004100A"
                     WBEMCode = "WBEM_E_CRITICAL_ERROR"
                     WBEMMessage = "Internal critical and unexpected error occurred." 
                Case "0x8004100B"
                     WBEMCode = "WBEM_E_INVALID_STREAM"
                     WBEMMessage = "One or more network packets were corrupted during a remote session"
                Case "0x8004100C"
                     WBEMCode = "WBEM_E_NOT_SUPPORTED"
                     WBEMMessage = "Feature or operation is not supported"
                Case "0x8004100D"
                     WBEMCode = "WBEM_E_INVALID_SUPERCLASS"
                     WBEMMessage = "Parent class specified is not valid"
                Case "0x8004100E"
                     WBEMCode = "WBEM_E_INVALID_NAMESPACE"
                     WBEMMessage = "Namespace specified cannot be found"
                Case "0x8004100F"
                     WBEMCode = "WBEM_E_INVALID_OBJECT"
                     WBEMMessage = "Specified instance is not valid"
                Case "0x80041010"
                     WBEMCode = "WBEM_E_INVALID_CLASS"
                     WBEMMessage = "Specified class is not valid"
                Case "0x80041011"
                     WBEMCode = "WBEM_E_PROVIDER_NOT_FOUND"
                     WBEMMessage = "Provider referenced in the schema does not have a corresponding registration"
                Case "0x80041012"
                     WBEMCode = "WBEM_E_INVALID_PROVIDER_REGISTRATION"
                     WBEMMessage = "Provider referenced in the schema has an incorrect or incomplete registration"
                Case "0x80041013"
                     WBEMCode = "WBEM_E_PROVIDER_LOAD_FAILURE"
                     WBEMMessage = "COM cannot locate a provider referenced in the schema"
                Case "0x80041014"
                     WBEMCode = "WBEM_E_INITIALIZATION_FAILURE"
                     WBEMMessage = "Component such as a provider failed to initialize for internal reasons" 
                Case "0x80041015"
                     WBEMCode = "WBEM_E_TRANSPORT_FAILURE"
                     WBEMMessage = "Networking error that prevents normal operation has occurred"
                Case "0x80041016"
                     WBEMCode = "WBEM_E_INVALID_OPERATION"
                     WBEMMessage = "Requested operation is not valid. This error usually applies to invalid attempts to delete classes or properties"
                Case "0x80041017"
                     WBEMCode = "WBEM_E_INVALID_QUERY"
                     WBEMMessage = "Query was not syntactically valid"
                Case "0x80041018"
                     WBEMCode = "WBEM_E_INVALID_QUERY_TYPE"
                     WBEMMessage = "Requested query language is not supported"
                Case "0x80041019"
                     WBEMCode = "WBEM_E_ALREADY_EXISTS"
                     WBEMMessage = "In a put operation the wbemChangeFlagCreateOnly flag was specified but the instance already exists" 
                Case "0x8004101A"
                     WBEMCode = "WBEM_E_OVERRIDE_NOT_ALLOWED"
                     WBEMMessage = "Not possible to perform the add operation on this qualifier because the owning object does not permit overrides"
                Case "0x8004101B"
                     WBEMCode = "WBEM_E_PROPAGATED_QUALIFIER"
                     WBEMMessage = "User attempted to delete a qualifier that was not owned. The qualifier was inherited from a parent class"
                Case "0x8004101C"
                     WBEMCode = "WBEM_E_PROPAGATED_PROPERTY"
                     WBEMMessage = "User attempted to delete a property that was not owned. The property was inherited from a parent class"
                Case "0x8004101D"
                     WBEMCode = "WBEM_E_UNEXPECTED"
                     WBEMMessage = "Client made an unexpected and illegal sequence of calls such as calling EndEnumeration before calling BeginEnumeration"
                Case "0x8004101E"
                     WBEMCode = "WBEM_E_ILLEGAL_OPERATION"
                     WBEMMessage = "User requested an illegal operation such as spawning a class from an instance"
                Case "0x8004101F"
                     WBEMCode = "WBEM_E_CANNOT_BE_KEY"
                     WBEMMessage = "Illegal attempt to specify a key qualifier on a property that cannot be a key"
                Case "0x80041020"
                     WBEMCode = "WBEM_E_INCOMPLETE_CLASS"
                     WBEMMessage = "Current object is not a valid class definition. Either it is incomplete or it has not been registered"
                Case "0x80041021"
                     WBEMCode = "WBEM_E_INVALID_SYNTAX"
                     WBEMMessage = "Query is syntactically invalid"
                Case "0x80041022"
                     WBEMCode = "WBEM_E_NONDECORATED_OBJECT"
                     WBEMMessage = "Reserved for future use"
                Case "0x80041023"
                     WBEMCode = "WBEM_E_READ_ONLY"
                     WBEMMessage = "An attempt was made to modify a read-only property"
                Case "0x80041024"
                     WBEMCode = "WBEM_E_PROVIDER_NOT_CAPABLE"
                     WBEMMessage = "Provider cannot perform the requested operation"
                Case "0x80041025"
                     WBEMCode = "WBEM_E_CLASS_HAS_CHILDREN"
                     WBEMMessage = "Attempt was made to make a change that invalidates a subclass"
                Case "0x80041026"
                     WBEMCode = "WBEM_E_CLASS_HAS_INSTANCES"
                     WBEMMessage = "Attempt was made to delete or modify a class that has instances"
                Case "0x80041027"
                     WBEMCode = "WBEM_E_QUERY_NOT_IMPLEMENTED"
                     WBEMMessage = "Reserved for future use"
                Case "0x80041028"
                     WBEMCode = "WBEM_E_ILLEGAL_NULL"
                     WBEMMessage = "Value of Nothing/NULL was specified for a property that must have a value"
                Case "0x80041029"
                     WBEMCode = "WBEM_E_INVALID_QUALIFIER_TYPE"
                     WBEMMessage = "Variant value for a qualifier was provided that is not a legal qualifier type"
                Case "0x8004102A"
                     WBEMCode = "WBEM_E_INVALID_PROPERTY_TYPE"
                     WBEMMessage = "CIM type specified for a property is not valid"
                Case "0x8004102B"
                     WBEMCode = "WBEM_E_VALUE_OUT_OF_RANGE"
                     WBEMMessage = "Request was made with an out-of-range value or it is incompatible with the type"
                Case "0x8004102C"
                     WBEMCode = "WBEM_E_CANNOT_BE_SINGLETON"
                     WBEMMessage = "Illegal attempt was made to make a class singleton such as when the class is derived from a non-singleton class" 
                Case "0x8004102D"
                     WBEMCode = "WBEM_E_INVALID_CIM_TYPE"
                     WBEMMessage = "CIM type specified is invalid"
                Case "0x8004102E"
                     WBEMCode = "WBEM_E_INVALID_METHOD"
                     WBEMMessage = "Requested method is not available"
                Case "0x8004102F"
                     WBEMCode = "WBEM_E_INVALID_METHOD_PARAMETERS"
                     WBEMMessage = "Parameters provided for the method are invalid"
                Case "0x80041030"
                     WBEMCode = "WBEM_E_SYSTEM_PROPERTY"
                     WBEMMessage = "There was an attempt to get qualifiers on a system property"
                Case "0x80041031"
                     WBEMCode = "WBEM_E_INVALID_PROPERTY"
                     WBEMMessage = "Property type is not recognized"
                Case "0x80041032"
                     WBEMCode = "WBEM_E_CALL_CANCELLED"
                     WBEMMessage = "Asynchronous process has been canceled"
                Case "0x80041033"
                     WBEMCode = "WBEM_E_SHUTTING_DOWN"
                     WBEMMessage = "User has requested an operation while WMI is in the process of shutting down"
                Case "0x80041034"
                     WBEMCode = "WBEM_E_PROPAGATED_METHOD"
                     WBEMMessage = "Attempt was made to reuse an existing method name from a parent class and the signatures do not match"
                Case "0x80041035"
                     WBEMCode = "WBEM_E_UNSUPPORTED_PARAMETER"
                     WBEMMessage = "One or more parameter values such as a query text is too complex or unsupported"
                Case "0x80041036"
                     WBEMCode = "WBEM_E_MISSING_PARAMETER_ID"
                     WBEMMessage = "Parameter was missing from the method call"
                Case "0x80041037"
                     WBEMCode = "WBEM_E_INVALID_PARAMETER_ID"
                     WBEMMessage = "Method parameter has an invalid ID qualifier"
                Case "0x80041038"
                     WBEMCode = "WBEM_E_NONCONSECUTIVE_PARAMETER_IDS"
                     WBEMMessage = "One or more of the method parameters have ID qualifiers that are out of sequence"
                Case "0x80041039"
                     WBEMCode = "WBEM_E_PARAMETER_ID_ON_RETVAL"
                     WBEMMessage = "Return value for a method has an ID qualifier"
                Case "0x8004103A"
                     WBEMCode = "WBEM_E_INVALID_OBJECT_PATH"
                     WBEMMessage = "Specified object path was invalid"
                Case "0x8004103B"
                     WBEMCode = "WBEM_E_OUT_OF_DISK_SPACE"
                     WBEMMessage = "Disk is out of space or the 4 GB limit on WMI repository (WMI repository) size is reached"
                Case "0x8004103C"
                     WBEMCode = "WBEM_E_BUFFER_TOO_SMALL"
                     WBEMMessage = "Supplied buffer was too small to hold all of the objects in the enumerator or to read a string property"
                Case "0x8004103D"
                     WBEMCode = "WBEM_E_UNSUPPORTED_PUT_EXTENSION"
                     WBEMMessage = "Provider does not support the requested put operation"
                Case "0x8004103E"
                     WBEMCode = "WBEM_E_UNKNOWN_OBJECT_TYPE"
                     WBEMMessage = "Object with an incorrect type or version was encountered during marshaling"
                Case "0x8004103F"
                     WBEMCode = "WBEM_E_UNKNOWN_PACKET_TYPE"
                     WBEMMessage = "Packet with an incorrect type or version was encountered during marshaling"
                Case "0x80041040"
                     WBEMCode = "WBEM_E_MARSHAL_VERSION_MISMATCH"
                     WBEMMessage = "Packet has an unsupported version"
                Case "0x80041041"
                     WBEMCode = "WBEM_E_MARSHAL_INVALID_SIGNATURE"
                     WBEMMessage = "Packet appears to be corrupt"
                Case "0x80041042"
                     WBEMCode = "WBEM_E_INVALID_QUALIFIER"
                     WBEMMessage = "Attempt was made to mismatch qualifiers such as putting [key] on an object instead of a property" 
                Case "0x80041043"
                     WBEMCode = "WBEM_E_INVALID_DUPLICATE_PARAMETER"
                     WBEMMessage = "Duplicate parameter was declared in a CIM method"
                Case "0x80041044"
                     WBEMCode = "WBEM_E_TOO_MUCH_DATA"
                     WBEMMessage = "Reserved for future use"
                Case "0x80041045"
                     WBEMCode = "WBEM_E_SERVER_TOO_BUSY"
                     WBEMMessage = "Call to IWbemObjectSink::Indicate has failed. The provider can refire the event"
                Case "0x80041046"
                     WBEMCode = "WBEM_E_INVALID_FLAVOR"
                     WBEMMessage = "Specified qualifier flavor was invalid"
                Case "0x80041047"
                     WBEMCode = "WBEM_E_CIRCULAR_REFERENCE"
                     WBEMMessage = "Attempt was made to create a reference that is circular (for example deriving a class from itself)" 
                Case "0x80041048"
                     WBEMCode = "WBEM_E_UNSUPPORTED_CLASS_UPDATE"
                     WBEMMessage = "Specified class is not supported"
                Case "0x80041049"
                     WBEMCode = "WBEM_E_CANNOT_CHANGE_KEY_INHERITANCE"
                     WBEMMessage = "Attempt was made to change a key when instances or subclasses are already using the key"
                Case "0x80041050"
                     WBEMCode = "WBEM_E_CANNOT_CHANGE_INDEX_INHERITANCE"
                     WBEMMessage = "An attempt was made to change an index when instances or subclasses are already using the index"
                Case "0x80041051"
                     WBEMCode = "WBEM_E_TOO_MANY_PROPERTIES"
                     WBEMMessage = "Attempt was made to create more properties than the current version of the class supports"
                Case "0x80041052"
                     WBEMCode = "WBEM_E_UPDATE_TYPE_MISMATCH"
                     WBEMMessage = "Property was redefined with a conflicting type in a derived class"
                Case "0x80041053"
                     WBEMCode = "WBEM_E_UPDATE_OVERRIDE_NOT_ALLOWED"
                     WBEMMessage = "Attempt was made in a derived class to override a qualifier that cannot be overridden"
                Case "0x80041054"
                     WBEMCode = "WBEM_E_UPDATE_PROPAGATED_METHOD"
                     WBEMMessage = "Method was re-declared with a conflicting signature in a derived class"
                Case "0x80041055"
                     WBEMCode = "WBEM_E_METHOD_NOT_IMPLEMENTED"
                     WBEMMessage = "Attempt was made to execute a method not marked with [implemented] in any relevant class"
                Case "0x80041056"
                     WBEMCode = "WBEM_E_METHOD_DISABLED"
                     WBEMMessage = "Attempt was made to execute a method marked with [disabled]"
                Case "0x80041057"
                     WBEMCode = "WBEM_E_REFRESHER_BUSY"
                     WBEMMessage = "Refresher is busy with another operation"
                Case "0x80041058"
                     WBEMCode = "WBEM_E_UNPARSABLE_QUERY"
                     WBEMMessage = "Filtering query is syntactically invalid"
                Case "0x80041059"
                     WBEMCode = "WBEM_E_NOT_EVENT_CLASS"
                     WBEMMessage = "The FROM clause of a filtering query references a class that is not an event class (not derived from __Event)"
                Case "0x8004105A"
                     WBEMCode = "WBEM_E_MISSING_GROUP_WITHIN"
                     WBEMMessage = "A GROUP BY clause was used without the corresponding GROUP WITHIN clause"
                Case "0x8004105B"
                     WBEMCode = "WBEM_E_MISSING_AGGREGATION_LIST"
                     WBEMMessage = "A GROUP BY clause was used. Aggregation on all properties is not supported"
                Case "0x8004105C"
                     WBEMCode = "WBEM_E_PROPERTY_NOT_AN_OBJECT"
                     WBEMMessage = "Dot notation was used on a property that is not an embedded object"
                Case "0x8004105D"
                     WBEMCode = "WBEM_E_AGGREGATING_BY_OBJECT"
                     WBEMMessage = "A GROUP BY clause references a property that is an embedded object without using dot notation"
                Case "0x8004105F"
                     WBEMCode = "WBEM_E_UNINTERPRETABLE_PROVIDER_QUERY"
                     WBEMMessage = "Event provider registration query (__EventProviderRegistration) did not specify the classes for which events were provided"
                Case "0x80041060"
                     WBEMCode = "WBEM_E_BACKUP_RESTORE_WINMGMT_RUNNING"
                     WBEMMessage = "Request was made to back up or restore the WMI repository while it was in use by WinMgmt.exe or in Windows XP or later the SVCHOST process that contains the Windows Management service" 
                Case "0x80041061"
                     WBEMCode = "WBEM_E_QUEUE_OVERFLOW"
                     WBEMMessage = "Asynchronous delivery queue overflowed from the event consumer being too slow"
                Case "0x80041062"
                     WBEMCode = "WBEM_E_PRIVILEGE_NOT_HELD"
                     WBEMMessage = "Operation failed because the client did not have the necessary security privilege"
                Case "0x80041063"
                     WBEMCode = "WBEM_E_INVALID_OPERATOR"
                     WBEMMessage = "Operator is invalid for this property type"
                Case "0x80041064"
                     WBEMCode = "WBEM_E_LOCAL_CREDENTIALS"
                     WBEMMessage = "User specified a username/password/authority on a local connection. The user must use a blank username/password and rely on default security"
                Case "0x80041065"
                     WBEMCode = "WBEM_E_CANNOT_BE_ABSTRACT"
                     WBEMMessage = "Class was made abstract when its parent class is not abstract"
                Case "0x80041066"
                     WBEMCode = "WBEM_E_AMENDED_OBJECT"
                     WBEMMessage = "Amended object was written without the WBEM_FLAG_USE_AMENDED_QUALIFIERS flag being specified"
                Case "0x80041067"
                     WBEMCode = "WBEM_E_CLIENT_TOO_SLOW"
                     WBEMMessage = "Client did not retrieve objects quickly enough from an enumeration"
                Case "0x80041068"
                     WBEMCode = "WBEM_E_NULL_SECURITY_DESCRIPTOR"
                     WBEMMessage = "Null security descriptor was used"
                Case "0x80041069"
                     WBEMCode = "WBEM_E_TIMED_OUT"
                     WBEMMessage = "Operation timed out"
                Case "0x8004106A"
                     WBEMCode = "WBEM_E_INVALID_ASSOCIATION"
                     WBEMMessage = "Association is invalid"
                Case "0x8004106B"
                     WBEMCode = "WBEM_E_AMBIGUOUS_OPERATION"
                     WBEMMessage = "Operation was ambiguous"
                Case "0x8004106C"
                     WBEMCode = "WBEM_E_QUOTA_VIOLATION"
                     WBEMMessage = "WMI is taking up too much memory" 
                Case "0x8004106D"
                     WBEMCode = "WBEM_E_TRANSACTION_CONFLICT"
                     WBEMMessage = "Operation resulted in a transaction conflict"
                Case "0x8004106E"
                     WBEMCode = "WBEM_E_FORCED_ROLLBACK"
                     WBEMMessage = "Transaction forced a rollback"
                Case "0x8004106F"
                     WBEMCode = "WBEM_E_UNSUPPORTED_LOCALE"
                     WBEMMessage = "Locale used in the call is not supported"
                Case "0x80041070"
                     WBEMCode = "WBEM_E_HANDLE_OUT_OF_DATE"
                     WBEMMessage = "Object handle is out-of-date"
                Case "0x80041071"
                     WBEMCode = "WBEM_E_CONNECTION_FAILED"
                     WBEMMessage = "Connection to the SQL database failed"
                Case "0x80041072"
                     WBEMCode = "WBEM_E_INVALID_HANDLE_REQUEST"
                     WBEMMessage = "Handle request was invalid"
                Case "0x80041073"
                     WBEMCode = "WBEM_E_PROPERTY_NAME_TOO_WIDE"
                     WBEMMessage = "Property name contains more than 255 characters"
                Case "0x80041074"
                     WBEMCode = "WBEM_E_CLASS_NAME_TOO_WIDE"
                     WBEMMessage = "Class name contains more than 255 characters"
                Case "0x80041075"
                     WBEMCode = "WBEM_E_METHOD_NAME_TOO_WIDE"
                     WBEMMessage = "Method name contains more than 255 characters"
                Case "0x80041076"
                     WBEMCode = "WBEM_E_QUALIFIER_NAME_TOO_WIDE"
                     WBEMMessage = "Qualifier name contains more than 255 characters"
                Case "0x80041077"
                     WBEMCode = "WBEM_E_RERUN_COMMAND"
                     WBEMMessage = "The SQL command must be rerun because there is a deadlock in SQL"
                Case "0x80041078"
                     WBEMCode = "WBEM_E_DATABASE_VER_MISMATCH"
                     WBEMMessage = "Database version does not match the version that the WMI repository driver understands"
                Case "0x80041079"
                     WBEMCode = "WBEM_E_VETO_DELETE"
                     WBEMMessage = "WMI cannot execute the delete operation because the provider does not allow it"
                Case "0x8004107A"
                     WBEMCode = "WBEM_E_VETO_PUT"
                     WBEMMessage = "WMI cannot execute the put operation because the provider does not allow it"
                Case "0x80041080"
                     WBEMCode = "WBEM_E_INVALID_LOCALE"
                     WBEMMessage = "Specified locale identifier was invalid for the operation"
                Case "0x80041081"
                     WBEMCode = "WBEM_E_PROVIDER_SUSPENDED"
                     WBEMMessage = "Provider is suspended"
                Case "0x80041082"
                     WBEMCode = "WBEM_E_SYNCHRONIZATION_REQUIRED"
                     WBEMMessage = "Object must be written to the WMI repository and retrieved again before the requested operation can succeed"
                Case "0x80041083"
                     WBEMCode = "WBEM_E_NO_SCHEMA"
                     WBEMMessage = "Operation cannot be completed; no schema is available"
                Case "0x80041084"
                     WBEMCode = "WBEM_E_PROVIDER_ALREADY_REGISTERED"
                     WBEMMessage = "Provider cannot be registered because it is already registered"
                Case "0x80041085"
                     WBEMCode = "WBEM_E_PROVIDER_NOT_REGISTERED"
                     WBEMMessage = "Provider was not registered"
                Case "0x80041086"
                     WBEMCode = "WBEM_E_FATAL_TRANSPORT_ERROR"
                     WBEMMessage = "Fatal transport error occurred"
                Case "0x80041087"
                     WBEMCode = "WBEM_E_ENCRYPTED_CONNECTION_REQUIRED"
                     WBEMMessage = "User attempted to set a computer name or domain without an encrypted connection"
                Case "0x80041088"
                     WBEMCode = "WBEM_E_PROVIDER_TIMED_OUT"
                     WBEMMessage = "A provider failed to report results within the specified timeout"
                Case "0x80041089"
                     WBEMCode = "WBEM_E_NO_KEY"
                     WBEMMessage = "User attempted to put an instance with no defined key"
                Case "0x8004108A"
                     WBEMCode = "WBEM_E_PROVIDER_DISABLED"
                     WBEMMessage = "User attempted to register a provider instance but the COM server for the provider instance was unloaded"
                Case "0x80042003"
                     WBEMCode = "WBEMESS_E_AUTHZ_NOT_PRIVILEGED"
                     WBEMMessage = "This computer does not have the necessary domain permissions to support the security functions that relate to the created subscription instance. Contact the Domain Administrator to get this computer added to the Windows Authorization Access Group" 
                Case "0x80042001"
                     WBEMCode = "WBEMESS_E_REGISTRATION_TOO_BROAD"
                     WBEMMessage = "Provider registration overlaps with the system event domain"
                Case "0x80042002"
                     WBEMCode = "WBEMESS_E_REGISTRATION_TOO_PRECISE"
                     WBEMMessage = "A WITHIN clause was not used in this query" 
                Case "0x80043001"
                     WBEMCode = "WBEM_E_RETRY_LATER"
                     WBEMMessage = "Reserved for future use" 
                Case "0x80043002"
                     WBEMCode = "WBEM_E_RESOURCE_CONTENTION"
                     WBEMMessage = "Reserved for future use" 
                Case Else
                     WBEMCode = "WBEM_UNKNOWN"
                     WBEMMessage = "This error code is external to WMI." 
            End Select

End Function

' --------------------------------------------------------------------------------------------------------
Function InitializeWMISystemInformation (ByVal objLOGFileHandle)

        On Error Resume Next

        WriteToLogFile objLOGFileHandle, "Initializing WMI System Information.", cLoggingLevel0, False

     	Select Case RunTimeEnvironmentInfo.OSIdentifier
               Case cWindows2000RTM, cWindows2000SP1, cWindows2000SP2, cWindows2000SP3, cWindows2000SP4
                    If RunTimeEnvironmentInfo.IsServerOS Then 

                       arrayWMIDCOMDataList = Array (_
                                                     "%SystemRoot%\System32\WBEM\", "smi2smir.exe", True, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "mofcomp.exe", False, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "scrcons.exe", False, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "unsecapp.exe", False, Array ("\CLSID\{49BD2028-1523-11D1-AD79-00C04FD8FDFF}"),_
                                                     "%SystemRoot%\System32\WBEM\", "wbemtest.exe", False, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "winmgmt.exe", False, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "cimw32ex.dll", False, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "cimwin32.dll", False, Array ("\CLSID\{3DD82D10-E6F1-11D2-B139-00105A1F77A1}", _
                                                                                                                  "\CLSID\{D63A5850-8F16-11CF-9F47-00AA00BF345C}"), _
                                                     "%SystemRoot%\System32\WBEM\", "dsprov.dll", False, Array ("\CLSID\{1EF94880-01A8-11D2-A90B-00AA00BF3363}", _
                                                                                                                "\CLSID\{33831ED4-42B8-11D2-93AD-00805F853771}", _
                                                                                                                "\CLSID\{AA527A40-4D9A-11D2-93AD-00805F853771}"), _
                                                     "%SystemRoot%\System32\WBEM\", "fastprox.dll", False, Array ("\CLSID\{1B1CAD8C-2DAB-11D2-B604-00104B703EFD}", _
                                                                                                                  "\CLSID\{29B5828C-CAB9-11D2-B35C-00105A1F8177}", _
                                                                                                                  "\CLSID\{4590F812-1D3A-11D0-891F-00AA004B2E24}", _
                                                                                                                  "\CLSID\{674B6698-EE92-11D0-AD71-00C04FD8FDFF}", _
                                                                                                                  "\CLSID\{6C19BE35-7500-11D1-AD94-00C04FD8FDFF}", _
                                                                                                                  "\CLSID\{7016F8FA-CCDA-11D2-B35C-00105A1F8177}", _
                                                                                                                  "\CLSID\{71285C44-1DC0-11D2-B5FB-00104B703EFD}", _
                                                                                                                  "\CLSID\{7A0227F6-7108-11D1-AD90-00C04FD8FDFF}", _
                                                                                                                  "\CLSID\{C71566F2-561E-11D1-AD87-00C04FD8FDFF}"), _
                                                     "%SystemRoot%\System32\WBEM\", "framedyn.dll", False, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "mofd.dll", False, Array ("\CLSID\{6DAF9757-2E37-11D2-AEC9-00C04FB68820}", _
                                                                                                              "\CLSID\{C10B4771-4DA0-11D2-A2F5-00C04F86FB7D}"), _
                                                     "%SystemRoot%\System32\WBEM\", "ntevt.dll", False, Array ("\CLSID\{F55C5B4C-517D-11D1-AB57-00C04FD9159E}", _
                                                                                                               "\CLSID\{FD4F53E0-65DC-11D1-AB64-00C04FD9159E}"), _
                                                     "%SystemRoot%\System32\WBEM\", "provthrd.dll", False, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "secrcw32.dll", False, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "smtpcons.dll", False, Array ("\CLSID\{C7A3A54B-0250-11D3-9CD1-00105A1F4801}"), _
                                                     "%SystemRoot%\System32\WBEM\", "stdprov.dll", False, Array ("\CLSID\{72967901-68EC-11D0-B729-00AA0062CBB7}", _
                                                                                                                 "\CLSID\{72967903-68EC-11D0-B729-00AA0062CBB7}", _
                                                                                                                 "\CLSID\{F00B4404-F8F1-11CE-A5B6-00AA00680C3F}", _
                                                                                                                 "\CLSID\{FA77A74E-E109-11D0-AD6E-00C04FD8FDFF}", _
                                                                                                                 "\CLSID\{FE9AF5C0-D3B6-11CE-A5B6-00AA00680C3F}"), _
                                                     "%SystemRoot%\System32\WBEM\", "viewprov.dll", False, Array ("\CLSID\{AA70DDF4-E11C-11D1-ABB0-00C04FD9159E}"), _
                                                     "%SystemRoot%\System32\WBEM\", "wbemads.dll", False, Array ("\CLSID\{F0975AFE-5C7F-11D2-8B74-00104B2AFB41}"), _
                                                     "%SystemRoot%\System32\WBEM\", "wbemads.tlb", False, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "wbemcntl.dll", False, Array ("\CLSID\{5C659257-E236-11D2-8899-00104B2AFB46}", _
                                                                                                                  "\CLSID\{5C659258-E236-11D2-8899-00104B2AFB46}"), _
                                                     "%SystemRoot%\System32\WBEM\", "wbemcomn.dll", False, Array ("\CLSID\{9A653086-174F-11D2-B5F9-00104B703EFD}", _
                                                                                                                  "\CLSID\{EB87E1BD-3233-11D2-AEC9-00C04FB68820}"), _
                                                     "%SystemRoot%\System32\WBEM\", "wbemcore.dll", False, Array ("\CLSID\{443E7B79-DE31-11D2-B340-00104BCC4B4A}", _
                                                                                                                  "\CLSID\{4FA18276-912A-11D1-AD9B-00C04FD8FDFF}", _
                                                                                                                  "\CLSID\{A83EF168-CA8D-11D2-B33D-00104BCC4B4A}", _
                                                                                                                  "\CLSID\{CB8555CC-9128-11D1-AD9B-00C04FD8FDFF}", _
                                                                                                                  "\CLSID\{CD184336-9128-11D1-AD9B-00C04FD8FDFF}"), _
                                                     "%SystemRoot%\System32\WBEM\", "wbemdisp.dll", False, Array ("\CLSID\{172BDDF8-CEEA-11D1-8B05-00600806D9B6}", _
                                                                                                                  "\CLSID\{5791BC26-CE9C-11D1-97BF-0000F81E849C}", _
                                                                                                                  "\CLSID\{75718C9A-F029-11D1-A1AC-00C04FB6C223}", _
                                                                                                                  "\CLSID\{76A64158-CB41-11D1-8B02-00600806D9B6}", _
                                                                                                                  "\CLSID\{9AED384E-CE8B-11D1-8B05-00600806D9B6}", _
                                                                                                                  "\CLSID\{C2FEEEAC-CFCD-11D1-8B05-00600806D9B6}", _
                                                                                                                  "\Interface\{75718C9F-F029-11D1-A1AC-00C04FB6C223}", _
                                                                                                                  "\Interface\{75718CA0-F029-11D1-A1AC-00C04FB6C223}", _
                                                                                                                  "\Interface\{D962DB84-D4BB-11D1-8B09-00600806D9B6}"), _
                                                     "%SystemRoot%\System32\WBEM\", "wbemdisp.tlb", False, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "wbemess.dll", False, Array ("\CLSID\{5D08B586-343A-11D0-AD46-00C04FD8FDFF}"), _
                                                     "%SystemRoot%\System32\WBEM\", "wbemperf.dll", False, Array ("\CLSID\{FF37A93C-C28E-11D1-AEB6-00C04FB68820}"), _
                                                     "%SystemRoot%\System32\WBEM\", "wbemprox.dll", False, Array ("\CLSID\{4590F811-1D3A-11D0-891F-00AA004B2E24}", _
                                                                                                                  "\CLSID\{A1044801-8F7E-11D1-9E7C-00C04FC324A8}", _
                                                                                                                  "\CLSID\{F7CE2E13-8C90-11D1-9E7B-00C04FC324A8}"), _
                                                     "%SystemRoot%\System32\WBEM\", "wbemsvc.dll", False, Array ("\CLSID\{7C857801-7381-11CF-884D-00AA004B2E24}", _
                                                                                                                 "\Interface\{1BE41571-91DD-11D1-AEB2-00C04FB68820}", _
                                                                                                                 "\Interface\{1BE41572-91DD-11D1-AEB2-00C04FB68820}", _
                                                                                                                 "\Interface\{1C1C45EE-4395-11D2-B60B-00104B703EFD}", _
                                                                                                                 "\Interface\{1CFABA8C-1523-11D1-AD79-00C04FD8FDFF}", _
                                                                                                                 "\Interface\{2C9273E0-1DC3-11D3-B364-00105A1F8177}", _
                                                                                                                 "\Interface\{37196B38-CCCF-11D2-B35C-00105A1F8177}", _
                                                                                                                 "\Interface\{37196B39-CCCF-11D2-B35C-00105A1F8177}", _
                                                                                                                 "\Interface\{423EC01E-2E35-11D2-B604-00104B703EFD}", _
                                                                                                                 "\Interface\{44ACA675-E8FC-11D0-A07C-00C04FB68820}", _
                                                                                                                 "\Interface\{580ACAF8-FA1C-11D0-AD72-00C04FD8FDFF}", _
                                                                                                                 "\Interface\{60E512D4-C47B-11D2-B338-00105A1F4AAF}", _
                                                                                                                 "\Interface\{631F7D96-D993-11D2-B339-00105A1F4AAF}", _
                                                                                                                 "\Interface\{631F7D97-D993-11D2-B339-00105A1F4AAF}", _
                                                                                                                 "\Interface\{6C19BE32-7500-11D1-AD94-00C04FD8FDFF}", _
                                                                                                                 "\Interface\{6C19BE34-7500-11D1-AD94-00C04FD8FDFF}", _
                                                                                                                 "\Interface\{755F9DA7-7508-11D1-AD94-00C04FD8FDFF}", _
                                                                                                                 "\Interface\{C49E32C7-BC8B-11D2-85D4-00105A1F8304}", _
                                                                                                                 "\Interface\{E245105B-B06E-11D0-AD61-00C04FD8FDFF}", _
                                                                                                                 "\Interface\{E246107A-B06E-11D0-AD61-00C04FD8FDFF}", _
                                                                                                                 "\Interface\{F1E9C5B2-F59B-11D2-B362-00105A1F8177}", _
                                                                                                                 "\Interface\{F309AD18-D86A-11D0-A075-00C04FB68820}"), _
                                                     "%SystemRoot%\System32\WBEM\", "wbemupgd.dll", False, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "winmgmtr.dll", False, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "wlbsprov.dll", False, Array ("\CLSID\{FB223274-D72E-11D2-A420-00C04F68FE28}"), _
                                                     "%SystemRoot%\System32\WBEM\", "wmiprov.dll", False, Array ("\CLSID\{0725C3CB-FEFB-11D0-99F9-00C04FC2F8EC}", _
                                                                                                                 "\CLSID\{D2D588B5-D081-11D0-99E0-00C04FC2F8EC}"), _
                                                     "%SystemRoot%\System32\WBEM\", "msiprov.dll", False, Array ("\CLSID\{BE0A9830-2B8B-11D1-A949-0060181EBBAD}"), _
                                                     "%SystemRoot%\System32\WBEM\", "snmpcl.dll", True, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "snmpincl.dll", True, Array ("\CLSID\{19C813AC-FEE7-11D0-AB22-00C04FD9159E}", _
                                                                                                                 "\CLSID\{1F517A23-B29C-11CF-8C8D-00AA00A4086C}", _
                                                                                                                 "\CLSID\{70426720-F78F-11CF-9151-00AA00A4086C}", _
                                                                                                                 "\CLSID\{9D5BED16-0765-11D1-AB2C-00C04FD9159E}"), _
                                                     "%SystemRoot%\System32\WBEM\", "snmpsmir.dll", True, Array ("\CLSID\{5009AB90-F9EE-11CF-AEC1-00AA00BDD7D1}", _
                                                                                                                 "\CLSID\{5009AB92-F9EE-11CF-AEC1-00AA00BDD7D1}", _
                                                                                                                 "\CLSID\{5009AB94-F9EE-11CF-AEC1-00AA00BDD7D1}", _
                                                                                                                 "\CLSID\{5009AB9B-F9EE-11CF-AEC1-00AA00BDD7D1}", _
                                                                                                                 "\CLSID\{B11B26AC-A791-11D0-AAEA-00A024E8AD1C}", _
                                                                                                                 "\CLSID\{B11B26AE-A791-11D0-AAEA-00A024E8AD1C}"), _
                                                     "%SystemRoot%\System32\WBEM\", "snmpthrd.dll", True, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "wmiutils.dll", True, Array ("\CLSID\{CF4CC405-E2C5-4DDD-B3CE-5E7582D8C9FA}", _
                                                                                                                 "\CLSID\{EAC8A024-21E2-4523-AD73-A71A0AA2F56A}"), _
                                                     "%SystemRoot%\System32\WBEM\", "wbemdc.dll", True, Array ("\CLSID\{6919DD07-1637-4611-A8A7-C16FAC5B2D53}"), _
                                                     "%SystemRoot%\System32\WBEM\", "wmidcad.dll", True, Array ("\CLSID\{4cfc7932-0f9d-4bef-9c32-8ea2a6b56fcb}", _
                                                                                                                "\CLSID\{54D8502C-527D-43f7-A506-A9DA075E229C}", _
                                                                                                                "\CLSID\{f5f75737-2843-4f22-933d-c76a97cda62f}") _
                                                    )

                           arrayWMITestList = Array (_
                                                     "Root", _
                                                           True, _
                                                           Null, _
                                                           Null, _
                                                           Array (cWarning, "__ObjectProviderCacheControl", "@",        Array ("ClearAfter", "00000000000200.000000:000"), _
                                                                  cWarning, "__PropertyProviderCacheControl", "@",      Array ("ClearAfter", "00000000000200.000000:000"), _
                                                                  cWarning, "__EventProviderCacheControl", "@",         Array ("ClearAfter", "00000000000010.000000:000"), _
                                                                  cWarning, "__EventConsumerProviderCacheControl", "@", Array ("ClearAfter", "00000000000010.000000:000"), _
                                                                  cWarning, "__EventSinkCacheControl", "@",             Array ("ClearAfter", "00000000000010.000000:000") _
                                                                 ), _
                                                     "Root/Default", _
                                                           True, _
                                                           Null, _
                                                           Null, _
                                                           Null, _
                                                     "Root/CIMv2", _
                                                           True, _
                                                           Array (cCritical, "Win32_Process", _
                                                                  cCritical, "Win32_OperatingSystem", _
                                                                  cCritical, "Win32_ComputerSystem", _
                                                                  cCritical, "Win32_Service", _
                                                                  cCritical, "Win32_Bios", _
                                                                  cPresence, "Win32_Perf", _
                                                                  cPresence, "Win32_PerfRawData", _
                                                                  cCritical, "Win32_PerfRawData_Tcpip_IP", _
                                                                  cCritical, "Win32_PerfRawData_Tcpip_TCP", _
                                                                  cCritical, "Win32_PerfRawData_Tcpip_UDP", _
                                                                  cCritical, "Win32_PerfRawData_Tcpip_ICMP", _
                                                                  cCritical, "Win32_PerfRawData_PerfOS_Cache", _
                                                                  cCritical, "Win32_PerfRawData_PerfOS_Memory", _
                                                                  cCritical, "Win32_PerfRawData_PerfOS_Objects", _
                                                                  cCritical, "Win32_PerfRawData_PerfOS_PagingFile", _
                                                                  cCritical, "Win32_PerfRawData_PerfOS_Processor", _
                                                                  cCritical, "Win32_PerfRawData_PerfOS_System", _
                                                                  cCritical, "Win32_PerfRawData_PerfProc_Process", _
                                                                  cCritical, "Win32_PerfRawData_PerfProc_Thread"), _
                                                           Array (cCritical, "Select * From Win32_LogicalDisk WHERE FreeSpace > 10000000 AND DriveType = 3", _
                                                                  cCritical, "Select DriveType From Win32_LogicalDisk WHERE Name='C:'", _
                                                                  cCritical, "Select * From Win32_Service", _
                                                                  cCritical, "Select * From Win32_PageFileUsage", _
                                                                  cCritical, "Select * From Win32_BIOS WHERE Version IS NOT NULL", _
                                                                  cCritical, "Select * From Win32_NetworkAdapter WHERE AdapterType IS NOT NULL AND AdapterType != ""Wide Area Network (WAN)"" AND Description != ""Packet Scheduler Miniport"" ", _
                                                                  cCritical, "Select * From Win32_Processor WHERE Name IS NOT NULL", _
                                                                  cCritical, "Select * From Win32_DiskDrive", _
                                                                  cCritical, "Select * From Win32_ComputerSystem", _
                                                                  cCritical, "Select * From Win32_DiskPartition", _
                                                                  cCritical, "Select * From Win32_LogicalDisk WHERE Description != ""Network Connection""", _
                                                                  cWarning,  "Select * From Win32_VideoController", _
                                                                  cWarning,  "Select * From Win32_USBController", _
                                                                  cWarning,  "Select * From Win32_DesktopMonitor", _
                                                                  cWarning,  "Select * From Win32_PointingDevice WHERE Status = ""OK""", _
                                                                  cWarning,  "Select * From Win32_Keyboard", _
                                                                  cCritical, "Select * From Win32_SystemDriver WHERE StartMode != ""Disabled"""), _
                                                           Null, _
                                                     "Root/WMI", _
                                                           True, _
                                                           Null, _
                                                           Array (cCritical, "Select * From MSNdis_MediaConnectStatus"), _
                                                           Null _
                                                    )
                    Else
                       arrayWMIDCOMDataList = Array (_
                                                     "%SystemRoot%\System32\WBEM\", "smi2smir.exe", True, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "mofcomp.exe", False, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "scrcons.exe", False, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "unsecapp.exe", False, Array ("\CLSID\{49BD2028-1523-11D1-AD79-00C04FD8FDFF}"),_
                                                     "%SystemRoot%\System32\WBEM\", "wbemtest.exe", False, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "winmgmt.exe", False, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "cimw32ex.dll", False, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "cimwin32.dll", False, Array ("\CLSID\{3DD82D10-E6F1-11D2-B139-00105A1F77A1}", _
                                                                                                                  "\CLSID\{D63A5850-8F16-11CF-9F47-00AA00BF345C}"), _
                                                     "%SystemRoot%\System32\WBEM\", "dsprov.dll", False, Array ("\CLSID\{1EF94880-01A8-11D2-A90B-00AA00BF3363}", _
                                                                                                                "\CLSID\{33831ED4-42B8-11D2-93AD-00805F853771}", _
                                                                                                                "\CLSID\{AA527A40-4D9A-11D2-93AD-00805F853771}"), _
                                                     "%SystemRoot%\System32\WBEM\", "fastprox.dll", False, Array ("\CLSID\{1B1CAD8C-2DAB-11D2-B604-00104B703EFD}", _
                                                                                                                  "\CLSID\{29B5828C-CAB9-11D2-B35C-00105A1F8177}", _
                                                                                                                  "\CLSID\{4590F812-1D3A-11D0-891F-00AA004B2E24}", _
                                                                                                                  "\CLSID\{674B6698-EE92-11D0-AD71-00C04FD8FDFF}", _
                                                                                                                  "\CLSID\{6C19BE35-7500-11D1-AD94-00C04FD8FDFF}", _
                                                                                                                  "\CLSID\{7016F8FA-CCDA-11D2-B35C-00105A1F8177}", _
                                                                                                                  "\CLSID\{71285C44-1DC0-11D2-B5FB-00104B703EFD}", _
                                                                                                                  "\CLSID\{7A0227F6-7108-11D1-AD90-00C04FD8FDFF}", _
                                                                                                                  "\CLSID\{C71566F2-561E-11D1-AD87-00C04FD8FDFF}"), _
                                                     "%SystemRoot%\System32\WBEM\", "framedyn.dll", False, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "mofd.dll", False, Array ("\CLSID\{6DAF9757-2E37-11D2-AEC9-00C04FB68820}", _
                                                                                                              "\CLSID\{C10B4771-4DA0-11D2-A2F5-00C04F86FB7D}"), _
                                                     "%SystemRoot%\System32\WBEM\", "ntevt.dll", False, Array ("\CLSID\{F55C5B4C-517D-11D1-AB57-00C04FD9159E}", _
                                                                                                               "\CLSID\{FD4F53E0-65DC-11D1-AB64-00C04FD9159E}"), _
                                                     "%SystemRoot%\System32\WBEM\", "provthrd.dll", False, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "secrcw32.dll", False, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "smtpcons.dll", False, Array ("\CLSID\{C7A3A54B-0250-11D3-9CD1-00105A1F4801}"), _
                                                     "%SystemRoot%\System32\WBEM\", "stdprov.dll", False, Array ("\CLSID\{72967901-68EC-11D0-B729-00AA0062CBB7}", _
                                                                                                                 "\CLSID\{72967903-68EC-11D0-B729-00AA0062CBB7}", _
                                                                                                                 "\CLSID\{F00B4404-F8F1-11CE-A5B6-00AA00680C3F}", _
                                                                                                                 "\CLSID\{FA77A74E-E109-11D0-AD6E-00C04FD8FDFF}", _
                                                                                                                 "\CLSID\{FE9AF5C0-D3B6-11CE-A5B6-00AA00680C3F}"), _
                                                     "%SystemRoot%\System32\WBEM\", "viewprov.dll", False, Array ("\CLSID\{AA70DDF4-E11C-11D1-ABB0-00C04FD9159E}"), _
                                                     "%SystemRoot%\System32\WBEM\", "wbemads.dll", False, Array ("\CLSID\{F0975AFE-5C7F-11D2-8B74-00104B2AFB41}"), _
                                                     "%SystemRoot%\System32\WBEM\", "wbemads.tlb", False, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "wbemcntl.dll", False, Array ("\CLSID\{5C659257-E236-11D2-8899-00104B2AFB46}", _
                                                                                                                  "\CLSID\{5C659258-E236-11D2-8899-00104B2AFB46}"), _
                                                     "%SystemRoot%\System32\WBEM\", "wbemcomn.dll", False, Array ("\CLSID\{9A653086-174F-11D2-B5F9-00104B703EFD}", _
                                                                                                                  "\CLSID\{EB87E1BD-3233-11D2-AEC9-00C04FB68820}"), _
                                                     "%SystemRoot%\System32\WBEM\", "wbemcore.dll", False, Array ("\CLSID\{443E7B79-DE31-11D2-B340-00104BCC4B4A}", _
                                                                                                                  "\CLSID\{4FA18276-912A-11D1-AD9B-00C04FD8FDFF}", _
                                                                                                                  "\CLSID\{A83EF168-CA8D-11D2-B33D-00104BCC4B4A}", _
                                                                                                                  "\CLSID\{CB8555CC-9128-11D1-AD9B-00C04FD8FDFF}", _
                                                                                                                  "\CLSID\{CD184336-9128-11D1-AD9B-00C04FD8FDFF}"), _
                                                     "%SystemRoot%\System32\WBEM\", "wbemdisp.dll", False, Array ("\CLSID\{172BDDF8-CEEA-11D1-8B05-00600806D9B6}", _
                                                                                                                  "\CLSID\{5791BC26-CE9C-11D1-97BF-0000F81E849C}", _
                                                                                                                  "\CLSID\{75718C9A-F029-11D1-A1AC-00C04FB6C223}", _
                                                                                                                  "\CLSID\{76A64158-CB41-11D1-8B02-00600806D9B6}", _
                                                                                                                  "\CLSID\{9AED384E-CE8B-11D1-8B05-00600806D9B6}", _
                                                                                                                  "\CLSID\{C2FEEEAC-CFCD-11D1-8B05-00600806D9B6}", _
                                                                                                                  "\Interface\{75718C9F-F029-11D1-A1AC-00C04FB6C223}", _
                                                                                                                  "\Interface\{75718CA0-F029-11D1-A1AC-00C04FB6C223}", _
                                                                                                                  "\Interface\{D962DB84-D4BB-11D1-8B09-00600806D9B6}"), _
                                                     "%SystemRoot%\System32\WBEM\", "wbemdisp.tlb", False, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "wbemess.dll", False, Array ("\CLSID\{5D08B586-343A-11D0-AD46-00C04FD8FDFF}"), _
                                                     "%SystemRoot%\System32\WBEM\", "wbemperf.dll", False, Array ("\CLSID\{FF37A93C-C28E-11D1-AEB6-00C04FB68820}"), _
                                                     "%SystemRoot%\System32\WBEM\", "wbemprox.dll", False, Array ("\CLSID\{4590F811-1D3A-11D0-891F-00AA004B2E24}", _
                                                                                                                  "\CLSID\{A1044801-8F7E-11D1-9E7C-00C04FC324A8}", _
                                                                                                                  "\CLSID\{F7CE2E13-8C90-11D1-9E7B-00C04FC324A8}"), _
                                                     "%SystemRoot%\System32\WBEM\", "wbemsvc.dll", False, Array ("\CLSID\{7C857801-7381-11CF-884D-00AA004B2E24}", _
                                                                                                                 "\Interface\{1BE41571-91DD-11D1-AEB2-00C04FB68820}", _
                                                                                                                 "\Interface\{1BE41572-91DD-11D1-AEB2-00C04FB68820}", _
                                                                                                                 "\Interface\{1C1C45EE-4395-11D2-B60B-00104B703EFD}", _
                                                                                                                 "\Interface\{1CFABA8C-1523-11D1-AD79-00C04FD8FDFF}", _
                                                                                                                 "\Interface\{2C9273E0-1DC3-11D3-B364-00105A1F8177}", _
                                                                                                                 "\Interface\{37196B38-CCCF-11D2-B35C-00105A1F8177}", _
                                                                                                                 "\Interface\{37196B39-CCCF-11D2-B35C-00105A1F8177}", _
                                                                                                                 "\Interface\{423EC01E-2E35-11D2-B604-00104B703EFD}", _
                                                                                                                 "\Interface\{44ACA675-E8FC-11D0-A07C-00C04FB68820}", _
                                                                                                                 "\Interface\{580ACAF8-FA1C-11D0-AD72-00C04FD8FDFF}", _
                                                                                                                 "\Interface\{60E512D4-C47B-11D2-B338-00105A1F4AAF}", _
                                                                                                                 "\Interface\{631F7D96-D993-11D2-B339-00105A1F4AAF}", _
                                                                                                                 "\Interface\{631F7D97-D993-11D2-B339-00105A1F4AAF}", _
                                                                                                                 "\Interface\{6C19BE32-7500-11D1-AD94-00C04FD8FDFF}", _
                                                                                                                 "\Interface\{6C19BE34-7500-11D1-AD94-00C04FD8FDFF}", _
                                                                                                                 "\Interface\{755F9DA7-7508-11D1-AD94-00C04FD8FDFF}", _
                                                                                                                 "\Interface\{C49E32C7-BC8B-11D2-85D4-00105A1F8304}", _
                                                                                                                 "\Interface\{E245105B-B06E-11D0-AD61-00C04FD8FDFF}", _
                                                                                                                 "\Interface\{E246107A-B06E-11D0-AD61-00C04FD8FDFF}", _
                                                                                                                 "\Interface\{F1E9C5B2-F59B-11D2-B362-00105A1F8177}", _
                                                                                                                 "\Interface\{F309AD18-D86A-11D0-A075-00C04FB68820}"), _
                                                     "%SystemRoot%\System32\WBEM\", "wbemupgd.dll", False, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "winmgmtr.dll", False, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "wmiprov.dll", False, Array ("\CLSID\{0725C3CB-FEFB-11D0-99F9-00C04FC2F8EC}", _
                                                                                                                 "\CLSID\{D2D588B5-D081-11D0-99E0-00C04FC2F8EC}"), _
                                                     "%SystemRoot%\System32\WBEM\", "msiprov.dll", False, Array ("\CLSID\{BE0A9830-2B8B-11D1-A949-0060181EBBAD}"), _
                                                     "%SystemRoot%\System32\WBEM\", "snmpcl.dll", True, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "snmpincl.dll", True, Array ("\CLSID\{19C813AC-FEE7-11D0-AB22-00C04FD9159E}", _
                                                                                                                 "\CLSID\{1F517A23-B29C-11CF-8C8D-00AA00A4086C}", _
                                                                                                                 "\CLSID\{70426720-F78F-11CF-9151-00AA00A4086C}", _
                                                                                                                 "\CLSID\{9D5BED16-0765-11D1-AB2C-00C04FD9159E}"), _
                                                     "%SystemRoot%\System32\WBEM\", "snmpsmir.dll", True, Array ("\CLSID\{5009AB90-F9EE-11CF-AEC1-00AA00BDD7D1}", _
                                                                                                                 "\CLSID\{5009AB92-F9EE-11CF-AEC1-00AA00BDD7D1}", _
                                                                                                                 "\CLSID\{5009AB94-F9EE-11CF-AEC1-00AA00BDD7D1}", _
                                                                                                                 "\CLSID\{5009AB9B-F9EE-11CF-AEC1-00AA00BDD7D1}", _
                                                                                                                 "\CLSID\{B11B26AC-A791-11D0-AAEA-00A024E8AD1C}", _
                                                                                                                 "\CLSID\{B11B26AE-A791-11D0-AAEA-00A024E8AD1C}"), _
                                                     "%SystemRoot%\System32\WBEM\", "snmpthrd.dll", True, Null, _
                                                     "%SystemRoot%\System32\WBEM\", "wmiutils.dll", True, Array ("\CLSID\{CF4CC405-E2C5-4DDD-B3CE-5E7582D8C9FA}", _
                                                                                                                 "\CLSID\{EAC8A024-21E2-4523-AD73-A71A0AA2F56A}"), _
                                                     "%SystemRoot%\System32\WBEM\", "wbemdc.dll", True, Array ("\CLSID\{6919DD07-1637-4611-A8A7-C16FAC5B2D53}"), _
                                                     "%SystemRoot%\System32\WBEM\", "wmidcad.dll", True, Array ("\CLSID\{4cfc7932-0f9d-4bef-9c32-8ea2a6b56fcb}", _
                                                                                                                "\CLSID\{54D8502C-527D-43f7-A506-A9DA075E229C}", _
                                                                                                                "\CLSID\{f5f75737-2843-4f22-933d-c76a97cda62f}") _
                                                    )

                           arrayWMITestList = Array (_
                                                     "Root", _
                                                           True, _
                                                           Null, _
                                                           Null, _
                                                           Array (cWarning, "__ObjectProviderCacheControl", "@",        Array ("ClearAfter", "00000000000200.000000:000"), _
                                                                  cWarning, "__PropertyProviderCacheControl", "@",      Array ("ClearAfter", "00000000000200.000000:000"), _
                                                                  cWarning, "__EventProviderCacheControl", "@",         Array ("ClearAfter", "00000000000010.000000:000"), _
                                                                  cWarning, "__EventConsumerProviderCacheControl", "@", Array ("ClearAfter", "00000000000010.000000:000"), _
                                                                  cWarning, "__EventSinkCacheControl", "@",             Array ("ClearAfter", "00000000000010.000000:000") _
                                                                 ), _
                                                     "Root/Default", _
                                                           True, _
                                                           Null, _
                                                           Null, _
                                                           Null, _
                                                     "Root/CIMv2", _
                                                           True, _
                                                           Array (cCritical, "Win32_Process", _
                                                                  cCritical, "Win32_OperatingSystem", _
                                                                  cCritical, "Win32_ComputerSystem", _
                                                                  cCritical, "Win32_Service", _
                                                                  cCritical, "Win32_Bios", _
                                                                  cPresence, "Win32_Perf", _
                                                                  cPresence, "Win32_PerfRawData", _
                                                                  cCritical, "Win32_PerfRawData_Tcpip_IP", _
                                                                  cCritical, "Win32_PerfRawData_Tcpip_TCP", _
                                                                  cCritical, "Win32_PerfRawData_Tcpip_UDP", _
                                                                  cCritical, "Win32_PerfRawData_Tcpip_ICMP", _
                                                                  cCritical, "Win32_PerfRawData_PerfOS_Cache", _
                                                                  cCritical, "Win32_PerfRawData_PerfOS_Memory", _
                                                                  cCritical, "Win32_PerfRawData_PerfOS_Objects", _
                                                                  cCritical, "Win32_PerfRawData_PerfOS_PagingFile", _
                                                                  cCritical, "Win32_PerfRawData_PerfOS_Processor", _
                                                                  cCritical, "Win32_PerfRawData_PerfOS_System", _
                                                                  cCritical, "Win32_PerfRawData_PerfProc_Process", _
                                                                  cCritical, "Win32_PerfRawData_PerfProc_Thread"), _
                                                           Array (cCritical, "Select * From Win32_LogicalDisk WHERE FreeSpace > 10000000 AND DriveType = 3", _
                                                                  cCritical, "Select DriveType From Win32_LogicalDisk WHERE Name='C:'", _
                                                                  cCritical, "Select * From Win32_Service", _
                                                                  cCritical, "Select * From Win32_PageFileUsage", _
                                                                  cCritical, "Select * From Win32_BIOS WHERE Version IS NOT NULL", _
                                                                  cCritical, "Select * From Win32_NetworkAdapter WHERE AdapterType IS NOT NULL AND AdapterType != ""Wide Area Network (WAN)"" AND Description != ""Packet Scheduler Miniport"" ", _
                                                                  cCritical, "Select * From Win32_Processor WHERE Name IS NOT NULL", _
                                                                  cCritical, "Select * From Win32_DiskDrive", _
                                                                  cCritical, "Select * From Win32_ComputerSystem", _
                                                                  cCritical, "Select * From Win32_DiskPartition", _
                                                                  cCritical, "Select * From Win32_LogicalDisk WHERE Description != ""Network Connection""", _
                                                                  cWarning,  "Select * From Win32_VideoController", _
                                                                  cWarning,  "Select * From Win32_USBController", _
                                                                  cWarning,  "Select * From Win32_DesktopMonitor", _
                                                                  cWarning,  "Select * From Win32_PointingDevice WHERE Status = ""OK""", _
                                                                  cWarning,  "Select * From Win32_Keyboard", _
                                                                  cCritical, "Select * From Win32_SystemDriver WHERE StartMode != ""Disabled"""), _
                                                           Null, _
                                                     "Root/WMI", _
                                                           True, _
                                                           Null, _
                                                           Array (cCritical, "Select * From MSNdis_MediaConnectStatus"), _
                                                           Null _
                                                    )
                    End If

                    arrayWMISystemClassList = Array ("__SystemClass", _
                                                     "__Provider", _
                                                     "__Win32Provider", _
                                                     "__ProviderRegistration", _
                                                     "__EventProviderRegistration", _
                                                     "__EventConsumerProviderRegistration", _
                                                     "__PropertyProviderRegistration", _
                                                     "__ObjectProviderRegistration", _
                                                     "__ClassProviderRegistration", _
                                                     "__InstanceProviderRegistration", _
                                                     "__MethodProviderRegistration", _
                                                     "__IndicationRelated", _
                                                     "__EventFilter", _
                                                     "__EventConsumer", _
                                                     "__FilterToConsumerBinding", _
                                                     "__EventGenerator", _
                                                     "__TimerInstruction", _
                                                     "__IntervalTimerInstruction", _
                                                     "__AbsoluteTimerInstruction", _
                                                     "__Event", _
                                                     "__ExtrinsicEvent", _
                                                     "__SystemEvent", _
                                                     "__EventDroppedEvent", _
                                                     "__ConsumerFailureEvent", _
                                                     "__EventQueueOverflowEvent", _
                                                     "__InstanceOperationEvent", _
                                                     "__InstanceCreationEvent", _
                                                     "__InstanceModificationEvent", _
                                                     "__InstanceDeletionEvent", _
                                                     "__ClassOperationEvent", _
                                                     "__ClassModificationEvent", _
                                                     "__ClassCreationEvent", _
                                                     "__ClassDeletionEvent", _
                                                     "__NamespaceOperationEvent", _
                                                     "__NamespaceDeletionEvent", _
                                                     "__NamespaceCreationEvent", _
                                                     "__NamespaceModificationEvent", _
                                                     "__TimerEvent", _
                                                     "__AggregateEvent", _
                                                     "__TimerNextFiring", _
                                                     "__SystemSecurity", _
                                                     "__NAMESPACE" _
                                                    )
            
                    arrayWMIProgID = Array ("WBemscripting.SWBemlocator", "wbemdisp.dll", _
                                            "WbemScripting.SWbemObjectPath", "wbemdisp.dll", _
                                            "WbemScripting.SWbemSink", "wbemdisp.dll", _
                                            "WbemScripting.SWbemLocator", "wbemdisp.dll", _
                                            "WbemScripting.SWbemNamedValueSet", "wbemdisp.dll" _
                                           )

                    arrayWMIRegistryServiceSetup = Array ("HKLM\SYSTEM\CurrentControlSet\Services\winmgmt", _
                                                          Array (_
                                                                 cRegistryError, "Type", "REG_DWORD", "&h10", _
                                                                 cRegistryError, "Start", "REG_DWORD", "&h2", _
                                                                 cRegistryWarning, "ErrorControl", "REG_DWORD", "&h0", _
                                                                 cRegistryError, "ImagePath", "REG_EXPAND_SZ", "%SystemRoot%\System32\WBEM\WinMgmt.exe", _
                                                                 cRegistryInfo, "DisplayName", "REG_SZ", Null, _
                                                                 cRegistryWarning, "DependOnService", "REG_MULTI_SZ", "RPCSS", _
                                                                 cRegistryInfo, "DependOnGroup", "REG_MULTI_SZ", Null, _
                                                                 cRegistryError, "ObjectName", "REG_SZ", "LocalSystem", _
                                                                 cRegistryInfo, "Description", "REG_SZ", Null _
                                                                ), _
                                                          "HKLM\SYSTEM\CurrentControlSet\Services\winmgmt\Security", _
                                                          Array (_
                                                                 cRegistryWarning, "Security", "REG_BINARY", "" _
                                                                ), _
                                                          "HKLM\SYSTEM\CurrentControlSet\Services\winmgmt\Enum", _
                                                          Array (_
                                                                 cRegistryWarning, "0", "REG_SZ", "Root\LEGACY_WINMGMT\0000", _
                                                                 cRegistryWarning, "Count", "REG_DWORD", "&h1", _
                                                                 cRegistryWarning, "NextInstance", "REG_DWORD", "&h1" _
                                                                ) _
                                                          )

                    arrayWMIRegistrySettings = Array ("HKLM\SOFTWARE\Microsoft\WBEM\Scripting", _
                                                      Array (_
                                                             cRegistryWarning, "Default Namespace", "REG_SZ", "root\cimv2", _
                                                             cRegistryWarning, "Default Impersonation Level", "REG_DWORD", "3" _
                                                            ), _
                                                     "HKLM\SOFTWARE\Microsoft\WBEM\CIMOM", _
                                                      Array (_
                                                             cRegistryError, "EnableEvents", "REG_SZ", "1", _
                                                             cRegistryInfo, "Logging", "REG_SZ", "1", _
                                                             cRegistryWarning, "Logging Directory", "REG_EXPAND_SZ", "%SystemRoot%\system32\WBEM\Logs", _
                                                             cRegistryError, "Repository Directory", "REG_EXPAND_SZ", "%SystemRoot%\system32\WBEM\Repository", _
                                                             cRegistryWarning, "TimeOutMs", "REG_SZ", "20000", _
                                                             cRegistryError, "WMISetup", "REG_SZ", "0", _
                                                             cRegistryWarning, "Autorecover MOFs", "REG_SZ", Null, _
                                                             cRegistryError, "Working Directory", "REG_EXPAND_SZ", "%SystemRoot%\system32\WBEM" _
                                                            ) _
                                                     )

                    arrayWMIRegistryDCOMSetup = Array ("HKLM\SOFTWARE\Classes\AppID\{8BC3F05E-D86B-11D0-A075-00C04FB68820}", _
                                                       Array (_
                                                              cRegistryInfo, "", "REG_SZ", "Windows Management Instrumentation", _
                                                              cRegistryWarningWhenPresent, "AuthenticationLevel", "REG_DWORD", Null, _
                                                              cRegistryError, "LocalService", "REG_SZ", "WINMGMT" _
                                                             ), _
                                                       "HKLM\SOFTWARE\Classes\CLSID\{8BC3F05E-D86B-11D0-A075-00C04FB68820}", _
                                                       Array (_
                                                              cRegistryInfo, "", "REG_SZ", "Windows Management Instrumentation", _
                                                              cRegistryError, "AppID", "REG_SZ", "{8BC3F05E-D86B-11D0-A075-00C04FB68820}" _
                                                             ), _
                                                       "HKLM\SOFTWARE\Classes\AppID\winmgmt", _
                                                       Array (_
                                                              cRegistryError, "AppID", "REG_SZ", "{74864DA1-0630-11D0-A5B6-00AA00680C3F}" _
                                                             ), _
                                                       "HKLM\SOFTWARE\Classes\AppID\{49BD2028-1523-11D1-AD79-00C04FD8FDFF}", _
                                                       Array (_
                                                              cRegistryWarningWhenPresent, "AuthenticationLevel", "REG_DWORD", Null _
                                                             ), _
                                                       "HKLM\SOFTWARE\Classes\CLSID\{49BD2028-1523-11D1-AD79-00C04FD8FDFF}", _
                                                       Array (_
                                                              cRegistryInfo, "", "REG_SZ", "Microsoft WBEM UnSecured Apartment" _
                                                             ), _
                                                       "HKLM\SOFTWARE\Classes\AppID\{266C72E7-62E8-11D1-AD89-00C04FD8FDFF}", _
                                                       Array (_
                                                              cRegistryWarningWhenPresent, "AuthenticationLevel", "REG_DWORD", Null _
                                                             ), _
                                                       "HKLM\SOFTWARE\Classes\CLSID\{266C72E7-62E8-11D1-AD89-00C04FD8FDFF}", _
                                                       Array (_
                                                              cRegistryInfo, "", "REG_SZ", "Microsoft WBEM Active Scripting Event Consumer Provider" _
                                                             ), _
                                                       "HKLM\SOFTWARE\Classes\CLSID\{C49E32C6-BC8B-11D2-85D4-00105A1F8304}", _
                                                       Array (_
                                                              cRegistryInfo, "", "REG_SZ", "Windows Management Instrumentation Backup and Recovery", _
                                                              cRegistryError, "AppID", "REG_SZ", "{8BC3F05E-D86B-11D0-A075-00C04FB68820}" _
                                                             ), _
                                                       "HKLM\SOFTWARE\Classes\WINMGMTS", _
                                                       Array (_
                                                              cRegistryInfo, "", "REG_SZ", "Wbem Scripting Object Path" _
                                                             ), _
                                                       "HKLM\SOFTWARE\Classes\WINMGMTS\CLSID", _
                                                       Array (_
                                                              cRegistryError, "", "REG_SZ", "{172BDDF8-CEEA-11D1-8B05-00600806D9B6}" _
                                                             ), _
                                                       "HKLM\SOFTWARE\Classes\WINMGMTS\CurVer", _
                                                       Array (_
                                                              cRegistryError, "", "REG_SZ", "WINMGMTS.1" _
                                                             ), _
                                                       "HKCR\WINMGMTS.1", _
                                                       Array (_
                                                              cRegistryInfo, "", "REG_SZ", "Wbem Object Path 1.0" _
                                                             ), _
                                                       "HKCR\WINMGMTS.1\CLSID", _
                                                       Array (_
                                                              cRegistryError, "", "REG_SZ", "{172BDDF8-CEEA-11D1-8B05-00600806D9B6}" _
                                                             ), _
                                                       "HKLM\SOFTWARE\Classes\CLSID\{172BDDF8-CEEA-11D1-8B05-00600806D9B6}\ProgID", _
                                                       Array (_
                                                              cRegistryError, "", "REG_SZ", "WINMGMTS.1" _
                                                             ), _
                                                       "HKLM\SOFTWARE\Classes\CLSID\{172BDDF8-CEEA-11D1-8B05-00600806D9B6}\VersionIndependentProgID", _
                                                       Array (_
                                                              cRegistryError, "", "REG_SZ", "WINMGMTS" _
                                                             ) _
                                                      )

                    arrayWMISystemConfigurationClasses = Array ("__CIMOMIdentification", "__CacheControl")

                    arrayWMIRepositoryFiles = Array(_
                                                    "Repository", _
                                                    "$WinMgmt.CFG", _
                                                    "CIM.REP" _
                                                   )

                    arrayWMIServiceKnownDependent = Array (_
                                                           "CcmExec", "SMS Agent Host", _
                                                           "6to4", "IPv6 Helper Service", _
                                                           "MSExchangeMGMT", "Exchange Management Service", _
                                                           "IIMFilter", "Live Communication Server Filter Service", _
                                                           "RtcSrv", "Live Communication Server User Service", _
                                                           "MngAgent", "SNA Mngagent Service", _
                                                           "ADSBuilder", "Automated Deployment Services (ADS) Deployment Agent", _
                                                           "ADSPXE", "Automated Deployment Services (ADS) PXE Service" _
                                                          )

                    arrayDCOMDefaultAccessPermission = Array ("BUILTIN\Administrators", _
                                                              "BUILTIN\Administrators", _
                                                              SE_DACL_PRESENT Or SE_SELF_RELATIVE, _
                                                              Array ("NT AUTHORITY\SELF", _
                                                                       ACCESS_ALLOWED_ACE_TYPE, _
                                                                       0, _
                                                                       DCOM_RIGHT_EXECUTE Or _
                                                                         DCOM_RIGHT_ACCESS_LOCAL Or _
                                                                         DCOM_RIGHT_ACCESS_REMOTE, _
                                                                     "NT AUTHORITY\SYSTEM", _
                                                                       ACCESS_ALLOWED_ACE_TYPE, _
                                                                       0, _
                                                                       DCOM_RIGHT_EXECUTE Or _
                                                                         DCOM_RIGHT_ACCESS_LOCAL), _
                                                              Null _
                                                             )
           
                    arrayDCOMDefaultLaunchPermission = Array ("BUILTIN\Administrators", _
                                                              "BUILTIN\Administrators", _
                                                              SE_DACL_PRESENT Or SE_SELF_RELATIVE, _
                                                              Array ("BUILTIN\Administrators", _
                                                                        ACCESS_ALLOWED_ACE_TYPE, _
                                                                        0, _
                                                                        DCOM_RIGHT_EXECUTE Or _
                                                                          DCOM_RIGHT_LAUNCH_LOCAL Or _
                                                                          DCOM_RIGHT_LAUNCH_REMOTE Or _
                                                                          DCOM_RIGHT_ACTIVATE_LOCAL Or _
                                                                          DCOM_RIGHT_ACTIVATE_REMOTE, _
                                                                     "NT AUTHORITY\INTERACTIVE", _
                                                                        ACCESS_ALLOWED_ACE_TYPE, _
                                                                        0, _
                                                                        DCOM_RIGHT_EXECUTE Or _
                                                                          DCOM_RIGHT_LAUNCH_LOCAL Or _
                                                                          DCOM_RIGHT_ACTIVATE_LOCAL, _
                                                                     "NT AUTHORITY\SYSTEM", _
                                                                        ACCESS_ALLOWED_ACE_TYPE, _
                                                                        0, _
                                                                        DCOM_RIGHT_EXECUTE Or _
                                                                          DCOM_RIGHT_LAUNCH_LOCAL Or _
                                                                          DCOM_RIGHT_ACTIVATE_LOCAL), _
                                                              Null _
                                                             )
           
                    arrayDCOMMachineAccessRestriction = Array ("BUILTIN\Administrators", _
                                                               "BUILTIN\Administrators", _
                                                               SE_DACL_PRESENT Or SE_SELF_RELATIVE, _
                                                               Array ("NT AUTHORITY\ANONYMOUS LOGON", _
                                                                         ACCESS_ALLOWED_ACE_TYPE, _
                                                                         0, _
                                                                         DCOM_RIGHT_EXECUTE Or _
                                                                           DCOM_RIGHT_ACCESS_LOCAL, _
                                                                      "Everyone", _
                                                                         ACCESS_ALLOWED_ACE_TYPE, _
                                                                         0, _
                                                                         DCOM_RIGHT_EXECUTE Or _
                                                                           DCOM_RIGHT_ACCESS_LOCAL Or _
                                                                           DCOM_RIGHT_ACCESS_REMOTE), _
                                                               Null _ 
                                                              )
           
                    arrayDCOMMachineLaunchRestriction = Array ("BUILTIN\Administrators", _
                                                               "BUILTIN\Administrators", _
                                                               SE_DACL_PRESENT Or SE_SELF_RELATIVE, _
                                                               Array ("BUILTIN\Administrators", _
                                                                         ACCESS_ALLOWED_ACE_TYPE, _
                                                                         0, _
                                                                         DCOM_RIGHT_EXECUTE Or _
                                                                           DCOM_RIGHT_LAUNCH_LOCAL Or _
                                                                           DCOM_RIGHT_LAUNCH_REMOTE Or _
                                                                           DCOM_RIGHT_ACTIVATE_LOCAL Or _
                                                                           DCOM_RIGHT_ACTIVATE_REMOTE, _
                                                                      "Everyone", _
                                                                         ACCESS_ALLOWED_ACE_TYPE, _
                                                                         0, _
                                                                         DCOM_RIGHT_EXECUTE Or _
                                                                           DCOM_RIGHT_LAUNCH_LOCAL Or _
                                                                           DCOM_RIGHT_ACTIVATE_LOCAL), _
                                                               Null _
                                                              )
           
                    arrayWMIDCOMAccessPermission = arrayDCOMDefaultAccessPermission 
                    arrayWMIDCOMLaunchPermission = Array ("BUILTIN\Administrators", _
                                                          "BUILTIN\Administrators", _
                                                          SE_DACL_PRESENT Or SE_SELF_RELATIVE, _
                                                          Array ("Everyone", _
                                                                    ACCESS_ALLOWED_ACE_TYPE, _
                                                                    0, _
                                                                    DCOM_RIGHT_EXECUTE Or _
                                                                      DCOM_RIGHT_LAUNCH_LOCAL Or _
                                                                      DCOM_RIGHT_LAUNCH_REMOTE Or _
                                                                      DCOM_RIGHT_ACTIVATE_LOCAL Or _
                                                                      DCOM_RIGHT_ACTIVATE_REMOTE), _
                                                          Null _
                                                         ) 
           
                    arrayWMIPSSDCOMAccessPermission = arrayDCOMDefaultAccessPermission 
                    arrayWMIPSSDCOMLaunchPermission = Array ("BUILTIN\Administrators", _
                                                             "BUILTIN\Administrators", _
                                                             SE_DACL_PRESENT Or SE_SELF_RELATIVE, _
                                                             Array ("BUILTIN\Administrators", _
                                                                       ACCESS_ALLOWED_ACE_TYPE, _
                                                                       0, _
                                                                       DCOM_RIGHT_EXECUTE Or _
                                                                         DCOM_RIGHT_LAUNCH_LOCAL Or _
                                                                         DCOM_RIGHT_LAUNCH_REMOTE Or _
                                                                         DCOM_RIGHT_ACTIVATE_LOCAL Or _
                                                                         DCOM_RIGHT_ACTIVATE_REMOTE, _
                                                                    "NT AUTHORITY\INTERACTIVE", _
                                                                       ACCESS_ALLOWED_ACE_TYPE, _
                                                                       0, _
                                                                       DCOM_RIGHT_EXECUTE Or _
                                                                         DCOM_RIGHT_LAUNCH_LOCAL Or _
                                                                         DCOM_RIGHT_LAUNCH_REMOTE Or _
                                                                         DCOM_RIGHT_ACTIVATE_LOCAL Or _
                                                                         DCOM_RIGHT_ACTIVATE_REMOTE, _
                                                                    "NT AUTHORITY\SYSTEM", _
                                                                       ACCESS_ALLOWED_ACE_TYPE, _
                                                                       0, _
                                                                       DCOM_RIGHT_EXECUTE Or _
                                                                         DCOM_RIGHT_LAUNCH_LOCAL Or _
                                                                         DCOM_RIGHT_LAUNCH_REMOTE Or _
                                                                         DCOM_RIGHT_ACTIVATE_LOCAL Or _
                                                                         DCOM_RIGHT_ACTIVATE_REMOTE, _
                                                                    "NT AUTHORITY\NETWORK SERVICE", _
                                                                       ACCESS_ALLOWED_ACE_TYPE, _
                                                                       0, _
                                                                       DCOM_RIGHT_EXECUTE Or _
                                                                         DCOM_RIGHT_LAUNCH_LOCAL Or _
                                                                         DCOM_RIGHT_LAUNCH_REMOTE Or _
                                                                         DCOM_RIGHT_ACTIVATE_LOCAL Or _
                                                                         DCOM_RIGHT_ACTIVATE_REMOTE, _
                                                                    "NT AUTHORITY\LOCAL SERVICE", _
                                                                       ACCESS_ALLOWED_ACE_TYPE, _
                                                                       0, _
                                                                       DCOM_RIGHT_EXECUTE Or _
                                                                         DCOM_RIGHT_LAUNCH_LOCAL Or _
                                                                         DCOM_RIGHT_LAUNCH_REMOTE Or _
                                                                         DCOM_RIGHT_ACTIVATE_LOCAL Or _
                                                                         DCOM_RIGHT_ACTIVATE_REMOTE), _
                                                             Null _
                                                            ) 

                    arrayWMIUnsecureApptDCOMAccessPermission = arrayDCOMDefaultAccessPermission 
                    arrayWMIUnsecureApptDCOMLaunchPermission = arrayDCOMDefaultLaunchPermission 

                    arrayWMIActiveScriptEventConsDCOMAccessPermission = arrayDCOMDefaultAccessPermission 
                    arrayWMIActiveScriptEventConsDCOMLaunchPermission = arrayDCOMDefaultLaunchPermission 

                    arrayWMIDefaultNameSpaceSecurity = Array ("BUILTIN\Administrators", _
                                                              "BUILTIN\Administrators", _
                                                               SE_DACL_PRESENT Or SE_SELF_RELATIVE, _
                                                               Array ("BUILTIN\Administrators", _
                                                                         ACCESS_ALLOWED_ACE_TYPE, _
                                                                         CONTAINER_INHERIT_ACE Or INHERITED_ACE, _
                                                                         WBEM_ENABLE Or _
                                                                           WBEM_METHOD_EXECUTE Or _
                                                                           WBEM_FULL_WRITE_REP Or _
                                                                           WBEM_PARTIAL_WRITE_REP Or _
                                                                           WBEM_WRITE_PROVIDER Or _
                                                                           WBEM_REMOTE_ACCESS Or _
                                                                           WBEM_WRITE_DAC Or _
                                                                           WBEM_READ_CONTROL, _
                                                                      "NT AUTHORITY\NETWORK SERVICE", _
                                                                         ACCESS_ALLOWED_ACE_TYPE, _
                                                                         CONTAINER_INHERIT_ACE Or INHERITED_ACE, _
                                                                         WBEM_ENABLE Or _
                                                                           WBEM_METHOD_EXECUTE Or _
                                                                           WBEM_WRITE_PROVIDER, _
                                                                      "NT AUTHORITY\LOCAL SERVICE", _
                                                                         ACCESS_ALLOWED_ACE_TYPE, _
                                                                         CONTAINER_INHERIT_ACE Or INHERITED_ACE, _
                                                                         WBEM_ENABLE Or _
                                                                           WBEM_METHOD_EXECUTE Or _
                                                                           WBEM_WRITE_PROVIDER, _
                                                                      "Everyone", _
                                                                         ACCESS_ALLOWED_ACE_TYPE, _
                                                                         CONTAINER_INHERIT_ACE Or INHERITED_ACE, _
                                                                         WBEM_ENABLE Or _
                                                                           WBEM_METHOD_EXECUTE Or _
                                                                           WBEM_WRITE_PROVIDER), _
                                                               Null _
                                                              )
           
                    arrayWMINameSpaceSecurity = Array ("ROOT", _
                                                       arrayWMIDefaultNameSpaceSecurity, _
                                                       "ROOT/SECURITY", _
                                                       arrayWMIDefaultNameSpaceSecurity, _
                                                       "ROOT/CLI", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/ASPNET", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/SNMP", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/SNMP/LOCALHOST", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/SECURITYCENTER", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/WMI", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/CIMV2", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/CIMV2/APPLICATIONS", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/CIMV2/APPLICATIONS/MICROSOFTIE", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/POLICY", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/MICROSOFT", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/MICROSOFT/HOMENET", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/DEFAULT", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/DIRECTORY", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/DIRECTORY/LDAP", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/SUBSCRIPTION", _
                                                       arrayWMIDefaultNameSpaceSecurity, _
                                                       "Root/RSOP", _
                                                       Array ("BUILTIN\Administrators", _
                                                              "BUILTIN\Administrators", _
                                                               SE_DACL_PRESENT Or SE_SELF_RELATIVE, _
                                                               Array ("BUILTIN\Administrators", _
                                                                         ACCESS_ALLOWED_ACE_TYPE, _
                                                                         CONTAINER_INHERIT_ACE Or INHERITED_ACE, _
                                                                         WBEM_ENABLE Or _
                                                                           WBEM_METHOD_EXECUTE Or _
                                                                           WBEM_FULL_WRITE_REP Or _
                                                                           WBEM_PARTIAL_WRITE_REP Or _
                                                                           WBEM_WRITE_PROVIDER Or _
                                                                           WBEM_REMOTE_ACCESS Or _
                                                                           WBEM_WRITE_DAC Or _
                                                                           WBEM_READ_CONTROL, _
                                                                      "NT AUTHORITY\SYSTEM", _
                                                                         ACCESS_ALLOWED_ACE_TYPE, _
                                                                         CONTAINER_INHERIT_ACE Or INHERITED_ACE, _
                                                                         WBEM_ENABLE Or _
                                                                           WBEM_METHOD_EXECUTE Or _
                                                                           WBEM_FULL_WRITE_REP Or _
                                                                           WBEM_PARTIAL_WRITE_REP Or _
                                                                           WBEM_WRITE_PROVIDER Or _
                                                                           WBEM_REMOTE_ACCESS Or _
                                                                           WBEM_WRITE_DAC Or _
                                                                           WBEM_READ_CONTROL, _
                                                                      "NT AUTHORITY\Authenticated Users", _
                                                                         ACCESS_ALLOWED_ACE_TYPE, _
                                                                         CONTAINER_INHERIT_ACE Or INHERITED_ACE, _
                                                                         WBEM_ENABLE Or _
                                                                           WBEM_METHOD_EXECUTE Or _
                                                                           WBEM_REMOTE_ACCESS Or _
                                                                           WBEM_READ_CONTROL), _
                                                               Null _
                                                              ), _
                                                       "Root/RSOP/Computer", _
                                                       Array ("BUILTIN\Administrators", _
                                                              "BUILTIN\Administrators", _
                                                               SE_DACL_PRESENT Or SE_SELF_RELATIVE, _
                                                               Array ("BUILTIN\Administrators", _
                                                                         ACCESS_ALLOWED_ACE_TYPE, _
                                                                         CONTAINER_INHERIT_ACE Or INHERITED_ACE, _
                                                                         WBEM_ENABLE Or _
                                                                           WBEM_METHOD_EXECUTE Or _
                                                                           WBEM_FULL_WRITE_REP Or _
                                                                           WBEM_PARTIAL_WRITE_REP Or _
                                                                           WBEM_WRITE_PROVIDER Or _
                                                                           WBEM_REMOTE_ACCESS Or _
                                                                           WBEM_WRITE_DAC Or _
                                                                           WBEM_READ_CONTROL, _
                                                                      "NT AUTHORITY\SYSTEM", _
                                                                         ACCESS_ALLOWED_ACE_TYPE, _
                                                                         CONTAINER_INHERIT_ACE Or INHERITED_ACE, _
                                                                         WBEM_ENABLE Or _
                                                                           WBEM_METHOD_EXECUTE Or _
                                                                           WBEM_FULL_WRITE_REP Or _
                                                                           WBEM_PARTIAL_WRITE_REP Or _
                                                                           WBEM_WRITE_PROVIDER Or _
                                                                           WBEM_REMOTE_ACCESS Or _
                                                                           WBEM_WRITE_DAC Or _
                                                                           WBEM_READ_CONTROL, _
                                                                      "NT AUTHORITY\Authenticated Users", _
                                                                         ACCESS_ALLOWED_ACE_TYPE, _
                                                                         CONTAINER_INHERIT_ACE Or INHERITED_ACE, _
                                                                         WBEM_ENABLE Or _
                                                                           WBEM_METHOD_EXECUTE Or _
                                                                           WBEM_REMOTE_ACCESS Or _
                                                                           WBEM_READ_CONTROL), _
                                                               Null _
                                                              ), _
                                                       "Root/RSOP/User", _
                                                       Array ("BUILTIN\Administrators", _
                                                              "BUILTIN\Administrators", _
                                                               SE_DACL_PRESENT Or SE_SELF_RELATIVE, _
                                                               Array ("BUILTIN\Administrators", _
                                                                         ACCESS_ALLOWED_ACE_TYPE, _
                                                                         CONTAINER_INHERIT_ACE Or INHERITED_ACE, _
                                                                         WBEM_ENABLE Or _
                                                                           WBEM_METHOD_EXECUTE Or _
                                                                           WBEM_FULL_WRITE_REP Or _
                                                                           WBEM_PARTIAL_WRITE_REP Or _
                                                                           WBEM_WRITE_PROVIDER Or _
                                                                           WBEM_REMOTE_ACCESS Or _
                                                                           WBEM_WRITE_DAC Or _
                                                                           WBEM_READ_CONTROL, _
                                                                      "NT AUTHORITY\SYSTEM", _
                                                                         ACCESS_ALLOWED_ACE_TYPE, _
                                                                         CONTAINER_INHERIT_ACE Or INHERITED_ACE, _
                                                                         WBEM_ENABLE Or _
                                                                           WBEM_METHOD_EXECUTE Or _
                                                                           WBEM_FULL_WRITE_REP Or _
                                                                           WBEM_PARTIAL_WRITE_REP Or _
                                                                           WBEM_WRITE_PROVIDER Or _
                                                                           WBEM_REMOTE_ACCESS Or _
                                                                           WBEM_WRITE_DAC Or _
                                                                           WBEM_READ_CONTROL, _
                                                                      "NT AUTHORITY\Authenticated Users", _
                                                                         ACCESS_ALLOWED_ACE_TYPE, _
                                                                         CONTAINER_INHERIT_ACE Or INHERITED_ACE, _
                                                                         WBEM_ENABLE Or _
                                                                           WBEM_METHOD_EXECUTE Or _
                                                                           WBEM_REMOTE_ACCESS Or _
                                                                           WBEM_READ_CONTROL), _
                                                                          Null _
                                                              ) _
                                                      )

               Case cWindowsXPRTM, cWindowsXPSP1

                    arrayWMIDCOMDataList = Array (_
                                                  "%SystemRoot%\System32\WBEM\", "smi2smir.exe", True, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "wmiprvse.exe", False, Array ("\CLSID\{73E709EA-5D93-4B2E-BBB0-99B7938DA9E4}"), _
                                                  "%SystemRoot%\System32\WBEM\", "mofcomp.exe", False, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "scrcons.exe", False, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "unsecapp.exe", False, Array ("\CLSID\{49BD2028-1523-11D1-AD79-00C04FD8FDFF}"),_
                                                  "%SystemRoot%\System32\WBEM\", "wbemtest.exe", False, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "winmgmt.exe", False, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "wmiadap.exe", False, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "wmiapsrv.exe", False, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "cimwin32.dll", False, Array ("\CLSID\{3DD82D10-E6F1-11D2-B139-00105A1F77A1}", _
                                                                                                               "\CLSID\{D31B6A3F-9350-40DE-A3FC-A7EDEB9B7C63}", _
                                                                                                               "\CLSID\{D63A5850-8F16-11CF-9F47-00AA00BF345C}"), _
                                                  "%SystemRoot%\System32\WBEM\", "CmdEvTgProv.dll", True, Array ("\CLSID\{797EF3B3-127B-4283-8096-1E8084BF67A6}"), _
                                                  "%SystemRoot%\System32\WBEM\", "dsprov.dll", False, Array ("\CLSID\{1EF94880-01A8-11D2-A90B-00AA00BF3363}", _
                                                                                                             "\CLSID\{33831ED4-42B8-11D2-93AD-00805F853771}", _
                                                                                                             "\CLSID\{AA527A40-4D9A-11D2-93AD-00805F853771}"), _
                                                  "%SystemRoot%\System32\WBEM\", "esscli.dll", False, Array ("\CLSID\{6C19BE35-7500-11D1-AD94-00C04FD8FDFF}", _
                                                                                                             "\CLSID\{DC923725-0FDD-45E1-AE74-EA09182E739B}"), _
                                                  "%SystemRoot%\System32\WBEM\", "evntrprv.dll", False, Array ("\CLSID\{9a5dd473-d410-11d1-b829-00c04f94c7c3}", _
                                                                                                               "\CLSID\{f95e1664-7979-44f2-a040-496e7f500043}"), _
                                                  "%SystemRoot%\System32\WBEM\", "fastprox.dll", False, Array ("\CLSID\{1108BE51-F58A-4CDA-BB99-7A0227D11D5E}", _
                                                                                                               "\CLSID\{1B1CAD8C-2DAB-11D2-B604-00104B703EFD}", _
                                                                                                               "\CLSID\{29B5828C-CAB9-11D2-B35C-00105A1F8177}", _
                                                                                                               "\CLSID\{4590F812-1D3A-11D0-891F-00AA004B2E24}", _
                                                                                                               "\CLSID\{5839FCA9-774D-42A1-ACDA-D6A79037F57F}", _
                                                                                                               "\CLSID\{674B6698-EE92-11D0-AD71-00C04FD8FDFF}", _
                                                                                                               "\CLSID\{7016F8FA-CCDA-11D2-B35C-00105A1F8177}", _
                                                                                                               "\CLSID\{71285C44-1DC0-11D2-B5FB-00104B703EFD}", _
                                                                                                               "\CLSID\{78103FB7-AED7-4066-8BCD-30BB27B02331}", _
                                                                                                               "\CLSID\{7A0227F6-7108-11D1-AD90-00C04FD8FDFF}", _
                                                                                                               "\CLSID\{8D1C559D-84F0-4BB3-A7D5-56A7435A9BA6}", _
                                                                                                               "\CLSID\{9A653086-174F-11D2-B5F9-00104B703EFD}", _
                                                                                                               "\CLSID\{C71566F2-561E-11D1-AD87-00C04FD8FDFF}", _
                                                                                                               "\CLSID\{CC9072AB-C000-49D8-A5AA-00266C8DBB9B}", _
                                                                                                               "\CLSID\{CD1ABFC8-6C5E-4A8D-B90B-2A3B153B886D}", _
                                                                                                               "\CLSID\{D68AF00A-29CB-43FA-8504-CE99A996D9EA}", _
                                                                                                               "\CLSID\{D71EE747-F455-4804-9DF6-2ED81025F2C1}", _
                                                                                                               "\CLSID\{DCF33DF4-B510-439F-832A-16B6B514F2A7}", _
                                                                                                               "\CLSID\{ED51D12E-511F-4999-8DCD-C2BAC91BE86E}"), _
                                                  "%SystemRoot%\System32\WBEM\", "framedyn.dll", False, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "fwdprov.dll", False, Array ("\CLSID\{7879E40D-9FB5-450A-8A6D-00C89F349FCE}", _
                                                                                                              "\CLSID\{AD1B46E8-0AAC-401B-A3B8-FCDCF8186F55}"), _
                                                  "%SystemRoot%\System32\WBEM\", "krnlprov.dll", False, Array ("\CLSID\{9877D8A7-FDA1-43F9-AEEA-F90747EA66B0}", _
                                                                                                               "\TypeLib\{6B100E1A-1385-4D1F-A02E-6E705A76BB6C}\1.0"), _
                                                  "%SystemRoot%\System32\WBEM\", "mofd.dll", False, Array ("\CLSID\{6DAF9757-2E37-11D2-AEC9-00C04FB68820}", _
                                                                                                           "\CLSID\{C10B4771-4DA0-11D2-A2F5-00C04F86FB7D}"), _
                                                  "%SystemRoot%\System32\WBEM\", "ncprov.dll", False, Array ("\CLSID\{29F06F0C-FB7F-44A5-83CD-D41705D5C525}", _
                                                                                                             "\TypeLib\{5F099F16-6A6E-4BBC-8BD8-98F3221D58C4}\1.0"), _
                                                  "%SystemRoot%\System32\WBEM\", "ntevt.dll", False, Array ("\CLSID\{F55C5B4C-517D-11D1-AB57-00C04FD9159E}", _
                                                                                                            "\CLSID\{FD4F53E0-65DC-11D1-AB64-00C04FD9159E}"), _
                                                  "%SystemRoot%\System32\WBEM\", "policman.dll", True, Array ("\CLSID\{69D76D1B-B12E-4913-8F48-671B90195A2B}", _
                                                                                                              "\CLSID\{AAEAE72F-0328-4763-8ECB-23422EDE2DB5}"), _
                                                  "%SystemRoot%\System32\WBEM\", "provthrd.dll", False, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "repdrvfs.dll", False, Array ("\CLSID\{7998DC37-D3FE-487C-A60A-7701FCC70CC6}"), _
                                                  "%SystemRoot%\System32\WBEM\", "smtpcons.dll", False, Array ("\CLSID\{C7A3A54B-0250-11D3-9CD1-00105A1F4801}"), _
                                                  "%SystemRoot%\System32\WBEM\", "stdprov.dll", False, Array ("\CLSID\{72967901-68EC-11D0-B729-00AA0062CBB7}", _
                                                                                                              "\CLSID\{72967903-68EC-11D0-B729-00AA0062CBB7}", _
                                                                                                              "\CLSID\{F00B4404-F8F1-11CE-A5B6-00AA00680C3F}", _
                                                                                                              "\CLSID\{FA77A74E-E109-11D0-AD6E-00C04FD8FDFF}", _
                                                                                                              "\CLSID\{FE9AF5C0-D3B6-11CE-A5B6-00AA00680C3F}"), _
                                                  "%SystemRoot%\System32\WBEM\", "tmplprov.dll", False, Array ("\CLSID\{C486ABD2-27F6-11D3-865E-00C04F63049B}"), _
                                                  "%SystemRoot%\System32\WBEM\", "trnsprov.dll", False, Array ("\CLSID\{405595AA-1E14-11D3-B33D-00105A1F4AAF}", _
                                                                                                               "\CLSID\{405595AB-1E14-11D3-B33D-00105A1F4AAF}"), _
                                                  "%SystemRoot%\System32\WBEM\", "updprov.dll", False, Array ("\CLSID\{74E3B84C-C7BE-4E0A-9BD2-853CA72CD435}", _
                                                                                                              "\CLSID\{A3A16907-227B-11D3-865D-00C04F63049B}"), _
                                                  "%SystemRoot%\System32\WBEM\", "viewprov.dll", False, Array ("\CLSID\{AA70DDF4-E11C-11D1-ABB0-00C04FD9159E}"), _
                                                  "%SystemRoot%\System32\WBEM\", "wbemads.dll", False, Array ("\CLSID\{F0975AFE-5C7F-11D2-8B74-00104B2AFB41}"), _
                                                  "%SystemRoot%\System32\WBEM\", "wbemads.tlb", False, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "wbemcntl.dll", False, Array ("\CLSID\{5C659257-E236-11D2-8899-00104B2AFB46}", _
                                                                                                               "\CLSID\{5C659258-E236-11D2-8899-00104B2AFB46}"), _
                                                  "%SystemRoot%\System32\WBEM\", "wbemcomn.dll", False, Array ("\CLSID\{266C72D4-62E8-11D1-AD89-00C04FD8FDFF}", _
                                                                                                               "\CLSID\{266C72E5-62E8-11D1-AD89-00C04FD8FDFF}", _
                                                                                                               "\CLSID\{266C72E6-62E8-11D1-AD89-00C04FD8FDFF}"), _
                                                  "%SystemRoot%\System32\WBEM\", "wbemcons.dll", False, Array ("\CLSID\{266C72D4-62E8-11D1-AD89-00C04FD8FDFF}", _
                                                                                                               "\CLSID\{266C72E5-62E8-11D1-AD89-00C04FD8FDFF}", _
                                                                                                               "\CLSID\{266C72E6-62E8-11D1-AD89-00C04FD8FDFF}"), _
                                                  "%SystemRoot%\System32\WBEM\", "wbemcore.dll", False, Array ("\CLSID\{1860E246-E924-4F73-B2C5-93E0577E3AA1}", _
                                                                                                               "\CLSID\{1F0BC6AD-46D4-488B-BE1F-047FC7505E60}", _
                                                                                                               "\CLSID\{4FA18276-912A-11D1-AD9B-00C04FD8FDFF}", _
                                                                                                               "\CLSID\{6543D242-A80B-44A3-B828-95C1EC452423}", _
                                                                                                               "\CLSID\{A83EF168-CA8D-11D2-B33D-00104BCC4B4A}", _
                                                                                                               "\CLSID\{ED999FF5-223A-4052-8ECE-0B10C8DBAA39}"), _
                                                  "%SystemRoot%\System32\WBEM\", "wbemdisp.dll", False, Array ("\CLSID\{172BDDF8-CEEA-11D1-8B05-00600806D9B6}", _
                                                                                                               "\CLSID\{47DFBE54-CF76-11D3-B38F-00105A1F473A}", _
                                                                                                               "\CLSID\{5791BC26-CE9C-11D1-97BF-0000F81E849C}", _
                                                                                                               "\CLSID\{75718C9A-F029-11D1-A1AC-00C04FB6C223}", _
                                                                                                               "\CLSID\{76A64158-CB41-11D1-8B02-00600806D9B6}", _
                                                                                                               "\CLSID\{9AED384E-CE8B-11D1-8B05-00600806D9B6}", _
                                                                                                               "\CLSID\{C2FEEEAC-CFCD-11D1-8B05-00600806D9B6}", _
                                                                                                               "\CLSID\{D269BF5C-D9C1-11D3-B38F-00105A1F473A}", _
                                                                                                               "\Interface\{14D8250E-D9C2-11D3-B38F-00105A1F473A}", _
                                                                                                               "\Interface\{269AD56A-8A67-4129-BC8C-0506DCFE9880}", _
                                                                                                               "\Interface\{5AD4BF92-DAAB-11D3-B38F-00105A1F473A}", _
                                                                                                               "\Interface\{5E97458A-CF77-11D3-B38F-00105A1F473A}", _
                                                                                                               "\Interface\{75718C9F-F029-11D1-A1AC-00C04FB6C223}", _
                                                                                                               "\Interface\{75718CA0-F029-11D1-A1AC-00C04FB6C223}", _
                                                                                                               "\Interface\{D2F68443-85DC-427E-91D8-366554CC754C}", _
                                                                                                               "\Interface\{D962DB84-D4BB-11D1-8B09-00600806D9B6}", _
                                                                                                               "\TypeLib\{565783C6-CB41-11D1-8B02-00600806D9B6}\1.2"), _
                                                  "%SystemRoot%\System32\WBEM\", "wbemdisp.tlb", False, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "wbemess.dll", False, Array ("\CLSID\{5D08B586-343A-11D0-AD46-00C04FD8FDFF}", _
                                                                                                              "\CLSID\{F3130CDB-AA52-4C3A-AB32-85FFC23AF9C1}"), _
                                                  "%SystemRoot%\System32\WBEM\", "wbemperf.dll", False, Array ("\CLSID\{76A94DE3-7C26-44F5-8E98-C5AEA48186CB}", _
                                                                                                               "\CLSID\{FF37A93C-C28E-11D1-AEB6-00C04FB68820}"), _
                                                  "%SystemRoot%\System32\WBEM\", "wbemprox.dll", False, Array ("\CLSID\{443E7B79-DE31-11D2-B340-00104BCC4B4A}", _
                                                                                                               "\CLSID\{4590F811-1D3A-11D0-891F-00AA004B2E24}", _
                                                                                                               "\CLSID\{4C6055D8-84B9-4111-A7D3-6623894EEDB3}", _
                                                                                                               "\CLSID\{A1044801-8F7E-11D1-9E7C-00C04FC324A8}", _
                                                                                                               "\CLSID\{CB8555CC-9128-11D1-AD9B-00C04FD8FDFF}", _
                                                                                                               "\CLSID\{CD184336-9128-11D1-AD9B-00C04FD8FDFF}", _
                                                                                                               "\CLSID\{F7CE2E13-8C90-11D1-9E7B-00C04FC324A8}"), _
                                                  "%SystemRoot%\System32\WBEM\", "wbemsvc.dll", False, Array ("\CLSID\{7C857801-7381-11CF-884D-00AA004B2E24}", _
                                                                                                              "\Interface\{06413D98-405C-4A5A-8D6F-19B8B7C6ACF7}", _
                                                                                                              "\Interface\{07435309-D440-41B7-83F3-EB82DB6C622F}", _
                                                                                                              "\Interface\{0FC8C622-1728-4149-A57F-AD19D0970710}", _
                                                                                                              "\Interface\{11CAA957-4E80-474E-A819-7FD72148ADA9}", _
                                                                                                              "\Interface\{1BE41571-91DD-11D1-AEB2-00C04FB68820}", _
                                                                                                              "\Interface\{1BE41572-91DD-11D1-AEB2-00C04FB68820}", _
                                                                                                              "\Interface\{1C1C45EE-4395-11D2-B60B-00104B703EFD}", _
                                                                                                              "\Interface\{1CFABA8C-1523-11D1-AD79-00C04FD8FDFF}", _
                                                                                                              "\Interface\{21CD80A2-B305-4F37-9D4C-4534A8D9B568}", _
                                                                                                              "\Interface\{25411283-46FC-4326-8DF2-FF5D34B2DFEF}", _
                                                                                                              "\Interface\{2A504CA2-CA90-4731-87BC-6E99CA2019AF}", _
                                                                                                              "\Interface\{2B322B6E-A9DF-44E3-97BF-259E3583FDA4}", _
                                                                                                              "\Interface\{2C9273E0-1DC3-11D3-B364-00105A1F8177}", _
                                                                                                              "\Interface\{2DB9FA90-9973-46CF-B310-9865B644699D}", _
                                                                                                              "\Interface\{37196B38-CCCF-11D2-B35C-00105A1F8177}", _
                                                                                                              "\Interface\{37196B39-CCCF-11D2-B35C-00105A1F8177}", _
                                                                                                              "\Interface\{3AE0080A-7E3A-4366-BF89-0FEEDC931659}", _
                                                                                                              "\Interface\{41AA40E6-2FBA-4E80-ADE9-34306567206D}", _
                                                                                                              "\Interface\{423EC01E-2E35-11D2-B604-00104B703EFD}", _
                                                                                                              "\Interface\{44ACA675-E8FC-11D0-A07C-00C04FB68820}", _
                                                                                                              "\Interface\{484E3ECE-1F81-4591-B9D4-943BA13B609D}", _
                                                                                                              "\Interface\{48FF3109-A366-4B56-B340-01FAE758BA64}", _
                                                                                                              "\Interface\{580ACAF8-FA1C-11D0-AD72-00C04FD8FDFF}", _
                                                                                                              "\Interface\{5FBA5051-3124-4112-B723-46BFBAF1D622}", _
                                                                                                              "\Interface\{60E512D4-C47B-11D2-B338-00105A1F4AAF}", _
                                                                                                              "\Interface\{631F7D96-D993-11D2-B339-00105A1F4AAF}", _
                                                                                                              "\Interface\{631F7D97-D993-11D2-B339-00105A1F4AAF}", _
                                                                                                              "\Interface\{6919DD07-1637-4611-A8A7-C16FAC5B2D53}", _
                                                                                                              "\Interface\{6963B029-B969-40AA-9180-2B2F84075973}", _
                                                                                                              "\Interface\{6B3FC272-BF37-4968-933A-6DF9222A2607}", _
                                                                                                              "\Interface\{6C19BE32-7500-11D1-AD94-00C04FD8FDFF}", _
                                                                                                              "\Interface\{6C19BE34-7500-11D1-AD94-00C04FD8FDFF}", _
                                                                                                              "\Interface\{755F9DA7-7508-11D1-AD94-00C04FD8FDFF}", _
                                                                                                              "\Interface\{854D745C-6742-42C0-8BB9-01EC466B6E87}", _
                                                                                                              "\Interface\{88F3781C-6902-4647-9A6B-A74F450AF861}", _
                                                                                                              "\Interface\{8A0DC377-A9D3-41CB-BD69-AE1FDAF2DC68}", _
                                                                                                              "\Interface\{A210BFE9-C9F7-4919-B114-0D98B3D5341E}", _
                                                                                                              "\Interface\{A359DEC5-E813-4834-8A2A-BA7F1D777D76}", _
                                                                                                              "\Interface\{AC9EA02A-2C8A-4ACD-B562-D7E8EBEE8E8E}", _
                                                                                                              "\Interface\{B1B55910-8BA0-47A5-A16E-2B733B1D987C}", _
                                                                                                              "\Interface\{B60EF4F1-A411-462B-B51E-477CBDBB90B4}", _
                                                                                                              "\Interface\{B7B31DF9-D515-11D3-A11C-00105A1F515A}", _
                                                                                                              "\Interface\{BAC6B661-167E-4957-AD77-286AB256585E}", _
                                                                                                              "\Interface\{C49E32C7-BC8B-11D2-85D4-00105A1F8304}", _
                                                                                                              "\Interface\{CE61E841-65BC-11D0-B6BD-00AA003240C7}", _
                                                                                                              "\Interface\{D4781CD6-E5D3-44DF-AD94-930EFE48A887}", _
                                                                                                              "\Interface\{D8EC9CB1-B135-4F10-8B1B-C7188BB0D186}", _
                                                                                                              "\Interface\{DF2373F5-EFB2-475C-AD58-3102D61967D4}", _
                                                                                                              "\Interface\{E245105B-B06E-11D0-AD61-00C04FD8FDFF}", _
                                                                                                              "\Interface\{E246107A-B06E-11D0-AD61-00C04FD8FDFF}", _
                                                                                                              "\Interface\{E8107BDF-BAAF-4C7C-BB5F-9D732E8D8F07}", _
                                                                                                              "\Interface\{EB658B8A-7A64-4DDC-9B8D-A92610DB0206}", _
                                                                                                              "\Interface\{F0E4EDDE-475A-498A-93D7-D4347F68A8F3}", _
                                                                                                              "\Interface\{F1E9C5B2-F59B-11D2-B362-00105A1F8177}", _
                                                                                                              "\Interface\{F309AD18-D86A-11D0-A075-00C04FB68820}", _
                                                                                                              "\Interface\{F50A28CF-5C9C-4F7E-9D80-E25E16E18C59}", _
                                                                                                              "\Interface\{FD450835-CF1B-4C87-9FD2-5E0D42FDE081}", _
                                                                                                              "\Interface\{FEC1B0AC-5808-4033-A915-C0185934581E}"), _
                                                  "%SystemRoot%\System32\WBEM\", "wbemupgd.dll", False, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "winmgmtr.dll", False, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "wmiapres.dll", False, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "wmiaprpl.dll", False, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "wmicookr.dll", False, Array ("\CLSID\{B0A2AB46-F612-4469-BEC4-7AB038BC476C}"), _
                                                  "%SystemRoot%\System32\WBEM\", "wmidcprv.dll", False, Array ("\CLSID\{4CFC7932-0F9D-4BEF-9C32-8EA2A6B56FCB}", _
                                                                                                               "\CLSID\{F5F75737-2843-4F22-933D-C76A97CDA62F}"), _
                                                  "%SystemRoot%\System32\WBEM\", "wmimsg.dll", False, Array ("\CLSID\{622D47B6-CEEC-4DE1-8056-B6D16F29BC97}", _
                                                                                                             "\CLSID\{89F9F7B0-8DE3-4AE0-8B41-109ABAB32151}", _
                                                                                                             "\CLSID\{958C59A0-3670-4FE0-B893-6998BB494402}", _
                                                                                                             "\CLSID\{9F007F18-9C24-4630-8B3E-61F96280C593}", _
                                                                                                             "\CLSID\{C1692211-1EC1-4847-9C0D-D2F2D80D07CF}", _
                                                                                                             "\CLSID\{C169CC11-1EC1-4847-9C0D-D2F2D80D07CF}", _
                                                                                                             "\CLSID\{CE69CC1E-1EC0-4847-9C0D-D2F2D80D07CF}"), _
                                                  "%SystemRoot%\System32\WBEM\", "wmipcima.dll", False, Array ("\CLSID\{04788120-12C2-498D-83C1-A7D92E677AC6}", _
                                                                                                               "\CLSID\{A3E41207-BE04-492A-AFF0-19E880FF7545}", _
                                                                                                               "\CLSID\{E2CBCB87-9C07-4523-A78F-061499C83987}"), _
                                                  "%SystemRoot%\System32\WBEM\", "wmipdskq.dll", False, Array ("\CLSID\{4AF3F4A4-06C8-4B79-A523-633CC65CE297}"), _
                                                  "%SystemRoot%\System32\WBEM\", "wmipicmp.dll", False, Array ("\CLSID\{734AC5AE-68E1-4FB5-B8DA-1D92F7FC6661}"), _
                                                  "%SystemRoot%\System32\WBEM\", "wmipiprt.dll", False, Array ("\CLSID\{23B77E99-5C2D-482D-A795-62CA3AE5B673}", _
                                                                                                               "\CLSID\{6D7A4B0E-66D5-4AC3-A7ED-0189E8CF5E77}"), _
                                                  "%SystemRoot%\System32\WBEM\", "wmipjobj.dll", False, Array ("\CLSID\{6515834D-6125-4878-A3A3-6B0A73B809A2}", _
                                                                                                               "\CLSID\{7FB1D98A-F895-4761-8DC2-774969C84D10}", _
                                                                                                               "\CLSID\{AB40A5C1-804B-40BD-9DFE-A640691C6956}", _
                                                                                                               "\CLSID\{C0AA9D93-2EF5-47FB-960C-F90FC644B48E}"), _
                                                  "%SystemRoot%\System32\WBEM\", "wmiprov.dll", False, Array ("\CLSID\{0725C3CB-FEFB-11D0-99F9-00C04FC2F8EC}", _
                                                                                                              "\CLSID\{35B78F79-B973-48C8-A045-CAEC732A35D5}", _
                                                                                                              "\CLSID\{D2D588B5-D081-11D0-99E0-00C04FC2F8EC}"), _
                                                  "%SystemRoot%\System32\WBEM\", "wmiprvsd.dll", False, Array ("\CLSID\{4DE225BF-CF59-4CFC-85F7-68B90F185355}", _
                                                                                                               "\CLSID\{7F598975-37E0-4A67-A992-116680F0CEDA}", _
                                                                                                               "\CLSID\{8BEBCE8B-1AF0-4323-8B4D-36994567CAE1}", _
                                                                                                               "\CLSID\{F5A55D36-8750-432C-AB52-AD49A016EABC}"), _
                                                  "%SystemRoot%\System32\WBEM\", "wmipsess.dll", False, Array ("\CLSID\{6E78DAD9-E187-4D6E-BA63-760256D6F405}"), _
                                                  "%SystemRoot%\System32\WBEM\", "wmisvc.dll", False, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "wmitimep.dll", False, Array ("\CLSID\{C4819C8D-9AB8-4B2F-B8AE-C77DABF553D5}"), _
                                                  "%SystemRoot%\System32\WBEM\", "wmiutils.dll", False, Array ("\CLSID\{CF4CC405-E2C5-4DDD-B3CE-5E7582D8C9FA}", _
                                                                                                               "\CLSID\{EAC8A024-21E2-4523-AD73-A71A0AA2F56A}", _
                                                                                                               "\CLSID\{EB87E1BD-3233-11D2-AEC9-00C04FB68820}"), _
                                                  "%SystemRoot%\System32\WBEM\", "msiprov.dll", False, Array ("\CLSID\{BE0A9830-2B8B-11D1-A949-0060181EBBAD}"), _
                                                  "%SystemRoot%\System32\WBEM\xml\", "wmi2xml.dll", False, Null, _
                                                  "%SystemRoot%\System32\WBEM\xml\", "cim20.dtd", False, Null, _
                                                  "%SystemRoot%\System32\WBEM\xml\", "wmi20.dtd", False, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "xsl-mappings.xml", True, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "csv.xsl", True, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "hform.xsl", True, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "htable-sortby.xsl", True, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "htable.xsl", True, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "mof.xsl", True, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "rawxml.xsl", True, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "texttable.xsl", True, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "texttablewsys.xsl", True, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "textvaluelist.xsl", True, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "wmiclimofformat.xsl", True, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "wmiclitableformat.xsl", True, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "wmiclitableformatnosys.xsl", True, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "wmiclivalueformat.xsl", True, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "xml.xsl", True, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "wmic.exe", True, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "snmpcl.dll", True, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "snmpincl.dll", True, Array ("\CLSID\{19C813AC-FEE7-11D0-AB22-00C04FD9159E}", _
                                                                                                              "\CLSID\{1F517A23-B29C-11CF-8C8D-00AA00A4086C}", _
                                                                                                              "\CLSID\{70426720-F78F-11CF-9151-00AA00A4086C}", _
                                                                                                              "\CLSID\{9D5BED16-0765-11D1-AB2C-00C04FD9159E}"), _
                                                  "%SystemRoot%\System32\WBEM\", "snmpsmir.dll", True, Array ("\CLSID\{5009AB90-F9EE-11CF-AEC1-00AA00BDD7D1}", _
                                                                                                              "\CLSID\{5009AB92-F9EE-11CF-AEC1-00AA00BDD7D1}", _
                                                                                                              "\CLSID\{5009AB94-F9EE-11CF-AEC1-00AA00BDD7D1}", _
                                                                                                              "\CLSID\{5009AB9B-F9EE-11CF-AEC1-00AA00BDD7D1}", _
                                                                                                              "\CLSID\{B11B26AC-A791-11D0-AAEA-00A024E8AD1C}", _
                                                                                                              "\CLSID\{B11B26AE-A791-11D0-AAEA-00A024E8AD1C}"), _
                                                  "%SystemRoot%\System32\WBEM\", "snmpstup.dll", True, Null, _
                                                  "%SystemRoot%\System32\WBEM\", "snmpthrd.dll", True, Null _
                                                 )

                    arrayWMISystemClassList = Array ("__SystemClass", _
                                                     "__thisNAMESPACE", _
                                                     "__Provider", _
                                                     "__Win32Provider", _
                                                     "__ProviderRegistration", _
                                                     "__EventProviderRegistration", _
                                                     "__EventConsumerProviderRegistration", _
                                                     "__PropertyProviderRegistration", _
                                                     "__ObjectProviderRegistration", _
                                                     "__ClassProviderRegistration", _
                                                     "__InstanceProviderRegistration", _
                                                     "__MethodProviderRegistration", _
                                                     "__IndicationRelated", _
                                                     "__EventFilter", _
                                                     "__EventConsumer", _
                                                     "__FilterToConsumerBinding", _
                                                     "__EventGenerator", _
                                                     "__TimerInstruction", _
                                                     "__IntervalTimerInstruction", _
                                                     "__AbsoluteTimerInstruction", _
                                                     "__Event", _
                                                     "__ExtrinsicEvent", _
                                                     "__SystemEvent", _
                                                     "__EventDroppedEvent", _
                                                     "__ConsumerFailureEvent", _
                                                     "__QOSFailureEvent", _
                                                     "__EventQueueOverflowEvent", _
                                                     "__InstanceOperationEvent", _
                                                     "__InstanceCreationEvent", _
                                                     "__InstanceModificationEvent", _
                                                     "__MethodInvocationEvent", _
                                                     "__InstanceDeletionEvent", _
                                                     "__ClassOperationEvent", _
                                                     "__ClassModificationEvent", _
                                                     "__ClassCreationEvent", _
                                                     "__ClassDeletionEvent", _
                                                     "__NamespaceOperationEvent", _
                                                     "__NamespaceDeletionEvent", _
                                                     "__NamespaceCreationEvent", _
                                                     "__NamespaceModificationEvent", _
                                                     "__TimerEvent", _
                                                     "__AggregateEvent", _
                                                     "__TimerNextFiring", _
                                                     "__SystemSecurity", _
                                                     "__NAMESPACE" _
                                                    )

                    arrayWMIProgID = Array ("WBemscripting.SWBemlocator", "wbemdisp.dll", _
                                            "WbemScripting.SWbemDateTime", "wbemdisp.dll", _
                                            "WbemScripting.SWbemObjectPath", "wbemdisp.dll", _
                                            "WbemScripting.SWbemSink", "wbemdisp.dll", _
                                            "WbemScripting.SWbemLocator", "wbemdisp.dll", _
                                            "WbemScripting.SWbemNamedValueSet", "wbemdisp.dll", _
                                            "WbemScripting.SWbemRefresher", "wbemdisp.dll" _
                                           )

                    arrayWMITestList = Array (_
                                              "Root", _
                                                    True, _
                                                    Null, _
                                                    Null, _
                                                    Array (cWarning, "__ArbitratorConfiguration", "@", Array ("OutstandingTasksPerUser", 30, _
                                                                                                              "OutstandingTasksTotal", 3000, _
                                                                                                              "PermanentSubscriptionsPerUser", 1000, _
                                                                                                              "PermanentSubscriptionsTotal", 10000, _
                                                                                                              "PollingInstructionsPerUser", 1000, _
                                                                                                              "PollingInstructionsTotal", 10000, _
                                                                                                              "PollingMemoryPerUser", 5000000, _
                                                                                                              "PollingMemoryTotal", 10000000, _
                                                                                                              "QuotaRetryCount", 10, _
                                                                                                              "QuotaRetryWaitInterval", 15000, _
                                                                                                              "TaskThreadsPerUser", 3, _
                                                                                                              "TaskThreadsTotal", 30, _
                                                                                                              "TemporarySubscriptionsPerUser", 1000, _
                                                                                                              "TemporarySubscriptionsTotal", 10000, _
                                                                                                              "TotalCacheDisk", 1048576, _
                                                                                                              "TotalCacheDiskPerTask", 51250, _
                                                                                                              "TotalCacheDiskPerUser", 102500, _
                                                                                                              "TotalCacheMemory", 10240, _
                                                                                                              "TotalCacheMemoryPerTask", 1024, _
                                                                                                              "TotalCacheMemoryPerUser", 2048, _
                                                                                                              "TotalUsers", 50), _
                                                           cWarning, "__ProviderHostQuotaConfiguration", "@", Array ("HandlesPerHost", 4096, _
                                                                                                                     "MemoryAllHosts", "1073741824", _
                                                                                                                     "MemoryPerHost", "134217728", _
                                                                                                                     "ProcessLimitAllHosts", 32, _
                                                                                                                     "ThreadsPerHost", 256), _
                                                           cWarning, "__EventProviderCacheControl", "@",         Array ("ClearAfter", "00000000000030.000000:000"), _
                                                           cWarning, "__ObjectProviderCacheControl", "@",        Array ("ClearAfter", "00000000000030.000000:000"), _
                                                           cWarning, "__EventSinkCacheControl", "@",             Array ("ClearAfter", "00000000000015.000000:000"), _
                                                           cWarning, "__EventConsumerProviderCacheControl", "@", Array ("ClearAfter", "00000000000030.000000:000"), _
                                                           cWarning, "__PropertyProviderCacheControl", "@",      Array ("ClearAfter", "00000000000030.000000:000") ), _
                                              "Root/Default", _
                                                    True, _
                                                    Array (cWarning, "SystemRestore", _
                                                           cWarning, "SystemRestoreConfig"), _
                                                    Array (cWarning,  "Select * From SystemRestore", _
                                                           cWarning,  "Select * From SystemRestoreConfig"), _
                                                    Null, _
                                              "Root/CIMv2", _
                                                    True, _
                                                    Array (cCritical, "Win32_Process", _
                                                           cCritical, "Win32_OperatingSystem", _
                                                           cCritical, "Win32_ComputerSystem", _
                                                           cCritical, "Win32_Service", _
                                                           cCritical, "Win32_Bios", _
                                                           cPresence, "Win32_Perf", _
                                                           cPresence, "Win32_PerfRawData", _
                                                           cCritical, "Win32_PerfRawData_Tcpip_IP", _
                                                           cCritical, "Win32_PerfRawData_Tcpip_TCP", _
                                                           cCritical, "Win32_PerfRawData_Tcpip_UDP", _
                                                           cCritical, "Win32_PerfRawData_Tcpip_ICMP", _
                                                           cCritical, "Win32_PerfRawData_PerfOS_Cache", _
                                                           cCritical, "Win32_PerfRawData_PerfOS_Memory", _
                                                           cCritical, "Win32_PerfRawData_PerfOS_Objects", _
                                                           cCritical, "Win32_PerfRawData_PerfOS_PagingFile", _
                                                           cCritical, "Win32_PerfRawData_PerfOS_Processor", _
                                                           cCritical, "Win32_PerfRawData_PerfOS_System", _
                                                           cCritical, "Win32_PerfRawData_PerfProc_Process", _
                                                           cCritical, "Win32_PerfRawData_PerfProc_Thread", _
                                                           cPresence, "Win32_PerfFormattedData", _
                                                           cCritical, "Win32_PerfFormattedData_Tcpip_IP", _
                                                           cCritical, "Win32_PerfFormattedData_Tcpip_TCP", _
                                                           cCritical, "Win32_PerfFormattedData_Tcpip_UDP", _
                                                           cCritical, "Win32_PerfFormattedData_Tcpip_ICMP", _
                                                           cCritical, "Win32_PerfFormattedData_PerfOS_Cache", _
                                                           cCritical, "Win32_PerfFormattedData_PerfOS_Memory", _
                                                           cCritical, "Win32_PerfFormattedData_PerfOS_Objects", _
                                                           cCritical, "Win32_PerfFormattedData_PerfOS_PagingFile", _
                                                           cCritical, "Win32_PerfFormattedData_PerfOS_Processor", _
                                                           cCritical, "Win32_PerfFormattedData_PerfOS_System", _
                                                           cCritical, "Win32_PerfFormattedData_PerfProc_Process", _
                                                           cCritical, "Win32_PerfFormattedData_PerfProc_Thread"), _
                                                    Array (cCritical, "Select * From Win32_LogicalDisk WHERE FreeSpace > 10000000 AND DriveType = 3", _
                                                           cCritical, "Select DriveType From Win32_LogicalDisk WHERE Name='C:'", _
                                                           cCritical, "Select * From Win32_Service", _
                                                           cCritical, "Select * From Win32_PageFileUsage", _
                                                           cCritical, "Select * From Win32_BIOS WHERE Version IS NOT NULL", _
                                                           cCritical, "Select * From Win32_NetworkAdapter WHERE AdapterType IS NOT NULL AND AdapterType != ""Wide Area Network (WAN)"" AND Description != ""Packet Scheduler Miniport"" ", _
                                                           cCritical, "Select * From Win32_Processor WHERE Name IS NOT NULL", _
                                                           cCritical, "Select * From Win32_DiskDrive", _
                                                           cCritical, "Select * From Win32_ComputerSystem", _
                                                           cCritical, "Select * From Win32_DiskPartition", _
                                                           cCritical, "Select * From Win32_LogicalDisk WHERE Description != ""Network Connection""", _
                                                           cWarning,  "Select * From Win32_SoundDevice", _
                                                           cWarning,  "Select * From Win32_VideoController", _
                                                           cWarning,  "Select * From Win32_USBController", _
                                                           cWarning,  "Select * From Win32_DesktopMonitor", _
                                                           cWarning,  "Select * From Win32_PointingDevice WHERE Status = ""OK""", _
                                                           cWarning,  "Select * From Win32_Keyboard", _
                                                           cCritical, "Select * From Win32_SystemDriver WHERE StartMode != ""Disabled"""), _
                                                    Null, _
                                              "Root/WMI", _
                                                    True, _
                                                    Null, _
                                                    Array (cCritical, "Select * From MSNdis_MediaConnectStatus"), _
                                                    Null _
                                             )

                    arrayWMIRegistryServiceSetup = Array ("HKLM\SYSTEM\CurrentControlSet\Services\winmgmt", _
                                                          Array (_
                                                                 cRegistryError, "Type", "REG_DWORD", "&h20", _
                                                                 cRegistryError, "Start", "REG_DWORD", "&h2", _
                                                                 cRegistryWarning, "ErrorControl", "REG_DWORD", "&h0", _
                                                                 cRegistryWarning, "ImagePath", "REG_EXPAND_SZ", "%systemroot%\system32\svchost.exe -k netsvcs", _
                                                                 cRegistryInfo, "DisplayName", "REG_SZ", Null, _
                                                                 cRegistryWarning, "DependOnService", "REG_MULTI_SZ", "RPCSS", _
                                                                 cRegistryInfo, "DependOnGroup", "REG_MULTI_SZ", Null, _
                                                                 cRegistryError, "ObjectName", "REG_SZ", "LocalSystem", _
                                                                 cRegistryWarning, "FailureActions", "REG_BINARY", Null, _
                                                                 cRegistryInfo, "Description", "REG_SZ", Null _
                                                                ), _
                                                          "HKLM\SYSTEM\CurrentControlSet\Services\winmgmt\Parameters", _
                                                          Array (_
                                                                 cRegistryError, "ServiceDll", "REG_EXPAND_SZ", "%SystemRoot%\system32\wbem\WMIsvc.dll", _
                                                                 cRegistryError, "ServiceMain", "REG_SZ", "ServiceMain" _
                                                                ), _
                                                          "HKLM\SYSTEM\CurrentControlSet\Services\winmgmt\Security", _
                                                          Array (_
                                                                 cRegistryWarning, "Security", "REG_BINARY", "" _
                                                                ), _
                                                          "HKLM\SYSTEM\CurrentControlSet\Services\winmgmt\Enum", _
                                                          Array (_
                                                                 cRegistryWarning, "0", "REG_SZ", "Root\LEGACY_WINMGMT\0000", _
                                                                 cRegistryWarning, "Count", "REG_DWORD", "&h1", _
                                                                 cRegistryWarning, "NextInstance", "REG_DWORD", "&h1" _
                                                                ) _
                                                         )

                    arrayWMIRegistrySettings = Array ("HKLM\SOFTWARE\Microsoft\WBEM\Scripting", _
                                                      Array (_
                                                             cRegistryWarning, "Default Namespace", "REG_SZ", "root\cimv2", _
                                                             cRegistryWarning, "Default Impersonation Level", "REG_DWORD", "3" _
                                                            ), _
                                                      "HKLM\SOFTWARE\Microsoft\WBEM\CIMOM", _
                                                      Array (_
                                                             cRegistryWarning, "ADAPDelay", "REG_DWORD", "&hf0", _
                                                             cRegistryError, "Default Repository Driver", "REG_SZ", "{7998dc37-d3fe-487c-a60a-7701fcc70cc6}", _
                                                             cRegistryError, "EnableEvents", "REG_SZ", "1", _
                                                             cRegistryInfo, "Logging", "REG_SZ", "1", _
                                                             cRegistryWarning, "Logging Directory", "REG_EXPAND_SZ", "%SystemRoot%\system32\WBEM\Logs\", _
                                                             cRegistryError, "Repository Directory", "REG_EXPAND_SZ", "%SystemRoot%\system32\WBEM\Repository", _
                                                             cRegistryWarning, "TimeOutMs", "REG_SZ", "20000", _
                                                             cRegistryError, "WMISetup", "REG_SZ", "0", _
                                                             cRegistryWarning, "Autorecover MOFs", "REG_SZ", Null, _
                                                             cRegistryError, "Working Directory", "REG_EXPAND_SZ", "%SystemRoot%\system32\WBEM" _
                                                            ) _
                                                     )

                    arrayWMIRegistryDCOMSetup = Array ("HKLM\SOFTWARE\Classes\AppID\{8BC3F05E-D86B-11D0-A075-00C04FB68820}", _
                                                       Array (_
                                                              cRegistryInfo, "", "REG_SZ", "Windows Management and Instrumentation", _
                                                              cRegistryWarningWhenPresent, "AuthenticationLevel", "REG_DWORD", Null, _
                                                              cRegistryError, "LocalService", "REG_SZ", "WINMGMT" _
                                                             ), _
                                                       "HKLM\SOFTWARE\Classes\CLSID\{8BC3F05E-D86B-11D0-A075-00C04FB68820}", _
                                                       Array (_
                                                              cRegistryInfo, "", "REG_SZ", "Windows Management and Instrumentation", _
                                                              cRegistryError, "AppID", "REG_SZ", "{8BC3F05E-D86B-11D0-A075-00C04FB68820}", _
                                                              cRegistryError, "LocalService", "REG_SZ", "WINMGMT" _
                                                             ), _
                                                       "HKLM\SOFTWARE\Classes\AppID\winmgmt", _
                                                       Array (_
                                                              cRegistryError, "AppID", "REG_SZ", "{8BC3F05E-D86B-11D0-A075-00C04FB68820}" _
                                                             ), _
                                                       "HKLM\SOFTWARE\Classes\AppID\{73E709EA-5D93-4B2E-BBB0-99B7938DA9E4}", _
                                                       Array (_
                                                              cRegistryInfo, "", "REG_SZ", "Microsoft WMI Provider Subsystem Host", _
                                                              cRegistryWarningWhenPresent, "AuthenticationLevel", "REG_DWORD", Null _
                                                             ), _
                                                       "HKLM\SOFTWARE\Classes\CLSID\{73E709EA-5D93-4B2E-BBB0-99B7938DA9E4}", _
                                                       Array (_
                                                              cRegistryInfo, "", "REG_SZ", "Microsoft WMI Provider Subsystem Host", _
                                                              cRegistryError, "AppID", "REG_SZ", "{73E709EA-5D93-4B2E-BBB0-99B7938DA9E4}" _
                                                             ), _ 
                                                       "HKLM\SOFTWARE\Classes\AppID\{49BD2028-1523-11D1-AD79-00C04FD8FDFF}", _
                                                       Array (_
                                                              cRegistryWarningWhenPresent, "AuthenticationLevel", "REG_DWORD", Null _
                                                             ), _
                                                       "HKLM\SOFTWARE\Classes\CLSID\{49BD2028-1523-11D1-AD79-00C04FD8FDFF}", _
                                                       Array (_
                                                              cRegistryInfo, "", "REG_SZ", "Microsoft WBEM UnSecured Apartment" _
                                                             ), _
                                                       "HKLM\SOFTWARE\Classes\AppID\{266C72E7-62E8-11D1-AD89-00C04FD8FDFF}", _
                                                       Array (_
                                                              cRegistryWarningWhenPresent, "AuthenticationLevel", "REG_DWORD", Null _
                                                             ), _
                                                       "HKLM\SOFTWARE\Classes\CLSID\{266C72E7-62E8-11D1-AD89-00C04FD8FDFF}", _
                                                       Array (_
                                                              cRegistryInfo, "", "REG_SZ", "Microsoft WBEM Active Scripting Event Consumer Provider" _
                                                             ), _
                                                       "HKLM\SOFTWARE\Classes\CLSID\{C49E32C6-BC8B-11D2-85D4-00105A1F8304}", _
                                                       Array (_
                                                              cRegistryInfo, "", "REG_SZ", "Windows Management Instrumentation Backup and Recovery", _
                                                              cRegistryError, "AppID", "REG_SZ", "{8BC3F05E-D86B-11D0-A075-00C04FB68820}", _
                                                              cRegistryError, "LocalService", "REG_SZ", "WINMGMT" _
                                                             ), _
                                                       "HKLM\SOFTWARE\Classes\WINMGMTS", _
                                                       Array (_
                                                              cRegistryInfo, "", "REG_SZ", "Wbem Scripting Object Path" _
                                                             ), _
                                                       "HKLM\SOFTWARE\Classes\WINMGMTS\CLSID", _
                                                       Array (_
                                                              cRegistryError, "", "REG_SZ", "{172BDDF8-CEEA-11D1-8B05-00600806D9B6}" _
                                                             ), _
                                                       "HKLM\SOFTWARE\Classes\WINMGMTS\CurVer", _
                                                       Array (_
                                                              cRegistryError, "", "REG_SZ", "WINMGMTS.1" _
                                                             ), _
                                                       "HKCR\WINMGMTS.1", _
                                                       Array (_
                                                              cRegistryInfo, "", "REG_SZ", "Wbem Object Path 1.0" _
                                                             ), _
                                                       "HKCR\WINMGMTS.1\CLSID", _
                                                       Array (_
                                                              cRegistryError, "", "REG_SZ", "{172BDDF8-CEEA-11D1-8B05-00600806D9B6}" _
                                                             ), _
                                                       "HKLM\SOFTWARE\Classes\CLSID\{172BDDF8-CEEA-11D1-8B05-00600806D9B6}\ProgID", _
                                                       Array (_
                                                              cRegistryError, "", "REG_SZ", "WINMGMTS.1" _
                                                             ), _
                                                       "HKLM\SOFTWARE\Classes\CLSID\{172BDDF8-CEEA-11D1-8B05-00600806D9B6}\VersionIndependentProgID", _
                                                       Array (_
                                                              cRegistryError, "", "REG_SZ", "WINMGMTS" _
                                                             ) _
                                                      )

                    arrayWMISystemConfigurationClasses = Array ("__CIMOMIdentification", "__ArbitratorConfiguration", " __ProviderHostQuotaConfiguration", "__CacheControl")

                    arrayWMIRepositoryFiles = Array(_
                                                    "Repository\FS", _
                                                    "INDEX.BTR", _
                                                    "INDEX.MAP", _
                                                    "OBJECTS.DATA", _
                                                    "OBJECTS.MAP" _
                                                   )

                    arrayWMIServiceKnownDependent = Array (_
                                                           "CcmExec", "SMS Agent Host", _
                                                           "6to4", "IPv6 Helper Service", _
                                                           "MSExchangeMGMT", "Exchange Management Service", _
                                                           "IIMFilter", "Live Communication Server Filter Service", _
                                                           "RtcSrv", "Live Communication Server User Service", _
                                                           "MngAgent", "SNA Mngagent Service", _
                                                           "ADSBuilder", "Automated Deployment Services (ADS) Deployment Agent", _
                                                           "ADSPXE", "Automated Deployment Services (ADS) PXE Service" _
                                                          )

                    arrayDCOMDefaultAccessPermission = Array ("BUILTIN\Administrators", _
                                                              "BUILTIN\Administrators", _
                                                              SE_DACL_PRESENT Or SE_SELF_RELATIVE, _
                                                              Array ("NT AUTHORITY\SELF", _
                                                                       ACCESS_ALLOWED_ACE_TYPE, _
                                                                       0, _
                                                                       DCOM_RIGHT_EXECUTE, _
                                                                     "NT AUTHORITY\SYSTEM", _
                                                                       ACCESS_ALLOWED_ACE_TYPE, _
                                                                       0, _
                                                                       DCOM_RIGHT_EXECUTE), _
                                                              Null _
                                                             )
           
                    arrayDCOMDefaultLaunchPermission = Array ("BUILTIN\Administrators", _
                                                              "BUILTIN\Administrators", _
                                                              SE_DACL_PRESENT Or SE_SELF_RELATIVE, _
                                                              Array ("BUILTIN\Administrators", _
                                                                        ACCESS_ALLOWED_ACE_TYPE, _
                                                                        0, _
                                                                        DCOM_RIGHT_EXECUTE, _
                                                                     "NT AUTHORITY\INTERACTIVE", _
                                                                        ACCESS_ALLOWED_ACE_TYPE, _
                                                                        0, _
                                                                        DCOM_RIGHT_EXECUTE, _
                                                                     "NT AUTHORITY\SYSTEM", _
                                                                        ACCESS_ALLOWED_ACE_TYPE, _
                                                                        0, _
                                                                        DCOM_RIGHT_EXECUTE), _
                                                              Null _
                                                             )
           
                    arrayDCOMMachineAccessRestriction = Null
           
                    arrayDCOMMachineLaunchRestriction = Null
           
                    arrayWMIDCOMAccessPermission = arrayDCOMDefaultAccessPermission 
                    arrayWMIDCOMLaunchPermission = Array ("BUILTIN\Administrators", _
                                                          "BUILTIN\Administrators", _
                                                          SE_DACL_PRESENT Or SE_SELF_RELATIVE, _
                                                          Array ("Everyone", _
                                                                    ACCESS_ALLOWED_ACE_TYPE, _
                                                                    0, _
                                                                    DCOM_RIGHT_EXECUTE), _
                                                          Null _
                                                         ) 
           
                    arrayWMIPSSDCOMAccessPermission = arrayDCOMDefaultAccessPermission 
                    arrayWMIPSSDCOMLaunchPermission = Array ("BUILTIN\Administrators", _
                                                             "BUILTIN\Administrators", _
                                                             SE_DACL_PRESENT Or SE_SELF_RELATIVE, _
                                                             Array ("BUILTIN\Administrators", _
                                                                       ACCESS_ALLOWED_ACE_TYPE, _
                                                                       0, _
                                                                       DCOM_RIGHT_EXECUTE, _
                                                                    "NT AUTHORITY\INTERACTIVE", _
                                                                       ACCESS_ALLOWED_ACE_TYPE, _
                                                                       0, _
                                                                       DCOM_RIGHT_EXECUTE, _
                                                                    "NT AUTHORITY\SYSTEM", _
                                                                       ACCESS_ALLOWED_ACE_TYPE, _
                                                                       0, _
                                                                       DCOM_RIGHT_EXECUTE, _
                                                                    "NT AUTHORITY\NETWORK SERVICE", _
                                                                       ACCESS_ALLOWED_ACE_TYPE, _
                                                                       0, _
                                                                       DCOM_RIGHT_EXECUTE, _
                                                                    "NT AUTHORITY\LOCAL SERVICE", _
                                                                       ACCESS_ALLOWED_ACE_TYPE, _
                                                                       0, _
                                                                       DCOM_RIGHT_EXECUTE), _
                                                             Null _
                                                            ) 

                    arrayWMIUnsecureApptDCOMAccessPermission = arrayDCOMDefaultAccessPermission 
                    arrayWMIUnsecureApptDCOMLaunchPermission = arrayDCOMDefaultLaunchPermission 

                    arrayWMIActiveScriptEventConsDCOMAccessPermission = arrayDCOMDefaultAccessPermission 
                    arrayWMIActiveScriptEventConsDCOMLaunchPermission = arrayDCOMDefaultLaunchPermission 

                    arrayWMIDefaultNameSpaceSecurity = Array ("BUILTIN\Administrators", _
                                                              "BUILTIN\Administrators", _
                                                               SE_DACL_PRESENT Or SE_SELF_RELATIVE, _
                                                               Array ("BUILTIN\Administrators", _
                                                                         ACCESS_ALLOWED_ACE_TYPE, _
                                                                         CONTAINER_INHERIT_ACE Or INHERITED_ACE, _
                                                                         WBEM_ENABLE Or _
                                                                           WBEM_METHOD_EXECUTE Or _
                                                                           WBEM_FULL_WRITE_REP Or _
                                                                           WBEM_PARTIAL_WRITE_REP Or _
                                                                           WBEM_WRITE_PROVIDER Or _
                                                                           WBEM_REMOTE_ACCESS Or _
                                                                           WBEM_WRITE_DAC Or _
                                                                           WBEM_READ_CONTROL, _
                                                                      "NT AUTHORITY\NETWORK SERVICE", _
                                                                         ACCESS_ALLOWED_ACE_TYPE, _
                                                                         CONTAINER_INHERIT_ACE Or INHERITED_ACE, _
                                                                         WBEM_ENABLE Or _
                                                                           WBEM_METHOD_EXECUTE Or _
                                                                           WBEM_WRITE_PROVIDER, _
                                                                      "NT AUTHORITY\LOCAL SERVICE", _
                                                                         ACCESS_ALLOWED_ACE_TYPE, _
                                                                         CONTAINER_INHERIT_ACE Or INHERITED_ACE, _
                                                                         WBEM_ENABLE Or _
                                                                           WBEM_METHOD_EXECUTE Or _
                                                                           WBEM_WRITE_PROVIDER, _
                                                                      "Everyone", _
                                                                         ACCESS_ALLOWED_ACE_TYPE, _
                                                                         CONTAINER_INHERIT_ACE Or INHERITED_ACE, _
                                                                         WBEM_ENABLE Or _
                                                                           WBEM_METHOD_EXECUTE Or _
                                                                           WBEM_WRITE_PROVIDER), _
                                                               Null _
                                                              )
           
                    arrayWMINameSpaceSecurity = Array ("ROOT", _
                                                       arrayWMIDefaultNameSpaceSecurity, _
                                                       "ROOT/SECURITY", _
                                                       arrayWMIDefaultNameSpaceSecurity, _
                                                       "ROOT/CLI", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/ASPNET", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/SNMP", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/SNMP/LOCALHOST", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/SECURITYCENTER", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/WMI", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/CIMV2", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/CIMV2/APPLICATIONS", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/CIMV2/APPLICATIONS/MICROSOFTIE", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/POLICY", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/MICROSOFT", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/MICROSOFT/HOMENET", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/DEFAULT", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/DIRECTORY", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/DIRECTORY/LDAP", _
                                                       arrayWMIDefaultNameSpaceSecurity, _  
                                                       "ROOT/SUBSCRIPTION", _
                                                       arrayWMIDefaultNameSpaceSecurity, _
                                                       "Root/RSOP", _
                                                       Array ("BUILTIN\Administrators", _
                                                              "BUILTIN\Administrators", _
                                                               SE_DACL_PRESENT Or SE_SELF_RELATIVE, _
                                                               Array ("BUILTIN\Administrators", _
                                                                         ACCESS_ALLOWED_ACE_TYPE, _
                                                                         CONTAINER_INHERIT_ACE Or INHERITED_ACE, _
                                                                         WBEM_ENABLE Or _
                                                                           WBEM_METHOD_EXECUTE Or _
                                                                           WBEM_FULL_WRITE_REP Or _
                                                                           WBEM_PARTIAL_WRITE_REP Or _
                                                                           WBEM_WRITE_PROVIDER Or _
                                                                           WBEM_REMOTE_ACCESS Or _
                                                                           WBEM_WRITE_DAC Or _
                                                                           WBEM_READ_CONTROL, _
                                                                      "NT AUTHORITY\SYSTEM", _
                               